package teSummaryConfiguration;
use Getopt::Long;
use strict;
use teSummaryHELP;

sub init
{
    my $conf = shift;
    my $MAX_COL_WIDTH_TEDB = 50;

    my $DEFAULT_TEDB_JSON_FILEHANDLE = "tedb_info.json";

    GetOptions(
        'debug'               => \$conf->{debug},
        'help|h'              => \$conf->{help},
        'traces'              => \$conf->{traces},
        'xmlfile|xml=s'       => \$conf->{xmlfile},
        'file|f=s'            => \$conf->{file},
        'html=s'              => \$conf->{html},
        'csv'                 => \$conf->{csv},
        'period=s'            => \$conf->{period},
        'printrop'            => \$conf->{printrop},
        'silent'              => \$conf->{silent},
        'noconcat'            => \$conf->{noconcat},
        'noueStat'            => \$conf->{noueStat},
        'noueRackTables'      => \$conf->{noueRackTables},
        'notransitionAttempt' => \$conf->{notransitionAttempt},
        'eJSON'               => \$conf->{eJSON},                  ## Option added to extend JSON files to contain all data from the run for each rop, even if it's zero.
        'midPoint'            => \$conf->{midPoint},               ## Will put the datapoints in the middle of the periods in the HTML graphs
        'completeROPs'        => \$conf->{completeROPs},           ## Option to show only complete ROPS will remove first and last ROP period if specified.

        'noueConfigTables' => \$conf->{noueConfigTables},
        'max=s'            => \$conf->{max},
        'config|c=s'       => \$conf->{config},


        'imsi=s'  => \$conf->{filterImsi},
        'eimsi=s' => \$conf->{excludeImsi},
        'cell=s'  => \$conf->{filterCell},
        'ecell=s' => \$conf->{excludeCell},
        'or' => \$conf->{filter_or},

        'start|s=s' => \$conf->{filterStartTime},
        'end=s'     => \$conf->{filterEndTime},

        'diff=s'      => \$conf->{diff},
        'nodiff'      => \$conf->{nodiff},
        'onlydiff'    => \$conf->{onlydiff},
        'diffstore=s' => \$conf->{diffstore},
        'difffiles=s' => \$conf->{difffiles},
        'outfile|o=s' => \$conf->{outfile},
        'rop|r'       => \$conf->{rop},

        'force'      => \$conf->{force},
        'perimeisv'    => \$conf->{perimeisv},
        'perimsi'    => \$conf->{perimsi},
        'pertmsi'    => \$conf->{pertmsi},
        'perueref'   => \$conf->{perueref},

        'nodename=s'   => \$conf->{nodename},
        'cv=s'   => \$conf->{cv},
        'comment=s'    => \$conf->{comment},

        '3gsim=s'          => \$conf->{trafficFile},        # not implemented
        'color'          => \$conf->{color},         # not in use, keep it to avoid warnings since it used by other tools.
        'fixing_logs'  => \$conf->{fixing_logs},    # not in use, keep it to avoid warnings since it used by other tools.
        'noconvert'  => \$conf->{noconvert},    # not in use, keep it to avoid warnings since it used by other tools.
        'extended|e' => \$conf->{extended},     # not in use, keep it to avoid warnings since it used by other tools.

        'table=s'    => \$conf->{table},
        'etable=s'   => \$conf->{etable},
        'type=s'     => \$conf->{type},
        'etype=s'    => \$conf->{etype},

        'eventsupport|es'    => \$conf->{eventSupport},

        # TESummary DB options:
        'teDB'        => \$conf->{tedb},            #flag that tells if we want tedb logging
        'stp=s'        => \$conf->{stp},
        'node=s'    => \$conf->{node},
        'runType=s'    => \$conf->{runtype},
        'sw=s'        => \$conf->{swpackage},
        'start_time=s' => \$conf->{tedb_startTime},
        'tedb_log|tl=s' => \$conf->{tedb_logfile},
        'testcase|tc=s' => \$conf->{testcase},
        'teststep|ts=s' => \$conf->{teststep}

    );

    if ( defined $conf->{period} ) {
        my $period = $conf->{period};
        unless ( ( $period >= 1 && $period <=60 ) || ( $period <= 1440 && $period%60 == 0 ) ) {
            print "ERROR: $period is not a vaild value for period. Period must be 1-60 or <=1440 and divisible with 60! Exiting...\n";
            exit;
        }
    }

    if ( defined $conf->{eJSON} && !defined $conf->{html} ){
        print "Warning: -eJSON requires the use of the -html option\n";
    }

    if ( defined $conf->{eJSON} && defined $conf->{midPoint} ){
        print "Warning: Not possible to use the -eJSON option with -midPoint option... -midPoint will be ignored\n";
        $conf->{midPoint} = undef;
    }

    if ( defined $conf->{filter_or} && !(defined $conf->{filterImsi} && defined $conf->{filterCell}) ){
        print "option -or require options -imsi and -cell\n";
        exit;
    }

    if ( defined $conf->{filterStartTime} && $conf->{filterStartTime} =~ /^(\d{4}\-\d{2}\-\d{2})\.(\d{2}:\d{2}:\d{2})$/ )
    {
        $conf->{filterStartTime} = $1 . ' ' . $2;
    }
    if ( defined $conf->{filterEndTime} && $conf->{filterEndTime} =~ /^(\d{4}\-\d{2}\-\d{2})\.(\d{2}:\d{2}:\d{2})$/ )
    {
        $conf->{filterEndTime} = $1 . ' ' . $2;
    }
    $conf->{comment}  = "" if !defined $conf->{comment};
    $conf->{nodename} = "" if !defined $conf->{nodename};
    $conf->{version}  = '3.0';
    $conf->{perlversion} = $];
    $conf->{duration} = "";
    $conf->{cv}       = "" if !defined $conf->{cv};
    @{ $conf->{modules} }  = ();
    @{ $conf->{modules2} } = ();
    teSummaryHELP::helpTextPrinter($conf);

    lookupTables::defineTables($conf);

    if ( $conf->{diff} )
    {
        use teSummaryDiff;
        teSummaryDiff::diff($conf);
    }
    if ( defined $conf->{diffstore} && !-d $conf->{diffstore} )
    {
        system("mkdir -p  $conf->{diffstore} ");
    }
    if ( !defined $conf->{xmlfile} )
    {
        if ( defined $conf->{flow} )
        {
            $conf->{xmlfile} = $conf->{BASE} . 'etc/teSummary_flow.xml';
        }
        elsif ( defined $conf->{lite} )
        {
            $conf->{xmlfile} = $conf->{BASE} . 'etc/teSummary_lite.xml';
        }
        else
        {
            $conf->{xmlfile} = $conf->{BASE} . 'etc/teSummary.xml';
        }
    }
    if ( !defined $conf->{max} )
    {
        $conf->{max} = 100;
    }
    if ( defined $conf->{filterStartTime} || defined $conf->{filterEndTime} )
    {
        push( @{ $conf->{modules} }, { modulename => "timeFilter", obj => undef } );
    }
    if (   defined $conf->{filterImsi}
        || defined $conf->{excludeImsi}
        || defined $conf->{filterCell}
        || defined $conf->{excludeCell} )
    {
        push( @{ $conf->{modules} }, { modulename => "attribFilter", obj => undef } );
    }
    if ( defined $conf->{config} )
    {
        if ( !defined $conf->{noueRackTables} )
        {
            push( @{ $conf->{modules} }, { modulename => "ueRackTables", obj => undef } );
        }
        if ( !defined $conf->{noueConfigTables} )
        {
            push( @{ $conf->{modules} }, { modulename => "ueConfigTables", obj => undef } );
        }
    }
    if ( !defined $conf->{noueStat} )
    {
        push( @{ $conf->{modules} }, { modulename => "ueStat", obj => undef } );
    }
    if ( !defined $conf->{notransitionAttempt} )
    {
        push( @{ $conf->{modules} }, { modulename => "transitionAttempt", obj => undef } );
    }
    if (defined $conf->{tedb}){
        eval{
            require "DBI.pm";
            DBI->import();
            1;
        } or do {
            warn "Warning: tedb printer unable to load DBI module.  Please ensure the module is available and compatible with currently running version of Perl or try another version of Perl.\nContinuing with tedb printer turned off.  No data will be stored in the database\n";
            $conf->{tedb} = undef;
        };

        eval{
            require HTTP::Request;
            HTTP::Request->import();
            1;
        } or do {
            warn "Warning: tedb printer was unable to load HTTP::Request module.  Please ensure the module is available and compatible with currently running version of Perl or try another version of Perl.\nContinuing with tedb printer turned off.  No data will be stored in the database\n";
            $conf->{tedb} = undef;
        };

        if (!defined $conf->{stp} || !defined $conf->{node} || !defined $conf->{runtype} || !defined $conf->{swpackage}){
            die "Error: When running with --teDB option, --stp, --node, --runtype, and --sw must also be defined\n";
        }
        elsif(defined $conf->{tedb_startTime} && $conf->{tedb_startTime} =~ /^(\d{4}-\d{2}-\d{2})\.(\d{2}:\d{2}:\d{2})/){
            my $tempDate= $1 . " " . $2 . ".000";
            $conf->{tedb_startTime} = $tempDate;
        }
        elsif(defined $conf->{tedb_startTime} && $conf->{tedb_startTime} =~ /^(\d{2})(\d{2})(\d{2})_(\d{2})(\d{2})(\d{2})/){
            my $tempDate= "20". $1 . "-" . $2 . "-" . $3 . " " . $4 . ":" . $5 . ":" . $6 . ".000";
            $conf->{tedb_startTime} = $tempDate;
        }
        elsif(defined $conf->{tedb_startTime} && $conf->{tedb_startTime} =~ /^(\d{2})(\d{2})(\d{2})(\d{2})(\d{2})(\d{2})/){
            my $tempDate= "20". $1 . "-" . $2 . "-" . $3 . " " . $4 . ":" . $5 . ":" . $6 . ".000";
            $conf->{tedb_startTime} = $tempDate;
        }
        if (defined $conf->{testcase}){
            $conf->{testcase}= &checkAndTruncField($conf->{testcase}, $MAX_COL_WIDTH_TEDB);
        }
        if (defined $conf->{teststep}){
            $conf->{teststep}=&checkAndTruncField($conf->{teststep}, $MAX_COL_WIDTH_TEDB);
        }
    }

    $conf->{tedbjsonfilehandle}= $DEFAULT_TEDB_JSON_FILEHANDLE;

    if ( defined $conf->{html} )
    {
        $conf->{html} =~ s/\.html$//;
        $conf->{html} .= '/';

        if ( !defined $conf->{force} && -e $conf->{html} )
        {
            print "html directory $conf->{html} already exist!\n";
            exit;
        }

        $conf->{flotpath}   = $conf->{html} . '/dataseries/';
        $conf->{imagespath} = $conf->{html} . '/images/';
        if ( !-d $conf->{flotpath} )
        {
            system("mkdir -p  $conf->{flotpath} ");
        }
        if ( !-d $conf->{imagespath} )
        {
            system("mkdir -p  $conf->{imagespath} ");
        }
        push( @{ $conf->{modules} }, { modulename => "lostTraces", obj => undef } );

        $conf->{fileToCopy} = {

            'eGraphs.js'                => $conf->{BASE} . 'www/' . 'eGraphs.js',
            'config.js'                 => $conf->{BASE} . 'etc/' . 'config.js',
            'jquery-1.10.2.js'          => $conf->{BASE} . 'www/' . 'jquery-1.10.2.js',
            'jquery.flot.js'            => $conf->{BASE} . 'www/' . 'jquery.flot.js',
            'jquery.flot.selection.js'  => $conf->{BASE} . 'www/' . 'jquery.flot.selection.js',
            'jquery.tablesorter.js'     => $conf->{BASE} . 'www/' . 'jquery.tablesorter.js',
#           'jquery.flot.orderBars.js'  => $conf->{BASE} . 'www/' . 'jquery.flot.orderBars.js',
            'jquery.flot.time.js'       => $conf->{BASE} . 'www/' . 'jquery.flot.time.js',
            'jquery.flot.symbol.js'     => $conf->{BASE} . 'www/' . 'jquery.flot.symbol.js',
            'jquery.flot.resize.js'     => $conf->{BASE} . 'www/' . 'jquery.flot.resize.js',
            'jquery.flot.tooltip.min.js'=> $conf->{BASE} . 'www/' . 'jquery.flot.tooltip.min.js',
            'utilities.js'              => $conf->{BASE} . 'www/' . 'utilities.js',

            'license.txt'              => $conf->{BASE} . 'www/' . 'license.txt',
            'page_header_fade.jpg'     => $conf->{BASE} . 'www/images/' . 'page_header_fade.jpg',
            'ericsson_logo.gif'        => $conf->{BASE} . 'www/images/' . 'ericsson_logo.gif',
            'style.css'                => $conf->{BASE} . 'www/' . 'style.css',
            'newStyle.css'             => $conf->{BASE} . 'www/' . 'newStyle.css',

            'error1_16x16.png' => $conf->{BASE} . 'www/images/' . 'error1_16x16.png',
            'redtriangle.png'  => $conf->{BASE} . 'www/images/' . 'redtriangle.png',
            'warn1_16x16.png'  => $conf->{BASE} . 'www/images/' . 'warn1_16x16.png',
            'warn2_16x16.png'  => $conf->{BASE} . 'www/images/' . 'warn2_16x16.png',
            'x.png'            => $conf->{BASE} . 'www/images/' . 'x.png',
        };

        while ( my ( $filename, $path ) = each %{ $conf->{fileToCopy} } )
        {
            my $toPath = $conf->{html};
            if ( $filename =~ /\.(png|gif|jpg)$/ )
            {
                $toPath = $conf->{imagespath};
            }
            if ( -e $path )
            {
                copy( $conf, $path, $toPath . $filename );
            }
            else
            {
                print "not possible to copy $filename, ($path)\n";
            }
        }
        if ( defined $conf->{tedb} )
        {
            $conf->{tedbjsonfilehandle}="$conf->{html}"."$DEFAULT_TEDB_JSON_FILEHANDLE";        #put json file in html root if it exists
            $conf->{rop} = "1";
        }
        system("chmod 777 -R $conf->{html}");
    }
    print "loaded modules: ( ";
    foreach my $module ( @{ $conf->{modules} } )
    {
        print $module->{modulename} . " ";
    }
    print ")\n";
    print "debug mode\n" if defined $conf->{debug};



    #if ( defined $conf->{rrs} )
    #{
        ## initialize the soap object and save it in $conf

    #    my $url = "http://ki72fjw-test.rnd.ki.sw.ericsson.se:8001/rrs/SOAP"; # <---- SPECIFY THE ADDRESS TO THE SOAP SERVER

        #my $url = "http://esekilxxen1115.rnd.ericsson.se:50000/rrs/SOAP";
    #    my $url = "http://ki72fjw-test.rnd.ki.sw.ericsson.se:8001/newrrs/rrs/SOAP";

    #    my $url = "http://esekilxxen1113.rnd.ericsson.se:8081/rrs/SOAP"; <-- wenqings server, dont use

    #    my $soap = SOAP::Lite
    #        ->proxy("$url/rrpservernat.php?type=rpc",timeout => 20)
    #        ->encoding('ISO-8859-1')
    #        ->on_fault( sub {
    #                    print "Could not connect to RRS server!\n";
    #                    return;
    #                } );
    #
    #    $conf->{RRSsession}->{soap}=$soap;
    #}
}

sub checkAndTruncField
{
    my $inputString = shift;
    my $limit = shift;
    if (length($inputString) > $limit){
        #Truncate after the first $limit characters
        warn("***WARNING***:\n",
        "command-line argument \"$inputString\" is longer than the defined limit of $limit characters.\n",
        "It has been auto-truncated to fit within the limit.\n");
        return substr($inputString, 0, $limit);
    } else {
        return $inputString;
    }
}

sub copy
{
    my $conf = shift;
    my $from = shift;
    my $to   = shift;
    print "cp $from $to\n" if ( defined $conf->{debug} );
    my $res = `cp $from $to`;
    print "res: $res\n" if ( defined $conf->{debug} );
}

1;
