﻿#!/usr/bin/perl 
######################################################################################
#                                                                                    #
# © Ericsson AB 2001-2024    - All Rights Reserved                                   #
#                                                                                    #
# The copyright to the computer program(s) herein is the property   of Ericsson AB,  #
# Sweden. The programs may be used and/or copied only with the written permission    #
# from Ericsson AB or in accordance with the terms and  conditions stipulated in the #
# agreement/contract under which the program(s) have been supplied.                  #
#                                                                                    #
######################################################################################

use strict;
use Getopt::Long;
use Time::Local;

sub printUsage {

	if (@_) {print STDERR "@_\n";};
	die <<_EOTXT_;

time_convert : Convert log files to required timezones.

usage: time_convert [options] [<file1> [<file2...] ]
Options:

    -z
           Output time as local time - otherwise time will be shown in UTC.
           (make sure environment variable TZ is set)
	   
    -tz <timezone>
           Specify timezone other than the one in which this machine is located
	   eg. -tz +10 means 10 hours ahead of UTC  and -tz -10 means 10 hours behind UTC.
    
    -c     
	   To specify that the logs are being generated in CSV format.

_EOTXT_

}

my ($local_time, $tz, $CSV, $help);
my ($yy,$mo,$dd,$hh,$mi,$ss,$timestamp,@date_time,@date,@time,$us,@sec);
my $toTZ = "UTC";
my $header = "UTC";
my $toCSV = 0;

GetOptions(
	"z"        => \$local_time,
	"tz=f"     => \$tz,
	"c"        => \$CSV,
	"help"     => \$help
) or printUsage("Invalid Options");

printUsage if ($help);
if ($local_time) { $toTZ = "local" ; $header = sprintf("%-9s"," (LOCAL)")}
if ($CSV) { $toCSV = 1; }
if ($tz) { $toTZ="$tz" ;$header = sprintf("%-9s"," (UTC$tz)")}

while (<>) {

	if ($_ =~ /^(Event Time : )?[1-2][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9][ ;][0-9][0-9]:[0-9][0-9]:[0-9][0-9]([.][0-9]+)?[ ;]/)
	{
		my $pref = "";
		if ($_ =~ /^Event Time : /)
		{
			s/^Event Time : //;
			$pref = "Event Time : ";
		}
		my @date_time = split(/[ ;]/, $_);
		my @date = split('-',$date_time[0]) ;
		$yy=$date[0]; $mo=$date[1]; $dd=$date[2];
		my @time = split(':',$date_time[1]) ;
		$hh=$time[0]; $mi=$time[1]; 
		my @sec = split(/[.]/, $time[2]);
		$ss=$sec[0]; $us="";
		if ($sec[1] != "") { $us=".$sec[1]" ; } 
		if ($tz) {($ss,$mi,$hh,$dd,$mo,$yy) = gmtime(timegm($ss,$mi,$hh,$dd,$mo-1,$yy-1900)+($tz*3600));}
		else {($ss,$mi,$hh,$dd,$mo,$yy) = localtime(timegm($ss,$mi,$hh,$dd,$mo-1,$yy-1900));}
		$yy+=1900;
		$mo++;
		if ($toCSV == 1) 
		{ 
			$timestamp = sprintf("%04d-%02d-%02d;%02d:%02d:%02d%s", ($yy,$mo,$dd,$hh,$mi,$ss,$us)); 
			s/^[1-2][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9][ ;][0-9][0-9]:[0-9][0-9]:[0-9][0-9]([.][0-9]+)?[ ;]/$timestamp;/;
		}
		else 
		{ 
			$timestamp = sprintf("%04d-%02d-%02d %02d:%02d:%02d%s", ($yy,$mo,$dd,$hh,$mi,$ss,$us)); 
			s/^[1-2][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9][ ;][0-9][0-9]:[0-9][0-9]:[0-9][0-9]([.][0-9]+)?[ ;]/$timestamp /;
		}
		if ($pref =~ /^Event/) { $_ = $pref . $_ ;}
		print; 
	}
	elsif ($_ =~ /^Timestamp \(UTC\)   /) { s/^Timestamp \(UTC\)   /Timestamp$header/ ; print}
	elsif ($_ =~ /^Date . Time \(UTC\)   /) { s/^Date . Time \(UTC\)   /Date & Time$header/ ; print}
	else { print }
}
