#include <stdio.h>
#include <sys/param.h>
#if (RDSIGNAL & hpux)
#define signal sigset
#endif
#ifdef GCC_490
#define SYSTEM5
#endif
#ifdef _OSF_SOURCE
#define AIX
#endif
#ifdef AIX
#define SYSTEM5
#endif
#ifdef BSD42
#define memcpy(a,b,c) bcopy(b,a,c)
#define memset(a,b,c) bzero(a,c)
#define strchr index
#define strrchr rindex
#endif
#ifdef USING_PPL
#define NO_BACKUP
#endif
#ifndef SYSTEM5
#define getcwd(a,b) getwd(a)
#define getcwd getwd
#endif
#define MAX_FILENAME 255
#define SUCCESS 0
#define FAIL -1
#define YES 1
#define NO 0
#define TRUE 1
#define FALSE 0
#ifdef MSB
#undef MSB
#endif
#define MSB(x) (((x) >> 8) & 0xff)
#define LSB(x) ((x) & 0xff)
typedef unsigned char BYTE;
typedef unsigned short WORD;
typedef unsigned long ULONG;
typedef long LONG;
typedef unsigned char BOOL;
struct date_time {
BYTE day;
BYTE month;
BYTE year;
BYTE second;
BYTE minute;
BYTE hour;
};
#define DATE_TIME_SIZE 6
#define MAX_USR_DATA (2048+sizeof(long))
#define X_INACTIVE (1<<0)
#define X_SEND_DELV (1<<1)
#define X_DEL_ANS_SEND (1<<2)
#define X_DEL_A_ANS_SEND (1<<3)
#define X_SEND (1<<4)
#define X_RECV (1<<5)
#define X_RECV_A (1<<6)
#define X_EOF (1<<7)
#define X_PENDING (1<<8)
#define X_EXIT (1<<9)
#define X_ABORT (1<<10)
#define X_EOT (1<<11)
#define X_DIR_EOT (1<<12)
#define X_SEND_ATT (1<<13)
#define X_BKUP_START (1<<14)
#define X_BKUP (1<<15)
#define X_RST_START (1<<16)
#define X_RST (1<<17)
#define X_EOF_RST (1<<18)
#define X_EOT_RST (1<<19)
#define X_SEND_DIR (1<<20)
#define X_SEND_DIR_INFO (1<<21)
#define X_DIR_EOF (1<<22)
#define X_DIR_CONTINUE (1<<23)
#define X_LAST_STATE 24
enum xfer_return_type {
xfer_success,
xfer_eof,
xfer_no_memory,
xfer_improper_state,
xfer_rms_error,
xfer_failure,
xfer_nofile,
xfer_bad_packet
};
struct unix_record {
BYTE unix_rec_type;
BYTE unix_ret_code;
WORD unix_data_len;
WORD unix_pass_back;
BYTE unix_usr_data[MAX_USR_DATA];
};
#define UX_REC_OVHD 6
#define UX_REC_LEN (UX_REC_OVHD+MAX_USR_DATA)
struct xfer_context_block {
BYTE xfer_token;
ULONG xfer_state;
WORD xfer_type;
struct unix_record *read_buffer;
WORD read_length;
struct unix_record *write_buffer;
WORD write_length;
struct unix_record *ack_buffer;
WORD ack_length;
BOOL read_ready;
int sys_status;
BYTE compression_type;
ULONG disposition;
char *attr_buffer;
char *attr_pointer;
BYTE directory_info;
int directory_offset;
WORD directory_flag;
};
#define MESS_CONT 3
#define VERS_CHECK 0
#define VERS_REPLY 1
#define DEATH 2
#define TOUSER_DATA 3
#define FROMUSER_DATA 4
#define ACK_USER_DATA 5
#define HIPRI_DATA 8
#define DEFAULT_FILESPEC "*"
#include <errno.h>
extern int errno;
int dekermitize();
void set_kermit(), adj_kermit();
extern WORD crctab[];
#define docrc(old, c) (old = ((old<<8) ^ crctab[((old>>8)^c) & 0xff])&0xffff)
extern BYTE should_kermit[];
BYTE _kermitize();
#define NO_ERROR 1
#define ERROR 0
#define QUIT_NORMAL 0
#define QUIT_SHUTDOWN 1
#define QUIT_READ_TTY 2
#define QUIT_WRITE_TTY 3
#define QUIT_TIMEOUT 5
#define QUIT_MSGQ 6
#define QUIT_HANGUP_TTY 7
#define QUIT_INTERRUPT_TTY 8
#define QUIT_RETRY_MAX 9
#define QUIT_REXMIT_MAX 10
#define QUIT_PROTOCOL 11
#define TERMINATOR '\n'
#define TTY_TYPE 0
#define MSGQ_TYPE 1
#define TIMEOUT_TYPE 2
#define MAX_FR_SIZE 256
#define MIN_FR_SIZE 20
#define MAX_MSG (2048+sizeof(long)+UX_REC_OVHD)
#define MAX_FR_ADJUST 12
#define VAL_MAX_FR (MAX_FR_SIZE - MAX_FR_ADJUST)
struct childmsg
{
long id;
char msg[1];
};
struct framemsg
{
BYTE id;
BYTE msg[MAX_FR_SIZE-1];
};
struct dataframemsg
{
BYTE id;
BYTE phdr;
BYTE msg[MAX_FR_SIZE-2];
};
typedef struct framemsg Frame;
typedef struct dataframemsg Dataframe;
extern int GetFrame();
extern unsigned char *GetMsgq();
extern char start_char, end_char;
extern int read_timer;
#include <setjmp.h>
#include <signal.h>
#define START_CHAR '('
#define END_CHAR ')'
#define USER_D_IN ">USER DATA"
#define USER_D_OUT "<USER DATA"
#define CTRL_D_IN ">CTRL DATA"
#define CTRL_D_OUT "<CTRL DATA"
#define CTRL_IN ">CTRL"
#define CTRL_OUT "<CTRL"
#define TIME_OUT "TIMEOUT"
#define BAD_FRAME_IN ">BAD FRAME"
#define WEAK_KERMIT 0
#define STRONG_KERMIT 1
extern BOOL pend_rej, send_ctl, pend_ctl, pend_ans, pend_err, pend_close,
send_cr, Abort;
#ifdef USING_PPL
#define MAX_CIRCUITS 4
#else
#define MAX_CIRCUITS 2
#endif
#define XFER_CIRC 0
#define FIRST_AVAIL_CIRCUIT 1
#define INITIAL_CRDTS 8
#define OUTST_ACKS 8
#define OUTST_VERSION 1
#define OUTST_HIPRI 1
#define VERS_SIZE_REPLY 2
#define MAX_HI_PRI 8
struct _circuit
{
int son_pid;
BYTE store_buff[INITIAL_CRDTS][MAX_FR_SIZE];
int store_len[INITIAL_CRDTS];
int first_stored;
int num_stored;
int next_avail;
BYTE a_store_buff[OUTST_ACKS][UX_REC_OVHD];
int a_first_stored;
int a_num_stored;
int a_next_avail;
BYTE v_store_buff[UX_REC_OVHD+VERS_SIZE_REPLY];
int v_num_stored;
BYTE h_buff_store[UX_REC_OVHD+MAX_HI_PRI];
int h_store_len;
int h_num_stored;
};
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
enum xfer_return_type xfer__initialize ();
enum xfer_return_type xfer__shutdown ();
enum xfer_return_type xfer__read_record ();
enum xfer_return_type xfer__write_record ();
enum xfer_return_type xfer__ack();
void send_rr();
void send_unn_ack();
void get_pkt_hdr();
void proc_2_data();
void proc_3_data();
void proc_data_frame();
void process_data();
void close_circ();
void proc_pkt_hdr();
void load_xmit();
void check_ack();
#define READ_TIMEOUT 30
#define SHORT_TIMEOUT 4
#define MAX_RETRIES 5
#define MAX_REXMITS 10
#define MAX_SEQ 7
#define MIN_WINDOW 1
#define MAX_WINDOW MAX_SEQ
#define CIRCUIT_CHECK 2
#define I_FRAME 1
#define CTRL_FRAME 0
#define RR 3
#define RNR 2
#define REJ 1
#define I_FRAME_HDR 0x40
#define CTRL_HDR 0xC0
#define RR_FRAME_HDR 0x30
#define RNR_FRAME_HDR 0x20
#define REJ_FRAME_HDR 0x10
#define CONNECT_HDR 0x00
#define UNN_ACK 0x01
#define DISCONNECT_HDR 0x02
#define CTL_PKT 0xC
#define CTRL_D_2 0xD
#define CTRL_D_3 0xC
#define DATA_PACKET 0x40
#define CONFIG 0xD0
#define ANS_CONFIG 0xD2
#define OPEN_CIR 0xC0
#define ANSWER_OPEN 0xC2
#define CLOSE_CIR 0xC4
#define CIR_ERROR 0xC6
#define HI_PRI_PKT 0xC8
struct unix_record *s_buf_r[MAX_CIRCUITS];
struct unix_record *s_buf_w[MAX_CIRCUITS];
struct unix_record *s_buf_a[MAX_CIRCUITS];
BYTE read_buff[MAX_CIRCUITS][MAX_USR_DATA + UX_REC_OVHD];
BYTE write_buff[MAX_CIRCUITS][MAX_USR_DATA + UX_REC_OVHD];
BYTE ack_buff[MAX_CIRCUITS][UX_REC_OVHD];
static int try_xfer_circuit = 0;
struct _circuit circuit[MAX_CIRCUITS];
int max_fr_out = VAL_MAX_FR;
#define STRING_MAX 64
#define OPEN_ID 0
#define OPEN_CREDITS 1
#define OPEN_LEN 2
#define OPEN_STRING 3
#define OPEN_PARMS_SIZE (3+STRING_MAX+1)
typedef char OPEN_PRMS[OPEN_PARMS_SIZE];
OPEN_PRMS open_parms;
#define ANS_ID 0
#define ANS_CREDITS 1
#define ANS_STATUS 2
#define ANS_OPEN_PARMS_SIZE 3
typedef char ANS_PRMS[ANS_OPEN_PARMS_SIZE];
ANS_PRMS ans_open_parms;
#define ERROR_ID 0
#define ERROR_CODE 1
#define ERROR_PARMS_SIZE 2
typedef char ERR_PRMS[ERROR_PARMS_SIZE];
ERR_PRMS error_parms;
#define CLOSE_ID 0
#define CLOSE_PARMS_SIZE 1
typedef char CLOSE_PRMS[CLOSE_PARMS_SIZE];
CLOSE_PRMS close_parms;
#define HI_ID 0
#define HI_DATA_LEN 1
#define HI_DATA 2
#define HIPRI_PARMS_SIZE (2+MAX_HI_PRI)
typedef char HI_PRMS[HIPRI_PARMS_SIZE];
struct unix_record hipri_buf;
struct xfer_context_block *context_block;
#define MORE_DATA '!'
#define MAX_XTRA 64
#define MIN_CFG_LEN 8
unsigned short config_version, config_max_fr_len;
#define CFG_VERSION 0
#define CFG_MAX_FR_LEN 2
#define CFG_XFER_TYPE 4
#define CFG_WINDOW 5
#define CFG_START_C 6
#define CFG_END_C 7
#define CFG_NUM_XTRA_C 8
#define CFG_XTRA_C 9
#define MAX_CFG_LEN (9+MAX_XTRA)
typedef unsigned char CFG_PARMS[MAX_CFG_LEN];
#define UNIX_OS_NUMBER 3
#define MAJOR ((UNIX_OS_NUMBER << 5) | 3)
#define MINOR 3
#define BUILD 4
#ifdef USING_PPL
static char *ident="@(#) ppluhost.c WRQ Version 3.03";
#else
static char *ident="@(#) unxlink2.c WRQ Version 3.03";
#endif
#define UNIX_XFER_TYPE 'B'
#define UNIX_WINDOW 4
#define UNIX_START_C 2
#define UNIX_END_C 3
#define UNIX_NUM_XTRA_C 7
CFG_PARMS conf_parms, ans_parms;
BYTE curr_cfg_type;
BYTE curr_ctl_type;
int r_prm_len = 0;
int c_prm_len = 0;
#define IDLE 0
#define ACTIVE 1
#define ABORTED 2
#define BLOCKED 3
char start_char = START_CHAR;
char end_char = END_CHAR;
BYTE static_pkt_hdr;
int quit_type = QUIT_NORMAL;
int rcv_seq;
int send_seq;
int last_ack;
int r_lst_ack;
int re_xmits;
int rexmit_count = 0;
int window = 1;
int retry_cnt = 0;
BOOL choke;
BOOL rmt_choke;
BOOL Abort;
BOOL resp_req = TRUE;
BOOL choke_pending = FALSE;
BOOL unnack_pending = FALSE;
BYTE frame_type;
BOOL pend_rej = FALSE;
BOOL pend_ctl = FALSE;
BOOL pend_ans = FALSE;
BOOL pend_err = FALSE;
BOOL pend_actl = FALSE;
BOOL pend_close = FALSE;
BOOL send_ctl = FALSE;
BOOL send_cr = FALSE;
BOOL pend_rr = FALSE;
unsigned nxt_cir = 0;
unsigned xmt_cir = 0;
BYTE *data_ptr;
unsigned data_len;
unsigned pend_data;
unsigned ack_data;
unsigned credit_ack;
BYTE ctl_hdr;
unsigned xmit_buff[MAX_SEQ + 1];
BYTE xmt_hdr[MAX_SEQ + 1];
BYTE *d_ptr[MAX_CIRCUITS];
unsigned da_len[MAX_CIRCUITS];
unsigned a_data[MAX_CIRCUITS];
unsigned p_data[MAX_CIRCUITS];
#define CLOSED 0
#define OPEN 1
#define PPL_SUCCESS ' '
#define PPL_NO_SUCCESS '!'
#define MAX_CRD_ADV 7
unsigned circuit_status[MAX_CIRCUITS];
unsigned credits[MAX_CIRCUITS];
unsigned pnd_credits[MAX_CIRCUITS];
unsigned rmt_credits[MAX_CIRCUITS];
unsigned user_msg_len[MAX_CIRCUITS];
int open_mode = 0644;
int read_timer = READ_TIMEOUT;
int rexmit_limit = MAX_REXMITS;
int retry_limit = MAX_RETRIES;
BOOL upper_case = FALSE;
BOOL no_show_root = FALSE;
char *home_directory;
#ifdef NO_MACROS
#define kermitize(b_buf,chr) b_buf += _kermitize(b_buf, chr)
#else
#define kermitize(b_buf,chr) \
{ \
if (should_kermit[chr]) \
{ \
if (chr == '#' || chr == '&') \
{ \
*b_buf++ = '#'; \
*b_buf++ = chr; \
} \
else if (chr > 0x7f) \
{ \
*b_buf++ = '&'; \
\
b_buf += _kermitize(b_buf, chr^0xc0); \
\
} \
else if (chr == 0x7f || chr < ' ' || chr==start_char || chr==end_char) \
{ \
*b_buf++ = '#'; \
*b_buf++ = chr ^ 0x40; \
} \
else \
*b_buf++ = chr; \
} \
else \
*b_buf++ = chr; \
}
#endif
main(argc, argv)
int argc;
char **argv;
{
int c;
extern int optind;
extern char *optarg;
char *getenv();
extern char currentFilespec[];
#ifdef UMASK
{
mode_t mymask;
mymask = umask(0);
if (mymask != 0)
open_mode = 0666;
(void)umask(mymask);
}
#endif
while ((c=getopt(argc, argv, "D:d:X:x:t:T:r:R:lLn:N:vVcChHSsM:m:")) != EOF)
switch (c)
{
case 'V':
case 'v':
#ifdef USING_PPL
printf("PPLUHOST Version %d.%02d.%02d\n",MAJOR&0x0f,MINOR,BUILD);
#else
printf("UNXLINK2 Version %d.%02d.%02d\n",MAJOR&0x0f,MINOR,BUILD);
#endif
exit(0);
case 'L':
case 'l':
OpenTrace();
break;
case 'T':
case 't':
read_timer = atoi(optarg);
break;
case 'X':
case 'x':
rexmit_limit = atoi(optarg);
break;
case 'N':
case 'n':
retry_limit = atoi(optarg);
break;
case 'M':
case 'm':
sscanf(optarg, "%o", &open_mode);
break;
case 'C':
case 'c':
upper_case++;
break;
case 'S':
case 's':
if ((home_directory = getenv("HOME")) != NULL)
no_show_root++;
break;
case 'H':
case 'h':
usage(argv[0]);
exit(1);
case '?':
default:
break;
}
fclose(stderr);
if (tty_open() == FAIL)
exit(1);
init_circuits();
strcpy(currentFilespec, DEFAULT_FILESPEC);
if (pconnect() == SUCCESS)
{
pend_ctl = TRUE;
decide_xmit();
converse_until_disconnect();
}
quit(quit_type);
}
reset_connection()
{
alarm(0);
retry_cnt = send_seq = rcv_seq = last_ack = r_lst_ack = re_xmits = 0;
rmt_choke = choke = FALSE;
resp_req = TRUE;
memset(xmit_buff, NULL, sizeof(xmit_buff));
ack_data = pend_data = 0;
}
pconnect()
{
int event;
Frame d_frame;
reset_connection();
while (retry_cnt++ < retry_limit)
{
d_frame.id = CONNECT_HDR;
WriteFrame(&d_frame,1);
read_again:
tty_block();
event = wait_event();
alarm(0);
tty_noblock();
switch(event)
{
case TTY_TYPE:
if (GetFrame(&d_frame) <= 0)
break;
if (d_frame.id == UNN_ACK)
return SUCCESS;
else if (d_frame.id == CONNECT_HDR)
{
send_unn_ack();
goto read_again;
}
break;
case TIMEOUT_TYPE:
default:
break;
}
}
return FAIL;
}
decide_xmit()
{
unsigned i;
if (Abort == TRUE)
{
return ABORTED;
}
if (pend_rej)
{
return (send_rej(), ACTIVE);
}
if (send_ctl)
{
return (send_data_frame());
}
if (send_cr)
{
return (send_credit_frame(xmt_cir));
}
if (calc_unacks() != 0)
{
return(send_it());
}
if (pend_ctl)
{
BYTE *b;
pend_ctl = FALSE;
send_ctl = TRUE;
pend_data = 0;
ctl_hdr = CONFIG;
data_ptr = (BYTE *)conf_parms;
b = (BYTE *) conf_parms;
put_word(&b, MINOR+(256*MAJOR));
put_word(&b, MAX_FR_SIZE);
put_byte(&b, UNIX_XFER_TYPE);
put_byte(&b, UNIX_WINDOW);
put_byte(&b, UNIX_START_C);
put_byte(&b, UNIX_END_C);
put_byte(&b, UNIX_NUM_XTRA_C);
put_byte(&b, 0);
put_byte(&b, 10);
put_byte(&b, 145);
put_byte(&b, 147);
put_byte(&b, 26);
put_byte(&b, 255);
put_byte(&b, 128);
data_len = UNIX_NUM_XTRA_C + MIN_CFG_LEN + 1;
return(send_data_frame());
}
if (pend_ans)
{
pend_ans = FALSE;
send_ctl = TRUE;
ctl_hdr = ANSWER_OPEN;
data_ptr = (BYTE *)ans_open_parms;
data_len = ANS_OPEN_PARMS_SIZE;
pend_data = 0;
return(send_data_frame());
}
if (pend_err)
{
pend_err = FALSE;
send_ctl = TRUE;
ctl_hdr = CIR_ERROR;
data_ptr = (BYTE *)error_parms;
data_len = ERROR_PARMS_SIZE;
pend_data = 0;
return(send_data_frame());
}
if (pend_close)
{
pend_close = FALSE;
send_ctl = TRUE;
ctl_hdr = CLOSE_CIR;
data_ptr = (BYTE *)close_parms;
data_len = CLOSE_PARMS_SIZE;
pend_data = 0;
return(send_data_frame());
}
for(i=0;i<MAX_CIRCUITS;i++)
{
nxt_cir++;
nxt_cir &= (MAX_CIRCUITS - 1);
if (choke_circ(nxt_cir))
{
if (d_ptr[nxt_cir] == 0)
{
return(send_credit_frame(nxt_cir));
}
else
{
if (d_ptr[xmt_cir] != 0)
{
p_data[xmt_cir] = pend_data;
a_data[xmt_cir] = ack_data;
}
xmt_cir = nxt_cir;
return(send_it());
}
}
}
if (d_ptr[xmt_cir] != 0 && rmt_credits[xmt_cir] != 0)
{
return(send_it());
}
for(i=0;i<MAX_CIRCUITS;i++)
{
nxt_cir++;
nxt_cir &= (MAX_CIRCUITS - 1);
if ((d_ptr[nxt_cir] != 0) && (rmt_credits[nxt_cir] != 0))
{
xmt_cir = nxt_cir;
return(send_it());
}
}
for (i=0; i<2; i++)
{
if (try_xfer_circuit)
{
try_xfer_circuit = 0;
if (circuit_status[nxt_cir = XFER_CIRC] == OPEN &&
context_block->read_ready && do_xfer_read() == NO_ERROR)
{
load_xmit();
return(send_it());
}
}
else
{
try_xfer_circuit = 1;
if (TryMsgq())
{
if (do_read() == NO_ERROR)
{
load_xmit();
return(send_it());
}
}
}
}
if (resp_req)
{
if (choke)
send_rnr();
else
{
send_rr();
}
}
return(IDLE);
}
converse_until_disconnect()
{
int nmsg, event, n, ckc = 0;
struct framemsg fmsg;
BOOL transmit;
struct _circuit *c;
int i;
BOOL failed;
while (1)
{
transmit = TRUE;
event = wait_event();
alarm(0);
tty_noblock();
if (ckc++ == CIRCUIT_CHECK)
{
ckc = 0;
check_circuits();
}
process_frame:
switch(event)
{
case TTY_TYPE:
if ((nmsg = GetFrame(&fmsg)) == FAIL)
{
WriteTrace(BAD_FRAME_IN);
retry_cnt++;
if (retry_cnt > retry_limit)
{
quit_type = QUIT_RETRY_MAX;
goto all_done;
}
}
else if (nmsg > 0)
{
retry_cnt = 0;
resp_req = TRUE;
if ((frame_type = fmsg.id >> 6) == I_FRAME)
{
proc_data_frame(&fmsg, nmsg);
}
else
{
if ((frame_type = fmsg.id >> 4) == RR)
{
rmt_choke = FALSE;
check_ack(fmsg.id & MAX_SEQ);
}
else if (frame_type == RNR)
{
rmt_choke = TRUE;
check_ack(fmsg.id & MAX_SEQ);
}
else if (frame_type == REJ)
{
re_xmits = calc_unacks();
check_ack(fmsg.id & MAX_SEQ);
}
else
{
if ((frame_type = fmsg.id) == UNN_ACK)
{
re_xmits = calc_unacks();
}
else if (frame_type == DISCONNECT_HDR)
{
unnack_pending = TRUE;
close_shop();
return;
}
else
{
WriteTrace(BAD_FRAME_IN);
retry_cnt++;
if (retry_cnt > retry_limit)
{
quit_type = QUIT_RETRY_MAX;
goto all_done;
}
}
}
}
}
n = nowait_event();
event = TTY_TYPE;
if (n != 0)
{
goto process_frame;
}
do_xmit:
if (transmit == TRUE)
{
if ((n = decide_xmit()) == ABORTED)
{
quit_type = QUIT_PROTOCOL;
goto all_done;
}
else if (n == IDLE)
{
tty_block();
}
}
if (rexmit_count > rexmit_limit)
{
quit_type = QUIT_REXMIT_MAX;
goto all_done;
}
if (!TryMsgq())
{
break;
}
case MSGQ_TYPE:
retry_cnt = 0;
try_xfer_circuit = 1;
if (do_read() == NO_ERROR)
{
load_xmit();
if ((n = send_it()) == ABORTED)
{
quit_type = QUIT_PROTOCOL;
goto all_done;
}
else if (n == IDLE)
{
tty_block();
}
}
break;
case TIMEOUT_TYPE:
WriteTrace(TIME_OUT);
retry_cnt++;
if (retry_cnt > retry_limit)
{
quit_type = QUIT_RETRY_MAX;
goto all_done;
}
transmit = TRUE;
resp_req = TRUE;
re_xmits = calc_unacks();
goto do_xmit;
default:
break;
}
}
all_done:
disconnect();
close_shop();
}
close_shop()
{
int i;
for (i=0; i < MAX_CIRCUITS; i++)
if (circuit_status[i] == OPEN)
close_circ(i);
}
send_disconnect()
{
BYTE b;
b = DISCONNECT_HDR;
WriteFrame(&b, 1);
}
disconnect()
{
read_timer = SHORT_TIMEOUT;
send_disconnect();
(void) wait_event();
alarm(0);
}
calc_credit()
{
return (window-((send_seq-last_ack)&MAX_SEQ));
}
quit(type)
int type;
{
int i;
if (unnack_pending == TRUE)
send_unn_ack();
if (type == QUIT_INTERRUPT_TTY)
send_disconnect();
if (type != QUIT_NORMAL)
sleep(1);
tty_close();
CloseDir();
for (i=0; i<MAX_CIRCUITS; i++)
kill_son(circuit[i].son_pid);
{
char *q;
switch(type)
{
case QUIT_NORMAL:
q = "QUIT NORMAL";
break;
case QUIT_SHUTDOWN:
q = "QUIT USER SHUTDOWN";
break;
case QUIT_READ_TTY:
q = "QUIT READ TTY";
break;
case QUIT_WRITE_TTY:
q = "QUIT WRITE_TTY";
break;
case QUIT_HANGUP_TTY:
q = "QUIT HANGUP_TTY";
break;
case QUIT_INTERRUPT_TTY:
q = "QUIT INTERRUPT_TTY";
break;
case QUIT_TIMEOUT:
q = "QUIT TIMEOUT";
break;
case QUIT_MSGQ:
q = "QUIT MSGQ";
break;
case QUIT_RETRY_MAX:
q = "QUIT RETRY_MAX";
break;
case QUIT_REXMIT_MAX:
q = "QUIT REXMIT_MAX";
break;
case QUIT_PROTOCOL:
q = "QUIT PROTOCOL FAILED";
break;
default:
q = "QUIT ???";
break;
}
WriteTrace(q);
}
CloseTrace();
exit(type);
}
start_son(cir, process)
int cir;
char *process;
{
if (cir == FAIL)
return FAIL;
else
{
if ((circuit[cir].son_pid = spawn_son(process)) == FAIL)
return (circuit[cir].son_pid = 0, FAIL);
return SUCCESS;
}
}
init_circuits()
{
quit_type = QUIT_NORMAL;
memset(circuit, NULL, sizeof(circuit));
}
void send_rr()
{
BYTE b;
b = RR_FRAME_HDR | rcv_seq;
r_lst_ack = rcv_seq;
WriteFrame(&b, 1);
resp_req = FALSE;
pend_rr = FALSE;
}
send_rej()
{
BYTE b;
tty_iflush();
b = REJ_FRAME_HDR | rcv_seq;
r_lst_ack = rcv_seq;
WriteFrame(&b, 1);
pend_rej = FALSE;
}
send_rnr()
{
BYTE b;
b = RNR_FRAME_HDR | rcv_seq;
r_lst_ack = rcv_seq;
WriteFrame(&b, 1);
resp_req = FALSE;
choke_pending = FALSE;
}
WriteFrame(frame, fr_len)
BYTE *frame;
int fr_len;
{
BYTE buffer[MAX_FR_SIZE+1], *bptr = buffer, *f;
int i;
WORD crc = 0;
*bptr++ = start_char;
for (f = frame, i = 0; i < fr_len; i++, f++)
{
kermitize(bptr, *f);
docrc(crc, *f);
}
bptr += _kermitize(bptr, MSB(crc));
bptr += _kermitize(bptr, LSB(crc));
*bptr++ = end_char;
tty_write(buffer, bptr - buffer);
WriteBTrace("< ", buffer, bptr - buffer);
resp_req = FALSE;
}
void send_unn_ack()
{
BYTE b = UNN_ACK;
WriteFrame(&b,1);
}
send_it()
{
pend_data = p_data[xmt_cir];
ack_data = a_data[xmt_cir];
data_len = da_len[xmt_cir];
data_ptr = d_ptr[xmt_cir];
return (send_data_frame());
}
choke_circ(circ_num)
unsigned circ_num;
{
return ((!credits[circ_num] && pnd_credits[circ_num]) ? TRUE : FALSE);
}
int send_data_frame()
{
BYTE pkt_hdr;
int ix;
int ret_code = IDLE;
if (rmt_choke)
{
consider_rr:
if (resp_req)
{
if (choke)
send_rnr();
else
{
send_rr();
}
}
return(ret_code);
}
if (re_xmits > 0)
goto re_xmit_data;
if (data_len == 0)
goto consider_rr;
if (calc_credit() != 0 && pend_data < data_len)
{
if (send_ctl)
{
pkt_hdr = ctl_hdr;
goto send_data;
}
if (rmt_credits[xmt_cir] == 0)
if (pnd_credits[xmt_cir] == 0)
goto consider_rr;
get_pkt_hdr(xmt_cir,&pkt_hdr);
send_data:
xmit_buff[send_seq] = pend_data;
xmt_hdr[send_seq] = pkt_hdr;
if (rmt_credits[xmt_cir] == 0 && send_ctl == FALSE)
write_data_frame(0,0,pkt_hdr);
else
pend_data += write_data_frame(data_ptr + pend_data,
data_len - pend_data,pkt_hdr);
xmit_buff[send_seq] = pend_data;
p_data[xmt_cir] = pend_data;
if (!send_ctl)
{
if (rmt_credits[xmt_cir] != 0)
rmt_credits[xmt_cir]--;
}
return(ACTIVE);
}
goto consider_rr;
re_xmit_data:
ix = (send_seq - re_xmits) & MAX_SEQ;
write_data_frame((data_ptr + xmit_buff[ix]),
(data_len - xmit_buff[ix]),xmt_hdr[ix]);
rexmit_count++;
return(ACTIVE);
}
int send_credit_frame(circ_num)
unsigned circ_num;
{
int ret_code = IDLE;
BYTE pkt_hdr;
if (rmt_choke)
{
if (resp_req)
{
if (choke)
send_rnr();
else
{
send_rr();
}
}
return(ret_code);
}
if (re_xmits > 0)
goto re_xmit_credit;
if (calc_unacks() != 0)
return IDLE;
if (calc_credit() != 0 )
{
send_cr = TRUE;
get_pkt_hdr(circ_num,&static_pkt_hdr);
re_xmit_credit:
pkt_hdr = static_pkt_hdr;
write_data_frame(0,0,pkt_hdr);
rexmit_count++;
credit_ack = send_seq;
return(ACTIVE);
}
return IDLE;
}
void get_pkt_hdr(x_cir,pkt_hdr)
unsigned x_cir;
BYTE *pkt_hdr;
{
*pkt_hdr = DATA_PACKET | x_cir;
if (pnd_credits[x_cir] <= MAX_CRD_ADV)
{
*pkt_hdr |= (pnd_credits[x_cir] << 3);
credits[x_cir] += pnd_credits[x_cir];
pnd_credits[x_cir] = 0;
}
else
{
*pkt_hdr |= (MAX_CRD_ADV << 3);
credits[x_cir] += MAX_CRD_ADV;
pnd_credits[x_cir] -= MAX_CRD_ADV;
}
}
int write_data_frame(d_buf,buf_len,d_type)
BYTE *d_buf;
int buf_len;
BYTE d_type;
{
BYTE buffer[MAX_FR_SIZE+1], *bptr = buffer, *end_data, *dmax;
WORD crc = 0;
BYTE more_char = ' ';
BYTE f_hdr = I_FRAME_HDR;
f_hdr |= ((((send_seq - re_xmits) & MAX_SEQ)<<3) | rcv_seq);
r_lst_ack = rcv_seq;
end_data = d_buf + buf_len;
*bptr++ = start_char;
dmax = bptr + max_fr_out;
kermitize(bptr, f_hdr);
docrc(crc, f_hdr);
kermitize(bptr, d_type);
docrc(crc, d_type);
while (d_buf < end_data)
{
if (bptr >= dmax)
{
more_char = '!';
break;
}
kermitize(bptr, *d_buf);
docrc(crc, *d_buf);
d_buf++;
}
kermitize(bptr, more_char);
docrc(crc, more_char);
bptr += _kermitize(bptr, MSB(crc));
bptr += _kermitize(bptr, LSB(crc));
*bptr++ = end_char;
tty_write(buffer, bptr - buffer);
WriteBTrace("< ", buffer, bptr - buffer);
if (re_xmits > 0)
re_xmits--;
else
{
send_seq++;
send_seq &= MAX_SEQ;
}
resp_req = FALSE;
return((d_buf+buf_len) - end_data);
}
calc_unacks()
{
return ((send_seq-last_ack) & MAX_SEQ);
}
void check_ack(remote_rcv_seq)
int remote_rcv_seq;
{
int i;
static int same_acks = 0;
if ((((send_seq - last_ack) & MAX_SEQ) -
((send_seq - remote_rcv_seq) & MAX_SEQ)) < 0)
{
Abort = TRUE;
return;
}
if (last_ack == remote_rcv_seq)
same_acks++;
else
{
same_acks = 0;
rexmit_count = 0;
}
if (same_acks == 2)
{
re_xmits = calc_unacks();
same_acks = 0;
}
last_ack = remote_rcv_seq;
if (re_xmits > 0)
{
i = calc_unacks();
if (i < re_xmits)
re_xmits = 0;
}
if (send_cr)
{
if (credit_ack == last_ack)
{
rexmit_count = 0;
send_cr = FALSE;
}
return;
}
if (pend_data != 0)
{
ack_data = xmit_buff[remote_rcv_seq];
if (!send_ctl)
a_data[xmt_cir] = ack_data;
}
if ((ack_data == pend_data) && (ack_data >= data_len)
&& (data_len > 0))
{
rexmit_count = ack_data = pend_data = data_len = 0;
if (send_ctl)
send_ctl = FALSE;
else
{
d_ptr[xmt_cir] = 0;
a_data[xmt_cir] = 0;
p_data[xmt_cir] = 0;
s_buf_a[xmt_cir]->unix_rec_type = ACK_USER_DATA;
s_buf_a[xmt_cir]->unix_ret_code = 0;
s_buf_a[xmt_cir]->unix_pass_back =
s_buf_r[xmt_cir]->unix_pass_back;
if (xmt_cir == XFER_CIRC)
{
xfer__ack(context_block);
}
}
}
}
void proc_data_frame(data_frame, frame_length)
Dataframe *data_frame;
unsigned frame_length;
{
unsigned circ_num;
BYTE pkt_type;
check_ack(data_frame->id & MAX_SEQ);
if (((data_frame->id>>3) & MAX_SEQ) == rcv_seq)
{
rcv_seq++;
rcv_seq &= MAX_SEQ;
pkt_type = (data_frame->phdr >> 4);
circ_num = (data_frame->phdr & (MAX_CIRCUITS - 1));
if ((pkt_type < CTL_PKT) &&
(circuit_status[circ_num] == OPEN))
{
proc_pkt_hdr(data_frame->phdr);
process_data(data_frame,frame_length-2);
}
else
{
if (pkt_type == CTRL_D_2)
{
proc_2_data(data_frame,frame_length-2);
}
else if (pkt_type == CTRL_D_3)
{
proc_3_data(data_frame,frame_length-2);
}
else
{
}
}
}
else
{
}
}
void proc_2_data(frame,fr_len)
Dataframe *frame;
unsigned fr_len;
{
BYTE *b_ptr;
BYTE more;
WORD get_word();
if ((curr_cfg_type = frame->phdr) != CONFIG && curr_cfg_type != ANS_CONFIG)
{
return;
}
fr_len--;
if ((r_prm_len + fr_len) > MAX_CFG_LEN)
{
Abort = TRUE;
return;
}
b_ptr = (BYTE *)ans_parms + r_prm_len;
memcpy(b_ptr, frame->msg, fr_len);
if (r_prm_len == 0)
{
config_version = get_word(&b_ptr);
config_max_fr_len = get_word(&b_ptr);
}
more = *(frame->msg+fr_len);
r_prm_len += fr_len;
if (more == MORE_DATA)
{
return;
}
if (r_prm_len < MIN_CFG_LEN)
{
Abort = TRUE;
return;
}
r_prm_len = 0;
if (MIN_FR_SIZE <= config_max_fr_len && config_max_fr_len <= MAX_FR_SIZE)
{
max_fr_out = config_max_fr_len - MAX_FR_ADJUST;
}
if (MIN_WINDOW <= ans_parms[CFG_WINDOW] &&
ans_parms[CFG_WINDOW] <= MAX_WINDOW)
window = conf_parms[CFG_WINDOW] = ans_parms[CFG_WINDOW];
if ((ans_parms[CFG_START_C] == start_char) ||
(ans_parms[CFG_START_C] < 32))
start_char = conf_parms[CFG_START_C] = ans_parms[CFG_START_C];
if ((ans_parms[CFG_END_C] == end_char) || (ans_parms[CFG_END_C] < 32))
end_char = conf_parms[CFG_END_C] = ans_parms[CFG_END_C];
conf_parms[CFG_XFER_TYPE] = ans_parms[CFG_XFER_TYPE];
conf_parms[CFG_NUM_XTRA_C] = ans_parms[CFG_NUM_XTRA_C];
if (ans_parms[CFG_XFER_TYPE] == 'A')
set_kermit(WEAK_KERMIT);
else if (ans_parms[CFG_XFER_TYPE] == 'B')
{
int i;
set_kermit(WEAK_KERMIT);
for (i=0; i<ans_parms[CFG_NUM_XTRA_C]; i++)
adj_kermit(conf_parms[CFG_XTRA_C+i] = ans_parms[CFG_XTRA_C+i]);
}
else
set_kermit(STRONG_KERMIT);
adj_kermit(start_char);
adj_kermit(end_char);
if (curr_cfg_type == CONFIG)
pend_actl = TRUE;
}
void proc_3_data(frame,fr_len)
Dataframe *frame;
unsigned fr_len;
{
BYTE *b_ptr;
BYTE more;
int i;
curr_ctl_type = frame->phdr;
fr_len--;
if ((c_prm_len + fr_len) > MAX_CFG_LEN)
{
Abort = TRUE;
return;
}
b_ptr = (BYTE *)open_parms + c_prm_len;
memcpy(b_ptr, frame->msg, fr_len);
more = *(frame->msg+fr_len);
c_prm_len += fr_len;
if (more == MORE_DATA)
return;
if (curr_ctl_type == OPEN_CIR)
{
i = open_parms[OPEN_ID];
if (circuit_status[i] == OPEN)
{
goto bad_open;
}
rmt_credits[i] = open_parms[OPEN_CREDITS];
ans_open_parms[ANS_ID] = i;
ans_open_parms[ANS_CREDITS] = INITIAL_CRDTS;
credits[i] = INITIAL_CRDTS;
pnd_credits[i] = 0;
if (open_circuit(i,open_parms+OPEN_STRING,open_parms[OPEN_LEN])
== NO_ERROR)
{
circuit_status[open_parms[OPEN_ID]] = OPEN;
ans_open_parms[ANS_STATUS] = PPL_SUCCESS;
}
else
{
bad_open:
ans_open_parms[ANS_STATUS] = PPL_NO_SUCCESS;
}
pend_ans = TRUE;
xmt_cir = i;
}
else if (curr_ctl_type == CLOSE_CIR)
{
i = open_parms[CLOSE_ID];
if (circuit_status[i] == CLOSED)
{
}
else
{
circuit_status[i] = CLOSED;
close_circ(i);
}
}
else if (curr_ctl_type == HI_PRI_PKT)
{
memcpy(hipri_buf.unix_usr_data, open_parms+HI_DATA,
open_parms[HI_DATA_LEN]);
hipri_buf.unix_ret_code = 0;
hipri_buf.unix_data_len = open_parms[HI_DATA_LEN];
hipri_buf.unix_rec_type = HIPRI_DATA;
c_prm_len = open_parms[HI_DATA_LEN];
}
c_prm_len = 0;
}
int open_circuit(circ_num,son_name,son_len)
unsigned circ_num;
BYTE *son_name;
unsigned son_len;
{
if (circ_num == XFER_CIRC)
{
if (xfer__initialize(&context_block) == xfer_success)
{
s_buf_r[circ_num] = context_block->read_buffer;
s_buf_w[circ_num] = context_block->write_buffer;
s_buf_a[circ_num] = context_block->ack_buffer;
return(NO_ERROR);
}
else
return(ERROR);
}
#ifdef USING_PPL
s_buf_r[circ_num] = (struct unix_record *)read_buff[circ_num];
s_buf_w[circ_num] = (struct unix_record *)write_buff[circ_num];
s_buf_a[circ_num] = (struct unix_record *)ack_buff[circ_num];
son_name[son_len] = (BYTE)NULL;
return (start_son(circ_num, son_name) == FAIL ? ERROR : NO_ERROR);
#else
return ERROR;
#endif
}
void close_circ(circ_num)
unsigned circ_num;
{
s_buf_w[circ_num]->unix_rec_type = DEATH;
if (circ_num == XFER_CIRC)
{
if (context_block->xfer_state == X_ABORT)
quit_type = QUIT_SHUTDOWN;
xfer__shutdown(context_block);
}
kill_son(circuit[circ_num].son_pid);
circuit[circ_num].son_pid = 0;
d_ptr[circ_num] = 0;
p_data[circ_num] = 0;
a_data[circ_num] = 0;
credits[circ_num] = 0;
da_len[circ_num] = 0;
pnd_credits[circ_num] = 0;
rmt_credits[circ_num] = 0;
}
void proc_pkt_hdr(hdr)
BYTE hdr;
{
rmt_credits[hdr & 0x07] += ((hdr >> 3) & MAX_CRD_ADV);
}
void process_data(frame,fr_len)
Dataframe *frame;
int fr_len;
{
unsigned circ_num;
BYTE *b_ptr;
BYTE more;
int pass_data = 0;
circ_num = (frame->phdr & (MAX_CIRCUITS - 1));
fr_len--;
if ((user_msg_len[circ_num] + fr_len) > MAX_USR_DATA)
{
s_buf_w[circ_num]->unix_rec_type = TOUSER_DATA;
s_buf_w[circ_num]->unix_ret_code = MESS_CONT;
s_buf_w[circ_num]->unix_data_len = user_msg_len[circ_num];
if (circ_num == XFER_CIRC)
{
context_block->write_length = user_msg_len[circ_num] + UX_REC_OVHD;
xfer__write_record(context_block);
}
user_msg_len[circ_num] = 0;
}
b_ptr = &s_buf_w[circ_num]->unix_usr_data[user_msg_len[circ_num]];
memcpy(b_ptr, frame->msg, fr_len);
more = *(frame->msg+fr_len);
if (more != MORE_DATA && calc_unacks() == 0)
tty_iflush();
user_msg_len[circ_num] += fr_len;
if (fr_len > 0)
{
credits[circ_num]--;
if (circ_num == XFER_CIRC)
{
pass_data = (context_block->xfer_state &
(X_RECV | X_RECV_A | X_BKUP | X_BKUP_START));
}
else
pass_data = 1;
pnd_credits[circ_num]++;
if (more != MORE_DATA || pass_data)
{
resp_req = TRUE;
s_buf_w[circ_num]->unix_rec_type = TOUSER_DATA;
s_buf_w[circ_num]->unix_ret_code =
(more == MORE_DATA ?MESS_CONT:0);
s_buf_w[circ_num]->unix_data_len = user_msg_len[circ_num];
if (circ_num == XFER_CIRC)
{
context_block->write_length = user_msg_len[circ_num] +
UX_REC_OVHD;
xfer__write_record(context_block);
}
user_msg_len[circ_num] = 0;
}
}
}
void load_xmit()
{
da_len[nxt_cir] = s_buf_r[nxt_cir]->unix_data_len;
if (da_len[nxt_cir] > MAX_USR_DATA)
da_len[nxt_cir] = MAX_USR_DATA;
d_ptr[nxt_cir] = s_buf_r[nxt_cir]->unix_usr_data;
p_data[nxt_cir] = a_data[nxt_cir] = 0;
xmt_cir = nxt_cir;
}
int do_xfer_read()
{
if (xfer__read_record(context_block) == xfer_success)
{
if ((s_buf_r[XFER_CIRC]->unix_rec_type == FROMUSER_DATA)
&& (context_block->read_length > 0))
return(NO_ERROR);
}
return(ERROR);
}
int do_read()
{
int i, j;
long pid;
unsigned char *f;
f = (unsigned char *)GetMsgq(&i, &pid);
for (j=0; j<MAX_CIRCUITS; j++)
if (circuit[j].son_pid == pid)
{
nxt_cir = j;
break;
}
if (j != MAX_CIRCUITS && i>0)
{
memcpy(s_buf_r[nxt_cir], f, i);
if (s_buf_r[nxt_cir]->unix_rec_type == FROMUSER_DATA)
return(NO_ERROR);
else if (s_buf_r[nxt_cir]->unix_rec_type == VERS_CHECK)
{
s_buf_w[nxt_cir]->unix_rec_type = VERS_REPLY;
s_buf_w[nxt_cir]->unix_pass_back =
s_buf_r[nxt_cir]->unix_pass_back;
s_buf_w[nxt_cir]->unix_ret_code = 0;
s_buf_w[nxt_cir]->unix_data_len = VERS_SIZE_REPLY;
s_buf_w[nxt_cir]->unix_usr_data[0] = MAJOR&0x0f;
s_buf_w[nxt_cir]->unix_usr_data[1] = MINOR;
}
}
return(ERROR);
}
check_circuits()
{
int i;
for (i=0; i<MAX_CIRCUITS; i++)
{
if (check_son(circuit[i].son_pid) == FAIL)
{
error_parms[ERROR_ID] = i;
error_parms[ERROR_CODE] = ECHILD;
pend_err = TRUE;
xmt_cir = i;
circuit[i].son_pid = 0;
}
}
}
usage(prog)
char *prog;
{
fprintf(stderr, "\nusage: %s [-t<sec>][-n<n>][-l][-v][-x<n>][-c][-h]\n\n",
prog);
fprintf(stderr, "\t[-t<sec>] Read timeout. Default: %d\n", READ_TIMEOUT);
fprintf(stderr, "\t[-n<n>]   Number of retries. Default: %d\n",
MAX_RETRIES);
fprintf(stderr, "\t[-l]      Create log \"WRQLOG\".\n");
fprintf(stderr, "\t[-v]      Display version number and exit.\n");
fprintf(stderr, "\t[-x<n>]   Number of retransmits. Default: %d\n",
MAX_REXMITS);
fprintf(stderr,
"\t[-c]      Wildcard transfers to host result in uppercase filenames.\n");
fprintf(stderr, "\t[-h]      Display usage and exit.\n");
}
#ifdef BSD42
#define anyof(c, sep) (index(sep, c) == NULL ? FALSE : TRUE)
char *strtok(s1, sep)
char *s1, *sep;
{
static char *s = (char *) NULL;
char *t;
if (s1 != (char *)NULL)
s = s1;
t = s;
if (s == (char *) NULL || *s == NULL)
return NULL;
while (*s != NULL && anyof(*s, sep) == FALSE)
s++;
if (*s != NULL)
*s++ = NULL;
return t;
}
char *strpbrk(s1, s2)
char *s1, *s2;
{
while (*s1 != NULL && anyof(*s1, s2) == FALSE)
s1++;
return (*s1 == NULL ? NULL : s1);
}
#endif
#ifndef MODULAR
#include <time.h>
#define leap(y) ((y)%4 == 0 && (y)%100 != 0 || (y)%400 == 0)
static int day_tab[2][13] = {
{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31},
{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31},
};
unsigned long GetTime(dt)
struct date_time *dt;
{
unsigned long days, secs;
int i;
days = (unsigned long) dt->day;
for(i=1;i<dt->month;i++)
days += (unsigned long) day_tab[leap(dt->year+1900)][i];
for(i=1970;i<dt->year+1900;i++)
days += (unsigned long) (365+(leap(i) ? 1 : 0));
secs = days * 24L * 3600L;
secs += (unsigned long) dt->second +
(unsigned long) (60 * dt->minute) +
(unsigned long) (3600L * (unsigned long) dt->hour);
return secs;
}
static validTime(dt)
struct date_time *dt;
{
if (dt->second > 59 || dt->minute > 59 || dt->hour > 23)
return FAIL;
if (!dt->month && !dt->day && !dt->year)
return SUCCESS;
return ((dt->month < 1 || dt->month > 12 || dt->year < 70 ||
dt->day < 1 || dt->day > day_tab[leap(dt->year+1900)][dt->month]) ?
FAIL : SUCCESS);
}
#define MAX_TIME_STRING 19
_parse_time(t, dt)
char *t;
struct date_time *dt;
{
char *strtok();
int atoi();
char *sub;
if ((sub = strtok(t, ": ")) == NULL)
return;
dt->hour = atoi(sub);
if ((sub = strtok(NULL, ": ")) == NULL)
return;
dt->minute = atoi(sub);
if ((sub = strtok(NULL, ": ")) == NULL)
return;
dt->second = atoi(sub);
}
ParseTime(b, dt)
char *b;
struct date_time *dt;
{
char s[MAX_TIME_STRING+1], *ptr = s, *sub;
char *strtok();
int atoi();
long d;
struct tm *tmp;
strncpy(s, b, MAX_TIME_STRING);
s[MAX_TIME_STRING] = (char) NULL;
if (*ptr == ':')
{
time(&d);
tmp = localtime(&d);
dt->day = tmp->tm_mday;
dt->month = tmp->tm_mon+1;
dt->year = tmp->tm_year;
_parse_time(++ptr, dt);
}
else
{
if ((sub = strtok(ptr, "-/ ")) == NULL)
return FAIL;
dt->month = atoi(sub);
if ((sub = strtok(NULL, "-/ ")) == NULL)
return FAIL;
dt->day = atoi(sub);
if ((sub = strtok(NULL, "-/: ")) == NULL)
return FAIL;
if ((dt->year = atoi(sub)) < 70)
dt->year += 100;
if ((sub = strtok(NULL, "")) != NULL)
_parse_time(sub, dt);
}
return (validTime(dt));
}
unsigned long GetUnixDate(dt)
struct date_time *dt;
{
long d;
struct date_time mydt;
long GMadj = 0L;
d = GetTime(dt);
GetPplDate(&mydt, d);
GMadj = GetTime(&mydt) - d;
return (GetTime(dt) - GMadj);
}
GetPplDate(dt, t)
struct date_time *dt;
long t;
{
struct tm *localtime(), *lt;
lt = localtime(&t);
dt->day = lt->tm_mday;
dt->month = lt->tm_mon+1;
dt->year = lt->tm_year;
dt->second = lt->tm_sec;
dt->minute = lt->tm_min;
dt->hour = lt->tm_hour;
}
typedef struct
{
unsigned char *space;
unsigned char *curr_add;
unsigned char *end;
unsigned char *curr_next;
int size;
int inc;
int n;
int curr_n;
} List;
List *NewList();
int AddList();
void FreeList();
unsigned char *NextList();
int ForeachList();
void FirstList();
void free();
#define NumberofList(l) (l ? l->n : 0)
List *NewList(n, inc)
int n, inc;
{
List *l;
if ((l = (List *) malloc(sizeof(List))) == (List *) NULL)
return (List *) NULL;
if ((l->space = (unsigned char *) malloc(n)) == (unsigned char *) NULL)
return (free(l), (List *) NULL);
l->size = n;
l->end = l->space + n;
l->inc = inc;
l->curr_next = l->curr_add = l->space;
l->curr_n = l->n = 0;
return l;
}
void FreeList(l)
List *l;
{
free(l->space);
free(l);
}
AddList(l, s)
List *l;
unsigned char *s;
{
if (l->curr_add + strlen(s) + 1 > l->end)
{
int next, add;
next = l->curr_next - l->space;
add = l->curr_add - l->space;
l->size += l->inc;
if ((l->space = (unsigned char *) realloc(l->space, l->size)) ==
(unsigned char *) NULL)
return FAIL;
l->end = l->space + l->size;
l->curr_next = l->space + next;
l->curr_add = l->space + add;
}
strcpy(l->curr_add, s);
l->curr_add += strlen(s) + 1;
l->n++;
return SUCCESS;
}
void FirstList(l)
List *l;
{
l->curr_next = l->space;
l->curr_n = 0;
}
unsigned char *NextList(l)
List *l;
{
unsigned char *s;
if (++l->curr_n > l->n)
return NULL;
s = l->curr_next;
l->curr_next += strlen(l->curr_next) + 1;
return (s);
}
static int current_list = 0;
ForeachList(l, offset, fn)
int offset;
List *l;
int (*fn)();
{
unsigned char *s;
current_list = 0;
if (offset >= l->n)
return FAIL;
s = l->space;
for (;current_list<offset; current_list++)
s += strlen(s) + 1;
for (;current_list<l->n; current_list++)
{
if((*fn)(s) == FAIL)
return FAIL;
s += strlen(s) + 1;
}
return SUCCESS;
}
CurrentListMember()
{
return current_list;
}
#ifdef SYSTEM5
#ifdef _OSF_SOURCE
#include <termios.h>
#else
#include <termio.h>
#endif
#ifdef AIX
#define TTYSTRUCT termios
#define TGET(a,b) tcgetattr(a,b)
#define TSET(a,b) tcsetattr(a,TCSANOW,b)
#define TFLUSH(a,b) tcsetattr(a,TCSAFLUSH,b)
#define TIFLUSH(a,b) tcflush(a,TCIOFLUSH)
#else
#define TTYSTRUCT termio
#define TGET(a,b) ioctl(a,TCGETA,b)
#define TSET(a,b) ioctl(a,TCSETA,b)
#define TFLUSH(a,b) ioctl(a,TCSETAW,b)
#define TIFLUSH(a,b) ioctl(a,TCFLSH,b)
#endif
#else
#include <sgtty.h>
#include <sys/file.h>
#define TTYSTRUCT sgttyb
#ifdef TIOCGETC
struct tchars oldtchars, curtchars;
#endif
#ifdef TIOCGLTC
struct ltchars oldltchars, curltchars;
#endif
#endif
extern jmp_buf TimerEnv;
extern int TimerSet;
#define PPL_CTRL(X) (X - 'A' + 1)
jmp_buf TimerEnv;
int TimerSet = 0;
int NOBLOCK = FALSE;
int interrupt = FALSE;
#define DEFAULT_BUFSZ 256
#define TREAD(a,b) read(0, a, b)
#define TWRITE(a,b) write(1, a, b)
struct TTYSTRUCT curtty;
struct TTYSTRUCT oldtty;
int tty_open()
{
void tty_hangup(), tty_interrupt(), tty_timeout();
signal(SIGHUP, tty_hangup);
signal(SIGINT, tty_interrupt);
signal(SIGQUIT, SIG_IGN);
#ifdef SIGCLD
signal(SIGCLD, SIG_IGN);
#endif
#ifdef SIGTSTP
signal(SIGTSTP, SIG_IGN);
#endif
#ifdef _SIGTSTP
signal(_SIGTSTP, SIG_IGN);
#endif
#ifdef SIGUSR1
signal(SIGUSR1, SIG_IGN);
#endif
#ifdef SIGUSR2
signal(SIGUSR2, SIG_IGN);
#endif
alarm(0);
signal(SIGALRM, tty_timeout);
#ifdef SYSTEM5
TGET(0, &oldtty);
curtty = oldtty;
#ifdef MINTTY
curtty.c_lflag &= ~ECHO;
curtty.c_cc[2] = 8;
curtty.c_cc[3] = 21;
#else
curtty.c_lflag = ISIG+ICANON;
curtty.c_iflag = ICRNL|IGNBRK|IXON|PARMRK;
curtty.c_oflag &= ~OPOST;
#ifdef AIX
curtty.c_iflag |= IEXTEN;
#endif
curtty.c_cc[VINTR] = PPL_CTRL('Y');
curtty.c_cc[VQUIT] = '\377';
curtty.c_cc[VERASE] = '\377';
curtty.c_cc[VKILL] = '\377';
curtty.c_cc[VEOF] = '\377';
curtty.c_cc[VEOL] = '\377';
#ifdef VEOL2
curtty.c_cc[VEOL2] = '\377';
#endif
#ifdef VSWTCH
curtty.c_cc[VSWTCH] = '\377';
#endif
#ifdef VDSUSP
curtty.c_cc[VDSUSP] = '\377';
#endif
#ifdef VREPRINT
curtty.c_cc[VREPRINT] = '\377';
#endif
#ifdef VDISCRD
curtty.c_cc[VDISCRD] = '\377';
#endif
#ifdef VWERSE
curtty.c_cc[VWERSE] = '\377';
#endif
#ifdef VWERASE
curtty.c_cc[VWERASE] = '\377';
#endif
#ifdef VLNEXT
curtty.c_cc[VLNEXT] = '\377';
#endif
#ifdef VSUSP
curtty.c_cc[VSUSP] = '\377';
#endif
#ifdef VSTOP
curtty.c_cc[VSTOP] = '\377';
#endif
#ifdef VSTART
curtty.c_cc[VSTART] = '\377';
#endif
#endif
TSET(0, &curtty);
#else
gtty(0, &oldtty);
#ifdef TIOCGETC
ioctl(0, TIOCGETC, &oldtchars);
curtchars = oldtchars;
curtchars.t_intrc = PPL_CTRL('Y');
curtchars.t_quitc = '\377';
curtchars.t_eofc = '\377';
curtchars.t_brkc = '\377';
ioctl(0, TIOCSETC, &curtchars);
#endif
#ifdef TIOCGLTC
ioctl(0, TIOCGLTC, &oldltchars);
curltchars = oldltchars;
curltchars.t_suspc = '\377';
curltchars.t_dsuspc = '\377';
curltchars.t_rprntc = '\377';
curltchars.t_flushc = '\377';
curltchars.t_werasc = '\377';
curltchars.t_lnextc = '\377';
ioctl(0, TIOCSLTC, &curltchars);
#endif
curtty = oldtty;
curtty.sg_flags &= ~ECHO;
curtty.sg_erase = '\377';
curtty.sg_kill = '\377';
stty(0, &curtty);
#endif
{
int dummy, val;
val = fcntl(0, F_GETFL, &dummy);
}
tty_flush();
tty_noblock();
return SUCCESS;
}
tty_noblock()
{
if (NOBLOCK == FALSE)
{
fcntl(0, F_SETFL, O_RDWR+O_NDELAY);
NOBLOCK = TRUE;
}
}
tty_block()
{
if (NOBLOCK == TRUE)
{
fcntl(0, F_SETFL, O_RDWR);
NOBLOCK = FALSE;
}
}
tty_close()
{
void tty_continue();
tty_block();
signal(SIGALRM, tty_continue);
alarm(2);
tty_flush();
alarm(0);
#ifdef SYSTEM5
TSET(0, &oldtty);
#else
stty(0, &oldtty);
#ifdef TIOCGETC
ioctl(0, TIOCSETC, &oldtchars);
#endif
#ifdef TIOCGLTC
ioctl(0, TIOCSLTC, &oldltchars);
#endif
#endif
tty_write("\n", 1);
}
int tty_read(buf)
unsigned char *buf;
{
int tb_max = 0;
#ifdef RDCHK
if (rdchk() == 0)
return 0;
#endif
tb_max = TREAD(buf, DEFAULT_BUFSZ);
WriteBTrace("> ", buf, tb_max);
if (tb_max > 0)
interrupt = FALSE;
return(tb_max);
}
tty_write(buf, blen)
char *buf;
int blen;
{
#ifdef DG
fflush(stdout);
#endif
if (blen == -1)
blen = strlen(buf);
if (TWRITE(buf, blen) < 0)
quit(QUIT_WRITE_TTY);
}
tty_flush()
{
#ifdef SYSTEM5
TFLUSH(0, &curtty);
#else
stty(0, &curtty);
#endif
}
void tty_timeout()
{
alarm(0);
signal(SIGALRM, tty_timeout);
tty_iflush();
if(TimerSet)
{
TimerSet = 0;
longjmp(TimerEnv,1);
}
quit(QUIT_TIMEOUT);
}
tty_iflush()
{
#ifdef SYSTEM5
TIFLUSH(0,0);
#else
ioctl(0, TIOCFLUSH, FREAD);
#endif
}
void tty_hangup()
{
quit(QUIT_HANGUP_TTY);
}
void tty_interrupt()
{
signal(SIGINT, tty_interrupt);
if (interrupt == TRUE)
quit(QUIT_INTERRUPT_TTY);
interrupt = TRUE;
}
void tty_continue()
{
alarm(0);
signal(SIGALRM, tty_continue);
}
int ppl_write(fd, buf, len)
int fd, len;
unsigned char *buf;
{
int ret;
signal(SIGINT, SIG_IGN);
ret = write(fd, buf, len);
signal(SIGINT, tty_interrupt);
return ret;
}
int ppl_read(fd, buf, len)
int fd, len;
unsigned char *buf;
{
int ret;
signal(SIGINT, SIG_IGN);
ret = read(fd, buf, len);
signal(SIGINT, tty_interrupt);
return ret;
}
int ppl_fwrite(buf, size, nitems, stream)
unsigned char *buf;
unsigned int size, nitems;
FILE *stream;
{
int ret;
signal(SIGINT, SIG_IGN);
ret = fwrite(buf, size, nitems, stream);
signal(SIGINT, tty_interrupt);
return ret;
}
int ppl_fread(buf, size, nitems, stream)
unsigned char *buf;
unsigned int size, nitems;
FILE *stream;
{
int ret;
signal(SIGINT, SIG_IGN);
ret = fread(buf, size, nitems, stream);
signal(SIGINT, tty_interrupt);
return ret;
}
#include <ctype.h>
static char *trace_file = "WRQLOG";
static int tracefd = FAIL;
OpenTrace()
{
tracefd = open(trace_file, O_WRONLY+O_CREAT+O_TRUNC, 0666);
}
WriteTrace(s)
char *s;
{
if (tracefd == FAIL)
return;
ppl_write(tracefd, s, strlen(s));
ppl_write(tracefd, "\n", 1);
}
WriteBTrace(c, s, n)
unsigned char *s, *c;
int n;
{
long istime;
extern char *ctime();
char *tp;
void tty_interrupt();
if (tracefd == FAIL)
return;
if (n < 0)
return;
(void)time(&istime);
tp = ctime(&istime);
tp[19] = ' ';
signal(SIGINT, SIG_IGN);
write(tracefd, &tp[11], 9);
write(tracefd, c, 2);
write(tracefd, s, n);
write(tracefd, "\n", 1);
signal(SIGINT, tty_interrupt);
}
CloseTrace()
{
if (tracefd == FAIL)
return;
close(tracefd);
}

#ifdef AIX
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#define WILD_ANY '*'
#define WILD_ONE '?'
#define BEG_RANGE '['
#define END_RANGE ']'
#define NOT_RANGE '!'
char *original;
char *strchr();
static char *first();
static int _match(), range();
match(pat, s)
char *pat, *s;
{
original = s;
return (_match(pat, s));
}
fixslashes(s)
char *s;
{
char *t;
for (t = s; *t; t++)
if (*t == '\\')
*t = '/';
}
static int _match(pat, s)
char *pat, *s;
{
char *strchr();
char *anyofu;
extern BOOL show_hidden;
while (*pat && *s && *pat != WILD_ANY)
{
if (*pat == BEG_RANGE)
{
do
{
if ((anyofu = strchr(++pat, END_RANGE)) == NULL)
return NO;
if (range(*s, pat, anyofu-pat) == NO)
return NO;
s++;
pat = anyofu+1;
}
while (*pat == BEG_RANGE);
continue;
}
if (*pat != WILD_ONE && *pat != *s)
return(NO);
if (*s == '/' && *pat != '/')
return NO;
if (show_hidden == FALSE &&
(*s == '.' && ((s == original && *pat != '.') ||
(s != original && *(s-1) == '/' && *pat != '.'))))
return NO;
pat++;
s++;
}
while (*pat == WILD_ANY)
{
if (*s == '/' || (show_hidden == FALSE && (*s == '.' &&
(s == original || *(s-1) == '/'))))
return NO;
if (*++pat == '\0')
return ((strchr(s,'/') != NULL ||
(show_hidden == FALSE && (*s == '.' &&
(s == original || *(s-1) == '/')))) ? NO : YES);
}
if (*pat == '\0' || *s == '\0')
return((*s || *pat) ? NO : YES);
while (s = first(s,*pat))
if (match(pat,s) == YES)
return(YES);
else if (*++s == '\0')
return (NO);
return NO;
}
static char *first(str,c)
char *str,c;
{
return ((c == BEG_RANGE || c == WILD_ONE) ? str : strchr(str,c));
}
static int range(c, s, n)
char c, *s;
int n;
{
int not = NO;
char *t = s, *end = s+n-1;
if (*t == NOT_RANGE)
not = YES;
for (t+=not; t <= end; t++)
{
if (c == *t)
return (!not);
if (*t == '-' && t != end && t != s+not && c >= *(t-1))
{
if (c <= *++t)
return (!not);
}
}
return (not);
}
int SetSince(), SetBefore(), SetExclude(), SetSort();
int CheckSince(), CheckBefore(), CheckExclude();
extern int dirsort;
#define HIBITL (1L << (8 * (int)sizeof(long)) - 1)
#define MAXLONG (~HIBITL)
struct opstruct
{
char *option;
int significant;
int (*setfn)();
int (*checkfn)();
};
static struct opstruct options[] =
{
{"since", 2, SetSince, CheckSince},
{"before", 1, SetBefore, CheckBefore},
{"exclude", 1, SetExclude, CheckExclude},
{"sort", 2, SetSort, NULL},
{NULL, 0, NULL, NULL}
};
#define MAX_ATTRS 4
static getOption();
static validOption();
static getValue();
unsigned long before, since;
List *excludeList = (List *) NULL;
SetOptions(optstring)
char *optstring;
{
char obuf[100], value[100];
before = MAXLONG;
since = 0L;
excludeList = (List *) NULL;
dirsort = NO;
while (getOption(&optstring, obuf) == SUCCESS)
{
if (getValue(&optstring, value) == FAIL)
return FAIL;
if (validOption(obuf, value, options) == FAIL)
return FAIL;
}
return SUCCESS;
}
SetAttrs(fn, optstring)
char *fn, *optstring;
{
char *argv[(MAX_ATTRS*2)+1], *tok;
int count = 0, c, next = 0;
char *owner=NULL, *size=NULL, *group=NULL, *mode=NULL;
extern int optind, opterr, errno;
extern char *optarg;
char *strtok();
errno = 0;
while ((tok = strtok(next++ ? NULL : optstring, " ")) != NULL)
{
if (strncmp(tok, "/SIZE", 5) == 0 ||
strncmp(tok, "RECSIZE", 7) == 0)
continue;
if (++count > MAX_ATTRS*2)
return FAIL;
argv[count] = tok;
}
if (!count)
return SUCCESS;
opterr = 0;
optarg = NULL;
optind = 1;
while ((c = getopt(count+1, argv, "O:o:G:g:M:m:S:s:")) != EOF)
switch (c)
{
case 'O':
case 'o':
owner = optarg;
break;
case 'S':
case 's':
size = optarg;
break;
case 'G':
case 'g':
group = optarg;
break;
case 'M':
case 'm':
mode = optarg;
break;
case '?':
default:
return FAIL;
}
if (optind != count+1)
return FAIL;
if (mode)
if (SetMode(fn, mode) == FAIL)
return FAIL;
if (group)
if (SetGroup(fn, group) == FAIL)
return FAIL;
if (owner)
if (SetOwner(fn, owner) == FAIL)
return FAIL;
return SUCCESS;
}
static getOption(o, buf)
char **o;
char *buf;
{
char *p, *b = buf;
int string = 0;
for (p = *o; *p; p++)
{
if (*p == '(')
string = 1;
else if (*p == ')')
string = 0;
else if (!string && *p == '/')
{
p++;
while (*p && !isspace(*p) && *p != '=' && *p != '/')
*b++ = *p++;
break;
}
}
*b = (char) NULL;
*o = p;
return (strlen(buf) ? SUCCESS : FAIL);
}
static validOption(o, value, option)
char *o, *value;
struct opstruct *option;
{
struct opstruct *op;
char *stolower();
for (op = option; op->option != NULL; op++)
if (strlen(o) >= op->significant &&
strncmp(op->option, stolower(o), strlen(o)) == 0)
return ((int)(*op->setfn)(value));
return FAIL;
}
static getValue(o, buf)
char **o, *buf;
{
char *p = *o;
int string = 0;
char *b = buf;
EatWhite(&p);
if (*p == '=')
p++;
EatWhite(&p);
if (*p == '(')
{
string = 1;
p++;
}
while (*p)
{
if ((string && *p == ')') ||
(!string && (isspace(*p) || *p == '/')))
break;
*b++ = *p++;
}
*b = (char)NULL;
*o = p;
return (SUCCESS);
}
EatWhite(o)
char **o;
{
char *p = *o;
while (*p && isspace(*p))
p++;
*o = p;
}
static SetBefore(d)
char *d;
{
struct date_time dt;
dt.hour = dt.minute = dt.second = 0;
if (ParseTime(d, &dt) == FAIL)
return FAIL;
before = GetTime(&dt);
return SUCCESS;
}
static SetSince(d)
char *d;
{
struct date_time dt;
dt.hour = 23;
dt.minute = dt.second = 59;
if (ParseTime(d, &dt) == FAIL)
return FAIL;
since = GetTime(&dt);
return SUCCESS;
}
#define OPTION_INC 50
SetExclude(f)
char *f;
{
char fn[MAX_FILENAME+1];
char *p = f, *pp;
char *strpbrk();
int done = 0;
if ((excludeList = NewList(strlen(f)+1, OPTION_INC)) == (List *) NULL)
return FAIL;
while (!done)
{
EatWhite(&p);
if ((pp = strpbrk(p, ", \t\n\r:")) == NULL)
{
pp = p + strlen(p);
done++;
}
if (p != pp)
{
strncpy(fn, p, pp - p);
fn[pp-p] = (char) NULL;
AddList(excludeList, fn);
}
p = pp + 1;
}
return SUCCESS;
}
SetSort(o)
char *o;
{
#ifdef DIRECTORY
dirsort=YES;
#endif
return SUCCESS;
}
struct fileinfo
{
char *name;
unsigned long mtime;
} fi;
SetFileinfoName(fn)
char *fn;
{
fi.name = fn;
}
static CheckBefore()
{
return (fi.mtime < before ? SUCCESS : FAIL);
}
static CheckSince()
{
return (fi.mtime > since ? SUCCESS : FAIL);
}
static checkit(e)
char *e;
{
char *strchr(), *ptr, *strrchr();
if (strchr(e, '/') == (char *) NULL)
{
if ((ptr = strrchr(fi.name, '/')) == NULL)
ptr = fi.name;
else
ptr++;
return (match(e,ptr) == YES ? FAIL : SUCCESS);
}
else
return (match(e,fi.name) == YES ? FAIL : SUCCESS);
}
CheckExclude()
{
if (NumberofList(excludeList) == 0)
return SUCCESS;
return(ForeachList(excludeList, 0, checkit));
}
CheckOptions(file)
char *file;
{
struct stat statbuf;
struct opstruct *op;
struct tm *t;
extern int errno;
struct date_time dt;
if (stat(file, &statbuf) == FAIL)
{
return FAIL;
}
fi.name = file;
t = localtime(&statbuf.st_mtime);
dt.second = t->tm_sec;
dt.minute = t->tm_min;
dt.hour = t->tm_hour;
dt.day = t->tm_mday;
dt.month = t->tm_mon+1;
dt.year = t->tm_year;
fi.mtime = GetTime(&dt);
for (op = options; op->option != NULL; op++)
{
if (op->checkfn != NULL && (int)(*op->checkfn)() == FAIL)
{
return FAIL;
}
}
return SUCCESS;
}
FreeOptions()
{
FreeExclude();
}
FreeExclude()
{
if (excludeList != (List *) NULL)
FreeList(excludeList);
}
#include <grp.h>
#include <pwd.h>
extern struct stat statbuf;
SetOwner(fn, o)
char *o, *fn;
{
int uid;
struct passwd *pwd;
if (isdigit(*o))
uid = atoi(o);
else if ((pwd = (struct passwd *)getpwnam(o)) == (struct passwd *)NULL)
return -1;
else
uid = pwd->pw_uid;
if (chown(fn, uid, statbuf.st_gid) == 0)
{
statbuf.st_uid = uid;
return 0;
}
return -1;
}
SetGroup(fn, g)
char *g, *fn;
{
int gid;
struct group *grp;
if (isdigit(*g))
gid = atoi(g);
else if ((grp = (struct group *)getgrnam(g)) == (struct group *)NULL)
return -1;
else
gid = grp->gr_gid;
if (chown(fn, statbuf.st_uid, gid) == 0)
{
statbuf.st_gid = gid;
return 0;
}
return -1;
}
SetMode(fn, p)
char *p, *fn;
{
int prot;
sscanf(p, "%o", &prot);
return (chmod(fn, prot));
}
char *stolower(s)
char *s;
{
static char n[128];
char *p, *q;
if (strlen(s) > sizeof(n))
return (char *) NULL;
for (q = n, p = s; *p; p++)
{
if (isupper(*p))
*q++ = tolower(*p);
else
*q++ = *p;
}
*q = (char)NULL;
return n;
}

#ifdef SIGUSR2
#define EXEC_SIG SIGUSR2
static jmp_buf ExecEnv;
static int ExecSet;
#define UnsetExec() signal(EXEC_SIG, SIG_IGN)
static void bad_exec();
#endif
static EatChars();
int spawn_son(command)
BYTE *command;
{
int tty, pid, count;
extern int errno;
BYTE **args, *t;
if ((tty = open("/dev/tty", O_RDWR)) == FAIL)
return FAIL;
#ifdef SIGUSR2
signal(EXEC_SIG, bad_exec);
ExecSet=1;
if (setjmp(ExecEnv))
return FAIL;
#endif
if ((pid = fork()) == 0)
{
close(0); dup(tty);
close(1); dup(tty);
close(2); dup(tty);
close(tty);
for (count = 0, t = command; *t != (char)NULL;)
{
count++;
EatChars(&t);
EatWhite(&t);
}
args = (BYTE **)malloc((count+1) * sizeof(char *));
for (count = 0, t = command; *t != (char)NULL;)
{
args[count++] = t;
EatChars(&t);
if (*t == (char)NULL)
{
break;
}
else
*t++ = (char)NULL;
EatWhite(&t);
}
args[count] = (BYTE *)NULL;
tty = execvp(args[0], args);
#ifdef SIGUSR2
kill(getppid(), SIGUSR2);
#endif
exit(-1);
}
close(tty);
UnsetExec();
return pid;
}
#ifdef SIGUSR2
static void bad_exec()
{
signal(EXEC_SIG, bad_exec);
if(ExecSet)
{
ExecSet = 0;
longjmp(ExecEnv,1);
}
}
#endif
static EatChars(o)
char **o;
{
char *p = *o;
while (*p && !isspace(*p))
p++;
*o = p;
}
kill_son(pid)
int pid;
{
if (pid > 0)
{
}
return (pid > 0 ? kill(pid, SIGTERM) : SUCCESS);
}
check_son(pid)
int pid;
{
return (kill(pid, 0) == -1 ? FAIL : SUCCESS);
}

int kermit_type = STRONG_KERMIT;
WORD crctab[] = {
0,4129,8258,12387,16516,20645,24774,28903,
33032,37161,41290,45419,49548,53677,57806,61935,
4657,528,12915,8786,21173,17044,29431,25302,
37689,33560,45947,41818,54205,50076,62463,58334,
9314,13379,1056,5121,25830,29895,17572,21637,
42346,46411,34088,38153,58862,62927,50604,54669,
13907,9842,5649,1584,30423,26358,22165,18100,
46939,42874,38681,34616,63455,59390,55197,51132,
18628,22757,26758,30887,2112,6241,10242,14371,
51660,55789,59790,63919,35144,39273,43274,47403,
23285,19156,31415,27286,6769,2640,14899,10770,
56317,52188,64447,60318,39801,35672,47931,43802,
27814,31879,19684,23749,11298,15363,3168,7233,
60846,64911,52716,56781,44330,48395,36200,40265,
32407,28342,24277,20212,15891,11826,7761,3696,
65439,61374,57309,53244,48923,44858,40793,36728,
37256,33193,45514,41451,53516,49453,61774,57711,
4224,161,12482,8419,20484,16421,28742,24679,
33721,37784,41979,46042,49981,54044,58239,62302,
689,4752,8947,13010,16949,21012,25207,29270,
46570,42443,38312,34185,62830,58703,54572,50445,
13538,9411,5280,1153,29798,25671,21540,17413,
42971,47098,34713,38840,59231,63358,50973,55100,
9939,14066,1681,5808,26199,30326,17941,22068,
55628,51565,63758,59695,39368,35305,47498,43435,
22596,18533,30726,26663,6336,2273,14466,10403,
52093,56156,60223,64286,35833,39896,43963,48026,
19061,23124,27191,31254,2801,6864,10931,14994,
64814,60687,56684,52557,48554,44427,40424,36297,
31782,27655,23652,19525,15522,11395,7392,3265,
61215,65342,53085,57212,44955,49082,36825,40952,
28183,32310,20053,24180,11923,16050,3793,7920
};
#define docrc(old, c) (old = ((old<<8) ^ crctab[((old>>8)^c) & 0xff])&0xffff)
BYTE _kermitize();
BYTE should_kermit[] = { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
0,0,0,1,0,0,1,0,1,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 };
BYTE weak_kermit[] = { 0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,
0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,
0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
BYTE strong_kermit[] = { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1 };
#ifdef BSD42
BYTE all_ones[] = { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 };
#endif
void set_kermit(type)
int type;
{
kermit_type = type;
if (type == STRONG_KERMIT)
{
memcpy(should_kermit, strong_kermit, sizeof(strong_kermit));
#ifdef BSD42
memcpy(should_kermit+sizeof(strong_kermit), all_ones, sizeof(all_ones));
#else
memset(should_kermit+sizeof(strong_kermit), 1, sizeof(strong_kermit));
#endif
}
else if (type == WEAK_KERMIT)
{
memcpy(should_kermit, weak_kermit, sizeof(weak_kermit));
memset(should_kermit+sizeof(weak_kermit), 0, sizeof(weak_kermit));
}
}
void adj_kermit(c)
BYTE c;
{
should_kermit[c] = 1;
}
BYTE _kermitize(b_ptr,chr)
BYTE *b_ptr;
BYTE chr;
{
BYTE *b_buf = b_ptr;
if (should_kermit[chr])
{
if (chr == '#' || chr == '&')
{
*b_buf++ = '#';
*b_buf++ = chr;
}
else if (chr > 0x7f)
{
*b_buf++ = '&';
#ifdef REGULAR_KERMIT
b_buf += _kermitize(b_buf, chr&0x7f);
#else
b_buf += _kermitize(b_buf, chr^0xc0);
#endif
}
else if (chr == 0x7f || chr < ' ' || chr == start_char || chr==end_char)
{
*b_buf++ = '#';
*b_buf++ = chr^0x40;
}
else
*b_buf++ = chr;
}
else
*b_buf++ = chr;
return(b_buf - b_ptr);
}
dekermitize(b_ptr, n, f_ptr, crc)
BYTE *b_ptr;
int n;
BYTE *f_ptr;
WORD *crc;
{
BYTE *end = b_ptr+n;
BYTE *f = f_ptr;
BYTE c;
while (b_ptr < end)
{
if ((c = *b_ptr++) == '&')
{
if ((c = *b_ptr++) != '#')
{
#ifdef REGULAR_KERMIT
c ^= 0x80;
#else
c ^= 0xc0;
#endif
}
else
{
c = *b_ptr++;
#ifdef REGULAR_KERMIT
c ^= ((c == '&' || c == '#') ? 0x80 : 0xC0);
#else
c ^= ((c == '&' || c == '#') ? 0xC0 : 0x80);
#endif
}
}
else if (c == '#')
{
c = *b_ptr++;
if (c != '&' && c != '#')
c ^= 0x40;
}
docrc(*crc,(c&0xff));
*f_ptr++ = c;
}
return(f_ptr - f);
}
static unsigned char frame[MAX_MSG];
static int nframe;
wait_event()
{
#if RDCHK
TimerSet = 1;
if (setjmp(TimerEnv))
return (TIMEOUT_TYPE);
alarm(read_timer);
while (1)
{
if ((nframe = tty_read(frame)) > 1)
return (nframe--, TTY_TYPE);
if (TryMsgq())
return MSGQ_TYPE;
sleep(1);
}
#endif
#ifdef RDNOBLOCK
static unsigned char save[MAX_FR_SIZE];
static int nsave=0;
unsigned char temp[MAX_FR_SIZE];
unsigned char *f=frame, *t;
int nchar;
TimerSet = 1;
if (setjmp(TimerEnv))
return (TIMEOUT_TYPE);
memset(temp, NULL, sizeof(temp));
memcpy(temp, save, nsave);
for (t = temp; *t != TERMINATOR && nsave > 0;
t++, nsave--, f++)
*f = *t;
if (*t == TERMINATOR)
{
if (nsave > 0)
nsave--;
t++;
memcpy(save, t, nsave);
nframe = (int)(f - frame);
return TTY_TYPE;
}
alarm(read_timer);
while (1)
{
memset(temp, NULL, sizeof(temp));
if ((nchar = tty_read(temp)) == 0 && f - frame == 0 && TryMsgq())
return MSGQ_TYPE;
nsave = nchar;
for (t = temp; *t != TERMINATOR && nsave > 0;
t++, nsave--, f++)
*f = *t;
if (*t == TERMINATOR)
{
if (nsave > 0)
nsave--;
t++;
memcpy(save, t, nsave);
nframe = (int)(f - frame);
return TTY_TYPE;
}
if (f-frame == 0)
sleep(1);
}
#endif
#if RDSIGNAL
static int trymsgq=0;
TimerSet = 1;
if (setjmp(TimerEnv))
return (UnsetMsgq(), trymsgq = 1, TIMEOUT_TYPE);
MsgqSet = 1;
signal(MSGQ_SIG, data_msgq);
if (setjmp(MsgqEnv))
trymsgq = 1;
alarm(read_timer);
while (1)
{
if (!trymsgq)
{
if ((nframe = tty_read(frame)) > 1)
return (UnsetMsgq(), trymsgq = 1, nframe--, TTY_TYPE);
else if (nframe != -1)
{
return (UnsetMsgq(), trymsgq = 1, nframe = 0, TTY_TYPE);
}
#ifdef EAGAIN
else if (errno == EAGAIN)
{
return (UnsetMsgq(), trymsgq = 1, nframe = 0, TTY_TYPE);
}
#endif
#ifdef EWOULDBLOCK
else if (errno == EWOULDBLOCK)
{
return (UnsetMsgq(), trymsgq = 1, nframe = 0, TTY_TYPE);
}
#endif
}
trymsgq = 0;
UnsetMsgq();
if (TryMsgq())
return (MSGQ_TYPE);
MsgqSet = 1;
signal(MSGQ_SIG, data_msgq);
}
#else
TimerSet = 1;
if (setjmp(TimerEnv))
return (TIMEOUT_TYPE);
alarm(read_timer);
while (1)
{
if ((nframe = tty_read(frame)) > 1)
return (nframe--, TTY_TYPE);
else if (nframe != -1)
{
return(nframe = 0, TTY_TYPE);
}
#ifdef EAGAIN
else if (errno == EAGAIN)
{
return (nframe = 0, TTY_TYPE);
}
#endif
#ifdef EWOULDBLOCK
else if (errno == EWOULDBLOCK)
{
return (nframe = 0, TTY_TYPE);
}
#endif
}
#endif
}
nowait_event()
{
#ifndef NONOWAIT
if ((nframe = tty_read(frame)) > 1)
return (nframe--);
#endif
return 0;
}
GetFrame(msg)
Frame *msg;
{
int n_frame;
BYTE *start, *end;
WORD crc = 0;
int no_end = 0;
if (nframe == 0)
return 0;
for (end = frame+nframe-1; end >= frame; end--)
if (*end == end_char)
break;
if (--end < frame)
{
no_end++;
end = frame+nframe-1;
}
for (start = end; start >= frame; start--)
if (*start == start_char)
break;
if (start++ < frame)
return (FAIL);
else if (no_end)
return (pend_rej = TRUE, FAIL);
n_frame = dekermitize(start, end-start+1, (BYTE *)msg, &crc);
if (crc)
{
return (pend_rej = TRUE, FAIL);
}
return n_frame-2;
}
unsigned char *GetMsgq(n, pid)
int *n;
long *pid;
{
struct message
{
long pid;
char *msg;
};
*n = nframe - sizeof(long);
*pid = ((struct message *) frame)->pid;
return (frame+sizeof(long));
}
TryMsgq()
{
return 0;
}

#ifdef DIRECTORY
#include <ndir.h>
static DIR *dirp;
static char **sorted_ptrs;
#define DIR_ESTIMATE 1000
static List *namelist;
#else
FILE *list_fp;
#endif
int dirsort=NO;
#define MAX_READNAME 300
#define D_REGFILE 0
#define D_DIRECTORY 1
List *dirList = (List *) NULL;
List *fileList = (List *) NULL;
char currentDirectory[MAX_FILENAME+1];
char currentFilespec[MAX_FILENAME+1];
BYTE currentLevel;
BOOL show_hidden = NO;
char home_root[MAX_FILENAME+1];
extern BOOL no_show_root;
extern char *home_directory;
#ifdef NO_PIPES
char wrq_ls_file[20];
#endif
static char directory[MAX_FILENAME+1], filespec[MAX_FILENAME+1];
int OpenDir(), CloseDir();
char *NextDir(), *FullName();
static char *getNextDir();
static isregfile();
static isdotdir();
static int dir_open = FALSE;
#ifdef DIRECTORY
alpha_order(p1, p2)
char **p1, **p2;
{
return (strcmp(*p1, *p2));
}
#endif
OpenDir(path, fs)
char *path, *fs;
{
char *name, *fname;
int i;
char sysbuf[MAX_FILENAME+1];
if (fs == NULL)
parsepath(path, directory, filespec);
else
{
filespec[0] = (char)NULL;
strcpy(directory, path);
}
#ifdef DIRECTORY
if ((dirp = opendir(directory)) == NULL)
return FAIL;
if (dirsort==YES)
{
if ((namelist = NewList(DIR_ESTIMATE, DIR_ESTIMATE)) == (List *) NULL)
{
CloseDir();
return FAIL;
}
while ((name = getNextDir(FALSE, NULL)) != NULL)
{
if (CheckOptions(fname = FullName(name)) == SUCCESS)
AddList(namelist, fname);
}
if ((sorted_ptrs = (char **)
malloc(NumberofList(namelist) * sizeof(char *))) == (char **) NULL)
return FAIL;
FirstList(namelist);
for (i=0; i<NumberofList(namelist); i++)
sorted_ptrs[i] = NextList(namelist);
qsort(sorted_ptrs,NumberofList(namelist),sizeof(char *),alpha_order);
}
#else
#ifdef NO_PIPES
sprintf(wrq_ls_file, "/tmp/wrq%05d", getpid());
sprintf(sysbuf,"ls %s %s | tee %s | grep %s",
isdirectory(path) ? "":"-d",
path, wrq_ls_file, wrq_ls_file);
system(sysbuf);
if ((list_fp = fopen(wrq_ls_file, "r")) == NULL)
return (errno = EACCES, FAIL);
#else
{
char tmpbuf[MAX_FILENAME+1];
int j,k;
sprintf(sysbuf,"ls -a %s '",
fs != NULL ? "" : "-d");
strcpy(tmpbuf, FullName(filespec));
j=strlen(sysbuf);
for (i=0,k=1 ; tmpbuf[i] != '\0' ; i++,j++) {
if (tmpbuf[i] == '*' || tmpbuf[i] == '?' || tmpbuf[i] == '\'') {
if (k == 1) {
sysbuf[j++] = '\'';
k = -1;
}
if (tmpbuf[i] == '\'') {
sysbuf[j++] = '\\';
}
}
else {
if (k == -1) {
sysbuf[j++] = '\'';
k = 1;
}
}
sysbuf[j] = tmpbuf[i];
}
if (k == 1) {
sysbuf[j++] = '\'';
}
sysbuf[j] = '\0';
}
if ((list_fp = popen(sysbuf, "r")) == NULL)
return (FAIL);
#endif
#endif
dir_open = TRUE;
return SUCCESS;
}
static char *getNextDir(type, ftype)
int type, *ftype;
{
#ifdef DIRECTORY
static struct direct *dp;
static matchdir();
while ((dp = readdir(dirp)) != NULL)
{
if (strcmp(dp->d_name, ".") == 0 ||
strcmp(dp->d_name, "..") == 0)
continue;
if (strlen(filespec) == 0 || matchdir(filespec,dp->d_name))
{
if (type == FALSE && isregfile(FullName(dp->d_name)))
return dp->d_name;
else if (type == TRUE && (isregfile(FullName(dp->d_name)) ||
isdirectory(FullName(dp->d_name))))
{
*ftype = (isdirectory(FullName(dp->d_name)) ? D_DIRECTORY :
D_REGFILE);
return dp->d_name;
}
}
}
#else
char buffer[MAX_READNAME+1], dir[MAX_READNAME+1];
static char fn[MAX_READNAME+1];
while (fgets(buffer, MAX_READNAME, list_fp) != NULL)
{
buffer[strlen(buffer)-1] = (char) NULL;
if (strcmp(buffer, ".") == 0 ||
strcmp(buffer, "..") == 0)
continue;
if (type == 0 && isregfile(buffer))
{
parsepath(buffer, directory, fn);
return fn;
}
else if (type == 1 && (isregfile(buffer) || isdirectory(buffer)))
{
*ftype = (isdirectory(buffer) ? D_DIRECTORY : D_REGFILE);
parsedirent(buffer, fn);
return fn;
}
}
#endif
return NULL;
}
char *NextDir(type, ftype)
int type, *ftype;
{
#ifdef DIRECTORY
static int n = 0;
if (dir_open == FALSE)
return NULL;
return (dirsort == YES ?
(n < NumberofList(namelist) ? sorted_ptrs[n++] : NULL) :
getNextDir(type, ftype));
#else
if (dir_open == FALSE)
return NULL;
return getNextDir(type, ftype);
#endif
}
char *FullName(n)
char *n;
{
static char name[MAX_FILENAME+1];
name[0] = (char)NULL;
if (strcmp(directory, "."))
{
strcpy(name, directory);
if (directory[strlen(directory)-1] != '/')
strcat(name, "/");
}
strcat(name, n);
return name;
}
CloseDir()
{
if (dir_open == FALSE)
return;
#ifdef DIRECTORY
closedir(dirp);
if (dirsort == YES)
{
FreeList(namelist);
free(sorted_ptrs);
}
#else
#ifdef NO_PIPES
fclose(list_fp);
unlink(wrq_ls_file);
#else
pclose(list_fp);
#endif
list_fp = NULL;
#endif
dir_open = FALSE;
}
parsepath(path, dir, fn)
char *path, *dir, *fn;
{
char *strrchr(), *p;
strcpy(dir, path);
if (isdirectory(dir))
{
strcpy(fn, "*");
}
else if ((p = strrchr(dir, '/')) == NULL)
{
strcpy(fn, dir);
strcpy(dir, ".");
}
else
{
strcpy(fn, p+1);
*p = (char)NULL;
if (dir[0] == (char)NULL)
strcpy(dir, "/");
if (fn[0] == (char)NULL)
strcpy(fn, "*");
}
}
static matchdir(pattern, name)
char *pattern, *name;
{
return ((isdotdir(name) || !match(pattern, name)) ? NO : YES);
}
static isregfile(name)
char *name;
{
struct stat sbuf;
if (stat(name, &sbuf) == -1)
return NO;
return (sbuf.st_mode & 0100000 ? YES : NO);
}
isdirectory(name)
char *name;
{
struct stat sbuf;
if (stat(name, &sbuf) == -1)
return NO;
return (sbuf.st_mode & 0040000 ? YES : NO);
}
static isdotdir(name)
char *name;
{
return ((strcmp(name, ".") && strcmp(name, "..")) ? NO : YES);
}
createDirectoryList()
{
if ((dirList = NewList(MAX_FILENAME, MAX_FILENAME)) == (List *) NULL)
return FAIL;
if ((fileList = NewList(MAX_FILENAME, MAX_FILENAME)) == (List *) NULL)
return FAIL;
return SUCCESS;
}
freeDirectoryList()
{
if (dirList != (List *) NULL)
FreeList(dirList);
if (fileList != (List *) NULL)
FreeList(fileList);
}
getPathDirectory()
{
char path[MAX_FILENAME+1], *p = path, *ptr;
int i='0';
char *strtok(), *strrchr();
strcpy(path, currentDirectory);
if (no_show_root)
{
if (strncmp(path, home_directory, strlen(home_directory)) == 0)
{
if (home_directory[strlen(home_directory)-1] == '/')
home_directory[strlen(home_directory)-1] = NULL;
if ((ptr = strrchr(home_directory, '/')) == NULL)
ptr = home_directory;
strncpy(home_root, home_directory, ptr-home_directory);
home_root[ptr-home_directory] = NULL;
p += (ptr-home_directory);
if (strcmp(home_directory, "/") != 0 && *p == '/')
p++;
}
}
if (*p == '/')
{
p++;
i++;
AddList(dirList, "0/");
}
ptr = strtok(p, "/");
while (ptr != NULL)
{
ptr--;
*ptr = i++;
AddList(dirList, ptr);
ptr = strtok(NULL, "/");
}
currentLevel = i-'0';
}
getFileDirectory()
{
int type;
char *fn, *NextDir();
char dir[MAX_FILENAME+1];
if (OpenDir(currentDirectory, DEFAULT_FILESPEC) == FAIL)
return FAIL;
if (SetExclude(currentFilespec) == FAIL)
return FAIL;
while ((fn = NextDir(TRUE, &type)) != NULL)
{
if (type == D_DIRECTORY)
{
if (show_hidden || *fn != '.')
{
dir[0] = currentLevel+'0';
strcpy(dir+1, fn);
AddList(dirList, dir);
}
}
else
{
SetFileinfoName(fn);
if (CheckExclude() == FAIL)
AddList(fileList, fn);
}
}
FreeExclude();
CloseDir();
return SUCCESS;
}
getCurrentLevel()
{
char *p;
char *strchr();
int level = 1;
p = currentDirectory;
if (no_show_root)
{
if (strncmp(currentDirectory, home_root, strlen(home_root)) == 0)
{
p += strlen(home_root);
if (*p == '/')
p++;
}
}
if (*p == '/' && strlen(p) == 1)
{
}
else if (strlen(p) > 0)
{
if (p[strlen(p)-1] == '/')
p[strlen(p)-1] = (char)NULL;
while ((p = strchr(p, '/')) != NULL)
{
level++;
p++;
}
}
currentLevel = level;
}
parsedirent(path, dirent)
char *path, *dirent;
{
char *strrchr(), *p;
if ((p = strrchr(path, '/')) == NULL)
strcpy(dirent, path);
else
strcpy(dirent, p+1);
}
ForeachDirectory(offset, func)
int offset;
int (*func)();
{
return (ForeachList(dirList, offset, func));
}
ForeachFilename(offset, func)
int offset;
int (*func)();
{
return (ForeachList(fileList, offset, func));
}
NumberofDirectory()
{
return (NumberofList(dirList));
}
NumberofFilename()
{
return (NumberofList(fileList));
}

enum xfer_return_type filesys_error();
enum xfer_return_type xfer_restore_start();
enum xfer_return_type xfer_rfile ();
enum xfer_return_type xfer_rfile_ext ();
enum xfer_return_type xfer_sfile ();
enum xfer_return_type xfer_misc_info ();
enum xfer_return_type xfer_start ();
enum xfer_return_type xfer_done ();
enum xfer_return_type xfer_abort ();
enum xfer_return_type xfer_ratt ();
enum xfer_return_type xfer_recv ();
enum xfer_return_type send_eof ();
enum xfer_return_type send_eot ();
enum xfer_return_type xfer_sclose ();
enum xfer_return_type xfer_get_directory();
enum xfer_return_type xfer_start_directory();
enum xfer_return_type xfer_send_directory();
enum xfer_return_type xfer_change_default();
enum xfer_return_type xfer_delete_files();
enum xfer_return_type xfer_qualify_file();
enum xfer_return_type xfer_continue_dir();
enum xfer_return_type check_cont ();
enum xfer_return_type check_err ();
enum xfer_return_type xfer_send ();
void initiate_send ();
void auto_detect_transfer_type ();
int fill_rms_buffer ();
int open_next_file ();
int open_output ();
int search_for_file ();
enum xfer_return_type open_existing_file();
unsigned char host_file_newer ();
char *get_renamed_filename();
int fill_attribute_buffer ();
int parse_attributes ();
int parse_selection ();
void xfer_ready_error_packet ();
int get_msg_text ();
enum xfer_return_type xfer_rbackup ();
enum xfer_return_type init_backup ();
enum xfer_return_type xfer_backup ();
enum xfer_return_type xfer_bkup_restore_close ();
void init_restore ();
enum xfer_return_type xfer_rrestore ();
int fill_directory_restore ();
unsigned char next_restore_path ();
int fill_restore_buffer ();
enum xfer_return_type xfer_directory ();
enum xfer_return_type send_directory ();
BOOL Binit ();
void crit_initiate();
int Bterm();
void Bcreate();
void Bdelete ();
void crit_delete();
void Binstall ();
void crit_install();
unsigned char Bopenf ();
unsigned char Bopenn();
unsigned char Bread();
void Bwrite ();
unsigned char Badvance ();
unsigned short Bhash ();
unsigned char Blookup ();
unsigned char Bposition ();
void Add_to_free ();
void data_write ();
void Set_prior ();
void add_chr ();
unsigned char Bcompile ();
unsigned char Bmatch ();
BYTE bgchar();
void bgstr ();
unsigned short bgword();
long bglong();
long bglink();
void bpchar ();
void bpstr ();
void bpword ();
void bplong ();
void bplink ();
void bpfill();
void hdr_read();
void hdr_write();
void checkpoint ();
void info_restore();
BOOL hash_read ();
void hash_write ();
void dir_read ();
void dir_write ();
int file_open ();
int file_create ();
int file_read ();
int file_write ();
int file_close();
int file_delete ();
int RF_create ();
int RF_open ();
int RF_read ();
int RF_write ();
int RF_close();
int RF_position ();
int fl_open ();
int fl_create ();
int fl_close ();
int fl_read ();
int fl_write ();
void pshutdown ();
long get_file_size( );
int return_owner_attributes();
int return_group_attributes();
int return_protection_attributes();
enum xfer_return_type rd_ascii_data ();
enum xfer_return_type rd_binary_data ();
enum xfer_return_type rd_h_ascii_data ();
enum xfer_return_type rd_h_binary_data ();
enum xfer_return_type wr_binary_data ();
enum xfer_return_type wr_ascii_data ();
enum xfer_return_type wr_h_binary_data ();
enum xfer_return_type wr_h_ascii_data ();
unsigned char decomp_binary ();
unsigned char decomp_ascii ();
unsigned char decmph_binary ();
unsigned char decmph_ascii ();
#define MAX_ATTRIBUTE_SIZE 1024
#define MAX_ERROR_STRING_LENGTH 255
#define MAX_FILE_SPEC_LENGTH 255
#define MAX_DATA_LENGTH (MAX_USR_DATA - sizeof(long) - 3)
#define END_OF_RECORD 0xff
#define SPACE_COMPRESS_ESCAPE 0xfe
#define ASCII_SPACE ' '
#define MAX_SELECTION_LENGTH 100
#define DEFAULT_RMS_RECORD_SIZE 1024
#define ATTRIBUTES_BUFFER_SIZE 1024
#define TOKEN_REQ '0'
#define SEND_FILE '1'
#define ANS_SEND '2'
#define GET_FILE '3'
#define DATA_MSG '4'
#define EOF_MSG '5'
#define EOT_MSG '6'
#define ABORT_XFER '7'
#define CONT_MSG '8'
#define ERR_MSG '9'
#define GET_DIR 'C'
#define SEND_DIR 'D'
#define ANSWER_DIR 'E'
#define CHANGE_DIR 'F'
#define ANSWER_CHANGE 'G'
#define DELETE_FILE 'H'
#define ANSWER_DELETE 'I'
#define QUALIFY_NAME 'J'
#define ANSWER_QUALIFY 'K'
#define SEND_FILE_EXT 'S'
#define MISC_INFO 'X'
#define MISC_I_FEATURES '3'
#define MISC_FEATURE_LENGTH 9
#define MISC_AUTODETECT 0
#define MISC_FILESCAN 1
#define MISC_RENAME 2
#define MISC_AUTONAMESPACE 3
#define MISC_SENDFILEEXT 4
#define MISC_FILENAMEFORMAT 5
#define MISC_EXTNAMESPACE 6
#define MISC_RECTYPEBINARY 7
#define MISC_LOWERCASE 8
#define MISC_I_UNSUPPORTED '4'
#define COMPRESS '~'
#define MIN_DUPS 4
#define CS_NONE 0
#define CS_START 1
#define CS_STABLE 2
#define CS_ESCAPE 3
#define CS_DUPLICATE 4
#define CS_WRTDUP 5
#define CS_COUNT 6
#define CS_WRTREP 7
#define CS_CHAR 8
#define CS_ASCII_8 9
#define COMP_NONE 0
#define COMP_REPEATED_RUN 1
#define COMP_HUFFMAN 2
#define TT_ASCII_MASK (1<<0)
#define TT_ATTRIBUTE_MASK (1<<1)
#define TT_IMAGE_MASK (1<<2)
#define TT_BACKUP_MASK (1<<4)
#define TT_RESTORE_MASK (1<<5)
#define TT_ONLY_MASK (1<<7)
#define TT_WILD_MASK (1<<9)
#define TT_LEVEL_PATTERN (1<<10)
#define TT_ONEBYTE_EOR (1<<11)
#define TT_AUTODETECT (1<<14)
#define DF_PURGE_MASK 1
#define DF_APPEND_MASK 2
#define DF_OVERWRITE_MASK 4
#define DF_DELETE_MASK 8
#define DF_FRESHEN_MASK 64
#define DF_RENAME_MASK 128
#define DF_SKIP_MASK 256
#define DF_UPDATE_MASK 512
#define RESPONSE_OK 0
#define RESPONSE_ERROR 67
struct cstate {
int comp_state;
int comp_type;
WORD count;
BYTE bcount;
BYTE repeat;
BYTE *buffer_ptr;
int buffer_count;
BOOL ascii_transfer;
BOOL eof_pending;
BYTE old, new;
BOOL new_dir;
BOOL restore_in_progress;
};
struct generic_packet {
BYTE packet_type;
};
struct token_req_packet {
BYTE packet_type;
};
struct send_file_packet {
BYTE packet_type;
WORD transfer_type;
BYTE ascii_flags;
BYTE compression_type;
BYTE disposition_flags;
struct date_time creation_date;
struct date_time revision_date;
ULONG file_size;
BYTE file_sp_length;
BYTE pattern_length;
char file_spec[MAX_FILE_SPEC_LENGTH*2];
};
struct send_file_ext_packet {
BYTE packet_type;
ULONG transfer_type;
BYTE ascii_flags;
BYTE compression_type;
ULONG disposition_flags;
struct date_time creation_date;
struct date_time revision_date;
ULONG file_size;
BYTE file_sp_length;
BYTE pattern_length;
char file_spec[MAX_FILE_SPEC_LENGTH*2];
};
struct answer_send_packet {
BYTE packet_type;
BYTE start_code;
BYTE compression_type;
BYTE string_length;
BYTE file_spec_length;
ULONG host_error;
char error_string[MAX_ERROR_STRING_LENGTH+MAX_FILE_SPEC_LENGTH];
};
struct get_file_packet {
BYTE packet_type;
WORD transfer_type;
BYTE compression_type;
WORD file_sp_length;
WORD selection_length;
char file_spec[MAX_FILE_SPEC_LENGTH*2];
};
struct data_packet {
BYTE packet_type;
WORD count;
BYTE data[MAX_DATA_LENGTH];
};
struct eof_packet {
BYTE packet_type;
};
#define EOF_PACKET_SIZE 1
struct eot_packet {
BYTE packet_type;
};
#define EOT_PACKET_SIZE 1
struct abort_packet {
BYTE packet_type;
BYTE abort_code;
};
struct cont_msg_packet {
BYTE packet_type;
};
#define CONT_MSG_PACKET_SIZE 1
struct error_packet {
BYTE packet_type;
BYTE reflection_error_code;
WORD string_length;
ULONG host_error;
char error_string[MAX_ERROR_STRING_LENGTH];
};
#define DIR_INFO_DEFAULT (1<<0)
#define DIR_INFO_TREE (1<<1)
#define DIR_INFO_FILES (1<<2)
#define DIR_INFO_PATTERN (1<<3)
#define DIR_SHOW_HIDDEN (1<<0)
#define DIR_NOSHOW_ROOT (1<<1)
struct get_dir_packet {
BYTE packet_type;
BYTE compression;
BYTE info;
WORD flag;
};
struct send_dir_packet {
BYTE packet_type;
BYTE content;
WORD flag;
};
struct answer_dir_packet {
BYTE packet_type;
BYTE start_code;
WORD flag;
};
struct change_dir_packet {
BYTE packet_type;
BYTE level_number;
WORD flag;
BYTE length;
BYTE string[MAX_FILENAME];
};
struct answer_change_packet {
BYTE packet_type;
BYTE result;
WORD flag;
union {
struct {
BYTE update_info;
BYTE level;
BYTE default_length;
BYTE pattern_length;
BYTE string[MAX_FILENAME*2];
} update;
struct {
BYTE error_length;
ULONG host_error;
BYTE error_string[MAX_FILENAME];
} error;
} info;
};
struct delete_file_packet {
BYTE packet_type;
WORD flag;
BYTE length;
BYTE name[MAX_FILENAME];
};
struct answer_delete_packet {
BYTE packet_type;
BYTE result;
WORD flag;
BYTE error_length;
ULONG host_error;
BYTE string[MAX_FILENAME];
};
#define QUALIFY_LEVEL_PATTERN 0x0001
struct qualify_packet {
BYTE packet_type;
WORD flag;
BYTE local_length;
BYTE host_length;
BYTE buffer[MAX_FILENAME*2];
};
struct answer_qualify_packet {
BYTE packet_type;
BYTE start_code;
BYTE host_length;
BYTE buffer[MAX_FILENAME];
};
struct misc_info_packet {
BYTE packet_type;
BYTE info_type;
WORD reserved1;
WORD reserved2;
BYTE info_length;
BYTE info_length2;
WORD info_length3;
char info_data[MAX_ERROR_STRING_LENGTH];
};
#define X_PPL_OK 0
#define X_EOFiles ' '
#define X_MoreFiles '!'
#define X_BAD_PACKET 8
#define X_FILESYS_ERROR 9
#define X_NOUPDATE 66
#define X_ERR 67
#define HIS 0
#define MINE 1
static struct change_dir_packet cdp;
static struct answer_change_packet acp;
static struct delete_file_packet dfp;
static struct answer_delete_packet adp;
static struct data_packet dirdp;
static struct get_dir_packet gdp;
static struct send_dir_packet sdp;
static struct answer_dir_packet adirp;
static struct qualify_packet qp;
static struct answer_qualify_packet aqp;
extern char currentDirectory[MAX_FILENAME+1];
extern char currentFilespec[MAX_FILENAME+1];
extern BYTE currentLevel;
extern BOOL show_hidden;
extern BOOL no_show_root;
extern char *home_directory;
extern char home_root[];
int buildDirectory();
WORD get_word();
enum xfer_return_type xfer_get_directory(xfer_context)
struct xfer_context_block *xfer_context;
{
struct get_dir_packet *packet;
char *getenv();
BYTE *b;
if (xfer_context->xfer_state != X_INACTIVE)
return xfer_improper_state;
xfer_context->xfer_type = 0;
packet = &gdp;
b = (unsigned char *) xfer_context->write_buffer->unix_usr_data;
packet->packet_type = get_byte(&b);
packet->compression = get_byte(&b);
packet->info = get_byte(&b);
packet->flag = get_word(&b);
xfer_context->compression_type = packet->compression;
xfer_context->directory_info = packet->info;
xfer_context->directory_flag = packet->flag;
show_hidden = (xfer_context->directory_flag & DIR_SHOW_HIDDEN);
if (!no_show_root)
no_show_root =
((xfer_context->directory_flag & DIR_NOSHOW_ROOT) ? TRUE : FALSE);
if (no_show_root)
{
if ((home_directory = getenv("HOME")) == NULL)
no_show_root = FALSE;
}
if (createDirectoryList() == FAIL)
return xfer_failure;
getPathDirectory();
if (getFileDirectory() == FAIL)
return xfer_failure;
return xfer_continue_dir(xfer_context);
}
enum xfer_return_type xfer_start_directory(xfer_context)
struct xfer_context_block *xfer_context;
{
struct answer_dir_packet *packet;
BYTE *b;
if (xfer_context->xfer_state != X_SEND_DIR)
{
return xfer_improper_state;
}
packet = &adirp;
b = (unsigned char *) xfer_context->write_buffer->unix_usr_data;
packet->packet_type = get_byte(&b);
packet->start_code = get_byte(&b);
packet->flag = get_word(&b);
if (packet->start_code != RESPONSE_OK)
{
xfer_context->xfer_state = X_INACTIVE;
return xfer_success;
}
xfer_context->xfer_state = X_SEND_DIR_INFO;
xfer_context->directory_offset = 0;
return xfer_send_directory(xfer_context);
}
enum xfer_return_type xfer_send_directory(xfer_context)
struct xfer_context_block *xfer_context;
{
BYTE *b;
struct data_packet *dp;
int status;
dp = &dirdp;
status =
fill_directory_buffer(xfer_context,dp->data,MAX_DATA_LENGTH,&dp->count);
if (status == EOF)
xfer_context->xfer_state = X_DIR_EOF;
dp->packet_type = DATA_MSG;
b = (unsigned char *) xfer_context->read_buffer->unix_usr_data;
put_byte(&b, dp->packet_type);
put_word(&b, dp->count);
put_nbyte(&b, dp->data, dp->count);
xfer_context->read_buffer->unix_data_len =
b - xfer_context->read_buffer->unix_usr_data;
xfer_context->read_length =
xfer_context->read_buffer->unix_data_len + UX_REC_OVHD;
xfer_context->read_ready = TRUE;
return xfer_success;
}
static BYTE *dBuffer;
static WORD dCount;
static WORD dBufferSize;
fill_dbuffer(fn)
char *fn;
{
int len;
len = strlen(fn+1);
if (dCount+len+2 <= dBufferSize)
{
*dBuffer++ = (*fn)-'0';
*dBuffer++ = len;
memcpy(dBuffer, fn+1, len);
dBuffer += len;
dCount += len+2;
return SUCCESS;
}
else
return FAIL;
}
fill_fbuffer(fn)
char *fn;
{
int len;
len = strlen(fn);
if (dCount+len+1 <= dBufferSize)
{
*dBuffer++ = len;
memcpy(dBuffer, fn, len);
dBuffer += len;
dCount += len+1;
return SUCCESS;
}
else
return FAIL;
}
fill_directory_buffer(xfer_context, buffer, buffer_size, count)
struct xfer_context_block *xfer_context;
BYTE *buffer;
WORD buffer_size;
WORD *count;
{
BYTE *b = buffer;
if (xfer_context->directory_info & DIR_INFO_DEFAULT)
{
*count = strlen(currentDirectory)+2;
*b++ = currentLevel-1;
*b++ = strlen(currentDirectory);
strcpy(b, currentDirectory);
xfer_context->directory_info &= ~DIR_INFO_DEFAULT;
return EOF;
}
else if (xfer_context->directory_info & DIR_INFO_PATTERN)
{
if (strcmp(currentFilespec, DEFAULT_FILESPEC) == 0)
{
*count = 1;
*b++ = 0;
}
else
{
*count = strlen(currentFilespec)+1;
*b++ = strlen(currentFilespec);
strcpy(b, currentFilespec);
}
xfer_context->directory_info &= ~DIR_INFO_PATTERN;
return EOF;
}
else if (xfer_context->directory_info & DIR_INFO_TREE)
{
dCount = 0;
dBuffer = buffer;
dBufferSize = buffer_size;
if (NumberofDirectory() > 0)
{
if (ForeachDirectory(xfer_context->directory_offset,
fill_dbuffer) == FAIL)
{
*count = dCount;
xfer_context->directory_offset = CurrentListMember();
return 0;
}
}
*count = dCount;
xfer_context->directory_info &= ~DIR_INFO_TREE;
xfer_context->directory_offset = 0;
return EOF;
}
else if (xfer_context->directory_info & DIR_INFO_FILES)
{
dCount = 0;
dBuffer = buffer;
dBufferSize = buffer_size;
if (NumberofFilename() > 0)
{
if (ForeachFilename(xfer_context->directory_offset, fill_fbuffer) ==
FAIL)
{
*count = dCount;
xfer_context->directory_offset = CurrentListMember();
return 0;
}
}
*count = dCount;
xfer_context->directory_info &= ~DIR_INFO_FILES;
xfer_context->directory_offset = 0;
return EOF;
}
return EOF;
}
BYTE thisLevel;
BYTE thisName[MAX_FILENAME+1];
BYTE thisCD[MAX_FILENAME+1];
static BOOL dirComplete;
buildDirectoryName()
{
BYTE myCD[MAX_FILENAME+1];
if (thisLevel == currentLevel)
{
strcpy(thisCD, currentDirectory);
if (currentDirectory[strlen(currentDirectory)-1] != '/')
strcat(thisCD, "/");
strcat(thisCD, thisName);
}
else
{
if (createDirectoryList() == FAIL)
return FAIL;
getPathDirectory();
thisCD[0] = (BYTE)NULL;
dirComplete = FALSE;
ForeachDirectory(0, buildDirectory);
freeDirectoryList();
if (dirComplete == FALSE)
return (errno = ENOENT, FAIL);
if (no_show_root)
{
strcpy(myCD, thisCD);
strcpy(thisCD, home_root);
if (thisCD[strlen(thisCD)-1] != '/')
strcat(thisCD, "/");
strcat(thisCD, myCD);
}
}
return SUCCESS;
}
enum xfer_return_type xfer_change_default(xfer_context)
struct xfer_context_block *xfer_context;
{
struct change_dir_packet *packet;
struct answer_change_packet *answer;
unsigned char *b;
char *strrchr(), *ptr, *p, *strchr(), *strpbrk(), *getcwd();
if (xfer_context->xfer_state != X_INACTIVE)
return xfer_improper_state;
xfer_context->xfer_type = 0;
packet = &cdp;
answer = &acp;
b = (unsigned char *) xfer_context->write_buffer->unix_usr_data;
packet->packet_type = get_byte(&b);
packet->level_number = get_byte(&b);
packet->flag = get_word(&b);
packet->length = get_byte(&b);
get_nbyte(&b, packet->string, packet->length);
answer->result = X_PPL_OK;
thisLevel = packet->level_number;
memcpy(thisName, packet->string, packet->length);
thisName[packet->length] = (BYTE)NULL;
if (packet->level_number == 255)
{
p = (char *)thisName;
while (TRUE)
{
while (*p && isspace(*p))
p++;
if (*p == (char)NULL)
break;
if ((p = strpbrk(p, ", \t\n\r:")) == NULL)
break;
p++;
if (strchr(p, '/') == NULL)
break;
change_dir_error(answer, EINVAL);
goto send_answer_change;
}
if (strlen(thisName) == 0)
strcpy(thisName, DEFAULT_FILESPEC);
answer->info.update.update_info = DIR_INFO_TREE|DIR_INFO_FILES;
if (isdirectory(thisName))
strcpy(thisCD, DEFAULT_FILESPEC);
else
{
if ((ptr = strrchr(thisName, '/')) == NULL)
{
strcpy(thisCD, thisName);
strcpy(thisName, ".");
answer->info.update.update_info = DIR_INFO_FILES;
}
else
{
strcpy(thisCD, ptr+1);
*ptr = (char)NULL;
}
}
if (chdir(thisName) == -1)
{
change_dir_error(answer, errno);
goto send_answer_change;
}
if (getcwd(currentDirectory, MAX_FILENAME+1) == NULL)
strcpy(currentDirectory, thisName);
getCurrentLevel();
if (strcmp(currentFilespec, thisCD) != 0)
answer->info.update.update_info |= DIR_INFO_PATTERN;
strcpy(currentFilespec, thisCD);
answer->info.update.level = currentLevel-1;
answer->info.update.default_length = strlen(currentDirectory);
strcpy(answer->info.update.string, currentDirectory);
}
else
{
if (buildDirectoryName() == FAIL)
{
change_dir_error(answer, errno);
goto send_answer_change;
}
if (chdir(thisCD) == -1)
{
change_dir_error(answer, errno);
goto send_answer_change;
}
if (strcmp(thisCD, currentDirectory) != 0)
answer->info.update.update_info = DIR_INFO_TREE|DIR_INFO_FILES;
else
answer->info.update.update_info = 0;
strcpy(currentDirectory, thisCD);
getCurrentLevel();
answer->info.update.level = currentLevel-1;
answer->info.update.default_length = strlen(currentDirectory);
strcpy(answer->info.update.string, currentDirectory);
}
if (strcmp(currentFilespec, DEFAULT_FILESPEC) == 0)
{
answer->info.update.pattern_length = 0;
}
else
{
answer->info.update.pattern_length = strlen(currentFilespec);
strcpy(answer->info.update.string+answer->info.update.default_length,
currentFilespec);
}
send_answer_change:
answer->packet_type = ANSWER_CHANGE;
answer->flag = 0;
b = (unsigned char *) xfer_context->read_buffer->unix_usr_data;
put_byte(&b, answer->packet_type);
put_byte(&b, answer->result);
put_word(&b, answer->flag);
if (answer->result == X_PPL_OK)
{
put_byte(&b, answer->info.update.update_info);
put_byte(&b, answer->info.update.level);
put_byte(&b, answer->info.update.default_length);
put_byte(&b, answer->info.update.pattern_length);
if (answer->info.update.default_length ||
answer->info.update.pattern_length)
put_nbyte(&b,answer->info.update.string,
answer->info.update.default_length+
answer->info.update.pattern_length);
}
else
{
put_byte(&b, answer->info.error.error_length);
if (answer->info.error.error_length)
{
put_long(&b, answer->info.error.host_error);
put_nbyte(&b, answer->info.error.error_string,
answer->info.error.error_length-4);
}
}
xfer_context->read_buffer->unix_data_len =
b - xfer_context->read_buffer->unix_usr_data;
xfer_context->read_length =
xfer_context->read_buffer->unix_data_len + UX_REC_OVHD;
xfer_context->read_ready = TRUE;
return(xfer_success);
}
buildDirectory(fn)
char *fn;
{
if ((*fn)-'0' < thisLevel)
{
strcat(thisCD, fn+1);
if (*fn != '0')
strcat(thisCD, "/");
}
else if ((*fn)-'0' == thisLevel && strcmp(fn+1, thisName) == 0)
{
strcat(thisCD, fn+1);
dirComplete = TRUE;
return FAIL;
}
return SUCCESS;
}
change_dir_error(a, status)
struct answer_change_packet *a;
int status;
{
a->result = X_FILESYS_ERROR;
a->info.error.error_length =
get_msg_text(status, a->info.error.error_string)+4;
a->info.error.host_error = status;
}
enum xfer_return_type xfer_delete_files(xfer_context)
struct xfer_context_block *xfer_context;
{
struct delete_file_packet *packet;
struct answer_delete_packet *answer;
unsigned char *b;
packet = &dfp;
answer = &adp;
b = (unsigned char *) xfer_context->write_buffer->unix_usr_data;
packet->packet_type = get_byte(&b);
packet->flag = get_word(&b);
packet->length = get_byte(&b);
get_nbyte(&b, packet->name, packet->length);
packet->name[packet->length] = (char)NULL;
if (unlink(packet->name) == -1)
{
answer->result = X_FILESYS_ERROR;
answer->error_length = get_msg_text(errno, answer->string)+4;
answer->host_error = errno;
}
else
{
answer->result = X_PPL_OK;
answer->error_length = 0;
}
answer->packet_type = ANSWER_DELETE;
answer->flag = 0;
b = (unsigned char *) xfer_context->read_buffer->unix_usr_data;
put_byte(&b, answer->packet_type);
put_byte(&b, answer->result);
put_word(&b, answer->flag);
put_byte(&b, answer->error_length);
if (answer->error_length)
{
put_long(&b, answer->host_error);
put_nbyte(&b,answer->string,answer->error_length-4);
}
xfer_context->read_buffer->unix_data_len =
b - xfer_context->read_buffer->unix_usr_data;
xfer_context->read_length =
xfer_context->read_buffer->unix_data_len + UX_REC_OVHD;
xfer_context->read_ready = TRUE;
return xfer_success;
}
enum xfer_return_type xfer_qualify_file(xfer_context)
struct xfer_context_block *xfer_context;
{
struct qualify_packet *packet;
struct answer_qualify_packet *answer;
unsigned char *b;
BYTE local_name[MAX_FILENAME+1], host_name[MAX_FILENAME+1];
packet = &qp;
answer = &aqp;
b = (unsigned char *) xfer_context->write_buffer->unix_usr_data;
packet->packet_type = get_byte(&b);
packet->flag = get_word(&b);
packet->local_length = get_byte(&b);
packet->host_length = get_byte(&b);
get_nbyte(&b, packet->buffer, packet->local_length+packet->host_length);
memcpy(local_name, packet->buffer, packet->local_length);
local_name[packet->local_length] = NULL;
memcpy(host_name,packet->buffer+packet->local_length,packet->host_length);
host_name[packet->host_length] = NULL;
if (packet->flag | QUALIFY_LEVEL_PATTERN)
{
if (TRUE)
{
answer->start_code = X_ERR;
answer->host_length = 0;
}
else
{
answer->start_code = X_PPL_OK;
answer->host_length = 0;
}
}
answer->packet_type = ANSWER_QUALIFY;
b = (unsigned char *) xfer_context->read_buffer->unix_usr_data;
put_byte(&b, answer->packet_type);
put_byte(&b, answer->start_code);
put_byte(&b, answer->host_length);
if (answer->host_length)
put_nbyte(&b,answer->buffer,answer->host_length);
xfer_context->read_buffer->unix_data_len =
b - xfer_context->read_buffer->unix_usr_data;
xfer_context->read_length =
xfer_context->read_buffer->unix_data_len + UX_REC_OVHD;
xfer_context->read_ready = TRUE;
return xfer_success;
}
enum xfer_return_type xfer_continue_dir(xfer_context)
struct xfer_context_block *xfer_context;
{
struct send_dir_packet *send;
unsigned char *b;
send = &sdp;
xfer_context->xfer_state = X_SEND_DIR;
if (xfer_context->directory_info & DIR_INFO_DEFAULT)
send->content = DIR_INFO_DEFAULT;
else if (xfer_context->directory_info & DIR_INFO_PATTERN)
send->content = DIR_INFO_PATTERN;
else if (xfer_context->directory_info & DIR_INFO_TREE)
send->content = DIR_INFO_TREE;
else if (xfer_context->directory_info & DIR_INFO_FILES)
send->content = DIR_INFO_FILES;
else
{
freeDirectoryList();
return (send_eot(xfer_context));
}
send->packet_type = SEND_DIR;
send->flag = 0;
b = (unsigned char *) xfer_context->read_buffer->unix_usr_data;
put_byte(&b, send->packet_type);
put_byte(&b, send->content);
put_word(&b, send->flag);
xfer_context->read_buffer->unix_data_len =
b - xfer_context->read_buffer->unix_usr_data;
xfer_context->read_length =
xfer_context->read_buffer->unix_data_len + UX_REC_OVHD;
xfer_context->read_ready = TRUE;
return xfer_success;
}
#endif
