#include <stdio.h>
typedef unsigned char BYTE;
extern int errno;
#ifdef GCC_490
#define SYSTEM5
#endif
#define TOCHAR(c) ((c)+32)
#define UNCHAR(c) ((c)-32)
#define ctl(c) ((c)^64)
#define TTY_TYPE 0
#define TIMEOUT_TYPE 2
#include <setjmp.h>
#include <signal.h>
#define MAX_PACKET_SIZE 64
#define MAX_FRAME_SIZE MAX_PACKET_SIZE+10
#define QUIT_NORMAL 0
#define QUIT_SHUTDOWN 1
#define QUIT_ERROR 2
#define QUIT_INTERRUPT_TTY 3
#define QUIT_RETRY_MAX 4
#define QUIT_PROTOCOL 5
#include <fcntl.h>
#define RWAIT 0
#define RFILE 1
#define RDATA 2
#define REOT 3
int read_timer = 7;
int quit_type = 0;
int retry_limit = 10;
int start_char = 1;
int terminator = '\r';
int max_packet = MAX_PACKET_SIZE;
int binary = 0, retry_cnt = 0, in_seq = 0, out_seq = 0;
unsigned int chk2(pkt, len)
BYTE *pkt;
int len;
{
long chk;
for (chk = 0; len-- > 0; pkt++)
chk += *pkt & 0377;
return(chk & 07777);
}
BYTE do_checksum(s, l)
BYTE *s;
int l;
{
unsigned int chk;
chk = chk2(s, l);
chk = (((chk & 0300) >> 6) + chk) & 077;
return((BYTE)chk);
}
BYTE *get_msg_text (msg_id)
int msg_id;
{
#ifdef GCC_490
extern const char *const sys_errlist[];
#else
extern char * sys_errlist[];
#endif
extern int sys_nerr, errno;
static BYTE msg_buf[256];
if (msg_id < sys_nerr)
strcpy(msg_buf, sys_errlist[msg_id]);
else
sprintf(msg_buf, "Error %d", msg_id);
return (msg_buf);
}
#ifndef MODULAR
#ifdef SYSTEM5
#include <termio.h>
#define TTYSTRUCT termio
#else
#include <sgtty.h>
#define TTYSTRUCT sgttyb
#ifdef TIOCGETC
struct tchars otc, ctc;
#endif
#ifdef TIOCGLTC
struct ltchars oltc, cltc;
#endif
#endif
#define PPL_CTRL(X) (X - 'A' + 1)
jmp_buf TimerEnv;
int TimerSet = 0;
int interrupt = 0;
struct TTYSTRUCT cty;
struct TTYSTRUCT oty;
void tty_timeout()
{
alarm(0);
signal(SIGALRM, tty_timeout);
if(TimerSet)
{
TimerSet = 0;
longjmp(TimerEnv,1);
}
quit(QUIT_ERROR);
}
void tty_hangup()
{
quit(QUIT_ERROR);
}
void tty_interrupt()
{
signal(SIGINT, tty_interrupt);
if (interrupt == 1)
quit(QUIT_INTERRUPT_TTY);
interrupt = 1;
}
void tty_continue()
{
alarm(0);
signal(SIGALRM, tty_continue);
}
void tty_flush()
{
#ifdef SYSTEM5
ioctl(0, TCSETAW, &cty);
#else
stty(0, &cty);
#endif
}
void tty_open()
{
signal(SIGHUP, tty_hangup);
signal(SIGINT, tty_interrupt);
signal(SIGQUIT, SIG_IGN);
#ifdef SIGTSTP
signal(SIGTSTP, SIG_IGN);
#endif
alarm(0);
signal(SIGALRM, tty_timeout);
#ifdef SYSTEM5
ioctl(0, TCGETA, &oty);
cty = oty;
cty.c_lflag = ISIG+ICANON;
cty.c_iflag = ICRNL|IGNBRK|IXON|PARMRK;
cty.c_oflag = 0;
cty.c_cc[VINTR] = PPL_CTRL('Y');
cty.c_cc[VQUIT] = cty.c_cc[VERASE] = cty.c_cc[VKILL] = cty.c_cc[VEOF] =
cty.c_cc[VEOL] = '\377';
#ifdef VEOL2
cty.c_cc[VEOL2] = '\377';
#endif
#ifdef VSWTCH
cty.c_cc[VSWTCH] = '\377';
#endif
ioctl(0, TCSETA, &cty);
#else
gtty(0, &oty);
#ifdef TIOCGETC
ioctl(0, TIOCGETC, &otc);
ctc = otc;
ctc.t_intrc = PPL_CTRL('Y');
ctc.t_quitc = ctc.t_eofc = ctc.t_brkc = '\377';
ioctl(0, TIOCSETC, &ctc);
#endif
#ifdef TIOCGLTC
ioctl(0, TIOCGLTC, &oltc);
cltc = oltc;
cltc.t_suspc = cltc.t_dsuspc = cltc.t_rprntc = cltc.t_flushc =
cltc.t_werasc = cltc.t_lnextc = '\377';
ioctl(0, TIOCSLTC, &cltc);
#endif
cty = oty;
cty.sg_flags &= ~ECHO;
cty.sg_erase = cty.sg_kill = '\377';
stty(0, &cty);
#endif
tty_flush();
}
void tty_close()
{
signal(SIGALRM, tty_continue);
alarm(2);
tty_flush();
alarm(0);
#ifdef SYSTEM5
ioctl(0, TCSETA, &oty);
#else
stty(0, &oty);
#ifdef TIOCGETC
ioctl(0, TIOCSETC, &otc);
#endif
#ifdef TIOCGLTC
ioctl(0, TIOCSLTC, &oltc);
#endif
#endif
}
tty_read(buf)
BYTE *buf;
{
int tb_max = 0;
tb_max = read(0, buf, 256);
if (tb_max > 0)
interrupt = 0;
return(tb_max);
}
void tty_write(buf, blen)
char *buf;
int blen;
{
if (blen == -1)
blen = strlen(buf);
if (write(1, buf, blen) < 0)
quit(QUIT_ERROR);
}
ppl_write(fd, buf, len)
int fd, len;
BYTE *buf;
{
int ret;
signal(SIGINT, SIG_IGN);
ret = write(fd, buf, len);
signal(SIGINT, tty_interrupt);
return ret;
}
#include <errno.h>
static BYTE frame[MAX_FRAME_SIZE];
static int nframe;
wait_event()
{
TimerSet = 1;
if (setjmp(TimerEnv))
return (TIMEOUT_TYPE);
alarm(read_timer);
while (1)
{
if ((nframe = tty_read(frame)) > 1)
{
return (nframe--, TTY_TYPE);
}
else if (nframe != -1)
{
return(nframe = 0, TTY_TYPE);
}
else if (nframe == -1 && errno != EINTR)
{
return(nframe = 0, TTY_TYPE);
}
}
}
GetPacket(msg)
BYTE *msg;
{
BYTE *s, *e;
BYTE len, ck;
int i, n_frame;
BYTE packet[MAX_FRAME_SIZE];
if (nframe == 0)
return 0;
for (s = frame, e = frame+nframe; s < e; s++)
if (*s == start_char)
break;
if (s++ == e)
return 0;
if ((len = UNCHAR(*s)) > (e-s))
return 0;
if ((ck = do_checksum(s, len)) != UNCHAR(*(s+len)))
{
return 0;
}
if (len < 3)
return 0;
memcpy(msg, s, 3);
n_frame = dekermitize(s+3, len-3, packet);
if (binary)
{
memcpy(msg+3, packet, n_frame);
return n_frame+3;
}
else
{
s = msg+3;
for (i=0; i<n_frame; i++)
if (packet[i] != '\r')
*s++ = packet[i];
return s - msg;
}
}

dekermitize(b, n, fp)
BYTE *b;
int n;
BYTE *fp;
{
BYTE *end = b+n;
BYTE *f = fp;
BYTE c;
while (b < end)
{
if ((c = *b++) == '&')
{
if ((c = *b++) != '#')
{
c ^= 0x80;
}
else
{
c = *b++;
c ^= ((c == '&' || c == '#') ? 0x80 : 0xC0);
}
}
else if (c == '#')
{
c = *b++;
if (c != '&' && c != '#')
c ^= 0x40;
}
*fp++ = c;
}
return(fp - f);
}
#endif
main(argc, argv)
int argc;
char **argv;
{
int c;
extern int optind;
extern char *optarg;
while ((c = getopt(argc, argv, "D:d:Bb")) != EOF)
switch (c)
{
case 'B':
case 'b':
binary = 1;
case '?':
default:
break;
}
converse();
quit(quit_type);
}
converse()
{
int state = RWAIT, nmsg, event, fd, seq;
BYTE pkt[MAX_FRAME_SIZE];
tty_open();
while (1)
{
event = wait_event();
alarm(0);
switch(event)
{
case TTY_TYPE:
if ((nmsg = GetPacket(pkt)) >= 3)
{
seq = UNCHAR(pkt[1]);
if (pkt[2] == 'E')
{
quit_type = QUIT_SHUTDOWN;
return;
}
else if (seq < in_seq)
send_ack();
else if (seq == in_seq)
{
switch(pkt[2])
{
case 'S':
if (state == RWAIT || state == RFILE)
{
if (UNCHAR(pkt[3]) < max_packet)
max_packet = UNCHAR(pkt[3]);
read_timer = UNCHAR(pkt[4]);
terminator = UNCHAR(pkt[7]);
retry_cnt = 0;
in_seq = ++in_seq & 077;
send_initack();
state = RFILE;
}
else
goto bad_packet;
break;
case 'F':
if (state == RFILE)
{
pkt[nmsg] = '\0';
if ((fd = open(&pkt[3],
O_RDWR+O_CREAT+O_TRUNC, 0644)) == -1)
{
send_error(get_msg_text(errno));
quit_type = QUIT_ERROR;
return;
}
state = RDATA;
up_seq();
}
else
goto bad_packet;
break;
case 'D':
if (state == RDATA)
{
ppl_write(fd, &pkt[3], nmsg-3);
up_seq();
}
else
goto bad_packet;
break;
case 'Z':
if (state == RDATA)
{
close(fd);
state = REOT;
up_seq();
}
else
goto bad_packet;
break;
case 'B':
if (state == REOT)
{
up_seq();
return;
}
else
goto bad_packet;
default:
quit_type = QUIT_PROTOCOL;
goto bad_packet;
}
}
else
goto bad_packet;
}
else
{
goto bad_packet;
}
break;
case TIMEOUT_TYPE:
goto bad_packet;
default:
break;
}
continue;
bad_packet:
retry_cnt++;
if (retry_cnt > retry_limit)
{
quit_type = QUIT_RETRY_MAX;
goto all_done;
}
send_nak();
}
all_done:
disconnect();
}
up_seq()
{
retry_cnt = 0;
in_seq = ++in_seq & 077;
out_seq = ++out_seq & 077;
send_ack();
}
disconnect() { send_eot(); }
send_eot() { send_nodata('B', out_seq); }
send_ack() { send_nodata('Y', out_seq); }
send_nak() { send_nodata('N', in_seq); }
send_nodata(type, seq)
BYTE type;
int seq;
{
BYTE pkt[4];
pkt[0] = TOCHAR(3);
pkt[1] = TOCHAR(seq);
pkt[2] = type;
pkt[3] = TOCHAR(do_checksum(pkt, 3));
write_packet(pkt, 4);
}
send_error(msg)
BYTE *msg;
{
BYTE pkt[MAX_FRAME_SIZE];
int len;
len = 3+strlen(msg);
pkt[0] = TOCHAR(len);
pkt[1] = TOCHAR(out_seq);
pkt[2] = 'E';
strcpy(&pkt[3], msg);
pkt[len] = TOCHAR(do_checksum(pkt, len));
write_packet(pkt, len+1);
}
send_initack()
{
BYTE ack[12];
ack[0] = TOCHAR(11);
ack[1] = TOCHAR(out_seq);
ack[2] = 'Y';
ack[3] = TOCHAR(max_packet);
ack[4] = TOCHAR(read_timer+3);
ack[5] = TOCHAR(0);
ack[6] = ctl(0);
ack[7] = TOCHAR('\r');
ack[8] = '#';
ack[9] = '&';
ack[10] = '1';
ack[11] = TOCHAR(do_checksum(ack, 11));
write_packet(ack, 12);
}
write_packet(pkt, len)
BYTE *pkt;
int len;
{
BYTE packet[MAX_FRAME_SIZE], *p = packet;
*p++ = start_char;
memcpy(p, pkt, len);
p += len;
*p++ = terminator;
tty_write(packet, p-packet);
}
quit(type)
int type;
{
tty_close();
exit(type);
}
