!include <ntwin32.MAK>

# Set ISVLIBS to the directory containing WCPIC32.LIB
# Set ISVINCS to the directory containing WINCPIC.H

ISVLIBS = ..\exe\$(PRODUCTPATH)\ibm\support
ISVINCS = ..\exe\$(PRODUCTPATH)\ibm\support

snalibs  = $(ISVLIBS)\wcpic32.lib
headers  = cpicerrs.h   \
           cpicdefs.h  \
           cpicport.h  \
           cpicinit.h  \
           getopt.h    \
           $(ISVINCS)\wincpic.h 

INCLUDE = $(INCLUDE);$(ISVINCS);

all: aping.exe apingd.exe

clean:  
	rm apingd.obj aping.obj cpicport.obj cpicerr.obj
	rm getopt.obj cpicinit.obj aping.exe apingd.exe

# Update the object files if necessary

apingd.obj: apingd.c $(headers)
    $(cc) $(cflags) $(cvarsdll) $(cdebug) apingd.c

aping.obj: aping.c $(headers)
    $(cc) $(cflags) $(cvarsdll) $(cdebug) aping.c

cpicport.obj: cpicport.c $(headers)
    $(cc) $(cflags) $(cvarsdll) $(cdebug) cpicport.c

cpicerr.obj: cpicerr.c $(headers)
    $(cc) $(cflags) $(cvarsdll) $(cdebug) cpicerr.c

getopt.obj: getopt.c $(headers)
    $(cc) $(cflags) $(cvarsdll) $(cdebug) getopt.c

cpicinit.obj: cpicinit.c $(headers)
    $(cc) $(cflags) $(cvarsdll) $(cdebug) cpicinit.c

aping.exe: aping.obj cpicport.obj cpicerr.obj getopt.obj cpicinit.obj $(snalibs)
    $(link) $(linkdebug) $(conflags) aping.obj cpicport.obj cpicerr.obj getopt.obj cpicinit.obj $(snalibs) $(conlibsdll) -out:aping.exe

apingd.exe: apingd.obj cpicport.obj cpicerr.obj getopt.obj cpicinit.obj $(snalibs)
    $(link) $(linkdebug) $(conflags) apingd.obj cpicport.obj cpicerr.obj getopt.obj cpicinit.obj $(snalibs) $(conlibsdll) advapi32.lib -out:apingd.exe
