/*****************************************************************************
 *
 *  MODULE NAME: CPICCMC.H
 *
 *  COPYRIGHTS:
 *             This module contains code made available by IBM
 *             Corporation on an AS IS basis.  Any one receiving the
 *             module is considered to be licensed under IBM copyrights
 *             to use the IBM-provided source code in any way he or she
 *             deems fit, including copying it, compiling it, modifying
 *             it, and redistributing it, with or without
 *             modifications.  No license under any IBM patents or
 *             patent applications is to be implied from this copyright
 *             license.
 *
 *             A user of the module should understand that IBM cannot
 *             provide technical support for the module and will not be
 *             responsible for any consequences of use of the program.
 *
 *             Any notices, including this one, are not to be removed
 *             from the module without the prior written consent of
 *             IBM.
 *
 *  AUTHOR:    Peter J. Schwaller
 *             CompuServe: 73602,3201
 *             VNET:       PJS at RALVM6           Tie Line: 444-4376
 *             Internet:   pjs@ralvm6.vnet.ibm.com     (919) 254-4376
 *
 *  FUNCTION:  Attempts to isolate the program from differences among
 *             CPI-C include files.
 *
 *  AVAILABILITY:
 *             These sample programs and source are also available on
 *             CompuServe through the APPC Information Exchange.  To get
 *             to the APPC forum just type 'GO APPC' from any CompuServe
 *             prompt.  The samples are available in the Sample Programs
 *             library section.  Just search on the keyword CPICPGMS to
 *             find all the samples in this series.
 *
 *             Updates for the sample programs and support for many more
 *             CPI-C platforms will also be made available on CompuServe.
 *
 *  CHANGE HISTORY:
 *  Date       Description
 *  08/05/92   Version 2.31 of APING, ATELL and AREXEC released to CompuServe.
 *             This version was also distributed at the APPC/APPN Platform
 *             Developer's Conference held in Raleigh, NC.
 *
 *****************************************************************************/

#ifndef INCL_CPICCMC
#define INCL_CPICCMC

#if 1

#if defined(WIN32)
#include <windows.h>
#include "snaeng32\snacpic\wincpic.h"
#else
#include "cpic.h"
#endif


/*
 * Everything below this point is obsolete if we are using the
 * new CPIC.H file.  The following is being kept around for a
 * while in case my CPIC.H is not adopted as the standard CPIC
 * include file.
 */
#else

#ifdef MVS
#include "atbcmc.h"
#define CM_INT32 signed long int
typedef CM_INT32 CM_CONVERSATION_TYPE;
typedef CM_INT32 CM_DATA_RECEIVED_TYPE;
typedef CM_INT32 CM_DEALLOCATE_TYPE;
typedef CM_INT32 CM_ERROR_DIRECTION;
typedef CM_INT32 CM_FILL;
typedef CM_INT32 CM_PREPARE_TO_RECEIVE_TYPE;
typedef CM_INT32 CM_RECEIVE_TYPE;
typedef CM_INT32 CM_REQUEST_TO_SEND_RECEIVED;
typedef CM_INT32 CM_RETURN_CODE;
typedef CM_INT32 CM_RETURN_CONTROL;
typedef CM_INT32 CM_SEND_TYPE;
typedef CM_INT32 CM_STATUS_RECEIVED;
typedef CM_INT32 CM_SYNC_LEVEL;
#define CM_PTR   *
#define CM_SYNC_LVL_NOT_SUPPORTED_LU     (CM_RETURN_CODE) 7
#else
#ifdef OS400
#define cminit CMINIT
#define cmaccp CMACCP
#define cmallc CMALLC
#define cmcfm  CMCFM
#define cmcfmd CMCFMD
#define cmdeal CMDEAL
#define cmecs  CMECS
#define cmect  CMECT
#define cmemn  CMEMN
#define cmepln CMEPLN
#define cmesl  CMESL
#define cmflus CMFLUS
#define cminit CMINIT
#define cmptr  CMPTR
#define cmrcv  CMRCV
#define cmrts  CMRTS
#define cmsct  CMSCT
#define cmsdt  CMSDT
#define cmsed  CMSED
#define cmsend CMSEND
#define cmserr CMSERR
#define cmsf   CMSF
#define cmsld  CMSLD
#define cmsmn  CMSMN
#define cmspln CMSPLN
#define cmsptr CMSPTR
#define cmsrc  CMSRC
#define cmsrt  CMSRT
#define cmssl  CMSSL
#define cmsst  CMSST
#define cmstpn CMSTPN
#define cmtrts CMTRTS
#endif
#ifdef AIX
#define CM_INT32 signed long int
#endif
#include <cmc.h>
#endif
#if defined(OS400) || defined(MVS)
typedef CM_INT32 CM_CONVERSATION_STATE;
/*  conversation_state values  */

#define CM_INITIALIZE_STATE              (CM_CONVERSATION_STATE) 2
#define CM_SEND_STATE                    (CM_CONVERSATION_STATE) 3
#define CM_RECEIVE_STATE                 (CM_CONVERSATION_STATE) 4
#define CM_SEND_PENDING_STATE            (CM_CONVERSATION_STATE) 5
#define CM_CONFIRM_STATE                 (CM_CONVERSATION_STATE) 6
#define CM_CONFIRM_SEND_STATE            (CM_CONVERSATION_STATE) 7
#define CM_CONFIRM_DEALLOCATE_STATE      (CM_CONVERSATION_STATE) 8
#define CM_DEFER_RECEIVE_STATE           (CM_CONVERSATION_STATE) 9
#define CM_DEFER_DEALLOCATE_STATE        (CM_CONVERSATION_STATE) 10
#define CM_SYNC_POINT_STATE              (CM_CONVERSATION_STATE) 11
#define CM_SYNC_POINT_SEND_STATE         (CM_CONVERSATION_STATE) 12
#define CM_SYNC_POINT_DEALLOCATE_STATE   (CM_CONVERSATION_STATE) 13

/* return codes */
#define CM_TAKE_BACKOUT                  (CM_RETURN_CODE) 100
#define CM_DEALLOCATED_ABEND_BO          (CM_RETURN_CODE) 130
#define CM_DEALLOCATED_ABEND_SVC_BO      (CM_RETURN_CODE) 131
#define CM_DEALLOCATED_ABEND_TIMER_BO    (CM_RETURN_CODE) 132
#define CM_RESOURCE_FAIL_NO_RETRY_BO     (CM_RETURN_CODE) 133
#define CM_RESOURCE_FAILURE_RETRY_BO     (CM_RETURN_CODE) 134
#define CM_DEALLOCATED_NORMAL_BO         (CM_RETURN_CODE) 135

/*  sync_level values  */
#define CM_SYNC_POINT                    (CM_SYNC_LEVEL) 2
#endif


#if defined(CM_OS2) || defined(CM_DOS) || defined(CM_VM) || defined(WIN32)
#define SUPPORTS_SETTING_SECURITY
#endif


#if defined(OS2) || defined(FAPI) || defined(DOS) || defined(OS2_20) \
    || defined (AIX) || defined(WIN32)
#define PLN_COULD_REQUIRE_LOWERCASE
#endif

#if defined(OS400) || defined(MVS)
#define  ECS_NOT_SUPPORTED
#endif

#endif

#endif
