#   Makefile accompanying the McGraw-Hill Book:
#    "CPI-C Programming in C:  An Application Developer's Guide to APPC"
#    John Q. Walker II and Peter J. Schwaller, ISBN 0-07911733-3, 1994.
#
#   CLASSIC5.MAK - General-purpose makefile, for NMAKE or MAKE
#
#   PROGRAMS:  PIPE, PIPED, CREDIT, CREDITD, INQUIRY, INQUIRYD,
#              FILEX, FILEXD, UPDATE, UPDATED
#
#   ENVIRONMENT VARIABLES:
#              The following variables must be set for this makefile
#              to work:
#                   CPICCC   - C compiler and its flags
#                   CPICLINK - linker and its flags
#                   CPICLIB  - libraries to be linked with
#                   CPICDEF  - name of definitions file
#
#   RELATED FILES:
#              See file README.TXT for detailed information.
#
#   HOW TO REACH US:
#               John Q.                     Peter
#
#   CompuServe: 72440,1544                  73602,3201
#   Internet:   72440.1544@compuserve.com   73602.3201@compuserve.com
#
#   FOR THE LATEST VERSION OF THIS FILE:
#              "GO APPC" in CompuServe, and download file CPICC1.ZIP
#
#   CHANGE HISTORY:
#   Date       Description
#   05/01/94   version 1.00
#   06/16/98   make file modified for use with WRQ Reflection
#
#   Copyright (c) John Q. Walker II and Peter J. Schwaller 1994
#-----------------------------------------------------------------------

!include <ntwin32.mak>

#-----------------------------------------------------------------------
#  set CPICLIB to the full path and file name of the CPIC library file
#  set INCLUDE to the directory containing wincpic.h
#-----------------------------------------------------------------------
CPICLIB = C:\PROGRA~1\REFLEC~1\IBM\SUPPORT\APPCSDK\WCPIC32.LIB
INCLUDE = .;C:\PROGRA~1\REFLEC~1\IBM\SUPPORT\APPCSDK;$(INCLUDE)

all: pipe.exe    piped.exe     \
     credit.exe  creditd.exe   \
     inquiry.exe inquiryd.exe  \
     filex.exe   filexd.exe    \
     update.exe  updated.exe

#-----------------------------------------------------------------------

.c.obj:
    $(cc) $(cflags) $(cvarsdll) $(cdebug) $*.c

.obj.exe:
    $(link) $(linkdebug) $(conflags) $** $(CPICLIB)  $(conlibsdll) -out:$*.exe

pipe.exe     : pipe.obj docpic.obj

piped.exe    : piped.obj docpic.obj

credit.exe   : credit.obj docpic.obj

creditd.exe  : creditd.obj docpic.obj

inquiry.exe  : inquiry.obj docpic.obj

inquiryd.exe : inquiryd.obj docpic.obj

filex.exe    : filex.obj docpic.obj

filexd.exe   : filexd.obj docpic.obj

update.exe   : update.obj docpic.obj

updated.exe  : updated.obj docpic.obj

