/*  CPI-C utilities file, accompanying the McGraw-Hill Book:
 *   "CPI-C Programming in C:
 *    An Application Developer's Guide to APPC"
 *   by John Q. Walker II and Peter J. Schwaller,
 *   ISBN 0-07-911733-3, 1994.
 *
 *  DOCPIC.H - CPI-C utility routines, header file
 *
 *  RELATED FILES:
 *	    See file README.TXT for detailed information.
 *
 *  HOW TO REACH US:
 *		John Q. Walker II
 *  CompuServe: 72440,1544
 *  Internet:	72440.1544@compuserve.com
 *
 *		Peter J. Schwaller
 *  CompuServe: 73602,3201
 *  Internet:	73602.3201@compuserve.com
 *
 *  FOR THE LATEST VERSION OF THIS FILE:
 *	    "GO APPC" in CompuServe, and download file CPICC1.ZIP
 *
 *  CHANGE HISTORY:
 *  Date       Description
 *  10/15/94   version 1.03
 *
 *  Copyright (c) John Q. Walker II and Peter J. Schwaller 1994
 *-------------------------------------------------------------*/
#ifndef _INC_WINDOWS
typedef enum {FALSE, TRUE} BOOL;
#endif

#ifndef min
#define min(a,b)	(((a) < (b)) ? (a) : (b))
#endif


BOOL
do_receive_pipe(
    unsigned char * conversation_ID,
    unsigned char * data_buffer,
    CM_INT32	    buffer_size,
    CM_INT32 *	    bytes_received);

BOOL
do_receive_credit(
    unsigned char * conversation_ID,
    unsigned char * data_buffer,
    CM_INT32	    buffer_size,
    CM_INT32 *	    bytes_received);

BOOL
do_receive_inquiry(
    unsigned char * conversation_ID,
    unsigned char * data_buffer,
    CM_INT32	    buffer_size,
    CM_INT32 *	    bytes_received);

int
do_confirmed(
    unsigned char *conversation_ID);

int
do_initialize_conversation(
    unsigned char  *conversation_ID,
    unsigned char  *input_string);

int
do_blank_sym_dest_name(
    unsigned char  *cpic_conv_id);

int
do_sync_level_confirm(
    unsigned char  *conversation_ID);

int
do_set_partner_lu_name(
    unsigned char  *conversation_ID,
    unsigned char  *partner_lu_name);

int
do_set_mode_name(
    unsigned char  *conversation_ID,
    unsigned char  *mode_name);

int
do_set_tp_name(
    unsigned char  *conversation_ID,
    unsigned char  *tp_name);

int
do_allocate(
    unsigned char  *conversation_ID);

int
do_accept_conversation(
    unsigned char  *conversation_ID);

void
do_error_cleanup(
    unsigned char  *conversation_ID);

int
do_send_data(
    unsigned char  *conversation_ID,
    unsigned char  *data_buffer,
    CM_INT32	    send_length);

int
do_send_error(
    unsigned char *conversation_ID);

int
do_request_to_send(
    unsigned char  *conversation_ID);

int
do_deallocate(
    unsigned char *conversation_ID);

void
handle_error(
    unsigned char * conversation_ID,
    const char *fmt,
    ...);

void
handle_cpic_rc(
    unsigned char * conversation_ID,
    const CM_RETURN_CODE rc,
    const char *call);

void
show_cpic_return_code(
    CM_RETURN_CODE cpic_return_code);

void
show_status_received(
    CM_STATUS_RECEIVED status_received);

void
show_conversation_state(
    unsigned char *conversation_ID);

void
show_data_received(
    CM_DATA_RECEIVED_TYPE data_received);
