/*---------------------------------------------------------------
 *  Inquiry transaction, client side.
 *  (file INQUIRY.C)
 *-------------------------------------------------------------*/
#include <cpic.h>		/* conversation API library    */
#include <stdarg.h>		/* variable arguments	       */
#include <stdio.h>		/* file I/O		       */
#include <stdlib.h>		/* standard library	       */
#include <string.h>		/* strings and memory	       */

#include "docpic.h"             /* CPI-C do_ procedures        */

/*---------------------------------------------------------------
 *  The larger a receive size you can afford, the faster your
 *  overall performance.
 *-------------------------------------------------------------*/
#define BUFFER_SIZE  (32767)	/* largest possible record     */

int main(int argc, char *argv[])
{
    /*-----------------------------------------------------------
     *	This side sends a single mapped record, then waits to
     *	receive a single mapped record and Deallocate-Normal
     *	from its partner.
     *
     *	We've arbitrarily bounded the size of the incoming
     *	record to 32767 bytes.
     *---------------------------------------------------------*/
    unsigned char   conversation_ID[CM_CID_SIZE];

    CM_INT32	    received_length;
    unsigned char * data_buffer;

    /*-----------------------------------------------------------
     *	Get the symbolic destination from the command line and
     *	initialize a conversation.
     *---------------------------------------------------------*/
    if (argc > 1) { /* is there at least one argument? */
	do_initialize_conversation(conversation_ID,
	    (unsigned char *)argv[1]);
    }
    else {
	handle_error(
	    conversation_ID,
	    "A symbolic destination name must be provided");
    }

    /*-----------------------------------------------------------
     *	Allocate a session for this conversation.
     *---------------------------------------------------------*/
    do_allocate(conversation_ID);

    /*-----------------------------------------------------------
     *	This is where your program prepares the data record
     *	that should be sent on this pipeline transaction.
     *---------------------------------------------------------*/
    {
	unsigned char *send_buffer = (unsigned char *)
	    "Test of the Inquiry transaction";
	CM_INT32 send_length =
	    (CM_INT32)strlen((char *)send_buffer);

	do_send_data(
	    conversation_ID,	/* conversation ID	       */
	    send_buffer,	/* send this buffer	       */
	    send_length);	/* length to send	       */
    }

    /*-----------------------------------------------------------
     *	Allocate enough memory for whatever you expect to
     *	receive from the partner...
     *---------------------------------------------------------*/
    data_buffer = (unsigned char *)malloc((size_t)BUFFER_SIZE);
    if (data_buffer == NULL) {
	handle_error(
	    conversation_ID,
	    "Can't allocate %lu bytes for data_buffer",
	    (unsigned long)BUFFER_SIZE);
    }

    /*-----------------------------------------------------------
     *	The receiving the reply looks like the server side
     *	of the PIPE transaction; we receive a record
     *	and DEALLOCATED_NORMAL.
     *---------------------------------------------------------*/
    do_receive_pipe(
	conversation_ID,
	data_buffer,
	BUFFER_SIZE,		/* buffer size		       */
	&received_length);	/* bytes received	       */

    /*-----------------------------------------------------------
     *	This is where your program processes the received data.
     *	For this example, we just display it, using fwrite().
     *---------------------------------------------------------*/
    (void)fwrite((void *)data_buffer, (size_t)1,
	      (size_t)received_length, stdout);
    (void)printf("\nPress Enter to end the program\n");
    (void)getchar();

    return EXIT_SUCCESS;	/* program was successful      */
}
