/*---------------------------------------------------------------
 *  Inquiry transaction, server side.
 *  (file INQUIRYD.C)
 *-------------------------------------------------------------*/
#include <cpic.h>		/* conversation API library    */
#include <stdio.h>		/* file I/O		       */
#include <stdlib.h>		/* standard library	       */
#include <string.h>		/* strings and memory	       */

#include "docpic.h"             /* CPI-C do_ procedures        */

/*---------------------------------------------------------------
 *  The larger a receive size you can afford, the faster your
 *  overall performance.
 *-------------------------------------------------------------*/
#define BUFFER_SIZE  (32767)	/* largest possible record     */

int main(void)
{
    /*-----------------------------------------------------------
     *	The client side should have sent a single record, and
     *	then be waiting for a record in reply and Deallocate.
     *
     *	We've arbitrarily bounded the size of the incoming
     *	record to 32767 bytes.
     *---------------------------------------------------------*/
    unsigned char   conversation_ID[CM_CID_SIZE];
    CM_RETURN_CODE  cpic_return_code;

    CM_INT32	    received_length;
    unsigned char * data_buffer;

    /*-----------------------------------------------------------
     *	Accept a new conversation from the client.
     *
     *	We assume (without explicitly checking) that the
     *	conversation_type is MAPPED and the sync_level is NONE.
     *	The TP definition should restrict these values, which
     *	will then be verified by the attach manager.
     *---------------------------------------------------------*/
    do_accept_conversation(conversation_ID);

    /*-----------------------------------------------------------
     *	Allocate enough memory for whatever you expect to
     *	receive from the partner...
     *---------------------------------------------------------*/
    data_buffer = (unsigned char *)malloc((size_t)BUFFER_SIZE);
    if (data_buffer == NULL) {
	handle_error(
	    conversation_ID,
	    "Can't allocate %lu bytes for data_buffer",
	    (unsigned long)BUFFER_SIZE);
    }

    /*-----------------------------------------------------------
     *	Call do_receive_inquiry(), which expects a single
     *	data record followed by a status_received value of
     *	CM_SEND_RECEIVED.
     *---------------------------------------------------------*/
    do_receive_inquiry(
	conversation_ID,
	data_buffer,
	BUFFER_SIZE,		/* buffer size		       */
	&received_length);	/* bytes received	       */

    /*-----------------------------------------------------------
     *	When we get here, we should be in Send state.
     *---------------------------------------------------------*/
    if (received_length > 0) {
	(void)fwrite((void *)data_buffer, 1,
		  (size_t)received_length, stdout);
    }
    else {
	handle_error(
	    conversation_ID,
	    "No data was sent");
    }
    (void)printf("\nPress Enter to reply and deallocate\n");

    (void)getchar();

    /*-----------------------------------------------------------
     *	Couple a Deallocate Flush with this single Send_Data(),
     *	using a Set_Send_Type() call.
     *---------------------------------------------------------*/
    {
	CM_SEND_TYPE send_type = CM_SEND_AND_DEALLOCATE;

	cmsst(			/* Set Send Type	       */
	    conversation_ID,	/* conversation ID	       */
	    &send_type, 	/* set the send type	       */
	    &cpic_return_code); /* return code from this call  */
	if (cpic_return_code != CM_OK) {
	    handle_cpic_rc(
		conversation_ID,
		cpic_return_code,
		"CMSST");
	}
    }

    /*-----------------------------------------------------------
     *	This is where your program prepares the data reply
     *	that should be sent on this inquiry transaction.
     *---------------------------------------------------------*/
    {
	unsigned char *send_buffer = (unsigned char *)
	    "Reply to the Inquiry transaction";
	CM_INT32 send_length =
	    (CM_INT32)strlen((char *)send_buffer);

	do_send_data(
	    conversation_ID,	/* conversation ID	       */
	    data_buffer,	/* send this buffer	       */
	    send_length);	/* length to send	       */
    }

    return EXIT_SUCCESS;	/* program was successful      */
}
