/*---------------------------------------------------------------
 *  Pipeline transaction, client side.
 *  (file PIPE.C)
 *-------------------------------------------------------------*/
#include <cpic.h>		/* conversation API library    */
#include <stdarg.h>		/* variable arguments	       */
#include <stdio.h>		/* file I/O		       */
#include <stdlib.h>		/* standard library	       */
#include <string.h>		/* strings and memory	       */

#include "docpic.h"             /* CPI-C do_ procedures        */

int main(int argc, char *argv[])
{
    /*-----------------------------------------------------------
     *	This side sends a single mapped record, followed by a
     *	Deallocate Flush.
     *---------------------------------------------------------*/
    CM_RETURN_CODE  cpic_return_code;
    unsigned char   conversation_ID[CM_CID_SIZE];

    /*-----------------------------------------------------------
     *	Get the symbolic destination from the command line and
     *	initialize a conversation.
     *---------------------------------------------------------*/
    if (argc > 1) { /* is there at least one argument? */
	do_initialize_conversation(conversation_ID,
	    (unsigned char *)argv[1]);
    }
    else {
	handle_error(
	    conversation_ID,
	    "A symbolic destination name must be provided");
    }

    /*-----------------------------------------------------------
     *	Allocate a session for this conversation.
     *---------------------------------------------------------*/
    do_allocate(conversation_ID);

    /*-----------------------------------------------------------
     *	Couple a Deallocate Flush with this single Send_Data(),
     *	using a Set_Send_Type() call.
     *---------------------------------------------------------*/
    {
	CM_SEND_TYPE send_type = CM_SEND_AND_DEALLOCATE;

	cmsst(			/* Set Send Type	       */
	    conversation_ID,	/* conversation ID	       */
	    &send_type, 	/* set the send type	       */
	    &cpic_return_code); /* return code from this call  */
	if (cpic_return_code != CM_OK) {
	    handle_cpic_rc(
		conversation_ID,
		cpic_return_code,
		"CMSST");
	}
    }

    /*-----------------------------------------------------------
     *	This is where your program prepares the data record
     *	that should be sent on this pipeline transaction.
     *---------------------------------------------------------*/
    {
	unsigned char *data_buffer = (unsigned char *)
	    "Test of the Pipeline transaction";
	CM_INT32 send_length =
	    (CM_INT32)strlen((char *)data_buffer);

	do_send_data(
	    conversation_ID,	/* conversation ID	       */
	    data_buffer,	/* send this buffer	       */
	    send_length);	/* length to send	       */
    }

    return EXIT_SUCCESS;	/* program was successful      */
}
