/*---------------------------------------------------------------
 *  Pipeline transaction, server side.
 *  (file PIPED.C)
 *-------------------------------------------------------------*/
#include <cpic.h>		/* conversation API library    */
#include <limits.h>		/* integer bounds	       */
#include <stdio.h>		/* file I/O		       */
#include <stdlib.h>		/* standard library	       */
#include <string.h>		/* strings and memory	       */

#include "docpic.h"             /* CPI-C do_ procedures        */

/*---------------------------------------------------------------
 *  The larger a receive size you can afford, the faster your
 *  overall performance.
 *-------------------------------------------------------------*/
#define BUFFER_SIZE  (32767)	/* largest possible record     */

int main(void)
{
    /*-----------------------------------------------------------
     *	The client side should have sent a single record,
     *	followed by a Deallocate Flush.
     *
     *	We've arbitrarily bounded the size of the incoming
     *	record to 32767 bytes.
     *---------------------------------------------------------*/
    unsigned char   conversation_ID[CM_CID_SIZE];

    CM_INT32	    received_length;
    unsigned char * data_buffer;


    /*-----------------------------------------------------------
     *	Accept a new conversation from the client.
     *
     *	We assume (without explicitly checking) that the
     *	conversation_type is MAPPED and the sync_level is NONE.
     *	The TP definition should restrict these values, which
     *	will then be verified by the attach manager.
     *---------------------------------------------------------*/
    do_accept_conversation(conversation_ID);

    /*-----------------------------------------------------------
     *	Allocate enough memory for whatever you expect to
     *	receive from the partner.
     *---------------------------------------------------------*/
    data_buffer = (unsigned char *)malloc((size_t)BUFFER_SIZE);
    if (data_buffer == NULL) {
	handle_error(
	    conversation_ID,
	    "Can't get %u bytes of memory for a data_buffer",
	    (unsigned)BUFFER_SIZE);
    }

    /*-----------------------------------------------------------
     *	Call do_receive_pipe(), which expects a single
     *	data record followed by a return code of
     *	CM_DEALLOCATED_NORMAL.
     *---------------------------------------------------------*/
    do_receive_pipe(
	conversation_ID,
	data_buffer,
	BUFFER_SIZE,		/* buffer size		       */
	&received_length);	/* bytes received	       */

    /*-----------------------------------------------------------
     *	This is where your program processes the received data.
     *	For this example, we just display it, using fwrite().
     *---------------------------------------------------------*/
    if (received_length > 0) {
	(void)fwrite((void *)data_buffer, 1,
		  (size_t)received_length, stdout);
    }
    else {
	handle_error(
	    conversation_ID,
	    "No data was sent");
    }

    (void)printf("\nPress Enter to end the program\n");
    (void)getchar();

    return EXIT_SUCCESS;	/* program was successful      */
}
