#ifndef _LOGON_H
#define _LOGON_H
#include <windows.h>
#include <stdio.h>
#include "..\r8Class.h"
// Portable macros for splitting WM_COMMAND into components -- WIN32
#define GET_WM_COMMAND_CMD(wp, lp)  HIWORD(wp)
#define GET_WM_COMMAND_ID(wp, lp)   LOWORD(wp)
#define GET_WM_COMMAND_HWND(wp, lp) (HWND)(lp)


#define IDC_CONNECTBTN                  1001
#define IDC_DISCONNECTBTN               1002
#define IDC_USERID                      1003
#define IDC_PASSWORD                    1004
#define IDC_SESSIONLIST                 1005
#define IDC_GROUP                      -1
#define IDC_SESSIONTEXT                 1006
#define IDC_USERIDTEXT                  1007
#define IDC_PASSWORDTEXT                1008

#define FST_NOACTIVESESSION				0
#define FST_LINKEDTOSESSION				1
#define	FST_HOSTSPECIFIED				2	
#define	FST_CONNECTED					3
#define	FST_LOGGED						4
#define MAX_STRLEN						128	
#define MAX_NUMSESSIONS					20		

///////////////////////////////////
typedef char SESSIONS [MAX_NUMSESSIONS] [MAX_STRLEN] ;

UINT 	initSessions(HWND);
UINT 	getApplicationState();
void 	SendLogon(HWND);
void 	ConnectToHost(HWND);
void 	DisplayRCErrors (HWND, WORD) ;
UINT 	SetupListBox(HWND, SESSIONS, UINT);
void 	sizeCombo(HWND, UINT);
void 	setButtons (HWND, UINT);


// SessionManager Class....
// This class grabs the running Reflection sessions creating an array of
// CReflectionIBM objects.  This array is kept current by calling the
// Refresh method.

typedef struct _SesData {
	CHAR sSettingsFile[MAX_STRLEN];
	CHAR sOleServerName[MAX_STRLEN];
	CReflectionIBM *pRIBM;
	BOOL bValid;
} SESDATA, *PSESDATA;

class SessionManager {
	SESDATA m_ses[MAX_NUMSESSIONS];
	CReflectionIBM *m_pCurrentSession;
public:
	SessionManager();
	~SessionManager();
	LPSTR GetSettingsFile(UINT index);
	UINT GetNumSessions();
	
	BOOL SetCurrentSession(UINT index);
	CReflectionIBM *GetCurrentSession();

	// Returns True if the index has changed
	BOOL Refresh();
	// Returns True if the Reflection object passed is still valid
	BOOL IsSessionValid(CReflectionIBM *p);
};

#endif // End #indef _LOGON_H
