//_____________________________________________________________________________
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
/*
 * Name...........	Mail.cpp
 * Description....	Sample code demonstrating Reflection APIs. This program
 *					demonstrates how to:
 *					1) Link to a reflection session
 *					2) synchronize with the session
 *					3) Screen scrape host information
 *					3) create a custom interface to navigate around the host
 *
 *					This program uses the CReflectionIBM COM wrapper class in the
 *					IBM/Samples/CPP directory.  The member functions used in this program
 *					are:
 *	 				
 *					TransmitANSI(...)
 *					TransmitTerminalKey(...)
 *					WaitForEvent(...)
 *					GetDisplayText(...)
 *					MoveCursor(...)
 * 					GetErrorString(...)
 *					SetNumeric(...)
 *					get_DisplayRows(...)
 *					get_DisplayColumns (...)
 *
 *					To link to the session this program uses the SessionEnumerator
 *					class found in the header file.
 *
 * Compatibility..	32Bit
 * System.........	Windows
 * Language.......	CPP
 * Copyright......	(c) 1998 WRQ Inc.
*/
//_____________________________________________________________________________
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#include <windows.h>
#include <string.h>
#include <stdio.h>         
#include "..\r8Class.h"
#include "mail.h" 

HINSTANCE hInst;
CReflectionIBM *g_pRIBM;

char szAppName[]    = "Mail";
char szDlgName[]    = "SUMMARY";
char szRAppName[]   = "REFLECTION_EIGHT";

//////////////////////////////////////////////////////////
int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
    HWND      hWnd;
    MSG       msg;
    DLGPROC   dialogProc;

    hInst = hInstance;
	g_pRIBM = NULL;
  
    dialogProc = (DLGPROC) MakeProcInstance((FARPROC)WndProc, hInst);
    if (!(hWnd = CreateDialog(hInstance, szDlgName, 0, dialogProc)))
        return(FALSE);

    ShowWindow(hWnd, nCmdShow);

    if (DialogBox(hInst,"LINK", hWnd,  (DLGPROC)LinkDlgProc) == 0) {
        PostMessage(hWnd, (WM_USER + 100), 0, 0);
        while (GetMessage(&msg,	 (HWND) NULL, (UINT) NULL, (UINT) NULL)) {
            if (!IsDialogMessage(hWnd, &msg)) {
                TranslateMessage(&msg);
                DispatchMessage(&msg);
            }
        }
	}
	DestroyWindow(hWnd);
	FreeProcInstance(dialogProc);
	return(msg.wParam);
}
//////////////////////////////////////////////////////////
long CALLBACK WndProc(HWND hSummaryDlg, unsigned message ,WPARAM wParam ,LPARAM lParam)
{
	WORD 			uId 	= GET_WM_COMMAND_ID  (wParam, lParam);		
	WORD 			uCmd 	= GET_WM_COMMAND_CMD (wParam, lParam);		

    static int 		tabStopArray[] = {42,78,203};

    switch (message) {
            
        case WM_INITDIALOG:            
            SendDlgItemMessage(hSummaryDlg,IDC_SUM_MESSAGES_LST,LB_SETTABSTOPS,3, (LPARAM) (LPINT) tabStopArray);
            break;
    	case (WM_USER + 100):
            RptApiErr(hSummaryDlg,  (WORD) g_pRIBM->SetNumeric(rcTypeAhead, rcNo));
            HourglassCursor(TRUE);
    	    if (NavigateToMailScreen(hSummaryDlg))
                DisplayMessageSummary(hSummaryDlg);
            else {
                MsgBox(hSummaryDlg,
                	  "Unable to process mail. Must begin at the OfficeVision \"Work with Mail\" screen.",
                	  "C/Reflection Mail Error",
                	  MB_OK);
                DestroyWindow(hSummaryDlg);
            }
            HourglassCursor(FALSE);
            break;
            
        case WM_COMMAND:   
        	switch (uId) {

                case IDC_SUM_MESSAGES_LST: 
                    if (uCmd == LBN_SELCHANGE)
                        HandleButtons(hSummaryDlg);
                    if (uCmd == LBN_DBLCLK)
                        PostMessage(hSummaryDlg,
                                   WM_COMMAND,
                                   IDC_SUM_VIEW_BTN,
                                   0L);
                    break;

	            case IDC_SUM_REFRESH_BTN:  
                    HourglassCursor(TRUE);
                    if (NavigateToMailScreen(hSummaryDlg))
                        DisplayMessageSummary(hSummaryDlg);
                    else {
                        MsgBox(hSummaryDlg,
                              "Unable to process mail. Must begin at the OfficeVision \"Work with Mail\" screen.",
                              "C/Reflection Mail Error",
                              MB_OK);
                        DestroyWindow(hSummaryDlg);
                    }
                    HourglassCursor(FALSE);
                    break;
	            
	            case IDC_SUM_EXIT_BTN:
                    DestroyWindow(hSummaryDlg);
                    break;
	            
	            case IDC_SUM_VIEW_BTN:     
                    HourglassCursor(TRUE);
                    if (LocateMessage(hSummaryDlg)) {
                        RptApiErr(hSummaryDlg, (WORD) g_pRIBM->TransmitANSI("5"));
                        RptApiErr(hSummaryDlg, (WORD) g_pRIBM->TransmitTerminalKey(rcIBMEnterKey));
                        RptApiErr(hSummaryDlg, (WORD) g_pRIBM->WaitForEvent(rcKbdEnabled,
                                                              "0:60",
                                                              "0:1",
                                                              1,
                                                              1));
                        DialogBox(hInst,            
                                 "VIEW", 
                                 hSummaryDlg,       
                                 (DLGPROC)ViewDlgProc);
                    }
                    else
  		                MsgBox(hSummaryDlg,
                                  "Unable to view - message not found.",
                                  "C/Reflection Mail Error",
                                  MB_OK);
                    break;
	            
	            case IDC_SUM_DELETE_BTN:   

                    HourglassCursor(TRUE);
                    if (LocateMessage(hSummaryDlg)) {
                        RptApiErr(hSummaryDlg, (WORD) g_pRIBM->TransmitANSI("4"));
                        RptApiErr(hSummaryDlg, (WORD) g_pRIBM->TransmitTerminalKey(rcIBMEnterKey));
                        RptApiErr(hSummaryDlg, (WORD) g_pRIBM->WaitForEvent(rcKbdEnabled,
                                                             "0:60",
                                                             "0:1",
                                                             1,
                                                             1));
                        RptApiErr(hSummaryDlg, (WORD) g_pRIBM->TransmitTerminalKey(rcIBMEnterKey));
                        RptApiErr(hSummaryDlg, (WORD) g_pRIBM->WaitForEvent(rcKbdEnabled,
                                                             "0:60",
                                                             "0:1",
                                                             1,
                                                             1));
                        DisplayMessageSummary(hSummaryDlg);
                    }
                    else
  		                MsgBox(hSummaryDlg,
                                  "Unable to delete - message not found.",
                                  "C/Reflection Mail Error",
                                  MB_OK);
                    HourglassCursor(FALSE);
                    break;
	            
               case IDC_SUM_SEND_BTN:
                    HourglassCursor(TRUE);
                    DialogBox(hInst,            
                             "SEND", 
                             hSummaryDlg,       
                             (DLGPROC)SendDlgProc);
                    break;
	            
	            default:
                    return (FALSE);  
			}
            break;

        case WM_CLOSE:

            DestroyWindow(hSummaryDlg);
            break;

        case WM_DESTROY:

            PostQuitMessage(0);
            break;
         
        default:

            return (FALSE);                 
  
    }
    return (TRUE);                          
}                 

SessionEnumerator *pSes = NULL;

//////////////////////////////////////////////////////////
BOOL CALLBACK LinkDlgProc(HWND hLinkDlg ,unsigned message, WORD wParam, LONG lParam)
{	
	WORD 			uId 	= GET_WM_COMMAND_ID  (wParam, lParam);		
	WORD 			uCmd 	= GET_WM_COMMAND_CMD (wParam, lParam);		

	switch (message) {

        case WM_INITDIALOG:
			pSes = new SessionEnumerator();
            InitializeLinkDialog(hLinkDlg, pSes);
            break;

        case WM_COMMAND:

        	switch (uId){

                case IDC_LNK_LINK_BTN:   
                    if ( pSes ) {
						LinkToReflection(hLinkDlg, pSes);
						delete pSes;
						pSes = NULL;
						EndDialog(hLinkDlg, 0); 
					}
					else {
						EndDialog(hLinkDlg, 1);
					}
                    break;
	            
	            case IDC_LNK_CANCEL_BTN:
					if ( pSes ) {
						delete pSes;
						pSes = NULL;
					}
                    EndDialog(hLinkDlg,1); 
                    break;
	            
	            default:
                    return (FALSE);     
			}
            break;

        case WM_CLOSE:
			if ( pSes ) {
				delete pSes;
				pSes = NULL;
			}
            EndDialog(hLinkDlg, 1); 
            break;
         
         default:

            return (FALSE);             
  
    }
    return  (TRUE);                     
}                 


//////////////////////////////////////////////////////////
BOOL CALLBACK ViewDlgProc(HWND hViewDlg, unsigned message ,WORD wParam ,LONG lParam)
{
	WORD 			uId 	= GET_WM_COMMAND_ID  (wParam, lParam);		
	WORD 			uCmd 	= GET_WM_COMMAND_CMD (wParam, lParam);		

    switch (message) {

        case WM_INITDIALOG:

            InitializeViewDialog(hViewDlg);
            HourglassCursor(FALSE);
            break;

        case WM_COMMAND:   

        	switch (uId) {

                case IDC_VEW_DONE_BTN:  
                    HourglassCursor(TRUE);
					RptApiErr(hViewDlg, (WORD) g_pRIBM->TransmitTerminalKey(rcIBMEnterKey));
                    RptApiErr(hViewDlg, (WORD) g_pRIBM->WaitForEvent(rcKbdEnabled,
                                                      "0:60",
                                                      "0:1",
                                                      1,
                                                      1));

                    HourglassCursor(FALSE);
                    EndDialog(hViewDlg, 0); 
                    break;
	            
	            default:
                    return (FALSE);     
			}
            break;

        case WM_CLOSE:

            EndDialog(hViewDlg,
            0); 
            break;
         
         default:

            return (FALSE);             
  
    }
    return  (TRUE);                     
}                 


//////////////////////////////////////////////////////////
BOOL CALLBACK SendDlgProc(HWND hSendDlg,unsigned message ,WORD wParam ,LONG lParam)
{
	WORD 			uId 	= GET_WM_COMMAND_ID  (wParam, lParam);		
	WORD 			uCmd 	= GET_WM_COMMAND_CMD (wParam, lParam);		

    switch (message) {

        case WM_INITDIALOG:

            InitializeSendDialog(hSendDlg);
            HourglassCursor(FALSE);
            break;

        case WM_COMMAND:   

        	switch (uId) {

                case IDC_SND_POST_BTN:  
                    HourglassCursor(TRUE);
                    PostMailMessage(hSendDlg);
                    HourglassCursor(FALSE);
	            
                case IDC_SND_CLEAR_BTN:  
                    SendDlgItemMessage(hSendDlg,
                                    IDC_SND_USERID_TXT,
                                    WM_SETTEXT,
                                    0,
                                    (LPARAM) (LPSTR) "");
                    SendDlgItemMessage(hSendDlg,
                                    IDC_SND_ADDRESS_TXT,
                                    WM_SETTEXT,
                                    0,
                                    (LPARAM) (LPSTR) "");
                    SendDlgItemMessage(hSendDlg,
                                    IDC_SND_MESSAGE_TXT,
                                    WM_SETTEXT,
                                    0,
                                    (LPARAM) (LPSTR) "");
                    break;
	            
                case IDC_SND_DONE_BTN:  
                    
                    HourglassCursor(TRUE);
                    RptApiErr(hSendDlg, (WORD) g_pRIBM->TransmitTerminalKey(rcIBMF3Key));
                    RptApiErr(hSendDlg, (WORD) g_pRIBM->WaitForEvent(rcKbdEnabled,
                                                  "0:60",
                                                  "0:1",
                                                  1,
                                                  1));
                    RptApiErr(hSendDlg, (WORD) g_pRIBM->TransmitANSI("2"));
                    RptApiErr(hSendDlg, (WORD) g_pRIBM->TransmitTerminalKey(rcIBMEnterKey));
                    RptApiErr(hSendDlg, (WORD) g_pRIBM->WaitForEvent(rcKbdEnabled,
                                                  "0:60",
                                                  "0:1",
                                                   1,
                                                  1));
                    HourglassCursor(FALSE);
                    EndDialog(hSendDlg, 0); 
                    break;
	            
	            default:
                    return (FALSE);     
			}
            break;

        case WM_CLOSE:

            EndDialog(hSendDlg,
            0); 
            break;
         
         default:

            return (FALSE);            
  
    }
    return  (TRUE);                     
}                 


//////////////////////////////////////////////////////////
BOOL AtWorkWithMailScreen(HWND hWnd)
{ 
    int     nFoundRow;
    int     nFoundCol;

    if (FindDisplayString(hWnd,
                         "Work with Mail",
                         1,
                         1,
                         &nFoundRow,
                         &nFoundCol))
        if (nFoundRow == 1) 
            if (FindDisplayString(hWnd,
                                 "Type options below",
                                 3,
                                 1,
                                 &nFoundRow,
                                 &nFoundCol))
                if (nFoundRow == 3)
                    if (FindDisplayString(hWnd,
                                         "Opt  Status      User ID   Address",
                                         8,
                                         1,
                                         &nFoundRow,
                                         &nFoundCol))
                        if (nFoundRow == 8)
                            return(TRUE);
    return(FALSE);
}

//////////////////////////////////////////////////////////
void PostMailMessage(HWND hWnd)

{ 
    HWND    hControl;

    int     nFoundRow;
    int     nFoundCol;

    DWORD   dwCount;

    char    sUserId[10];
    char    sAddress[10];
    char    sMessage[204];

    BOOL    bAtMyScreen;

    bAtMyScreen = FALSE;

    if (FindDisplayString(hWnd,
                         "Send Message",
                         1,
                         1,
                         &nFoundRow,
                         &nFoundCol))
        if (nFoundRow == 1) 
            if (FindDisplayString(hWnd,
                                 "Type message and information below.",
                                 3,
                                 1,
                                 &nFoundRow,
                                 &nFoundCol))
                if (nFoundRow == 3)
                    if (FindDisplayString(hWnd,
                                         "-----Addressees------",
                                         12,
                                         1,
                                         &nFoundRow,
                                         &nFoundCol))
                        if (nFoundRow == 12)
                            bAtMyScreen = TRUE;

    if (!bAtMyScreen) {
  		MsgBox(hWnd,
              "Unable to process mail. Expected OfficeVision \"Send Message\" screen.",
              "C/Reflection Mail Error",
              MB_OK);
        return;
    }

	hControl = GetDlgItem(hWnd, IDC_SND_USERID_TXT);
	dwCount = SendMessage(hControl,
                         WM_GETTEXT,
                         sizeof(sUserId),
                         (LPARAM) (LPSTR) sUserId);
    if ((dwCount < 1) || (dwCount > 8)) {
  		MsgBox(hWnd,
              "User ID must be between one and eight characters in length.",
              "C/Reflection Mail Error",
              MB_OK);
        return;
    }

	hControl = GetDlgItem(hWnd, IDC_SND_ADDRESS_TXT);
	dwCount = SendMessage(hControl,
                         WM_GETTEXT,
                         sizeof(sAddress),
                         (LPARAM) (LPSTR) sAddress);
    if  (dwCount > 8) {
  		MsgBox(hWnd,
                  "Address must be between one and eight characters in length.",
                  "C/Reflection Mail Error",
                  MB_OK);
        return;
    }

	hControl = GetDlgItem(hWnd, IDC_SND_MESSAGE_TXT);
	dwCount = SendMessage(hControl,
                         WM_GETTEXT,
                         sizeof(sMessage),
                         (LPARAM) (LPSTR) sMessage);
    if (dwCount > 202) {
  		MsgBox(hWnd,
                  "Message length exceeds 202 characters. Message will be truncated.",
                  "C/Reflection Mail Error",
                  MB_OK);
    }

    RptApiErr(hWnd, (WORD) g_pRIBM->MoveCursor(6, 4));
    RptApiErr(hWnd, (WORD) g_pRIBM->TransmitANSI(sMessage));
    RptApiErr(hWnd, (WORD) g_pRIBM->MoveCursor(14, 2));
    RptApiErr(hWnd, (WORD) g_pRIBM->TransmitANSI(sUserId));
    RptApiErr(hWnd, (WORD) g_pRIBM->MoveCursor(14, 15));
    RptApiErr(hWnd, (WORD) g_pRIBM->TransmitANSI(sAddress));

    RptApiErr(hWnd, (WORD) g_pRIBM->TransmitTerminalKey(rcIBMEnterKey));
    RptApiErr(hWnd, (WORD) g_pRIBM->WaitForEvent(rcKbdEnabled,
                                  "0:60",
                                  "0:1",
                                  1,
                                  1));

    if (FindDisplayString(hWnd,
                         "To send, press F10.",
                         24,
                         1,
                         &nFoundRow,
                         &nFoundCol)) {
        RptApiErr(hWnd, (WORD) g_pRIBM->TransmitTerminalKey(rcIBMF10Key));
        RptApiErr(hWnd, (WORD) g_pRIBM->WaitForEvent(rcKbdEnabled,
                                      "0:60",
                                      "0:1",
                                      1,
                                      1));
    }
    else {
        RptApiErr(hWnd, (WORD) g_pRIBM->TransmitTerminalKey(rcIBMFieldExitKey));
        RptApiErr(hWnd, (WORD) g_pRIBM->TransmitTerminalKey(rcIBMFieldExitKey));
        RptApiErr(hWnd, (WORD) g_pRIBM->TransmitTerminalKey(rcIBMBacktabKey));
        RptApiErr(hWnd, (WORD) g_pRIBM->TransmitTerminalKey(rcIBMBacktabKey));
  		MsgBox(hWnd,
                  "Message was undeliverable - please check User ID and Address.",
                  "C/Reflection Mail Error",
                  MB_OK);
    }
}

//////////////////////////////////////////////////////////
BOOL NavigateToMailScreen(HWND hWnd)
{ 
    int     nFoundRow;
    int     nFoundCol;

    BOOL    bAtMyScreen;  

    bAtMyScreen = AtWorkWithMailScreen(hWnd);

    if (!bAtMyScreen)
        if (FindDisplayString	(hWnd,
        						"OfficeVision/400",
        						1,
        						1,
        						&nFoundRow,
        						&nFoundCol))
            if (nFoundRow == 1) 
                if (FindDisplayString	(hWnd,"2. Mail",
                						6,
                						1,
                						&nFoundRow,
                						&nFoundCol))
                    if (nFoundRow == 6)
                        if (FindDisplayString	(hWnd,"3. Send message",
                        						7,
                        						1,
                        						&nFoundRow,
                        						&nFoundCol))
                            if (nFoundRow == 7) {
                                RptApiErr(hWnd, (WORD) g_pRIBM->TransmitTerminalKey(rcIBMTabKey));
                                RptApiErr(hWnd, (WORD) g_pRIBM->TransmitANSI("2"));
                                RptApiErr(hWnd, (WORD) g_pRIBM->TransmitTerminalKey(rcIBMEnterKey));
								RptApiErr(hWnd, (WORD) g_pRIBM->WaitForEvent(rcKbdEnabled,"0:60","0:1",1,1));
                                bAtMyScreen = TRUE;
                            }

    if (!bAtMyScreen)
        if (FindDisplayString	(hWnd,"Send Message",
        						1,
        						1,
        						&nFoundRow,
        						&nFoundCol))
            if (nFoundRow == 1) 
                if (FindDisplayString	(hWnd,
                						"Type message and information below.",
                						3,
                						1,
                						&nFoundRow,
                						&nFoundCol))
                    if (nFoundRow == 3)
                        if (FindDisplayString	(hWnd,
                        						"-----Addressees------",
                        						12,
                        						1,
                        						&nFoundRow,
                        						&nFoundCol))
                            if (nFoundRow == 12) {
                                RptApiErr(hWnd, (WORD) g_pRIBM->TransmitTerminalKey(rcIBMF3Key));
                                RptApiErr(hWnd, (WORD) g_pRIBM->WaitForEvent(rcKbdEnabled,"0:60","0:1",1,1));
                                RptApiErr(hWnd, (WORD) g_pRIBM->TransmitANSI("2"));
                                RptApiErr(hWnd, (WORD) g_pRIBM->TransmitTerminalKey(rcIBMEnterKey));
                                RptApiErr(hWnd, (WORD) g_pRIBM->WaitForEvent(rcKbdEnabled,"0:60","0:1",1,1));
                                bAtMyScreen = TRUE;
                            }

    if (!bAtMyScreen)
        if (FindDisplayString(hWnd,
                             "AS/400 Main Menu",
                             1,
                             1,
                             &nFoundRow,
                             &nFoundCol))
            if (nFoundRow == 1) 
                if (FindDisplayString(hWnd,
                                    "Selection or command",
                                     19,
                                     1,
                                     &nFoundRow,
                                     &nFoundCol))
                    if (nFoundRow == 19)
                        if (FindDisplayString(hWnd,
                                            "===>",
                                             20,
                                             1,
                                             &nFoundRow,
                                             &nFoundCol))
                            if (nFoundRow == 20) {
                                RptApiErr(hWnd, (WORD) g_pRIBM->TransmitTerminalKey(rcIBMTabKey));
                                RptApiErr(hWnd, (WORD) g_pRIBM->TransmitANSI("STROFC"));
                                RptApiErr(hWnd, (WORD) g_pRIBM->TransmitTerminalKey(rcIBMEnterKey));
                                RptApiErr(hWnd, (WORD) g_pRIBM->WaitForEvent(rcKbdEnabled,
                                                              "0:60",
                                                              "0:1",
                                                              1,
                                                              1));
                                RptApiErr(hWnd, (WORD) g_pRIBM->TransmitANSI("2"));
                                RptApiErr(hWnd, (WORD) g_pRIBM->TransmitTerminalKey(rcIBMEnterKey));
                                RptApiErr(hWnd, (WORD) g_pRIBM->WaitForEvent(rcKbdEnabled,
                                                              "0:60",
                                                              "0:1",
                                                              1,
                                                              1));
                                bAtMyScreen = TRUE;
                            }
    return(bAtMyScreen);
}

//////////////////////////////////////////////////////////
BOOL LocateMessage(HWND hWnd)

{ 
	DWORD   dwRow;
	DWORD   dwIndex;

    BOOL    bMatchFound;
    BOOL    bAtSummaryBottom;

    char    sListBuf[(SUMMARY_WIDTH + 1)];
    char    sLineBuf[(SUMMARY_WIDTH + 1)];
    DWORD   dwLineBufSize;

    int     nFoundRow;
    int     nFoundCol;
        dwIndex = SendDlgItemMessage(hWnd,
                                IDC_SUM_MESSAGES_LST,
                                LB_GETCURSEL,
                                0,
                                0L);
    SendDlgItemMessage(hWnd,
                      IDC_SUM_MESSAGES_LST,
                      LB_GETTEXT,
                      (WPARAM) dwIndex,
                      (LPARAM) (LPCSTR) sListBuf);

    
    dwRow = FIRST_MESSAGE_ROW;
    bMatchFound = FALSE;

    do {
	    dwLineBufSize = SUMMARY_WIDTH;
        RptApiErr(hWnd, (WORD) g_pRIBM->GetDisplayText(dwRow,
                                        SUMMARY_COLUMN,
                                        (LPSTR) sLineBuf,
                                        (LPDWORD) &dwLineBufSize));
	    sLineBuf[dwLineBufSize] = 0;       

        if (strncmp(sLineBuf, "MESSAGE", strlen("MESSAGE")) == 0) {
            TabifyMessageSummary(sLineBuf);
            if (strcmp(&sLineBuf[USER_ID_OFFSET], sListBuf) == 0)
                bMatchFound = TRUE;
        }
        dwRow++;
    }
    while ((!bMatchFound) && (dwRow <= LAST_MESSAGE_ROW));
    
    if (!bMatchFound) {
        RptApiErr(hWnd, (WORD) g_pRIBM->TransmitTerminalKey(rcIBMF10Key));
        RptApiErr(hWnd, (WORD) g_pRIBM->WaitForEvent(rcKbdEnabled,
                                      "0:60",
                                      "0:1",
                                      1,
                                      1));
        bAtSummaryBottom = FALSE;
        do {
            dwRow = FIRST_MESSAGE_ROW;
            do {
	            dwLineBufSize = SUMMARY_WIDTH;
                RptApiErr(hWnd, (WORD) g_pRIBM->GetDisplayText(dwRow,
                                                SUMMARY_COLUMN,
                                                (LPSTR) sLineBuf,
                                                (LPDWORD) &dwLineBufSize));
	            sLineBuf[dwLineBufSize] = 0;       

                if (strncmp(sLineBuf, "MESSAGE", strlen("MESSAGE")) == 0) {
                    TabifyMessageSummary(sLineBuf);
                    if (strcmp(&sLineBuf[USER_ID_OFFSET], sListBuf) == 0)
                        bMatchFound = TRUE;
                }
                dwRow++;
            }
            while ((!bMatchFound) && (dwRow <= LAST_MESSAGE_ROW));

            if (!bMatchFound) {
                if (FindDisplayString(hWnd,
                                     "Bottom",
                                     BOTTOM_STRING_ROW,
                                     BOTTOM_STRING_COLUMN,
                                     &nFoundRow,
                                     &nFoundCol)) {
                    if ((nFoundRow == BOTTOM_STRING_ROW) && (nFoundCol == BOTTOM_STRING_COLUMN))
                        bAtSummaryBottom = TRUE;
                }
                else {
                    RptApiErr(hWnd, (WORD) g_pRIBM->TransmitTerminalKey(rcIBMPageDownKey));
                    RptApiErr(hWnd, (WORD) g_pRIBM->WaitForEvent(rcKbdEnabled,
                                                  "0:60",
                                                  "0:1",
                                                  1,
                                                  (DWORD)1));
                }
            }
        }
        while ((!bMatchFound) && (!bAtSummaryBottom));
    }
    
    if (bMatchFound) {
        RptApiErr(hWnd, (WORD) g_pRIBM->MoveCursor((dwRow - 1), 2));
        return(TRUE);
    }
    else
        return(FALSE);
}

//////////////////////////////////////////////////////////
void DisplayMessageSummary(HWND hWnd)

{
    HWND    hControl;

    int     nFoundRow;
    int     nFoundCol;
	DWORD   dwRowCount;

    BOOL    bFound;
    BOOL    bAtMyScreen;  
    BOOL    bAtSummaryBottom;  

    char    sLineBuf[256];
    DWORD   dwSize;

    SendDlgItemMessage(hWnd,
	                  IDC_SUM_MESSAGES_LST,
	                  LB_RESETCONTENT,
                      0,
                      0L);
    bAtMyScreen = AtWorkWithMailScreen(hWnd);

    if (bAtMyScreen) {
        RptApiErr(hWnd, (WORD) g_pRIBM->TransmitTerminalKey(rcIBMF10Key));
        RptApiErr(hWnd, (WORD) g_pRIBM->WaitForEvent(rcKbdEnabled,
                                      "0:60",
                                      "0:1",
                                      1, 1));
    }
    else {
  		MsgBox(hWnd,
  			  "Unable to process mail. Must begin at the OfficeVision \"Work with Mail\" screen.",
  			  "C/Reflection Mail Error",
  			  MB_OK);
        return;
    }

    bAtSummaryBottom = FALSE;
    SendDlgItemMessage(hWnd,
                      IDC_SUM_MESSAGES_LST,
                      WM_SETREDRAW,
                      FALSE,
                      0);
    do {
        for(dwRowCount = FIRST_MESSAGE_ROW; dwRowCount <= LAST_MESSAGE_ROW; dwRowCount++) {
		    dwSize = SUMMARY_WIDTH;
            RptApiErr(hWnd, (WORD) g_pRIBM->GetDisplayText(dwRowCount,
                                            SUMMARY_COLUMN,
                                            (LPSTR) sLineBuf,
                                            (LPDWORD) &dwSize));
		    sLineBuf[dwSize] = 0;
            if (strncmp(sLineBuf, "MESSAGE", strlen("MESSAGE")) == 0) {

                TabifyMessageSummary(sLineBuf);

                SendDlgItemMessage(hWnd,
                                  IDC_SUM_MESSAGES_LST,
                                  LB_ADDSTRING,
                                  0,
                                  (LPARAM) (LPSTR) &sLineBuf[USER_ID_OFFSET]);
            }
        }

        bFound = FindDisplayString(hWnd,
                                  "Bottom",
                                  BOTTOM_STRING_ROW,
                                  BOTTOM_STRING_COLUMN,
                                  &nFoundRow,
                                  &nFoundCol);
        if ((bFound) && (nFoundRow == BOTTOM_STRING_ROW) && (nFoundCol == BOTTOM_STRING_COLUMN))
            bAtSummaryBottom = TRUE;
        else {
            RptApiErr(hWnd, (WORD) g_pRIBM->TransmitTerminalKey(rcIBMPageDownKey));
            RptApiErr(hWnd, (WORD) g_pRIBM->WaitForEvent(rcKbdEnabled, "0:60", "0:1", 1, 1));
        }
    }
    while (!bAtSummaryBottom);
  
    SendDlgItemMessage(hWnd,
                    IDC_SUM_MESSAGES_LST,
                    WM_SETREDRAW, TRUE, 0);

	hControl = GetDlgItem(hWnd, IDC_SUM_MESSAGES_LST);

    InvalidateRect(hControl, NULL, TRUE);

    UpdateWindow(hControl);

    HandleButtons(hWnd);

    RptApiErr(hWnd, (WORD) g_pRIBM->TransmitTerminalKey(rcIBMF10Key));
    RptApiErr(hWnd, (WORD) g_pRIBM->WaitForEvent(rcKbdEnabled, "0:60", "0:1", 1, 1));
}
 

//////////////////////////////////////////////////////////
void HandleButtons(HWND hWnd)

{
    BOOL haveSelection;
    HWND hControl;
												 
    haveSelection = (SendDlgItemMessage(hWnd,IDC_SUM_MESSAGES_LST,LB_GETCURSEL,0,0) != LB_ERR);

	hControl = GetDlgItem(hWnd, IDC_SUM_VIEW_BTN);
    EnableWindow(hControl, haveSelection);

	hControl = GetDlgItem(hWnd, IDC_SUM_DELETE_BTN);
    EnableWindow(hControl, haveSelection);
}

//////////////////////////////////////////////////////////
BOOL FindDisplayString(HWND hWnd, char * szSoughtString ,int nStartRow ,int nStartCol ,int * nFoundRow ,int * nFoundCol)
{ 
    DWORD   dwMaxRow;
    DWORD   dwMaxCol;
    DWORD   dwDisplayRow;
    DWORD   dwDisplayCol;
    char    sDisplayBuf[256];
    DWORD   dwDisplayBufSize;
    char *  sSubString;
            
    RptApiErr(hWnd, (WORD) g_pRIBM->get_DisplayRows((LPDWORD) &dwMaxRow));
	RptApiErr(hWnd, (WORD) g_pRIBM->get_DisplayColumns((LPDWORD) &dwMaxCol));

    if ((nStartRow >= 1) && (nStartCol >= 1) && (nStartRow <= (int) dwMaxRow) && (nStartCol <= (int) dwMaxCol)) {
        dwDisplayRow = nStartRow;
        dwDisplayCol = nStartCol;
        do {
            dwDisplayBufSize = (dwMaxCol - dwDisplayCol) + 1;
            RptApiErr(hWnd, (WORD) g_pRIBM->GetDisplayText(dwDisplayRow, dwDisplayCol,(LPSTR) sDisplayBuf,(LPDWORD) &dwDisplayBufSize));
            sDisplayBuf[dwDisplayBufSize] = 0;
            if (sSubString = strstr(sDisplayBuf, szSoughtString)) {
                * nFoundRow = (int) dwDisplayRow;
                * nFoundCol = (int) (dwDisplayCol + (sSubString - sDisplayBuf));
                return(TRUE);
            }
            dwDisplayRow++;
            dwDisplayCol = 1;
        }
        while (dwDisplayRow <= dwMaxRow);
    }
    return(FALSE);
}

//////////////////////////////////////////////////////////
void RptApiErr(HWND hWnd , WORD rcError)
{
    DWORD dwSize = 128;
    char  sErrorString[128];
    char  sErrorMsg[128];

    if (rcError) {
    
        if (g_pRIBM->GetErrorString(rcError,
  	                        (LPSTR) sErrorString,
							(LPDWORD) &dwSize)) {
			if ( rcError == rcRteNoStartup ) {
				wsprintf(sErrorString, "No Session was Found, someone killed it");
				wsprintf(sErrorMsg, "Error #%d - ", rcError);
  				strcat(sErrorMsg, sErrorString);
  				MsgBox(hWnd,
  					  sErrorMsg,
  					  "Reflection API Error",
  					  MB_OK);
				DestroyWindow(hWnd);
			}
			else
				wsprintf(sErrorString, "Could not retrieve error text:%i", rcError);
			
		}
  		else
  	    	sErrorString[dwSize] = 0;   // Null-terminate

        wsprintf(sErrorMsg, "Error #%d - ", rcError);
  	    strcat(sErrorMsg, sErrorString);
  	    MsgBox(hWnd,
  			  sErrorMsg,
  		      "Reflection API Error",
  		      MB_OK);
    }
}


//////////////////////////////////////////////////////////
BOOL LinkToReflection(HWND hWnd, SessionEnumerator *pSes)

{
	WORD    rcError = FALSE;
	DWORD	dwCount;
	DWORD	dwCurrentSelection;

    dwCount = SendDlgItemMessage(hWnd, IDC_LNK_SESSIONS_LST,LB_GETCOUNT,0,0L);
    if (dwCount) {
        dwCurrentSelection = SendDlgItemMessage(hWnd,IDC_LNK_SESSIONS_LST,LB_GETCURSEL,0,0L);
	    g_pRIBM = pSes->GetASession(dwCurrentSelection);
	}
	else
        rcError = TRUE;
   
   return (!rcError);
}

//////////////////////////////////////////////////////////
void HourglassCursor (BOOL bDisplayHourglass)
{
   static HCURSOR hOldCursor = NULL;
   static int nCalls = 0;

   if (bDisplayHourglass) {
       if (nCalls++)
           return;
       hOldCursor = SetCursor (LoadCursor (NULL, IDC_WAIT));
       ShowCursor (TRUE);
   }
   else {
       if (!nCalls)
           return;
       if (!(--nCalls)) {
           SetCursor (hOldCursor);
           hOldCursor = NULL;
           ShowCursor (FALSE);
       }
   }
}

//////////////////////////////////////////////////////////
void PositionChildDialog(HWND hWnd)

{ 
    RECT rcSummary;
    RECT rcChild;

    int nLeft;
    int nTop;
    int nWidth;
    int nHeight;

    GetWindowRect(GetParent(hWnd),
                 &rcSummary);
    GetWindowRect(hWnd,
                 &rcChild);

    nWidth = rcChild.right - rcChild.left;
    nHeight = rcChild.bottom - rcChild.top;
    nLeft = rcSummary.left + (((rcSummary.right - rcSummary.left) - nWidth) / 2);
    nTop = rcSummary.top - ((rcSummary.bottom - rcSummary.top) / 3);
    if (nTop < 0)
        nTop = rcSummary.bottom - ((rcSummary.bottom - rcSummary.top) / 3);
     
    MoveWindow(hWnd,nLeft,nTop,nWidth,nHeight,FALSE); 
}

//////////////////////////////////////////////////////////
void TabifyMessageSummary(char * szSumMsg)

{ 
    int     lastChar;

    lastChar = ADDRESS_OFFSET;
    while (--lastChar >= USER_ID_OFFSET && szSumMsg[lastChar] == ' ')
    	szSumMsg[lastChar] = '\0';
    lastChar = DESCRIPTION_OFFSET;
    while (--lastChar >= ADDRESS_OFFSET && szSumMsg[lastChar] == ' ')
    	szSumMsg[lastChar] = '\0';
    lastChar = DATE_OFFSET;
    while (--lastChar >= DESCRIPTION_OFFSET && szSumMsg[lastChar] == ' ')
    	szSumMsg[lastChar] = '\0';

    strcat(szSumMsg, "\t");
    strcat(szSumMsg, &szSumMsg[ADDRESS_OFFSET]);
    strcat(szSumMsg, "\t");
    strcat(szSumMsg, &szSumMsg[DESCRIPTION_OFFSET]);
    strcat(szSumMsg, "\t");
    strcat(szSumMsg, &szSumMsg[DATE_OFFSET]);
}

//////////////////////////////////////////////////////////
int  MsgBox(HWND hwndParent, LPCSTR lpszText, LPCSTR lpszTitle ,UINT fuStyle)
{ 
    HourglassCursor(FALSE);
    return(MessageBox(hwndParent,lpszText,lpszTitle,fuStyle));
}

//////////////////////////////////////////////////////////
void InitializeLinkDialog(HWND hWnd, SessionEnumerator *pSes)

{
	DWORD   dwWindowId;
	DWORD   dwSize;
	char	sConfigName[MAX_STRLEN];

	PositionChildDialog(hWnd);
    dwSize 	   = 256;
	dwWindowId = 0;
	
	UINT num = pSes->GetNumSessions();

	for ( UINT i = 0; i < num; ++i ) {
		strcpy(sConfigName, pSes->GetSettingsFile(i));
		SendDlgItemMessage(hWnd,IDC_LNK_SESSIONS_LST,LB_INSERTSTRING,(WPARAM)-1, (LPARAM) (LPSTR) sConfigName);
	}

	if ( !num ) {
		EnableWindow(GetDlgItem(hWnd, IDC_LNK_LINK_BTN), FALSE);
		MsgBox(hWnd, "Pleas start a session before using this program", "No Links found", MB_OK);
	}
	SendDlgItemMessage(hWnd,IDC_LNK_SESSIONS_LST,LB_SETCURSEL,0,0L);
}


//////////////////////////////////////////////////////////
void InitializeViewDialog(HWND hWnd) 
{ 
	char    sMessageBuf[(MAX_MESSAGE_SIZE + 1)];
	char    sLineBuf[(80 + 1)];
	DWORD   dwLineBufSize;

	PositionChildDialog(hWnd);	   
	
    sMessageBuf[0] = 0;
    dwLineBufSize = 77;
    RptApiErr(hWnd, (WORD) g_pRIBM->GetDisplayText(8,
                                    4,
                                    (LPSTR) sLineBuf,
                                    (LPDWORD) &dwLineBufSize));
	sLineBuf[dwLineBufSize] = 0;       // Null-terminate
    strcat(sMessageBuf,
          sLineBuf);

	dwLineBufSize = 80;
    RptApiErr(hWnd, (WORD) g_pRIBM->GetDisplayText(9,
                                    1,
                                    (LPSTR) sLineBuf,
                                    (LPDWORD) &dwLineBufSize));
	sLineBuf[dwLineBufSize] = 0;       
    strcat(sMessageBuf,
          sLineBuf);

	dwLineBufSize = 45;
    RptApiErr(hWnd, (WORD) g_pRIBM->GetDisplayText(10,
                                    1,
                                    (LPSTR) sLineBuf,
                                    (LPDWORD) &dwLineBufSize));
	sLineBuf[dwLineBufSize] = 0;       
    strcat(sMessageBuf,
          sLineBuf);

    SendDlgItemMessage(hWnd,
                      IDC_VEW_MESSAGE_TXT,
                      WM_SETTEXT,
                      0,
                      (LPARAM) (LPSTR) sMessageBuf);
}


//////////////////////////////////////////////////////////
void InitializeSendDialog(HWND hWnd)
{ 
	PositionChildDialog(hWnd);	   

    if (!AtWorkWithMailScreen(hWnd))
  		MsgBox(hWnd,
                  "Unable to process mail. Must begin at the OfficeVision \"Work with Mail\" screen.",
                  "",
                  MB_OK);
    else {
        RptApiErr(hWnd, (WORD) g_pRIBM->TransmitTerminalKey(rcIBMF3Key));
        RptApiErr(hWnd, (WORD) g_pRIBM->WaitForEvent(rcKbdEnabled,
                                      "0:60",
                                      "0:1",
                                      1,
                                      1));
        RptApiErr(hWnd, (WORD) g_pRIBM->TransmitANSI("3"));
        RptApiErr(hWnd, (WORD) g_pRIBM->TransmitTerminalKey(rcIBMEnterKey));
        RptApiErr(hWnd, (WORD) g_pRIBM->WaitForEvent(rcKbdEnabled,
                                      "0:60",
                                      "0:1",
                                       1,
                                      1));
    }
}

// Creates an array of CReflectionIBM objects
SessionEnumerator::SessionEnumerator()
{
	int i;
	for ( i = 0; i < MAX_NUMSESSIONS; ++i ) {
		*m_ses[i].sSettingsFile = NULL;
		*m_ses[i].sOleServerName = NULL;
		m_ses[i].bValid = FALSE;
		m_ses[i].pRIBM = NULL;
	}
	
	CHAR buffer[MAX_STRLEN];
	DWORD len = MAX_STRLEN;
	m_ses[0].pRIBM = new CReflectionIBM();
	WORD ret = m_ses[0].pRIBM->GetSession("RIBM");
	for ( i = 0; ret != rcRteNoSessionFound && i < MAX_NUMSESSIONS;
			ret = m_ses[i].pRIBM->GetSession("RIBM") ) {
		sprintf(buffer, "%04i", i);
		m_ses[i].pRIBM->put_OLEServerName(buffer);
		strcpy(m_ses[i].sOleServerName, buffer);
		len = MAX_STRLEN;
		m_ses[i].pRIBM->get_SettingsFile(buffer, &len);
		strcpy(m_ses[i].sSettingsFile, buffer);
		m_ses[i].bValid = TRUE;
		m_ses[++i].pRIBM = new CReflectionIBM();
	}
	delete m_ses[i].pRIBM;
	m_ses[i].pRIBM = NULL;
}

// Destroys the valid CReflectionIBM objects
SessionEnumerator::~SessionEnumerator() {
	for (int i = 0; i < MAX_NUMSESSIONS; ++i ) {
		if ( m_ses[i].bValid ) {
			m_ses[i].pRIBM->put_OLEServerName("RIBM");
			m_ses[i].bValid = FALSE;
			delete m_ses[i].pRIBM;
			m_ses[i].pRIBM = NULL;
		}
	}
}

// Returns the number of valid reflection objects
UINT SessionEnumerator::GetNumSessions() {
	UINT count = 0;
	for (int i = 0; i < MAX_NUMSESSIONS; ++i) {
		if ( m_ses[i].bValid ) {
			++count;
		}
	}
	return count;
}

// Returns the session referenced by the given index marking
// this session as invalid for the session manager to manage.
CReflectionIBM *SessionEnumerator::GetASession(UINT index) {
	UINT count = 0;
	for (int i = 0; i < MAX_NUMSESSIONS; ++i) {
		if ( m_ses[i].bValid ) {
			if ( count++ == index ) {
				m_ses[i].bValid = FALSE;
				m_ses[i].pRIBM->put_OLEServerName("RIBM");
				return m_ses[i].pRIBM;
			}
		}
	}
	return NULL;
}

// Gets the settings file referenced by the nth index
LPSTR SessionEnumerator::GetSettingsFile(UINT index) {
	UINT count = 0;
	for (int i = 0; i < MAX_NUMSESSIONS; ++i) {
		if ( m_ses[i].bValid ) {
			if ( count++ == index ) {
				return m_ses[i].sSettingsFile;
			}
		}
	}
	return NULL;
}
