#ifndef _MAIL_H
#define _MAIL_H

#include <windows.h>

// Macros for splitting WM_COMMAND into components
#define GET_WM_COMMAND_CMD(wp, lp)  HIWORD(wp)
#define GET_WM_COMMAND_ID(wp, lp)   LOWORD(wp)
#define GET_WM_COMMAND_HWND(wp, lp) (HWND)(lp)

//
// Summary dialog controls
//
#define IDC_SUM_USERID_LBL              1001
#define IDC_SUM_ADDRESS_LBL             1002
#define IDC_SUM_DESCRIPTION_LBL         1003
#define IDC_SUM_DATE_LBL                1004
#define IDC_SUM_MESSAGES_LST            1005
#define IDC_SUM_VIEW_BTN                1006
#define IDC_SUM_DELETE_BTN              1007
#define IDC_SUM_SEND_BTN                1008
#define IDC_SUM_REFRESH_BTN             1009
#define IDC_SUM_EXIT_BTN                1010
//
// Link dialog controls
//
#define IDC_LNK_SESSIONS_LST            1011
#define IDC_LNK_LINK_BTN                1012
#define IDC_LNK_CANCEL_BTN              1013
//
// View dialog controls
//
#define IDC_VEW_MESSAGE_TXT             1014
#define IDC_VEW_DONE_BTN                1015
//
// Send dialog controls
//
#define IDC_SND_USERID_LBL              1016
#define IDC_SND_ADDRESS_LBL             1017
#define IDC_SND_USERID_TXT              1018
#define IDC_SND_ADDRESS_TXT             1019
#define IDC_SND_MESSAGE_TXT             1020
#define IDC_SND_POST_BTN                1021
#define IDC_SND_CLEAR_BTN               1022
#define IDC_SND_DONE_BTN                1023
//
// Host display constants
//
#define FIRST_MESSAGE_ROW               9
#define LAST_MESSAGE_ROW                20
#define MAX_MESSAGE_SIZE                202
#define BOTTOM_STRING_ROW               21
#define BOTTOM_STRING_COLUMN            74
#define SUMMARY_COLUMN                  7
#define SUMMARY_WIDTH                   73
#define USER_ID_OFFSET                  12
#define ADDRESS_OFFSET                  22
#define DESCRIPTION_OFFSET              32
#define DATE_OFFSET                     65

#define MAX_STRLEN						128	
#define MAX_NUMSESSIONS					20		

//
// Function prototypes
//
class SessionEnumerator;

int WINAPI WinMain(HINSTANCE, HINSTANCE, LPSTR, int);
long CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK LinkDlgProc(HWND, UINT, WORD, LONG);
BOOL CALLBACK ViewDlgProc(HWND, UINT, WORD, LONG);
BOOL CALLBACK SendDlgProc(HWND, UINT, WORD, LONG);
BOOL AtWorkWithMailScreen(HWND);
void PostMailMessage(HWND);
BOOL NavigateToMailScreen(HWND);
BOOL LocateMessage(HWND);
void DisplayMessageSummary(HWND);
BOOL FindDisplayString(HWND, char *, int, int, int *, int *);
void RptApiErr(HWND, WORD);
BOOL LinkToReflection(HWND, SessionEnumerator *pSes);
void InitializeLinkDialog(HWND, SessionEnumerator *pSes);
void InitializeViewDialog(HWND);
void InitializeSendDialog(HWND);
void HandleButtons(HWND);
void PositionChildDialog(HWND);
void TabifyMessageSummary(char *);
int  MsgBox(HWND, LPCSTR, LPCSTR, UINT);
void HourglassCursor(BOOL);

// SessionEnumerator class....
// This class creates a list of the running reflection sessions.

typedef struct _SesData {
	CHAR sSettingsFile[MAX_STRLEN];
	CHAR sOleServerName[MAX_STRLEN];
	CReflectionIBM *pRIBM;
	BOOL bValid;
} SESDATA, *PSESDATA;

class SessionEnumerator {
	SESDATA m_ses[MAX_NUMSESSIONS];
public:
	SessionEnumerator();
	~SessionEnumerator();
	LPSTR GetSettingsFile(UINT index);
	UINT GetNumSessions();

	// Lets the caller be responsible for deleting The CReflectionIBM object
	CReflectionIBM *GetASession(UINT index);
};

#endif // End #indef _MAIL_H
