//
//	 r8class.h
//

#ifndef __r8class_H_
#define __r8class_H_

/*------------------------------------------------------------------------
 * Name..........r8class.h
 * Description...Header for Reflection Class
 * Language......C++
 * Copyright.....(c) 1998-2001 WRQ Inc.
 *------------------------------------------------------------------------
 */
#include <windows.h>
#include "r8oledcl.h"

//_________________________________________________________________________
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
/*
 *	CReflectionIBM
 *	--------------
 *
 *	Purpose: 
 *		This class encapsulates the COM calls required to access Reflection 
 *		for IBM using a C++ class. All of the commands and properties are 
 *		implemented as public members. 
 *
 *	How to compile: 
 *		1) Include r8Class.h in your code
 *		2) Add r8class.cpp to your project
 *
 *		The two sample files, LOGON and MAIL provided with Reflection for 
 *		IBM use this class and can be used as examples.
 *
 *	Documentation:
 *		Documentation for all the public functions can be found with the 
 *		online documentation. Please feel free to refer to them for additional
 *		information.	
 *		
 */
//_________________________________________________________________________
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// RIBM objects support this interface
const GUID IID_DRIBMAPP = { 0xecf246da,  0xe871, 0x11d2, { 0x8c, 0xc2, 0x00, 0xc0, 0x4f, 0x72, 0xc0, 0xed } };

class CReflectionIBM {
private:
	// Pointer to the IDispatch pointer for current instance.
	LPDISPATCH m_pDisp;

	// Pointer to stream containing marshalled IDispatch pointer
	LPSTREAM   m_pStream;
	
	// VARIANT packing Helper Methods
	void CopyToVariant(
			VARIANTARG *pvArg, 
			LPSTR lpInputStr);
	void CopyToVariant(
			VARIANTARG *pvArg, 
			LONG lArg);
	void CopyToVariant(
			VARIANTARG *pvArg, 
			DWORD dwArg);
	void CopyToVariant(
			VARIANTARG *pvArg, 
			LPDWORD lpdwArg);
	void CleanUpStringVariant(
			VARIANTARG *pvArg);
	void InitVariants(
			VARIANTARG *pvArgs, 
			UINT uNum);
	void GetNumericReturn(
			VARIANTARG *pvRet, 
			LPDWORD pdwRet);
	void GetStringReturn(
			VARIANTARG *pvRet, 
			LPSTR lpszArg, 
			LPDWORD pdwLen);

	// InvokeMethodHelper: executes a method using IDispatch's Invoke
	WORD InvokeMethodHelper(
			LPOLESTR pwszCmdName,	// Wide string containing name of Command.
			VARIANTARG *pvArgs,		// Array of input VARIANTS
			UINT uNumArgs,			// Number of Variants Inputted
			VARIANTARG *pvRet);		// Pointer to return Variant
	
	// InvokePutHelper: Puts a property using IDispatch's Invoke 
	WORD InvokePutHelper(
			LPOLESTR pwszProperty,	// Wide string containing name of Property.
			VARIANTARG *pvArg);		// Variant to Put in the Property

	// InvokeGetHelper: Gets a property using IDispatch's Invoke
	WORD InvokeGetHelper(
			LPOLESTR pwszProperty,	// Wide string containing name of Property.
			VARIANTARG *pvArg);		// Variant to Get from the Property

public:
	// Constructor:
	CReflectionIBM();
	// Destructor:
	~CReflectionIBM();
	
	// Util Methods:
	BOOL IsBound();
	WORD GetNumSessions(
			LPDWORD pdwNumWindows);
			
	WORD GetSessionSettingsFile(
			UINT uIndex, 
			LPSTR pName, 
			LPDWORD pdwLen);
	WORD GetErrorString(
			WORD wErrorId,		// Reflection error ID
			LPSTR lpErrorString,// Error string buffer
			LPDWORD lpdwLength);// length of buffer[in,out]

	
	WORD GetDisplayText(
			LONG Row,
			LONG Column,
			LPSTR Chars,
			LPDWORD lpdwArg3);

	IDispatch* GetDispatch();

	// The following are for marshalling this object across threads.
	BOOL InterfaceToStream();
	BOOL StreamToInterface();

	// Creation Method: (Creates and binds)
	WORD CreateSession(
			LPSTR lpLanchArgs = NULL);

	// Bind Method: (Binds to a running Reflection session)
	WORD GetSession(
			LPSTR pName = NULL);
//-----------------------------------------------------------------------------
// The Rest of the methods have to be called after the Object has bound to a Object.
//-----------------------------------------------------------------------------



	//***********************************************************************
	//***** Standard Method Declarations ************************************
	//***********************************************************************
	WORD AbortTransfer(void);
	WORD AboutReflectionDlg(void);
	WORD ActivateCommandLine(void);
	WORD AddButton(DWORD nIndex);
	WORD AddHotListItem(LPSTR sName, LPSTR sSelection, LPSTR sCommands, DWORD nOption);
	WORD AddReferenceDlg(void);
	WORD AppendSelection(void);
	WORD AppendSQLStatement(DWORD nType, LPSTR sStatement);
	WORD CancelSelection(void);
	WORD CancelTransfer(void);
	WORD ClearHotlists(void);
	WORD ClearHotspots(void);
	WORD ClearIBMPrinterFonts(void);
	WORD ClearMenu(void);
	WORD ClearNWSAA3270Config(void);
	WORD ClearSelection(void);
	WORD ClosePrinter(void);
	WORD Connect(void);
	WORD CopyPasteSettingsDlg(void);
	WORD CopySelection(void);
	WORD CopyTable(void);
	WORD CutSelection(void);
	WORD DDESetupDlg(void);
	WORD DefineButton(DWORD nIndex, DWORD nSeparator, LPSTR sPicture, LPSTR sText, LPSTR sHelp, LPSTR sCmds);
	WORD DefineHotspot(LPSTR sString, DWORD nFlags, LPSTR sCommands);
	WORD DefineHotspotEx(LPSTR sString, DWORD nFlags, DWORD nRow, DWORD nColumn, LPSTR sTip, LPSTR sHelp, LPSTR sCommands);
	WORD DefineToolbarButton(LPSTR sToolbarName, DWORD nIndex, DWORD nSeparator, LPSTR sSmallPictureFile, DWORD uSmallPicIndex, LPSTR sLargePictureFile, DWORD sLargePicIndex, LPSTR sLabel, LPSTR sTip, LPSTR sHelp, LPSTR sCommands);
	WORD DefineTransferTemplate(DWORD nHostSystem, LPSTR sPCFilename, LPSTR sHostFilename, DWORD nTransferType, DWORD nExistsAction, DWORD nRecfm, DWORD nAsciiCRLF, DWORD nBinaryCRLF, DWORD nJISCIICRLF, DWORD nLRECL, LPSTR sAddParm, DWORD nBlockSize, DWORD nAllocUnits, DWORD nAvgBlkSize, DWORD nPrimAlloc, DWORD nSecAlloc);
	WORD DeletePopupItem(DWORD nPopup, DWORD nItem);
	WORD Disconnect(void);
	WORD DisplayFontsDlg(void);
	WORD DisplayOptionsDlg(void);
	WORD DisplaySetupDlg(void);
	WORD EditMacro(LPSTR sMacro);
	WORD EditScript(LPSTR sScriptFile);
	WORD EditScriptDlg(void);
	WORD EnableInternalTrace(LPSTR sTraceNode, DWORD nEnableOrDisable);
	WORD EnableOnEvent(DWORD nOnEventNumber, DWORD nEnableOrDisable);
	WORD Exit(void);
	WORD ExitAll(void);
	WORD ExtendSelection(LONG nRow, LONG nColumn);
	WORD ExtendSelectionLine(DWORD nDirection);
	WORD ExtendSelectionPage(DWORD nDirection);
	WORD ExtendSelectionRect(LONG nRow, LONG nColumn);
	WORD ExtendSelectionWord(DWORD nDirection);
	WORD FontDefault(void);
	WORD FontGrow(void);
	WORD FontShrink(void);
	WORD FTPClient(void);
	WORD GraphicsMouse(DWORD nType, LONG nXCoordinate, LONG nYCoordinate);
	WORD Help(DWORD Topic);
	WORD HelpCursor(void);
	WORD HotlistSetupDlg(void);
	WORD HotspotSetupDlg(void);
	WORD ImportVBAProjectItemDlg(void);
	WORD IndReceiveFile(LPSTR sLocalFile, LPSTR sHostFile, DWORD nType, DWORD nExistsOption, DWORD nShowStat);
	WORD IndSendFile(LPSTR sLocalFile, LPSTR sHostFile, DWORD nType, DWORD nExistsOption, DWORD nShowStat);
	WORD InsertPopupItem(DWORD nItemType, DWORD nPopup, DWORD nItem, LPSTR sName, LPSTR sDescription, LPSTR sCommands);
	WORD InternalTraceDlg(void);
	WORD IssuePrinterCommand(DWORD nPrinterCommand);
	WORD KeyboardMapSetupDlg(void);
	WORD LightPen(LONG nRow, LONG nColumn);
	WORD MacrosDlg(void);
	WORD MenuSetupDlg(void);
	WORD MouseMapSetupDlg(void);
	WORD MoveCursor(LONG nRow, LONG nColumn);
	WORD MoveGraphicsCursor(LONG nXCoordinate, LONG nYCoordinate);
	WORD NewHotlist(LPSTR sName, DWORD nOptions);
	WORD NewSession(LPSTR sFilename);
	WORD NewSessionDlg(void);
	WORD NewToolbar(LPSTR sName);
	WORD OnEvent(DWORD nEvNumber, DWORD nEvent, LPSTR sCommands, DWORD nEnable, DWORD nAfterEvent, LPSTR sString, DWORD nRow, DWORD nColumn);
	WORD OnEventSetupDlg(void);
	WORD OpenLayoutDlg(void);
	WORD OpenSettings(DWORD nSettingsType, LPSTR sFilename);
	WORD OpenSettingsDlg(void);
	WORD OpenTemplateDlg(void);
	WORD PageSetupDlg(void);
	WORD Paste(void);
	WORD PasteNext(void);
	WORD PasteRange(LONG n1stTop, LONG n1stLeft, LONG n1stBottom, LONG n1stRight, LONG nRemTop, LONG nRemLeft, LONG nRemBottom, LONG nRemRight, DWORD nKey, DWORD nWrapText, DWORD nUseFieldDelim);
	WORD PasteRangeDlg(void);
	WORD PCSReceiveFile(LPSTR sTransferFile, DWORD nShowStat);
	WORD PCSSendFile(LPSTR sTransferFile, DWORD nShowStat);
	WORD PlayBackTrace(DWORD nType, LPSTR sFilename);
	WORD PlayBackTraceDlg(void);
	WORD PlayNextTraceRecord(void);
	WORD PlayPreviousTraceRecord(void);
	WORD PreferencesSetupDlg(void);
	WORD Print(DWORD nItem, DWORD nCopies);
	WORD PrintControl(DWORD nPrintControl);
	WORD PrintDlg(void);
	WORD PrintHostFile(LPSTR HostFile, DWORD Type, DWORD CarriageControl);
	WORD PrintSetupDlg(void);
	WORD PrintString(LPSTR sString);
	WORD PrintTransparentChar(DWORD nASCIICode);
	WORD RaiseControlEvent(DWORD nIntData, LPSTR sStrData);
	WORD ReadQuickText(LONG nRow, LONG nColumn, DWORD nReadOption);
	WORD RecordingSetupDlg(void);
	WORD ReferencesDlg(void);
	WORD RemoveAllToolbars(void);
	WORD RemoveButton(DWORD nIndex);
	WORD RemoveHotlist(LPSTR sName);
	WORD RemoveNWSAA3270Config(DWORD Index);
	WORD RemoveOnEvent(DWORD nEvent);
	WORD RemoveToolbar(LPSTR sName);
	WORD RemoveToolbarButton(LPSTR sToolbarName, DWORD nIndex);
	WORD ResetCommands(void);
	WORD RestoreDefaults(DWORD nSettingsType);
	WORD RunExternalMacro(LPSTR sFileName, LPSTR sMacroName, LPSTR sMacroData);
	WORD RunMacro(LPSTR sMacroName, LPSTR sMacroData);
	WORD RunScript(LPSTR sScriptFile, LPSTR sArguments);
	WORD RunScriptDlg(void);
	WORD SaveDisplay(DWORD nLayeringOption, DWORD nExistOption, LPSTR sFileName, DWORD nColorType, DWORD nBackground);
	WORD SaveDisplayDlg(void);
	WORD SaveLayoutAsDlg(void);
	WORD SaveSettings(DWORD nType, DWORD nExistOption, LPSTR sFileName);
	WORD SaveSettingsAsDlg(void);
	WORD SaveSettingsDlg(void);
	WORD SaveXML(LPSTR sFileName, DWORD nXMLType, DWORD nExistOption, DWORD nOption);
	WORD SelectAll(void);
	WORD SelectLine(DWORD nLineNumber);
	WORD SelectWord(LONG nRow, LONG nColumn);
	WORD SendMail(LPSTR sRecipient, LPSTR sSubject, DWORD nContentType, LPSTR sContent);
	WORD SendMailDlg(void);
	WORD SessionSetupDlg(void);
	WORD SetAPLKeyMap(DWORD nControls, LPSTR sKey, LPSTR sCommands);
	WORD SetColorMap(DWORD nAttribute, DWORD nForeground, DWORD nBackground);
	WORD SetColorRGB(DWORD nColor, DWORD nRed, DWORD nGreen, DWORD nBlue);
	WORD SetCommandProfile(LPSTR sCommandName, DWORD nEnableFlag);
	WORD SetCommandRecording(LPSTR sCommandName, DWORD nEnableFlag);
	WORD SetDisplayAttribute(DWORD nHostAttrIndex, DWORD nAttribute, DWORD nEnable);
	WORD SetEncryptedString(DWORD nEncryptedSetting, LPSTR sString);
	WORD SetIBMPrinterFont(DWORD nFontID, LPSTR sFontDescription);
	WORD SetKeyMap(DWORD nControls, LPSTR sKey, LPSTR sCommands);
	WORD SetMouseMap(DWORD nControls, LPSTR sChord, LPSTR sCommands);
	WORD SetMousePos(LONG nRow, LONG nColumn);
	WORD SetNumeric(DWORD nSetting, DWORD nValue);
	WORD SetNumericProfile(DWORD nSetting, DWORD nEnableFlag);
	WORD SetRecentlyUsedFile(LPSTR sTitle, LPSTR sDescription, LPSTR sCommands);
	WORD SetScanCodeName(DWORD nScanType, DWORD nScanCode, LPSTR sKey);
	WORD SetSelectionStartPos(LONG nRow, LONG nColumn);
	WORD SetSQLStatement(DWORD nType, LPSTR sStatement);
	WORD SetString(DWORD nSetting, LPSTR sString);
	WORD SetStringProfile(DWORD nSetting, DWORD nEnableFlag);
	WORD SetTerminalKbdPos(LONG nLeft, LONG nTop, LONG nWidth, LONG nHeight);
	WORD SetToolbarMode(LPSTR sToolbarName, DWORD nMode);
	WORD SetToolbarPos(LONG nLeft, LONG nTop, LONG nWidth, LONG nHeight);
	WORD SetToolbarPosition(LPSTR sToolbarName, LONG nLeft, LONG nTop, LONG nWidth, LONG nHeight);
	WORD SetupNWSAA3270Config(LPSTR sServer, LPSTR sService, LPSTR sLU);
	WORD SetupSession(DWORD nSessionType, DWORD nTerminalModel, DWORD nTransportType);
	WORD SetWindowPos(LONG nLeft, LONG nTop, LONG nWidth, LONG nHeight);
	WORD Shell(LPSTR sApplicationName, LPSTR sArguments, DWORD nShowHow);
	WORD ShowDBCSHostCodeInputWindow(DWORD nHostCode);
	WORD ShowDisplayAttribute(DWORD nAttribute, DWORD nEnable);
	WORD ShowHotlist(LPSTR sName, DWORD nRow, DWORD nColumn, DWORD nWidth, DWORD nHeight);
	WORD ShowToolbar(LPSTR sToolbarName, DWORD nYesNo);
	WORD ShowToolbarButtonsFixedWidth(LPSTR sToolbarName, DWORD nYesNo);
	WORD ShowToolbarColor(LPSTR sToolbarName, DWORD nYesNo);
	WORD ShowToolbarLabels(LPSTR sToolbarName, DWORD nYesNo);
	WORD ShowToolbarLarge(LPSTR sToolbarName, DWORD nYesNo);
	WORD ShowToolbarTips(LPSTR sToolbarName, DWORD nYesNo);
	WORD StartInternalTrace(LPSTR sFileName);
	WORD StartRecording(void);
	WORD StartTrace(DWORD nType, DWORD nExistOption, LPSTR sFileName);
	WORD StartTraceDlg(void);
	WORD StopInternalTrace(void);
	WORD StopMacro(void);
	WORD StopRecording(DWORD nDestination, DWORD nExistsOption, LPSTR sFile);
	WORD StopRecordingDlg(void);
	WORD StopRecordingMacro(DWORD nDestination, LPSTR sName, LPSTR sDescription);
	WORD StopScript(void);
	WORD StopTrace(void);
	WORD SwitchToWindow(DWORD nSession);
	WORD TerminalMouse(DWORD nType, LONG nRow, LONG nCol);
	WORD TerminalSetupDlg(void);
	WORD TetherToolbar(LPSTR sToolbarName, DWORD nYesNo);
	WORD Toggle(DWORD nSetting);
	WORD ToolbarSetupDlg(void);
	WORD TransferDlg(void);
	WORD TransferSetupDlg(void);
	WORD TransformXML(LPSTR sInputFile, LPSTR sTransformFile, LPSTR sOutputFile);
	WORD TransmitANSI(LPSTR sString);
	WORD TransmitTerminalKey(DWORD nKey);
	WORD ViewSettingsDlg(void);
	WORD Wait(LPSTR sDuration);
	WORD WaitForCommString(LPSTR sString, LPSTR sTimeOut);
	WORD WaitForDisplayString(LPSTR sString, LPSTR sTimeOut, DWORD nRow, DWORD nCol);
	WORD WaitForEvent(DWORD nEvent, LPSTR sTimeOut, LPSTR sDuration, LONG nRow, LONG nCol);
	WORD WaitForPrinterStatusString(LPSTR sString, LPSTR sTimeOut);
	WORD WaitForPrinterString(LPSTR sString, LPSTR sTimeOut);
	WORD WaitForPrinterStringReplace(LPSTR sString, LPSTR sTimeOut, DWORD nCol);
	WORD WaitForTerminalKey(DWORD nTerminalKey, LPSTR sTimeOut);
	WORD WaitForTimeOfDay(LPSTR sTimeOfDay);
	WORD WriteQuickText(DWORD nTerminalKey);
	WORD CheckEvent(LPDWORD Event);
	WORD ClearEvents(void);
	WORD CommitLoginProperties(DWORD Options);
	WORD CompileScript(LPSTR ScriptName, LPDWORD lpdwArg1);
	WORD DefineEvent(DWORD Event, DWORD EventType, LPSTR Duration, LPSTR String, DWORD Row, DWORD Column, DWORD Key);
	WORD FindField(LONG Row, LONG Column, DWORD FindType, DWORD FindAttribute, LPDWORD lpdwArg4, LPDWORD lpdwArg5, LPDWORD lpdwArg6, LPDWORD lpdwArg7, LPDWORD lpdwArg8);
	WORD GetBufferedTermKey(LPDWORD lpdwArg0);
	WORD GetButtonCommands(DWORD Index, LPSTR lpsArg1, LPDWORD lpdwArg2);
	WORD GetButtonHelpText(DWORD Index, LPSTR lpsArg1, LPDWORD lpdwArg2);
	WORD GetButtonLabel(DWORD Index, LPSTR lpsArg1, LPDWORD lpdwArg2);
	WORD GetButtonPictureFile(DWORD Index, LPSTR lpsArg1, LPDWORD lpdwArg2);
	WORD GetButtonSeparator(DWORD Index, LPDWORD lpdwArg1);
	WORD GetCommandProfile(LPSTR Command, LPDWORD lpdwArg1);
	WORD GetCommandRecording(LPSTR Command, LPDWORD lpdwArg1);
	WORD GetCurrentHotspot(LPDWORD nRow, LPDWORD nColumn, LPSTR sName, LPDWORD nLength);
	WORD GetCurrentHotspotEx(LPDWORD nRow, LPDWORD nColumn, LPSTR sName, LPDWORD nLength, LPDWORD nFlags, LPDWORD nDefRow, LPDWORD nDefColumn);
	WORD GetFieldAttributes(LONG Row, LONG Column, LPDWORD lpdwArg2);
	WORD GetFieldColor(LONG Row, LONG Column, LPDWORD lpdwArg2);
	WORD GetHotlistItem(LPSTR sName, DWORD nIndex, LPSTR sItem, LPDWORD nLength);
	WORD GetHotlistItemCommands(LPSTR sList, LPSTR sItem, LPSTR sCommands, LPDWORD nLength);
	WORD GetHotlistItemOptions(LPSTR sList, LPSTR sItem, LPDWORD nOptions);
	WORD GetHotlistName(DWORD nIndex, LPSTR sName, LPDWORD nLength);
	WORD GetHotlistOptions(LPSTR sName, LPDWORD nOptions);
	WORD GetHotlistShowPosition(LPSTR sName, LPDWORD nRow, LPDWORD nColumn, DWORD dwArg3, DWORD dwArg4);
	WORD GetHotspotCommands(LPSTR Name, LPSTR Commands, LPDWORD Size);
	WORD GetHotspotCommandsEx(LPSTR Name, DWORD Flags, DWORD Row, DWORD Column, LPSTR Commands, LPDWORD Size);
	WORD GetHotspotHelp(LPSTR Name, DWORD Flags, DWORD Row, DWORD Column, LPSTR Commands, LPDWORD Size);
	WORD GetHotspots(DWORD nIndex, LPDWORD nRow, LPDWORD nColumn, LPSTR sDescription, LPDWORD nLength);
	WORD GetHotspotsEx(DWORD nIndex, LPDWORD nRow, LPDWORD nColumn, LPSTR sDescription, LPDWORD nLength, LPDWORD nFlags, LPDWORD nDefRow, LPDWORD nDefColumn);
	WORD GetHotspotTip(LPSTR Name, DWORD Flags, DWORD Row, DWORD Column, LPSTR Commands, LPDWORD Size);
	WORD GetKeyMap(DWORD Modifiers, LPSTR KeyOrChord, LPSTR lpsArg2, LPDWORD lpdwArg3);
	WORD GetLastActiveInstance(LPDWORD lpdwArg0);
	WORD GetLoginProperty(LPSTR Property, LPSTR HostUsername, LPSTR Hostname, LPSTR Options, LPSTR lpsArg4, LPDWORD lpdwArg5);
	WORD GetMouseMap(DWORD Modifiers, LPSTR Chord, LPSTR lpsArg2, LPDWORD lpdwArg3);
	WORD GetMyWindow(LPDWORD lpdwArg0);
	WORD GetNumButtons(LPDWORD lpdwArg0);
	WORD GetNumeric(DWORD NumericSetting, LPDWORD lpdwArg1);
	WORD GetNumHotlists(LPDWORD nNumberLists);
	WORD GetNumHotspots(LPDWORD nHotspots);
	WORD GetNumItems(LPSTR sList, LPDWORD nItems);
	WORD GetNumToolbars(LPDWORD lpdwArg0);
	WORD GetPassword(LPSTR Prompt, LPSTR HostUsername, LPSTR Hostname, LPSTR Options, LPSTR lpsArg4, LPDWORD lpdwArg5);
	WORD GetScanCode(DWORD ScanType, DWORD ScanCode, LPSTR lpsArg2, LPDWORD lpdwArg3);
	WORD GetSetProfile(DWORD SettingName, LPDWORD lpdwArg1);
	WORD GetSetStringProfile(DWORD SettingName, LPDWORD lpdwArg1);
	WORD GetSQLStatement(DWORD nType, LPSTR lpsArg1, LPDWORD lpdwArg2);
	WORD GetString(DWORD StringSetting, LPSTR lpsArg1, LPDWORD lpdwArg2);
	WORD GetVersionNumber(LPSTR lpsArg0, LPDWORD lpdwArg1);
	WORD PasswordBox(LPSTR Prompt, LPSTR Title, LPSTR lpsArg2, LPDWORD lpdwArg3);
	WORD RemoveEvent(DWORD Event);
	WORD ResetEvent(DWORD Event);
	WORD SetClipboardText(LPSTR Text);
	WORD SetTermKeyBuffer(LONG Size, LONG Overflow);
	WORD WaitEvent(LPDWORD Timeout, LPSTR lpsArg1);
	WORD WaitEventNumber(DWORD Event, LPSTR Timeout);

	//***********************************************************************
	//***** put and get Property Declarations *******************************
	//***********************************************************************
	WORD get_CapsLockState(LPDWORD pdwOut);
	WORD put_CapsLockState(DWORD dwIn);
	WORD get_DDEServerEnable(LPDWORD pdwOut);
	WORD put_DDEServerEnable(DWORD dwIn);
	WORD get_DisableInterrupts(LPDWORD pdwOut);
	WORD put_DisableInterrupts(DWORD dwIn);
	WORD get_DisableXlate(LPDWORD pdwOut);
	WORD put_DisableXlate(DWORD dwIn);
	WORD get_NumLockState(LPDWORD pdwOut);
	WORD put_NumLockState(DWORD dwIn);
	WORD get_MappedNumLockPreservesNumLock(LPDWORD pdwOut);
	WORD put_MappedNumLockPreservesNumLock(DWORD dwIn);
	WORD get_KanaLockState(LPDWORD pdwOut);
	WORD put_KanaLockState(DWORD dwIn);
	WORD get_QueryExit(LPDWORD pdwOut);
	WORD put_QueryExit(DWORD dwIn);
	WORD get_SaveChanges(LPDWORD pdwOut);
	WORD put_SaveChanges(DWORD dwIn);
	WORD get_SaveWindowState(LPDWORD pdwOut);
	WORD put_SaveWindowState(DWORD dwIn);
	WORD get_ScrollLockState(LPDWORD pdwOut);
	WORD put_ScrollLockState(DWORD dwIn);
	WORD get_UseCtrlZ(LPDWORD pdwOut);
	WORD put_UseCtrlZ(DWORD dwIn);
	WORD get_XlateASCII(LPDWORD pdwOut);
	WORD put_XlateASCII(DWORD dwIn);
	WORD get_DDETimeout(LPDWORD pdwOut);
	WORD put_DDETimeout(DWORD dwIn);
	WORD get_FileSystem(LPDWORD pdwOut);
	WORD put_FileSystem(DWORD dwIn);
	WORD get_SpacesPerTab(LPDWORD pdwOut);
	WORD put_SpacesPerTab(DWORD dwIn);
	WORD get_TransferType(LPDWORD pdwOut);
	WORD put_TransferType(DWORD dwIn);
	WORD get_XfrHostSys(LPDWORD pdwOut);
	WORD put_XfrHostSys(DWORD dwIn);
	WORD get_XfrIndStrucFldSz(LPDWORD pdwOut);
	WORD put_XfrIndStrucFldSz(DWORD dwIn);
	WORD get_XfrTimeout(LPDWORD pdwOut);
	WORD put_XfrTimeout(DWORD dwIn);
	WORD get_XfrIndRecFm(LPDWORD pdwOut);
	WORD put_XfrIndRecFm(DWORD dwIn);
	WORD get_XfrIndLrecl(LPDWORD pdwOut);
	WORD put_XfrIndLrecl(DWORD dwIn);
	WORD get_XfrIndBlkSize(LPDWORD pdwOut);
	WORD put_XfrIndBlkSize(DWORD dwIn);
	WORD get_XfrIndAllocUnit(LPDWORD pdwOut);
	WORD put_XfrIndAllocUnit(DWORD dwIn);
	WORD get_XfrIndAvgBlk(LPDWORD pdwOut);
	WORD put_XfrIndAvgBlk(DWORD dwIn);
	WORD get_XfrIndPrimAlloc(LPDWORD pdwOut);
	WORD put_XfrIndPrimAlloc(DWORD dwIn);
	WORD get_XfrIndSecAlloc(LPDWORD pdwOut);
	WORD put_XfrIndSecAlloc(DWORD dwIn);
	WORD get_XfrBinaryCRLF(LPDWORD pdwOut);
	WORD put_XfrBinaryCRLF(DWORD dwIn);
	WORD get_XfrASCIICRLF(LPDWORD pdwOut);
	WORD put_XfrASCIICRLF(DWORD dwIn);
	WORD get_XfrJISCIICRLF(LPDWORD pdwOut);
	WORD put_XfrJISCIICRLF(DWORD dwIn);
	WORD get_CurrentTraceRecord(LPDWORD pdwOut);
	WORD get_MaxDebugFilelength(LPDWORD pdwOut);
	WORD get_TraceFileMaxSize(LPDWORD pdwOut);
	WORD put_TraceFileMaxSize(DWORD dwIn);
	WORD get_TraceFileCompressType(LPDWORD pdwOut);
	WORD put_TraceFileCompressType(DWORD dwIn);
	WORD get_TraceBufferSize(LPDWORD pdwOut);
	WORD put_TraceBufferSize(DWORD dwIn);
	WORD get_WindowState(LPDWORD pdwOut);
	WORD put_WindowState(DWORD dwIn);
	WORD get_ToolBarMode(LPDWORD pdwOut);
	WORD put_ToolBarMode(DWORD dwIn);
	WORD get_ToolBarVisible(LPDWORD pdwOut);
	WORD put_ToolBarVisible(DWORD dwIn);
	WORD get_ToolBarTether(LPDWORD pdwOut);
	WORD put_ToolBarTether(DWORD dwIn);
	WORD get_TerminalKbdVisible(LPDWORD pdwOut);
	WORD put_TerminalKbdVisible(DWORD dwIn);
	WORD get_TerminalKbdTether(LPDWORD pdwOut);
	WORD put_TerminalKbdTether(DWORD dwIn);
	WORD get_TerminalKbdTooltips(LPDWORD pdwOut);
	WORD put_TerminalKbdTooltips(DWORD dwIn);
	WORD get_SettingsChanged(LPDWORD pdwOut);
	WORD get_SessionType(LPDWORD pdwOut);
	WORD get_TerminalModel(LPDWORD pdwOut);
	WORD get_TransportName(LPSTR pStrOut, LPDWORD length);
	WORD get_TransportType(LPDWORD pdwOut);
	WORD get_HostName(LPSTR pStrOut, LPDWORD length);
	WORD put_HostName(LPSTR pStrIn);
	WORD get_AssignedDeviceName(LPSTR pStrOut, LPDWORD length);
	WORD get_AssignedEncryptionStrength(LPDWORD pdwOut);
	WORD get_XfrHostCmd(LPSTR pStrOut, LPDWORD length);
	WORD put_XfrHostCmd(LPSTR pStrIn);
	WORD get_XfrAddParam(LPSTR pStrOut, LPDWORD length);
	WORD put_XfrAddParam(LPSTR pStrIn);
	WORD get_RecordToggle(LPDWORD pdwOut);
	WORD put_RecordToggle(DWORD dwIn);
	WORD get_DfltXfrType(LPDWORD pdwOut);
	WORD put_DfltXfrType(DWORD dwIn);
	WORD get_DfltExistsAction(LPDWORD pdwOut);
	WORD put_DfltExistsAction(DWORD dwIn);
	WORD get_ConnectScript(LPSTR pStrOut, LPDWORD length);
	WORD put_ConnectScript(LPSTR pStrIn);
	WORD get_ConnectScriptArguments(LPSTR pStrOut, LPDWORD length);
	WORD put_ConnectScriptArguments(LPSTR pStrIn);
	WORD get_HostsFile(LPSTR pStrOut, LPDWORD length);
	WORD put_HostsFile(LPSTR pStrIn);
	WORD get_TerminalKbdShape(LPDWORD pdwOut);
	WORD put_TerminalKbdShape(DWORD dwIn);
	WORD get_AutoConnect(LPDWORD pdwOut);
	WORD put_AutoConnect(DWORD dwIn);
	WORD get_PrintCompressFont(LPDWORD pdwOut);
	WORD put_PrintCompressFont(DWORD dwIn);
	WORD get_PrintDest(LPSTR pStrOut, LPDWORD length);
	WORD put_PrintDest(LPSTR pStrIn);
	WORD get_DfltPrintCopies(LPDWORD pdwOut);
	WORD put_DfltPrintCopies(DWORD dwIn);
	WORD get_PrintDefaultFont(LPSTR pStrOut, LPDWORD length);
	WORD put_PrintDefaultFont(LPSTR pStrIn);
	WORD get_PrintLineSpacing(LPDWORD pdwOut);
	WORD put_PrintLineSpacing(DWORD dwIn);
	WORD get_PrintCase(LPDWORD pdwOut);
	WORD put_PrintCase(DWORD dwIn);
	WORD get_PrintCharsPerLine(LPDWORD pdwOut);
	WORD put_PrintCharsPerLine(DWORD dwIn);
	WORD get_PrintLinesPerPage(LPDWORD pdwOut);
	WORD put_PrintLinesPerPage(DWORD dwIn);
	WORD get_PrintLinesPerInch(LPDWORD pdwOut);
	WORD put_PrintLinesPerInch(DWORD dwIn);
	WORD get_PrintHostLUName(LPSTR pStrOut, LPDWORD length);
	WORD put_PrintHostLUName(LPSTR pStrIn);
	WORD get_DeviceName(LPSTR pStrOut, LPDWORD length);
	WORD put_DeviceName(LPSTR pStrIn);
	WORD get_AutoSignon(LPDWORD pdwOut);
	WORD put_AutoSignon(DWORD dwIn);
	WORD get_CursorShape(LPDWORD pdwOut);
	WORD put_CursorShape(DWORD dwIn);
	WORD get_CursorMovementStyle(LPDWORD pdwOut);
	WORD put_CursorMovementStyle(DWORD dwIn);
	WORD get_CursorBlinkRate(LPDWORD pdwOut);
	WORD put_CursorBlinkRate(DWORD dwIn);
	WORD get_BlinkRate(LPDWORD pdwOut);
	WORD put_BlinkRate(DWORD dwIn);
	WORD get_TypeAhead(LPDWORD pdwOut);
	WORD put_TypeAhead(DWORD dwIn);
	WORD get_EnableHotSpots(LPDWORD pdwOut);
	WORD put_EnableHotSpots(DWORD dwIn);
	WORD get_ShowHotSpots(LPDWORD pdwOut);
	WORD put_ShowHotSpots(DWORD dwIn);
	WORD get_QuickText(LPSTR pStrOut, LPDWORD length);
	WORD put_QuickText(LPSTR pStrIn);
	WORD get_CmdPrompt(LPSTR pStrOut, LPDWORD length);
	WORD put_CmdPrompt(LPSTR pStrIn);
	WORD get_DfltDatasetType(LPDWORD pdwOut);
	WORD put_DfltDatasetType(DWORD dwIn);
	WORD get_PasteLineBreak(LPDWORD pdwOut);
	WORD put_PasteLineBreak(DWORD dwIn);
	WORD get_HLLAPIShortName(LPSTR pStrOut, LPDWORD length);
	WORD put_HLLAPIShortName(LPSTR pStrIn);
	WORD get_HLLAPILongName(LPSTR pStrOut, LPDWORD length);
	WORD put_HLLAPILongName(LPSTR pStrIn);
	WORD get_KeysDuringWait(LPDWORD pdwOut);
	WORD put_KeysDuringWait(DWORD dwIn);
	WORD get_DragQuickTextOption(LPDWORD pdwOut);
	WORD put_DragQuickTextOption(DWORD dwIn);
	WORD get_FastTextPrinting(LPDWORD pdwOut);
	WORD put_FastTextPrinting(DWORD dwIn);
	WORD get_PrintStatusLine(LPDWORD pdwOut);
	WORD put_PrintStatusLine(DWORD dwIn);
	WORD get_PrintMonochrome(LPDWORD pdwOut);
	WORD put_PrintMonochrome(DWORD dwIn);
	WORD get_PrintSquareAspectRatio(LPDWORD pdwOut);
	WORD put_PrintSquareAspectRatio(DWORD dwIn);
	WORD get_PrintBackground(LPDWORD pdwOut);
	WORD put_PrintBackground(DWORD dwIn);
	WORD get_PrintWhat(LPDWORD pdwOut);
	WORD put_PrintWhat(DWORD dwIn);
	WORD get_BackgndColor(LPDWORD pdwOut);
	WORD put_BackgndColor(DWORD dwIn);
	WORD get_AutoFormfeed(LPDWORD pdwOut);
	WORD put_AutoFormfeed(DWORD dwIn);
	WORD get_ClosePrinterManually(LPDWORD pdwOut);
	WORD put_ClosePrinterManually(DWORD dwIn);
	WORD get_PrintFitToPage(LPDWORD pdwOut);
	WORD put_PrintFitToPage(DWORD dwIn);
	WORD get_PrintFileExistsAction(LPDWORD pdwOut);
	WORD put_PrintFileExistsAction(DWORD dwIn);
	WORD get_PrintFileName(LPSTR pStrOut, LPDWORD length);
	WORD put_PrintFileName(LPSTR pStrIn);
	WORD get_PrintFormFeedOnEndOfJob(LPDWORD pdwOut);
	WORD put_PrintFormFeedOnEndOfJob(DWORD dwIn);
	WORD get_PrintPaperSize(LPDWORD pdwOut);
	WORD put_PrintPaperSize(DWORD dwIn);
	WORD get_PrintPaperSource(LPDWORD pdwOut);
	WORD put_PrintPaperSource(DWORD dwIn);
	WORD get_PrintToFile(LPDWORD pdwOut);
	WORD put_PrintToFile(DWORD dwIn);
	WORD get_PrintUsePrinterFontsOnly(LPDWORD pdwOut);
	WORD put_PrintUsePrinterFontsOnly(DWORD dwIn);
	WORD get_PrintSuppressBlankPage(LPDWORD pdwOut);
	WORD put_PrintSuppressBlankPage(DWORD dwIn);
	WORD get_PrintTranslateEBCDICInTRN(LPDWORD pdwOut);
	WORD put_PrintTranslateEBCDICInTRN(DWORD dwIn);
	WORD get_BypassWindowsPrinting(LPDWORD pdwOut);
	WORD put_BypassWindowsPrinting(DWORD dwIn);
	WORD get_BypassWindowsTransparent(LPDWORD pdwOut);
	WORD put_BypassWindowsTransparent(DWORD dwIn);
	WORD get_HostPrintTimeout(LPDWORD pdwOut);
	WORD put_HostPrintTimeout(DWORD dwIn);
	WORD get_PrintDeviceAscii899(LPDWORD pdwOut);
	WORD put_PrintDeviceAscii899(DWORD dwIn);
	WORD get_PrintDeviceFormsMode(LPDWORD pdwOut);
	WORD put_PrintDeviceFormsMode(DWORD dwIn);
	WORD get_PrintDeviceFontId(LPDWORD pdwOut);
	WORD put_PrintDeviceFontId(DWORD dwIn);
	WORD get_PrintDeviceEnvelopeSrc(LPDWORD pdwOut);
	WORD put_PrintDeviceEnvelopeSrc(DWORD dwIn);
	WORD get_PrintDevicePaperSrc1(LPDWORD pdwOut);
	WORD put_PrintDevicePaperSrc1(DWORD dwIn);
	WORD get_PrintDevicePaperSrc2(LPDWORD pdwOut);
	WORD put_PrintDevicePaperSrc2(DWORD dwIn);
	WORD get_PrintDeviceWscstName(LPSTR pStrOut, LPDWORD length);
	WORD put_PrintDeviceWscstName(LPSTR pStrIn);
	WORD get_PrintDeviceWscstLibrary(LPSTR pStrOut, LPDWORD length);
	WORD put_PrintDeviceWscstLibrary(LPSTR pStrIn);
	WORD get_KeyClick(LPDWORD pdwOut);
	WORD put_KeyClick(DWORD dwIn);
	WORD get_PauseDebugPlayOnEOR(LPDWORD pdwOut);
	WORD put_PauseDebugPlayOnEOR(DWORD dwIn);
	WORD get_NationalCharacterSet(LPDWORD pdwOut);
	WORD put_NationalCharacterSet(DWORD dwIn);
	WORD get_CEGC(LPDWORD pdwOut);
	WORD put_CEGC(DWORD dwIn);
	WORD get_TelnetPort(LPDWORD pdwOut);
	WORD put_TelnetPort(DWORD dwIn);
	WORD get_HostKbdType(LPDWORD pdwOut);
	WORD put_HostKbdType(DWORD dwIn);
	WORD get_LocalKbd(LPDWORD pdwOut);
	WORD put_LocalKbd(DWORD dwIn);
	WORD get_Host3270Kbd(LPDWORD pdwOut);
	WORD put_Host3270Kbd(DWORD dwIn);
	WORD get_Host5250Kbd(LPDWORD pdwOut);
	WORD put_Host5250Kbd(DWORD dwIn);
	WORD get_TerminalKbdMode(LPDWORD pdwOut);
	WORD put_TerminalKbdMode(DWORD dwIn);
	WORD get_HelpDisplayMode(LPDWORD pdwOut);
	WORD put_HelpDisplayMode(DWORD dwIn);
	WORD get_FrameTerminalWindow(LPDWORD pdwOut);
	WORD put_FrameTerminalWindow(DWORD dwIn);
	WORD get_XfrHostmessage(LPSTR pStrOut, LPDWORD length);
	WORD put_XfrHostmessage(LPSTR pStrIn);
	WORD get_InsertProtocol(LPDWORD pdwOut);
	WORD put_InsertProtocol(DWORD dwIn);
	WORD get_InsertArena(LPDWORD pdwOut);
	WORD put_InsertArena(DWORD dwIn);
	WORD get_EnableQuickText(LPDWORD pdwOut);
	WORD put_EnableQuickText(DWORD dwIn);
	WORD get_ToolbarInsideTerminalKbd(LPDWORD pdwOut);
	WORD put_ToolbarInsideTerminalKbd(DWORD dwIn);
	WORD get_KbdMapShowHostMappedKeys(LPDWORD pdwOut);
	WORD put_KbdMapShowHostMappedKeys(DWORD dwIn);
	WORD get_KbdMapShowKeyHelp(LPDWORD pdwOut);
	WORD put_KbdMapShowKeyHelp(DWORD dwIn);
	WORD get_TerminalKbdFixUpperRight(LPDWORD pdwOut);
	WORD put_TerminalKbdFixUpperRight(DWORD dwIn);
	WORD get_ExtendHotSpots(LPDWORD pdwOut);
	WORD put_ExtendHotSpots(DWORD dwIn);
	WORD get_Xfr400UseDescriptionFile(LPDWORD pdwOut);
	WORD put_Xfr400UseDescriptionFile(DWORD dwIn);
	WORD get_Xfr400SaveDescriptionFile(LPDWORD pdwOut);
	WORD put_Xfr400SaveDescriptionFile(DWORD dwIn);
	WORD get_Xfr400SendConversion(LPDWORD pdwOut);
	WORD put_Xfr400SendConversion(DWORD dwIn);
	WORD get_Xfr400ReceiveConversion(LPDWORD pdwOut);
	WORD put_Xfr400ReceiveConversion(DWORD dwIn);
	WORD get_Xfr400HostFileType(LPDWORD pdwOut);
	WORD put_Xfr400HostFileType(DWORD dwIn);
	WORD get_Xfr400Authority(LPDWORD pdwOut);
	WORD put_Xfr400Authority(DWORD dwIn);
	WORD get_Xfr400RecordLength(LPDWORD pdwOut);
	WORD put_Xfr400RecordLength(DWORD dwIn);
	WORD get_Xfr400TimeFormat(LPDWORD pdwOut);
	WORD put_Xfr400TimeFormat(DWORD dwIn);
	WORD get_Xfr400DateFormat(LPDWORD pdwOut);
	WORD put_Xfr400DateFormat(DWORD dwIn);
	WORD get_Xfr400TimeSeparator(LPDWORD pdwOut);
	WORD put_Xfr400TimeSeparator(DWORD dwIn);
	WORD get_Xfr400DateSeparator(LPDWORD pdwOut);
	WORD put_Xfr400DateSeparator(DWORD dwIn);
	WORD get_Xfr400IgnoreDecErrors(LPDWORD pdwOut);
	WORD put_Xfr400IgnoreDecErrors(DWORD dwIn);
	WORD get_Xfr400ReturnMissing(LPDWORD pdwOut);
	WORD put_Xfr400ReturnMissing(DWORD dwIn);
	WORD get_Xfr400DecSep(LPDWORD pdwOut);
	WORD put_Xfr400DecSep(DWORD dwIn);
	WORD get_Xfr400OutputDest(LPDWORD pdwOut);
	WORD put_Xfr400OutputDest(DWORD dwIn);
	WORD get_Xfr400FileText(LPSTR pStrOut, LPDWORD length);
	WORD put_Xfr400FileText(LPSTR pStrIn);
	WORD get_Xfr400MemberText(LPSTR pStrOut, LPDWORD length);
	WORD put_Xfr400MemberText(LPSTR pStrIn);
	WORD get_Xfr400SelectString(LPSTR pStrOut, LPDWORD length);
	WORD put_Xfr400SelectString(LPSTR pStrIn);
	WORD get_Xfr400WhereString(LPSTR pStrOut, LPDWORD length);
	WORD put_Xfr400WhereString(LPSTR pStrIn);
	WORD get_Xfr400GroupByString(LPSTR pStrOut, LPDWORD length);
	WORD put_Xfr400GroupByString(LPSTR pStrIn);
	WORD get_Xfr400OrderByString(LPSTR pStrOut, LPDWORD length);
	WORD put_Xfr400OrderByString(LPSTR pStrIn);
	WORD get_Xfr400JoinByString(LPSTR pStrOut, LPDWORD length);
	WORD put_Xfr400JoinByString(LPSTR pStrIn);
	WORD get_Xfr400HavingString(LPSTR pStrOut, LPDWORD length);
	WORD put_Xfr400HavingString(LPSTR pStrIn);
	WORD get_Xfr400SendDescFile(LPSTR pStrOut, LPDWORD length);
	WORD put_Xfr400SendDescFile(LPSTR pStrIn);
	WORD get_Xfr400ReceiveDescFile(LPSTR pStrOut, LPDWORD length);
	WORD put_Xfr400ReceiveDescFile(LPSTR pStrIn);
	WORD get_AssignedHostName(LPSTR pStrOut, LPDWORD length);
	WORD get_Xfr400LocalFile(LPSTR pStrOut, LPDWORD length);
	WORD put_Xfr400LocalFile(LPSTR pStrIn);
	WORD get_Xfr400RemoteFile(LPSTR pStrOut, LPDWORD length);
	WORD put_Xfr400RemoteFile(LPSTR pStrIn);
	WORD get_XfrLocalFile(LPSTR pStrOut, LPDWORD length);
	WORD put_XfrLocalFile(LPSTR pStrIn);
	WORD get_XfrRemoteFile(LPSTR pStrOut, LPDWORD length);
	WORD put_XfrRemoteFile(LPSTR pStrIn);
	WORD get_Xfr400SortSeq(LPSTR pStrOut, LPDWORD length);
	WORD put_Xfr400SortSeq(LPSTR pStrIn);
	WORD get_XFR400Objects(LPDWORD pdwOut);
	WORD put_XFR400Objects(DWORD dwIn);
	WORD get_Xfr400RefFile(LPSTR pStrOut, LPDWORD length);
	WORD put_Xfr400RefFile(LPSTR pStrIn);
	WORD get_CommandLineEnabled(LPDWORD pdwOut);
	WORD put_CommandLineEnabled(DWORD dwIn);
	WORD get_XfrStartTimeout(LPDWORD pdwOut);
	WORD put_XfrStartTimeout(DWORD dwIn);
	WORD get_HostcommTimeout(LPDWORD pdwOut);
	WORD put_HostcommTimeout(DWORD dwIn);
	WORD get_AutoReConnect(LPDWORD pdwOut);
	WORD put_AutoReConnect(DWORD dwIn);
	WORD get_Caption(LPSTR pStrOut, LPDWORD length);
	WORD put_Caption(LPSTR pStrIn);
	WORD get_IconTitle(LPSTR pStrOut, LPDWORD length);
	WORD put_IconTitle(LPSTR pStrIn);
	WORD get_CommPCSBufSize(LPDWORD pdwOut);
	WORD put_CommPCSBufSize(DWORD dwIn);
	WORD get_MenuVisible(LPDWORD pdwOut);
	WORD put_MenuVisible(DWORD dwIn);
	WORD get_PreserveEntryMode(LPDWORD pdwOut);
	WORD put_PreserveEntryMode(DWORD dwIn);
	WORD get_RestrictedCursor(LPDWORD pdwOut);
	WORD put_RestrictedCursor(DWORD dwIn);
	WORD get_VerticalCursorSpeed(LPDWORD pdwOut);
	WORD put_VerticalCursorSpeed(DWORD dwIn);
	WORD get_HorizontalCursorSpeed(LPDWORD pdwOut);
	WORD put_HorizontalCursorSpeed(DWORD dwIn);
	WORD get_TypeOf5250StatusLine(LPDWORD pdwOut);
	WORD put_TypeOf5250StatusLine(DWORD dwIn);
	WORD get_MessageQueue(LPSTR pStrOut, LPDWORD length);
	WORD put_MessageQueue(LPSTR pStrIn);
	WORD get_MessageLibrary(LPSTR pStrOut, LPDWORD length);
	WORD put_MessageLibrary(LPSTR pStrIn);
	WORD get_RulerCursorType(LPDWORD pdwOut);
	WORD put_RulerCursorType(DWORD dwIn);
	WORD get_RulerCursorVisible(LPDWORD pdwOut);
	WORD put_RulerCursorVisible(DWORD dwIn);
	WORD get_PrintCharsPerInch(LPDWORD pdwOut);
	WORD put_PrintCharsPerInch(DWORD dwIn);
	WORD get_PrintOutputReduction(LPDWORD pdwOut);
	WORD put_PrintOutputReduction(DWORD dwIn);
	WORD get_PrintMarginBottom(LPDWORD pdwOut);
	WORD put_PrintMarginBottom(DWORD dwIn);
	WORD get_PrintMarginTop(LPDWORD pdwOut);
	WORD put_PrintMarginTop(DWORD dwIn);
	WORD get_PrintMarginLeft(LPDWORD pdwOut);
	WORD put_PrintMarginLeft(DWORD dwIn);
	WORD get_PrintMarginRight(LPDWORD pdwOut);
	WORD put_PrintMarginRight(DWORD dwIn);
	WORD get_Xfr400ExistsAction(LPDWORD pdwOut);
	WORD put_Xfr400ExistsAction(DWORD dwIn);
	WORD get_ProfileMessage(LPSTR pStrOut, LPDWORD length);
	WORD put_ProfileMessage(LPSTR pStrIn);
	WORD get_HostNumlockControl(LPDWORD pdwOut);
	WORD put_HostNumlockControl(DWORD dwIn);
	WORD get_HostTypeaheadControl(LPDWORD pdwOut);
	WORD put_HostTypeaheadControl(DWORD dwIn);
	WORD get_PrintProportionalCPI(LPDWORD pdwOut);
	WORD put_PrintProportionalCPI(DWORD dwIn);
	WORD get_PCSIdleInterval(LPDWORD pdwOut);
	WORD put_PCSIdleInterval(DWORD dwIn);
	WORD get_PCSUseLowerMemory(LPDWORD pdwOut);
	WORD put_PCSUseLowerMemory(DWORD dwIn);
	WORD get_HLLAPIStyle(LPDWORD pdwOut);
	WORD put_HLLAPIStyle(DWORD dwIn);
	WORD get_PrintTransparent(LPDWORD pdwOut);
	WORD put_PrintTransparent(DWORD dwIn);
	WORD get_PrintOverrideHostFmt(LPDWORD pdwOut);
	WORD put_PrintOverrideHostFmt(DWORD dwIn);
	WORD get_PrintOverrideOrientation(LPDWORD pdwOut);
	WORD put_PrintOverrideOrientation(DWORD dwIn);
	WORD get_CloseDOSWindowOnExit(LPDWORD pdwOut);
	WORD put_CloseDOSWindowOnExit(DWORD dwIn);
	WORD get_Xfr400ShowProgress(LPDWORD pdwOut);
	WORD put_Xfr400ShowProgress(DWORD dwIn);
	WORD get_Xfr400Charset(LPDWORD pdwOut);
	WORD put_Xfr400Charset(DWORD dwIn);
	WORD get_IgnoreHostPrintReq(LPDWORD pdwOut);
	WORD put_IgnoreHostPrintReq(DWORD dwIn);
	WORD get_AutoFontSize(LPDWORD pdwOut);
	WORD put_AutoFontSize(DWORD dwIn);
	WORD get_FontName(LPSTR pStrOut, LPDWORD length);
	WORD put_FontName(LPSTR pStrIn);
	WORD get_FontStyle(LPDWORD pdwOut);
	WORD put_FontStyle(DWORD dwIn);
	WORD get_FontSize(LPDWORD pdwOut);
	WORD put_FontSize(DWORD dwIn);
	WORD get_VisibleTop(LPDWORD pdwOut);
	WORD put_VisibleTop(DWORD dwIn);
	WORD get_VisibleLeft(LPDWORD pdwOut);
	WORD put_VisibleLeft(DWORD dwIn);
	WORD get_VisibleColumns(LPDWORD pdwOut);
	WORD get_VisibleRows(LPDWORD pdwOut);
	WORD get_Xfr400Transport(LPDWORD pdwOut);
	WORD put_Xfr400Transport(DWORD dwIn);
	WORD get_Xfr400HostTP(LPDWORD pdwOut);
	WORD put_Xfr400HostTP(DWORD dwIn);
	WORD get_DefaultPorts(LPDWORD pdwOut);
	WORD put_DefaultPorts(DWORD dwIn);
	WORD get_XfrCurrentDirectory(LPSTR pStrOut, LPDWORD length);
	WORD put_XfrCurrentDirectory(LPSTR pStrIn);
	WORD get_Xfr400DeleteTrailingSpaces(LPDWORD pdwOut);
	WORD put_Xfr400DeleteTrailingSpaces(DWORD dwIn);
	WORD get_Xfr400AssumePositiveNumerics(LPDWORD pdwOut);
	WORD put_Xfr400AssumePositiveNumerics(DWORD dwIn);
	WORD get_XfrEnableTemplates(LPDWORD pdwOut);
	WORD put_XfrEnableTemplates(DWORD dwIn);
	WORD get_Xfr400CompatibleFDFFile(LPDWORD pdwOut);
	WORD put_Xfr400CompatibleFDFFile(DWORD dwIn);
	WORD get_Xfr400CompatibleAsciiFile(LPDWORD pdwOut);
	WORD put_Xfr400CompatibleAsciiFile(DWORD dwIn);
	WORD get_Xfr400ForceHexConversion(LPDWORD pdwOut);
	WORD put_Xfr400ForceHexConversion(DWORD dwIn);
	WORD get_XfrCloseDlgAfterTransfer(LPDWORD pdwOut);
	WORD put_XfrCloseDlgAfterTransfer(DWORD dwIn);
	WORD get_NWSAANetwork(LPDWORD pdwOut);
	WORD put_NWSAANetwork(DWORD dwIn);
	WORD get_UserName(LPSTR pStrOut, LPDWORD length);
	WORD put_UserName(LPSTR pStrIn);
	WORD get_Password(LPSTR pStrOut, LPDWORD length);
	WORD put_Password(LPSTR pStrIn);
	WORD get_AssignedServer(LPSTR pStrOut, LPDWORD length);
	WORD get_AssignedService(LPSTR pStrOut, LPDWORD length);
	WORD get_AssignedLUName(LPSTR pStrOut, LPDWORD length);
	WORD get_MouseShape(LPDWORD pdwOut);
	WORD put_MouseShape(DWORD dwIn);
	WORD get_SettingsFile(LPSTR pStrOut, LPDWORD length);
	WORD get_TelnetSysReq(LPDWORD pdwOut);
	WORD put_TelnetSysReq(DWORD dwIn);
	WORD get_TelnetAttn(LPDWORD pdwOut);
	WORD put_TelnetAttn(DWORD dwIn);
	WORD get_TelnetKeepAlive(LPDWORD pdwOut);
	WORD put_TelnetKeepAlive(DWORD dwIn);
	WORD get_TelnetKeepAliveTimeout(LPDWORD pdwOut);
	WORD put_TelnetKeepAliveTimeout(DWORD dwIn);
	WORD get_TelnetKeepAliveAverage(LPDWORD pdwOut);
	WORD get_TN3287ConnectType(LPDWORD pdwOut);
	WORD put_TN3287ConnectType(DWORD dwIn);
	WORD get_TelnetLocation(LPSTR pStrOut, LPDWORD length);
	WORD put_TelnetLocation(LPSTR pStrIn);
	WORD get_TelnetResponseMode(LPDWORD pdwOut);
	WORD put_TelnetResponseMode(DWORD dwIn);
	WORD get_TelnetProtocol(LPDWORD pdwOut);
	WORD get_PrintToComm(LPDWORD pdwOut);
	WORD put_PrintToComm(DWORD dwIn);
	WORD get_ShellDOSFullScreen(LPDWORD pdwOut);
	WORD put_ShellDOSFullScreen(DWORD dwIn);
	WORD get_C370Charset(LPDWORD pdwOut);
	WORD put_C370Charset(DWORD dwIn);
	WORD get_Support3270Partitions(LPDWORD pdwOut);
	WORD put_Support3270Partitions(DWORD dwIn);
	WORD get_CharacterSetIndicator(LPDWORD pdwOut);
	WORD put_CharacterSetIndicator(DWORD dwIn);
	WORD get_AlternateScreenRows(LPDWORD pdwOut);
	WORD get_ReconnectDelay(LPDWORD pdwOut);
	WORD put_ReconnectDelay(DWORD dwIn);
	WORD get_TNAPPNGateway(LPDWORD pdwOut);
	WORD put_TNAPPNGateway(DWORD dwIn);
	WORD get_NumberMouseButtons(LPDWORD pdwOut);
	WORD put_NumberMouseButtons(DWORD dwIn);
	WORD get_EnterKeyRepeat(LPDWORD pdwOut);
	WORD put_EnterKeyRepeat(DWORD dwIn);
	WORD get_RightControlKeyRepeat(LPDWORD pdwOut);
	WORD put_RightControlKeyRepeat(DWORD dwIn);
	WORD get_Locale(LPDWORD pdwOut);
	WORD put_Locale(DWORD dwIn);
	WORD get_LanguageOverride(LPDWORD pdwOut);
	WORD put_LanguageOverride(DWORD dwIn);
	WORD get_AsyncTransportEnabled(LPDWORD pdwOut);
	WORD put_AsyncTransportEnabled(DWORD dwIn);
	WORD get_OLEServerName(LPSTR pStrOut, LPDWORD length);
	WORD put_OLEServerName(LPSTR pStrIn);
	WORD get_HostNetworkAddress(LPSTR pStrOut, LPDWORD length);
	WORD get_LocationName(LPSTR pStrOut, LPDWORD length);
	WORD put_LocationName(LPSTR pStrIn);
	WORD get_SNADomainSuffix(LPSTR pStrOut, LPDWORD length);
	WORD put_SNADomainSuffix(LPSTR pStrIn);
	WORD get_APPNNetID(LPSTR pStrOut, LPDWORD length);
	WORD put_APPNNetID(LPSTR pStrIn);
	WORD get_Visible(LPDWORD pdwOut);
	WORD put_Visible(DWORD dwIn);
	WORD get_Top(LPDWORD pdwOut);
	WORD put_Top(DWORD dwIn);
	WORD get_Left(LPDWORD pdwOut);
	WORD put_Left(DWORD dwIn);
	WORD get_Height(LPDWORD pdwOut);
	WORD put_Height(DWORD dwIn);
	WORD get_Width(LPDWORD pdwOut);
	WORD put_Width(DWORD dwIn);
	WORD get_Fullname(LPSTR pStrOut, LPDWORD length);
	WORD get_Name(LPSTR pStrOut, LPDWORD length);
	WORD get_Path(LPSTR pStrOut, LPDWORD length);
	WORD get_PrintMetricUnits(LPDWORD pdwOut);
	WORD put_PrintMetricUnits(DWORD dwIn);
	WORD get_PrintProportionalLPI(LPDWORD pdwOut);
	WORD put_PrintProportionalLPI(DWORD dwIn);
	WORD get_PrintTransform(LPDWORD pdwOut);
	WORD put_PrintTransform(DWORD dwIn);
	WORD get_PrintMfrType(LPSTR pStrOut, LPDWORD length);
	WORD put_PrintMfrType(LPSTR pStrIn);
	WORD get_AllFontCharacterSets(LPDWORD pdwOut);
	WORD put_AllFontCharacterSets(DWORD dwIn);
	WORD get_FontCharacterSet(LPDWORD pdwOut);
	WORD put_FontCharacterSet(DWORD dwIn);
	WORD get_DisplayVariableWidthFonts(LPDWORD pdwOut);
	WORD put_DisplayVariableWidthFonts(DWORD dwIn);
	WORD get_UseOLESyntax(LPDWORD pdwOut);
	WORD put_UseOLESyntax(DWORD dwIn);
	WORD get_UseTableFormat(LPDWORD pdwOut);
	WORD put_UseTableFormat(DWORD dwIn);
	WORD get_TNAssociation(LPSTR pStrOut, LPDWORD length);
	WORD put_TNAssociation(LPSTR pStrIn);
	WORD get_XfrSpacesToUnderscores(LPDWORD pdwOut);
	WORD put_XfrSpacesToUnderscores(DWORD dwIn);
	WORD get_XfrUnderscoresToSpaces(LPDWORD pdwOut);
	WORD put_XfrUnderscoresToSpaces(DWORD dwIn);
	WORD get_XfrReceive8Dot3(LPDWORD pdwOut);
	WORD put_XfrReceive8Dot3(DWORD dwIn);
	WORD get_Xfr8Dot3FilenameCase(LPDWORD pdwOut);
	WORD put_Xfr8Dot3FilenameCase(DWORD dwIn);
	WORD get_PrintDefaultTabH(LPDWORD pdwOut);
	WORD put_PrintDefaultTabH(DWORD dwIn);
	WORD get_PrintDefaultTabV(LPDWORD pdwOut);
	WORD put_PrintDefaultTabV(DWORD dwIn);
	WORD get_Connected(LPDWORD pdwOut);
	WORD get_SubstituteDisplayChars(LPDWORD pdwOut);
	WORD put_SubstituteDisplayChars(DWORD dwIn);
	WORD get_DisplayMargins(LPDWORD pdwOut);
	WORD put_DisplayMargins(DWORD dwIn);
	WORD get_KeyboardErrorReset(LPDWORD pdwOut);
	WORD put_KeyboardErrorReset(DWORD dwIn);
	WORD get_AidFieldExit(LPDWORD pdwOut);
	WORD put_AidFieldExit(DWORD dwIn);
	WORD get_EnableHostAlarm(LPDWORD pdwOut);
	WORD put_EnableHostAlarm(DWORD dwIn);
	WORD get_HostCursorBlinkControl(LPDWORD pdwOut);
	WORD put_HostCursorBlinkControl(DWORD dwIn);
	WORD get_PrinterOrientation(LPDWORD pdwOut);
	WORD put_PrinterOrientation(DWORD dwIn);
	WORD get_KeyboardLocked(LPDWORD pdwOut);
	WORD get_KeyboardErrorAlarm(LPDWORD pdwOut);
	WORD put_KeyboardErrorAlarm(DWORD dwIn);
	WORD get_Xfr400StartRecord(LPDWORD pdwOut);
	WORD put_Xfr400StartRecord(DWORD dwIn);
	WORD get_Xfr400NumDisplayRecords(LPDWORD pdwOut);
	WORD put_Xfr400NumDisplayRecords(DWORD dwIn);
	WORD get_NewWindowOnOpen(LPDWORD pdwOut);
	WORD put_NewWindowOnOpen(DWORD dwIn);
	WORD get_NewSessionCurrentSettings(LPDWORD pdwOut);
	WORD put_NewSessionCurrentSettings(DWORD dwIn);
	WORD get_ShowDISOSSStatusDialog(LPDWORD pdwOut);
	WORD put_ShowDISOSSStatusDialog(DWORD dwIn);
	WORD get_SNAEngineCfgFile(LPSTR pStrOut, LPDWORD length);
	WORD put_SNAEngineCfgFile(LPSTR pStrIn);
	WORD get_StartupWorkingDir(LPSTR pStrOut, LPDWORD length);
	WORD get_NativeOS(LPSTR pStrOut, LPDWORD length);
	WORD get_HostControlsOutlineColor(LPDWORD pdwOut);
	WORD put_HostControlsOutlineColor(DWORD dwIn);
	WORD get_ModeName(LPSTR pStrOut, LPDWORD length);
	WORD put_ModeName(LPSTR pStrIn);
	WORD get_FQRemoteLu(LPSTR pStrOut, LPDWORD length);
	WORD put_FQRemoteLu(LPSTR pStrIn);
	WORD get_PrintEmulateFormFeed(LPDWORD pdwOut);
	WORD put_PrintEmulateFormFeed(DWORD dwIn);
	WORD get_PrintFlushOnEndOfJob(LPDWORD pdwOut);
	WORD put_PrintFlushOnEndOfJob(DWORD dwIn);
	WORD get_IgnoreEUICmdErr(LPDWORD pdwOut);
	WORD put_IgnoreEUICmdErr(DWORD dwIn);
	WORD get_NWSAACheckModel(LPDWORD pdwOut);
	WORD put_NWSAACheckModel(DWORD dwIn);
	WORD get_TelnetTerminalID(LPSTR pStrOut, LPDWORD length);
	WORD put_TelnetTerminalID(LPSTR pStrIn);
	WORD get_FoundTextColumn(LPDWORD pdwOut);
	WORD get_FoundFieldStartRow(LPDWORD pdwOut);
	WORD get_FoundFieldStartColumn(LPDWORD pdwOut);
	WORD get_FoundFieldEndRow(LPDWORD pdwOut);
	WORD get_FoundFieldEndColumn(LPDWORD pdwOut);
	WORD get_FoundFieldLength(LPDWORD pdwOut);
	WORD get_FoundTextRow(LPDWORD pdwOut);
	WORD get_CursorRow(LPDWORD pdwOut);
	WORD get_CursorColumn(LPDWORD pdwOut);
	WORD get_DisplayRows(LPDWORD pdwOut);
	WORD get_DisplayColumns(LPDWORD pdwOut);
	WORD get_MouseClickRow(LPDWORD pdwOut);
	WORD get_MouseClickColumn(LPDWORD pdwOut);
	WORD get_SelectionStartRow(LPDWORD pdwOut);
	WORD get_SelectionStartColumn(LPDWORD pdwOut);
	WORD get_SelectionEndRow(LPDWORD pdwOut);
	WORD get_SelectionEndColumn(LPDWORD pdwOut);
	WORD get_CurrentHotspotRow(LPDWORD pdwOut);
	WORD get_CurrentHotspotColumn(LPDWORD pdwOut);
	WORD get_HotlistShowRow(LPDWORD pdwOut);
	WORD get_HotlistShowColumn(LPDWORD pdwOut);
	WORD get_ShowRecentlyUsedFiles(LPDWORD pdwOut);
	WORD put_ShowRecentlyUsedFiles(DWORD dwIn);
	WORD get_RecentlyUsedFiles(LPDWORD pdwOut);
	WORD put_RecentlyUsedFiles(DWORD dwIn);
	WORD get_ShowReflectionWindows(LPDWORD pdwOut);
	WORD put_ShowReflectionWindows(DWORD dwIn);
	WORD get_APL(LPDWORD pdwOut);
	WORD put_APL(DWORD dwIn);
	WORD get_Recording(LPDWORD pdwOut);
	WORD get_SingleSignOn(LPDWORD pdwOut);
	WORD put_SingleSignOn(DWORD dwIn);
	WORD get_GraphicsExtendedColors(LPDWORD pdwOut);
	WORD put_GraphicsExtendedColors(DWORD dwIn);
	WORD get_TelnetUseSocks(LPDWORD pdwOut);
	WORD put_TelnetUseSocks(DWORD dwIn);
	WORD get_TelnetUseReflectionSecurityProxy(LPDWORD pdwOut);
	WORD put_TelnetUseReflectionSecurityProxy(DWORD dwIn);
	WORD get_RequestAuthentication(LPDWORD pdwOut);
	WORD put_RequestAuthentication(DWORD dwIn);
	WORD get_KerberosPrincipalRealm(LPSTR pStrOut, LPDWORD length);
	WORD put_KerberosPrincipalRealm(LPSTR pStrIn);
	WORD get_KerberosFlags(LPDWORD pdwOut);
	WORD put_KerberosFlags(DWORD dwIn);
	WORD get_KerberosRenew(LPDWORD pdwOut);
	WORD put_KerberosRenew(DWORD dwIn);
	WORD get_NWSAAUse20Query(LPDWORD pdwOut);
	WORD put_NWSAAUse20Query(DWORD dwIn);
	WORD get_NWSAARefreshScreen(LPDWORD pdwOut);
	WORD put_NWSAARefreshScreen(DWORD dwIn);
	WORD get_WordWrap(LPDWORD pdwOut);
	WORD put_WordWrap(DWORD dwIn);
	WORD get_RectangularSelection(LPDWORD pdwOut);
	WORD put_RectangularSelection(DWORD dwIn);
	WORD get_RecordPasswords(LPDWORD pdwOut);
	WORD put_RecordPasswords(DWORD dwIn);
	WORD get_GraphicsCursorX(LPDWORD pdwOut);
	WORD put_GraphicsCursorX(DWORD dwIn);
	WORD get_GraphicsCursorY(LPDWORD pdwOut);
	WORD put_GraphicsCursorY(DWORD dwIn);
	WORD get_MacroData(LPSTR pStrOut, LPDWORD length);
	WORD put_MacroData(LPSTR pStrIn);
	WORD get_UseIPV6(LPDWORD pdwOut);
	WORD put_UseIPV6(DWORD dwIn);
	WORD get_WinsockVersion(LPDWORD pdwOut);
	WORD put_WinsockVersion(DWORD dwIn);
	WORD get_GenerateDeviceNames(LPDWORD pdwOut);
	WORD put_GenerateDeviceNames(DWORD dwIn);
	WORD get_WordWrap3270(LPDWORD pdwOut);
	WORD put_WordWrap3270(DWORD dwIn);
	WORD get_WordWrap3270MinimumFieldLength(LPDWORD pdwOut);
	WORD put_WordWrap3270MinimumFieldLength(DWORD dwIn);
	WORD get_PasteWrapText(LPDWORD pdwOut);
	WORD put_PasteWrapText(DWORD dwIn);
	WORD get_PasteMaskProtectedFields(LPDWORD pdwOut);
	WORD put_PasteMaskProtectedFields(DWORD dwIn);
	WORD get_PasteUsingFieldDelimiters(LPDWORD pdwOut);
	WORD put_PasteUsingFieldDelimiters(DWORD dwIn);
	WORD get_PasteReplaceTabs(LPDWORD pdwOut);
	WORD put_PasteReplaceTabs(DWORD dwIn);
	WORD get_PasteTabReplacement(LPSTR pStrOut, LPDWORD length);
	WORD put_PasteTabReplacement(LPSTR pStrIn);
	WORD get_CutFillCharacter(LPDWORD pdwOut);
	WORD put_CutFillCharacter(DWORD dwIn);
	WORD get_BlanksBetweenFields(LPDWORD pdwOut);
	WORD put_BlanksBetweenFields(DWORD dwIn);
	WORD get_CopyInputFieldsOnly(LPDWORD pdwOut);
	WORD put_CopyInputFieldsOnly(DWORD dwIn);
	WORD get_GraphicsEnabled(LPDWORD pdwOut);
	WORD put_GraphicsEnabled(DWORD dwIn);
	WORD get_GraphicsCursorShape(LPDWORD pdwOut);
	WORD put_GraphicsCursorShape(DWORD dwIn);
	WORD get_GraphicsCrosshairColor(LPDWORD pdwOut);
	WORD put_GraphicsCrosshairColor(DWORD dwIn);
	WORD get_SerialNumber(LPSTR pStrOut, LPDWORD length);
	WORD get_VersionString(LPSTR pStrOut, LPDWORD length);
	WORD get_SelectionMode(LPDWORD pdwOut);
	WORD get_MaximumSessions(LPDWORD pdwOut);
	WORD get_NumberSessions(LPDWORD pdwOut);
	WORD get_StatusBarText(LPSTR pStrOut, LPDWORD length);
	WORD put_StatusBarText(LPSTR pStrIn);
	WORD get_ProfileName(LPSTR pStrOut, LPDWORD length);
	WORD get_StartupSettings(LPSTR pStrOut, LPDWORD length);
	WORD get_TelnetXSystem(LPDWORD pdwOut);
	WORD put_TelnetXSystem(DWORD dwIn);
	WORD get_BDTIgnoreScrollLock(LPDWORD pdwOut);
	WORD put_BDTIgnoreScrollLock(DWORD dwIn);
	WORD get_Xfr400NCS(LPDWORD pdwOut);
	WORD put_Xfr400NCS(DWORD dwIn);
	WORD get_CommandLineSwitches(LPSTR pStrOut, LPDWORD length);
	WORD get_MPTNIPAddress(LPSTR pStrOut, LPDWORD length);
	WORD put_MPTNIPAddress(LPSTR pStrIn);
	WORD get_CMSFileListCommand(LPSTR pStrOut, LPDWORD length);
	WORD put_CMSFileListCommand(LPSTR pStrIn);
	WORD get_TSOMemberListCommand(LPSTR pStrOut, LPDWORD length);
	WORD put_TSOMemberListCommand(LPSTR pStrIn);
	WORD get_TSOFileListCommand(LPSTR pStrOut, LPDWORD length);
	WORD put_TSOFileListCommand(LPSTR pStrIn);
	WORD get_HostFileListScript(LPSTR pStrOut, LPDWORD length);
	WORD put_HostFileListScript(LPSTR pStrIn);
	WORD get_HostFileListMacro(LPSTR pStrOut, LPDWORD length);
	WORD put_HostFileListMacro(LPSTR pStrIn);
	WORD get_XfrHostReturnCode(LPDWORD pdwOut);
	WORD get_ShowSOSIChars(LPDWORD pdwOut);
	WORD put_ShowSOSIChars(DWORD dwIn);
	WORD get_Preserve3270InsertState(LPDWORD pdwOut);
	WORD put_Preserve3270InsertState(DWORD dwIn);
	WORD get_SupportDBCSFeatures(LPDWORD pdwOut);
	WORD put_SupportDBCSFeatures(DWORD dwIn);
	WORD get_XfrIndNOSO(LPDWORD pdwOut);
	WORD put_XfrIndNOSO(DWORD dwIn);
	WORD get_XfrIndSO(LPDWORD pdwOut);
	WORD put_XfrIndSO(DWORD dwIn);
	WORD get_XfrApvUser(LPDWORD pdwOut);
	WORD put_XfrApvUser(DWORD dwIn);
	WORD get_AutoIME(LPDWORD pdwOut);
	WORD put_AutoIME(DWORD dwIn);
	WORD get_DBCSUnmappedChar(LPDWORD pdwOut);
	WORD put_DBCSUnmappedChar(DWORD dwIn);
	WORD get_PrintAutoWordWrap(LPDWORD pdwOut);
	WORD put_PrintAutoWordWrap(DWORD dwIn);
	WORD get_PrinterMPL(LPDWORD pdwOut);
	WORD put_PrinterMPL(DWORD dwIn);
	WORD get_PrinterMPP(LPDWORD pdwOut);
	WORD put_PrinterMPP(DWORD dwIn);
	WORD get_GraphicsDevice(LPDWORD pdwOut);
	WORD put_GraphicsDevice(DWORD dwIn);
	WORD get_CursorProgressionIndicator(LPDWORD pdwOut);
	WORD put_CursorProgressionIndicator(DWORD dwIn);
	WORD get_EventDefined(LPDWORD pdwOut);
	WORD get_IndAutoPositionCursor(LPDWORD pdwOut);
	WORD put_IndAutoPositionCursor(DWORD dwIn);
	WORD get_CreateShortcut(LPDWORD pdwOut);
	WORD put_CreateShortcut(DWORD dwIn);
	WORD get_ShortcutFolder(LPSTR pStrOut, LPDWORD length);
	WORD put_ShortcutFolder(LPSTR pStrIn);
	WORD get_CopyTrailingSpaces(LPDWORD pdwOut);
	WORD put_CopyTrailingSpaces(DWORD dwIn);
	WORD get_PrintAutoOrientation(LPDWORD pdwOut);
	WORD put_PrintAutoOrientation(DWORD dwIn);
	WORD get_BrowserCloseOption(LPDWORD pdwOut);
	WORD put_BrowserCloseOption(DWORD dwIn);
	WORD get_WebSecurity(LPDWORD pdwOut);
	WORD put_WebSecurity(DWORD dwIn);
	WORD get_TermKeyBufferOverflow(LPDWORD pdwOut);
	WORD get_TermKeyBufferSize(LPDWORD pdwOut);
	WORD get_WorkstationAddress(LPDWORD pdwOut);
	WORD put_WorkstationAddress(DWORD dwIn);
	WORD get_AS400LinkName(LPSTR pStrOut, LPDWORD length);
	WORD put_AS400LinkName(LPSTR pStrIn);
	WORD get_ReuseMSSNAPoolName(LPDWORD pdwOut);
	WORD put_ReuseMSSNAPoolName(DWORD dwIn);
	WORD get_QueryExitAll(LPDWORD pdwOut);
	WORD put_QueryExitAll(DWORD dwIn);
	WORD get_UseServiceLocation(LPDWORD pdwOut);
	WORD put_UseServiceLocation(DWORD dwIn);
	WORD get_SLPScope(LPSTR pStrOut, LPDWORD length);
	WORD put_SLPScope(LPSTR pStrIn);
	WORD get_SLPScopedServicesOnly(LPDWORD pdwOut);
	WORD put_SLPScopedServicesOnly(DWORD dwIn);
	WORD get_SLPDirectoryAgents(LPSTR pStrOut, LPDWORD length);
	WORD put_SLPDirectoryAgents(LPSTR pStrIn);
	WORD get_SLPDiscoveryRetryInterval(LPDWORD pdwOut);
	WORD put_SLPDiscoveryRetryInterval(DWORD dwIn);
	WORD get_SLPMulticastRetryInterval(LPDWORD pdwOut);
	WORD put_SLPMulticastRetryInterval(DWORD dwIn);
	WORD get_SLPDARequestTimeout(LPDWORD pdwOut);
	WORD put_SLPDARequestTimeout(DWORD dwIn);
	WORD get_SLPMaxMulticastReplyWait(LPDWORD pdwOut);
	WORD put_SLPMaxMulticastReplyWait(DWORD dwIn);
	WORD get_SLPMaxDiscoveryWait(LPDWORD pdwOut);
	WORD put_SLPMaxDiscoveryWait(DWORD dwIn);
	WORD get_SLPMaxSARequestWait(LPDWORD pdwOut);
	WORD put_SLPMaxSARequestWait(DWORD dwIn);
	WORD get_SLPAgentSearchMethod(LPDWORD pdwOut);
	WORD put_SLPAgentSearchMethod(DWORD dwIn);
	WORD get_SLPMulticastRadius(LPDWORD pdwOut);
	WORD put_SLPMulticastRadius(DWORD dwIn);
	WORD get_SLPPathMTU(LPDWORD pdwOut);
	WORD put_SLPPathMTU(DWORD dwIn);
	WORD get_SLPUseLoadBalancing(LPDWORD pdwOut);
	WORD put_SLPUseLoadBalancing(DWORD dwIn);
	WORD get_DelayAfterAID(LPDWORD pdwOut);
	WORD put_DelayAfterAID(DWORD dwIn);
	WORD get_RecordInitialSyncCmds(LPDWORD pdwOut);
	WORD put_RecordInitialSyncCmds(DWORD dwIn);
	WORD get_TelnetEnvironment(LPSTR pStrOut, LPDWORD length);
	WORD put_TelnetEnvironment(LPSTR pStrIn);
	WORD get_ClipboardSyntax(LPDWORD pdwOut);
	WORD put_ClipboardSyntax(DWORD dwIn);
	WORD get_ClipboardPrologue(LPDWORD pdwOut);
	WORD put_ClipboardPrologue(DWORD dwIn);
	WORD get_ThaiCompositionMode(LPDWORD pdwOut);
	WORD put_ThaiCompositionMode(DWORD dwIn);
	WORD get_ConnectMacro(LPSTR pStrOut, LPDWORD length);
	WORD put_ConnectMacro(LPSTR pStrIn);
	WORD get_ConnectMacroData(LPSTR pStrOut, LPDWORD length);
	WORD put_ConnectMacroData(LPSTR pStrIn);
	WORD get_ShowBytesRemaining(LPDWORD pdwOut);
	WORD put_ShowBytesRemaining(DWORD dwIn);
	WORD get_PrintDBCS2To3(LPDWORD pdwOut);
	WORD put_PrintDBCS2To3(DWORD dwIn);
	WORD get_PrintDBCSSmallerFont(LPDWORD pdwOut);
	WORD put_PrintDBCSSmallerFont(DWORD dwIn);
	WORD get_PrintSOSIPresentation(LPDWORD pdwOut);
	WORD put_PrintSOSIPresentation(DWORD dwIn);
	WORD get_PrintDBCSHorzFontSize(LPDWORD pdwOut);
	WORD put_PrintDBCSHorzFontSize(DWORD dwIn);
	WORD get_PrintDBCSVertFontSize(LPDWORD pdwOut);
	WORD put_PrintDBCSVertFontSize(DWORD dwIn);
	WORD get_PrintDBCSRotationAngle(LPDWORD pdwOut);
	WORD put_PrintDBCSRotationAngle(DWORD dwIn);
	WORD get_InputFieldUnderlines(LPDWORD pdwOut);
	WORD put_InputFieldUnderlines(DWORD dwIn);
	WORD get_DBCSUserDefinedCharacterSource(LPDWORD pdwOut);
	WORD put_DBCSUserDefinedCharacterSource(DWORD dwIn);
	WORD get_UserDefinedCharactersViaTelnet(LPDWORD pdwOut);
	WORD put_UserDefinedCharactersViaTelnet(DWORD dwIn);
	WORD get_IGCFEAT(LPDWORD pdwOut);
	WORD put_IGCFEAT(DWORD dwIn);
	WORD get_PrintFitForm(LPDWORD pdwOut);
	WORD put_PrintFitForm(DWORD dwIn);
	WORD get_PrintFitFormSize(LPDWORD pdwOut);
	WORD put_PrintFitFormSize(DWORD dwIn);
	WORD get_PrintFitUser(LPDWORD pdwOut);
	WORD put_PrintFitUser(DWORD dwIn);
	WORD get_PrintFitUserLength(LPDWORD pdwOut);
	WORD put_PrintFitUserLength(DWORD dwIn);
	WORD get_PrintFitUserWidth(LPDWORD pdwOut);
	WORD put_PrintFitUserWidth(DWORD dwIn);
	WORD get_PrintXlateANSIToASCII(LPDWORD pdwOut);
	WORD put_PrintXlateANSIToASCII(DWORD dwIn);
	WORD get_PrintTransverse(LPDWORD pdwOut);
	WORD put_PrintTransverse(DWORD dwIn);
	WORD get_ShowStatusBar(LPDWORD pdwOut);
	WORD put_ShowStatusBar(DWORD dwIn);
	WORD get_ShowTitleBar(LPDWORD pdwOut);
	WORD put_ShowTitleBar(DWORD dwIn);
	WORD get_PrintOverstrike(LPDWORD pdwOut);
	WORD put_PrintOverstrike(DWORD dwIn);
	WORD get_PrintSuppressNewlines(LPDWORD pdwOut);
	WORD put_PrintSuppressNewlines(DWORD dwIn);
	WORD get_AS400HostName(LPSTR pStrOut, LPDWORD length);
	WORD put_AS400HostName(LPSTR pStrIn);
	WORD get_AssignedAS400(LPSTR pStrOut, LPDWORD length);
	WORD get_UserDataDirectory(LPSTR pStrOut, LPDWORD length);
	WORD put_UserDataDirectory(LPSTR pStrIn);
	WORD get_TelnetEncryption(LPDWORD pdwOut);
	WORD put_TelnetEncryption(DWORD dwIn);
	WORD get_TelnetEncryptionStrength(LPDWORD pdwOut);
	WORD put_TelnetEncryptionStrength(DWORD dwIn);
	WORD get_TelnetEncryptionVerifyHostName(LPDWORD pdwOut);
	WORD put_TelnetEncryptionVerifyHostName(DWORD dwIn);
	WORD get_ColumnSeparatorStyle(LPDWORD pdwOut);
	WORD put_ColumnSeparatorStyle(DWORD dwIn);
	WORD get_WindowsTSEClientKeyboard(LPDWORD pdwOut);
	WORD put_WindowsTSEClientKeyboard(DWORD dwIn);
	WORD get_SettingsFileUpdate(LPDWORD pdwOut);
	WORD get_AutoUpdateFile(LPSTR pStrOut, LPDWORD length);
	WORD put_AutoUpdateFile(LPSTR pStrIn);
	WORD get_AutoUpdateSave(LPDWORD pdwOut);
	WORD put_AutoUpdateSave(DWORD dwIn);
	WORD get_SharedMacrosFolder(LPSTR pStrOut, LPDWORD length);
	WORD put_SharedMacrosFolder(LPSTR pStrIn);
	WORD get_SettingsUpdateType(LPDWORD pdwOut);
	WORD put_SettingsUpdateType(DWORD dwIn);
	WORD get_TransformRWebToXML(LPSTR pStrOut, LPDWORD length);
	WORD put_TransformRWebToXML(LPSTR pStrIn);
	WORD get_TransformXMLtoSettings(LPSTR pStrOut, LPDWORD length);
	WORD put_TransformXMLtoSettings(LPSTR pStrIn);
	WORD get_TransformXMLtoSettingsJ(LPSTR pStrOut, LPDWORD length);
	WORD put_TransformXMLtoSettingsJ(LPSTR pStrIn);
	WORD get_TransformXMLtoRWeb(LPSTR pStrOut, LPDWORD length);
	WORD put_TransformXMLtoRWeb(LPSTR pStrIn);
	WORD get_TransformSettingsToHTML(LPSTR pStrOut, LPDWORD length);
	WORD put_TransformSettingsToHTML(LPSTR pStrIn);

};


#endif // __r8class_H_
