VERSION 5.00
Begin VB.Form Chart 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "VB/Reflection/Excel Data Analysis"
   ClientHeight    =   2985
   ClientLeft      =   7815
   ClientTop       =   75
   ClientWidth     =   5970
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   8.25
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   Icon            =   "chart.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   2985
   ScaleWidth      =   5970
   Begin VB.OptionButton optColumn 
      Caption         =   "Column"
      Height          =   255
      Left            =   2520
      TabIndex        =   10
      Top             =   1200
      Width           =   975
   End
   Begin VB.OptionButton optArea 
      Caption         =   "Area"
      Height          =   255
      Left            =   2520
      TabIndex        =   6
      Top             =   1920
      Width           =   975
   End
   Begin VB.OptionButton optPie 
      Caption         =   "Pie"
      Height          =   255
      Left            =   2520
      TabIndex        =   9
      Top             =   1560
      Width           =   975
   End
   Begin VB.OptionButton optBar 
      Caption         =   "Bar"
      Height          =   255
      Left            =   2520
      TabIndex        =   8
      Top             =   840
      Value           =   -1  'True
      Width           =   975
   End
   Begin VB.Frame fraChartType 
      Caption         =   "Chart Type"
      Height          =   1815
      Left            =   2400
      TabIndex        =   7
      Top             =   480
      Width           =   1215
   End
   Begin VB.CommandButton cmdQuitExcel 
      BackColor       =   &H80000005&
      Caption         =   "Quit Excel"
      Enabled         =   0   'False
      Height          =   495
      Left            =   4080
      TabIndex        =   5
      Top             =   2040
      Width           =   1575
   End
   Begin VB.CommandButton cmdChartHostData 
      BackColor       =   &H80000005&
      Caption         =   "Chart Host Data"
      Enabled         =   0   'False
      Height          =   495
      Left            =   4080
      TabIndex        =   4
      Top             =   1200
      Width           =   1575
   End
   Begin VB.CommandButton cmdLinkToExcel 
      BackColor       =   &H80000005&
      Caption         =   "Link to Excel"
      Height          =   495
      Left            =   4080
      TabIndex        =   3
      Top             =   360
      Width           =   1575
   End
   Begin VB.CommandButton cmdQuitReflection 
      BackColor       =   &H80000005&
      Caption         =   "Quit Reflection"
      Enabled         =   0   'False
      Height          =   495
      Left            =   240
      TabIndex        =   2
      Top             =   2040
      Width           =   1695
   End
   Begin VB.CommandButton cmdReadHostData 
      BackColor       =   &H80000005&
      Caption         =   "Read Host Data"
      Enabled         =   0   'False
      Height          =   495
      Left            =   240
      TabIndex        =   1
      Top             =   1200
      Width           =   1695
   End
   Begin VB.CommandButton cmdLinkToReflection 
      BackColor       =   &H80000005&
      Caption         =   "Link to Reflection"
      Height          =   495
      Left            =   240
      TabIndex        =   0
      Top             =   360
      Width           =   1695
   End
End
Attribute VB_Name = "Chart"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'------------------------------------------------------------------------
' Name..........CHART.FRM
' Description...Main form for Visual Basic sample program which
'               demonstrates the use of the Reflection API. CHART
'               demonstrates how to control and move data between
'               Reflection and Excel via the Reflection API and OLE.
' Language......Visual Basic
' Rev. Date.....11/14/96, updated for Reflection for IBM 6.1 11/96
' Copyright.....(c) 1996 WRQ Inc.
'
' You have a royalty-free right to use, modify, reproduce and distribute
' this file (and/or any modified version) in any way you find useful,
' provided that you agree that WRQ has no warranty, obligation or
' liability for its contents.
'------------------------------------------------------------------------
Option Explicit

Const DATA_FIELD_LENGTH = 6
Const xl3DArea = -4098
Const xl3DBar = -4099
Const xl3DColumn = -4100
Const xl3DPie = -4102

Dim ExcelSheet As Object
Dim ExcelObject As Object
Dim ExcelChart As Object
Dim ExcelChartRange As Object

Dim linkedToReflection As Integer
Dim linkedToExcel As Integer
Dim hostDataRead As Integer
Dim hostDataCharted As Integer

Dim chartData(5) As String
Dim bytePtr As Integer

Dim screenRow As Integer
Dim screenCol As Integer
Dim chartRow As Integer
Dim chartCol As Integer

Dim fieldBuf As String * DATA_FIELD_LENGTH
Dim fieldBufSize As Long

Dim tempString As String

Private Sub cmdChartHostData_Click()

    On Error GoTo cmdChartHostData_Click_Error

    ' Move the data from the array into the Microsoft Excel chart
    For chartRow = 1 To 5
        chartCol = 1
        bytePtr = 1
        While bytePtr < Len(chartData(chartRow))
            tempString = Mid(chartData(chartRow), bytePtr, (InStr(bytePtr, chartData(chartRow), ",") - bytePtr))
            ExcelSheet.Cells(chartRow, chartCol).Value = tempString
            bytePtr = InStr(bytePtr, chartData(chartRow), ",") + 1
            chartCol = chartCol + 1
        Wend
    Next chartRow

    ' Draw the chart
    ExcelSheet.Application.Visible = False
    Set ExcelChart = ExcelSheet.Application.Charts.Add
    hostDataCharted = True
    SetExcelChartType
    ExcelChart.Elevation = 30
    ExcelChart.Rotation = 40
    ExcelChart.Activate
    ExcelSheet.Application.Visible = True
    
    RefreshForm
    Show
    Exit Sub

cmdChartHostData_Click_Error:

    OLEErrorMsg Error$
    Exit Sub

End Sub

Private Sub cmdLinkToExcel_Click()
'
' Create a new sheet in Excel
'
    On Error GoTo cmdLinkToExcel_Click_error

    ' Define a Microsoft Excel chart
    Set ExcelObject = CreateObject("Excel.application")
    ExcelObject.Visible = True
    ExcelObject.Workbooks.Add
    Set ExcelSheet = ExcelObject.ActiveWorkbook.Worksheets("Sheet1")
    Set ExcelChartRange = ExcelSheet.Range("A1:E5")
    ExcelChartRange.Select
    
    linkedToExcel = True
    RefreshForm
    Show
    Exit Sub

cmdLinkToExcel_Click_error:
    OLEErrorMsg Error$
    Exit Sub
    
End Sub

Private Sub cmdLinkToReflection_Click()
'
' Search for an active instance of Reflection, and link to the first one
' found.
'

    ' See if there is an active instance of Reflection, and if not, attempt
    ' to start one
    If Not IsItActive() Then
        Load Start
        Start.Top = Top - Start.Height + 1000
        If Start.Top < 1 Then
            Start.Top = Top + Height - 1000
        End If
        Start.Left = Left + ((Width - Start.Width) / 2)
        Start.Show 1
        Show
        If Not gotReflectionStarted Then
            ErrorMessageBox ("Unable to find or start Reflection. Please start Reflection, then restart this application.")
            End
        Else
            ' Turn off typeahead to guarantee that API calls that modify
            ' the display (such as rcTransmitTerminalKey) and commands
            ' that read from the display (such as rcGetDisplayText and
            ' rcGetCursorPos) will be executed synchronously.
            r8.TypeAhead = False
        End If
    End If

    linkedToReflection = True
    RefreshForm
    Show

End Sub

Private Sub cmdQuitExcel_Click()

    ExcelObject.Quit
    linkedToExcel = False
    hostDataCharted = False
    RefreshForm

End Sub

Private Sub cmdQuitReflection_Click()

    On Error GoTo QuitReflectionError

    ' Turn off the "This will end your Reflection session" exit
    ' confirmation dialog. Then exit Reflection.

    r8.QueryExit = False
    r8.Exit
    Set r8 = Nothing

    linkedToReflection = False
    hostDataRead = False
    RefreshForm

    Exit Sub

QuitReflectionError:

    OLEErrorMsg Error$
    Exit Sub
        
End Sub

Private Sub cmdReadHostData_Click()
'
' Go to the "International Kayak Enterprises" demo host screen, and pull
' in the data we'll be charting in Excel.
'
    Dim found As Integer
    Dim foundRow As Integer
    Dim foundColumn As Integer

    Dim atKayakScreen As Integer
    
    Dim termType As Long
    Dim termModel As Long
    Dim TransportType As Long
    Dim simulationFilename As String

    On Error GoTo cmdReadHostData_Click_Error

    ' Are we already where we want to be?
    atKayakScreen = False
    found = FindDisplayString("KAYAK ENTERPRISES", 1, 1, foundRow, foundColumn)
    If found And (foundRow = 1) Then
        found = FindDisplayString("1991 Sales by Region", 3, 1, foundRow, foundColumn)
        If found And (foundRow = 3) Then
            atKayakScreen = True
        End If
    End If

    ' If we're not already there, then attempt to do session setup for the
    ' Demo host, connect, sign on, and go to the "International Kayak
    ' Enterprises" screen
    If Not atKayakScreen Then
        ' If there's already a connected established, warn the user that
        ' they will lose the connection as a result of running this demo.
        ' Give them a chance to bail out.
        If r8.Connected Then
            Load Disco
            Disco.Top = Top - (Height / 3)
            If Disco.Top < 1 Then
                Disco.Top = Top + (2 * (Height / 3))
            End If
            Disco.Left = Left + ((Width - Disco.Width) / 2)
            Disco.Show 1

            ' User's been warned, and has chosen to abandon their current
            ' connection, so...
            r8.Disconnect
        End If

        'Get information about the connection
        termType = r8.SessionType
        termModel = r8.TerminalModel
        TransportType = r8.TransportType
        simulationFilename = r8.HostName
  
        ' If Host Name is already set up, then the .SIM file's location
        ' is already known. Otherwise, assume that it's in the default
        ' location.
        If InStr(1, simulationFilename, ".sim", 1) = 0 Then
            If (termType = rc5250Terminal) Then
                simulationFilename = r8.Path & "support\ribm5250.sim"
            Else
                simulationFilename = r8.Path & "support\ribm3270.sim"
            End If
            r8.HostName = simulationFilename
        End If

        If (termType = rc5250Terminal) Then
            r8.SetupSession rc5250Terminal, rc31792, rcDemo
        Else
            r8.SetupSession rc3270Terminal, rc3270MODEL2E, rcDemo
        End If

        r8.Connect
            
        If Not r8.Connected Then
            ErrorMessageBox "Please connect to Demo host and execute ""KAYAK"" transaction, then restart."
            Exit Sub
        End If

            r8.WaitForEvent rcKbdEnabled, "0:0:30", "0:0:0", 1, 1
            r8.TransmitAnsi "chart"
            r8.TransmitTerminalKey rcIBMTabKey
            r8.TransmitAnsi "chart"
            r8.TransmitTerminalKey rcIBMEnterKey
            r8.WaitForEvent rcKbdEnabled, "0:0:30", "0:0:0", 1, 1
            r8.TransmitAnsi "kayak"
            r8.TransmitTerminalKey rcIBMEnterKey
            r8.WaitForEvent rcKbdEnabled, "0:0:30", "0:0:0", 1, 1

    End If      'Not at Kayak Screen

    ' Initialize array with the row and column headings
    chartData(1) = ",Q1,Q2,Q3,Q4,"
    chartData(2) = "East Coast,"
    chartData(3) = "Midwest,"
    chartData(4) = "Mountain,"
    chartData(5) = "West Coast,"
    
    ' Load in the data from the workstation display
    screenRow = 8
    For chartRow = 2 To 5
        For screenCol = 25 To 55 Step 10
            fieldBufSize = 6
            fieldBuf = r8.GetDisplayText(screenRow, screenCol, fieldBufSize)
            ' Remove commas from data
            bytePtr = InStr(fieldBuf, ",")
            While bytePtr
                tempString = Mid(fieldBuf, 1, (bytePtr - 1))
                fieldBuf = tempString & Mid(fieldBuf, (bytePtr + 1), (Len(fieldBuf) - bytePtr))
                bytePtr = InStr(fieldBuf, ",")
            Wend
            chartData(chartRow) = chartData(chartRow) & Trim(fieldBuf) & ","
        Next screenCol
        screenRow = screenRow + 1
    Next chartRow
    
    hostDataRead = True
    RefreshForm
    
    Exit Sub

cmdReadHostData_Click_Error:

    OLEErrorMsg Error$
    Exit Sub

End Sub

Private Sub Form_Load()

    Top = 1
    Left = 1

    linkedToReflection = False
    linkedToExcel = False
    hostDataRead = False
    hostDataCharted = False

End Sub

Private Sub optArea_Click()

    SetExcelChartType

End Sub

Private Sub optBar_Click()

    SetExcelChartType

End Sub

Private Sub optColumn_Click()

  SetExcelChartType

End Sub

Private Sub optPie_Click()

    SetExcelChartType

End Sub

Private Sub RefreshForm()
'
' Set/Clear the Enabled property of the buttons on the form, depending on
' the current state of things.
'
    If linkedToReflection Then
        cmdLinkToReflection.Enabled = False
        cmdQuitReflection.Enabled = True
        If hostDataRead Then
            cmdReadHostData.Enabled = False
        Else
            cmdReadHostData.Enabled = True
        End If
    Else
        cmdLinkToReflection.Enabled = True
        cmdQuitReflection.Enabled = False
        cmdReadHostData.Enabled = False
    End If

    If linkedToExcel Then
        cmdLinkToExcel.Enabled = False
        cmdQuitExcel.Enabled = True
        If hostDataRead And (Not hostDataCharted) Then
            cmdChartHostData.Enabled = True
        Else
            cmdChartHostData.Enabled = False
        End If
    Else
        cmdLinkToExcel.Enabled = True
        cmdQuitExcel.Enabled = False
        cmdChartHostData.Enabled = False
    End If
                                            
End Sub

Private Sub SetExcelChartType()

    If linkedToExcel And hostDataCharted Then
        If optColumn.Value = True Then
            ExcelChart.Type = xl3DColumn
        Else
            If optPie.Value = True Then
                ExcelChart.Type = xl3DPie
            Else
                If optArea.Value = True Then
                    ExcelChart.Type = xl3DArea
                Else
                    ExcelChart.Type = xl3DBar
                End If
            End If
        End If
    End If

End Sub

