Attribute VB_Name = "LINK2"
'------------------------------------------------------------------------
' Name..........LINK2.BAS
' Description...Subroutine for Visual Basic sample programs to
'               demonstrate use of the Reflection API.  LINK2.BAS makes
'               an OLE connection to a running copy of Reflection, using
'               a specific OLE server name if one is passed as a parameter.
'               It also contains some utility procedures, GetWord,
'               GetCommandLine, and MsgCaption.
' Language......Visual Basic
' Rev. Date.....11/14/96, updated 11/96 for Reflection for IBM 6.1
' Rev. Date.....5/29/98, updated for Reflection for IBM 7.0 5/98
'
'              Copyright 1994, 1995, 1996, 1998 WRQ, Inc.  All Rights Reserved.
'
' You have a royalty-free right to use, modify, reproduce and distribute
' this file (and/or any modified version) in any way you find useful,
' provided that you agree that WRQ has no warranty, obligation or
' liability for its contents.
'------------------------------------------------------------------------

Option Explicit

Global r8 As Object             'This will be our reference to Reflection
Global serverName As String     'OLE server name of an instance of Reflection

'Link to a running Reflection, using the OLE Automation Server
'Name passed as a command line parameter if one was
Function FindReflection(serverName As String) As Integer

    'If we try to create or get an OLE object and fail
    'then an error will be thrown
    On Error GoTo ObjectError

    If serverName <> "" Then
        Set r8 = GetObject(serverName)
    Else
        'Hook the first running instance of r8win we can find.
        'Note that this is a weakness of OLE -- we'll always get
        'the most recently loaded copy
        Set r8 = GetObject(, "ReflectionIBM.Application")
    End If
    FindReflection = True
    Exit Function

ObjectError:

    If Err = 429 Then
        MsgBox "Unable to find Reflection. Start Reflection, then restart this application.", 48
        FindReflection = False
        Exit Function
    ElseIf Err = 432 Then
        MsgBox "Unable to connect to Reflection using OLE server name " & serverName, 48
        FindReflection = False
        Exit Function
    Else
        OLEErrorMsg Error$
        'The user chose "Continue" in OLEErrorMsg, so return true
        FindReflection = True
    End If
    Exit Function

End Function

Sub GetCommandLine()
    Dim i As Integer, dummy As Integer
    Dim parm As String

    i = 1
    
    'Loop until we've read all the command line parameters

    Do
        parm = UCase$(GetWord(Command$, i))

        Select Case parm
            'DUMMY is included only as an example
            Case "DUMMY"
                dummy = True
            Case ""
                'do nothing, we'll exit loop below
            Case Else
                'We don't know what the server name may be so
                'we'll take anything that's not picked up above
                serverName = parm
        End Select

        i = i + 1

    Loop Until parm = ""

End Sub

Function GetWord(ByVal word_string As String, ByVal word_no As Integer) As String
'Extracts word indicated by word_no from string.
'Word_no starts from 1, not 0

    Dim start_pos, end_pos, temp, i As Integer
    
    word_string = Trim$(word_string) & " "  'No leading spaces, one trailing
    start_pos = 1

    For i = 1 To word_no

        'loop past consecutive spaces
        Do
            temp = start_pos
            end_pos = InStr(start_pos, word_string, " ")
            'if end = start then found a space immediately, must be a double
            If end_pos = start_pos Then start_pos = start_pos + 1
        Loop Until start_pos <> end_pos + 1
    
        If end_pos = 0 Then
            word_no = 0
            Exit For
        End If
        start_pos = end_pos + 1   'Move past space just found, then try again
    Next i
    
    If word_no Then
        start_pos = temp
        GetWord = Mid$(word_string, start_pos, end_pos - start_pos)
    Else
        GetWord = ""
    End If

End Function

Sub MsgCaption(message As String)
    Static oldCaption As String

    If message <> "" Then
        'Store the old caption, if we haven't already done it
        If oldCaption = "" Then oldCaption = Screen.ActiveForm.Caption
        Screen.ActiveForm.Caption = message
        Screen.MousePointer = 11     'hourglass
    Else
        'Restore the old caption
        Screen.ActiveForm.Caption = oldCaption
        Screen.MousePointer = 0      'back to normal
        oldCaption = ""
    End If

End Sub

