VERSION 5.00
Begin VB.Form Summary 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "VB/Reflection Mail Message Summary"
   ClientHeight    =   3345
   ClientLeft      =   75
   ClientTop       =   375
   ClientWidth     =   9390
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   8.25
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   Icon            =   "summary.frx":0000
   LinkTopic       =   "Form2"
   MaxButton       =   0   'False
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   3345
   ScaleWidth      =   9390
   Begin VB.CommandButton cmdSumRefresh 
      BackColor       =   &H80000005&
      Caption         =   "&Refresh"
      Height          =   615
      Left            =   7920
      TabIndex        =   9
      Top             =   840
      Width           =   1335
   End
   Begin VB.CommandButton cmdSumExit 
      BackColor       =   &H80000005&
      Caption         =   "&Exit"
      Height          =   615
      Left            =   7920
      TabIndex        =   4
      Top             =   2160
      Width           =   1335
   End
   Begin VB.CommandButton cmdSumSend 
      BackColor       =   &H80000005&
      Caption         =   "&Send Message"
      Height          =   495
      Left            =   5760
      TabIndex        =   3
      Top             =   2640
      Width           =   1575
   End
   Begin VB.CommandButton cmdSumDelete 
      BackColor       =   &H80000005&
      Caption         =   "&Delete Message"
      Height          =   495
      Left            =   3240
      TabIndex        =   2
      Top             =   2640
      Width           =   1575
   End
   Begin VB.CommandButton cmdSumView 
      BackColor       =   &H80000005&
      Caption         =   "&View Message"
      Default         =   -1  'True
      Height          =   495
      Left            =   720
      TabIndex        =   1
      Top             =   2640
      Width           =   1575
   End
   Begin VB.ListBox lstSumMessages 
      BeginProperty Font 
         Name            =   "Fixedsys"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1410
      Left            =   120
      TabIndex        =   0
      Top             =   720
      Width           =   7695
   End
   Begin VB.Label lblSumDate 
      Caption         =   "Date"
      Height          =   255
      Left            =   6840
      TabIndex        =   8
      Top             =   360
      Width           =   495
   End
   Begin VB.Label lblSumDescription 
      Caption         =   "Description"
      Height          =   255
      Left            =   2880
      TabIndex        =   7
      Top             =   360
      Width           =   1095
   End
   Begin VB.Label lblSumAddress 
      Caption         =   "Address"
      Height          =   255
      Left            =   1560
      TabIndex        =   6
      Top             =   360
      Width           =   735
   End
   Begin VB.Label lblSumUserId 
      Caption         =   "User ID"
      Height          =   255
      Left            =   360
      TabIndex        =   5
      Top             =   360
      Width           =   735
   End
End
Attribute VB_Name = "Summary"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'------------------------------------------------------------------------
' Name..........SUMMARY.FRM
' Description...Main form for Visual Basic sample program which
'               demonstrates the use of the Reflection API. MAIL front-
'               ends the AS/400 OfficeVision mail application. MAIL reads
'               the workstation display and sends kestrokes to the host
'               by making calls to Reflection.
'               tested on OS/400 v4r2
' Language......Visual Basic 5.0
' Rev. Date.....11/14/96, updated 11/96 for Reflection for IBM 6.1
' Rev. Date.....5/29/98, updated 5/98 for Reflection for IBM 7.0
'
'              Copyright 1994, 1995, 1996, 1998 WRQ, Inc.  All Rights Reserved.
'
' You have a royalty-free right to use, modify, reproduce and distribute
' this file (and/or any modified version) in any way you find useful,
' provided that you agree that WRQ has no warranty, obligation or
' liability for its contents.
'------------------------------------------------------------------------
Option Explicit

Const FIRST_MESSAGE_ROW = 9         ' top row of host message summary
Const LAST_MESSAGE_ROW = 20         ' bottom row of host message summary
Const BOTTOM_STRING_ROW = 21        ' row at which "Bottom" appears
Const BOTTOM_STRING_COLUMN = 74     ' column at which "Bottom" appears
Const SUMMARY_COLUMN = 7            ' start column of message info
Const SUMMARY_WIDTH = 73            ' width of message info
Const USER_ID_OFFSET = 12           ' offset of User ID string

Dim busy As Integer                 ' flag to prevent reentrant calls
                                    '  while waiting for host
Dim atMyScreen As Integer           ' flag used while evaluating
                                    '  workstation display

Private Sub cmdSumDelete_Click()
'
' Search the host message summary for a message matching the one that's
' currently selected in the Message Summary list box. If found, delete
' it, then re-display the message summary.
'
    Dim found As Integer

    On Error GoTo cmdSumDelete_Click_Error

    If busy = True Then
        Beep
    Else
        'Change caption to show message
        MsgCaption "Waiting for Host Response"

        found = LocateMessage()
        If found Then

            r8.TransmitAnsi "4"
            r8.TransmitTerminalKey rcIBMEnterKey
            r8.WaitForEvent rcKbdEnabled, "0:60", "0:0", 1, 1
            r8.TransmitTerminalKey rcIBMEnterKey
            r8.WaitForEvent rcKbdEnabled, "0:60", "0:0", 1, 1

            DisplayMessageSummary
        Else
            'Set Caption back
            MsgCaption ""

            ErrorMessageBox "Unable to delete - message not found"
        End If
    End If
    Exit Sub

cmdSumDelete_Click_Error:
    
    OLEErrorMsg Error$
    Exit Sub

End Sub

Private Sub cmdSumExit_Click()

    End

End Sub

Private Sub cmdSumRefresh_Click()
'
' Refresh the Message Summary list box from the host "Work with Mail"
' message summary.
'
    If busy = True Then
        Beep
    Else
        DisplayMessageSummary
    End If

End Sub

Private Sub cmdSumSend_Click()
'
' Show the Send Message dialog, which allows the user to post a mail
' message.
'
    If busy = True Then
        Beep
    Else
        'Loading this form also switches to host's "Send" screen,
        'which may take a little time
        MsgCaption "Waiting for Host Response"
        Load Send
        Send.Top = Top - (Height / 3)
        If Send.Top < 1 Then
            Send.Top = Top + (2 * (Height / 3))
        End If
        Send.Left = Left + ((Width - Send.Width) / 2)
        MsgCaption ""

        Send.Show 1
    End If
    
End Sub

Private Sub cmdSumView_Click()
'
' Search the host message summary for a message matching the one that's
' currently selected in the Message Summary list box. If found, show its
' contents via the View Message dialog.
'
    Dim found As Integer

On Error GoTo cmdSumView_Click_Error
    
    If busy = True Then
        Beep
    Else
        MsgCaption "Waiting for Host Response"
        found = LocateMessage()
        If found Then
            
            r8.TransmitAnsi "5"
            r8.TransmitTerminalKey rcIBMEnterKey
            r8.WaitForEvent rcKbdEnabled, "0:60", "0:0", 1, 1

            Load View
            View.Top = Top - (Height / 3)
            If View.Top < 1 Then
                View.Top = Top + (2 * (Height / 3))
            End If
            View.Left = Left + ((Width - View.Width) / 2)
            MsgCaption ""
            
            View.Show 1
        Else
            MsgCaption ""

            ErrorMessageBox "Unable to view - message not found"
        End If
    End If
    Exit Sub

cmdSumView_Click_Error:

    OLEErrorMsg Error$
    Exit Sub

End Sub

Private Sub DisplayMessageSummary()
'
' Fill the Message Summary listbox with entries read from the host "Work
' with Mail" message summary.
'
    Dim row As Long
    Dim lineBuf As String
    Dim lineBufSize As Long
    
    Dim found As Integer
    Dim foundRow As Integer
    Dim foundColumn As Integer

    Dim atSummaryBottom As Integer
    
    MsgCaption "Waiting for Host Response"

    cmdSumView.Enabled = False
    cmdSumDelete.Enabled = False
    lstSumMessages.Clear

    ' Confirm that we're at the OfficeVision "Work with Mail" screen and,
    ' if so, go to the first screen of the mail summary
    atMyScreen = False
    found = FindDisplayString("Work with Mail", 1, 1, foundRow, foundColumn)
    If found And (foundRow = 1) Then
        found = FindDisplayString("Type options below", 3, 1, foundRow, foundColumn)
        If found And (foundRow = 3) Then
            found = FindDisplayString("Opt  Status      User ID   Address", 8, 1, foundRow, foundColumn)
            If found And (foundRow = 8) Then
                atMyScreen = True
            End If
        End If
    End If

    On Error GoTo DisplayMessageSummary_Error

    If atMyScreen Then

        r8.TransmitTerminalKey rcIBMF10Key
        r8.WaitForEvent rcKbdEnabled, "0:60", "0:0", 1, 1

    Else
        MsgCaption ""
        ErrorMessageBox "Unable to process mail. Must begin at the OfficeVision ""Work with Mail"" screen."
        End
    End If

    ' Read the message summary and display it in the Message Summary list
    ' box
    atSummaryBottom = False
    Do
        For row = FIRST_MESSAGE_ROW To LAST_MESSAGE_ROW
            lineBuf = Space(SUMMARY_WIDTH)
            lineBufSize = SUMMARY_WIDTH
            
            lineBuf = r8.GetDisplayText(row, SUMMARY_COLUMN, lineBufSize)

            If Mid(lineBuf, 1, 7) = "MESSAGE" Then
                lstSumMessages.AddItem Mid(lineBuf, (USER_ID_OFFSET + 1), (SUMMARY_WIDTH - USER_ID_OFFSET))
            End If
        Next row

        found = FindDisplayString("Bottom", BOTTOM_STRING_ROW, BOTTOM_STRING_COLUMN, foundRow, foundColumn)
        If found And (foundRow = BOTTOM_STRING_ROW) And (foundColumn = BOTTOM_STRING_COLUMN) Then
            atSummaryBottom = True
        Else

            r8.TransmitTerminalKey rcIBMPageDownKey
            r8.WaitForEvent rcKbdEnabled, "0:60", "0:0", 1, 1

        End If
    Loop Until (atSummaryBottom = True)

    r8.TransmitTerminalKey rcIBMF10Key
    r8.WaitForEvent rcKbdEnabled, "0:60", "0:0", 1, 1

        MsgCaption ""
    Exit Sub

DisplayMessageSummary_Error:

    OLEErrorMsg Error$
    Exit Sub

End Sub

Private Sub Form_Load()

    Dim found As Integer        ' returned by FindDisplayString
    Dim foundRow As Integer     ' row at which string was found
    Dim foundColumn As Integer  ' column at which string was found
    Dim found2 As Integer        ' returned by FindDisplayString
    Dim foundRow2 As Integer     ' row at which string was found
    Dim foundColumn2 As Integer  ' column at which string was found
    
    busy = False

    Top = 1
    Left = 1
    Show

    ' Show the Link dialog, which allows the user to link to an instance
    ' of Reflection
    Load Link

    Link.Top = Top - (Height / 3)
    If Link.Top < 1 Then
        Link.Top = Top + (2 * (Height / 3))
    End If
    Link.Left = Left + ((Width - Link.Width) / 2)
    Link.Show 1

    MsgCaption "Waiting for Host Response"

    ' Determine if we're at the OfficeVision "Work with Mail" screen, our
    ' home base
    atMyScreen = False
    found = FindDisplayString("Work with Mail", 1, 1, foundRow, foundColumn)
    If found And (foundRow = 1) Then
        found = FindDisplayString("Type options below", 3, 1, foundRow, foundColumn)
        If found And (foundRow = 3) Then
            found = FindDisplayString("Opt  Status      User ID   Address", 8, 1, foundRow, foundColumn)
            If found And (foundRow = 8) Then
                atMyScreen = True
            End If
        End If
    End If

    On Error GoTo Form_Load_Error

    ' If we're at the "OfficeVision/400" screen, go to the "Work with
    ' Mail " screen"
    ' 5/29/98 added "OfficeVision for OS/400" for new version of officevision
    If Not atMyScreen Then
        found = FindDisplayString("OfficeVision/400", 1, 1, foundRow, foundColumn)
        found2 = FindDisplayString("OfficeVision for OS/400", 1, 1, foundRow2, foundColumn2)
        If (found And (foundRow = 1)) Or (found2 And (foundRow2 = 1)) Then
            found = FindDisplayString("2. Mail", 6, 1, foundRow, foundColumn)
            If found And (foundRow = 6) Then
                found = FindDisplayString("3. Send message", 7, 1, foundRow, foundColumn)
                If found And (foundRow = 7) Then
                    
                    r8.TransmitTerminalKey rcIBMTabKey
                    r8.TransmitAnsi "2"
                    r8.TransmitTerminalKey rcIBMEnterKey
                    r8.WaitForEvent rcKbdEnabled, "0:60", "0:0", 1, 1
                    
                    atMyScreen = True
                End If
            End If
        End If
    End If

    ' If we're at the "Send Message" screen, go to the "Work with Mail"
    ' screen
    If Not atMyScreen Then
        found = FindDisplayString("Send Message", 1, 1, foundRow, foundColumn)
        If found And (foundRow = 1) Then
            found = FindDisplayString("Type message and information below.", 3, 1, foundRow, foundColumn)
            If found And (foundRow = 3) Then
                found = FindDisplayString("-----Addressees------", 12, 1, foundRow, foundColumn)
                If found And (foundRow = 12) Then
                    r8.TransmitTerminalKey rcIBMF3Key
                    r8.WaitForEvent rcKbdEnabled, "0:60", "0:0", 1, 1
                    r8.TransmitAnsi "2"
                    r8.TransmitTerminalKey rcIBMEnterKey
                    r8.WaitForEvent rcKbdEnabled, "0:60", "0:0", 1, 1

                    atMyScreen = True
                End If
            End If
        End If
    End If

    ' If we're at the "AS/400 Main Menu" screen, go to the "Work with
    ' Mail " screen"
    ' 5/29/98  will also try to run "strofc" from submenus with "===>" prompts
    If Not atMyScreen Then
        found = FindDisplayString("AS/400 Main Menu", 1, 1, foundRow, foundColumn)
        found2 = FindDisplayString("===>", 20, 1, foundRow2, foundColumn2)
        If found And (foundRow = 1) Or found2 And (foundRow2 = 20) Then
            found = FindDisplayString("Selection or command", 19, 1, foundRow, foundColumn)
            If found And (foundRow = 19) Then
                If found2 And (foundRow2 = 20) Then
                    r8.TransmitTerminalKey rcIBMTabKey
                    r8.TransmitAnsi "STROFC"
                    r8.TransmitTerminalKey rcIBMEnterKey
                    r8.WaitForEvent rcKbdEnabled, "0:60", "0:0", 1, 1
                    r8.TransmitAnsi "2"
                    r8.TransmitTerminalKey rcIBMEnterKey
                    r8.WaitForEvent rcKbdEnabled, "0:60", "0:0", 1, 1
                    
                    atMyScreen = True
                End If
            End If
        End If
    End If

    If Not atMyScreen Then
        MsgCaption ""
        ErrorMessageBox "Unable to process mail. Must begin at the OfficeVision ""Work with Mail"" screen."
        End
    Else
        DisplayMessageSummary
    End If
    
    Exit Sub

Form_Load_Error:

    OLEErrorMsg Error$
    Exit Sub

End Sub

Private Function LocateMessage() As Integer
'
' Search the host message summary for a message matching the one that's
' currently selected in the Message Summary list box. If found, place the
' cursor in the input field to its left.
'
    Dim row As Long
    Dim lineBuf As String * SUMMARY_WIDTH
    Dim lineBufSize As Long

    Dim found As Integer
    Dim foundRow As Integer
    Dim foundColumn As Integer

    Dim matchFound As Integer
    Dim atSummaryBottom As Integer

    ' First, look to see if the message is on the current host screen
    row = FIRST_MESSAGE_ROW
    matchFound = False

    On Error GoTo LocateMessage_Error

    Do
        lineBuf = Space(SUMMARY_WIDTH)
        lineBufSize = SUMMARY_WIDTH
        
        lineBuf = r8.GetDisplayText(row, SUMMARY_COLUMN, lineBufSize)
            If (Mid(lineBuf, 1, 7) = "MESSAGE") And (Mid(lineBuf, (USER_ID_OFFSET + 1), (SUMMARY_WIDTH - USER_ID_OFFSET)) = lstSumMessages.Text) Then
                matchFound = True
            End If
    row = row + 1
    Loop Until (matchFound = True) Or (row > LAST_MESSAGE_ROW)

    ' If not found on current screen, then restart the search from the
    ' first message summary screen
    If Not matchFound Then

        r8.TransmitTerminalKey rcIBMF10Key
        r8.WaitForEvent rcKbdEnabled, "0:60", "0:0", 1, 1

        atSummaryBottom = False
        Do
            row = FIRST_MESSAGE_ROW
            Do
                lineBuf = Space(SUMMARY_WIDTH)
                lineBufSize = SUMMARY_WIDTH

                lineBuf = r8.GetDisplayText(row, SUMMARY_COLUMN, lineBufSize)
                
                    If (Mid(lineBuf, 1, 7) = "MESSAGE") And (Mid(lineBuf, (USER_ID_OFFSET + 1), (SUMMARY_WIDTH - USER_ID_OFFSET)) = lstSumMessages.Text) Then
                        matchFound = True
                    End If
                row = row + 1
            
            Loop Until matchFound Or (row > LAST_MESSAGE_ROW)

            If Not matchFound Then
                found = FindDisplayString("Bottom", BOTTOM_STRING_ROW, BOTTOM_STRING_COLUMN, foundRow, foundColumn)
                If found And (foundRow = BOTTOM_STRING_ROW) And (foundColumn = BOTTOM_STRING_COLUMN) Then
                    atSummaryBottom = True
                Else

                    r8.TransmitTerminalKey rcIBMPageDownKey
                    r8.WaitForEvent rcKbdEnabled, "0:60", "0:0", 1, 1

                End If
            End If
        Loop Until (matchFound = True) Or (atSummaryBottom = True)
    End If

    If matchFound Then
        r8.MoveCursor (row - 1), 2
    End If

    LocateMessage = matchFound
    Exit Function

LocateMessage_Error:

    OLEErrorMsg Error$
    Exit Function

End Function

Private Sub lstSumMessages_Click()

    cmdSumView.Enabled = True
    cmdSumDelete.Enabled = True

End Sub

Private Sub lstSumMessages_DblClick()

    cmdSumView_Click

End Sub

