Attribute VB_Name = "R8SERVER2"
'============================================================================
'Program:     R8SERVER (see r8server.mak for list of files)
'
'Products:    Reflection for IBM version 6.1
'
'Description: Demonstrates use of Reflection as an OLE server to log on,
'             gather host data and display or export it to Microsoft Excel,
'             transfer files, and close the connection.  Command line
'             parameters allow a manager to load Reflection invisibly,
'             and either to choose a specific previously running copy or
'             load a new one
'
'
'Functions:   Most functions are self-explanatory.  Major groups are:
'
'             Read startup parameters: Load procedure of R8Server form
'             Load and log on:  StartReflection, MakeConnection, Logon
'             Scrape screen:  GatherData, ParseData
'             Display and export host data:  Load procedure of ShowData form,
'                                            ExportExcel
'             Show Reflection transfer screen: XfrFile
'             Disconnect:  Disconnect, Cleanup
'
'
'
'Rev. Date:   11/96
'
'              Copyright 1996, WRQ, Inc.  All Rights Reserved.
'
' You have a royalty-free right to use, modify, reproduce and distribute
' this file (and/or any modified version) in any way you find useful,
' provided that you agree that WRQ has no warranty, obligation or
' liability for its contents.
'
'============================================================================

Option Explicit

'Constants
Global Const AS400 = 1
Global Const MAINFRAME = 2

Const SIMFILEPATH = "SUPPORT\"

'Variables
Global r8 As Object
Global serverName As String     'name of a running copy of Reflection,
                                'passed at startup
Global userid As String
Global password As String
Global invisible As Integer     'set at Load if the "invisible" startup
                                'parameter is used

'Using variant because we're going to take these in
'as strings and pass them to Excel as numbers
Global dataArray(1 To 4, 1 To 5) As Variant

Dim wasVisible As Integer
Dim lineLength As Integer
Dim maxRows As Integer





'See if Reflection is already connected to something
'and try to identify the connection for the user
Function AlreadyConnected() As Integer

    Dim s  As String, s2 As String      'quick 'n dirty variables
    Dim n As Long
    Dim msgText As String, LF As String

    LF = Chr$(10)
    
    If r8.Connected Then
        'Query r8 about the connection settings
        s = r8.HostName
        n = r8.TransportType

        Select Case n
            'not a complete list
            Case rcTelnet               '1
                s2 = "Telnet"
            Case rcDemo                 '3
                s2 = "Demonstration"
            Case rcNSRouter
                s2 = "NS Router"
            Case rcMSSNAServer
                s2 = "MS SNA Server"
            Case Else
                s2 = "Magic"
        End Select

        msgText = "Already connected to " & UCase$(s) & " via "
        msgText = msgText & UCase$(s2) & " protocol." & LF & LF
        msgText = msgText & "Do you want to disconnect now?"

        'Tell the user about the connection and ask what to do
        If MsgBox(msgText, 36, "Connect") = 6 Then
            r8.Disconnect
            AlreadyConnected = False
        Else
            AlreadyConnected = True
        End If
    Else
        'Not connected
        AlreadyConnected = False
    End If

End Function

'Called if logon cancelled, or user clicks Disconnect or Quit
Sub Cleanup()
    
    'Handle OLE error if we've been invoked before the r8 object
    'was set up, or if Cleanup has already happened
    On Error GoTo CleanupError

    If serverName <> "" Then
        'If we're using a previously loaded copy then put things
        'back the way they were

        'Note that if your Reflection started out invisible,
        'this is going to make it invisible again, so you'd
        'better have some mechanism for calling it and unloading it.
        r8.Visible = wasVisible
        Set r8 = Nothing
    Else
        'If we loaded a fresh copy, then unload it.
        r8.Exit
        Set r8 = Nothing
    End If
Exit Sub

CleanupError:
Exit Sub

End Sub

Sub Disconnect()
    
    MsgBox "Disconnecting now.", 16
    r8.Disconnect
    Cleanup
    
End Sub

'Returns the first numeric element of a string.
'At this point that's just the first word starting with a number
'but we could check by converting to a long to see if there's an error.
Function FindNumber(dataLine As String) As String
    Const SPACE1 = " "
    Dim i As Integer, c As String

    For i = 1 To Len(dataLine)
        c = Mid$(dataLine, i, 1)
        If c >= "0" And c <= "9" Then
            If InStr(i, dataLine, SPACE1) Then
                FindNumber = Mid$(dataLine, i, InStr(i, dataLine, SPACE1) - i)
            Else
                FindNumber = Mid$(dataLine, i, Len(dataLine))
            End If
            Exit Function
        End If
    Next i

    'We didn't find a numeric expression
    FindNumber = ""

End Function

Function FindSimFiles()
    Dim simFileName As String
    Dim msgText As String
    Dim LF As String
    
    LF = Chr$(10)
    
    
    'Dir$ function will return an empty string if it
    'can't find the files.  We also need to trap
    'the error generated if the path itself is wrong.
    On Error Resume Next
    simFileName = Dir$(r8.Path & SIMFILEPATH & "*.sim")

    If simFileName = "" Then
        msgText = "This program needs the files ""RIBM5250.SIM"" and ""RIBM3270.SIM"""
        msgText = msgText & " in order to connect to the demonstration hosts." & LF & LF
        msgText = msgText & "It looks for those files in the default directory, """
        msgText = msgText & r8.Path & SIMFILEPATH & """" & LF & LF & "Please put the files into"
        msgText = msgText & " that directory, or modify the constant ""SIMFILEPATH"""
        msgText = msgText & "in the R8SERVE.BAS module."
        
        MsgBox msgText, 16, "CAN'T FIND FILES"
        
        FindSimFiles = False
    Else
        FindSimFiles = True
    End If
        

End Function

Sub GatherData(host As Integer)
    '(Note that we're not using the host parameter because we don't
    'need it.  But if we wanted to transmit an AS/400-specific key,
    'for example, then we could.)

    Dim dataCommand As String
    Dim dataTitle As String
    Dim dataBuffer As String

    dataCommand = "Kayak"
    dataTitle = "INTERNATIONAL KAYAK ENTERPRISES"

    r8.TransmitAnsi dataCommand
    r8.TransmitTerminalKey rcIBMEnterKey

    On Error GoTo GatherDataError
    r8.WaitForDisplayString dataTitle, "5", 0, 0
        
    'Here we're just taking the whole screen into the dataBuffer
    'string, starting at the top.  We'll format it later.
    dataBuffer = r8.GetDisplayText(1, 1, maxRows * lineLength)
    ParseData (dataBuffer)
    ShowData
Exit Sub

GatherDataError:

    MsgBox "Error: Couldn't find host data", 16
    Exit Sub

End Sub

'Extracts word indicated by word_no from string.
'Word_no starts from 1, not 0
Function GetWord(ByVal word_string As String, ByVal word_no As Integer) As String

    Dim start_pos, end_pos, temp, i As Integer
    
    word_string = Trim$(word_string) & " "  'No leading spaces, one trailing
    start_pos = 1

    For i = 1 To word_no

        'loop past consecutive spaces
        Do
            temp = start_pos
            end_pos = InStr(start_pos, word_string, " ")
            'if end = start then found a space immediately, must be a double
            If end_pos = start_pos Then start_pos = start_pos + 1
        Loop Until start_pos <> end_pos + 1
    
        If end_pos = 0 Then
            word_no = 0
            Exit For
        End If
        start_pos = end_pos + 1   'Move past space just found, then try again
    Next i
    
    If word_no Then
        start_pos = temp
        GetWord = Mid$(word_string, start_pos, end_pos - start_pos)
    Else
        GetWord = ""
    End If

End Function

Function Logon(host As Integer) As Integer

    Dim userRow As Integer, userColumn As Integer
    
    If Not MakeConnection(host) Then
        Logon = False
        Exit Function
    End If
    
    'Ask the user for name and password
    frmLogon.Show 1    'Logon form is modal, user must
                       'fill it out (or cancel) to continue
  
   'If user pressed Cancel then return false
    If userid = "" And password = "" Then
    Logon = False
        Exit Function
    End If

    On Error GoTo Logon_Error

   'If Reflection's window has been minimized then pop it back up.
    If r8.WindowState = rcMinimized Then
        r8.WindowState = rcRestored
    End If

   'Find the first unprotected field on the screen and put the
   'cursor there.  (It's probably there already, but just in case.)
    r8.FindField 1, 1, rcNext, rcUnProtected
    userRow = r8.FoundFieldStartRow
    userColumn = r8.FoundFieldStartColumn
        
    r8.MoveCursor userRow, userColumn
        
   'Now send the userid and password
    r8.TransmitAnsi userid
    r8.TransmitTerminalKey rcIBMTabKey
    r8.TransmitAnsi password
    r8.TransmitTerminalKey rcIBMEnterKey

   'Now wait till it's safe to continue
    r8.WaitForEvent rcKbdEnabled, 5, 0, 1, 1
    Logon = True

    Exit Function

Logon_Error:

    MsgBox "Unable to log on to host.  Error was: " & Error$, 16, "Logon Error"
    Logon = False
    Exit Function
End Function

Function MakeConnection(host As Integer) As Integer
    Dim hostPrompt As String

    'Check for existing connection (and disconnect
    'if the user agrees)
    If AlreadyConnected() Then
        MakeConnection = False
        Exit Function
    End If

    On Error GoTo ConnectError
    
    If Not FindSimFiles() Then Error 9999
    'A dummy error number because Error requires one

    'Command line parameter tells us whether to be visible
    If invisible Then
        r8.Visible = False
    Else
        r8.Caption = "OLE Server"
        r8.Visible = True
    End If
    
    If host = MAINFRAME Then
        r8.HostName = r8.Path & SIMFILEPATH & "ribm3270.sim"
        r8.SetupSession rc3270Terminal, rc3270MODEL2E, rcDemo
        hostPrompt = "USERID"
    Else
        r8.HostName = r8.Path & SIMFILEPATH & "ribm5250.sim"
        r8.SetupSession rc5250Terminal, rc31792, rcDemo
        hostPrompt = "User"
    End If
    
    r8.Connect
    'An error will be thrown if the hostprompt isn't found before timeout
    r8.WaitForDisplayString hostPrompt, "5", 0, 0

    'Get information about host screen size for use by GatherData
    maxRows = r8.DisplayRows
    lineLength = r8.DisplayColumns


    MakeConnection = True
    Exit Function

ConnectError:
    MakeConnection = False
    Exit Function

End Function

'There are probably a million ways to parse data once you've scraped the screen.
'In this case we know the first word of the lines with values we want,
'so we're using that as the key.
Sub ParseData(dataBuffer As String)
    Dim lineCount As Integer, i As Integer  'line counts
    Dim j As Integer, k As Integer          'dimension counters for dataArray
    Dim dataLine As String, keyWord As String, numString As String

    'See how many lines there are
    '(adding 1 to allow for any remainder, since this is integer division)
    lineCount = (Len(dataBuffer) / lineLength) + 1
    j = 1

    For i = 1 To lineCount
         dataLine = Mid$(dataBuffer, (i * lineLength) + 1, lineLength)
        
        'Get the first word from the line
        keyWord = GetWord(dataLine, 1)

        Select Case keyWord

           'These are the ones we want
           Case "East", "Midwest", "Mountain", "West"
               k = 1
               'Go through the string, extracting numeric expressions
               Do While FindNumber(dataLine) <> ""
                   numString = FindNumber(dataLine)
                   dataArray(j, k) = numString
                   'Keep the part of the string after the number we found, and loop
                   dataLine = Right$(dataLine, Len(dataLine) - (InStr(dataLine, numString) + Len(numString)))
                   k = k + 1
               Loop
               j = j + 1
        End Select
    Next i

End Sub

Sub ShowData()
    
    frmShowData.Show 1
    
End Sub

'Start a new Reflection, or find one whose OLE Automation Server
'Name was passed as a command line parameter
Function StartReflection(serverName As String) As Integer
     Dim objTest As Integer

    'If we try to create or get an OLE object and fail
    'then an error will be thrown
    On Error GoTo ObjectError

    If serverName <> "" Then
        Set r8 = GetObject(serverName)
        'Record visible setting to restore later
        wasVisible = r8.Visible
    Else
        'Load an instance of r8, unless we're already hooked to one (this
        'will occur if the user chose to log on and not disconnect)
        If r8 Is Nothing Then Set r8 = CreateObject("ReflectionIBM.Application")
    End If
        
    StartReflection = True
    Exit Function

ObjectError:
    StartReflection = False
    Exit Function

End Function

Sub XfrFile(host As Integer)

    'Note that we could use one of the send- or receivefile methods
    'instead of bringing up this dialog.
    
    r8.TransferDlg

End Sub

