Attribute VB_Name = "VBTLOAD"
'------------------------------------------------------------------------
' Name..........VBTLOAD.BAS
' Description...Subroutine for Visual Basic sample program to demonstrate
'               the use of the Reflection API.  This module checks for an
'               active instance of Reflection, sees what terminal type
'               it's set to, and loads the matching VB terminal form
'
' Language......Visual Basic 5.0
' Rev. Date.....5/26/98, written for Reflection for IBM 7.0
'
'              Copyright 1998 WRQ, Inc.  All Rights Reserved.
'
' You have a royalty-free right to use, modify, reproduce and distribute
' this file (and/or any modified version) in any way you find useful,
' provided that you agree that WRQ has no warranty, obligation or
' liability for its contents.
'------------------------------------------------------------------------

Option Explicit

Sub Main()

    Dim errText As String

    'Look for and attach to a running copy of Reflection
    If Not IsItActive() Then
        Beep
        errText = "Unable to find Reflection. Start Reflection, then restart this application"
        MsgBox errText, , "VB/Reflection Terminal Error"
        End
    End If

    'See which type of terminal Reflection is configured for and load the
    'appropriate terminal form in VB
    If r8.SessionType = rc3270Terminal Then
        VB3270.Show
    ElseIf r8.SessionType = rc5250Terminal Then
        VB5250.Show
    Else
        errText = "You must configure Reflection as either a 3270 terminal or a 5250 terminal to use this program."
        MsgBox errText, , "VB/Reflection Terminal Error"
        End
    End If

End Sub

