'========================================================================
' Name..........APIERROR.BAS
' Description...Subroutine for Visual Basic sample program which
'               demonstrates the use of the Reflection API. APIERROR.BAS
'               displays an error message if an API error occurs.
' Language......Visual Basic
' Rev. Date.....11/22/96
' Copyright.....(c) 1996 WRQ Inc.
'========================================================================
Option Explicit

Sub RptApiErr (rcError As Integer)
'
' If the API error code is not zero, then call Reflection for the
' corresponding error message text, and display it.
'
    Const MAX_API_STRING_LENGTH = 128
    
    Dim errString As String * MAX_API_STRING_LENGTH
    Dim errLen As Long
    Dim rcError2 As Integer

    If rcError Then
        errLen = MAX_API_STRING_LENGTH
        errString = Space$(MAX_API_STRING_LENGTH)
        rcError2 = rcGetErrorString(rcError, errString, errLen)
        If rcError2 Then
            errString = "Unable to retrieve error description from Reflection."
        End If
        MsgBox "Error #" & Str$(rcError) & " - " & Left$(errString, errLen), , "Reflection API Error"
    End If

End Sub

