Attribute VB_Name = "FIND1"
'========================================================================
' Name..........FIND.BAS
' Description...Subroutine for Visual Basic sample program which
'               demonstrates the use of the Reflection API. FIND.BAS
'               searches the workstation display for a given string.
' Language......Visual Basic
' Rev. Date.....12/14/94, updated for Reflection for IBM 6.0 12/95
' Rev. Date.....5/29/98, updated for Reflection for IBM 7.0 5/98
'              Copyright 1994, 1995, 1998 WRQ, Inc.  All Rights Reserved.
'
' You have a royalty-free right to use, modify, reproduce and distribute
' this file (and/or any modified version) in any way you find useful,
' provided that you agree that WRQ has no warranty, obligation or
' liability for its contents.
'========================================================================
Option Explicit

Function FindDisplayString(searchString As String, startRow As Integer, startCol As Integer, findRow As Integer, findCol As Integer) As Integer
'
' Searches the Reflection workstation display for a given string,
' starting at a given row/column. Returns boolean to indicate whether the
' string was found and, if so, the row/column at which it was found.
' Parameters are...
'
'   searchString - string for which the workstation display is searched
'   startRow - display row at which to start the search
'   startCol - display column at which to start the search
'   findRow - (return) row in which the text was found (zero if not)
'   findCol - (return) column in which the text was found (zero if not)
'
    
    Dim maxRow As Long      ' last row on the workstation display
    Dim maxCol As Long      ' last column on the workstation display

    Dim displayRow As Long
    Dim displayCol As Long
    Dim displayBuf As String
    Dim displayBufSize As Long

    Dim stringCol As Integer

    findRow = 0
    findCol = 0

    On Error GoTo FindDisplayString_Error

    maxRow = r8.DisplayRows
    maxCol = r8.DisplayColumns

    If ((startRow >= 1) And (startCol >= 1) And (startRow <= maxRow) And (startCol <= maxCol)) Then
        displayRow = startRow
        displayCol = startCol
        Do
            displayBuf = r8.GetDisplayText(displayRow, displayCol, maxCol - displayCol + 1)
            stringCol = InStr(1, displayBuf, searchString, 0)

            If (stringCol <> 0) Then
                findRow = displayRow
                findCol = stringCol + (displayCol - 1)
                FindDisplayString = True
                Exit Function
            End If

            displayRow = displayRow + 1
            displayCol = 1
        Loop While (displayRow <= maxRow)
    End If
                
    FindDisplayString = False

    Exit Function

FindDisplayString_Error:

    OLEErrorMsg Error$
    Exit Function
        
End Function

