/* NetSoft 11/10/94

   Enhanced E32APPC.H for WIN 95.

   The following is extracted from IBM PCS/400 V2R3 EHNAPPC.H and EHNDTW.H
   with some modifications.

   Note that all "int" and "unsigned" are double word in WIN32.
   All far pascal are #define as nothing under WIN32 and no need to decalre
   DLL calls as extern. So all extern far pascal are taken out.

   Also, WIN 3.1 NS/Router currently has no support for EHNAPPC_QueryFullSystems
   verb. However, we will support this in WIN95.

   Also, the following new verbs are added to support multithreading :

    EHNAPPC_PostOnReceipt
    EHNAPPC_PostOnRTS
    EHNAPPC_CancelPost

   Note that only these 3 new verbs can be issued by a second thread. All
   other APPC verbs must be single threaded.

   EHNAPPC_PostOnReceipt and EHNAPPC_PostOnRts are automatically cancelled
   upon EHNAPPC_Deallocate, EHNAPPC_SendError, EHNAPPC_ReceiveAndWait or
   EHNAPPC_ReceiveImmediate verb.

   A new verb is added to be able to get a list of configured systems (as opposed to
   EHNAPPC_QuerySystems which only returns systems that are started) :

    EHNAPPC_QueryConfiguredSystems

   Also, EHNAPPC_GetCapabilities is enhanced to be able to check if the above
   4 new verbs are supported. Use the struct appctrcap_query with capability
   identifier of EHNAPPC_CAP_POST.

   All API calls are catered with one DLL only (E32APPC.DLL) and user must
   link with new library (E32APPC.LIB)

   A new verb EHNAPPC_Cleanup is added for user to cleanup the E32APPC.DLL.
   When user load and unload the E32APPC.DLL library multiple times in the
   application or user use the static link library option, user MUST call
   the EHNAPPC_Cleanup for every unload library operation before ending the
   application. User should NOT call EHNAPPC_Cleanup to clean up E32APPC.DLL
   when user is in the DLL_PROCESS_DETACH of a DLL, because the needed
   supporting modules are already unloaded by the system.

*/
/*
    11/22/95    Add the new verb EHNAPPC_ReceiveAllocate to support the
    incoming Allocation request.
*/
/*
    02/12/96    Add new EHNAPPC_QueryFullConfigutedSystems function.
*/

/*********************************************************************/
#ifndef   EHNAPPC_H    // If this file was not already included then
#define   EHNAPPC_H    // prevent this file from being included again
/**********************************************************************
 
  PURPOSE:
    This include file contain constants, data structures and function
    prototypes to be used to interface with AS/400 PC Support APPC
    router in the Microsoft Windows environment.
 
    All string inputs are expected to be in ANSI ASCII character set,
    and all output strings are in ANSI ASCII.
 
  ROUTINES:
    EHNAPPC_Allocate
    EHNAPPC_ExtendedAllocate
    EHNAPPC_SendData
    EHNAPPC_ReceiveAndWait
    EHNAPPC_ReceiveImmediate
    EHNAPPC_Deallocate
    EHNAPPC_Confirm
    EHNAPPC_SendError
    EHNAPPC_PrepareToReceive
    EHNAPPC_Confirmed
    EHNAPPC_RqsToSend
    EHNAPPC_Flush
    EHNAPPC_QuerySystems
    EHNAPPC_QueryFullSystems
    EHNAPPC_GetCapabilities
    EHNAPPC_IsRouterLoaded
    EHNAPPC_QueryConvState
    EHNAPPC_QueryUserId
    EHNAPPC_GetAttribute
    EHNAPPC_GetDefaultSystem
    EHNAPPC_RemoteProgramStart
    EHNAPPC_Cleanup
    EHNAPPC_ReceiveAllocate
    EHNAPPC_QueryFullConfiguredSystems
**********************************************************************/

#ifndef _MYLIB_
	#define E32APPC_API __declspec(dllimport)
#else
	#define E32APPC_API __declspec(dllexport)
#endif
 
#pragma pack(4)
 
typedef enum {  /* enums for "type" on Allocate requests */
    EHNAPPC_BASIC = 0,
    EHNAPPC_MAPPED = 1
} ConversationType;
 
typedef enum {  /* enums for "whatReceived" on Receive requests */
    EHNAPPC_DATA = 0,
    EHNAPPC_DATACOMPLETE = 1,
    EHNAPPC_DATAINCOMPLETE = 2,
    EHNAPPC_RECEIVEDCONFIRM = 3,
    EHNAPPC_RECEIVEDCONFIRMSEND = 4,
    EHNAPPC_RECEIVEDCONFIRMDEALLOC = 5,
    EHNAPPC_RECEIVEDSEND = 6
} WhatReceivedEnum;
 
typedef enum {  /* for "fill" on Receive requests */
    EHNAPPC_BUFFER = 0,
    EHNAPPC_LL = 1
} FillEnum;
 
typedef enum {  /* for "synchLevel" on Allocate requests */
    EHNAPPC_SYNCLEVELNONE = 0,
    EHNAPPC_SYNCLEVELCONFIRM = 1
} SyncLevelEnum;
 
typedef enum {  /* for "type" on Deallocate requests */
    EHNAPPC_DEALLOCATESYNCLEVEL  = 0,
    EHNAPPC_DEALLOCATEFLUSH      = 1,
    EHNAPPC_DEALLOCATEABEND      = 2
} DeallocateEnum;
 
typedef enum { /* for return codes from all router verb routines */
    EHNAPPC_OK = 0x00,
    EHNAPPC_DEALLOCNORMAL = 0x01,
    EHNAPPC_PROGRAMERRNOTRUNCATION = 0x02,
    EHNAPPC_PROGRAMERRTRUNCATION = 0x03,
    EHNAPPC_PROGRAMERRPURGING = 0x04,
    EHNAPPC_RESOURCEFAILURERETRY = 0x05,
    EHNAPPC_RESOURCEFAILURENORETRY = 0x06,
    EHNAPPC_UNSUCCESSFUL = 0x07,
    EHNAPPC_APPCBUSY = 0x08,
    EHNAPPC_PARMCHKINVALIDVERB = 0x14,
    EHNAPPC_PARMCHKINVALIDCONVERID = 0x15,
    EHNAPPC_PARMCHKBUFFERCROSSSEG = 0x16,
    EHNAPPC_PARMCHKTPNAMELENGTH = 0x17,
    EHNAPPC_PARMCHKINVCONVERTYPE = 0x18,
    EHNAPPC_PARMCHKBADSYNCLVLALLOC = 0x19,
    EHNAPPC_PARMCHKBADRETURNCTRL = 0x1A,
    EHNAPPC_PARMCHKPIPTOOLONG = 0x1B,
    EHNAPPC_PARMCHKBADPARTNERNAME = 0x1C,
    EHNAPPC_PARMCHKCONFNOTALLOWED = 0x1D,
    EHNAPPC_PARMCHKBADDEALLOCTYPE = 0x1E,
    EHNAPPC_PARMCHKPREPTORCVTYPE = 0x1F,
    EHNAPPC_PARMCHKBADFILLTYPE = 0x20,
    EHNAPPC_PARMCHKRECMAXLEN = 0x21,
    EHNAPPC_PARMCHKUNKNOWNSECTYPE = 0x22,
    EHNAPPC_PARMCHKRESFLDNOTZERO = 0x23,
    EHNAPPC_STATECHKNOTINCONFSTAT = 0x28,
    EHNAPPC_STATECHKNOTINRECEIVE = 0x29,
    EHNAPPC_STATECHKREQSNDBADSTAT = 0x2A,
    EHNAPPC_STATECHKSNDINBADSTATE = 0x2B,
    EHNAPPC_STATECHKSNDERRBADSTAT = 0x2C,
    EHNAPPC_ALLOCERRNORETRY = 0x32,
    EHNAPPC_ALLOCERRRETRY = 0x33,
    EHNAPPC_ALLOCERRPGMNOTAVAILNR = 0x34,
    EHNAPPC_ALLOCERRTPNNOTRECOG = 0x35,
    EHNAPPC_ALLOCERRPGMNOTAVAILR = 0x36,
    EHNAPPC_ALLOCERRSECNOTVALID = 0x37,
    EHNAPPC_ALLOCERRCONVTYP = 0x38,
    EHNAPPC_ALLOCERRPIPNOTALLOWED = 0x39,
    EHNAPPC_ALLOCERRPIPNOTCORRECT = 0x3A,
    EHNAPPC_ALLOCERRSYNCHLEVEL = 0x3B,
    EHNAPPC_DEALLOCABENDPROGRAM = 0x46,
    EHNAPPC_INSUFFICIENTMEMORY = 0x47,
    EHNAPPC_MEMORYALLOCERROR = 0x48,
    EHNAPPC_TOOMANYCONVERSATIONS = 0x49,
    EHNAPPC_CONVTABLEFULL = 0x4A,
    EHNAPPC_ROUTERNOTINSTALLED = 0x4B,
    EHNAPPC_ROUTERWRONGLEVEL = 0x4C,
    EHNAPPC_PCSWINNOTLOADED = 0x4D,
    EHNAPPC_PCSWINOUTOFMEMORY = 0x4E,
    EHNAPPC_INVALIDUSERIDLEN = 0x4F,
    EHNAPPC_INVALIDPASSWORDLEN = 0x50,
    EHNAPPC_INVALIDLUNAME = 0x51,
    EHNAPPC_UNDEFINED = 0x63,
} ReturnCode;
 
typedef enum{ /* for conversation states */
    EHNAPPC_RESET_STATE = 0,
    EHNAPPC_SEND_STATE = 1,
    EHNAPPC_RECEIVE_STATE = 2,
    EHNAPPC_RCVD_CONF_STATE = 3,
    EHNAPPC_RCVD_CONF_SEND_STATE = 4,
    EHNAPPC_RCVD_CONF_DEALL_STATE = 5,
    EHNAPPC_PEND_DEALLOCATE_STATE = 6,
    EHNAPPC_INVALID_STATE = 7
} ConvState;
 
typedef enum{ /* for security types */
    EHNAPPC_SECURITY_NONE = 0,
    EHNAPPC_SECURITY_SAME = 1,
    EHNAPPC_SECURITY_PGM = 2
} SecurityType;
 
/**********************************************************************/
/* defines and structures used for get system names call              */
/**********************************************************************/
#define  EHNAPPC_SYSNAME_LENGTH   10      /* System name length  */
#define  EHNAPPC_MAX_SYSTEMS      32      /* Max active systems  */
#define  EHNAPPC_ALIAS_LENGTH     10
#define  EHNAPPC_NETWORK_LENGTH   10
 
struct AS400_Sys                          /* Used to query system names.*/
   {
   unsigned char EHNAPPC_SysName[EHNAPPC_MAX_SYSTEMS]
                                [EHNAPPC_SYSNAME_LENGTH];
                                          /* List of system names       */
   };
 
typedef struct AS400_Sys SYSSTRUC;
typedef struct AS400_Sys far *LPSYSSTRUC; /* Long pointer to a sys structure  */
 
struct FullSysInfo
   {
   unsigned char EHNAPPC_AliasName[EHNAPPC_ALIAS_LENGTH];
   unsigned char EHNAPPC_NetworkName[EHNAPPC_NETWORK_LENGTH];
   unsigned char EHNAPPC_SysName[EHNAPPC_SYSNAME_LENGTH];
   };
 
typedef struct FullSysInfo far *LPFULLSYSINFO;    /* Long pointer to a  */
                                                  /* full sys info      */
 
struct AS400_FullSys                 /* Used to query Full system names.*/
   {
   struct FullSysInfo FullName[EHNAPPC_MAX_SYSTEMS];
                                          /* List of Alias, Network and */
   };                                     /* System names.              */
 
typedef struct AS400_FullSys far *LPFULLSYSSTRUC; /* Long pointer to a  */
                                                  /* full sys structure */
 
/**********************************************************************/
/* defines and structures used for get capabilities call              */
/**********************************************************************/
 
/* Get capability Operation Code                          */
#define  EHNAPPC_OC_CAPABILITIES             0x17
 
/* Capability identifier values.                                       */
#define  EHNAPPC_CAP_OPTIMAL_COM_SIZE        0x02
#define  EHNAPPC_CAP_QUERY_CONV_STATE        0x03
#define  EHNAPPC_CAP_EXT_ALLOCATE            0x04
#define  EHNAPPC_CAP_QUERY_FULL_SYS          0x05
#define  EHNAPPC_CAP_POST                    0xfe
 
/* RC values for the header and the individual entries.                */
#define  EHNAPPC_CAP_SUCCESSFUL              0x00
#define  EHNAPPC_CAP_UNSUCCESSFUL            0x01
 
/* The next values are for checking the data field in boolean queries. */
#define  EHNAPPC_CAP_SUPPORTED               0x01
#define  EHNAPPC_CAP_UNSUPPORTED             0x00
 
struct appcrtrcap_hdr                /* Router capability list header      */
    {
    unsigned char  rc;                  /* 0 Overall return code       */
                                        /*   EHNAPPC_CAP_SUCCESSFUL    */
                                        /*   EHNAPPC_CAP_UNSUCCESSFUL  */
    unsigned char  opcode;              /* 1 Verb operation code       */
                                        /*   EHNAPPC_OC_CAPABILITIES   */
    unsigned int   length;              /* 2 Length of entire verb     */
    };
 
struct appcrtrcap_mult               /* Optimal comm. buffer multiplier    */
    {
    unsigned int   length;              /* Length of this entry        */
    unsigned char  identifier;          /* Capability identifier       */
                                        /*   EHNAPPC_CAP_OPTIMAL_COM_SIZE  */
    unsigned char  rc;                  /* This entry's return code    */
                                        /*   EHNAPPC_CAP_SUCCESSFUL    */
                                        /*   EHNAPPC_CAP_UNSUCCESSFUL  */
    unsigned int   data;                /* The multiplier              */
    };
 
struct appcrtrcap_query              /* Used for boolean queries           */
    {
    unsigned int   length;              /* Length of this entry        */
    unsigned char  identifier;          /* Capability identifier       */
                                        /*  EHNAPPC_CAP_QUERY_CONV_STATE
                                        or  EHNAPPC_CAP_EXT_ALOCATE
                                        or  EHNAPPC_CAP_QUERY_FULL_SYS
                                        or  EHNAPPC_CAP_POST           */

    unsigned char  rc;                  /* This entry's return code    */
                                        /*   EHNAPPC_CAP_SUCCESSFUL    */
                                        /*   EHNAPPC_CAP_UNSUCCESSFUL  */
    unsigned char  data;                /* The returned boolean value  */
                                        /*  EHNAPPC_CAP_SUPPORTED      */
                                        /*  EHNAPPC_CAP_UNSUPPORTED    */
    };
 
 
/**********************************************************************
 
  EXTERNAL ROUTINE:
    EHNAPPC_Allocate
 
  PARAMETERS:
    HWND             hWnd            Caller's Windows handle
    unsigned         nBufferLength   Size of buffer to be allocated by
                                     router.  It must be at least 271.
                                     If it is less than 271, a 271 byte
                                     buffer will be allocated.
    ConversationType bType           Basic or Mapped conversation
    SyncLevelEnum    bSynchLevel     None or confirm
    LPSTR            lpszLocationName ASCIIZ string specifying host system name.
                                     Set to NULL to use default system.
    LPSTR            lpszTpn         ASCIIZ string specifying partner
                                     program name.
                                     If first character is less than 0x40
                                     ASCII to EBCDIC translation is not
                                     done.
    int              nPipLength      Length of PIP data.  Set to 0 to
                                     not send PIP data.
    LPVOID           lpPipData       no translation done, must be in GDS
                                     format
    LPDWORD          lpdwConversation Pointer to a double word handle
                                     returned by router to be used on
                                     subsequent calls.
 
  RETURN VALUE:
    int         Use the ReturnCode enumerations to determine the meaning
                of the return code
 
  USAGE NOTES:
    procedure Allocate is used to start a conversation with a partner
 
**********************************************************************/
E32APPC_API int WINAPI EHNAPPC_Allocate(
                 HWND               hWnd,
                 unsigned           nBufferLength,
                 ConversationType   bType,
                 SyncLevelEnum      bSynchLevel,
                 LPSTR              lpszLocationName,
                 LPSTR              lpszTpn,
                 int                nPipLength,
                 LPVOID             lpPipData,
                 LPDWORD            lpdwConversation);
 
/**********************************************************************
 
  EXTERNAL ROUTINE:
    EHNAPPC_ExtendedAllocate
 
  PARAMETERS:
    HWND             hWnd            Caller's Windows handle
    unsigned         nBufferLength   Size of buffer to be allocated by
                                     router.  It must be at least 271.
                                     If it is less than 271, a 271 byte
                                     buffer will be allocated.
    ConversationType bType           Basic or Mapped conversation
    SyncLevelEnum    bSynchLevel     None or confirm
    LPSTR            lpszLocationName ASCIIZ string specifying host system name.
                                     Set to NULL to use default system.
    LPSTR            lpszTpn         ASCIIZ string specifying partner
                                     program name.
                                     If first character is less than 0x40
                                     ASCII to EBCDIC translation is not
                                     done.
    LPSTR            lpszModeName    NULL to select QPCSUPP (default mode)
                                     or specifies a mode that is configured
                                     (e.g. "QSERVER")
    SecurityType     bSecurityType   Security type:
                                        EHNAPPC_SECURITY_NONE
                                        EHNAPPC_SECURITY_SAME
                                        EHNAPPC_SECURITY_PGM
    LPSTR            lpszUserId      ASCIIZ string containing user ID
                                     Maximum length of 10 characters
    LPSTR            lpszPassword    ASCIIZ string containing password
                                     Maximum length of 10 characters
    int              nPipLength      Length of PIP data.  Set to 0 to
                                     not send PIP data.
    LPVOID           lpPipData       no translation done, must be in GDS
                                     format
    LPDWORD          lpdwConversation Pointer to a double word handle
                                     returned by router to be used on
                                     subsequent calls.
 
  RETURN VALUE:
    int         Use the ReturnCode enumerations to determine the meaning
                of the return code
 
  USAGE NOTES:
    procedure Allocate is used to start a conversation with a partner
 
**********************************************************************/
E32APPC_API int WINAPI EHNAPPC_ExtendedAllocate(
                 HWND               hWnd,
                 unsigned           nBufferLength,
                 ConversationType   bType,
                 SyncLevelEnum      bSynchLevel,
                 LPSTR              lpszLocationName,
                 LPSTR              lpszTpn,
                 LPSTR              lpszModeName,
                 SecurityType       bSecurityType,
                 LPSTR              lpszUserId,
                 LPSTR              lpszPassword,
                 int                nPipLength,
                 LPVOID             lpPipData,
                 LPDWORD            lpdwConversation);
 
 
/**********************************************************************
 
  EXTERNAL ROUTINE:
    EHNAPPC_SendData
 
  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    DWORD       dwConversation       Conversation handle returned from
                                     allocate verb
    int         nSendDataLength      Length of data in Send buffer
    LPVOID      lpSendDataBuffer     Address of Send buffer
    LPBYTE      lpRequestToSendRcvd  Returns whether request to send
                                     was received
 
  RETURN VALUE:
    int         Use the ReturnCode enumerations to determine the meaning
                of the return code
 
  USAGE NOTES:
    Sends data to your partner program.  See PC Support/400: Application
    Program Interface Reference, under Router Service Verbs and Basic
    Conversation Verbs for the data format.
 
**********************************************************************/
E32APPC_API int WINAPI EHNAPPC_SendData(
                 HWND      hWnd,
                 DWORD     dwConversation,
                 int       nSendDataLength,
                 LPVOID    lpSendDataBuffer,
                 LPBYTE    lpRequestToSendRcvd);
 
/**********************************************************************
 
  EXTERNAL ROUTINE:
    EHNAPPC_ReceiveAndWait
 
  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    DWORD       dwConversation       Conversation handle returned from
                                     allocate verb
    FillEnum    bFill                Fill LL or Fill buffer
    int         nMaxLength           Largest amount of data that can be
                                     accepted
    LPVOID      lpReceiveData        Pointer to receive buffer
    LPBYTE      lpWhatReceived       Returned by router to indicate whether
                                     data, confirm, send indication, etc.
                                     has been received.
    LPBYTE      lpRequestToSendRcvd  Returns whether request to send
                                     was received
    LPWORD      lpReceiveDataLength  Returned by router to indicate the
                                     amount of data received.
 
  RETURN VALUE:
    int         Use the ReturnCode enumerations to determine the meaning
                of the return code
 
  USAGE NOTES:
    ReceiveAndWait is used to wait for information to arrive on
    the conversation and then receives the information.
 
**********************************************************************/
E32APPC_API int WINAPI EHNAPPC_ReceiveAndWait(
                       HWND             hWnd,
                       DWORD            dwConversation,
                       FillEnum         bFill,
                       int              nMaxLength,
                       LPVOID           lpReceiveData,
                       LPBYTE           lpWhatReceived,
                       LPBYTE           lpRequestToSendRcvd,
                       LPWORD           lpReceiveDataLength );
 
/**********************************************************************
 
  EXTERNAL ROUTINE:
    EHNAPPC_ReceiveImmediate
 
  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    DWORD       dwConversation       Conversation handle returned from
                                     allocate verb
    FillEnum    bFill                Fill LL or fill buffer
    int         nMaxLength           Largest amount of data that can be
                                     accepted
    LPVOID      lpReceiveData        Pointer to receive buffer
    LPBYTE      lpWhatReceived       Returned by router to indicate whether
                                     data, confirm, send indication, etc.
                                     has been received.
    LPBYTE      lpRequestToSendRcvd  Returns whether request to send
                                     was received
    LPWORD      lpReceiveDataLength  Returned by router to indicate the
                                     amount of data received.
 
  RETURN VALUE:
    int         Use the ReturnCode enumerations to determine the meaning
                of the return code
 
  USAGE NOTES:
    Receive Immediate will check to see if something has been received
    If it has it is returned.  If not a return code- unsuccessful
    is returned
 
**********************************************************************/
E32APPC_API int WINAPI EHNAPPC_ReceiveImmediate(
                         HWND             hWnd,
                         DWORD            dwConversation,
                         FillEnum         bFill,
                         int              nMaxLength,
                         LPVOID           lpReceiveData,
                         LPBYTE           lpWhatReceived,
                         LPBYTE           lpRequestToSendRcvd,
                         LPWORD           lpReceiveDataLength );
 
/**********************************************************************
 
  EXTERNAL ROUTINE:
    EHNAPPC_Deallocate
 
  PARAMETERS:
    HWND            hWnd             Caller's Windows handle
    DWORD           dwConversation   Conversation handle returned from
                                     allocate verb
    DeallocateEnum  bType            Use EHNAPPC_DEALLOCATEFLUSH for normal
                                     deallocate or EHNAPPC_DEALLOCATEABEND
                                     for error.
 
  RETURN VALUE:
    int         Use the ReturnCode enumerations to determine the meaning
                of the return code
 
  USAGE NOTES:
    Deallocates an allocated conversation.
 
**********************************************************************/
E32APPC_API int WINAPI EHNAPPC_Deallocate(
                HWND           hWnd,             /* Windows handle            */
                DWORD          dwConversation,
                DeallocateEnum bType          );
 
/**********************************************************************
 
  EXTERNAL ROUTINE:
    EHNAPPC_Confirm
 
  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    DWORD       dwConversation       Conversation handle returned from
                                     allocate verb
    LPBYTE      lpRequestToSendRcvd  Returns whether request to send
                                     was received
 
  RETURN VALUE:
    int         Use the ReturnCode enumerations to determine the meaning
                of the return code
 
  USAGE NOTES:
    Confirm is used to request a confirmation that all data sent so far
    has been received by the partner.
 
**********************************************************************/
E32APPC_API int WINAPI EHNAPPC_Confirm(
                HWND      hWnd,             /* Windows handle            */
                DWORD     dwConversation,
                LPBYTE    lpRequestToSendRcvd);
 
/**********************************************************************
 
  EXTERNAL ROUTINE:
    EHNAPPC_SendError
 
  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    DWORD       dwConversation       Conversation handle returned from
                                     allocate verb
    LPBYTE      lpRequestToSendRcvd  Returns whether request to send
                                     was received
 
  RETURN VALUE:
    int         Use the ReturnCode enumerations to determine the meaning
                of the return code
 
  USAGE NOTES:
    SendError is used to indicate to the partner program that some error
    has been found.  After using send error the local program is always
    in receive state.
 
 
**********************************************************************/
E32APPC_API int WINAPI EHNAPPC_SendError(
                HWND      hWnd,             /* Windows handle            */
                DWORD     dwConversation,
                LPBYTE    lpRequestToSendRcvd);
 
/**********************************************************************
 
  EXTERNAL ROUTINE:
    EHNAPPC_PrepareToReceive
 
  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    DWORD       dwConversation       Conversation handle returned from
                                     allocate verb
 
  RETURN VALUE:
    int         Use the ReturnCode enumerations to determine the meaning
                of the return code
 
  USAGE NOTES:
    Prepare to Receive is used as a preface to using ReceiveImmediate
 
**********************************************************************/
E32APPC_API int WINAPI EHNAPPC_PrepareToReceive(
                HWND      hWnd,             /* Windows handle            */
                DWORD     dwConversation);
 
/**********************************************************************
 
  EXTERNAL ROUTINE:
    EHNAPPC_Confirmed
 
  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    DWORD       dwConversation       Conversation handle returned from
                                     allocate verb
 
  RETURN VALUE:
    int         Use the ReturnCode enumerations to determine the meaning
                of the return code
 
  USAGE NOTES:
    Confirmed is used to send a confirmation to a partner that has
    requested it
 
**********************************************************************/
E32APPC_API int WINAPI EHNAPPC_Confirmed(
                HWND      hWnd,             /* Windows handle            */
                DWORD     dwConversation);
 
/**********************************************************************
 
  EXTERNAL ROUTINE:
    EHNAPPC_RqsToSend
 
  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    DWORD       dwConversation       Conversation handle returned from
                                     allocate verb
 
  RETURN VALUE:
    int         Use the ReturnCode enumerations to determine the meaning
                of the return code
 
  USAGE NOTES:
    RequestToSend is used to request that your partner give up control
    of the conversation.   Local program must stays in receive state
    until Send is received.
 
**********************************************************************/
E32APPC_API int WINAPI EHNAPPC_RqsToSend(
                HWND      hWnd,             /* Windows handle            */
                DWORD     dwConversation);
 
/**********************************************************************
 
  EXTERNAL ROUTINE:
    EHNAPPC_Flush
 
  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    DWORD       dwConversation       Conversation handle returned from
                                     allocate verb
 
  RETURN VALUE:
    int         Use the ReturnCode enumerations to determine the meaning
                of the return code
 
  USAGE NOTES:
    Flush can be used to cause the router to send any data that it may
    have in its buffers
 
**********************************************************************/
E32APPC_API int WINAPI EHNAPPC_Flush(
                HWND      hWnd,
                DWORD     dwConversation);
 
/**********************************************************************
 
  EXTERNAL ROUTINE:
    EHNAPPC_GetCapabilities
 
  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    LPSTR       lpList               Pointer to data structure that is
                                     returned indicating the functions
                                     supported by the router.
 
  RETURN VALUE:
    unsigned int     return code
 
  USAGE NOTES:
 
**********************************************************************/
E32APPC_API unsigned int WINAPI EHNAPPC_GetCapabilities(
                  HWND hWnd,
                  LPSTR lpList);
 
/**********************************************************************
 
  EXTERNAL ROUTINE:
    EHNAPPC_IsRouterLoaded
 
  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
 
  RETURN VALUE:
    TRUE if router is loaded, FALSE if not.
 
  USAGE NOTES:
    This function will return FALSE if:
      1) router is not loaded
      2) PCSWIN is not loaded
      3) wrong level (level that does not match the DLL) of router
         is not loaded
 
**********************************************************************/
E32APPC_API BOOL WINAPI EHNAPPC_IsRouterLoaded(HWND hWnd);
 
/**********************************************************************
 
  EXTERNAL ROUTINE:
    EHNAPPC_QueryConvState
 
  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    DWORD       dwConversation       Conversation handle returned from
                                     allocate verb
 
  RETURN VALUE:
    unsigned int      State of the conversation.
 
  USAGE NOTES:
 
**********************************************************************/
E32APPC_API unsigned int WINAPI EHNAPPC_QueryConvState(
                                             HWND hWnd,
                                             DWORD dwConversation);
 
/**********************************************************************
 
  EXTERNAL ROUTINE:
    EHNAPPC_QueryUserId
 
  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    LPSTR       lpszLocationName     ASCIIZ string specifying system name
                                     to be queried
    LPSTR       lpszUserId           ASCIIZ string returned by the call
                                     containing user id for the specified
                                     system.
  RETURN VALUE:
    unsigned int     return code
 
  USAGE NOTES:
    Return user ID for the system specified.
    Note that the system must be connected.
 
**********************************************************************/
E32APPC_API unsigned int WINAPI EHNAPPC_QueryUserId(
                                             HWND hWnd,
                                             LPSTR lpszLocationName,
                                             LPSTR lpszUserId);
 
/**********************************************************************
 
  EXTERNAL ROUTINE:
    EHNAPPC_GetAttributes
 
  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    DWORD       dwConversation       Conversation handle returned by
                                     allocate verb
    LPBYTE      lpbSyncLevel         Pointer to sync level
                                       EHNAPPC_NONE
                                       EHNAPPC_CONFIRM
    LPSTR       lpszModeName         ASCIIZ string returned by the call
                                     containing mode name
                                     Maximum of 8 characters
    LPSTR       lpszLuName           ASCIIZ string returned by the call
                                     containing local logical unit name
                                     Maximum of 8 characters
    LPSTR       lpszPluName          ASCIIZ string returned by the call
                                     containing partner logical unit name
                                     Maximum of 8 characters
    LPSTR       lpszUserId           ASCIIZ string returned by the call
                                     containing user id for the specified
                                     system
                                     Maximum of 10 characters
 
  RETURN VALUE:
    unsigned int    return code
 
  USAGE NOTES:
    Return information about the specified conversation
 
**********************************************************************/
E32APPC_API unsigned int WINAPI EHNAPPC_GetAttributes(
                                             HWND hWnd,
                                             DWORD dwConversation,
                                             LPBYTE lpbSyncLevel,
                                             LPSTR  lpszModeName,
                                             LPSTR  lpszLuName,
                                             LPSTR  lpszPluName,
                                             LPSTR  lpszUserId);
 
/**********************************************************************
 
  EXTERNAL ROUTINE:
    EHNAPPC_GetDefaultSystem
 
  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    LPSTR       lpszDefSysName       ASCIIZ string returned by the call
                                     containing the default system name
 
  RETURN VALUE:
    unsigned int     return code
 
  USAGE NOTES:
    Return the default AS/400 system name
 
**********************************************************************/
E32APPC_API unsigned int WINAPI EHNAPPC_GetDefaultSystem (HWND  hWnd,
                                                       LPSTR lpszDefSysName);

/***********************************************************************
  ENTRY POINT:
    EHNAPPC_RemoteProgramStart
 
  SYNTAX:
     WORD  EHNAPPC_RemoteProgramStart(HWND  hWindow,
                                               LPSTR lpszHostSystemName,
                                               LPSTR lpszHostProgramName,
                                               LPSTR lpszHostLibraryName,
                                               char FAR *lpchPipData,
                                               WORD  wPipDataLength);
  PURPOSE:
    This function will allow a Windows application to start a program on a
    remote AS/400.
 
  PARAMETERS:
    HWND  hWindow
      Identifies the Window of the calling application
 
    LPSTR lpszHostSystemName
      Contains the name of the remote system.  Set to NULL to use the
      default system.  The string must be an ASCIIZ string up to 8
      characters.
 
    LPSTR lpszHostProgramName
      Contains the name of the host program which is to be started.  The
      string must be an ASCIIZ string.
 
    LPSTR lpszHostLibraryName
      Contains the library path of the host program.  Set to NULL to use
      the default library list.  The string must be an ASCIIZ string.
 
    char FAR * lpchPipData
      Contains the program initialization parameters for the host program.
      Set to NULL if no PIP data is to be sent.  NOTE: this function only
      supports 1 parameter as PIP data.
 
    WORD wPipDataLength
      Contains the length of the PIP data.
 
  RETURN VALUE:
      The return code for this function is the return code from the
      router APIs.  If the function should fail due to unsuccessful data
      conversion to EBCIDIC it will return the router primary return code
      EHNAPPC_UNSUCCESSFUL.
 
***********************************************************************/
 
E32APPC_API WORD WINAPI EHNAPPC_RemoteProgramStart(HWND  hWindow,
                                           LPSTR lpszHostSystemName,
                                           LPSTR lpszHostProgramName,
                                           LPSTR lpszHostLibraryName,
                                           char FAR *lpchPipData,
                                           WORD  wPipDataLength);
 

/**********************************************************************
 
  EXTERNAL ROUTINE:
    EHNAPPC_PostOnReceipt
 
  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    DWORD       dwConversation       Conversation handle returned by
                                     allocate verb
    LPSTR       lpszEventName        ASCIIZ string to event name
 
  RETURN VALUE:
    unsigned int    return code          EHNAPPC_UNSUCCESSFUL if cannot
                                        open event.
                                     EHNAPPC_PARMCHKINVALIDCONVERID if
                                        bad conversation ID

  USAGE NOTES:
    Issue this verb on a separate thread and use WIN32 API call
    WaitForSingleObject to wait for event to be set whenever something is
    received. After that, the user should issue EHNAPPC_ReceiveImmediate
    to unload the data. Then, the user must issue another
    EHNAPPC_PostOnReceipt again (the posting is only good once).

 
**********************************************************************/
E32APPC_API unsigned int WINAPI EHNAPPC_PostOnReceipt (HWND  hWnd,
                                      DWORD dwConversation,
                                      LPSTR lpszEventName);
 
/***********************************************************************
 
  EXTERNAL ROUTINE:
    EHNAPPC_PostOnRTS
 
  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    DWORD       dwConversation       Conversation handle returned by
                                     allocate verb
    LPSTR       lpszEventName        ASCIIZ string to event name
 
  RETURN VALUE:
    unsigned int   return code          EHNAPPC_UNSUCCESSFUL if cannot
                                        open event.
                                     EHNAPPC_PARMCHKINVALIDCONVERID if
                                        bad conversation ID
 
  USAGE NOTES:
    Issue this verb on a separate thread and use WIN32 API call
    WaitForSingleObject to wait for event to be set whenever RTS is
    received. After that, the user does not need to issue any verb to
    unload the RTS status. The APPC engine's RTS flag will be rest
    after posting this event. This verb is good only once. The user must
    issue this verb again to wait for next RTS.

 
**********************************************************************/
E32APPC_API unsigned int WINAPI EHNAPPC_PostOnRTS (HWND  hWnd,
                                  DWORD dwConversation,
                                  LPSTR lpszEventName);

/***********************************************************************
 
  EXTERNAL ROUTINE:
    EHNAPPC_CancelPost
 
  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    DWORD       dwConversation       Conversation handle returned by
                                     allocate verb
    LPSTR       lpszEventName        ASCIIZ string to event name
 
  RETURN VALUE:
    unsigned int     return code          EHNAPPC_UNSUCCESSFUL if no
                                        such event posted
                                     EHNAPPC_PARMCHKINVALIDCONVERID if
                                        bad conversation ID

  USAGE NOTES:
    Issue this verb to cancel previous EHNAPPC_PostOnReceipt or
    EHNAPPC_PostOnRTS verb.
 
**********************************************************************/
E32APPC_API unsigned int WINAPI EHNAPPC_CancelPost (HWND  hWnd,
                                  DWORD dwConversation,
                                  LPSTR lpszEventName);

/**********************************************************************
 
  EXTERNAL ROUTINE:
    EHNAPPC_QueryConfiguredSystems
 
  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    LPINT       lpSysCount           Returns number of systems configured
    LPSYSSTRUC  lpSys                Pointer to array of system names
 
  RETURN VALUE:
    unsigned int    return code
 
  USAGE NOTES:
    Issue this verb to get a list of AS/400 systems configured.
 
**********************************************************************/
E32APPC_API unsigned int WINAPI EHNAPPC_QueryConfiguredSystems(
                  HWND hWnd,
                  LPINT       lpSysCount,
                  LPSYSSTRUC  lpSys);

/**********************************************************************
 
  EXTERNAL ROUTINE:
    EHNAPPC_QueryFullConfiguredSystems
 
  PARAMETERS:
    HWND            hWnd             Caller's Windows handle
    LPINT           lpSysCount       Returns number of systems configured
    LPFULLSYSSTRUC  lpSys            Pointer to array of full names;
                                     System Name, Alias Name, and Net ID.
 
  RETURN VALUE:
    unsigned int   return code
 
  USAGE NOTES:
    Issue this verb to get a list (System Name. Alias, and Net ID) of
    AS/400 systems configured.
 
**********************************************************************/
E32APPC_API unsigned int WINAPI EHNAPPC_QueryFullConfiguredSystems(
                  HWND              hWnd,
                  LPINT             lpSysCount,
                  LPFULLSYSSTRUC    lpSys);

/**********************************************************************
 
  EXTERNAL ROUTINE:
    EHNAPPC_QuerySystems
 
  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    LPINT       lpSysCount           Returns number of systems connected
    LPSYSSTRUC  lpSys                Pointer to array of system names
 
  RETURN VALUE:
    unsigned int   return code
 
  USAGE NOTES:
    Issue this verb to get a list of AS/400 systems connected.
 
**********************************************************************/
E32APPC_API unsigned int WINAPI EHNAPPC_QuerySystems(
                  HWND hWnd,
                  LPINT       lpSysCount,
                  LPSYSSTRUC  lpSys);
 
/**********************************************************************
 
  EXTERNAL ROUTINE:
    EHNAPPC_QueryFullSystems
 
  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    LPINT       lpSysCount           Returns number of systems connected
    LPSYSSTRUC  lpSys                Pointer to array of Alias, Network
                                     and system names.
  RETURN VALUE:
    unsigned int   return code
 
  USAGE NOTES:
    The first system in the list is the default system.
 
/**********************************************************************/
E32APPC_API unsigned int WINAPI EHNAPPC_QueryFullSystems(
                  HWND            hWnd,
                  LPINT           lpSysCount,
                  LPFULLSYSSTRUC  lpSys);
 

/******************************************************************************
  EXTERNAL ENTRY POINT:
    EHNDT_GetASCIIToEBCDICTable
 
  PURPOSE:
    Returns a pointer to the router's ASCII (OEM codepage) to EBCDIC
    translation table.
 
  PARAMETERS:
    HWND       hWnd
      Window handle to the application's window.
 
  RETURN VALUE: LPSTR
    Returns a pointer to the table.
    If the router is not loaded, NULL is returned.
 
  USAGE NOTES:
    Use this function to get the pointer to the table so your application
    can translate ASCII data to EBCDIC.
*******************************************************************************/
E32APPC_API LPSTR WINAPI EHNDT_GetASCIIToEBCDICTable( HWND hWnd );
 
 
/******************************************************************************
  EXTERNAL ENTRY POINT:
    EHNDT_GetEBCDICToASCIITable
 
  PURPOSE:
    Returns a pointer to the router's EBCDIC to ASCII (OEM codepage)
    translation table.
 
  PARAMETERS:
    HWND       hWnd
      Window handle to the application's window.
 
  RETURN VALUE: LPSTR
    Returns a pointer to the table.
    If the router is not loaded, NULL is returned.
 
  USAGE NOTES:
    Use this function to get the pointer to the table so your application
    can translate EBCDIC data to ASCII.
*******************************************************************************/
E32APPC_API LPSTR WINAPI EHNDT_GetEBCDICToASCIITable( HWND hWnd );
 
/******************************************************************************
 
  EXTERNAL ROUTINE:
    EHNDT_EBCDICToASCII
 
  PURPOSE:
    Translate an EBCDIC string to ASCII (OEM codepage).
 
  PARAMETERS:
    HWND       hWnd
      Caller's Windows handle.
 
    LPSTR      lpsSource
      Pointer to source string.
 
    LPSTR      lpsTarget
      Pointer to target string.
 
    unsigned int wSource
      Length of source string (number of bytes to translate).
 
    LPWORD     lpwTarget
      Pointer to word variable containing the size of the target buffer.
      This variable will be updated with the total number of translated
      characters in the target buffer.
 
  RETURN VALUE: unsigned int
    EHNDT_SUCCESS
    EHNDT_E2A_TABLE_NOT_FOUND
 
  USAGE NOTES:
    The source and target should not be pointed to the same string.  The
    source string is not modified.  The size of the target buffer must
    be specified in the variable pointed by the pointer lpwTarget.  If
    the target string is not large enough to contain the translated
    string, then translation stops at the end of the target string.
    If the target string is larger than required, it is then blank
    filled to the end of the string.  The total number of translated
    characters in the target buffer is returned to the caller.
 
    This routine translates from EBCDIC to ASCII based on the translation
    table loaded by the PC Support router.  This is the equivalent of
    the Windows OEM character set.
 
*******************************************************************************/
E32APPC_API unsigned int WINAPI EHNDT_EBCDICToASCII(
                HWND       hWnd,
                LPSTR      lpsSource,
                LPSTR      lpsTarget,
                unsigned int  wSource,
                LPWORD     lpwTarget);
 
/******************************************************************************
 
  EXTERNAL ROUTINE:
    EHNDT_ASCIIToEBCDIC
 
  PURPOSE:
    Translate an ASCII (OEM codepage) string to EBCDIC.
 
  PARAMETERS:
    HWND       hWnd
      Caller's Windows handle.
 
    LPSTR      lpsSource
      Pointer to source string.
 
    LPSTR      lpsTarget
      Pointer to target string.
 
    unsigned int wSource
      Length of source string (number of bytes to translate).
 
    LPWORD     lpwTarget
      Pointer to word variable containing the size of the target buffer.
      This variable will be updated with the total number of translated
      characters in the target buffer.
 
  RETURN VALUE: unsigned int
    EHNDT_SUCCESS
    EHNDT_A2E_TABLE_NOT_FOUND
 
  USAGE NOTES:
    The source and target should not be pointed to the same string.  The
    source string is not modified.  The size of the target buffer must
    be specified in the variable pointed by the pointer lpwTarget.  If
    the target string is not large enough to contain the translated
    string, then translation stops at the end of the target string.
    If the target string is larger than required, it is then blank
    filled to the end of the string.  The total number of translated
    characters in the target buffer is returned to the caller.
 
    This routine translates from ASCII to EBCDIC based on the translation
    table loaded by the PC Support router.  This is the equivalent of
    the Windows OEM character set.
 
*******************************************************************************/
E32APPC_API unsigned int WINAPI EHNDT_ASCIIToEBCDIC(
                HWND       hWnd,
                LPSTR      lpsSource,
                LPSTR      lpsTarget,
                unsigned int  wSource,
                LPWORD     lpwTarget );
 
/******************************************************************************
 
  EXTERNAL ROUTINE:
    EHNDT_EBCDICToANSI
 
  PURPOSE:
    Translate an EBCDIC string to the Windows ANSI codepage.
 
  PARAMETERS:
    HWND       hWnd
      Caller's Windows handle.
 
    LPSTR      lpsSource
      Pointer to source string.
 
    LPSTR      lpsTarget
      Pointer to target string.
 
    unsigned int wSource
      Length of source string (number of bytes to translate).
 
    LPWORD     lpwTarget
      Pointer to word variable containing the size of the target buffer.
      This variable will be updated with the total number of translated
      characters in the target buffer.
 
  RETURN VALUE: unsigned int
    EHNDT_SUCCESS
    EHNDT_E2A_TABLE_NOT_FOUND
 
  USAGE NOTES:
    The source and target should not be pointed to the same string.  The
    source string is not modified.  The size of the target buffer must
    be specified in the variable pointed by the pointer lpwTarget.  If
    the target string is not large enough to contain the translated
    string, then translation stops at the end of the target string.
    If the target string is larger than required, it is then blank
    filled to the end of the string.  The total number of translated
    characters in the target buffer is returned to the caller.
 
    This routine translates by from EBCDIC to ASCII by using the translation
    table loaded by the PC Support router.  An OEM to ANSI translation
    is then done before returning to the caller.
 
*******************************************************************************/
E32APPC_API unsigned int WINAPI EHNDT_EBCDICToANSI(
                HWND       hWnd,
                LPSTR      lpsSource,
                LPSTR      lpsTarget,
                unsigned int  wSource,
                LPWORD     lpwTarget);
 
/******************************************************************************
 
  EXTERNAL ROUTINE:
    EHNDT_ANSIToEBCDIC
 
  PURPOSE:
    Translate a string in the Windows ANSI codepage to EBCDIC.
 
  PARAMETERS:
    HWND       hWnd
      Caller's Windows handle.
 
    LPSTR      lpsSource
      Pointer to source string.
 
    LPSTR      lpsTarget
      Pointer to target string.
 
    unsigned int wSource
      Length of source string (number of bytes to translate).
 
    LPWORD     lpwTarget
      Pointer to word variable containing the size of the target buffer.
      This variable will be updated with the total number of translated
      characters in the target buffer.
 
  RETURN VALUE: unsigned int
    EHNDT_SUCCESS
    EHNDT_A2E_TABLE_NOT_FOUND
    EHNDT_MEMALLOC
 
  USAGE NOTES:
    The source and target should not be pointed to the same string.  The
    source string is not modified.  The size of the target buffer must
    be specified in the variable pointed by the pointer lpwTarget.  If
    the target string is not large enough to contain the translated
    string, then translation stops at the end of the target string.
    If the target string is larger than required, it is then blank
    filled to the end of the string.  The total number of translated
    characters in the target buffer is returned to the caller.
 
    This routine performs an ANSI to OEM translation before translating
    the string into EBCDIC.
 
*******************************************************************************/
E32APPC_API unsigned int WINAPI EHNDT_ANSIToEBCDIC(
                HWND       hWnd,
                LPSTR      lpsSource,
                LPSTR      lpsTarget,
                unsigned int  wSource,
                LPWORD     lpwTarget );

/**********************************************************************
  EXTERNAL ROUTINE:
    EHNAPPC_Cleanup
 
  PARAMETERS:
 
  RETURN VALUE:
    none.
 
  USAGE NOTES:
    procedure uses for DLL clean up.
**********************************************************************/
E32APPC_API VOID WINAPI EHNAPPC_Cleanup();

/**********************************************************************
  EXTERNAL ROUTINE:
    EHNAPPC_ReceiveAllocate
 
  PARAMETERS:
    HWND    hwnd,
        caller's windows handle

    int     nTPNameLenght,
        length of the TP name, 1 to 64.

    LPVOID  lpTP_Name,
        local TP name.

    LPDWORD lpdwConversation
        returned of the conversation ID

 
  RETURN VALUE: integer
    CM_OK
    CM_PROGRAM_STATE_CHECK
    CM_PRODUCT_SPECIFIC_ERROR
 
  USAGE NOTES:
    Issued by the program to indicate that it is able to accept incoming
    conversations which are directed to the name given. A program can issue
    this call more than once in order to handle incoming conversations
    which more than one TP name.
**********************************************************************/
E32APPC_API int WINAPI EHNAPPC_ReceiveAllocate(
                 HWND               hWnd,
                 int                nTPNameLength,
                 LPVOID             lpTP_Name,
                 LPDWORD            lpdwConversation);

#pragma pack()

#endif // EHNAPPC_H
