/*  $Id: //ribm/12.0/dev/r8misc/ehnappc.h#1 $ */
/*-----------------------------------------------------------------------
 * Name........... ehnappc.h
 * Product........ Reflection for IBM SNA Transport User
 * Description.... 
 * 
 * System......... Windows
 * Language....... C++
 * Designer....... Gary Rambo
 * Created........ 03/14/95
 * Copyright...... (c) WRQ Inc. 1994-1995
 *
 * $State: Exp $
 * $Source: $
 *-----------------------------------------------------------------------
 * Modifications
 * 95.03.14. This include file uses a Return_Code enumeration, which we
 *	changed to equivalent #define macros some time ago. 
 *-----------------------------------------------------------------------
*/
/*********************************************************************/
/* COPYRIGHT = 5763-XC1 (C) COPYRIGHT IBM CORP 1994                  */
/*   LICENSED MATERIAL - PROGRAM PROPERTY OF IBM                     */
/*   REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083.          */
/*********************************************************************/
#ifndef   EHNAPPC_H   /* If this file was not already included then  */
#define   EHNAPPC_H   /* prevent this file from being included again */
/**********************************************************************

  PURPOSE:
    This include file contain constants, data structures and function
    prototypes to be used to interface with AS/400 PC Support APPC
    router in the Microsoft Windows environment.

    All string inputs are expected to be in ANSI ASCII character set,
    and all output strings are in ANSI ASCII.

  ROUTINES:
    EHNAPPC_Allocate
    EHNAPPC_ExtendedAllocate
    EHNAPPC_SendData
    EHNAPPC_ReceiveAndWait
    EHNAPPC_ReceiveImmediate
    EHNAPPC_Deallocate
    EHNAPPC_Confirm
    EHNAPPC_SendError
    EHNAPPC_PrepareToReceive
    EHNAPPC_Confirmed
    EHNAPPC_RqsToSend
    EHNAPPC_Flush
    EHNAPPC_QueryConfiguredLinks
    EHNAPPC_QuerySystems
    EHNAPPC_QueryFullSystems
    EHNAPPC_GetCapabilities
    EHNAPPC_IsRouterLoaded
    EHNAPPC_QueryConvState
    EHNAPPC_QueryUserId
    EHNAPPC_GetAttributes
    EHNAPPC_GetDefaultSystem
    EHNAPPC_RemoteProgramStart
**********************************************************************/
#ifdef RC_INVOKED
	// NOTE: this list was originally an enum called ReturnCode.  Why?
	// I don't know.  I need #defines for the stupid ghouchin' RC SPOS.

#define	EHNAPPC_OK						0x00
#define	EHNAPPC_DEALLOCNORMAL			0x01
#define	EHNAPPC_PROGRAMERRNOTRUNCATION	0x02
#define	EHNAPPC_PROGRAMERRTRUNCATION	0x03
#define	EHNAPPC_PROGRAMERRPURGING		0x04
#define	EHNAPPC_RESOURCEFAILURERETRY	0x05
#define	EHNAPPC_RESOURCEFAILURENORETRY	0x06
#define	EHNAPPC_UNSUCCESSFUL			0x07
#define	EHNAPPC_APPCBUSY				0x08
#define	EHNAPPC_PARMCHKINVALIDVERB		0x14
#define	EHNAPPC_PARMCHKINVALIDCONVERID	0x15
#define	EHNAPPC_PARMCHKBUFFERCROSSSEG	0x16
#define	EHNAPPC_PARMCHKTPNAMELENGTH		0x17
#define	EHNAPPC_PARMCHKINVCONVERTYPE	0x18
#define	EHNAPPC_PARMCHKBADSYNCLVLALLOC	0x19
#define	EHNAPPC_PARMCHKBADRETURNCTRL	0x1A
#define	EHNAPPC_PARMCHKPIPTOOLONG		0x1B
#define	EHNAPPC_PARMCHKBADPARTNERNAME	0x1C
#define	EHNAPPC_PARMCHKCONFNOTALLOWED	0x1D
#define	EHNAPPC_PARMCHKBADDEALLOCTYPE	0x1E
#define	EHNAPPC_PARMCHKPREPTORCVTYPE	0x1F
#define	EHNAPPC_PARMCHKBADFILLTYPE		0x20
#define	EHNAPPC_PARMCHKRECMAXLEN		0x21
#define	EHNAPPC_PARMCHKUNKNOWNSECTYPE	0x22
#define	EHNAPPC_PARMCHKRESFLDNOTZERO	0x23
#define	EHNAPPC_STATECHKNOTINCONFSTAT	0x28
#define	EHNAPPC_STATECHKNOTINRECEIVE	0x29
#define	EHNAPPC_STATECHKREQSNDBADSTAT	0x2A
#define	EHNAPPC_STATECHKSNDINBADSTATE	0x2B
#define	EHNAPPC_STATECHKSNDERRBADSTAT	0x2C
#define	EHNAPPC_ALLOCERRNORETRY			0x32
#define	EHNAPPC_ALLOCERRRETRY			0x33
#define	EHNAPPC_ALLOCERRPGMNOTAVAILNR	0x34
#define	EHNAPPC_ALLOCERRTPNNOTRECOG		0x35
#define	EHNAPPC_ALLOCERRPGMNOTAVAILR	0x36
#define	EHNAPPC_ALLOCERRSECNOTVALID		0x37
#define	EHNAPPC_ALLOCERRCONVTYP			0x38
#define	EHNAPPC_ALLOCERRPIPNOTALLOWED	0x39
#define	EHNAPPC_ALLOCERRPIPNOTCORRECT	0x3A
#define	EHNAPPC_ALLOCERRSYNCHLEVEL		0x3B
#define	EHNAPPC_DEALLOCABENDPROGRAM		0x46
#define	EHNAPPC_INSUFFICIENTMEMORY		0x47
#define	EHNAPPC_MEMORYALLOCERROR		0x48
#define	EHNAPPC_TOOMANYCONVERSATIONS	0x49
#define	EHNAPPC_CONVTABLEFULL			0x4A
#define	EHNAPPC_ROUTERNOTINSTALLED		0x4B
#define	EHNAPPC_ROUTERWRONGLEVEL		0x4C
#define	EHNAPPC_PCSWINNOTLOADED			0x4D
#define	EHNAPPC_PCSWINOUTOFMEMORY		0x4E
#define	EHNAPPC_INVALIDUSERIDLEN		0x4F
#define	EHNAPPC_INVALIDPASSWORDLEN		0x50
#define	EHNAPPC_INVALIDLUNAME			0x51
#define	EHNAPPC_UNDEFINED				0x63
#define	EHNAPPC_CREDENTIALEXPIRED		0x64
#define	EHNAPPC_MPTN_BASE						0xD0	// cf r8mptn.h "MptnRc"
#define	EHNAPPC_MPTN_OK							EHNAPPC_MPTN_BASE + 0x00
#define	EHNAPPC_MPTN_PENDING					EHNAPPC_MPTN_BASE + 0x01
#define	EHNAPPC_MPTN_INVCONNID					EHNAPPC_MPTN_BASE + 0x02
#define	EHNAPPC_MPTN_INVTRANSPORT				EHNAPPC_MPTN_BASE + 0x03
#define	EHNAPPC_MPTN_UNABLETOLOCATESERVER		EHNAPPC_MPTN_BASE + 0x04
#define	EHNAPPC_MPTN_MEMALLOCFAILED				EHNAPPC_MPTN_BASE + 0x05
#define	EHNAPPC_MPTN_CONNALREADYOPEN			EHNAPPC_MPTN_BASE + 0x06
#define	EHNAPPC_MPTN_SERVERREFUSEDCONN			EHNAPPC_MPTN_BASE + 0x07
#define	EHNAPPC_MPTN_UNABLETOOPENCONN			EHNAPPC_MPTN_BASE + 0x08
#define	EHNAPPC_MPTN_CONNDEAD					EHNAPPC_MPTN_BASE + 0x09
#define	EHNAPPC_MPTN_TRANSMITERROR				EHNAPPC_MPTN_BASE + 0x0A
#define	EHNAPPC_MPTN_RECEIVEALREADYPENDING		EHNAPPC_MPTN_BASE + 0x0B
#define	EHNAPPC_MPTN_RECEIVECANCELLED			EHNAPPC_MPTN_BASE + 0x0C
#define	EHNAPPC_MPTN_RECEIVETIMEDOUT			EHNAPPC_MPTN_BASE + 0x0D
#define	EHNAPPC_MPTN_CONNRSPNEG					EHNAPPC_MPTN_BASE + 0x0E
#define	EHNAPPC_MPTN_CONNRSPDESTREJECT			EHNAPPC_MPTN_BASE + 0x0F
#define	EHNAPPC_MPTN_CONNRSPGWUNRECOG			EHNAPPC_MPTN_BASE + 0x10
#define	EHNAPPC_MPTN_CONNRSPDESTUNRECOG			EHNAPPC_MPTN_BASE + 0x11
#define	EHNAPPC_MPTN_CONNRSPUSERADDRUNKNOWN		EHNAPPC_MPTN_BASE + 0x12
#define	EHNAPPC_MPTN_CONNRSPREJECTEDBYUSER		EHNAPPC_MPTN_BASE + 0x13
#define	EHNAPPC_MPTN_CONNRSPUSERDATAERROR		EHNAPPC_MPTN_BASE + 0x14
#define	EHNAPPC_MPTN_CONNRSPCONNDATAUNEXPECTED	EHNAPPC_MPTN_BASE + 0x15
#define	EHNAPPC_MPTN_CONNRSPCONNDATAMISSING		EHNAPPC_MPTN_BASE + 0x16
#define	EHNAPPC_MPTN_CREATEEVENTFAILED			EHNAPPC_MPTN_BASE + 0x17
#define	EHNAPPC_MPTN_WINDOWCREATIONFAILED		EHNAPPC_MPTN_BASE + 0x18
#define	EHNAPPC_MPTN_SOCKETERROR				EHNAPPC_MPTN_BASE + 0x19
#define	EHNAPPC_MPTN_LOADLIBRARYERROR			EHNAPPC_MPTN_BASE + 0x1A
#define	EHNAPPC_MPTN_THREADREGISTERERROR		EHNAPPC_MPTN_BASE + 0x1B
#define	EHNAPPC_MPTN_CONNRSPUSERNAMEERROR		EHNAPPC_MPTN_BASE + 0x1C
#define	EHNAPPC_MPTN_CONNRSPTIMEOUTERROR		EHNAPPC_MPTN_BASE + 0x1D
#define	EHNAPPC_MPTN_UNKNOWNERROR				EHNAPPC_MPTN_BASE + 0x63
#define	EHNAPPC_INVALID_DATA_SEGMENT	0xF0
#define	EHNAPPC_INVALID_HWND			0xF1
#define	EHNAPPC_PENDING					0xF2
#define	EHNAPPC_UNEXPECTED_OS_ERROR		0xF3
#define    EHNAPPC_SESSIONSETUPBADLOCALLU	0xF4
#define	EHNAPPC_SESSIONSETUPBADREMOTELU	0xF5
#define    EHNAPPC_SESSIONSETUPBADLINKNAME 0xF6
#define	EHNAPPC_HOST_CONTROLLER_FAULT   0x87
// Reflection error code extensions (non MPTN specific)
#define EHNAPPC_EXTENSION_CMD_CANCELED	0x7101	//user cancelled operation

#else
#include "r8misc\platform.h"

typedef enum { /* for return codes from all router verb routines */
	EHNAPPC_OK = 0x00,							
	EHNAPPC_DEALLOCNORMAL = 0x01,
	EHNAPPC_PROGRAMERRNOTRUNCATION = 0x02,
	EHNAPPC_PROGRAMERRTRUNCATION = 0x03,
	EHNAPPC_PROGRAMERRPURGING = 0x04,
	EHNAPPC_RESOURCEFAILURERETRY = 0x05,
	EHNAPPC_RESOURCEFAILURENORETRY = 0x06,
	EHNAPPC_UNSUCCESSFUL = 0x07,
	EHNAPPC_APPCBUSY = 0x08,
	EHNAPPC_PARMCHKINVALIDVERB = 0x14,
	EHNAPPC_PARMCHKINVALIDCONVERID = 0x15,
	EHNAPPC_PARMCHKBUFFERCROSSSEG = 0x16,
	EHNAPPC_PARMCHKTPNAMELENGTH = 0x17,
	EHNAPPC_PARMCHKINVCONVERTYPE = 0x18,
	EHNAPPC_PARMCHKBADSYNCLVLALLOC = 0x19,
	EHNAPPC_PARMCHKBADRETURNCTRL = 0x1A,
	EHNAPPC_PARMCHKPIPTOOLONG = 0x1B,
	EHNAPPC_PARMCHKBADPARTNERNAME = 0x1C,
	EHNAPPC_PARMCHKCONFNOTALLOWED = 0x1D,
	EHNAPPC_PARMCHKBADDEALLOCTYPE = 0x1E,
	EHNAPPC_PARMCHKPREPTORCVTYPE = 0x1F,
	EHNAPPC_PARMCHKBADFILLTYPE = 0x20,
	EHNAPPC_PARMCHKRECMAXLEN = 0x21,
	EHNAPPC_PARMCHKUNKNOWNSECTYPE = 0x22,
	EHNAPPC_PARMCHKRESFLDNOTZERO = 0x23,
	EHNAPPC_STATECHKNOTINCONFSTAT = 0x28,
	EHNAPPC_STATECHKNOTINRECEIVE = 0x29,
	EHNAPPC_STATECHKREQSNDBADSTAT = 0x2A,
	EHNAPPC_STATECHKSNDINBADSTATE = 0x2B,
	EHNAPPC_STATECHKSNDERRBADSTAT = 0x2C,
	EHNAPPC_ALLOCERRNORETRY = 0x32,
	EHNAPPC_ALLOCERRRETRY = 0x33,
	EHNAPPC_ALLOCERRPGMNOTAVAILNR = 0x34,
	EHNAPPC_ALLOCERRTPNNOTRECOG = 0x35,
	EHNAPPC_ALLOCERRPGMNOTAVAILR = 0x36,
	EHNAPPC_ALLOCERRSECNOTVALID = 0x37,
	EHNAPPC_ALLOCERRCONVTYP = 0x38,
	EHNAPPC_ALLOCERRPIPNOTALLOWED = 0x39,
	EHNAPPC_ALLOCERRPIPNOTCORRECT = 0x3A,
	EHNAPPC_ALLOCERRSYNCHLEVEL = 0x3B,
	EHNAPPC_DEALLOCABENDPROGRAM = 0x46,
	EHNAPPC_INSUFFICIENTMEMORY = 0x47,
	EHNAPPC_MEMORYALLOCERROR = 0x48,
	EHNAPPC_TOOMANYCONVERSATIONS = 0x49,
	EHNAPPC_CONVTABLEFULL = 0x4A,
	EHNAPPC_ROUTERNOTINSTALLED = 0x4B,
	EHNAPPC_ROUTERWRONGLEVEL = 0x4C,
	EHNAPPC_PCSWINNOTLOADED = 0x4D,
	EHNAPPC_PCSWINOUTOFMEMORY = 0x4E,
	EHNAPPC_INVALIDUSERIDLEN = 0x4F,
	EHNAPPC_INVALIDPASSWORDLEN = 0x50,
	EHNAPPC_INVALIDLUNAME = 0x51,
	EHNAPPC_UNDEFINED = 0x63,
	EHNAPPC_CREDENTIALEXPIRED = 0x64,
	EHNAPPC_HOST_CONTROLLER_FAULT 	= 0x87,	// cover an NS/Router return code 95.03.14
	EHNAPPC_MPTN_BASE						= 0xD0,	// c. 28 codes + a wildcard @99decimal:
											//  cf. r8mptn.h "MptnRc"
	EHNAPPC_MPTN_OK							= 0xD0 + 0x00,
	EHNAPPC_MPTN_PENDING					= 0xD0 + 0x01,
	EHNAPPC_MPTN_INVCONNID					= 0xD0 + 0x02,
	EHNAPPC_MPTN_INVTRANSPORT				= 0xD0 + 0x03,
	EHNAPPC_MPTN_UNABLETOLOCATESERVER		= 0xD0 + 0x04,
	EHNAPPC_MPTN_MEMALLOCFAILED				= 0xD0 + 0x05,
	EHNAPPC_MPTN_CONNALREADYOPEN			= 0xD0 + 0x06,
	EHNAPPC_MPTN_SERVERREFUSEDCONN			= 0xD0 + 0x07,
	EHNAPPC_MPTN_UNABLETOOPENCONN			= 0xD0 + 0x08,
	EHNAPPC_MPTN_CONNDEAD					= 0xD0 + 0x09,
	EHNAPPC_MPTN_TRANSMITERROR				= 0xD0 + 0x0A,
	EHNAPPC_MPTN_RECEIVEALREADYPENDING		= 0xD0 + 0x0B,
	EHNAPPC_MPTN_RECEIVECANCELLED			= 0xD0 + 0x0C,
	EHNAPPC_MPTN_RECEIVETIMEDOUT			= 0xD0 + 0x0D,
	EHNAPPC_MPTN_CONNRSPNEG					= 0xD0 + 0x0E,
	EHNAPPC_MPTN_CONNRSPDESTREJECT			= 0xD0 + 0x0F,
	EHNAPPC_MPTN_CONNRSPGWUNRECOG			= 0xD0 + 0x10,
	EHNAPPC_MPTN_CONNRSPDESTUNRECOG			= 0xD0 + 0x11,
	EHNAPPC_MPTN_CONNRSPUSERADDRUNKNOWN		= 0xD0 + 0x12,
	EHNAPPC_MPTN_CONNRSPREJECTEDBYUSER		= 0xD0 + 0x13,
	EHNAPPC_MPTN_CONNRSPUSERDATAERROR		= 0xD0 + 0x14,
	EHNAPPC_MPTN_CONNRSPCONNDATAUNEXPECTED	= 0xD0 + 0x15,
	EHNAPPC_MPTN_CONNRSPCONNDATAMISSING		= 0xD0 + 0x16,
	EHNAPPC_MPTN_CREATEEVENTFAILED			= 0xD0 + 0x17,
	EHNAPPC_MPTN_WINDOWCREATIONFAILED		= 0xD0 + 0x18,
	EHNAPPC_MPTN_SOCKETERROR				= 0xD0 + 0x19,
	EHNAPPC_MPTN_LOADLIBRARYERROR			= 0xD0 + 0x1A,
	EHNAPPC_MPTN_THREADREGISTERERROR		= 0xD0 + 0x1B,
	EHNAPPC_MPTN_CONNRSPUSERNAMEERROR		= 0xD0 + 0x1C,
	EHNAPPC_MPTN_CONNRSPTIMEOUTERROR		= 0xD0 + 0x1D,
	EHNAPPC_MPTN_UNKNOWNERROR				= 0xD0 + 0x63,

	EHNAPPC_INVALID_DATA_SEGMENT	= 0xF0,	// locally-conceived
	EHNAPPC_INVALID_HWND			= 0xF1,
	EHNAPPC_PENDING					= 0xF2, // ""
	EHNAPPC_UNEXPECTED_OS_ERROR		= 0xF3, // ""
	EHNAPPC_SESSIONSETUPBADLOCALLU	= 0xF4, // ""
	EHNAPPC_SESSIONSETUPBADREMOTELU	= 0xF5, // ""
	EHNAPPC_SESSIONSETUPBADLINKNAME = 0xF6,
// Reflection error code extensions (non MPTN specific)
	EHNAPPC_EXTENSION_CMD_CANCELED	= 0x7101	//user cancelled operation
} ReturnCode;

#define EHNAPPC_API	extern "C" ReturnCode _EXPORT
#define EHNAPPC_STARTUPCONFIGFILE_ENVVAR "WRQ_TEMP_SNAENGINECFGFILE"

#pragma pack()

typedef enum {  /* enums for "type" on Allocate requests */
    EHNAPPC_BASIC = 0,
    EHNAPPC_MAPPED = 1
} ConversationType;

typedef enum {  /* enums for "whatReceived" on Receive requests */
    EHNAPPC_DATA = 0,
    EHNAPPC_DATACOMPLETE = 1,
    EHNAPPC_DATAINCOMPLETE = 2,
    EHNAPPC_RECEIVEDCONFIRM = 3,
    EHNAPPC_RECEIVEDCONFIRMSEND = 4,
    EHNAPPC_RECEIVEDCONFIRMDEALLOC = 5,
    EHNAPPC_RECEIVEDSEND = 6
} WhatReceivedEnum;

typedef enum {  /* for "fill" on Receive requests */
    EHNAPPC_BUFFER = 0,
    EHNAPPC_LL = 1
} FillEnum;

typedef enum {  /* for "synchLevel" on Allocate requests */
    EHNAPPC_SYNCLEVELNONE = 0,
    EHNAPPC_SYNCLEVELCONFIRM = 1
} SyncLevelEnum;

typedef enum {  /* for "type" on Deallocate requests */
    EHNAPPC_DEALLOCATESYNCLEVEL  = 0,
    EHNAPPC_DEALLOCATEFLUSH      = 1,
    EHNAPPC_DEALLOCATEABEND      = 2
} DeallocateEnum;

typedef enum{ /* for conversation states */
    EHNAPPC_RESET_STATE = 0,
    EHNAPPC_SEND_STATE = 1,
    EHNAPPC_RECEIVE_STATE = 2,
    EHNAPPC_RCVD_CONF_STATE = 3,
    EHNAPPC_RCVD_CONF_SEND_STATE = 4,
    EHNAPPC_RCVD_CONF_DEALL_STATE = 5,
    EHNAPPC_PEND_DEALLOCATE_STATE = 6,
    EHNAPPC_INVALID_STATE = 7
} ConvState;

typedef enum{ /* for security types */
    EHNAPPC_SECURITY_NONE = 0,
    EHNAPPC_SECURITY_SAME = 1,
    EHNAPPC_SECURITY_PGM = 2
} SecurityType;

/**********************************************************************/
/* defines and structures used for get system names call              */
/**********************************************************************/
#define  EHNAPPC_SYSNAME_LENGTH   10      /* System name length  */
#define  EHNAPPC_FQ_SYSNAME_LEN   17
#define  EHNAPPC_MAX_SYSTEMS      32      /* Max active systems  */
#define  EHNAPPC_ALIAS_LENGTH     10
#define  EHNAPPC_NETWORK_LENGTH   10

struct AS400_Sys                          /* Used to query system names.*/
   {
   unsigned char EHNAPPC_SysName[EHNAPPC_MAX_SYSTEMS][EHNAPPC_SYSNAME_LENGTH];
                                          /* List of system names       */
   };

typedef struct AS400_Sys far *LPSYSSTRUC, *SYSSTRUC; 
										   /* Long pointer to a sys structure  */

struct FullSysInfo
   {
   unsigned char EHNAPPC_AliasName[EHNAPPC_ALIAS_LENGTH];
   unsigned char EHNAPPC_NetworkName[EHNAPPC_NETWORK_LENGTH];
   unsigned char EHNAPPC_SysName[EHNAPPC_SYSNAME_LENGTH];
   };

typedef struct FullSysInfo far *LPFULLSYSINFO;    /* Long pointer to a  */
                                                  /* full sys info      */

struct AS400_FullSys                 /* Used to query Full system names.*/
   {
   struct FullSysInfo FullName[EHNAPPC_MAX_SYSTEMS];
                                          /* List of Alias, Network and */
   };                                     /* System names.              */

typedef struct AS400_FullSys far *LPFULLSYSSTRUC, *FULLSYSSTRUC; 
											/* Long pointer to a  */
                                           /* full sys structure */

/**********************************************************************/
/* defines and structures used for get capabilities call              */
/**********************************************************************/

/* Get capability Operation Code                          */
#define  EHNAPPC_OC_CAPABILITIES             0x17

/* Capability identifier values.                                       */
#define  EHNAPPC_CAP_OPTIMAL_COM_SIZE       0x02
#define  EHNAPPC_CAP_QUERY_CONV_STATE       0x03
#define  EHNAPPC_CAP_EXT_ALLOCATE           0x04
#define  EHNAPPC_CAP_QUERY_FULL_SYS          0x05

/* RC values for the header and the individual entries.                */
#define  EHNAPPC_CAP_SUCCESSFUL               0x00
#define  EHNAPPC_CAP_UNSUCCESSFUL             0x01

/* The next values are for checking the data field in boolean queries. */
#define  EHNAPPC_CAP_SUPPORTED                0x01
#define  EHNAPPC_CAP_UNSUPPORTED              0x00

struct appcrtrcap_hdr                /* Router capability list header      */
    {
    unsigned char  rc;                  /* 0 Overall return code       */
                                        /*   EHNAPPC_CAP_SUCCESSFUL    */
                                        /*   EHNAPPC_CAP_UNSUCCESSFUL  */
    unsigned char  opcode;              /* 1 Verb operation code       */
                                        /*   EHNAPPC_OC_CAPABILITIES   */
    unsigned int   length;              /* 2 Length of entire verb     */
    };

struct appcrtrcap_mult               /* Optimal comm. buffer multiplier    */
    {
    unsigned int   length;              /* Length of this entry        */
    unsigned char  identifier;          /* Capability identifier       */
                                        /*   EHNAPPC_CAP_OPTIMAL_COM_SIZE  */
    unsigned char  rc;                  /* This entry's return code    */
                                        /*   EHNAPPC_CAP_SUCCESSFUL    */
                                        /*   EHNAPPC_CAP_UNSUCCESSFUL  */
    unsigned int   data;                /* The multiplier              */
    };

struct appcrtrcap_query              /* Used for boolean queries           */
    {
    unsigned int   length;              /* Length of this entry        */
    unsigned char  identifier;          /* Capability identifier       */
                                        /*  EHNAPPC_CAP_QUERY_CONV_STATE */
    unsigned char  rc;                  /* This entry's return code    */
                                        /*   EHNAPPC_CAP_SUCCESSFUL    */
                                        /*   EHNAPPC_CAP_UNSUCCESSFUL  */
    unsigned char  data;                /* The returned boolean value  */
                                        /*  EHNAPPC_CAP_SUPPORTED      */
                                        /*  EHNAPPC_CAP_UNSUPPORTED    */
    };

/**********************************************************************

  EXTERNAL ROUTINE:
    EHNAPPC_Allocate

  PARAMETERS:
    HWND             hWnd            Caller's Windows handle
    unsigned         nBufferLength   Size of buffer to be allocated by
                                     router.  It must be at least 271.
                                     If it is less than 271, a 271 byte
                                     buffer will be allocated.
    ConversationType bType           Basic or Mapped conversation
    SyncLevelEnum    bSynchLevel     None or confirm
    LPSTR            lpszLocationName ASCIIZ string specifying host system name.
                                     Set to NULL to use default system.
    LPSTR            lpszTpn         ASCIIZ string specifying partner
                                     program name.
                                     If first character is less than 0x40
                                     ASCII to EBCDIC translation is not
                                     done.
    WORD             nPipLength      Length of PIP data.  Set to 0 to
                                     not send PIP data.
    LPVOID           lpPipData       no translation done, must be in GDS
                                     format
    LPDWORD          lpdwConversation Pointer to a double word handle
                                     returned by router to be used on
                                     subsequent calls.

  RETURN VALUE:
    int         Use the ReturnCode enumerations to determine the meaning
                of the return code

  USAGE NOTES:
    procedure Allocate is used to start a conversation with a partner

 96.09.24	Tack on the mptn use_socks_proxy_server here
 96.11.13	Don't; it's an RLU characteristic & belongs w/SessionSetup

**********************************************************************/
EHNAPPC_API EHNAPPC_Allocate(
   HWND               hWnd,
   unsigned           nBufferLength,
   ConversationType   bType,
   SyncLevelEnum      bSynchLevel,
   LPSTR              lpszLocationName,
   LPSTR              lpszTpn,
   WORD               nPipLength,
   LPVOID             lpPipData,
   LPDWORD            lpdwConversation);

/**********************************************************************

  EXTERNAL ROUTINE:
    EHNAPPC_ExtendedAllocate

  PARAMETERS:
    HWND             hWnd            Caller's Windows handle
    unsigned         nBufferLength   Size of buffer to be allocated by
                                     router.  It must be at least 271.
                                     If it is less than 271, a 271 byte
                                     buffer will be allocated.
    ConversationType bType           Basic or Mapped conversation
    SyncLevelEnum    bSynchLevel     None or confirm
    LPSTR            lpszLocationName ASCIIZ string specifying host system name.
                                     Set to NULL to use default system.
    LPSTR            lpszTpn         ASCIIZ string specifying partner
                                     program name.
                                     If first character is less than 0x40
                                     ASCII to EBCDIC translation is not
                                     done.
    LPSTR            lpszModeName    IBM: Must be NULL; WRQ: Needn't be NULL.
    SecurityType     bSecurityType   Security type:
                                        EHNAPPC_SECURITY_NONE
                                        EHNAPPC_SECURITY_SAME
                                        EHNAPPC_SECURITY_PGM
    LPSTR            lpszUserId      ASCIIZ string containing user ID
                                     Maximum length of 10 characters
    LPSTR            lpszPassword    ASCIIZ string containing password
                                     Maximum length of 10 characters
    WORD             nPipLength      Length of PIP data.  Set to 0 to
                                     not send PIP data.
    LPVOID           lpPipData       no translation done, must be in GDS
                                     format
    LPDWORD          lpdwConversation Pointer to a double word handle
                                     returned by router to be used on
                                     subsequent calls.

  RETURN VALUE:
    int         Use the ReturnCode enumerations to determine the meaning
                of the return code

  USAGE NOTES:
    procedure Allocate is used to start a conversation with a partner

**********************************************************************/
EHNAPPC_API EHNAPPC_ExtendedAllocate(
   HWND               hWnd,
   unsigned           nBufferLength,
   ConversationType   bType,
   SyncLevelEnum      bSynchLevel,
   LPSTR              lpszLocationName,
   LPSTR              lpszTpn,
   LPSTR              lpszModeName,
   SecurityType       bSecurityType,
   LPSTR              lpszUserId,
   LPSTR              lpszPassword,
   WORD               nPipLength,
   LPVOID             lpPipData,
   LPDWORD            lpdwConversation);


/**********************************************************************

  EXTERNAL ROUTINE:
    EHNAPPC_SendData

  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    DWORD       dwConversation       Conversation handle returned from
                                     allocate verb
    int         nSendDataLength      Length of data in Send buffer
    LPVOID      lpSendDataBuffer     Address of Send buffer
    LPBYTE      lpRequestToSendRcvd  Returns whether request to send
                                     was received
	 LPHANDLE*   lpWaitObject         96.04.04 nonstandard MPTN extension

  RETURN VALUE:
    int         Use the ReturnCode enumerations to determine the meaning
                of the return code

  USAGE NOTES:
    Sends data to your partner program.  See PC Support/400: Application
    Program Interface Reference, under Router Service Verbs and Basic
    Conversation Verbs for the data format.

**********************************************************************/
EHNAPPC_API EHNAPPC_SendData(
   HWND      hWnd,
   DWORD     dwConversation,
   int       nSendDataLength,
   LPVOID    lpSendDataBuffer,
   LPBYTE    lpRequestToSendRcvd);

/**********************************************************************

  EXTERNAL ROUTINE:
    EHNAPPC_ReceiveAndWait

  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    DWORD       dwConversation       Conversation handle returned from
                                     allocate verb
    FillEnum    bFill                Fill LL or Fill buffer
    int         nMaxLength           Largest amount of data that can be
                                     accepted
    LPVOID      lpReceiveData        Pointer to receive buffer
    LPBYTE      lpWhatReceived       Returned by router to indicate whether
                                     data, confirm, send indication, etc.
                                     has been received.
    LPBYTE      lpRequestToSendRcvd  Returns whether request to send
                                     was received
    LPWORD      lpReceiveDataLength  Returned by router to indicate the
                                     amount of data received.

  RETURN VALUE:
    int         Use the ReturnCode enumerations to determine the meaning
                of the return code

  USAGE NOTES:
    ReceiveAndWait is used to wait for information to arrive on
    the conversation and then receives the information.

**********************************************************************/
EHNAPPC_API EHNAPPC_ReceiveAndWait(
   HWND             hWnd,
   DWORD            dwConversation,
   FillEnum         bFill,
   int              nMaxLength,
   LPVOID           lpReceiveData,
   LPBYTE           lpWhatReceived,
   LPBYTE           lpRequestToSendRcvd,
   LPWORD           lpReceiveDataLength );

/**********************************************************************

  EXTERNAL ROUTINE:
    EHNAPPC_ReceiveImmediate

  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    DWORD       dwConversation       Conversation handle returned from
                                     allocate verb
    FillEnum    bFill                Fill LL or fill buffer
    int         nMaxLength           Largest amount of data that can be
                                     accepted
    LPVOID      lpReceiveData        Pointer to receive buffer
    LPBYTE      lpWhatReceived       Returned by router to indicate whether
                                     data, confirm, send indication, etc.
                                     has been received.
    LPBYTE      lpRequestToSendRcvd  Returns whether request to send
                                     was received
    LPWORD      lpReceiveDataLength  Returned by router to indicate the
                                     amount of data received.

  RETURN VALUE:
    int         Use the ReturnCode enumerations to determine the meaning
                of the return code

  USAGE NOTES:
    Receive Immediate will check to see if something has been received
    If it has it is returned.  If not a return code- unsuccessful
    is returned

**********************************************************************/
EHNAPPC_API EHNAPPC_ReceiveImmediate(
   HWND             hWnd,
   DWORD            dwConversation,
   FillEnum         bFill,
   int              nMaxLength,
   LPVOID           lpReceiveData,
   LPBYTE           lpWhatReceived,
   LPBYTE           lpRequestToSendRcvd,
   LPWORD           lpReceiveDataLength );

/**********************************************************************

  EXTERNAL ROUTINE:
    EHNAPPC_Deallocate

  PARAMETERS:
    HWND            hWnd             Caller's Windows handle
    DWORD           dwConversation   Conversation handle returned from
                                     allocate verb
    DeallocateEnum  bType            Use EHNAPPC_DEALLOCATEFLUSH for normal
                                     deallocate or EHNAPPC_DEALLOCATEABEND
                                     for error.

  RETURN VALUE:
    int         Use the ReturnCode enumerations to determine the meaning
                of the return code

  USAGE NOTES:
    Deallocates an allocated conversation.

**********************************************************************/
EHNAPPC_API EHNAPPC_Deallocate(
   HWND           hWnd,             /* Windows handle            */
   DWORD          dwConversation,
   DeallocateEnum bType          );

/**********************************************************************

  EXTERNAL ROUTINE:
    EHNAPPC_Confirm

  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    DWORD       dwConversation       Conversation handle returned from
                                     allocate verb
    LPBYTE      lpRequestToSendRcvd  Returns whether request to send
                                     was received

  RETURN VALUE:
    int         Use the ReturnCode enumerations to determine the meaning
                of the return code

  USAGE NOTES:
    Confirm is used to request a confirmation that all data sent so far
    has been received by the partner.

**********************************************************************/
EHNAPPC_API EHNAPPC_Confirm(
   HWND      hWnd,             /* Windows handle            */
   DWORD     dwConversation,
   LPBYTE    lpRequestToSendRcvd);

/**********************************************************************

  EXTERNAL ROUTINE:
    EHNAPPC_SendError

  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    DWORD       dwConversation       Conversation handle returned from
                                     allocate verb
    LPBYTE      lpRequestToSendRcvd  Returns whether request to send
                                     was received
	 LPHANDLE    lpWaitObject         96.04.04 nonstandard MPTN extension

  RETURN VALUE:
    int         Use the ReturnCode enumerations to determine the meaning
                of the return code

  USAGE NOTES:
    SendError is used to indicate to the partner program that some error
    has been found.  After using send error the local program is always
    in receive state.


**********************************************************************/
EHNAPPC_API EHNAPPC_SendError(
   HWND      hWnd,             /* Windows handle            */
   DWORD     dwConversation,
   LPBYTE    lpRequestToSendRcvd);

/**********************************************************************

  EXTERNAL ROUTINE:
    EHNAPPC_PrepareToReceive

  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    DWORD       dwConversation       Conversation handle returned from
                                     allocate verb

  RETURN VALUE:
    int         Use the ReturnCode enumerations to determine the meaning
                of the return code

  USAGE NOTES:
    Prepare to Receive is used as a preface to using ReceiveImmediate

**********************************************************************/
EHNAPPC_API EHNAPPC_PrepareToReceive(
   HWND      hWnd,             /* Windows handle            */
   DWORD     dwConversation);

/**********************************************************************

  EXTERNAL ROUTINE:
    EHNAPPC_Confirmed

  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    DWORD       dwConversation       Conversation handle returned from
                                     allocate verb

  RETURN VALUE:
    int         Use the ReturnCode enumerations to determine the meaning
                of the return code

  USAGE NOTES:
    Confirmed is used to send a confirmation to a partner that has
    requested it

**********************************************************************/
EHNAPPC_API EHNAPPC_Confirmed(
   HWND      hWnd,             /* Windows handle            */
   DWORD     dwConversation);

/**********************************************************************

  EXTERNAL ROUTINE:
    EHNAPPC_RqsToSend

  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    DWORD       dwConversation       Conversation handle returned from
                                     allocate verb

  RETURN VALUE:
    int         Use the ReturnCode enumerations to determine the meaning
                of the return code

  USAGE NOTES:
    RequestToSend is used to request that your partner give up control
    of the conversation.   Local program must stays in receive state
    until Send is received.

**********************************************************************/
EHNAPPC_API EHNAPPC_RqsToSend(
   HWND      hWnd,             /* Windows handle            */
   DWORD     dwConversation);

/**********************************************************************

  EXTERNAL ROUTINE:
    EHNAPPC_Flush

  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    DWORD       dwConversation       Conversation handle returned from
                                     allocate verb

  RETURN VALUE:
    int         Use the ReturnCode enumerations to determine the meaning
                of the return code

  USAGE NOTES:
    Flush can be used to cause the router to send any data that it may
    have in its buffers

**********************************************************************/
EHNAPPC_API EHNAPPC_Flush(
   HWND      hWnd,
   DWORD     dwConversation);

/*-----------------------------------------------------------------------

  EXTERNAL ROUTINE:
    EHNAPPC_QueryConfiguredLinks
		- get the names of LU6.2 links configured in the SNA engine

  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
	UINT		link_type			 link (transport) type 
    UINT*       link_count           Returns number of links configured
    char*		link_names           Pointer to buffer (filled with null-terminated
									 link names in the API)

  RETURN VALUE:
    EHNAPPC_OK                 - The list was retrieved ok.
    EHNAPPC_ROUTER_NOT_LOADED  - The router is not loaded.
    EHNAPPC_PCSWIN_NOT_LOADED  - PCSWIN is not loaded.
    EHNAPPC_ROUTER_WRONG_LEVEL - Down-level router loaded.

  USAGE NOTES:
    The first system in the list is the default system.
 *-----------------------------------------------------------------------
*/EHNAPPC_API
EHNAPPC_QueryConfiguredLinks (
	HWND		hwnd,
	UINT		link_type,
	UINT*		link_count,
	char*		link_names);

/**********************************************************************

  EXTERNAL ROUTINE:
    EHNAPPC_QuerySystems

  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    LPINT       lpSysCount           Returns number of systems connected
    LPSYSSTRUC  lpSys                Pointer to array of system names

  RETURN VALUE:
    EHNAPPC_OK                 - The list was retrieved ok.
    EHNAPPC_ROUTER_NOT_LOADED  - The router is not loaded.
    EHNAPPC_PCSWIN_NOT_LOADED  - PCSWIN is not loaded.
    EHNAPPC_ROUTER_WRONG_LEVEL - Down-level router loaded.

  USAGE NOTES:
    The first system in the list is the default system.

**********************************************************************/
EHNAPPC_API EHNAPPC_QuerySystems(                /*@DCR43*/
   HWND        hWnd,
   LPINT       lpSysCount,
   LPSYSSTRUC  lpSys);

/**********************************************************************

  EXTERNAL ROUTINE:
    EHNAPPC_QueryFullSystems

  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    LPINT       lpSysCount           Returns number of systems connected
    LPFULLSYSSTRUC  lpSys            Pointer to array of Alias, Network
                                     and system names.
  RETURN VALUE:
    int         return code

  USAGE NOTES:
    The first system in the list is the default system.

**********************************************************************/
EHNAPPC_API EHNAPPC_QueryFullSystems(            /*@DCR43*/
   HWND            hWnd,
   LPINT           lpSysCount,
   LPFULLSYSSTRUC  lpSys);

/**********************************************************************

  EXTERNAL ROUTINE:
    EHNAPPC_GetCapabilities

  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    LPSTR       lpList               Pointer to data structure that is
                                     returned indicating the functions
                                     supported by the router.

  RETURN VALUE:
    int         return code

  USAGE NOTES:

**********************************************************************/
EHNAPPC_API EHNAPPC_GetCapabilities(
   HWND hWnd,
   LPSTR lpList);

/**********************************************************************

  EXTERNAL ROUTINE:
    EHNAPPC_IsRouterLoaded

  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle

  RETURN VALUE:
    TRUE if router is loaded, FALSE if not.

  USAGE NOTES:
    This function will return FALSE if:
      1) router is not loaded
      2) PCSWIN is not loaded
      3) wrong level (level that does not match the DLL) of router
         is not loaded

**********************************************************************/
extern "C" BOOL _EXPORT
EHNAPPC_IsRouterLoaded(HWND hWnd);

/**********************************************************************

  EXTERNAL ROUTINE:
    EHNAPPC_QueryConvState

  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    DWORD       dwConversation       Conversation handle returned from
                                     allocate verb

  RETURN VALUE:
    int         State of the conversation.

  USAGE NOTES:

**********************************************************************/
extern "C" ConvState _EXPORT
EHNAPPC_QueryConvState(
   HWND hWnd,
   DWORD dwConversation);

/**********************************************************************

  EXTERNAL ROUTINE:
    EHNAPPC_QueryUserId

  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    LPSTR       lpszLocationName     ASCIIZ string specifying system name
                                     to be queried
    LPSTR       lpszUserId           ASCIIZ string returned by the call
                                     containing user id for the specified
                                     system

  RETURN VALUE:
    int         return code

  USAGE NOTES:
    Return user ID for the system specified.

**********************************************************************/
EHNAPPC_API EHNAPPC_QueryUserId(
   HWND	hWnd,
   LPSTR	lpszLocationName,
   LPSTR	lpszUserId);

/**********************************************************************

  EXTERNAL ROUTINE:
    EHNAPPC_GetAttributes

  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    DWORD       dwConversation       Conversation handle returned by
                                     allocate verb
    LPBYTE      lpbSyncLevel         Pointer to sync level
                                       EHNAPPC_NONE
                                       EHNAPPC_CONFIRM
    LPSTR       lpszModeName         ASCIIZ string returned by the call
                                     containing mode name
                                     Maximum of 8 characters
    LPSTR       lpszLuName           ASCIIZ string returned by the call
                                     containing local logical unit name
                                     Maximum of 8 characters
    LPSTR       lpszPluName          ASCIIZ string returned by the call
                                     containing partner logical unit name
                                     Maximum of 8 characters
    LPSTR       lpszUserId           ASCIIZ string returned by the call
                                     containing user id for the specified
                                     system
                                     Maximum of 10 characters

  RETURN VALUE:
    int         return code

  USAGE NOTES:
    Return user for specified conversation handle

**********************************************************************/
EHNAPPC_API EHNAPPC_GetAttributes(
   HWND	hWnd,
   DWORD	dwConversation,
   LPBYTE	lpbSyncLevel,
   LPSTR	lpszModeName,
   LPSTR	lpszLuName,
   LPSTR	lpszPluName,
   LPSTR	lpszUserId);

/**********************************************************************

  EXTERNAL ROUTINE:
    EHNAPPC_GetDefaultSystem

  PARAMETERS:
    HWND        hWnd                 Caller's Windows handle
    LPSTR       lpszDefSysName       ASCIIZ string returned by the call
                                     containing the default system name

  RETURN VALUE:
    int         return code

  USAGE NOTES:
    Return the default AS/400 system name

**********************************************************************/
EHNAPPC_API EHNAPPC_GetDefaultSystem (
	HWND  hWnd,
   LPSTR lpszDefSysName);

/***********************************************************************
  ENTRY POINT:
    EHNAPPC_RemoteProgramStart

  SYNTAX:
    extern WORD EHNAPPC_API EHNAPPC_RemoteProgramStart(HWND  hWindow,
                                               LPSTR lpszHostSystemName,
                                               LPSTR lpszHostProgramName,
                                               LPSTR lpszHostLibraryName,
                                               char FAR *lpchPipData,
                                               WORD  wPipDataLength);
  PURPOSE:
    This function will allow a Windows application start a program on a
    remote AS/400.

  PARAMETERS:
    HWND  hWindow
      Identifies the Window of the calling application

    LPSTR lpszHostSystemName
      Contains the name of the remote system.  Set to NULL to use the
      default system.  The string must be an ASCIIZ string up to 8
      characters.

    LPSTR lpszHostProgramName
      Contains the name of the host program which is to be started.  The
      string must be an ASCIIZ string.

    LPSTR lpszHostLibraryName
      Contains the library path of the host program.  Set to NULL to use
      the default library list.  The string must be an ASCIIZ string.

    char FAR * lpchPipData
      Contains the program initialization parameters for the host program.
      Set to NULL if no PIP data is to be sent.  NOTE: this function only
      supports 1 parameter as PIP data.

    WORD wPipDataLength
      Contains the length of the PIP data.

  RETURN VALUE:
      The return code for this function is the return code from the
      router APIs.  If the function should fail due to unsuccessful data
      conversion to EBCIDIC it will return the router primary return code
      EHNAPPC_UNSUCCESSFUL.

***********************************************************************/

EHNAPPC_API EHNAPPC_RemoteProgramStart(
	HWND  hWnd,
   LPSTR lpszHostSystemName,
   LPSTR lpszHostProgramName,
   LPSTR lpszHostLibraryName,
   LPSTR lpchPipData,
   WORD  wPipDataLength);

EHNAPPC_API EHNAPPC_StartHostProgram (
	HWND    hWnd,
   LPSTR   lpszHostSystemName,
   LPSTR   lpszHostProgramName,
   LPSTR   lpszHostLibraryName,
   LPSTR   lpchPipData,
   WORD    wPipDataLength,
   LPDWORD lpdwConversation );

/*-----------------------------------------------------------------------
 * function	: EHN_RC_String
 * filename	: ehnappc.h 			
 * author 		: Gary Rambo							   date : 04/20/95
 * parameters	: 
 * description	: given a buffer of specified length, fill it with the rc
 *				  text
 * returns		: 
 * notes		: 
 *-----------------------------------------------------------------------
*/EHNAPPC_API EHN_RC_String (
	HWND		hWnd,
	ReturnCode	rc,
	LPSTR		lpszBuffer,
	UINT		uBufferLen);

/*-----------------------------------------------------------------------
 * function	: EHN_SessionSetup
 * filename	: ehnappc.h 			
 * author 		: Gary Rambo							   date : 06/14/95
 * parameters	: conveying the results of R8 Session Setup + Connect
 * description	: 
 * returns		: 
 * notes		: Do we get the session, or do we merely define elements
 *				  and let EHNAPPC_IsRouterLoaded get the session? See *.cpp
 *				  for the exciting continuation.
 * 
 * 96.11.13	add use_socks_proxy_server, again, as an RLU characteristic
 *
 * 98.04.15	add link_name
 *-----------------------------------------------------------------------
*/EHNAPPC_API
EHN_SessionSetup (
	HWND		hwnd,
	LPSTR		net_id,
	LPSTR		local_lu,
	LPSTR		system_name,
	LPSTR		link_name,
	LPSTR		user_id,
	LPSTR		password,
	LPSTR		sna_domain_name,
	LPSTR		ip_address,
	BOOL		use_socks_proxy_server);

/*-----------------------------------------------------------------------
 * function	: EHN_SetLLU
 * filename	: ehnappc.h 			
 * author 		: Gary Rambo							   date : 06/18/95
 * parameters	: 
 * description	: truncated version of EHN_SessionSetup (); for those
 *				  unfortunate TPs wanting to use EHNAPPC API and not able
 *				  to define themselves on the fly, as DSPT TP can do.
 * returns		: 
 * notes		: 
 *-----------------------------------------------------------------------
*/EHNAPPC_API
EHN_SetLLU (
	HWND		hwnd,
	char*		local_lu);

#endif /* RC_INVOKED    */
#endif /* EHNAPPC_H     */
