/*  $Id: //ribm/12.0/dev/snaeng32/snalu62/aping.cpp#1 $ */
/*-----------------------------------------------------------------------
 * Name........... aPing.cpp
 * Product........ Reflection for IBM SNA WinAPPC Test Program
 * Description.... 
 * 
 * System......... Windows
 * Language....... C++
 * Designer....... Gary Rambo
 * Created........ 97.10.28
 * Copyright...... (c) WRQ Inc. 1994-1997
 *
 * $State: Exp $
 * $Source: $
 *-----------------------------------------------------------------------
 * Modifications
 *-----------------------------------------------------------------------
*/
#include	<windows.h>
#include	<string.h>
#include	<stdlib.h>

extern "C" {
#include	"rwinibm.h"		// or wherever the thing is
}
#include	"aPing.hpp"

typedef	unsigned long	ULONG;

char		app_name []		= "aPing";
BYTE		ebc_aPingD_name []	= {0xC1, 0xD7, 0xC9, 0xD5, 0xC7, 0xC4, 0x00};
BYTE		ebc_blank_name [] = {0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00};
BYTE		ebc_inter_name [] = {0x7B, 0xC9, 0xD5, 0xE3, 0xC5, 0xD9, 0x00, 0x00, 0x00};
HINSTANCE	hinst;
HWND		hwnd;
HANDLE		aPing_thread;
BOOL		iterate_forever;
BOOL		stop_aPing;
UINT		allocation_time;
UINT		starting_tick;
UINT		last_packet_tick;
UINT		total_iterations;
UINT		iterations	= 1, packets = 1, packet_size = 0x40;
UINT		interval	= 0;
char		remote_lu [ALIAS_LEN+1];
char		fq_remote_lu [FQ_LEN+1];
char		local_lu [12];
BYTE		conv_type 	= AP_MAPPED_CONVERSATION;
BYTE		sync_level	= AP_CONFIRM_SYNC_LEVEL;
BYTE		send_data_type	= AP_NONE;
BYTE		dealloc_type	= AP_SYNC_LEVEL;
BYTE		ptr_type		= AP_NONE;
BOOL		echo		= TRUE;

int PASCAL 
WinMain	(
	HINSTANCE	hinst_current, 
	HINSTANCE	hinst_previous, 
	LPSTR		lp_cmd_line, 
	int			cmd_show) {

	MSG msg;

	if (!init_application (hinst_current, hinst_previous))
		return FALSE;						/* initialization failed */

	/* Perform initializations for this instance. */
	if (!init_instance (cmd_show))
		return FALSE;

	/* Get and dispatch messages until WM_QUIT message. */
	while (GetMessage (&msg, NULL, 0, 0)) {
		TranslateMessage (&msg);		/* translates virtual key codes    */
		DispatchMessage (&msg);			/* dispatches message to window    */
	}
	return (int) msg.wParam;			/* return value of PostQuitMessage */
}	//	end WinMain

BOOL
init_application (
	HINSTANCE	hinst_current,
	HINSTANCE	hinst_previous) {
	WNDCLASS  	wc;

	hinst				= hinst_current;
	wc.style 			= CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc 		= aPing_wnd_proc;
	wc.cbClsExtra		= 0;
	wc.cbWndExtra		= 0;
	wc.hInstance		= hinst;
	wc.hIcon			= NULL;
	wc.hCursor			= LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground	= (HBRUSH) COLOR_WINDOW;
	wc.lpszMenuName		= "";
	wc.lpszClassName	= app_name;

	if (!hinst_previous)
		return (RegisterClass (&wc));
	else return TRUE;
}	//	end init_application

BOOL
init_instance (int			cmd_show) {
	BOOL	unique 			= FALSE;
	BYTE	ping_instance	= 0;
	// 95.05.31.	Problems with asynchronous completion aren't improved
	//				affect by SetMessageQueue (120)
	hwnd = CreateWindow (
		app_name,
		app_name,
		WS_VISIBLE | WS_OVERLAPPED | WS_SYSMENU | WS_MINIMIZE,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		0,
		0,
		HWND_DESKTOP,
		NULL,
		hinst,
		(LPSTR) NULL);
	if (!hwnd)
		return (FALSE);
	ShowWindow (hwnd, cmd_show);
	return TRUE;
}

extern "C" long CALLBACK
aPing_wnd_proc (
	HWND		hwnd,
	UINT	 	message,
	WPARAM 		wparam,
	LPARAM		lparam) {
	static   	
	HMENU 		hmenu_sys, hmenu_options, hmenu_help, hmenu_iterations, 
				hmenu_packet_size, hmenu_conv_type, hmenu_echo, hmenu_packets,
				hmenu_sd_type, hmenu_dealloc_type, hmenu_ptr_type, hmenu_interval;
	switch (message) {
		case WM_CREATE: {
			struct
			WAPPCDATA				appc_data;
			hmenu_sys			= GetSystemMenu (hwnd, FALSE);
			hmenu_options		= CreatePopupMenu ();
			hmenu_iterations	= CreatePopupMenu ();
			hmenu_packet_size	= CreatePopupMenu ();
			hmenu_packets		= CreatePopupMenu ();
			hmenu_conv_type		= CreatePopupMenu ();
			hmenu_echo			= CreatePopupMenu ();
			hmenu_sd_type		= CreatePopupMenu ();
			hmenu_dealloc_type	= CreatePopupMenu ();
			hmenu_ptr_type		= CreatePopupMenu ();
			hmenu_interval		= CreatePopupMenu ();
			hmenu_help			= CreatePopupMenu ();
			UpdateWindow (hwnd);
			if (initialize_system_menu (
				hmenu_sys, hmenu_options, hmenu_iterations, 
				hmenu_packet_size, hmenu_packets, hmenu_conv_type,
				hmenu_echo, hmenu_sd_type, hmenu_dealloc_type, 
				hmenu_ptr_type, hmenu_interval, hmenu_help))
				WinAPPCStartup (1, &appc_data);
				return 0L;     // success
			return 0L;		// 97.09.08 test
		}
		case WM_CLOSE:
		case WM_ENDSESSION: {
			DestroyWindow(hwnd);
			return(0);
		}
		case WM_INITMENUPOPUP: {
			if (hmenu_sys == (HMENU) wparam) {
				system_menu_popup (hmenu_sys);
				return 0L;
			}
			else if (hmenu_options == (HMENU) wparam) {
				options_menu_popup (hmenu_options);
				return 0L;
			}
			break;
		}
		case WM_SYSCOMMAND: {
			static
			BOOL	sent_name;
			switch (wparam) {
				case IDM_START_EPING: {
					DWORD		aPing_tid;
					if (WaitForSingleObject (aPing_thread, 0) == WAIT_TIMEOUT) {
						MessageBox (hwnd, "aPing busy", app_name, MB_OK);
						break;
					}
					pingfo.iterations	= iterations;
					pingfo.packet_size	= packet_size;
					if (!(aPing_thread = 
							CreateThread (
								NULL,
								0,
								(PTHREAD_START_ROUTINE) aPing_proc,
								&pingfo,
								0,
								&aPing_tid))) {
						MessageBox (hwnd, "can't start aPing thread", app_name, MB_OK);
						break;
					}
					break;
				}
				case IDM_STOP_EPING:
					if (WaitForSingleObject (aPing_thread, 0) == WAIT_TIMEOUT)
						stop_aPing		= TRUE;
					break;
				case IDM_SET_REMOTE_LU:
					if (WaitForSingleObject (aPing_thread, 0) != WAIT_TIMEOUT)
						set_remote_lu (hwnd);
					break;
				case IDM_ALLOCATE_TIME: {
					char str [256];
					wsprintf ((LPSTR) str, "allocation time:%lums", allocation_time);
					MessageBox (hwnd, str, "aPing Allocation Time", MB_OK);
					break;
				}
				case IDM_CONV_TYPE_BASIC: {
					conv_type	= AP_BASIC_CONVERSATION;
					break;
				}
				case IDM_CONV_TYPE_MAPPED: {
					conv_type	= AP_MAPPED_CONVERSATION;
					break;
				}
				case IDM_ECHO_YES:
					echo		= TRUE;
					break;

				case IDM_ECHO_NO:
					echo		= FALSE;
					break;
				case IDM_SD_NONE:
					send_data_type	= AP_NONE;
					break;
				case IDM_SD_FLUSH:
					send_data_type	= AP_SEND_DATA_FLUSH;
					break;
				case IDM_SD_CONFIRM:
					send_data_type	= AP_SEND_DATA_CONFIRM;
					break;
				case IDM_PTR_NONE:
					ptr_type		= AP_NONE;
					break;
				case IDM_PTR_FLUSH:
					ptr_type	= AP_SEND_DATA_P_TO_R_FLUSH;
					break;
				case IDM_PTR_SYNC_LEVEL:
					ptr_type	= AP_SEND_DATA_P_TO_R_SYNC_LEVEL;
					break;
				case IDM_PTR_CONFIRM:
					ptr_type	= AP_SEND_DATA_P_TO_R_CONFIRM;
					break;
				case IDM_DEALLOC_FLUSH:
					dealloc_type	= AP_FLUSH;
					break;
				case IDM_DEALLOC_SYNC_LEVEL:
					dealloc_type	= AP_SYNC_LEVEL;
					break;
				case IDM_DEALLOC_CONFIRM:
					dealloc_type	= AP_CONFIRM;
					break;
				case IDM_REVIEW_PARAMETERS: {
					// remote lu, packet_size, iterations, conv_type are the 
					//	current guys. But ApingD doesn't seem to handle BASIC 
					//	conv.. Make sure aPingD does.
					char	str [256];
					wsprintf (str, "remote lu:%s\niterations:%lu\npacket_size:%u\npackets:%u\ninterval:%x seconds\nconv_type:%s\necho:%s",
						remote_lu,
						iterations,
						packet_size,
						packets,
						interval,
						conv_type == AP_BASIC_CONVERSATION? "Basic" : "Mapped",
						echo? "Yes" : "No");
					MessageBox (hwnd, str, "aPing Settings", MB_OK);
					break;
				}
				case IDM_PACKET_TIME: {
					UINT	total_bytes = packet_size * total_iterations * (echo? 2 : 1) * packets;
					UINT	total_time = 0;
					if (!starting_tick)
						total_time	= 0;
					else
					if (last_packet_tick)
						total_time	= last_packet_tick - starting_tick;
					else
						total_time	= GetTickCount () - starting_tick;
					char	str [256];
					char	activity [40];
					if (lparam)
						lstrcpy (activity, "Completed");
					else
					if (WaitForSingleObject (aPing_thread, 0) == WAIT_TIMEOUT)
						if (iterate_forever)
							lstrcpy (activity, "Yes: endlessly");
						else
							wsprintf (
								activity, 
								"Yes: %lu iterations remaining", 
								iterations - total_iterations);
					else
						lstrcpy (activity, "No");
					wsprintf (
						(LPSTR) str,
						"active?:%s\nsource:%s\ntarget:%s\nsize:%u\npackets:%u\niterations:%lu\necho:%s\ntotal bytes:%lu\ntotal time:%lums\nKb/sec:%u\nIterations/sec:%u",
						activity,
						local_lu,
						remote_lu,
						packet_size, packets, total_iterations,
						echo? "Yes" : "No",
						total_bytes,
						total_time,
						LOWORD (total_bytes / (total_time? total_time : 1)),
						total_iterations / ((total_time / 1000) ? total_time / 1000 : 1));
					MessageBeep (MB_ICONASTERISK);
					MessageBox (hwnd, str, "aPing Packet Results", MB_OK);
					break;
				}
				case IDM_ITERATIONS_1:		iterations	= 1;		break;
				case IDM_ITERATIONS_2:		iterations	= 2;		break;
				case IDM_ITERATIONS_4:		iterations	= 4;		break;
				case IDM_ITERATIONS_8:		iterations	= 8;		break;
				case IDM_ITERATIONS_16:		iterations	= 16;		break;
				case IDM_ITERATIONS_32:		iterations	= 32;		break;
				case IDM_ITERATIONS_64:		iterations	= 64;		break;
				case IDM_ITERATIONS_128:	iterations	= 128;		break;
				case IDM_ITERATIONS_256:	iterations	= 256;		break;
				case IDM_ITERATIONS_512:	iterations	= 512;		break;
				case IDM_ITERATIONS_1024:	iterations	= 1024;		break;
				case IDM_ITERATIONS_2048:	iterations	= 2048;		break;
				case IDM_ITERATIONS_4096:	iterations	= 4096;		break;
				case IDM_ITERATIONS_8192:	iterations	= 8192;		break;
				case IDM_ITERATIONS_16384:	iterations	= 16384;	break;
				case IDM_ITERATIONS_32768:	iterations	= 32768;	break;
				case IDM_ITERATIONS_EVER:	{
					iterations		= 0xFFFFFFFF;
					iterate_forever	= TRUE;
					break;
				}
				case IDM_PACKET_SIZE_0:		packet_size	= 0x0;		break;
				case IDM_PACKET_SIZE_40:	packet_size	= 0x40;		break;
				case IDM_PACKET_SIZE_80:	packet_size	= 0x80;		break;
				case IDM_PACKET_SIZE_100:	packet_size	= 0x100;	break;
				case IDM_PACKET_SIZE_200:	packet_size	= 0x200;	break;
				case IDM_PACKET_SIZE_400:	packet_size	= 0x400;	break;
				case IDM_PACKET_SIZE_800:	packet_size	= 0x800;	break;
				case IDM_PACKET_SIZE_1000:	packet_size	= 0x1000;	break;
				case IDM_PACKET_SIZE_2000:	packet_size	= 0x2000;	break;
				case IDM_PACKET_SIZE_4000:	packet_size	= 0x4000;	break;
				case IDM_PACKET_SIZE_8000:	packet_size	= 0x7FFB;	break;
				case IDM_PACKETS_1:			packets		= 1;		break;
				case IDM_PACKETS_2:			packets		= 2;		break;
				case IDM_PACKETS_4:			packets		= 4;		break;
				case IDM_PACKETS_8:			packets		= 8;		break;
				case IDM_PACKETS_16:		packets		= 16;		break;
				case IDM_PACKETS_32:		packets		= 32;		break;
				case IDM_PACKETS_64:		packets		= 64;		break;
				case IDM_PACKETS_128:		packets		= 128;		break;
				case IDM_PACKETS_256:		packets		= 256;		break;
				case IDM_PACKETS_512:		packets		= 512;		break;
				case IDM_PACKETS_1024:		packets		= 1024;		break;
				case IDM_PACKETS_2048:		packets		= 2048;		break;
				case IDM_PACKETS_4096:		packets		= 4096;		break;
				case IDM_PACKETS_8192:		packets		= 8192;		break;
				case IDM_PACKETS_16384:		packets		= 16384;	break;
				case IDM_PACKETS_32768:		packets		= 32768;	break;

				case IDM_INTERVAL_0:		interval	= 0;	break;
				case IDM_INTERVAL_1:		interval	= 1;	break;
				case IDM_INTERVAL_2:		interval	= 2;	break;
				case IDM_INTERVAL_4:		interval	= 4;	break;
				case IDM_INTERVAL_8:		interval	= 8;	break;
				case IDM_INTERVAL_16:		interval	= 16;	break;
				case IDM_INTERVAL_32:		interval	= 32;	break;
				case IDM_INTERVAL_64:		interval	= 64;	break;
				case IDM_INTERVAL_128:		interval	= 128;	break;
				case IDM_INTERVAL_256:		interval	= 256;	break;
				case IDM_INTERVAL_512:		interval	= 512;	break;
				case IDM_INTERVAL_1024:		interval	= 1024; break;

				default: ;											
			}														
			break;													
 		}															
		case WM_PAINT: {											
			PAINTSTRUCT	ps;
			HBRUSH hbr;
			BeginPaint (hwnd, &ps);
			hbr 	= CreateSolidBrush (RGB (0, 200, 255));
			FillRect (ps.hdc, &ps.rcPaint, hbr);
			DeleteObject (hbr);
			TextOut (ps.hdc, 0, 10, app_name, lstrlen (app_name));
			EndPaint (hwnd, &ps);
			break;
		}
		case WM_DESTROY: {      /* message: window being destroyed */
			if (WaitForSingleObject (aPing_thread, 0) == WAIT_TIMEOUT) {
				stop_aPing = TRUE;
				WaitForSingleObject (aPing_thread, 5000);
			}
			WinAPPCCleanup ();
			PostQuitMessage (0);
			break;
		}
		default:         /* Passes it on if unproccessed    */
			return (DefWindowProc (hwnd, message, wparam, lparam));
	}
	return (DefWindowProc (hwnd, message, wparam, lparam));
}	// end nof_wnd_proc

BOOL initialize_system_menu (
	HMENU	h_sys,
	HMENU	h_options,
	HMENU	h_iterations,
	HMENU	h_packet_size,
	HMENU	h_packets,
	HMENU	h_conv_type,
	HMENU	h_echo,
	HMENU	h_send_data_type,
	HMENU	h_dealloc_type,
	HMENU	h_ptr_type,
	HMENU	h_interval,
	HMENU	h_help) {
	//
	//		System Menu: insert  
	//			Banner
	//		    EPing Options
	//				start aPing
	//				stop aPing
	//				set iterations
	//				set packet size
	//				query allocate time
	//				query packet time
	//     		separator
	//		    Help
	//   		Contents
	//       	Index
	//       	How to use Help
	//		    separator
	//   		About
	//    		separator
	//		delete Restore
	//		Move
	//		delete Size
	// 			"  Minimize
	// 			"  Maximize
	//
	// build the echo popup
	if (!AppendMenu (
		h_echo,
		MF_ENABLED | MF_STRING,
		IDM_ECHO_YES,
		"Yes"))
		return FALSE;

	if (!AppendMenu (
		h_echo,
		MF_ENABLED | MF_STRING,
		IDM_ECHO_NO,
		"No"))
		return FALSE;

	//
	//	build the send_data type popup
	//
	if (!AppendMenu (
		h_send_data_type,
		MF_ENABLED | MF_STRING,
		IDM_SD_NONE,
		"None"))
		return FALSE;

	if (!AppendMenu (
		h_send_data_type,
		MF_ENABLED | MF_STRING,
		IDM_SD_FLUSH,
		"Flush"))
		return FALSE;

	if (!AppendMenu (
		h_send_data_type,
		MF_ENABLED | MF_STRING,
		IDM_SD_CONFIRM,
		"Confirm"))
		return FALSE;

	if (!AppendMenu (
		h_ptr_type,
		MF_ENABLED | MF_STRING,
		IDM_PTR_NONE,
		"None"))
		return FALSE;

	if (!AppendMenu (
		h_ptr_type,
		MF_ENABLED | MF_STRING,
		IDM_PTR_FLUSH,
		"Prepare To Receive Flush"))
		return FALSE;

	if (!AppendMenu (
		h_ptr_type,
		MF_ENABLED | MF_STRING,
		IDM_PTR_SYNC_LEVEL,
		"Prepare To Receive Sync Level"))
		return FALSE;

	if (!AppendMenu (
		h_ptr_type,
		MF_ENABLED | MF_STRING,
		IDM_PTR_CONFIRM,
		"Prepare To Receive Confirm"))
		return FALSE;

	if (!AppendMenu (
		h_dealloc_type,
		MF_ENABLED | MF_STRING,
		IDM_DEALLOC_FLUSH,
		"Deallocate Flush"))
		return FALSE;

	if (!AppendMenu (
		h_dealloc_type,
		MF_ENABLED | MF_STRING,
		IDM_DEALLOC_SYNC_LEVEL,
		"Deallocate Sync Level"))
		return FALSE;

	if (!AppendMenu (
		h_dealloc_type,
		MF_ENABLED | MF_STRING,
		IDM_DEALLOC_CONFIRM,
		"Deallocate Confirm"))
		return FALSE;

	//
	// build the conv_type popup
	//
	if (!AppendMenu (
		h_conv_type,
		MF_ENABLED | MF_STRING,
		IDM_CONV_TYPE_BASIC,
		"Basic"))
		return FALSE;

	if (!AppendMenu (
		h_conv_type,
		MF_ENABLED | MF_STRING,
		IDM_CONV_TYPE_MAPPED,
		"Mapped"))
		return FALSE;

	//
	// build the ping-packet_size popup
	//
	if (!AppendMenu (
		h_packet_size,
		MF_ENABLED	| MF_STRING,
		IDM_PACKET_SIZE_0,
		"0"))
		return FALSE;

	if (!AppendMenu (
		h_packet_size,
		MF_ENABLED	| MF_STRING,
		IDM_PACKET_SIZE_40,
		"40H"))
		return FALSE;

	if (!AppendMenu (
		h_packet_size,
		MF_ENABLED	| MF_STRING,
		IDM_PACKET_SIZE_80,
		"80H"))
		return FALSE;

	if (!AppendMenu (
		h_packet_size,
		MF_ENABLED	| MF_STRING,
		IDM_PACKET_SIZE_100,
		"100H"))
		return FALSE;

	if (!AppendMenu (
		h_packet_size,
		MF_ENABLED	| MF_STRING,
		IDM_PACKET_SIZE_200,
		"200H"))
		return FALSE;

	if (!AppendMenu (
		h_packet_size,
		MF_ENABLED	| MF_STRING,
		IDM_PACKET_SIZE_400,
		"400H"))
		return FALSE;

	if (!AppendMenu (
		h_packet_size,
		MF_ENABLED	| MF_STRING,
		IDM_PACKET_SIZE_800,
		"800H"))
		return FALSE;

	if (!AppendMenu (
		h_packet_size,
		MF_ENABLED	| MF_STRING,
		IDM_PACKET_SIZE_1000,
		"1000H"))
		return FALSE;

	if (!AppendMenu (
		h_packet_size,
		MF_ENABLED	| MF_STRING,
		IDM_PACKET_SIZE_2000,
		"2000H"))
		return FALSE;

	if (!AppendMenu (
		h_packet_size,
		MF_ENABLED	| MF_STRING,
		IDM_PACKET_SIZE_4000,
		"4000H"))
		return FALSE;

	if (!AppendMenu (
		h_packet_size,
		MF_ENABLED	| MF_STRING,
		IDM_PACKET_SIZE_8000,
		"8000H"))
		return FALSE;

	//
	// build the packets popup
	//
	if (!AppendMenu (
		h_packets,
		MF_ENABLED	| MF_STRING,
		IDM_PACKETS_1,
		"1"))
		return FALSE;

	if (!AppendMenu (
		h_packets,
		MF_ENABLED	| MF_STRING,
		IDM_PACKETS_2,
		"2"))
		return FALSE;

	if (!AppendMenu (
		h_packets,
		MF_ENABLED	| MF_STRING,
		IDM_PACKETS_4,
		"4"))
		return FALSE;

	if (!AppendMenu (
		h_packets,
		MF_ENABLED	| MF_STRING,
		IDM_PACKETS_8,
		"8"))
		return FALSE;

	if (!AppendMenu (
		h_packets,
		MF_ENABLED	| MF_STRING,
		IDM_PACKETS_16,
		"16"))
		return FALSE;

	if (!AppendMenu (
		h_packets,
		MF_ENABLED	| MF_STRING,
		IDM_PACKETS_32,
		"32"))
		return FALSE;

	if (!AppendMenu (
		h_packets,
		MF_ENABLED	| MF_STRING,
		IDM_PACKETS_64,
		"64"))
		return FALSE;

	if (!AppendMenu (
		h_packets,
		MF_ENABLED	| MF_STRING,
		IDM_PACKETS_128,
		"128"))
		return FALSE;

	if (!AppendMenu (
		h_packets,
		MF_ENABLED	| MF_STRING,
		IDM_PACKETS_256,
		"256"))
		return FALSE;

	if (!AppendMenu (
		h_packets,
		MF_ENABLED	| MF_STRING,
		IDM_PACKETS_512,
		"512"))
		return FALSE;

	if (!AppendMenu (
		h_packets,
		MF_ENABLED	| MF_STRING,
		IDM_PACKETS_1024,
		"1024"))
		return FALSE;

	if (!AppendMenu (
		h_packets,
		MF_ENABLED	| MF_STRING,
		IDM_PACKETS_2048,
		"2048"))
		return FALSE;

	if (!AppendMenu (
		h_packets,
		MF_ENABLED	| MF_STRING,
		IDM_PACKETS_4096,
		"4096"))
		return FALSE;

	if (!AppendMenu (
		h_packets,
		MF_ENABLED	| MF_STRING,
		IDM_PACKETS_8192,
		"8192"))
		return FALSE;

	if (!AppendMenu (
		h_packets,
		MF_ENABLED	| MF_STRING,
		IDM_PACKETS_16384,
		"16384"))
		return FALSE;

	if (!AppendMenu (
		h_packets,
		MF_ENABLED	| MF_STRING,
		IDM_PACKETS_32768,
		"32768"))
		return FALSE;

	//
	// build the ping-iterations popup
	//
	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_1,
		"1"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_2,
		"2"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_4,
		"4"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_8,
		"8"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_16,
		"16"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_32,
		"32"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_64,
		"64"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_128,
		"128"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_256,
		"256"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_512,
		"512"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_1024,
		"1024"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_2048,
		"2048"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_4096,
		"4096"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_8192,
		"8192"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_16384,
		"16384"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_32768,
		"32768"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_EVER,
		"&Endless"))
		return FALSE;

	//
	// build the interval group
	//
	if (!AppendMenu (
		h_interval,
		MF_ENABLED | MF_STRING,
		IDM_INTERVAL_0,
		"&0 (No interval)"))
		return FALSE;

	if (!AppendMenu (
		h_interval,
		MF_ENABLED | MF_STRING,
		IDM_INTERVAL_1,
		"&1"))
		return FALSE;

	if (!AppendMenu (
		h_interval,
		MF_ENABLED | MF_STRING,
		IDM_INTERVAL_2,
		"&2"))
		return FALSE;

	if (!AppendMenu (
		h_interval,
		MF_ENABLED | MF_STRING,
		IDM_INTERVAL_4,
		"&4"))
		return FALSE;

	if (!AppendMenu (
		h_interval,
		MF_ENABLED | MF_STRING,
		IDM_INTERVAL_8,
		"&8"))
		return FALSE;

	if (!AppendMenu (
		h_interval,
		MF_ENABLED | MF_STRING,
		IDM_INTERVAL_16,
		"1&6"))
		return FALSE;

	if (!AppendMenu (
		h_interval,
		MF_ENABLED | MF_STRING,
		IDM_INTERVAL_32,
		"&32"))
		return FALSE;

	if (!AppendMenu (
		h_interval,
		MF_ENABLED | MF_STRING,
		IDM_INTERVAL_64,
		"64"))
		return FALSE;

	if (!AppendMenu (
		h_interval,
		MF_ENABLED | MF_STRING,
		IDM_INTERVAL_128,
		"128"))
		return FALSE;

	if (!AppendMenu (
		h_interval,
		MF_ENABLED | MF_STRING,
		IDM_INTERVAL_256,
		"2&56"))
		return FALSE;

	if (!AppendMenu (
		h_interval,
		MF_ENABLED | MF_STRING,
		IDM_INTERVAL_512,
		"512"))
		return FALSE;

	if (!AppendMenu (
		h_interval,
		MF_ENABLED | MF_STRING,
		IDM_INTERVAL_1024,
		"1024"))
		return FALSE;

	//
	// build the help popup
	//
	if (!AppendMenu (
		h_help,
		MF_ENABLED | MF_STRING,
		IDM_HELPCONTENTS,
		"&Contents"))
		return FALSE;

	if (!AppendMenu (
		h_help,
		MF_ENABLED | MF_STRING,
		IDM_HELPINDEX,
		"&Index"))
		return FALSE;

	if (!AppendMenu (
		h_help,
		MF_ENABLED | MF_STRING,
		IDM_HELPSEARCHFORHELPON,
		"&Search for Help on"))
		return FALSE;

	if (!AppendMenu (
		h_help,
		MF_ENABLED | MF_STRING,
		IDM_HELPHELPMODE,
		"&How to use Help"))
		return FALSE;

	if (!AppendMenu (
		h_help,
		MF_ENABLED | MF_SEPARATOR,
		IDM_SEPARATOR,
		""))
		return FALSE;

	if (!AppendMenu (
		h_help,
		MF_ENABLED | MF_STRING,
		IDM_HELPABOUT,
		"&About aPing"))
		return FALSE;

	//
	// build the options popup
	//
	if (!AppendMenu (
		h_options,
		MF_ENABLED | MF_STRING,
		IDM_SET_REMOTE_LU,
		"Set Remote &LU"))
		return FALSE;

	if (!AppendMenu (
		h_options,
		MF_ENABLED	| MF_POPUP,
		(UINT) h_iterations,
		"Set &Iterations"))
		return FALSE;

	if (!AppendMenu (
		h_options,
		MF_ENABLED | MF_POPUP,
		(UINT) h_packet_size,
		"Set Pac&ket Size"))
		return FALSE;

	if (!AppendMenu (
		h_options,
		MF_ENABLED | MF_POPUP,
		(UINT) h_packets,
		"Set &Packets per Iteration"))
		return FALSE;

	if (!AppendMenu (
		h_options,
		MF_ENABLED | MF_POPUP,
		(UINT) h_interval,
		"Interval (seconds) &between iterations"))
		return FALSE;

	if (!AppendMenu (
		h_options,
		MF_ENABLED | MF_POPUP,
		(UINT) h_conv_type,
		"Set &Conv Type"))
		return FALSE;

	if (!AppendMenu (
		h_options,
		MF_ENABLED | MF_POPUP,
		(UINT) h_echo,
		"Set &Echo"))
		return FALSE;
	
	if (!AppendMenu (
		h_options,
		MF_ENABLED | MF_POPUP,
		(UINT) h_send_data_type,
		"&Send Data Type"))
		return FALSE;

	if (!AppendMenu (
		h_options,
		MF_ENABLED | MF_POPUP,
		(UINT) h_ptr_type,
		"Prepare To &Receive Type"))
		return FALSE;

	if (!AppendMenu (
		h_options,
		MF_ENABLED | MF_POPUP,
		(UINT) h_dealloc_type,
		"&Deallocate Type"))
		return FALSE;

	if (!AppendMenu (
		h_options,
		MF_ENABLED | MF_STRING,
		IDM_ALLOCATE_TIME,
		"Query &Allocation Time"))
		return FALSE;

	if (!AppendMenu (
		h_options,
		MF_ENABLED | MF_STRING,
		IDM_PACKET_TIME,
		"Query Packet &Time"))
		return FALSE;

	if (!AppendMenu (
		h_options,
		MF_ENABLED | MF_STRING,
		IDM_REVIEW_PARAMETERS,
		"Re&view Settings"))
		return FALSE;

	if (!AppendMenu (
		h_options,
		MF_ENABLED | MF_SEPARATOR,
		IDM_SEPARATOR,
		""))
		return FALSE;

	if (!AppendMenu (
		h_options,
		MF_ENABLED | MF_POPUP,
		(UINT) h_help,
		"&Help"))
		return FALSE;
	//
	// remove restore, size, minimize, maximize from default menu
	//

	//
	// start inserting into the system menu
	//

	if (!InsertMenu (
		h_sys,
		0,
		MF_BYPOSITION | MF_SEPARATOR | MF_ENABLED,
		IDM_SEPARATOR,
		""))
		return FALSE;

	//
	// add the popup to the system menu
	//

	if (!InsertMenu (
		h_sys,
		IDM_SEPARATOR,
		MF_BYCOMMAND | MF_POPUP,
		(UINT) h_options,
		"aPing &Options"))
		return FALSE;

	if (!InsertMenu (
		h_sys,
		0,
		MF_BYPOSITION | MF_ENABLED | MF_STRING,
		IDM_STOP_EPING,
		"Sto&p aPing"))
		return FALSE;

	if (!InsertMenu (
		h_sys,
		0,
		MF_BYPOSITION | MF_ENABLED | MF_STRING,
		IDM_START_EPING,
		"&Start aPing"))
		return FALSE;

	if (!InsertMenu (
		h_sys,
		0,
		MF_BYPOSITION | MF_STRING | MF_ENABLED,
		IDM_BANNER,
		"EhnAPPC APing"))
		return FALSE;

	return TRUE;

	}  // end initialize_system_menu

void system_menu_popup (
	HMENU h_sys) {
	//
	// present Start/Stop APPC choice to the customer
	//
	// if APPC is up, we enable StopAPPC; else we enable
	// StartAPPC
	//
}  // end system_menu_popup

void options_menu_popup (
	HMENU h_options) {
}  // end options_menu_popup 

/*-----------------------------------------------------------------------
 * function	: set_remote_lu
 * filename	: EPING.CPP 			
 * author 		: Gary Rambo							   date : 9/12/97
 * parameters	: 
 * description	: 
 * returns		: 
 * notes		: 
 *-----------------------------------------------------------------------
*/BOOL
set_remote_lu (HWND hwnd) {
	int				count	= 0;
	char			alias [ALIAS_LEN+1];
	char			str [80];
	int				remote_lu_count = 0;
	char*			ptr	= NULL;
	HGLOBAL			hglobal	= NULL;
	char			local_lu [9];
	char			mode_name [9];
	memset (local_lu, 0x20, 8);
	local_lu [8]	= 0;
	mode_name [0]	= 0;
	// exploratory call:
	GetAppcConfig (
		(HANDLE) hwnd,
		(LPSTR) local_lu,
		(LPSTR) mode_name,
		(LPINT) &remote_lu_count,
		(INT) 	0,
		(LPSTR) NULL,
		(LPINT) NULL);
	if (remote_lu_count) {
		hglobal = GlobalAlloc (
					GMEM_MOVEABLE | GMEM_ZEROINIT, 
					remote_lu_count * 9);
		ptr = (char*) GlobalLock (hglobal);
		if (!ptr) {
			if (hglobal)
				GlobalFree (hglobal);
			return FALSE;
		}
	}
	else {
		MessageBox (
			hwnd,
			"no remote lus configured or with positive session limits",
			app_name,
			MB_OK);
		return FALSE;
	}
	GetAppcConfig (
		(HANDLE)hwnd,
		(LPSTR) local_lu,
		(LPSTR) mode_name,
		(LPINT) &remote_lu_count,
		(INT) 	remote_lu_count,
		(LPSTR) ptr,
		(LPINT) NULL);
	for (int u	= 0; u < remote_lu_count; u++) {
		memset (alias, 0, sizeof (alias));
		memcpy (alias, ptr + u * 9, 8);
		wsprintf (
			str, "is it :%s)?", alias);
		switch (MessageBox (
					hwnd,
					str,
					"aPing remote lu candidate",
					MB_YESNOCANCEL)) {
			case IDYES:
				// copy new values
				lstrcpy (remote_lu, alias);
				// add to window text
				lstrcpy (str, "aPinging ");
				lstrcat (str, alias);
				SetWindowText (hwnd, str);
				goto _exit;
			case IDNO:
				continue;
			case IDCANCEL:
				// keep incoming values, if any
				goto _exit;
		}
	}
	_exit: {
		if (hglobal)
			GlobalFree (hglobal);
		return (BOOL) remote_lu [0];
	}
}	// end set_remote_lu

/*-----------------------------------------------------------------------
 * function	: start_aPing
 * filename	: aPing.cpp 			
 * author 		: Gary Rambo							   date : 05/21/95
 * parameters	: 
 * description	: 
 * returns		: 
 * notes		: 
 *		allocate
 *		send data: aPingD name, instructions
 *		loop until done:
 *			receive and wait
 *		send data
 *		done
 *-----------------------------------------------------------------------
*/void WINAPI
aPing_proc (
	PINGFO*	pingfo) {
	UINT	iterations		= pingfo->iterations;
	UINT	packet_size		= pingfo->packet_size;
	BOOL	success			= FALSE;
	ULONG	conv_id			= 0;
	BYTE	tp_id [8];
	WORD	len				= 0;
	UINT	count			= 0;
	ULONG	init_tick		= 0;
	unsigned
	short	what_received	= AP_NONE;
	tp_started*	tps			= NULL;
	allocate*	alloc		= NULL;
	send_data*	sd			= NULL;
	receive_and_wait*	rcv_and_wait	= NULL;
	deallocate*	dealloc		= NULL;
	get_attributes*	get_attr	= NULL;
	confirmed*	confmd		= NULL;
	tp_ended*	tp_ended	= NULL;

	char	mode_name [12];
	char	user_id [12];
	HANDLE	hbuf			= GlobalAlloc (
								GMEM_DDESHARE | GMEM_MOVEABLE | GMEM_ZEROINIT,
								(DWORD) packet_size + 0x100);
	BYTE*	buf				= (BYTE*) GlobalLock (hbuf);
	HANDLE	hverb			= GlobalAlloc (
								GMEM_DDESHARE | GMEM_MOVEABLE | GMEM_ZEROINIT,
								(DWORD) 0x100);
	if (!buf || !hverb)	goto _failure;
	total_iterations		= 0;
	last_packet_tick		= 0;
	starting_tick			= 0;
	stop_aPing				= FALSE;
	if (iterations < 0xFFFFFFFF)
		iterate_forever		= FALSE;
	// 97.09.04: EHNAPPC_IsRouterLoaded() is optional here. E32APPC.DLL may
	//	be calling it for us
	init_tick				= GetTickCount ();
	if (!remote_lu [0])
		if (!set_remote_lu (hwnd)) {
			// 98.05.23: we need a dummy lock here
			GlobalLock (hverb);
			goto _failure;
		}
	tps	= (tp_started*) GlobalLock (hverb);
	tps->opcode	= AP_TP_STARTED;
	memset (tps->lu_alias, 0x20, 8);	// default lu
	memset (tps->tp_name, 0, 64);
	APPC ((long) tps);
	if (tps->primary_rc	== AP_OK)
		memcpy (tp_id, tps->tp_id, 8);
	else
		goto _failure;
	GlobalUnlock (hverb);
	alloc	= (allocate*) GlobalLock (hverb);
	memset (alloc, 0, sizeof (allocate));
	alloc->opcode	= AP_B_ALLOCATE;
	alloc->opext	= conv_type;
	memcpy (alloc->tp_name, ebc_aPingD_name, lstrlen ((char*) ebc_aPingD_name));
	memcpy (alloc->mode_name, ebc_inter_name, lstrlen ((char*) ebc_inter_name));
	memcpy (alloc->tp_id, tp_id, 8);
	alloc->conv_type	= conv_type;
	alloc->sync_level	= sync_level;
	alloc->user_id [0]	= 0;
	memcpy (alloc->plu_alias, remote_lu, lstrlen (remote_lu));
	APPC ((long) alloc);
	if (alloc->primary_rc == AP_OK)
		conv_id	= alloc->conv_id;
	else
		goto _failure;
	GlobalUnlock (hverb);
	get_attr	= (get_attributes*) GlobalLock (hverb);
	memset (get_attr, 0, sizeof (get_attributes));
	get_attr->opcode	= AP_B_GET_ATTRIBUTES;
	get_attr->opext		= conv_type;
	memcpy (get_attr->tp_id, tp_id, 8);
	get_attr->conv_id	= conv_id;
	APPC ((long) get_attr);
	sync_level	= get_attr->sync_level;
	memcpy (mode_name, get_attr->mode_name, 8);
	memcpy (local_lu, get_attr->lu_alias, 8);
	memcpy (remote_lu, get_attr->plu_alias, 8);
	memcpy (user_id, get_attr->user_id, 10);
	memcpy (fq_remote_lu, get_attr->fqplu_name, 17);
	// send aPingD the curious invariant
	if (conv_type	== AP_BASIC_CONVERSATION) {
		buf [0]	= 0;
		buf [1]	= 7;
		buf [2]	= 0x12;
		buf [3]	= 0xFF;
		buf [4] = 0x01;
		buf [5] = 0x02;
		buf [6] = 0x26;
	}
	else {
		buf [0] = 0x01;
		buf [1] = 0x02;
		buf [2] = 0x26;
	}
	GlobalUnlock (hverb);
	sd	= (send_data*) GlobalLock (hverb);
	memset (sd, 0, sizeof (send_data));
	sd->opcode	= AP_B_SEND_DATA;
	sd->opext	= conv_type;
	memcpy (sd->tp_id, tp_id, 8);
	sd->conv_id	= conv_id;
	sd->dlen	= conv_type == AP_BASIC_CONVERSATION? 7 : 3;
	sd->dptr	= buf;
	sd->type	= AP_NONE;
	APPC ((long) sd);
	if (sd->primary_rc != AP_OK)
		goto	_failure;
	GlobalUnlock (hverb);
	rcv_and_wait	= (receive_and_wait*) GlobalLock (hverb);
	memset (rcv_and_wait, 0, sizeof (receive_and_wait));
	rcv_and_wait->opcode		= AP_B_RECEIVE_AND_WAIT;
	rcv_and_wait->opext			= conv_type;
	memcpy (rcv_and_wait->tp_id, tp_id, 8);
	rcv_and_wait->conv_id		= conv_id;
	rcv_and_wait->rtn_status	= AP_YES;	// experiment here
	rcv_and_wait->fill			= AP_LL;
	rcv_and_wait->max_len		= 0x100;		// 0xE is enough
	rcv_and_wait->dptr			= buf;
	APPC ((long) rcv_and_wait);
	while (rcv_and_wait->primary_rc == AP_OK &&
			!(rcv_and_wait->what_rcvd & AP_SEND)) {
		APPC ((long) rcv_and_wait);
		if (rcv_and_wait->primary_rc != AP_OK)
			goto	_failure;
	}
	starting_tick			= GetTickCount ();
	allocation_time			= starting_tick - init_tick;
	memset (buf, LOBYTE (LOWORD (starting_tick)), packet_size);
	if (conv_type == AP_BASIC_CONVERSATION) {
		buf [0]	= HIBYTE (packet_size);
		buf [1]	= LOBYTE (packet_size);
		buf [2]	= 0x12;
		buf [3]	= 0xFF;
	}
	GlobalUnlock (hverb);
	// and loop
	for (count = 0; count < iterations && !stop_aPing; count++) {
		sd = (send_data*) GlobalLock (hverb);
		memset (sd, 0, sizeof (send_data));
		sd->opcode	= AP_B_SEND_DATA;
		sd->opext	= conv_type;
		memcpy (sd->tp_id, tp_id, 8);
		sd->conv_id	= conv_id;
		sd->dlen	= packet_size;
		sd->dptr	= buf;
		sd->type	= send_data_type;
		for (UINT	u = 0; u < packets; u++) {
			if (u == packets - 1) {
				if (!echo)
					sd->type	= AP_SEND_DATA_CONFIRM;
				else
					sd->type	= ptr_type;
			}
			APPC ((long) sd);
			if (sd->primary_rc != AP_OK)
				goto	_failure;
		}
		GlobalUnlock (hverb);
		if (echo) {
			rcv_and_wait	= (receive_and_wait*) GlobalLock (hverb);
			memset (rcv_and_wait, 0, sizeof (receive_and_wait));
			rcv_and_wait->opcode		= AP_B_RECEIVE_AND_WAIT;
			rcv_and_wait->opext			= conv_type;
			memcpy (rcv_and_wait->tp_id, tp_id, 8);
			rcv_and_wait->conv_id		= conv_id;
			rcv_and_wait->rtn_status	= AP_YES;
			rcv_and_wait->fill			= AP_LL;
			rcv_and_wait->max_len		= packet_size;
			rcv_and_wait->dptr			= buf;
			while (rcv_and_wait->primary_rc == AP_OK	&&
					!(rcv_and_wait->what_rcvd & AP_SEND) &&
					!(rcv_and_wait->what_rcvd & AP_CONFIRM_DEALLOCATE)) {
				APPC ((long) rcv_and_wait);
			}
			GlobalUnlock (hverb);
		}
		total_iterations++;
		if (rcv_and_wait->what_rcvd & AP_CONFIRM_DEALLOCATE) {
			confmd	= (confirmed*) GlobalLock (hverb);
			memset (confmd, 0, sizeof (confirmed));
			confmd->opcode	= AP_B_CONFIRMED;
			confmd->opext	= conv_type;
			memcpy (confmd->tp_id, tp_id, 8);
			confmd->conv_id	= conv_id;
			APPC ((long) confmd);
			GlobalUnlock (hverb);
			what_received	= rcv_and_wait->what_rcvd;
			goto _success;
		}
		else
		if (rcv_and_wait->primary_rc == AP_DEALLOC_NORMAL)
			goto	_success;
		else
		if (rcv_and_wait->primary_rc != AP_OK)
			goto	_failure;
		if (count == (iterations - 1) && iterate_forever)
			count	= 0;
		if (interval)
			Sleep (interval * 1000);
	}
	_success:
	last_packet_tick	= GetTickCount ();
	success		= TRUE;
	_deallocate: {
		dealloc	= (deallocate*) GlobalLock (hverb);
		memset (dealloc, 0, sizeof (deallocate));
		dealloc->opcode			= AP_B_DEALLOCATE;
		dealloc->opext			= conv_type;
		dealloc->dealloc_type	= dealloc_type;
		dealloc->conv_id		= conv_id;
		APPC ((long) dealloc);
		if (dealloc->primary_rc == AP_OK) {
			conv_id	= 0;
			goto	_return;
		}
		dealloc->dealloc_type	= conv_type == AP_MAPPED_CONVERSATION?
												AP_ABEND : AP_ABEND_PROG;
		APPC ((long) dealloc);
		conv_id	= 0;
		goto	_return;
	}
	_failure: {
		success		= FALSE;
		allocation_time	= 0xFFFFFFFF;
		if (conv_id)
			goto	_deallocate;
	}
	_return: {
		if (hbuf) {
			GlobalUnlock (hbuf);
			GlobalFree (hbuf);
			hbuf	= 0;
		}
		if (hverb) {
			GlobalUnlock (hverb);
			GlobalFree (hverb);
		}
		if (success)
			SendNotifyMessage (hwnd, WM_SYSCOMMAND, IDM_PACKET_TIME, 1L);
		else {
			MessageBeep (MB_ICONEXCLAMATION);
			MessageBox (hwnd, "aPing failure", app_name, MB_OK);
		}
	}
}	// end start_aPing
