Attribute VB_Name = "CPIC"
Option Explicit
Private Const MODULE_NAME = "WCPIC32.bas"
'---------------------------------------------------------------------------
'    wcpic32.bas
'    Copyright WRQ, Inc., 1998                                                
'---------------------------------------------------------------------------
'   CPI-Communications constants and function prototypes file               
'---------------------------------------------------------------------------

'---------------------------------------------------------------------------
' maximum sizes of strings and buffers
'---------------------------------------------------------------------------
Public Const CM_SIZE_CONVID = 8
Public Const CM_SIZE_LOGDATA = 512
Public Const CM_SIZE_MODENAME = 8
Public Const CM_SIZE_PARTNERLU = 17
Public Const CM_SIZE_PASSWORD = 10
Public Const CM_SIZE_SYMDESTNAME = 8
Public Const CM_SIZE_TPNAME = 64
Public Const CM_SIZE_USERID = 10

'---------------------------------------------------------------------------
' call_ID values
'---------------------------------------------------------------------------
Public Const CM_CMACCI                    As Long = 1
Public Const CM_CMACCP                    As Long = 2
Public Const CM_CMALLC                    As Long = 3
Public Const CM_CMCANC                    As Long = 4
Public Const CM_CMCFM                     As Long = 5
Public Const CM_CMCFMD                    As Long = 6
Public Const CM_CMCNVI                    As Long = 7
Public Const CM_CMCNVO                    As Long = 8
Public Const CM_CMDEAL                    As Long = 9
Public Const CM_CMDFDE                    As Long = 10
Public Const CM_CMEACN                    As Long = 11
Public Const CM_CMEAEQ                    As Long = 12
Public Const CM_CMEAPT                    As Long = 13
Public Const CM_CMECS                     As Long = 14
Public Const CM_CMECT                     As Long = 15
Public Const CM_CMECTX                    As Long = 16
Public Const CM_CMEID                     As Long = 17
Public Const CM_CMEMBS                    As Long = 18
Public Const CM_CMEMN                     As Long = 19
Public Const CM_CMEPID                    As Long = 20
Public Const CM_CMEPLN                    As Long = 21
Public Const CM_CMESI                     As Long = 22
Public Const CM_CMESL                     As Long = 23
Public Const CM_CMESRM                    As Long = 24
Public Const CM_CMESUI                    As Long = 25
Public Const CM_CMETC                     As Long = 26
Public Const CM_CMETPN                    As Long = 27
Public Const CM_CMFLUS                    As Long = 28
Public Const CM_CMINCL                    As Long = 29
Public Const CM_CMINIC                    As Long = 30
Public Const CM_CMINIT                    As Long = 31
Public Const CM_CMPREP                    As Long = 32
Public Const CM_CMPTR                     As Long = 33
Public Const CM_CMRCV                     As Long = 34
Public Const CM_CMRCVX                    As Long = 35
Public Const CM_CMRLTP                    As Long = 36
Public Const CM_CMRTS                     As Long = 37
Public Const CM_CMSAC                     As Long = 38
Public Const CM_CMSACN                    As Long = 39
Public Const CM_CMSAEQ                    As Long = 40
Public Const CM_CMSAPT                    As Long = 41
Public Const CM_CMSBT                     As Long = 42
Public Const CM_CMSCSP                    As Long = 43
Public Const CM_CMSCST                    As Long = 44
Public Const CM_CMSCSU                    As Long = 45
Public Const CM_CMSCT                     As Long = 46
Public Const CM_CMSCU                     As Long = 47
Public Const CM_CMSDT                     As Long = 48
Public Const CM_CMSED                     As Long = 49
Public Const CM_CMSEND                    As Long = 50
Public Const CM_CMSERR                    As Long = 51
Public Const CM_CMSF                      As Long = 52
Public Const CM_CMSID                     As Long = 53
Public Const CM_CMSLD                     As Long = 54
Public Const CM_CMSLTP                    As Long = 55
Public Const CM_CMSMN                     As Long = 56
Public Const CM_CMSNDX                    As Long = 57
Public Const CM_CMSPDP                    As Long = 58
Public Const CM_CMSPID                    As Long = 59
Public Const CM_CMSPLN                    As Long = 60
Public Const CM_CMSPM                     As Long = 61
Public Const CM_CMSPTR                    As Long = 62
Public Const CM_CMSQCF                    As Long = 63
Public Const CM_CMSQPM                    As Long = 64
Public Const CM_CMSRC                     As Long = 65
Public Const CM_CMSRT                     As Long = 66
Public Const CM_CMSSL                     As Long = 67
Public Const CM_CMSSRM                    As Long = 68
Public Const CM_CMSST                     As Long = 69
Public Const CM_CMSTC                     As Long = 70
Public Const CM_CMSTPN                    As Long = 71
Public Const CM_CMTRTS                    As Long = 72
Public Const CM_CMWAIT                    As Long = 73
Public Const CM_CMWCMP                    As Long = 74
Public Const CM_CMSJT                     As Long = 75
Public Const CM_CMEMID                    As Long = 76
Public Const CM_CMSMID                    As Long = 77
Public Const CM_CMSNDM                    As Long = 78
Public Const CM_CMRCVM                    As Long = 79
Public Const RW_XCMDSI                    As Long = 100
Public Const RW_XCMESI                    As Long = 101
Public Const RW_XCMSSI                    As Long = 102
Public Const RW_XCECST                    As Long = 103
Public Const RW_XCECSU                    As Long = 104
Public Const RW_XCSCSP                    As Long = 105
Public Const RW_XCSCST                    As Long = 106
Public Const RW_XCSCSU                    As Long = 107
Public Const RW_CMECST                    As Long = 108
Public Const RW_CMECSU                    As Long = 109
Public Const RW_XCHWND                    As Long = 110
Public Const RW_WINCPICCLEANUP            As Long = 111
Public Const RW_WINCPICISBLOCKING         As Long = 112
Public Const RW_WINCPICSTARTUP            As Long = 113
Public Const RW_WINCPICSETBLOCKINGHOOK    As Long = 114
Public Const RW_WINCPICUNHOOKBLOCKINGHOOK As Long = 115
Public Const RW_WINCPICSETEVENT           As Long = 116
Public Const RW_WINCPICEXTRACTEVENT       As Long = 117

'---------------------------------------------------------------------------
'allocate_confirm values
'---------------------------------------------------------------------------
 Public Const CM_ALLOCATE_NO_CONFIRM    As Long = 0
 Public Const CM_ALLOCATE_CONFIRM       As Long = 1

'---------------------------------------------------------------------------
'begin_transaction values
'---------------------------------------------------------------------------
Public Const CM_BEGIN_IMPLICIT As Long = 0
Public Const CM_BEGIN_EXPLICIT As Long = 1

'---------------------------------------------------------------------------
'confirmation_urgency values
'---------------------------------------------------------------------------
Public Const CM_CONFIRMATION_NOT_URGENT As Long = 0
Public Const CM_CONFIRMATION_URGENT     As Long = 1

'---------------------------------------------------------------------------
'control_information_received, request_to_send_received values
'---------------------------------------------------------------------------
Public Const CM_NO_CONTROL_INFO_RECEIVED        As Long = 0
Public Const CM_REQ_TO_SEND_NOT_RECEIVED        As Long = 0
Public Const CM_REQ_TO_SEND_RECEIVED            As Long = 1
Public Const CM_ALLOCATE_CONFIRMED              As Long = 2
Public Const CM_ALLOCATE_CONFIRMED_WITH_DATA    As Long = 3
Public Const CM_ALLOCATE_REJECTED_WITH_DATA     As Long = 4
Public Const CM_EXPEDITED_DATA_AVAILABLE        As Long = 5
Public Const CM_RTS_RCVD_AND_EXP_DATA_AVAIL     As Long = 6

'---------------------------------------------------------------------------
'conversation_queue values
'---------------------------------------------------------------------------
Public Const CM_INITIALIZATION_QUEUE    As Long = 0
Public Const CM_SEND_QUEUE              As Long = 1
Public Const CM_RECEIVE_QUEUE           As Long = 2
Public Const CM_SEND_RECEIVE_QUEUE      As Long = 3
Public Const CM_EXPEDITED_SEND_QUEUE    As Long = 4
Public Const CM_EXPEDITED_RECEIVE_QUEUE As Long = 5

'---------------------------------------------------------------------------
'conversation_security_type values
'---------------------------------------------------------------------------
Public Const CM_SECURITY_NONE           As Long = 0
Public Const CM_SECURITY_SAME           As Long = 1
Public Const CM_SECURITY_PROGRAM        As Long = 2
Public Const CM_SECURITY_DISTRIBUTED    As Long = 3
Public Const CM_SECURITY_MUTUAL         As Long = 4
Public Const CM_SECURITY_PROGRAM_STRONG As Long = 5

'---------------------------------------------------------------------------
'conversation_state values
'---------------------------------------------------------------------------
Public Const CM_INITIALIZE_STATE              As Long = 2
Public Const CM_SEND_STATE                    As Long = 3
Public Const CM_RECEIVE_STATE                 As Long = 4
Public Const CM_SEND_PENDING_STATE            As Long = 5
Public Const CM_CONFIRM_STATE                 As Long = 6
Public Const CM_CONFIRM_SEND_STATE            As Long = 7
Public Const CM_CONFIRM_DEALLOCATE_STATE      As Long = 8
Public Const CM_DEFER_RECEIVE_STATE           As Long = 9
Public Const CM_DEFER_DEALLOCATE_STATE        As Long = 10
Public Const CM_SYNC_POINT_STATE              As Long = 11
Public Const CM_SYNC_POINT_SEND_STATE         As Long = 12
Public Const CM_SYNC_POINT_DEALLOCATE_STATE   As Long = 13
Public Const CM_INITIALIZE_INCOMING_STATE     As Long = 14
Public Const CM_SEND_ONLY_STATE               As Long = 15
Public Const CM_RECEIVE_ONLY_STATE            As Long = 16
Public Const CM_SEND_RECEIVE_STATE            As Long = 17
Public Const CM_PREPARED_STATE                As Long = 18

'---------------------------------------------------------------------------
'conversation_type values
'---------------------------------------------------------------------------
Public Const CM_BASIC_CONVERSATION  As Long = 0
Public Const CM_MAPPED_CONVERSATION As Long = 1

'---------------------------------------------------------------------------
'data_received values
'---------------------------------------------------------------------------
Public Const CM_NO_DATA_RECEIVED            As Long = 0
Public Const CM_DATA_RECEIVED               As Long = 1
Public Const CM_COMPLETE_DATA_RECEIVED      As Long = 2
Public Const CM_INCOMPLETE_DATA_RECEIVED    As Long = 3

'---------------------------------------------------------------------------
'deallocate_type values
'---------------------------------------------------------------------------
Public Const CM_DEALLOCATE_SYNC_LEVEL   As Long = 0
Public Const CM_DEALLOCATE_FLUSH        As Long = 1
Public Const CM_DEALLOCATE_CONFIRM      As Long = 2
Public Const CM_DEALLOCATE_ABEND        As Long = 3

'---------------------------------------------------------------------------
'directory_encoding values
'---------------------------------------------------------------------------
Public Const CM_DEFAULT_ENCODING As Long = 0
Public Const CM_UNICODE_ENCODING As Long = 1

'---------------------------------------------------------------------------
'directory_syntax values
'---------------------------------------------------------------------------
Public Const CM_DEFAULT_SYNTAX  As Long = 0
Public Const CM_DCE_SYNTAX      As Long = 1
Public Const CM_XDS_SYNTAX      As Long = 2
Public Const CM_NDS_SYNTAX      As Long = 3

'---------------------------------------------------------------------------
'error_direction values
'---------------------------------------------------------------------------
Public Const CM_RECEIVE_ERROR   As Long = 0
Public Const CM_SEND_ERROR      As Long = 1

'---------------------------------------------------------------------------
'fill values
'---------------------------------------------------------------------------
Public Const CM_FILL_LL     As Long = 0
Public Const CM_FILL_BUFFER As Long = 1

'---------------------------------------------------------------------------
'join transaction values
'---------------------------------------------------------------------------
Public Const CM_JOIN_IMPLICIT As Long = 0
Public Const CM_JOIN_EXPLICIT As Long = 1

'---------------------------------------------------------------------------
'partner_ID_scope values
'---------------------------------------------------------------------------
Public Const CM_EXPLICIT  As Long = 0
Public Const CM_REFERENCE As Long = 1

'---------------------------------------------------------------------------
'partner_ID_type values
'---------------------------------------------------------------------------
Public Const CM_DISTINGUISHED_NAME          As Long = 0
Public Const CM_LOCAL_DISTINGUISHED_NAME    As Long = 1
Public Const CM_PROGRAM_FUNCTION_ID         As Long = 2
Public Const CM_OSI_TPSU_TITLE_OID          As Long = 3
Public Const CM_PROGRAM_BINDING             As Long = 4

'---------------------------------------------------------------------------
'prepare_data_permitted values
'---------------------------------------------------------------------------
Public Const CM_PREPARE_DATA_NOT_PERMITTED  As Long = 0
Public Const CM_PREPARE_DATA_PERMITTED      As Long = 1

'---------------------------------------------------------------------------
'prepare_to_receive_type values
'---------------------------------------------------------------------------
Public Const CM_PREP_TO_RECEIVE_SYNC_LEVEL  As Long = 0
Public Const CM_PREP_TO_RECEIVE_FLUSH       As Long = 1
Public Const CM_PREP_TO_RECEIVE_CONFIRM     As Long = 2

'---------------------------------------------------------------------------
'processing_mode values
'---------------------------------------------------------------------------
Public Const CM_BLOCKING        As Long = 0
Public Const CM_NON_BLOCKING    As Long = 1

'---------------------------------------------------------------------------
'receive_type values, expedited_receive_type
'---------------------------------------------------------------------------
Public Const CM_RECEIVE_AND_WAIT    As Long = 0
Public Const CM_RECEIVE_IMMEDIATE   As Long = 1

'---------------------------------------------------------------------------
'return_code values
'---------------------------------------------------------------------------
Public Const CM_OK                            As Long = 0
Public Const CM_ALLOCATE_FAILURE_NO_RETRY     As Long = 1
Public Const CM_ALLOCATE_FAILURE_RETRY        As Long = 2
Public Const CM_CONVERSATION_TYPE_MISMATCH    As Long = 3
Public Const CM_PIP_NOT_SPECIFIED_CORRECTLY   As Long = 5
Public Const CM_SECURITY_NOT_VALID            As Long = 6
Public Const CM_SYNC_LVL_NOT_SUPPORTED_SYS    As Long = 7
Public Const CM_SYNC_LVL_NOT_SUPPORTED_PGM    As Long = 8
Public Const CM_TPN_NOT_RECOGNIZED            As Long = 9
Public Const CM_TP_NOT_AVAILABLE_NO_RETRY     As Long = 10
Public Const CM_TP_NOT_AVAILABLE_RETRY        As Long = 11
Public Const CM_DEALLOCATED_ABEND             As Long = 17
Public Const CM_DEALLOCATED_NORMAL            As Long = 18
Public Const CM_PARAMETER_ERROR               As Long = 19
Public Const CM_PRODUCT_SPECIFIC_ERROR        As Long = 20
Public Const CM_PROGRAM_ERROR_NO_TRUNC        As Long = 21
Public Const CM_PROGRAM_ERROR_PURGING         As Long = 22
Public Const CM_PROGRAM_ERROR_TRUNC           As Long = 23
Public Const CM_PROGRAM_PARAMETER_CHECK       As Long = 24
Public Const CM_PROGRAM_STATE_CHECK           As Long = 25
Public Const CM_RESOURCE_FAILURE_NO_RETRY     As Long = 26
Public Const CM_RESOURCE_FAILURE_RETRY        As Long = 27
Public Const CM_UNSUCCESSFUL                  As Long = 28
Public Const CM_DEALLOCATED_ABEND_SVC         As Long = 30
Public Const CM_DEALLOCATED_ABEND_TIMER       As Long = 31
Public Const CM_SVC_ERROR_NO_TRUNC            As Long = 32
Public Const CM_SVC_ERROR_PURGING             As Long = 33
Public Const CM_SVC_ERROR_TRUNC               As Long = 34
Public Const CM_OPERATION_INCOMPLETE          As Long = 35
Public Const CM_SYSTEM_EVENT                  As Long = 36
Public Const CM_OPERATION_NOT_ACCEPTED        As Long = 37
Public Const CM_CONVERSATION_ENDING           As Long = 38
Public Const CM_SEND_RCV_MODE_NOT_SUPPORTED   As Long = 39
Public Const CM_BUFFER_TOO_SMALL              As Long = 40
Public Const CM_EXP_DATA_NOT_SUPPORTED        As Long = 41
Public Const CM_DEALLOC_CONFIRM_REJECT        As Long = 42
Public Const CM_ALLOCATION_ERROR              As Long = 43
Public Const CM_RETRY_LIMIT_EXCEEDED          As Long = 44
Public Const CM_NO_SECONDARY_INFORMATION      As Long = 45
Public Const CM_SECURITY_NOT_SUPPORTED        As Long = 46
Public Const CM_SECURITY_MUTUAL_FAILED        As Long = 47
Public Const CM_CALL_NOT_SUPPORTED            As Long = 48
Public Const CM_PARM_VALUE_NOT_SUPPORTED      As Long = 49
Public Const CM_UNKNOWN_MAP_NAME_REQUESTED    As Long = 50
Public Const CM_UNKNOWN_MAP_NAME_RECEIVED     As Long = 51
Public Const CM_MAP_ROUTINE_ERROR             As Long = 52
Public Const CM_CONVERSATION_CANCELLED        As Long = 53
Public Const CM_TAKE_BACKOUT                  As Long = 100
Public Const CM_DEALLOCATED_ABEND_BO          As Long = 130
Public Const CM_DEALLOCATED_ABEND_SVC_BO      As Long = 131
Public Const CM_DEALLOCATED_ABEND_TIMER_BO    As Long = 132
Public Const CM_RESOURCE_FAIL_NO_RETRY_BO     As Long = 133
Public Const CM_RESOURCE_FAILURE_RETRY_BO     As Long = 134
Public Const CM_DEALLOCATED_NORMAL_BO         As Long = 135
Public Const CM_CONV_DEALLOC_AFTER_SYNCPT     As Long = 136
Public Const CM_INCLUDE_PARTNER_REJECT_BO     As Long = 137

'---------------------------------------------------------------------------
'return_control values
'---------------------------------------------------------------------------
Public Const CM_WHEN_SESSION_ALLOCATED      As Long = 0
Public Const CM_IMMEDIATE                   As Long = 1
Public Const CM_WHEN_CONWINNER_ALLOCATED    As Long = 2
Public Const CM_WHEN_SESSION_FREE           As Long = 2

'---------------------------------------------------------------------------
'send_receive_mode values
'---------------------------------------------------------------------------
Public Const CM_HALF_DUPLEX As Long = 0
Public Const CM_FULL_DUPLEX As Long = 1

'---------------------------------------------------------------------------
'send_type values
'---------------------------------------------------------------------------
Public Const CM_BUFFER_DATA                 As Long = 0
Public Const CM_SEND_AND_FLUSH              As Long = 1
Public Const CM_SEND_AND_CONFIRM            As Long = 2
Public Const CM_SEND_AND_PREP_TO_RECEIVE    As Long = 3
Public Const CM_SEND_AND_DEALLOCATE         As Long = 4

'---------------------------------------------------------------------------
'status_received values
'---------------------------------------------------------------------------
Public Const CM_NO_STATUS_RECEIVED            As Long = 0
Public Const CM_SEND_RECEIVED                 As Long = 1
Public Const CM_CONFIRM_RECEIVED              As Long = 2
Public Const CM_CONFIRM_SEND_RECEIVED         As Long = 3
Public Const CM_CONFIRM_DEALLOC_RECEIVED      As Long = 4
Public Const CM_TAKE_COMMIT                   As Long = 5
Public Const CM_TAKE_COMMIT_SEND              As Long = 6
Public Const CM_TAKE_COMMIT_DEALLOCATE        As Long = 7
Public Const CM_TAKE_COMMIT_DATA_OK           As Long = 8
Public Const CM_TAKE_COMMIT_SEND_DATA_OK      As Long = 9
Public Const CM_TAKE_COMMIT_DEALLOC_DATA_OK   As Long = 10
Public Const CM_PREPARE_OK                    As Long = 11
Public Const CM_JOIN_TRANSACTION              As Long = 12

'---------------------------------------------------------------------------
'sync_level values
'---------------------------------------------------------------------------
Public Const CM_NONE                    As Long = 0
Public Const CM_CONFIRM                 As Long = 1
Public Const CM_SYNC_POINT              As Long = 2
Public Const CM_SYNC_POINT_NO_CONFIRM   As Long = 3

'---------------------------------------------------------------------------
'transaction_control values
'---------------------------------------------------------------------------
Public Const CM_CHAINED_TRANSACTIONS    As Long = 0
Public Const CM_UNCHAINED_TRANSACTIONS  As Long = 1

'---------------------------------------------------------------------------
' Values for conversation_security_type in SIDE_INFO
'---------------------------------------------------------------------------
Public Const XC_SECURITY_NONE     As Long = 0
Public Const XC_SECURITY_SAME     As Long = 1
Public Const XC_SECURITY_PROGRAM  As Long = 2


'---------------------------------------------------------------------------
' Values for the TP_name_type
'---------------------------------------------------------------------------
Public Const XC_APPLICATION_TP  As Long = 0
Public Const XC_SNA_SERVICE_TP  As Long = 1

'---------------------------------------------------------------------------
' CPIC data structure required by WinCPICStartup
'---------------------------------------------------------------------------
Type WCPICDATA
    wVersion As Integer
    szDescription As String * 128
End Type

'---------------------------------------------------------------------------
' SIDE_INFO structure required by xcmesi and xcmssi
'---------------------------------------------------------------------------
Type SIDE_INFO
    sym_dest_name As String * 8
    partner_LU_name As String * 17
    reserved3 As String * 3
    TP_name_type As Long
    TP_name As String * 64
    mode_name As String * 8
    conversation_security_type As Long
    security_user_ID As String * 8
    security_password As String * 8
End Type


'---------------------------------------------------------------------------
' Function prototypes for CPIC call routines
'---------------------------------------------------------------------------

Declare Sub CMACCP Lib "WCPIC32" Alias "cmaccp" (ByVal ConvID As String, _
                                                           ReturnCode As Long)

Declare Sub CMACCI Lib "WCPIC32" Alias "cmacci" (ByVal ConvID As String, _
                                                           ReturnCode As Long)

Declare Sub CMALLC Lib "WCPIC32" Alias "cmallc" (ByVal ConvID As String, _
                                                           ReturnCode As Long)

Declare Sub CMCANC Lib "WCPIC32" Alias "cmcanc" (ByVal ConvID As String, _
                                                           ReturnCode As Long)

Declare Sub CMCFM Lib "WCPIC32" Alias "cmcfm" (ByVal ConvID As String, _
                                                         ControlInfoReceived As Long, _
                                                         ReturnCode As Long)

Declare Sub CMCFMD Lib "WCPIC32" Alias "cmcfmd" (ByVal ConvID As String, _
                                                           ReturnCode As Long)

Declare Sub CMCNVI Lib "WCPIC32" Alias "cmcnvi" (ByVal Buffer As String, _
                                                           BufferLength As Long, _
                                                           ReturnCode As Long)

Declare Sub CMCNVO Lib "WCPIC32" Alias "cmcnvo" (ByVal Buffer As String, _
                                                           BufferLength As Long, _
                                                           ReturnCode As Long)

Declare Sub CMDEAL Lib "WCPIC32" Alias "cmdeal" (ByVal ConvID As String, _
                                                           ReturnCode As Long)

Declare Sub CMECTX Lib "WCPIC32" Alias "cmectx" (ByVal ConvID As String, _
                                                     ByVal ContextID As String, _
                                                           ContextIDLength As Long, _
                                                           ReturnCode As Long)

Declare Sub CMECS Lib "WCPIC32" Alias "cmecs" (ByVal ConvID As String, _
                                                         ConvState As Long, _
                                                         ReturnCode As Long)

Declare Sub CMECT Lib "WCPIC32" Alias "cmect" (ByVal ConvID As String, _
                                                         ConvType As Long, _
                                                         ReturnCode As Long)

Declare Sub CMEMBS Lib "WCPIC32" Alias "cmembs" (MaxBufferSize As Long, _
                                                     ReturnCode As Long)

Declare Sub CMEMN Lib "WCPIC32" Alias "cmemn" (ByVal ConvID As String, _
                                                   ByVal ModeName As String, _
                                                         ModeNameLength As Long, _
                                                         ReturnCode As Long)

Declare Sub CMEPLN Lib "WCPIC32" Alias "cmepln" (ByVal ConvID As String, _
                                                     ByVal PartnerLUName As String, _
                                                           PartnerLUNameLength As Long, _
                                                           ReturnCode As Long)

Declare Sub CMESI Lib "WCPIC32" Alias "cmesi" (ByVal ConvID As String, _
                                                         CallID As Long, _
                                                   ByVal Buffer As String, _
                                                         RequestedLength As Long, _
                                                         DataReceived As Long, _
                                                         ReceivedLength As Long, _
                                                         ReturnCode As Long)

Declare Sub CMESUI Lib "WCPIC32" Alias "cmesui" (ByVal ConvID As String, _
                                                     ByVal SecurityUserID As String, _
                                                           SecurityUserIDLength As Long, _
                                                           ReturnCode As Long)

Declare Sub CMESRM Lib "WCPIC32" Alias "cmesrm" (ByVal ConvID As String, _
                                                           SendReceiveMode As Long, _
                                                           ReturnCode As Long)

Declare Sub CMESL Lib "WCPIC32" Alias "cmesl" (ByVal ConvID As String, _
                                                         SyncLevel As Long, _
                                                         ReturnCode As Long)

Declare Sub CMETPN Lib "WCPIC32" Alias "cmetpn" (ByVal ConvID As String, _
                                                     ByVal TPName As String, _
                                                           TPNameLength As Long, _
                                                           ReturnCode As Long)

Declare Sub CMFLUS Lib "WCPIC32" Alias "cmflus" (ByVal ConvID As String, _
                                                           ReturnCode As Long)

Declare Sub CMINIT Lib "WCPIC32" Alias "cminit" (ByVal ConvID As String, _
                                                     ByVal SymDestName As String, _
                                                           ReturnCode As Long)

Declare Sub CMINIC Lib "WCPIC32" Alias "cminic" (ByVal ConvID As String, _
                                                           ReturnCode As Long)

Declare Sub CMPTR Lib "WCPIC32" Alias "cmptr" (ByVal ConvID As String, _
                                                         ReturnCode As Long)

Declare Sub CMRCV Lib "WCPIC32" Alias "cmrcv" (ByVal ConvID As String, _
                                                   ByVal Buffer As String, _
                                                         RequestedLength As Long, _
                                                         DataReceived As Long, _
                                                         ReceivedLength As Long, _
                                                         StatusReceived As Long, _
                                                         ControlInfoReceived As Long, _
                                                         ReturnCode As Long)

Declare Sub CMRCVX Lib "WCPIC32" Alias "cmrcvx" (ByVal ConvID As String, _
                                                     ByVal Buffer As String, _
                                                           RequestedLength As Long, _
                                                           ReceivedLength As Long, _
                                                           ControlInfoReceived As Long, _
                                                           ExpeditedReceiveType, _
                                                           ReturnCode As Long)

Declare Sub CMRLTP Lib "WCPIC32" Alias "cmrltp" (ByVal TPName As String, _
                                                           TPNameLength As Long, _
                                                           ReturnCode As Long)

Declare Sub CMRTS Lib "WCPIC32" Alias "cmrts" (ByVal ConvID As String, _
                                                         ReturnCode As Long)

Declare Sub CMSEND Lib "WCPIC32" Alias "cmsend" (ByVal ConvID As String, _
                                                     ByVal Buffer As String, _
                                                           SendLength As Long, _
                                                           ControlInfoReceived As Long, _
                                                           ReturnCode As Long)

Declare Sub CMSNDX Lib "WCPIC32" Alias "cmsndx" (ByVal ConvID As String, _
                                                     ByVal Buffer As String, _
                                                           SendLength As Long, _
                                                           ControlInfoReceived As Long, _
                                                           ReturnCode As Long)

Declare Sub CMSERR Lib "WCPIC32" Alias "cmserr" (ByVal ConvID As String, _
                                                           ControlInfoReceived As Long, _
                                                           ReturnCode As Long)

Declare Sub CMSCU Lib "WCPIC32" Alias "cmscu" (ByVal ConvID As String, _
                                                         ConfirmationUrgency As Long, _
                                                         ReturnCode As Long)

Declare Sub CMSCSP Lib "WCPIC32" Alias "cmscsp" (ByVal ConvID As String, _
                                                     ByVal SecurityPassword As String, _
                                                           SecurityPasswordLength As Long, _
                                                           ReturnCode As Long)

Declare Sub CMSCST Lib "WCPIC32" Alias "cmscst" (ByVal ConvID As String, _
                                                           ConvSecurityType As Long, _
                                                           ReturnCode As Long)

Declare Sub CMSCSU Lib "WCPIC32" Alias "cmscsu" (ByVal ConvID As String, _
                                                     ByVal SecurityUserID As String, _
                                                           SecurityUserIDLength As Long, _
                                                           ReturnCode As Long)

Declare Sub CMSCT Lib "WCPIC32" Alias "cmsct" (ByVal ConvID As String, _
                                                         ConvType As Long, _
                                                         ReturnCode As Long)

Declare Sub CMSDT Lib "WCPIC32" Alias "cmsdt" (ByVal ConvID As String, _
                                                         DeallocateType As Long, _
                                                         ReturnCode As Long)

Declare Sub CMSED Lib "WCPIC32" Alias "cmsed" (ByVal ConvID As String, _
                                                         ErrorDirection As Long, _
                                                         ReturnCode As Long)

Declare Sub CMSF Lib "WCPIC32" Alias "cmsf" (ByVal ConvID As String, _
                                                       Fill As Long, _
                                                       ReturnCode As Long)

Declare Sub CMSJT Lib "WCPIC32" Alias "cmsjt" (ByVal ConvID As String, _
                                                         JoinTransaction As Long, _
                                                         ReturnCode As Long)

Declare Sub CMSLD Lib "WCPIC32" Alias "cmsld" (ByVal ConvID As String, _
                                                   ByVal LogData As String, _
                                                         LogDataLength As Long, _
                                                         ReturnCode As Long)

Declare Sub CMSMN Lib "WCPIC32" Alias "cmsmn" (ByVal ConvID As String, _
                                                   ByVal ModeName As String, _
                                                         ModeNameLength As Long, _
                                                         ReturnCode As Long)

Declare Sub CMSPID Lib "WCPIC32" Alias "cmspid" (ByVal ConvID As String, _
                                                           PartnerIDType As Long, _
                                                     ByVal PartnerID As String, _
                                                           PartnerIDLength As Long, _
                                                           PartnerIDScope As Long, _
                                                           DirectorySyntax As Long, _
                                                           DirectoryEncoding As Long, _
                                                           ReturnCode As Long)

Declare Sub CMSPLN Lib "WCPIC32" Alias "cmspln" (ByVal ConvID As String, _
                                                     ByVal PartnerLUName As String, _
                                                           PartnerLUNameLength As Long, _
                                                           ReturnCode As Long)

Declare Sub CMSPTR Lib "WCPIC32" Alias "cmsptr" (ByVal ConvID As String, _
                                                           PrepareToReceiveType As Long, _
                                                           ReturnCode As Long)

Declare Sub CMSPM Lib "WCPIC32" Alias "cmspm" (ByVal ConvID As String, _
                                                         ProcessingMode As Long, _
                                                         ReturnCode As Long)

Declare Sub CMSQPM Lib "WCPIC32" Alias "cmsqpm" (ByVal ConvID As String, _
                                                           ConvQueue As Long, _
                                                           QueueProcessingMode As Long, _
                                                     ByVal UserField As String, _
                                                           OOID As Long, _
                                                           ReturnCode As Long)

Declare Sub CMSRT Lib "WCPIC32" Alias "cmsrt" (ByVal ConvID As String, _
                                                         ReceiveType As Long, _
                                                         ReturnCode As Long)

Declare Sub CMSRC Lib "WCPIC32" Alias "cmsrc" (ByVal ConvID As String, _
                                                         ReturnControl As Long, _
                                                         ReturnCode As Long)

Declare Sub CMSSRM Lib "WCPIC32" Alias "cmssrm" (ByVal ConvID As String, _
                                                           SendReceiveMode As Long, _
                                                           ReturnCode As Long)

Declare Sub CMSST Lib "WCPIC32" Alias "cmsst" (ByVal ConvID As String, _
                                                         SendType As Long, _
                                                         ReturnCode As Long)

Declare Sub CMSSL Lib "WCPIC32" Alias "cmssl" (ByVal ConvID As String, _
                                                         SyncLevel As Long, _
                                                         ReturnCode As Long)

Declare Sub CMSTPN Lib "WCPIC32" Alias "cmstpn" (ByVal ConvID As String, _
                                                     ByVal TPName As String, _
                                                           TPNameLength As Long, _
                                                           ReturnCode As Long)

Declare Sub CMSLTP Lib "WCPIC32" Alias "cmsltp" (ByVal TPName As String, _
                                                           TPNameLength As Long, _
                                                           ReturnCode As Long)

Declare Sub CMTRTS Lib "WCPIC32" Alias "cmtrts" (ByVal ConvID As String, _
                                                           ControlInfoReceived As Long, _
                                                           ReturnCode As Long)

Declare Sub CMWAIT Lib "WCPIC32" Alias "cmwait" (ByVal ConvID As String, _
                                                           ConvReturnCode As Long, _
                                                           ReturnCode As Long)

Declare Function WinCPICCleanup Lib "WCPIC32" () As Long

Declare Function WinCPICStartup Lib "WCPIC32" ( ByVal wVersionRequired As Integer, _
                                                CpicData As WCPICDATA) As Long

Declare Sub XCMDSI Lib "WCPIC32" Alias "xcmdsi" (ByVal KeyLock As String, _
                                                 ByVal SymdestName As String, _
                                                 ReturnCode As Long )

Declare Sub XCMESI Lib "WCPIC32" Alias "xcmesi" (EntryNumber As Long, _
                                                 ByVal SymdestName As String, _
                                                 SideInfo As SIDE_INFO, _
                                                 SideInfoLength As Long, _
                                                 ReturnCode As Long )

Declare Sub XCMSSI Lib "WCPIC32" Alias "xcmssi" (ByVal KeyLock As String, _
                                                 SideInfo As SIDE_INFO, _
                                                 SideInfoLength As Long, _
                                                 ReturnCode As Long )
