/*  $Id: //ribm/12.0/dev/snaeng32/snalu62/eping.cpp#1 $ */
/*-----------------------------------------------------------------------
 * Name........... nof.cpp
 * Product........ Reflection for IBM SNA Transport User
 * Description.... 
 * 
 * System......... Windows
 * Language....... C++
 * Designer....... Gary Rambo
 * Created........ 95.03.11
 * Copyright...... (c) WRQ Inc. 1994-1995
 *
 * $State: Exp $
 * $Source: $
 *-----------------------------------------------------------------------
 * Modifications
 *-----------------------------------------------------------------------
*/
#include	<windows.h>
#include	<string.h>
#include	<stdlib.h>

extern "C" {
#include	"..\r8misc\e32appc.h"	// or wherever the thing is
}
#include	"eping.hpp"

typedef	unsigned long	ULONG;

char		app_name []		= "ePing";
HINSTANCE	hinst;
HWND		hwnd;
HANDLE		eping_thread;
BOOL		iterate_forever;
BOOL		stop_eping;
UINT		allocation_time;
UINT		starting_tick;
UINT		last_packet_tick;
UINT		total_iterations;
UINT		iterations	= 1, consecutive = 1, packet_size = 0x100;
char		remote_lu [EHNAPPC_ALIAS_LENGTH+1];
char		fq_remote_lu [17+1];
char		local_lu [12];
ConversationType	conv_type 	= EHNAPPC_MAPPED;
BYTE		sync_level	= EHNAPPC_SYNCLEVELCONFIRM;

int PASCAL 
WinMain	(
	HINSTANCE	hinst_current, 
	HINSTANCE	hinst_previous, 
	LPSTR		lp_cmd_line, 
	int			cmd_show) {

	MSG msg;

	if (!init_application (hinst_current, hinst_previous))
		return FALSE;						/* initialization failed */

	/* Perform initializations for this instance. */
	if (!init_instance (cmd_show))
		return FALSE;

	/* Get and dispatch messages until WM_QUIT message. */
	while (GetMessage (&msg, NULL, 0, 0)) {
		TranslateMessage (&msg);		/* translates virtual key codes    */
		DispatchMessage (&msg);			/* dispatches message to window    */
	}
	return (int) msg.wParam;			/* return value of PostQuitMessage */
}	//	end WinMain

BOOL
init_application (
	HINSTANCE	hinst_current,
	HINSTANCE	hinst_previous) {
	WNDCLASS  	wc;

	hinst				= hinst_current;
	wc.style 			= CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc 		= eping_wnd_proc;
	wc.cbClsExtra		= 0;
	wc.cbWndExtra		= 0;
	wc.hInstance		= hinst;
	wc.hIcon			= NULL;
	wc.hCursor			= LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground	= (HBRUSH) COLOR_WINDOW;
	wc.lpszMenuName		= "";
	wc.lpszClassName	= app_name;

	if (!hinst_previous)
		return (RegisterClass (&wc));
	else return TRUE;
}	//	end init_application

BOOL
init_instance (int			cmd_show) {
	BOOL	unique 			= FALSE;
	BYTE	ping_instance	= 0;
	// 95.05.31.	Problems with asynchronous completion aren't improved
	//				affect by SetMessageQueue (120)
	hwnd = CreateWindow (
		app_name,
		app_name,
		WS_VISIBLE | WS_OVERLAPPED | WS_SYSMENU | WS_MINIMIZE,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		0,
		0,
		HWND_DESKTOP,
		NULL,
		hinst,
		(LPSTR) NULL);
	if (!hwnd)
		return (FALSE);
	ShowWindow (hwnd, cmd_show);
	return TRUE;
}

extern "C" long CALLBACK
eping_wnd_proc (
	HWND		hwnd,
	UINT	 	message,
	WPARAM 		wparam,
	LPARAM		lparam) {
	static   	
	HMENU 		hmenu_sys, hmenu_options, hmenu_help, hmenu_iterations, 
				hmenu_packet_size, hmenu_conv_type, hmenu_sync_level;
	switch (message) {
		case WM_CREATE: {
			hmenu_sys			= GetSystemMenu (hwnd, FALSE);
			hmenu_options		= CreatePopupMenu ();
			hmenu_iterations	= CreatePopupMenu ();
			hmenu_packet_size	= CreatePopupMenu ();
			hmenu_conv_type		= CreatePopupMenu ();
			hmenu_sync_level	= CreatePopupMenu ();
			hmenu_help			= CreatePopupMenu ();
			UpdateWindow (hwnd);
			if (initialize_system_menu (
				hmenu_sys, hmenu_options, hmenu_iterations, 
				hmenu_packet_size, hmenu_conv_type, 
				hmenu_sync_level, hmenu_help))
				return 0L;     // success
			return 0L;		// 97.09.08 test
		}
		case WM_CLOSE:
		case WM_ENDSESSION: {
			DestroyWindow(hwnd);
			return(0);
		}
		case WM_INITMENUPOPUP: {
			if (hmenu_sys == (HMENU) wparam) {
				system_menu_popup (hmenu_sys);
				return 0L;
			}
			else if (hmenu_options == (HMENU) wparam) {
				options_menu_popup (hmenu_options);
				return 0L;
			}
			break;
		}
		case WM_SYSCOMMAND: {
			static
			BOOL	sent_name;
			switch (wparam) {
				case IDM_START_EPING: {
					DWORD		eping_tid;
					if (WaitForSingleObject (eping_thread, 0) == WAIT_TIMEOUT) {
						MessageBox (hwnd, "eping busy", app_name, MB_OK);
						break;
					}
					pingfo.iterations	= iterations;
					pingfo.packet_size	= packet_size;
					if (!(eping_thread = 
							CreateThread (
								NULL,
								0,
								(PTHREAD_START_ROUTINE) eping_proc,
								&pingfo,
								0,
								&eping_tid))) {
						MessageBox (hwnd, "can't start eping thread", app_name, MB_OK);
						break;
					}
					break;
				}
				case IDM_STOP_EPING:
					if (WaitForSingleObject (eping_thread, 0) == WAIT_TIMEOUT)
						stop_eping		= TRUE;
					break;
				case IDM_SET_REMOTE_LU:
					if (WaitForSingleObject (eping_thread, 0) != WAIT_TIMEOUT)
						set_remote_lu (hwnd);
					break;
				case IDM_ALLOCATE_TIME: {
					char str [256];
					wsprintf ((LPSTR) str, "allocation time:%lums", allocation_time);
					MessageBox (hwnd, str, "ePing Allocation Time", MB_OK);
					break;
				}
				case IDM_CONV_TYPE_BASIC: {
					conv_type	= EHNAPPC_BASIC;
					break;
				}
				case IDM_CONV_TYPE_MAPPED: {
					conv_type	= EHNAPPC_MAPPED;
					break;
				}
				case IDM_SYNC_LEVEL_NONE: {
					sync_level	= EHNAPPC_SYNCLEVELNONE;
					break;
				}
				case IDM_SYNC_LEVEL_CONFIRM: {
					sync_level	= EHNAPPC_SYNCLEVELCONFIRM;
					break;
				}
				case IDM_REVIEW_PARAMETERS: {
					// remote lu, packet_size, iterations, conv_type are the 
					//	current guys. But ApingD doesn't seem to handle BASIC 
					//	conv.. Make sure ePingD does.
					char	str [256];
					wsprintf (str, "remote lu:%s\niterations:%lu\npacket_size:%u\nconv_type:%s\nsync_level:%s",
						fq_remote_lu,
						iterations,
						packet_size,
						conv_type == EHNAPPC_BASIC? "Basic" : "Mapped",
						sync_level == EHNAPPC_SYNCLEVELNONE? "None" : "Confirm");
					MessageBox (hwnd, str, "ePing Settings", MB_OK);
					break;
				}
				case IDM_PACKET_TIME: {
					UINT	total_bytes = packet_size * total_iterations * 2;
					UINT	total_time = 0;
					if (!starting_tick)
						total_time	= 0;
					else
					if (last_packet_tick)
						total_time	= last_packet_tick - starting_tick;
					else
						total_time	= GetTickCount () - starting_tick;
					char	str [256];
					char	activity [40];
					if (lparam)
						lstrcpy (activity, "Completed");
					else
					if (WaitForSingleObject (eping_thread, 0) == WAIT_TIMEOUT)
						if (iterate_forever)
							lstrcpy (activity, "Yes: endlessly");
						else
							wsprintf (
								activity, 
								"Yes: %lu iterations remaining", 
								iterations - total_iterations);
					else
						lstrcpy (activity, "No");
					wsprintf (
						(LPSTR) str,
						"active?:%s\nsource:%s\ntarget:%s\nsize:%u\nconsecutive:%u\niterations:%lu\ntotal bytes:%lu\ntotal time:%lums\nKb/sec:%u",
						activity,
						local_lu,
						fq_remote_lu,
						packet_size, consecutive, total_iterations,
						total_bytes,
						total_time,
						LOWORD (total_bytes / (total_time? total_time : 1)));
					MessageBeep (MB_ICONASTERISK);
					MessageBox (hwnd, str, "ePing Packet Results", MB_OK);
					break;
				}
				case IDM_ITERATIONS_1:		iterations	= 1;		break;
				case IDM_ITERATIONS_2:		iterations	= 2;		break;
				case IDM_ITERATIONS_4:		iterations	= 4;		break;
				case IDM_ITERATIONS_8:		iterations	= 8;		break;
				case IDM_ITERATIONS_16:		iterations	= 16;		break;
				case IDM_ITERATIONS_32:		iterations	= 32;		break;
				case IDM_ITERATIONS_64:		iterations	= 64;		break;
				case IDM_ITERATIONS_128:	iterations	= 128;		break;
				case IDM_ITERATIONS_256:	iterations	= 256;		break;
				case IDM_ITERATIONS_512:	iterations	= 512;		break;
				case IDM_ITERATIONS_1024:	iterations	= 1024;		break;
				case IDM_ITERATIONS_2048:	iterations	= 2048;		break;
				case IDM_ITERATIONS_4096:	iterations	= 4096;		break;
				case IDM_ITERATIONS_8192:	iterations	= 8192;		break;
				case IDM_ITERATIONS_16384:	iterations	= 16384;	break;
				case IDM_ITERATIONS_32768:	iterations	= 32768;	break;
				case IDM_ITERATIONS_EVER:	{
					iterations		= 0xFFFFFFFF;
					iterate_forever	= TRUE;
					break;
				}
				case IDM_PACKET_SIZE_0:		packet_size = 0x00;		break;
				case IDM_PACKET_SIZE_100:	packet_size	= 0x100;	break;
				case IDM_PACKET_SIZE_200:	packet_size	= 0x200;	break;
				case IDM_PACKET_SIZE_400:	packet_size	= 0x400;	break;
				case IDM_PACKET_SIZE_800:	packet_size	= 0x800;	break;
				case IDM_PACKET_SIZE_1000:	packet_size	= 0x1000;	break;
				case IDM_PACKET_SIZE_2000:	packet_size = 0x2000;	break;
				case IDM_PACKET_SIZE_4000:	packet_size = 0x4000;	break;
				case IDM_PACKET_SIZE_8000:	packet_size = 0x7FFB;	break;
				default: ;
			}
			break;
 		}
		case WM_PAINT: {
			PAINTSTRUCT	ps;
			HBRUSH hbr;
			BeginPaint (hwnd, &ps);
			hbr 	= CreateSolidBrush (RGB (0, 200, 255));
			FillRect (ps.hdc, &ps.rcPaint, hbr);
			DeleteObject (hbr);
			TextOut (ps.hdc, 0, 10, app_name, lstrlen (app_name));
			EndPaint (hwnd, &ps);
			break;
		}
		case WM_DESTROY: {      /* message: window being destroyed */
			if (WaitForSingleObject (eping_thread, 0) == WAIT_TIMEOUT) {
				stop_eping = TRUE;
				WaitForSingleObject (eping_thread, 5000);
			}
			PostQuitMessage (0);
			break;
		}
		default:         /* Passes it on if unproccessed    */
			return (DefWindowProc (hwnd, message, wparam, lparam));
	}
	return (DefWindowProc (hwnd, message, wparam, lparam));
}	// end nof_wnd_proc

BOOL initialize_system_menu (
	HMENU	h_sys,
	HMENU	h_options,
	HMENU	h_iterations,
	HMENU	h_packet_size,
	HMENU	h_conv_type,
	HMENU	h_sync_level,
	HMENU	h_help) {
	//
	//		System Menu: insert  
	//			Banner
	//		    EPing Options
	//				start eping
	//				stop eping
	//				set iterations
	//				set packet size
	//				query allocate time
	//				query packet time
	//     		separator
	//		    Help
	//   		Contents
	//       	Index
	//       	How to use Help
	//		    separator
	//   		About
	//    		separator
	//		delete Restore
	//		Move
	//		delete Size
	// 			"  Minimize
	// 			"  Maximize
	//
	// build the sync_level popup
	if (!AppendMenu (
		h_sync_level,
		MF_ENABLED | MF_STRING,
		IDM_SYNC_LEVEL_NONE,
		"None"))
		return FALSE;

	if (!AppendMenu (
		h_sync_level,
		MF_ENABLED | MF_STRING,
		IDM_SYNC_LEVEL_CONFIRM,
		"Confirm"))
		return FALSE;

	//
	// build the conv_type popup
	//
	if (!AppendMenu (
		h_conv_type,
		MF_ENABLED | MF_STRING,
		IDM_CONV_TYPE_BASIC,
		"Basic"))
		return FALSE;

	if (!AppendMenu (
		h_conv_type,
		MF_ENABLED | MF_STRING,
		IDM_CONV_TYPE_MAPPED,
		"Mapped"))
		return FALSE;

	//
	// build the ping-packet_size popup
	//
	if (!AppendMenu (
		h_packet_size,
		MF_ENABLED	| MF_STRING,
		IDM_PACKET_SIZE_0,
		"0x0"))
		return FALSE;

	if (!AppendMenu (
		h_packet_size,
		MF_ENABLED	| MF_STRING,
		IDM_PACKET_SIZE_100,
		"0x100"))
		return FALSE;

	if (!AppendMenu (
		h_packet_size,
		MF_ENABLED	| MF_STRING,
		IDM_PACKET_SIZE_200,
		"0x200"))
		return FALSE;

	if (!AppendMenu (
		h_packet_size,
		MF_ENABLED	| MF_STRING,
		IDM_PACKET_SIZE_400,
		"0x400"))
		return FALSE;

	if (!AppendMenu (
		h_packet_size,
		MF_ENABLED	| MF_STRING,
		IDM_PACKET_SIZE_800,
		"0x800"))
		return FALSE;

	if (!AppendMenu (
		h_packet_size,
		MF_ENABLED	| MF_STRING,
		IDM_PACKET_SIZE_1000,
		"0x1000"))
		return FALSE;

	if (!AppendMenu (
		h_packet_size,
		MF_ENABLED	| MF_STRING,
		IDM_PACKET_SIZE_2000,
		"0x2000"))
		return FALSE;

	if (!AppendMenu (
		h_packet_size,
		MF_ENABLED	| MF_STRING,
		IDM_PACKET_SIZE_4000,
		"0x4000"))
		return FALSE;

	if (!AppendMenu (
		h_packet_size,
		MF_ENABLED	| MF_STRING,
		IDM_PACKET_SIZE_8000,
		"0x8000"))
		return FALSE;

	//
	// build the ping-iterations popup
	//
	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_1,
		"1"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_2,
		"2"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_4,
		"4"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_8,
		"8"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_16,
		"16"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_32,
		"32"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_64,
		"64"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_128,
		"128"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_256,
		"256"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_512,
		"512"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_1024,
		"1024"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_2048,
		"2048"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_4096,
		"4096"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_8192,
		"8192"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_16384,
		"16384"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_32768,
		"32768"))
		return FALSE;

	if (!AppendMenu (
		h_iterations,
		MF_ENABLED	| MF_STRING,
		IDM_ITERATIONS_EVER,
		"&Endless"))
		return FALSE;

	//
	// build the help popup
	//
	if (!AppendMenu (
		h_help,
		MF_ENABLED | MF_STRING,
		IDM_HELPCONTENTS,
		"&Contents"))
		return FALSE;

	if (!AppendMenu (
		h_help,
		MF_ENABLED | MF_STRING,
		IDM_HELPINDEX,
		"&Index"))
		return FALSE;

	if (!AppendMenu (
		h_help,
		MF_ENABLED | MF_STRING,
		IDM_HELPSEARCHFORHELPON,
		"&Search for Help on"))
		return FALSE;

	if (!AppendMenu (
		h_help,
		MF_ENABLED | MF_STRING,
		IDM_HELPHELPMODE,
		"&How to use Help"))
		return FALSE;

	if (!AppendMenu (
		h_help,
		MF_ENABLED | MF_SEPARATOR,
		IDM_SEPARATOR,
		""))
		return FALSE;

	if (!AppendMenu (
		h_help,
		MF_ENABLED | MF_STRING,
		IDM_HELPABOUT,
		"&About ePing"))
		return FALSE;

	//
	// build the options popup
	//
	if (!AppendMenu (
		h_options,
		MF_ENABLED | MF_STRING,
		IDM_SET_REMOTE_LU,
		"Set &Remote LU"))
		return FALSE;

	if (!AppendMenu (
		h_options,
		MF_ENABLED	| MF_POPUP,
		(UINT) h_iterations,
		"Set &Iterations"))
		return FALSE;

	if (!AppendMenu (
		h_options,
		MF_ENABLED | MF_POPUP,
		(UINT) h_packet_size,
		"Set &Packet Size"))
		return FALSE;

	if (!AppendMenu (
		h_options,
		MF_ENABLED | MF_POPUP,
		(UINT) h_conv_type,
		"Set &Conv Type"))
		return FALSE;

	if (!AppendMenu (
		h_options,
		MF_ENABLED | MF_POPUP,
		(UINT) h_sync_level,
		"Set Sync &Level"))
		return FALSE;

	if (!AppendMenu (
		h_options,
		MF_ENABLED | MF_STRING,
		IDM_ALLOCATE_TIME,
		"Query &Allocation Time"))
		return FALSE;

	if (!AppendMenu (
		h_options,
		MF_ENABLED | MF_STRING,
		IDM_PACKET_TIME,
		"Query Packet &Time"))
		return FALSE;

	if (!AppendMenu (
		h_options,
		MF_ENABLED | MF_STRING,
		IDM_REVIEW_PARAMETERS,
		"Review &Settings"))
		return FALSE;

	if (!AppendMenu (
		h_options,
		MF_ENABLED | MF_SEPARATOR,
		IDM_SEPARATOR,
		""))
		return FALSE;

	if (!AppendMenu (
		h_options,
		MF_ENABLED | MF_POPUP,
		(UINT) h_help,
		"&Help"))
		return FALSE;
	//
	// remove restore, size, minimize, maximize from default menu
	//

	//
	// start inserting into the system menu
	//

	if (!InsertMenu (
		h_sys,
		0,
		MF_BYPOSITION | MF_SEPARATOR | MF_ENABLED,
		IDM_SEPARATOR,
		""))
		return FALSE;

	//
	// add the popup to the system menu
	//

	if (!InsertMenu (
		h_sys,
		IDM_SEPARATOR,
		MF_BYCOMMAND | MF_POPUP,
		(UINT) h_options,
		"ePing &Options"))
		return FALSE;

	if (!InsertMenu (
		h_sys,
		0,
		MF_BYPOSITION | MF_ENABLED | MF_STRING,
		IDM_STOP_EPING,
		"Sto&p ePing"))
		return FALSE;

	if (!InsertMenu (
		h_sys,
		0,
		MF_BYPOSITION | MF_ENABLED | MF_STRING,
		IDM_START_EPING,
		"&Start ePing"))
		return FALSE;

	if (!InsertMenu (
		h_sys,
		0,
		MF_BYPOSITION | MF_STRING | MF_ENABLED,
		IDM_BANNER,
		"EhnAPPC APing"))
		return FALSE;

	return TRUE;

	}  // end initialize_system_menu

void system_menu_popup (
	HMENU h_sys) {
	//
	// present Start/Stop APPC choice to the customer
	//
	// if APPC is up, we enable StopAPPC; else we enable
	// StartAPPC
	//
}  // end system_menu_popup

void options_menu_popup (
	HMENU h_options) {
}  // end options_menu_popup 

/*-----------------------------------------------------------------------
 * function	: set_remote_lu
 * filename	: EPING.CPP 			
 * author 		: Gary Rambo							   date : 9/12/97
 * parameters	: 
 * description	: 
 * returns		: 
 * notes		: 
 *-----------------------------------------------------------------------
*/BOOL
set_remote_lu (HWND hwnd) {
	AS400_FullSys	fullsys;
	int				count	= 0;
	char			alias [EHNAPPC_ALIAS_LENGTH+1];
	char			netid [EHNAPPC_NETWORK_LENGTH+1];
	char			sysname [EHNAPPC_SYSNAME_LENGTH+1];
	char			str [80];
	memset (&fullsys, 0, sizeof (fullsys));
	// QueryFullConfiguredSystems could yield systems with no positive
	//	session limits
	EHNAPPC_QueryFullSystems (
		hwnd,
		&count,
		&fullsys);
	if (!count) {
		MessageBox (
			hwnd,
			"no remote lus with positive session limits",
			app_name,
			MB_OK);
		return FALSE;
	}
	for (int u	= 0; u < count; u++) {
		memset (alias, 0, sizeof (alias));
		memset (netid, 0, sizeof (netid));
		memset (sysname, 0, sizeof (sysname));
		memcpy (
			alias, 
			fullsys.FullName [u].EHNAPPC_AliasName, 
			EHNAPPC_ALIAS_LENGTH);
		memcpy (
			netid, 
			fullsys.FullName [u].EHNAPPC_NetworkName, 
			EHNAPPC_NETWORK_LENGTH);
		memcpy (
			sysname, 
			fullsys.FullName [u].EHNAPPC_SysName, 
			EHNAPPC_SYSNAME_LENGTH);
		wsprintf (
			str, "is it alias:%s (%s.%s)?", alias, netid, sysname);
		switch (MessageBox (
					hwnd,
					str,
					"ePing remote lu candidate",
					MB_YESNOCANCEL)) {
			case IDYES:
				// copy new values
				lstrcpy (remote_lu, alias);
				lstrcpy (fq_remote_lu, netid);
				lstrcat (fq_remote_lu, ".");
				lstrcat (fq_remote_lu, sysname);
				// add to window text
				lstrcpy (str, "ePinging ");
				lstrcat (str, remote_lu);
				SetWindowText (hwnd, str);
				return TRUE;
			case IDNO:
				continue;
			case IDCANCEL:
				// keep incoming values, if any
				return (BOOL) remote_lu [0];
		}
	}
	return (BOOL) remote_lu [0];
}	// end set_remote_lu

char	m_tp [65];
/*-----------------------------------------------------------------------
 * function	: start_eping
 * filename	: eping.cpp 			
 * author 		: Gary Rambo							   date : 05/21/95
 * parameters	: 
 * description	: 
 * returns		: 
 * notes		: 
 *		allocate
 *		send data: epingd name, instructions
 *		loop until done:
 *			receive and wait
 *		send data
 *		done
 *-----------------------------------------------------------------------
*/void WINAPI
eping_proc (
	PINGFO*	pingfo) {
	UINT	iterations		= pingfo->iterations;
	UINT	packet_size		= pingfo->packet_size;
	ReturnCode	rc			= EHNAPPC_OK;
	BOOL	success			= FALSE;
	ULONG	conv_id			= 0;
	WORD	len				= 0;
	BYTE	what_received	= 0;
	BYTE	rts_rcvd		= 0;
	UINT	count			= 0;
	ULONG	init_tick		= 0;
	char	mode_name [12];
	char	user_id [12];
	HANDLE	hbuf			= GlobalAlloc (
								GMEM_DDESHARE | GMEM_MOVEABLE | GMEM_ZEROINIT,
								(DWORD) packet_size + 0x100);
	BYTE*	buf				= (BYTE*) GlobalLock (hbuf);
	if (!buf)	goto _failure;
	total_iterations		= 0;
	last_packet_tick		= 0;
	starting_tick			= 0;
	stop_eping				= FALSE;
	if (iterations < 0xFFFFFFFF)
		iterate_forever		= FALSE;
	// 97.09.04: EHNAPPC_IsRouterLoaded() is optional here. E32APPC.DLL may
	//	be calling it for us
	init_tick				= GetTickCount ();
	if (!remote_lu [0]) {
		if (!set_remote_lu (hwnd)) {
			rc =  (ReturnCode) 
					EHNAPPC_GetDefaultSystem (
						hwnd,
						(char*) remote_lu);
			if (!remote_lu [0])
				goto _failure;
			else
				lstrcpy (fq_remote_lu, remote_lu);
		}
	}
	// note: we can also use ExtendedAllocate now, to specify a mode
	lstrcpy (m_tp, "APINGD");
	rc	= (ReturnCode) EHNAPPC_Allocate (
			hwnd,
			0,
			conv_type,
			(SyncLevelEnum) sync_level,
			remote_lu,
			m_tp,
			0,
			NULL,
			&conv_id);
	if (rc != EHNAPPC_OK)
		goto	_failure;
	EHNAPPC_GetAttributes (
		hwnd,
		conv_id,
		&sync_level,
		mode_name,
		local_lu,
		remote_lu,
		user_id);
	// send epingd the curious invariant
	if (conv_type	== EHNAPPC_BASIC) {
		buf [0]	= 0;
		buf [1]	= 7;
		buf [2]	= 0x12;
		buf [3]	= 0xFF;
		buf [4] = 0x01;
		buf [5] = 0x02;
		buf [6] = 0x26;
	}
	else {
		buf [0] = 0x01;
		buf [1] = 0x02;
		buf [2] = 0x26;
	}
	rc	= (ReturnCode) EHNAPPC_SendData (
			hwnd,
			conv_id,
			conv_type == EHNAPPC_BASIC? 7 : 3,
			buf,
			&rts_rcvd);
	if (rc != EHNAPPC_OK)
		goto _failure;
	what_received	= 0;
	while (rc== EHNAPPC_OK 	&&
		   what_received != EHNAPPC_RECEIVEDSEND) {
		rc	= (ReturnCode) EHNAPPC_ReceiveAndWait (
				hwnd,
				conv_id,
				EHNAPPC_LL,
				0x100,		// 0xE is enough
				(BYTE*) buf,
				&what_received,
				&rts_rcvd,
				&len);
		if (rc != EHNAPPC_OK)
			goto	_failure;
	}
	starting_tick			= GetTickCount ();
	allocation_time			= starting_tick - init_tick;
	memset (buf, LOBYTE (LOWORD (starting_tick)), packet_size);
	if (conv_type == EHNAPPC_BASIC) {
		buf [0]	= HIBYTE (packet_size);
		buf [1]	= LOBYTE (packet_size);
		buf [2]	= 0x12;
		buf [3]	= 0xFF;
	}
	// and loop
	for (count = 0; count < iterations && !stop_eping; count++) {
		rc	= (ReturnCode) EHNAPPC_SendData (
				hwnd,
				conv_id,
				packet_size,
				buf,
				&rts_rcvd);
		if (rc != EHNAPPC_OK)
			goto	_failure;
		what_received	= 0;
		// 97.10.03: note we don't yet care whether the data that comes back
		//	is mapped or basic
		while (rc == EHNAPPC_OK	&&
			   what_received != EHNAPPC_RECEIVEDSEND &&
			   what_received != EHNAPPC_RECEIVEDCONFIRMDEALLOC) {
			rc = (ReturnCode) EHNAPPC_ReceiveAndWait (
					hwnd,
					conv_id,
					EHNAPPC_LL,
					packet_size,
					(BYTE*) buf,
					&what_received,
					&rts_rcvd,
					&len);
		}
		total_iterations++;
		if (what_received == EHNAPPC_RECEIVEDCONFIRMDEALLOC) {
			EHNAPPC_Confirmed (hwnd, conv_id);
			goto _success;
		}
		if (rc == EHNAPPC_DEALLOCNORMAL)
			goto	_success;
		else
		if (rc != EHNAPPC_OK)
			goto	_failure;
		if (count == (iterations - 1) && iterate_forever)
			count	= 0;
	}
	_success:
	last_packet_tick	= GetTickCount ();
	success		= TRUE;
	_deallocate:
	if (what_received == EHNAPPC_RECEIVEDCONFIRMDEALLOC ||
		EHNAPPC_QueryConvState (hwnd, conv_id) == EHNAPPC_SEND_STATE)
		rc = (ReturnCode) EHNAPPC_Deallocate (
				hwnd,
				conv_id,
				EHNAPPC_DEALLOCATESYNCLEVEL);
	if (rc == EHNAPPC_OK) {
		conv_id	= 0;
		goto	_return;
	}
	EHNAPPC_Deallocate (
		hwnd,
		conv_id,
		EHNAPPC_DEALLOCATEABEND);
	conv_id	= 0;
	goto	_return;
	_failure:
		success		= FALSE;
		allocation_time	= 0xFFFFFFFF;
		if (conv_id)
			goto	_deallocate;
	_return: {
		if (hbuf) {
			GlobalUnlock (hbuf);
			GlobalFree (hbuf);
			hbuf	= 0;
		}
		if (success)
			SendNotifyMessage (hwnd, WM_SYSCOMMAND, IDM_PACKET_TIME, 1L);
		else {
			MessageBeep (MB_ICONEXCLAMATION);
			MessageBox (hwnd, "ePing failure", app_name, MB_OK);
		}
	}
}	// end start_eping
