/*---------------------------------------------------------------------------*/
/* wincpic.h                                                                 */
/* Copyright WRQ, Inc., 1997                                                 */
/*---------------------------------------------------------------------------*/
/* CPI-Communications constants and function prototypes file                 */
/*---------------------------------------------------------------------------*/

#ifndef CMCH_INCLUDED
#define CMCH_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

/*---------------------------------------------------------------------------*/
/* Ensure the correct packing of structures                                  */
/*---------------------------------------------------------------------------*/
#ifdef WIN32
  #pragma pack(4)
#endif

/*---------------------------------------------------------------------------*/
/* Type Definitions                                                          */
/*---------------------------------------------------------------------------*/

#ifdef WINDOWS
#define WINSNA
#define CM_INT32 signed long int
#define CM_ENTRY extern void pascal far _loadds
#define CM_PTR   far *
#endif

#ifdef WIN32
#define WINSNA
#ifdef SET_UNALIGNED_ACCESS_FOR_THUNK
#define CM_INT32 signed long int UNALIGNED
#else
#define CM_INT32 signed long int
#endif
#define CM_ENTRY extern void WINAPI
#define CM_PTR   *
#define CM_EVENT_HANDLE HANDLE
#endif
#define CPIC_MAX_BUFFER_SIZE     32767
/*---------------------------------------------------------------------------*/
/*  - Base CPI-C constants and type definitions                              */
/*---------------------------------------------------------------------------*/

typedef CM_INT32 CM_AE_QUAL_OR_AP_TITLE_FORMAT; /* used for AE_QUALIFIER_FORMAT */
                                                /* and AP_TITLE_FORMAT          */
typedef CM_INT32 CM_ALLOCATE_CONFIRM_TYPE;
typedef CM_INT32 CM_BEGIN_TRANSACTION;
typedef CM_INT32 CM_BUFFER_LENGTH;
typedef CM_INT32 CM_CALL_ID;
typedef CM_INT32 CM_COMPLETED_OP_COUNT;
typedef CM_INT32 CM_CONFIRMATION_URGENCY;
typedef CM_INT32 CM_CONTEXT_ID_LENGTH;
typedef CM_INT32 CM_CONTROL_INFORMATION_RECEIVED;
typedef CM_INT32 CM_CONVERSATION_QUEUE;
typedef CM_INT32 CM_CONVERSATION_RETURN_CODE;
typedef CM_INT32 CM_CONVERSATION_SECURITY_TYPE;
typedef CM_INT32 CM_CONVERSATION_STATE;
typedef CM_INT32 CM_CONVERSATION_TYPE;
typedef CM_INT32 CM_DATA_RECEIVED_TYPE;
typedef CM_INT32 CM_DEALLOCATE_TYPE;
typedef CM_INT32 CM_DIRECTORY_ENCODING;
typedef CM_INT32 CM_DIRECTORY_SYNTAX;
typedef CM_INT32 CM_ERROR_DIRECTION;
typedef CM_INT32 CM_FILL;
typedef CM_INT32 CM_JOIN_TRANSACTION_TYPE;
typedef CM_INT32 CM_MAP_NAME_LENGTH;
typedef CM_INT32 CM_MAXIMUM_BUFFER_SIZE;
typedef CM_INT32 CM_OOID;
typedef CM_INT32 CM_OOID_LIST_COUNT;
typedef CM_INT32 CM_PARTNER_ID_SCOPE;
typedef CM_INT32 CM_PARTNER_ID_TYPE;
typedef CM_INT32 CM_PREPARE_DATA_PERMITTED_TYPE;
typedef CM_INT32 CM_PREPARE_TO_RECEIVE_TYPE;
typedef CM_INT32 CM_PROCESSING_MODE;    /* also used for queue_processing_mode  */
typedef CM_INT32 CM_RECEIVE_TYPE;       /* also used for expedited_receive_type */
typedef CM_CONTROL_INFORMATION_RECEIVED CM_REQUEST_TO_SEND_RECEIVED;
typedef CM_INT32 CM_RETURN_CODE;
typedef CM_INT32 CM_RETURN_CONTROL;
typedef unsigned char SECURITY_PASSWORD[10];
typedef CM_INT32 CM_SECURITY_PASSWORD_LENGTH;
typedef unsigned char SECURITY_USER_ID[10];
typedef CM_INT32 CM_SECURITY_USER_ID_LENGTH;
typedef CM_INT32 CM_SEND_RECEIVE_MODE;
typedef CM_INT32 CM_SEND_TYPE;
typedef CM_INT32 CM_STATUS_RECEIVED;
typedef CM_INT32 CM_SYNC_LEVEL;
typedef CM_INT32 CM_TIMEOUT;
typedef CM_INT32 CM_TRANSACTION_CONTROL;

/*---------------------------------------------------------------------------*/
/* X/open typedefs for compatibilty                                          */
/*---------------------------------------------------------------------------*/
#if defined(XOPEN_COMPATIBLE)

typedef unsigned char CONVERSATION_ID [8];
typedef CM_INT32 CM_RETCODE;
typedef CM_INT32 CONVERSATION_SECURITY_TYPE;
typedef CM_INT32 CONVERSATION_TYPE;
typedef CM_INT32 DATA_RECEIVED;
typedef CM_INT32 DEALLOCATE_TYPE;
typedef CM_INT32 ERROR_DIRECTION;
typedef CM_INT32 PREPARE_TO_RECEIVE_TYPE;
typedef CM_INT32 PROCESSING_MODE;
typedef CM_INT32 RECEIVE_TYPE;
typedef CM_INT32 REQUEST_TO_SEND_RECEIVED;
typedef CM_INT32 RETURN_CONTROL;
typedef CM_INT32 SEND_TYPE;
typedef CM_INT32 STATUS_RECEIVED;
typedef CM_INT32 SYNC_LEVEL;

#endif

typedef CM_INT32 XC_CONVERSATION_SECURITY_TYPE;
typedef CM_INT32 XC_TP_NAME_TYPE;

/**STRUCT+********************************************************************/
/* Side information struct used by xcmssi to define side information         */
/*---------------------------------------------------------------------------*/
typedef struct side_info_entry
{
  unsigned char   sym_dest_name[8];            /* symbolic destination name  */
  unsigned char   partner_LU_name[17];         /* fully Q'd PLU name         */
  unsigned char   reserved[3];                 /* future expansion ??        */
  XC_TP_NAME_TYPE TP_name_type;                /* set to XC_APPLICATION_TP   */
                                               /*  or to XC_SNA_SERVICE_TP   */
  unsigned char   TP_name[64];                 /* TP name                    */
  unsigned char   mode_name[8];                /* mode name                  */
  XC_CONVERSATION_SECURITY_TYPE
                  conversation_security_type;  /* set to XC_SECURITY_NONE    */
                                               /*  or to XC_SECURITY_SAME    */
                                               /*  or to XC_SECURITY_PROGRAM */
  unsigned char   security_user_ID[8];         /* user_ID                    */
  unsigned char   security_password[8];        /* password                   */
} SIDE_INFO;
/**STRUCT-********************************************************************/


/*---------------------------------------------------------------------------*/
/* Constant Definitions                                                      */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/*  AE_qual_or_AP_title_format values, used for                              */
/*  AE_qualifier_format and AP_title_format parameters                       */
/*---------------------------------------------------------------------------*/

#define CM_DN                            (CM_AE_QUAL_OR_AP_TITLE_FORMAT) 0
#define CM_OID                           (CM_AE_QUAL_OR_AP_TITLE_FORMAT) 1
#define CM_INT_DIGITS                    (CM_AE_QUAL_OR_AP_TITLE_FORMAT) 2


/*---------------------------------------------------------------------------*/
/*  allocate_confirm values                                                  */
/*---------------------------------------------------------------------------*/

#define CM_ALLOCATE_NO_CONFIRM           (CM_ALLOCATE_CONFIRM_TYPE) 0
#define CM_ALLOCATE_CONFIRM              (CM_ALLOCATE_CONFIRM_TYPE) 1


/*---------------------------------------------------------------------------*/
/*  begin_transaction values                                                 */
/*---------------------------------------------------------------------------*/

#define CM_BEGIN_IMPLICIT                (CM_BEGIN_TRANSACTION) 0
#define CM_BEGIN_EXPLICIT                (CM_BEGIN_TRANSACTION) 1


/*---------------------------------------------------------------------------*/
/*  call_ID values                                                           */
/*---------------------------------------------------------------------------*/

#define CM_CMACCI                        (CM_CALL_ID) 1
#define CM_CMACCP                        (CM_CALL_ID) 2
#define CM_CMALLC                        (CM_CALL_ID) 3
#define CM_CMCANC                        (CM_CALL_ID) 4
#define CM_CMCFM                         (CM_CALL_ID) 5
#define CM_CMCFMD                        (CM_CALL_ID) 6
#define CM_CMCNVI                        (CM_CALL_ID) 7
#define CM_CMCNVO                        (CM_CALL_ID) 8
#define CM_CMDEAL                        (CM_CALL_ID) 9
#define CM_CMDFDE                        (CM_CALL_ID) 10
#define CM_CMEACN                        (CM_CALL_ID) 11
#define CM_CMEAEQ                        (CM_CALL_ID) 12
#define CM_CMEAPT                        (CM_CALL_ID) 13
#define CM_CMECS                         (CM_CALL_ID) 14
#define CM_CMECT                         (CM_CALL_ID) 15
#define CM_CMECTX                        (CM_CALL_ID) 16
#define CM_CMEID                         (CM_CALL_ID) 17
#define CM_CMEMBS                        (CM_CALL_ID) 18
#define CM_CMEMN                         (CM_CALL_ID) 19
#define CM_CMEPID                        (CM_CALL_ID) 20
#define CM_CMEPLN                        (CM_CALL_ID) 21
#define CM_CMESI                         (CM_CALL_ID) 22
#define CM_CMESL                         (CM_CALL_ID) 23
#define CM_CMESRM                        (CM_CALL_ID) 24
#define CM_CMESUI                        (CM_CALL_ID) 25
#define CM_CMETC                         (CM_CALL_ID) 26
#define CM_CMETPN                        (CM_CALL_ID) 27
#define CM_CMFLUS                        (CM_CALL_ID) 28
#define CM_CMINCL                        (CM_CALL_ID) 29
#define CM_CMINIC                        (CM_CALL_ID) 30
#define CM_CMINIT                        (CM_CALL_ID) 31
#define CM_CMPREP                        (CM_CALL_ID) 32
#define CM_CMPTR                         (CM_CALL_ID) 33
#define CM_CMRCV                         (CM_CALL_ID) 34
#define CM_CMRCVX                        (CM_CALL_ID) 35
#define CM_CMRLTP                        (CM_CALL_ID) 36
#define CM_CMRTS                         (CM_CALL_ID) 37
#define CM_CMSAC                         (CM_CALL_ID) 38
#define CM_CMSACN                        (CM_CALL_ID) 39
#define CM_CMSAEQ                        (CM_CALL_ID) 40
#define CM_CMSAPT                        (CM_CALL_ID) 41
#define CM_CMSBT                         (CM_CALL_ID) 42
#define CM_CMSCSP                        (CM_CALL_ID) 43
#define CM_CMSCST                        (CM_CALL_ID) 44
#define CM_CMSCSU                        (CM_CALL_ID) 45
#define CM_CMSCT                         (CM_CALL_ID) 46
#define CM_CMSCU                         (CM_CALL_ID) 47
#define CM_CMSDT                         (CM_CALL_ID) 48
#define CM_CMSED                         (CM_CALL_ID) 49
#define CM_CMSEND                        (CM_CALL_ID) 50
#define CM_CMSERR                        (CM_CALL_ID) 51
#define CM_CMSF                          (CM_CALL_ID) 52
#define CM_CMSID                         (CM_CALL_ID) 53
#define CM_CMSLD                         (CM_CALL_ID) 54
#define CM_CMSLTP                        (CM_CALL_ID) 55
#define CM_CMSMN                         (CM_CALL_ID) 56
#define CM_CMSNDX                        (CM_CALL_ID) 57
#define CM_CMSPDP                        (CM_CALL_ID) 58
#define CM_CMSPID                        (CM_CALL_ID) 59
#define CM_CMSPLN                        (CM_CALL_ID) 60
#define CM_CMSPM                         (CM_CALL_ID) 61
#define CM_CMSPTR                        (CM_CALL_ID) 62
#define CM_CMSQCF                        (CM_CALL_ID) 63
#define CM_CMSQPM                        (CM_CALL_ID) 64
#define CM_CMSRC                         (CM_CALL_ID) 65
#define CM_CMSRT                         (CM_CALL_ID) 66
#define CM_CMSSL                         (CM_CALL_ID) 67
#define CM_CMSSRM                        (CM_CALL_ID) 68
#define CM_CMSST                         (CM_CALL_ID) 69
#define CM_CMSTC                         (CM_CALL_ID) 70
#define CM_CMSTPN                        (CM_CALL_ID) 71
#define CM_CMTRTS                        (CM_CALL_ID) 72
#define CM_CMWAIT                        (CM_CALL_ID) 73
#define CM_CMWCMP                        (CM_CALL_ID) 74
#define CM_CMSJT                         (CM_CALL_ID) 75
#define CM_CMEMID                        (CM_CALL_ID) 76
#define CM_CMSMID                        (CM_CALL_ID) 77
#define CM_CMSNDM                        (CM_CALL_ID) 78
#define CM_CMRCVM                        (CM_CALL_ID) 79
#define RW_XCMDSI                        (CM_CALL_ID) 100
#define RW_XCMESI                        (CM_CALL_ID) 101
#define RW_XCMSSI                        (CM_CALL_ID) 102
#define RW_XCECST                        (CM_CALL_ID) 103
#define RW_XCECSU                        (CM_CALL_ID) 104
#define RW_XCSCSP                        (CM_CALL_ID) 105
#define RW_XCSCST                        (CM_CALL_ID) 106
#define RW_XCSCSU                        (CM_CALL_ID) 107
#define RW_CMECST                        (CM_CALL_ID) 108
#define RW_CMECSU                        (CM_CALL_ID) 109
#define RW_XCHWND                        (CM_CALL_ID) 110
#define RW_WINCPICCLEANUP                (CM_CALL_ID) 111
#define RW_WINCPICISBLOCKING             (CM_CALL_ID) 112
#define RW_WINCPICSTARTUP                (CM_CALL_ID) 113
#define RW_WINCPICSETBLOCKINGHOOK        (CM_CALL_ID) 114
#define RW_WINCPICUNHOOKBLOCKINGHOOK     (CM_CALL_ID) 115
#define RW_WINCPICSETEVENT               (CM_CALL_ID) 116
#define RW_WINCPICEXTRACTEVENT           (CM_CALL_ID) 117


/*---------------------------------------------------------------------------*/
/*  confirmation_urgency values                                              */
/*---------------------------------------------------------------------------*/

#define CM_CONFIRMATION_NOT_URGENT       (CM_CONFIRMATION_URGENCY) 0
#define CM_CONFIRMATION_URGENT           (CM_CONFIRMATION_URGENCY) 1


/*---------------------------------------------------------------------------*/
/*  control_information_received, request_to_send_received values            */
/*  control_information_received is a superset of the old                    */
/*  request_to_send_received parameter.                                      */
/*---------------------------------------------------------------------------*/

#define CM_NO_CONTROL_INFO_RECEIVED      (CM_CONTROL_INFORMATION_RECEIVED)  0
#define CM_REQ_TO_SEND_NOT_RECEIVED      (CM_CONTROL_INFORMATION_RECEIVED)  0
#define CM_REQ_TO_SEND_RECEIVED          (CM_CONTROL_INFORMATION_RECEIVED)  1
#define CM_ALLOCATE_CONFIRMED            (CM_CONTROL_INFORMATION_RECEIVED)  2
#define CM_ALLOCATE_CONFIRMED_WITH_DATA  (CM_CONTROL_INFORMATION_RECEIVED)  3
#define CM_ALLOCATE_REJECTED_WITH_DATA   (CM_CONTROL_INFORMATION_RECEIVED)  4
#define CM_EXPEDITED_DATA_AVAILABLE      (CM_CONTROL_INFORMATION_RECEIVED)  5
#define CM_RTS_RCVD_AND_EXP_DATA_AVAIL   (CM_CONTROL_INFORMATION_RECEIVED)  6


/*---------------------------------------------------------------------------*/
/*  conversation_queue values                                                */
/*---------------------------------------------------------------------------*/

#define CM_INITIALIZATION_QUEUE          (CM_CONVERSATION_QUEUE) 0
#define CM_SEND_QUEUE                    (CM_CONVERSATION_QUEUE) 1
#define CM_RECEIVE_QUEUE                 (CM_CONVERSATION_QUEUE) 2
#define CM_SEND_RECEIVE_QUEUE            (CM_CONVERSATION_QUEUE) 3
#define CM_EXPEDITED_SEND_QUEUE          (CM_CONVERSATION_QUEUE) 4
#define CM_EXPEDITED_RECEIVE_QUEUE       (CM_CONVERSATION_QUEUE) 5


/*---------------------------------------------------------------------------*/
/*  conversation_state values                                                */
/*---------------------------------------------------------------------------*/

#define CM_INITIALIZE_STATE              (CM_CONVERSATION_STATE) 2
#define CM_SEND_STATE                    (CM_CONVERSATION_STATE) 3
#define CM_RECEIVE_STATE                 (CM_CONVERSATION_STATE) 4
#define CM_SEND_PENDING_STATE            (CM_CONVERSATION_STATE) 5
#define CM_CONFIRM_STATE                 (CM_CONVERSATION_STATE) 6
#define CM_CONFIRM_SEND_STATE            (CM_CONVERSATION_STATE) 7
#define CM_CONFIRM_DEALLOCATE_STATE      (CM_CONVERSATION_STATE) 8
#define CM_DEFER_RECEIVE_STATE           (CM_CONVERSATION_STATE) 9
#define CM_DEFER_DEALLOCATE_STATE        (CM_CONVERSATION_STATE) 10
#define CM_SYNC_POINT_STATE              (CM_CONVERSATION_STATE) 11
#define CM_SYNC_POINT_SEND_STATE         (CM_CONVERSATION_STATE) 12
#define CM_SYNC_POINT_DEALLOCATE_STATE   (CM_CONVERSATION_STATE) 13
#define CM_INITIALIZE_INCOMING_STATE     (CM_CONVERSATION_STATE) 14
#define CM_SEND_ONLY_STATE               (CM_CONVERSATION_STATE) 15
#define CM_RECEIVE_ONLY_STATE            (CM_CONVERSATION_STATE) 16
#define CM_SEND_RECEIVE_STATE            (CM_CONVERSATION_STATE) 17
#define CM_PREPARED_STATE                (CM_CONVERSATION_STATE) 18


/*---------------------------------------------------------------------------*/
/*  conversation_type values                                                 */
/*---------------------------------------------------------------------------*/

#define CM_BASIC_CONVERSATION            (CM_CONVERSATION_TYPE) 0
#define CM_MAPPED_CONVERSATION           (CM_CONVERSATION_TYPE) 1


/*---------------------------------------------------------------------------*/
/*  data_received values                                                     */
/*---------------------------------------------------------------------------*/

#define CM_NO_DATA_RECEIVED              (CM_DATA_RECEIVED_TYPE) 0
#define CM_DATA_RECEIVED                 (CM_DATA_RECEIVED_TYPE) 1
#define CM_COMPLETE_DATA_RECEIVED        (CM_DATA_RECEIVED_TYPE) 2
#define CM_INCOMPLETE_DATA_RECEIVED      (CM_DATA_RECEIVED_TYPE) 3


/*---------------------------------------------------------------------------*/
/*  deallocate_type values                                                   */
/*---------------------------------------------------------------------------*/

#define CM_DEALLOCATE_SYNC_LEVEL         (CM_DEALLOCATE_TYPE) 0
#define CM_DEALLOCATE_FLUSH              (CM_DEALLOCATE_TYPE) 1
#define CM_DEALLOCATE_CONFIRM            (CM_DEALLOCATE_TYPE) 2
#define CM_DEALLOCATE_ABEND              (CM_DEALLOCATE_TYPE) 3


/*---------------------------------------------------------------------------*/
/*  directory_encoding values                                                */
/*---------------------------------------------------------------------------*/

#define CM_DEFAULT_ENCODING              (CM_DIRECTORY_ENCODING) 0
#define CM_UNICODE_ENCODING              (CM_DIRECTORY_ENCODING) 1


/*---------------------------------------------------------------------------*/
/*  directory_syntax values                                                  */
/*---------------------------------------------------------------------------*/

#define CM_DEFAULT_SYNTAX                (CM_DIRECTORY_SYNTAX) 0
#define CM_DCE_SYNTAX                    (CM_DIRECTORY_SYNTAX) 1
#define CM_XDS_SYNTAX                    (CM_DIRECTORY_SYNTAX) 2
#define CM_NDS_SYNTAX                    (CM_DIRECTORY_SYNTAX) 3


/*---------------------------------------------------------------------------*/
/*  error_direction values                                                   */
/*---------------------------------------------------------------------------*/

#define CM_RECEIVE_ERROR                 (CM_ERROR_DIRECTION) 0
#define CM_SEND_ERROR                    (CM_ERROR_DIRECTION) 1


/*---------------------------------------------------------------------------*/
/*  fill values  */
/*---------------------------------------------------------------------------*/

#define CM_FILL_LL                       (CM_FILL) 0
#define CM_FILL_BUFFER                   (CM_FILL) 1


/*---------------------------------------------------------------------------*/
/*  join transaction values  */
/*---------------------------------------------------------------------------*/

#define CM_JOIN_IMPLICIT                 (CM_JOIN_TRANSACTION_TYPE) 0
#define CM_JOIN_EXPLICIT                 (CM_JOIN_TRANSACTION_TYPE) 1


/*---------------------------------------------------------------------------*/
/*  partner_ID_scope values */
/*---------------------------------------------------------------------------*/

#define CM_EXPLICIT                      (CM_PARTNER_ID_SCOPE) 0
#define CM_REFERENCE                     (CM_PARTNER_ID_SCOPE) 1


/*---------------------------------------------------------------------------*/
/*  partner_ID_type values */
/*---------------------------------------------------------------------------*/

#define CM_DISTINGUISHED_NAME            (CM_PARTNER_ID_TYPE) 0
#define CM_LOCAL_DISTINGUISHED_NAME      (CM_PARTNER_ID_TYPE) 1
#define CM_PROGRAM_FUNCTION_ID           (CM_PARTNER_ID_TYPE) 2
#define CM_OSI_TPSU_TITLE_OID            (CM_PARTNER_ID_TYPE) 3
#define CM_PROGRAM_BINDING               (CM_PARTNER_ID_TYPE) 4


/*---------------------------------------------------------------------------*/
/*  prepare_data_permitted values  */
/*---------------------------------------------------------------------------*/

#define CM_PREPARE_DATA_NOT_PERMITTED    (CM_PREPARE_DATA_PERMITTED_TYPE) 0
#define CM_PREPARE_DATA_PERMITTED        (CM_PREPARE_DATA_PERMITTED_TYPE) 1


/*---------------------------------------------------------------------------*/
/*  prepare_to_receive_type values  */
/*---------------------------------------------------------------------------*/

#define CM_PREP_TO_RECEIVE_SYNC_LEVEL    (CM_PREPARE_TO_RECEIVE_TYPE) 0
#define CM_PREP_TO_RECEIVE_FLUSH         (CM_PREPARE_TO_RECEIVE_TYPE) 1
#define CM_PREP_TO_RECEIVE_CONFIRM       (CM_PREPARE_TO_RECEIVE_TYPE) 2


/*---------------------------------------------------------------------------*/
/*  processing_mode values  */
/*---------------------------------------------------------------------------*/

#define CM_BLOCKING                      (CM_PROCESSING_MODE) 0
#define CM_NON_BLOCKING                  (CM_PROCESSING_MODE) 1


/*---------------------------------------------------------------------------*/
/*  receive_type values  */
/*---------------------------------------------------------------------------*/

#define CM_RECEIVE_AND_WAIT              (CM_RECEIVE_TYPE) 0
#define CM_RECEIVE_IMMEDIATE             (CM_RECEIVE_TYPE) 1


/*---------------------------------------------------------------------------*/
/*  return_code values  */
/*---------------------------------------------------------------------------*/

#define CM_OK                            (CM_RETURN_CODE) 0
#define CM_ALLOCATE_FAILURE_NO_RETRY     (CM_RETURN_CODE) 1
#define CM_ALLOCATE_FAILURE_RETRY        (CM_RETURN_CODE) 2
#define CM_CONVERSATION_TYPE_MISMATCH    (CM_RETURN_CODE) 3
#define CM_PIP_NOT_SPECIFIED_CORRECTLY   (CM_RETURN_CODE) 5
#define CM_SECURITY_NOT_VALID            (CM_RETURN_CODE) 6
#define CM_SYNC_LVL_NOT_SUPPORTED_LU     (CM_RETURN_CODE) 7
#define CM_SYNC_LVL_NOT_SUPPORTED_SYS    (CM_RETURN_CODE) 7    /* CPIC 2.0 */
#define CM_SYNC_LVL_NOT_SUPPORTED_PGM    (CM_RETURN_CODE) 8
#define CM_TPN_NOT_RECOGNIZED            (CM_RETURN_CODE) 9
#define CM_TP_NOT_AVAILABLE_NO_RETRY     (CM_RETURN_CODE) 10
#define CM_TP_NOT_AVAILABLE_RETRY        (CM_RETURN_CODE) 11
#define CM_DEALLOCATED_ABEND             (CM_RETURN_CODE) 17
#define CM_DEALLOCATED_NORMAL            (CM_RETURN_CODE) 18
#define CM_PARAMETER_ERROR               (CM_RETURN_CODE) 19
#define CM_PRODUCT_SPECIFIC_ERROR        (CM_RETURN_CODE) 20
#define CM_PROGRAM_ERROR_NO_TRUNC        (CM_RETURN_CODE) 21
#define CM_PROGRAM_ERROR_PURGING         (CM_RETURN_CODE) 22
#define CM_PROGRAM_ERROR_TRUNC           (CM_RETURN_CODE) 23
#define CM_PROGRAM_PARAMETER_CHECK       (CM_RETURN_CODE) 24
#define CM_PROGRAM_STATE_CHECK           (CM_RETURN_CODE) 25
#define CM_RESOURCE_FAILURE_NO_RETRY     (CM_RETURN_CODE) 26
#define CM_RESOURCE_FAILURE_RETRY        (CM_RETURN_CODE) 27
#define CM_UNSUCCESSFUL                  (CM_RETURN_CODE) 28
#define CM_DEALLOCATED_ABEND_SVC         (CM_RETURN_CODE) 30
#define CM_DEALLOCATED_ABEND_TIMER       (CM_RETURN_CODE) 31
#define CM_SVC_ERROR_NO_TRUNC            (CM_RETURN_CODE) 32
#define CM_SVC_ERROR_PURGING             (CM_RETURN_CODE) 33
#define CM_SVC_ERROR_TRUNC               (CM_RETURN_CODE) 34
#define CM_OPERATION_INCOMPLETE          (CM_RETURN_CODE) 35   /* CPIC 1.2 */
#define CM_SYSTEM_EVENT                  (CM_RETURN_CODE) 36   /* CPIC 1.2 */
#define CM_OPERATION_NOT_ACCEPTED        (CM_RETURN_CODE) 37   /* CPIC 1.2 */
#define CM_CONVERSATION_ENDING           (CM_RETURN_CODE) 38   /* CPIC 2.0 */
#define CM_SEND_RCV_MODE_NOT_SUPPORTED   (CM_RETURN_CODE) 39   /* CPIC 2.0 */
#define CM_BUFFER_TOO_SMALL              (CM_RETURN_CODE) 40   /* CPIC 2.0 */
#define CM_EXP_DATA_NOT_SUPPORTED        (CM_RETURN_CODE) 41   /* CPIC 2.0 */
#define CM_DEALLOC_CONFIRM_REJECT        (CM_RETURN_CODE) 42   /* CPIC 2.0 */
#define CM_ALLOCATION_ERROR              (CM_RETURN_CODE) 43   /* CPIC 2.0 */
#define CM_RETRY_LIMIT_EXCEEDED          (CM_RETURN_CODE) 44   /* CPIC 2.0 */
#define CM_NO_SECONDARY_INFORMATION      (CM_RETURN_CODE) 45   /* CPIC 2.0 */
#define CM_SECURITY_NOT_SUPPORTED        (CM_RETURN_CODE) 46   /* CPIC 2.0 */
#define CM_SECURITY_MUTUAL_FAILED        (CM_RETURN_CODE) 47   /* CPIC 2.0 */
#define CM_CALL_NOT_SUPPORTED            (CM_RETURN_CODE) 48   /* CPIC 2.0 */
#define CM_PARM_VALUE_NOT_SUPPORTED      (CM_RETURN_CODE) 49   /* CPIC 2.0 */
#define CM_UNKNOWN_MAP_NAME_REQUESTED    (CM_RETURN_CODE) 50   /* CPIC 2.1 */
#define CM_UNKNOWN_MAP_NAME_RECEIVED     (CM_RETURN_CODE) 51   /* CPIC 2.1 */
#define CM_MAP_ROUTINE_ERROR             (CM_RETURN_CODE) 52   /* CPIC 2.1 */
#define CM_CONVERSATION_CANCELLED        (CM_RETURN_CODE) 53   /* CPIC 2.1 */
#define CM_TAKE_BACKOUT                  (CM_RETURN_CODE) 100
#define CM_DEALLOCATED_ABEND_BO          (CM_RETURN_CODE) 130
#define CM_DEALLOCATED_ABEND_SVC_BO      (CM_RETURN_CODE) 131
#define CM_DEALLOCATED_ABEND_TIMER_BO    (CM_RETURN_CODE) 132
#define CM_RESOURCE_FAIL_NO_RETRY_BO     (CM_RETURN_CODE) 133
#define CM_RESOURCE_FAILURE_RETRY_BO     (CM_RETURN_CODE) 134
#define CM_DEALLOCATED_NORMAL_BO         (CM_RETURN_CODE) 135
#define CM_CONV_DEALLOC_AFTER_SYNCPT     (CM_RETURN_CODE) 136  /* CPIC 2.0 */
#define CM_INCLUDE_PARTNER_REJECT_BO     (CM_RETURN_CODE) 137  /* CPIC 2.0 */


/*---------------------------------------------------------------------------*/
/*  return_control values  */
/*---------------------------------------------------------------------------*/

#define CM_WHEN_SESSION_ALLOCATED        (CM_RETURN_CONTROL) 0
#define CM_IMMEDIATE                     (CM_RETURN_CONTROL) 1
#define CM_WHEN_CONWINNER_ALLOCATED      (CM_RETURN_CONTROL) 2
#define CM_WHEN_SESSION_FREE             (CM_RETURN_CONTROL) 3


/*---------------------------------------------------------------------------*/
/*  send_receive_mode values  */
/*---------------------------------------------------------------------------*/

#define CM_HALF_DUPLEX                   (CM_SEND_RECEIVE_MODE) 0
#define CM_FULL_DUPLEX                   (CM_SEND_RECEIVE_MODE) 1


/*---------------------------------------------------------------------------*/
/*  send_type values  */
/*---------------------------------------------------------------------------*/

#define CM_BUFFER_DATA                   (CM_SEND_TYPE) 0
#define CM_SEND_AND_FLUSH                (CM_SEND_TYPE) 1
#define CM_SEND_AND_CONFIRM              (CM_SEND_TYPE) 2
#define CM_SEND_AND_PREP_TO_RECEIVE      (CM_SEND_TYPE) 3
#define CM_SEND_AND_DEALLOCATE           (CM_SEND_TYPE) 4


/*---------------------------------------------------------------------------*/
/*  status_received values  */
/*---------------------------------------------------------------------------*/

#define CM_NO_STATUS_RECEIVED            (CM_STATUS_RECEIVED) 0
#define CM_SEND_RECEIVED                 (CM_STATUS_RECEIVED) 1
#define CM_CONFIRM_RECEIVED              (CM_STATUS_RECEIVED) 2
#define CM_CONFIRM_SEND_RECEIVED         (CM_STATUS_RECEIVED) 3
#define CM_CONFIRM_DEALLOC_RECEIVED      (CM_STATUS_RECEIVED) 4
#define CM_TAKE_COMMIT                   (CM_STATUS_RECEIVED) 5
#define CM_TAKE_COMMIT_SEND              (CM_STATUS_RECEIVED) 6
#define CM_TAKE_COMMIT_DEALLOCATE        (CM_STATUS_RECEIVED) 7
#define CM_TAKE_COMMIT_DATA_OK           (CM_STATUS_RECEIVED) 8
#define CM_TAKE_COMMIT_SEND_DATA_OK      (CM_STATUS_RECEIVED) 9
#define CM_TAKE_COMMIT_DEALLOC_DATA_OK   (CM_STATUS_RECEIVED) 10
#define CM_PREPARE_OK                    (CM_STATUS_RECEIVED) 11
#define CM_JOIN_TRANSACTION              (CM_STATUS_RECEIVED) 12


/*---------------------------------------------------------------------------*/
/* sync_level values  */
/*---------------------------------------------------------------------------*/

#ifdef CM_NONE		//	name collision with WinGDI.h
#undef CM_NONE
#endif

#define CM_NONE                          (CM_SYNC_LEVEL) 0
#define CM_CONFIRM                       (CM_SYNC_LEVEL) 1
#define CM_SYNC_POINT                    (CM_SYNC_LEVEL) 2
#define CM_SYNC_POINT_NO_CONFIRM         (CM_SYNC_LEVEL) 3

/*---------------------------------------------------------------------------*/
/* conversation_security_type values */
/*---------------------------------------------------------------------------*/

#define CM_SECURITY_NONE                 (CM_CONVERSATION_SECURITY_TYPE) 0
#define CM_SECURITY_SAME                 (CM_CONVERSATION_SECURITY_TYPE) 1
#define CM_SECURITY_PROGRAM              (CM_CONVERSATION_SECURITY_TYPE) 2
#define CM_SECURITY_DISTRIBUTED          (CM_CONVERSATION_SECURITY_TYPE) 3
#define CM_SECURITY_MUTUAL               (CM_CONVERSATION_SECURITY_TYPE) 4
#define CM_SECURITY_PROGRAM_STRONG       (CM_CONVERSATION_SECURITY_TYPE) 5

/*---------------------------------------------------------------------------*/
/* transaction_control values */
/*---------------------------------------------------------------------------*/

#define CM_CHAINED_TRANSACTIONS          (CM_TRANSACTION_CONTROL) 0
#define CM_UNCHAINED_TRANSACTIONS        (CM_TRANSACTION_CONTROL) 1


/*---------------------------------------------------------------------------*/
/* maximum sizes of strings and buffers */
/*---------------------------------------------------------------------------*/

#define CM_CID_SIZE   (8)         /* conversation ID           */
#define CM_CTX_SIZE   (32)        /* context ID                */
#define CM_LD_SIZE    (512)       /* log data                  */
#define CM_MAP_SIZE   (64)        /* map name                  */
#define CM_MN_SIZE    (8)         /* mode name                 */
#define CM_PLN_SIZE   (17)        /* partner LU name           */
#define CM_PW_SIZE    (10)        /* password                  */
#define CM_SDN_SIZE   (8)         /* symbolic destination name */
#define CM_TPN_SIZE   (64)        /* TP name                   */
#define CM_UID_SIZE   (10)        /* userid ID                 */


/*---------------------------------------------------------------------------*/
/* Values for the conversation_security_type (NS/2 compatible)               */
/*---------------------------------------------------------------------------*/
#define XC_SECURITY_NONE     (XC_CONVERSATION_SECURITY_TYPE) 0
#define XC_SECURITY_SAME     (XC_CONVERSATION_SECURITY_TYPE) 1
#define XC_SECURITY_PROGRAM  (XC_CONVERSATION_SECURITY_TYPE) 2


/*---------------------------------------------------------------------------*/
/* Values for the TP_name_type (NS/2 compatible)                             */
/*---------------------------------------------------------------------------*/
#define XC_APPLICATION_TP  (XC_TP_NAME_TYPE) 0
#define XC_SNA_SERVICE_TP  (XC_TP_NAME_TYPE) 1


/*---------------------------------------------------------------------------*/
/* Function prototypes for CPIC call routines                                */
/*---------------------------------------------------------------------------*/

CM_ENTRY cmacci(unsigned char CM_PTR,              /* conversation_ID         */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmaccp(unsigned char CM_PTR,              /* conversation_ID         */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmallc(unsigned char CM_PTR,              /* conversation_ID         */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmcanc(unsigned char CM_PTR,              /* conversation_ID         */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmcfm( unsigned char CM_PTR,              /* conversation_ID         */
                CM_CONTROL_INFORMATION_RECEIVED CM_PTR,
                                              /* control_information_received */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmcfmd(unsigned char CM_PTR,              /* conversation_ID         */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmcnvi(unsigned char CM_PTR,              /* buffer                  */
                CM_INT32 CM_PTR,                   /* buffer_length           */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmcnvo(unsigned char CM_PTR,              /* buffer                  */
                CM_INT32 CM_PTR,                   /* buffer_length           */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmdeal(unsigned char CM_PTR,              /* conversation_ID         */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmdfde(unsigned char CM_PTR,              /* conversation_ID         */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmeaeq(unsigned char CM_PTR,              /* conversation_ID         */
                unsigned char CM_PTR,              /* AE_qualifier            */
                CM_INT32 CM_PTR,                   /* AE_qualifier_length     */
                CM_AE_QUAL_OR_AP_TITLE_FORMAT CM_PTR,
                                                   /* AE_qualifier format     */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmeapt(unsigned char CM_PTR,              /* conversation_ID         */
                unsigned char CM_PTR,              /* AP_title                */
                CM_INT32 CM_PTR,                   /* AP_title length         */
                CM_AE_QUAL_OR_AP_TITLE_FORMAT CM_PTR,
                                                   /* AP_title format         */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmeacn(unsigned char CM_PTR,              /* conversation_ID         */
                unsigned char CM_PTR,              /* application_context_name*/
                CM_INT32 CM_PTR,                   /* appl_context_name_length*/
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmecs( unsigned char CM_PTR,              /* conversation_ID         */
                CM_CONVERSATION_STATE CM_PTR,      /* conversation_state      */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmect( unsigned char CM_PTR,              /* conversation_ID         */
                CM_CONVERSATION_TYPE CM_PTR,       /* conversation_type       */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmectx(unsigned char CM_PTR,              /* conversation_ID         */
                unsigned char CM_PTR,              /* context_ID              */
                CM_CONTEXT_ID_LENGTH CM_PTR,       /* context_ID_length       */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmeid( unsigned char CM_PTR,              /* conversation_ID         */
                unsigned char CM_PTR,              /* initialization_data     */
                CM_INT32 CM_PTR,                   /* requested_length        */
                CM_INT32 CM_PTR,                   /* initialization_data_leng*/
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmembs(CM_INT32 CM_PTR,                   /* maximum_buffer_size     */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmemid(unsigned char CM_PTR,              /* conversation_ID         */
                unsigned char CM_PTR,              /* local map name          */
                CM_MAP_NAME_LENGTH CM_PTR,         /* map_name_length         */
                unsigned char CM_PTR,              /* initialization_data     */
                CM_INT32 CM_PTR,                   /* requested_length        */
                CM_INT32 CM_PTR,                   /* initial_data_length     */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmemn( unsigned char CM_PTR,              /* conversation_ID         */
                unsigned char CM_PTR,              /* mode_name               */
                CM_INT32 CM_PTR,                   /* mode_name_length        */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmepid(unsigned char CM_PTR,              /* conversation_ID         */
                CM_PARTNER_ID_TYPE CM_PTR,         /* partner_ID_type         */
                unsigned char CM_PTR,              /* partner_ID              */
                CM_INT32 CM_PTR,                   /* requested_length        */
                CM_INT32 CM_PTR,                   /* partner_ID_length       */
                CM_PARTNER_ID_SCOPE CM_PTR,        /* partner_ID_scope        */
                CM_DIRECTORY_SYNTAX CM_PTR,        /* directory_syntax        */
                CM_DIRECTORY_ENCODING CM_PTR,      /* directory_encoding      */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmepln(unsigned char CM_PTR,              /* conversation_ID         */
                unsigned char CM_PTR,              /* partner_LU_name         */
                CM_INT32 CM_PTR,                   /* partner_LU_name_length  */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmesi( unsigned char CM_PTR,              /* conversation_ID         */
                CM_INT32 CM_PTR,                   /* call_ID                 */
                unsigned char CM_PTR,              /* buffer                  */
                CM_INT32 CM_PTR,                   /* requested_length        */
                CM_DATA_RECEIVED_TYPE CM_PTR,      /* data_received           */
                CM_INT32 CM_PTR,                   /* received_length         */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmesl( unsigned char CM_PTR,              /* conversation_ID         */
                CM_SYNC_LEVEL CM_PTR,              /* sync_level              */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmesrm(unsigned char CM_PTR,              /* conversation_ID         */
                CM_SEND_RECEIVE_MODE CM_PTR,       /* send_receive_mode       */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmesui(unsigned char  CM_PTR,             /* conversation_ID         */
                unsigned char  CM_PTR,             /* user_ID                 */
                CM_INT32 CM_PTR,                   /* user_ID_length          */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmetc( unsigned char CM_PTR,              /* conversation_ID         */
                CM_TRANSACTION_CONTROL CM_PTR,     /* transaction_control     */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmetpn(unsigned char CM_PTR,              /* conversation_ID         */
                unsigned char CM_PTR,              /* TP_name                 */
                CM_INT32 CM_PTR,                   /* TP_name_length          */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmflus(unsigned char CM_PTR,              /* conversation_ID         */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmincl(unsigned char CM_PTR,              /* conversation_ID         */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cminic(unsigned char CM_PTR,              /* conversation_ID         */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cminit(unsigned char CM_PTR,              /* conversation_ID         */
                unsigned char CM_PTR,              /* sym_dest_name           */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmprep(unsigned char CM_PTR,              /* conversation_ID         */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmptr( unsigned char CM_PTR,              /* conversation_ID         */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmrcv( unsigned char CM_PTR,              /* conversation_ID         */
                unsigned char CM_PTR,              /* buffer                  */
                CM_INT32 CM_PTR,                   /* requested_length        */
                CM_DATA_RECEIVED_TYPE CM_PTR,      /* data_received           */
                CM_INT32 CM_PTR,                   /* received_length         */
                CM_STATUS_RECEIVED CM_PTR,         /* status_received         */
                CM_CONTROL_INFORMATION_RECEIVED CM_PTR,
                                              /* control_information_received */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmrcvm(unsigned char CM_PTR,              /* conversation_ID         */
                unsigned char CM_PTR,              /* local map name          */
                CM_MAP_NAME_LENGTH CM_PTR,         /* map_name_length         */
                unsigned char CM_PTR,              /* buffer                  */
                CM_INT32 CM_PTR,                   /* requested_length        */
                CM_DATA_RECEIVED_TYPE CM_PTR,      /* data_received           */
                CM_STATUS_RECEIVED CM_PTR,         /* status_received         */
                CM_CONTROL_INFORMATION_RECEIVED CM_PTR,
                                              /* control_information_received */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmrcvx(unsigned char CM_PTR,              /* conversation_ID         */
                unsigned char CM_PTR,              /* buffer                  */
                CM_INT32 CM_PTR,                   /* requested_length        */
                CM_INT32 CM_PTR,                   /* received_length         */
                CM_CONTROL_INFORMATION_RECEIVED CM_PTR,
                                              /* control_information_received */
                CM_RECEIVE_TYPE CM_PTR,            /* expedited_receive_type  */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmrltp(unsigned char CM_PTR,              /* TP_name                 */
                CM_INT32 CM_PTR,                   /* TP_name_length          */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmrts( unsigned char CM_PTR,              /* conversation_ID         */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmsaeq(unsigned char  CM_PTR,             /* conversation_ID         */
                unsigned char  CM_PTR,             /* AE_qualifier            */
                CM_INT32 CM_PTR,                   /* AE_qualifier length     */
                CM_AE_QUAL_OR_AP_TITLE_FORMAT CM_PTR,
                                                   /* AE_qualifier format     */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmsac( unsigned char CM_PTR,              /* conversation_ID         */
                CM_ALLOCATE_CONFIRM_TYPE CM_PTR,   /* allocate_confirm        */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmsacn(unsigned char  CM_PTR,             /* conversation_ID         */
                unsigned char  CM_PTR,             /* application_context_name*/
                CM_INT32 CM_PTR,                   /* appl_context_name_length*/
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmsapt(unsigned char  CM_PTR,             /* conversation_ID         */
                unsigned char  CM_PTR,             /* AP_title                */
                CM_INT32 CM_PTR,                   /* AP_title_length         */
                CM_AE_QUAL_OR_AP_TITLE_FORMAT CM_PTR,
                                                   /* AP_title format         */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmsbt( unsigned char CM_PTR,              /* conversation_ID         */
                CM_BEGIN_TRANSACTION CM_PTR,       /* begin_transaction       */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmscsp(unsigned char  CM_PTR,             /* conversation_ID         */
                unsigned char  CM_PTR,             /* password                */
                CM_INT32 CM_PTR,                   /* password_length         */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmscst(unsigned char  CM_PTR,             /* conversation_ID         */
                CM_CONVERSATION_SECURITY_TYPE CM_PTR,
                                                   /* conv_security_type      */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmscsu(unsigned char  CM_PTR,             /* conversation_ID         */
                unsigned char  CM_PTR,             /* user_ID                 */
                CM_INT32 CM_PTR,                   /* user_ID_length          */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmsct( unsigned char CM_PTR,              /* conversation_ID         */
                CM_CONVERSATION_TYPE CM_PTR,       /* conversation_type       */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmscu( unsigned char CM_PTR,              /* conversation_ID         */
                CM_CONFIRMATION_URGENCY CM_PTR,    /* confirmation_urgency    */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmsdt( unsigned char CM_PTR,              /* conversation_ID         */
                CM_DEALLOCATE_TYPE CM_PTR,         /* deallocate_type         */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmsed( unsigned char CM_PTR,              /* conversation_ID         */
                CM_ERROR_DIRECTION CM_PTR,         /* error_direction         */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmsend(unsigned char CM_PTR,              /* conversation_ID         */
                unsigned char CM_PTR,              /* buffer                  */
                CM_INT32 CM_PTR,                   /* send_length             */
                CM_CONTROL_INFORMATION_RECEIVED CM_PTR,
                                              /* control_information_received */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmserr(unsigned char CM_PTR,              /* conversation_ID         */
                CM_CONTROL_INFORMATION_RECEIVED CM_PTR,
                                              /* control_information_received */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmsf(  unsigned char CM_PTR,              /* conversation_ID         */
                CM_FILL CM_PTR,                    /* fill                    */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmsid( unsigned char CM_PTR,              /* conversation_ID         */
                unsigned char CM_PTR,              /* initialization_data     */
                CM_INT32 CM_PTR,                   /* init_data length        */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmsjt( unsigned char CM_PTR,              /* conversation_ID         */
                CM_JOIN_TRANSACTION_TYPE CM_PTR,   /* join transaction        */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmsld( unsigned char CM_PTR,              /* conversation_ID         */
                unsigned char CM_PTR,              /* log_data                */
                CM_INT32 CM_PTR,                   /* log_data_length         */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmsltp(unsigned char CM_PTR,              /* TP_name                 */
                CM_INT32 CM_PTR,                   /* TP_name_length          */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmsmid(unsigned char CM_PTR,              /* conversation_ID         */
                unsigned char CM_PTR,              /* local map name          */
                CM_MAP_NAME_LENGTH CM_PTR,         /* map name length         */
                unsigned char CM_PTR,              /* initialization data     */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmsmn( unsigned char CM_PTR,              /* conversation_ID         */
                unsigned char CM_PTR,              /* mode_name               */
                CM_INT32 CM_PTR,                   /* mode_name_length        */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmsndm(unsigned char CM_PTR,              /* conversation_ID         */
                unsigned char CM_PTR,              /* local map name          */
                CM_MAP_NAME_LENGTH CM_PTR,         /* map name length         */
                unsigned char CM_PTR,              /* buffer                  */
                CM_INT32 CM_PTR,                   /* send_length             */
                CM_CONTROL_INFORMATION_RECEIVED CM_PTR,
                                              /* control_information_received */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmsndx(unsigned char CM_PTR,              /* conversation_ID         */
                unsigned char CM_PTR,              /* buffer                  */
                CM_INT32 CM_PTR,                   /* send_length             */
                CM_CONTROL_INFORMATION_RECEIVED CM_PTR,
                                              /* control_information_received */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmspdp(unsigned char CM_PTR,              /* conversation_ID         */
                CM_PREPARE_DATA_PERMITTED_TYPE CM_PTR,
                                                   /* prepare_data_permitted  */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmspid(unsigned char CM_PTR,              /* conversation_ID         */
                CM_PARTNER_ID_TYPE CM_PTR,         /* partner_ID_type         */
                unsigned char CM_PTR,              /* partner_ID              */
                CM_INT32 CM_PTR,                   /* partner_ID_length       */
                CM_PARTNER_ID_SCOPE CM_PTR,        /* partner_ID_scope        */
                CM_DIRECTORY_SYNTAX CM_PTR,        /* directory_syntax        */
                CM_DIRECTORY_ENCODING CM_PTR,      /* directory_encoding      */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmspln(unsigned char CM_PTR,              /* conversation_ID         */
                unsigned char CM_PTR,              /* partner_LU_name         */
                CM_INT32 CM_PTR,                   /* partner_LU_name_length  */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmspm( unsigned char CM_PTR,              /* conversation_ID         */
                CM_PROCESSING_MODE CM_PTR,         /* processing_mode         */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmsptr(unsigned char CM_PTR,              /* conversation_ID         */
                CM_PREPARE_TO_RECEIVE_TYPE CM_PTR, /* prepare_to_receive_type */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmsqcf(unsigned char CM_PTR,              /* conversation_ID         */
                CM_CONVERSATION_QUEUE CM_PTR,      /* conversation_queue      */
                void CM_PTR,                       /* callback_function       */
                unsigned char CM_PTR,              /* user_field              */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmsqpm(unsigned char CM_PTR,              /* conversation_ID         */
                CM_CONVERSATION_QUEUE CM_PTR,      /* conversation_queue      */
                CM_PROCESSING_MODE CM_PTR,         /* queue_processing_mode   */
                unsigned char CM_PTR,              /* user_field              */
                CM_OOID CM_PTR,                    /* OOID                    */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmsrc( unsigned char CM_PTR,              /* conversation_ID         */
                CM_RETURN_CONTROL CM_PTR,          /* return_control          */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmsrt( unsigned char CM_PTR,              /* conversation_ID         */
                CM_RECEIVE_TYPE CM_PTR,            /* receive_type            */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmssl( unsigned char CM_PTR,              /* conversation_ID         */
                CM_SYNC_LEVEL CM_PTR,              /* sync_level              */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmssrm(unsigned char CM_PTR,              /* conversation_ID         */
                CM_SEND_RECEIVE_MODE CM_PTR,       /* send_receive_mode       */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmsst( unsigned char CM_PTR,              /* conversation_ID         */
                CM_SEND_TYPE CM_PTR,               /* send_type               */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmstc( unsigned char CM_PTR,              /* conversation_ID         */
                CM_TRANSACTION_CONTROL CM_PTR,     /* transaction_control     */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmstpn(unsigned char CM_PTR,              /* conversation_ID         */
                unsigned char CM_PTR,              /* TP_name                 */
                CM_INT32 CM_PTR,                   /* TP_name_length          */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmtrts(unsigned char CM_PTR,              /* conversation_ID         */
                CM_CONTROL_INFORMATION_RECEIVED CM_PTR,
                                              /* control_information_received */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmwait(unsigned char CM_PTR,              /* conversation_ID         */
                CM_RETURN_CODE CM_PTR,             /* conversation_ret_code   */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
CM_ENTRY cmwcmp(CM_OOID CM_PTR,                    /* OOID_list               */
                CM_INT32 CM_PTR,                   /* OOID_list_count         */
                CM_TIMEOUT CM_PTR,                 /* timeout                 */
                CM_INT32 CM_PTR,                   /* completed_op_index_list */
                CM_INT32 CM_PTR,                   /* completed_op_count      */
                unsigned char CM_PTR,              /* user_field_list         */
                CM_RETURN_CODE CM_PTR);            /* return_code             */
/*---------------------------------------------------------------------------*/
/* Function Prototypes for additional NS/2 compatible call routines          */
/*---------------------------------------------------------------------------*/

/* Delete_CPIC_Side_Information */
CM_ENTRY xcmdsi(unsigned char CM_PTR,               /* key_lock              */
                unsigned char CM_PTR,               /* sym_dest_name         */
                CM_RETURN_CODE CM_PTR);             /* return_code           */

/* Extract_CPIC_Side_Information */
CM_ENTRY xcmesi(CM_INT32 CM_PTR,                    /* entry_number          */
                unsigned char CM_PTR,                       /* sym_dest_name         */
                SIDE_INFO CM_PTR,                   /* side_info_entry       */
                CM_INT32 CM_PTR,                    /* side_info_length      */
                CM_RETURN_CODE CM_PTR);             /* return_code           */

/* Set_CPIC_Side_Information */
CM_ENTRY xcmssi(unsigned char CM_PTR,               /* key_lock              */
                SIDE_INFO CM_PTR,                   /* side_info_entry       */
                CM_INT32 CM_PTR,                    /* side_info length      */
                CM_RETURN_CODE CM_PTR);             /* return_code           */

/* Extract_Conversation_Security_Type */
CM_ENTRY xcecst(unsigned char CM_PTR,               /* conversation_ID       */
                XC_CONVERSATION_SECURITY_TYPE CM_PTR, /* conversation_sec... */
                CM_RETURN_CODE CM_PTR);             /* return_code           */

/* Extract_Conversation_User_ID */
CM_ENTRY xcecsu(unsigned char CM_PTR,               /* conversation_ID       */
                unsigned char CM_PTR,               /* user_ID               */
                CM_INT32 CM_PTR,                    /* user_ID_length        */
                CM_RETURN_CODE CM_PTR);             /* return_code           */

/* Set_Conversation_Security_Password */
CM_ENTRY xcscsp(unsigned char CM_PTR,               /* conversation_ID       */
                unsigned char CM_PTR,               /* password              */
                CM_INT32 CM_PTR,                    /* password_length       */
                CM_RETURN_CODE CM_PTR);             /* return_code           */

/* Set_Conversation_Security_Type */
CM_ENTRY xcscst(unsigned char CM_PTR,               /* conversation_ID       */
                XC_CONVERSATION_SECURITY_TYPE CM_PTR, /* conversation_sec... */
                CM_RETURN_CODE CM_PTR);             /* return_code           */

/* Set_Conversation_Security_User_ID */
CM_ENTRY xcscsu(unsigned char CM_PTR,               /* conversation_ID       */
                unsigned char CM_PTR,               /* user_ID               */
                CM_INT32 CM_PTR,                    /* user_ID_length        */
                CM_RETURN_CODE CM_PTR);             /* return_code           */

/* Extract_Conversation_Security_Type */
CM_ENTRY cmecst(unsigned char CM_PTR,               /* conversation_ID       */
                XC_CONVERSATION_SECURITY_TYPE CM_PTR, /* conversation_sec... */
                CM_RETURN_CODE CM_PTR);             /* return_code           */

/* Extract_Conversation_User_ID */
CM_ENTRY cmecsu(unsigned char CM_PTR,               /* conversation_ID       */
                unsigned char CM_PTR,               /* user_ID               */
                CM_INT32 CM_PTR,                    /* user_ID_length        */
                CM_RETURN_CODE CM_PTR);             /* return_code           */

#ifdef WINSNA
/* Specify_Windows_Handle */
CM_ENTRY xchwnd(HWND,                               /* Window HWND     *WSNA1*/
                CM_INT32 CM_PTR);                   /* return_code           */
/*---------------------------------------------------------------------------*/
/* Windows CPI-C Extention Return Codes.                                     */
/*---------------------------------------------------------------------------*/

#define WCPICALREADY         0xF000   /* An async call is already outstanding */
#define WCPICINVALID         0xF001   /* Async Task Id is invalid             */
#define WCPICCANCEL          0xF002   /* Blocking call was cancelled          */
#define WCPICSYSNOTREADY     0xF003   /* Underlying subsystem not started     */
#define WCPICVERNOTSUPPORTED 0xF004   /* Application version not supported    */


/*----------------------------------------------------------------------------*/
/* Api structure definitions                                                  */
/*----------------------------------------------------------------------------*/
#define WCPICDESCRIPTION_LEN    127

typedef struct tagWCPICDATA {
        WORD    wVersion;
        char    szDescription[WCPICDESCRIPTION_LEN+1];
} WCPICDATA, * PWCPICDATA, FAR * LPWCPICDATA;

/*---------------------------------------------------------------------------*/
/*               Windows CPI-C function prototypes                           */
/*---------------------------------------------------------------------------*/

extern BOOL WINAPI    WinCPICCleanup(void);
extern BOOL WINAPI    WinCPICIsBlocking(void);
extern int WINAPI     WinCPICStartup(WORD, LPWCPICDATA );
extern FARPROC WINAPI WinCPICSetBlockingHook( FARPROC );
extern BOOL WINAPI    WinCPICUnhookBlockingHook(void);
#ifdef WIN32
extern VOID WINAPI    WinCPICSetEvent(unsigned char   CM_PTR,
                                      CM_EVENT_HANDLE CM_PTR,
                                      CM_RETURN_CODE CM_PTR);
extern VOID WINAPI    WinCPICExtractEvent(unsigned char   CM_PTR,
                                          CM_EVENT_HANDLE CM_PTR,
                                          CM_RETURN_CODE CM_PTR);
#endif

#define WIN_CPIC_ASYNC_COMPLETE_MESSAGE "WinAsyncCPI-C"

#endif

/*---------------------------------------------------------------------------*/
/* These macros allow you to write programs that are easier to read, since   */
/* you can use the full name of the CPI-C call rather than its 6 character   */
/* entry point.                                                              */
/*                                                                           */
/* When porting code that uses these macros, you will have to ensure that    */
/* the macros are defined on the target platform.                            */
/*---------------------------------------------------------------------------*/

#ifdef READABLE_MACROS

#define Accept_Conversation                   cmaccp
#define Accept_Incoming                       cmacci
#define Allocate                              cmallc
#define Cancel_Conversation                   cmcanc
#define Confirm                               cmcfm
#define Confirmed                             cmcfmd
#define Convert_Incoming                      cmcnvi
#define Convert_Outgoing                      cmcnvo
#define Deallocate                            cmdeal
#define Deferred_Deallocate                   cmdfde
#define Extract_AE_Qualifier                  cmeaeq
#define Extract_AP_Title                      cmeapt
#define Extract_Application_Context_Name      cmeacn
#define Extract_Conversation_Context          cmectx
#define Extract_Conversation_State            cmecs
#define Extract_Conversation_Type             cmect
#define Extract_Initialization_Data           cmeid
#define Extract_Mapped_Initialization_Data    cmemid
#define Extract_Maximum_Buffer_Size           cmembs
#define Extract_Mode_Name                     cmemn
#define Extract_Partner_ID                    cmepid
#define Extract_Partner_LU_Name               cmepln
#define Extract_Secondary_Information         cmesi
#define Extract_Security_User_ID              cmesui
#define Extract_Send_Receive_Mode             cmesrm
#define Extract_Sync_Level                    cmesl
#define Extract_Transaction_Control           cmetc
#define Extract_TP_Name                       cmetpn
#define Flush                                 cmflus
#define Include_Partner_In_Transaction        cmincl
#define Initialize_Conversation               cminit
#define Initialize_For_Incoming               cminic
#define Prepare                               cmprep
#define Prepare_To_Receive                    cmptr
#define Receive                               cmrcv
#define Receive_Expedited_Data                cmrcvx
#define Receive_Mapped_Data                   cmrcvm
#define Release_Local_TP_Name                 cmrltp
#define Request_To_Send                       cmrts
#define Send_Data                             cmsend
#define Send_Error                            cmserr
#define Send_Expedited_Data                   cmsndx
#define Send_Mapped_Data                      cmsndm
#define Set_AE_Qualifier                      cmsaeq
#define Set_Allocate_Confirm                  cmsac
#define Set_AP_Title                          cmsapt
#define Set_Application_Context_Name          cmsacn
#define Set_Begin_Transaction                 cmsbt
#define Set_Confirmation_Urgency              cmscu
#define Set_Conversation_Security_Password    cmscsp
#define Set_Conversation_Security_Type        cmscst
#define Set_Conversation_Security_User_ID     cmscsu
#define Set_Conversation_Type                 cmsct
#define Set_Deallocate_Type                   cmsdt
#define Set_Error_Direction                   cmsed
#define Set_Fill                              cmsf
#define Set_Initialization_Data               cmsid
#define Set_Join_Transaction                  cmsjt
#define Set_Log_Data                          cmsld
#define Set_Mapped_Initialization_Data        cmsmid
#define Set_Mode_Name                         cmsmn
#define Set_Partner_ID                        cmspid
#define Set_Partner_LU_Name                   cmspln
#define Set_Prepare_Data_Permitted            cmspdp
#define Set_Prepare_To_Receive_Type           cmsptr
#define Set_Processing_Mode                   cmspm
#define Set_Queue_Callback_Function           cmsqcf
#define Set_Queue_Processing_Mode             cmsqpm
#define Set_Receive_Type                      cmsrt
#define Set_Return_Control                    cmsrc
#define Set_Send_Receive_Mode                 cmssrm
#define Set_Send_Type                         cmsst
#define Set_Sync_Level                        cmssl
#define Set_TP_Name                           cmstpn
#define Set_Transaction_Control               cmstc
#define Specify_Local_TP_Name                 cmsltp
#define Test_Request_To_Send_Received         cmtrts
#define Wait_For_Completion                   cmwcmp
#define Wait_For_Conversation                 cmwait
#define Specify_Windows_Handle                xchwnd

#endif

#ifdef __cplusplus
}
#endif
/*---------------------------------------------------------------------------*/
/* Restore to default packing of structures                                  */
/*---------------------------------------------------------------------------*/
#ifdef WIN32
  #pragma pack()
#endif

#endif
