Attribute VB_Name = "Module1"
' $Id: //ribm/12.0/dev/ehllapi/ehllapi.bas#1 $
' -----------------------------------------------------------------------
'  Name........... ehllapi.bas
'  Product........ Reflection for IBM
'  Description.... deliverable definitions and declarations for EHLLAPI use
'                  from Microsoft Visual Basic
'  System......... Windows
'  Language....... Microsoft Visual Basic
'  Designer....... Craig Smith
'  Created........ 08/02/96
'  Copyright...... (c) 1996 WRQ Inc.
' -----------------------------------------------------------------------

' ------------------------------------------------------------------------
'  Terminology note.
'  In the HLLAPI code, and all things relating to it,
'
'      "session" refers to a period during which an application interacts
'          with an instance of a 3270/5250 emulator. It does NOT refer to a
'          "terminal session", i.e., a period during which an emulator is
'          connected to a host.
'
'          "instance" refers to an instance of a 3270/5250 emulator.
' ------------------------------------------------------------------------

' ***** Types ***********************************************************
' Structure returned by Query Sessions (f. 10), one per session.
Public Type HLLQSESSION
    ShortName As Byte
    LongName As String * 8
    SessType As Byte
    PresSpaceSz As Integer
End Type
Global Const HLLQSESSIONSIZE = 12

#If Win16 Then
Type HLLPOINT
    x As Integer
    y As Integer
End Type
#Else
Type HLLPOINT
    x As Long
    y As Long
End Type
#End If

' ***** Constants *******************************************************
'------------------------------------------------------------------------
' Api Function Codes
'------------------------------------------------------------------------
Global Const OEMFUNCTION = 0                    ' OEM function.
Global Const CONNECTPS = 1                      ' connect presentation space
Global Const DISCONNECTPS = 2                   ' disconnect presentation space
Global Const SENDKEY = 3                        ' send key
Global Const WAIT = 4                           ' wait
Global Const COPYPS = 5                         ' copy presentation space
Global Const SEARCHPS = 6                       ' search presentation space
Global Const QUERYCURSORLOC = 7                 ' query cursor position
Global Const COPYPSTOSTR = 8                    ' copy presentation space to string
Global Const SETSESSIONPARAMETERS = 9           ' set session parameters
Global Const QUERYSESSIONS = 10                 ' query sessions
Global Const RESERVE = 11                       ' reserve
Global Const RELEASE = 12                       ' release
Global Const COPYOIA = 13                       ' copy oia information
Global Const QUERYFIELDATTRIBUTE = 14           ' query field attribute
Global Const COPYSTRTOPS = 15                   ' copy string to presentation space
Global Const STORAGEMGR = 17                    ' storage manager
Global Const PAUSE = 18                         ' pause
Global Const QUERYSYSTEM = 20                   ' query system
Global Const RESETSYSTEM = 21                   ' reset system
Global Const QUERYSESSIONSTATUS = 22            ' query session status
Global Const STARTHOSTNOTIFICATION = 23         ' start host notification
Global Const QUERYHOSTUPDATE = 24               ' query host update
Global Const STOPHOSTNOTIFICATION = 25          ' stop host notification
Global Const SEARCHFIELD = 30                   ' search field
Global Const FINDFIELDPOSITION = 31             ' find field position
Global Const FINDFIELDLENGTH = 32               ' find field length
Global Const COPYSTRINGTOFIELD = 33             ' copy string to field
Global Const COPYFIELDTOSTRING = 34             ' copy field to string
Global Const DISPLAYCURSOR = 37                 ' display cursor
Global Const DISPLAYPRESENTATIONSPACE = 38      ' display presentation space
Global Const DELPRESENTATIONSPACE = 39          ' delete presentation space
Global Const SETCURSOR = 40                     ' set cursor
Global Const STARTCLOSEINTERCEPT = 41           ' Start close intercept
Global Const QUERYCLOSEINTERCEPT = 42           ' Query close intercept
Global Const STOPCLOSEINTERCEPT = 43            ' Stop close intercept
Global Const STARTKSINTERCEPT = 50              ' start keystroke intercept
Global Const GETKEY = 51                        ' get key
Global Const POSTINTERCEPTSTATUS = 52           ' post intercept status
Global Const STOPKSINTERCEPT = 53               ' stop keystroke intercept
Global Const LOCKPS = 60                        ' Lock presentation space
Global Const LOCKWINDOWSERVICES = 61            ' Lock window services
Global Const SENDFILE = 90                      ' send file
Global Const RECEIVEFILE = 91                   ' receive file
Global Const CONVERT = 99                       ' convert position or rowcol
Global Const CONNECTWS = 101                    ' Connect window services
Global Const DISCONNECTWS = 102                 ' Disconnect window services
Global Const QUERYWINDOWCOORDS = 103            ' Query window coordinates
Global Const WINDOWSTATUS = 104                 ' Query/change window status
Global Const CHANGESWITCHLISTLTNAME = 105       ' Change/reset logical term switch list
Global Const CHANGEPSWINDOWNAME = 106           ' Change/reset ps window name
Global Const CONNECTSTRUCTUREDFIELDS = 120      ' Connect to process structured fields
Global Const DISCONNECTSTRUCTUREDFIELDS = 121   ' Disconnect from processing SFs
Global Const QUERYCOMMBUFFERSIZE = 122          ' Query communications buffer size
Global Const ALLOCATECOMMBUFFER = 123           ' Allocate a communications buffer (SF)
Global Const FREECOMMBUFFER = 124               ' Free previously allocated buffer
Global Const GETREQUESTCOMPLETION = 125         ' Determine completion status of SF req
Global Const READSTRUCTUREDFIELDS = 126         ' Read a structured field
Global Const WRITESTRUCTUREDFIELDS = 127        ' Write a structured field
Global Const RUNPROFILE = 1000                  ' start emulator with profile
Global Const SHOWSESSION = 1001                 ' changes state of emulator window
Global Const GETSESSIONHWND = 1002              ' get window handle of emulator window


'------------------------------------------------------------------------
' EHLLAPI Return Codes
'------------------------------------------------------------------------
Global Const APIOK = 0                          ' successful
Global Const APINOTCONNECTED = 1                ' not connected to presentation space
Global Const APIPARAMETERERROR = 2              ' parameter error/invalid function
Global Const APIFTXCOMPLETE = 3                 ' file transfer complete
Global Const APIFTXSEGMENTED = 4                ' file transfer complete/segmented
Global Const APIPSBUSY = 4                      ' presentation space is busy
Global Const APIINHIBITED = 5                   ' inhibited/keyboard locked
Global Const APITRUNCATED = 6                   ' data truncated
Global Const APIPOSITIONERROR = 7               ' invalid presentation space position
Global Const APINOTAVAILABLE = 8                ' unavailable operation
Global Const APISYSERROR = 9                    ' system error
Global Const APIUNAVAILABLE = 11                ' resource is unavailable
Global Const APIUNDEFINEDKEY = 20               ' undefined key combination
Global Const APIOIAUPDATE = 21                  ' oia updated
Global Const APIPSUPDATE = 22                   ' ps updated
Global Const APIBOTHUPDATE = 23                 ' boths ps and oia updated
Global Const APINOFIELD = 24                    ' no such field found
Global Const APINOKEYSTROKES = 25               ' no keystrokes are availble
Global Const APIPSCHANGED = 26                  ' ps or oia changed
Global Const APIZEROLENFIELD = 28               ' zero length field
Global Const APIINVALIDTYPE = 30                ' invalid cursor type
Global Const APIKEYOVERFLOW = 31                ' keystroke overflow
Global Const APIFILENOTFOUND = 302              ' file not found
Global Const APIACCESSDENIED = 305              ' access denied
Global Const APIMEMORY = 308                    ' insufficient memory
Global Const APIINVALIDPSID = 9998              ' invalid presentation space id
Global Const APIINVALIDRC = 9999                ' invalid row or column code

' ***** Procedure Prototypes ********************************************
#If Win16 Then
    Declare Function hllapi Lib "eehllapi.dll" (lpwFunction As Integer, ByVal lpDataString As String, lpwLength As Integer, lpwReturnCode As Integer) As Integer

    Declare Function WD_ConnectPS Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal lpShortName As String) As Integer
    Declare Function WD_Convert Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal wType As Integer, lpPoint As HLLPOINT, ByVal lpShortName As String) As Integer
    Declare Function WD_CopyFieldToString Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal wPosition As Integer, ByVal lpData As String, ByVal wLength As Integer) As Integer
    Declare Function WD_CopyOIA Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal lpData As String, ByVal wLength As Integer) As Integer
    Declare Function WD_CopyPS Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal lpData As String, ByVal wLength As Integer) As Integer
    Declare Function WD_CopyPSToString Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal wPosition As Integer, ByVal lpData As String, ByVal wLength As Integer) As Integer
    Declare Function WD_CopyStringToField Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal wPosition As Integer, ByVal lpData As String) As Integer
    Declare Function WD_CopyStringToPS Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal wPosition As Integer, ByVal lpData As String, ByVal wLength As Integer) As Integer
    Declare Function WD_DeletePS Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal lpShortName As String) As Integer
    Declare Function WD_DisconnectPS Lib "eehllapi.dll" (ByVal hInst As Integer) As Integer
    Declare Function WD_DisplayCursor Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal wPosition As Integer, ByVal lpData As String) As Integer
    Declare Function WD_DisplayPS Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal lpShortName As String) As Integer
    Declare Function WD_FindFieldLength Lib "eehllapi.dll" (ByVal hInst As Integer, lpLocation As Integer, ByVal wPosition As Integer, ByVal lpData As String) As Integer
    Declare Function WD_FindFieldPosition Lib "eehllapi.dll" (ByVal hInst As Integer, lpLocation As Integer, ByVal wPosition As Integer, ByVal lpData As String) As Integer
    Declare Function WD_GetKey Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal lpData As String) As Integer
    Declare Function WD_GetSessionHWND Lib "eehllapi.dll" (ByVal hMyInst As Integer) As Integer
    Declare Function WD_Pause Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal wDuration As Integer) As Integer
    Declare Function WD_PostInterceptStatus Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal lpData As String) As Integer
    Declare Function WD_QueryCursorLocation Lib "eehllapi.dll" (ByVal hInst As Integer, lpLocation As Integer) As Integer
    Declare Function WD_QueryFieldAttribute Lib "eehllapi.dll" (ByVal hInst As Integer, lpLocation As Integer, ByVal wPosition As Integer) As Integer
    Declare Function WD_QueryHostUpdate Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal lpPSId As String) As Integer
    Declare Function WD_QuerySessionStatus Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal lpData As String) As Integer
    Declare Function WD_QuerySessions Lib "eehllapi.dll" (ByVal hInst As Integer, lpNumSess As Integer, lpSessions As HLLQSESSION) As Integer
    Declare Function WD_QuerySystem Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal lpData As String) As Integer
    Declare Function WD_ReceiveFile Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal lpData As String) As Integer
    Declare Function WD_Release Lib "eehllapi.dll" (ByVal hInst As Integer) As Integer
    Declare Function WD_Reserve Lib "eehllapi.dll" (ByVal hInst As Integer) As Integer
    Declare Function WD_ResetSystem Lib "eehllapi.dll" (ByVal hInst As Integer) As Integer
    Declare Function WD_RunProfile Lib "eehllapi.dll" (ByVal lpProfile As String, ByVal wSWConst As Integer) As Integer
    Declare Function WD_SearchField Lib "eehllapi.dll" (ByVal hInst As Integer, lpLocation As Integer, ByVal wPosition As Integer, ByVal lpTarget As String) As Integer
    Declare Function WD_SearchPS Lib "eehllapi.dll" (ByVal hInst As Integer, lpLocation As Integer, ByVal wPosition As Integer, ByVal lpTarget As String) As Integer
    Declare Function WD_SendFile Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal lpData As String) As Integer
    Declare Function WD_SendKey Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal lpData As String) As Integer
    Declare Function WD_SetCursor Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal wPosition As Integer) As Integer
    Declare Function WD_SetSessionParameters Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal dwParams As Long) As Integer
    Declare Function WD_ShowSession Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal wSWConst As Integer) As Integer
    Declare Function WD_StartHostNotification Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal lpData As String) As Integer
    Declare Function WD_StartKSIntercept Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal lpData As String) As Integer
    Declare Function WD_StopHostNotification Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal lpPSId As String) As Integer
    Declare Function WD_StopKSIntercept Lib "eehllapi.dll" (ByVal hInst As Integer, ByVal lpShortName As String) As Integer
    Declare Function WD_Wait Lib "eehllapi.dll" (ByVal hInst As Integer) As Integer
#Else
    Declare Function hllapi Lib "hllapi32.dll" (lpwFunction As Integer, ByVal lpDataString As String, lpwLength As Integer, lpwReturnCode As Integer) As Integer

    Declare Function WD_ConnectPS Lib "hllapi32.dll" (ByVal hInst As Long, ByVal lpShortName As String) As Integer
    Declare Function WD_Convert Lib "hllapi32.dll" (ByVal hInst As Long, ByVal wType As Integer, lpPoint As HLLPOINT, ByVal lpShortName As String) As Integer
    Declare Function WD_CopyFieldToString Lib "hllapi32.dll" (ByVal hInst As Long, ByVal wPosition As Integer, ByVal lpData As String, ByVal wLength As Integer) As Integer
    Declare Function WD_CopyOIA Lib "hllapi32.dll" (ByVal hInst As Long, ByVal lpData As String, ByVal wLength As Integer) As Integer
    Declare Function WD_CopyPS Lib "hllapi32.dll" (ByVal hInst As Long, ByVal lpData As String, ByVal wLength As Integer) As Integer
    Declare Function WD_CopyPSToString Lib "hllapi32.dll" (ByVal hInst As Long, ByVal wPosition As Integer, ByVal lpData As String, ByVal wLength As Integer) As Integer
    Declare Function WD_CopyStringToField Lib "hllapi32.dll" (ByVal hInst As Long, ByVal wPosition As Integer, ByVal lpData As String) As Integer
    Declare Function WD_CopyStringToPS Lib "hllapi32.dll" (ByVal hInst As Long, ByVal wPosition As Integer, ByVal lpData As String, ByVal wLength As Integer) As Integer
    Declare Function WD_DeletePS Lib "hllapi32.dll" (ByVal hInst As Long, ByVal lpShortName As String) As Integer
    Declare Function WD_DisconnectPS Lib "hllapi32.dll" (ByVal hInst As Long) As Integer
    Declare Function WD_DisplayCursor Lib "hllapi32.dll" (ByVal hInst As Long, ByVal wPosition As Integer, ByVal lpData As String) As Integer
    Declare Function WD_DisplayPS Lib "hllapi32.dll" (ByVal hInst As Long, ByVal lpShortName As String) As Integer
    Declare Function WD_FindFieldLength Lib "hllapi32.dll" (ByVal hInst As Long, lpLocation As Integer, ByVal wPosition As Integer, ByVal lpData As String) As Integer
    Declare Function WD_FindFieldPosition Lib "hllapi32.dll" (ByVal hInst As Long, lpLocation As Integer, ByVal wPosition As Integer, ByVal lpData As String) As Integer
    Declare Function WD_GetKey Lib "hllapi32.dll" (ByVal hInst As Long, ByVal lpData As String) As Integer
    Declare Function WD_GetSessionHWND Lib "hllapi32.dll" (ByVal hMyInst As Long) As Long
    Declare Function WD_Pause Lib "hllapi32.dll" (ByVal hInst As Long, ByVal wDuration As Integer) As Integer
    Declare Function WD_PostInterceptStatus Lib "hllapi32.dll" (ByVal hInst As Long, ByVal lpData As String) As Integer
    Declare Function WD_QueryCursorLocation Lib "hllapi32.dll" (ByVal hInst As Long, lpLocation As Integer) As Integer
    Declare Function WD_QueryFieldAttribute Lib "hllapi32.dll" (ByVal hInst As Long, lpLocation As Integer, ByVal wPosition As Integer) As Integer
    Declare Function WD_QueryHostUpdate Lib "hllapi32.dll" (ByVal hInst As Long, ByVal lpPSId As String) As Integer
    Declare Function WD_QuerySessionStatus Lib "hllapi32.dll" (ByVal hInst As Long, ByVal lpData As String) As Integer
    Declare Function WD_QuerySessions Lib "hllapi32.dll" (ByVal hInst As Long, lpNumSess As Integer, lpSessions As HLLQSESSION) As Integer
    Declare Function WD_QuerySystem Lib "hllapi32.dll" (ByVal hInst As Long, ByVal lpData As String) As Integer
    Declare Function WD_ReceiveFile Lib "hllapi32.dll" (ByVal hInst As Long, ByVal lpData As String) As Integer
    Declare Function WD_Release Lib "hllapi32.dll" (ByVal hInst As Long) As Integer
    Declare Function WD_Reserve Lib "hllapi32.dll" (ByVal hInst As Long) As Integer
    Declare Function WD_ResetSystem Lib "hllapi32.dll" (ByVal hInst As Long) As Integer
    Declare Function WD_RunProfile Lib "hllapi32.dll" (ByVal lpProfile As String, ByVal wSWConst As Integer) As Integer
    Declare Function WD_SearchField Lib "hllapi32.dll" (ByVal hInst As Long, lpLocation As Integer, ByVal wPosition As Integer, ByVal lpTarget As String) As Integer
    Declare Function WD_SearchPS Lib "hllapi32.dll" (ByVal hInst As Long, lpLocation As Integer, ByVal wPosition As Integer, ByVal lpTarget As String) As Integer
    Declare Function WD_SendFile Lib "hllapi32.dll" (ByVal hInst As Long, ByVal lpData As String) As Integer
    Declare Function WD_SendKey Lib "hllapi32.dll" (ByVal hInst As Long, ByVal lpData As String) As Integer
    Declare Function WD_SetCursor Lib "hllapi32.dll" (ByVal hInst As Long, ByVal wPosition As Integer) As Integer
    Declare Function WD_SetSessionParameters Lib "hllapi32.dll" (ByVal hInst As Long, ByVal dwParams As Long) As Integer
    Declare Function WD_ShowSession Lib "hllapi32.dll" (ByVal hInst As Long, ByVal wSWConst As Integer) As Integer
    Declare Function WD_StartHostNotification Lib "hllapi32.dll" (ByVal hInst As Long, ByVal lpData As String) As Integer
    Declare Function WD_StartKSIntercept Lib "hllapi32.dll" (ByVal hInst As Long, ByVal lpData As String) As Integer
    Declare Function WD_StopHostNotification Lib "hllapi32.dll" (ByVal hInst As Long, ByVal lpPSId As String) As Integer
    Declare Function WD_StopKSIntercept Lib "hllapi32.dll" (ByVal hInst As Long, ByVal lpShortName As String) As Integer
    Declare Function WD_Wait Lib "hllapi32.dll" (ByVal hInst As Long) As Integer
#End If
