//$Id: //ribm/12.0/dev/ehllapi/ehllapi.h#1 $
#ifndef _EHLLAPI_H
#define _EHLLAPI_H

/*------------------------------------------------------------------------
 * Name..........ehllapi.h
 * Description...deliverable definitions and declarations for
 *               EHLLAPI specification
 * Language......C, C++
 * Created.......Aug 4, 1993, Craig Smith
 * Copyright.....(c) 1994 WRQ Inc.
 *------------------------------------------------------------------------
 */

#include <windows.h>

/*------------------------------------------------------------------------
 * 32- and 16- bit portability issues
 *------------------------------------------------------------------------
 */
#ifdef _EXPORT
    #undef _EXPORT
#endif

#ifdef WIN32
#define _EXPORT _stdcall
#else
#define _EXPORT FAR PASCAL _export
#endif

/*------------------------------------------------------------------------
 * Terminology note.
 * In the HLLAPI code, and all things relating to it, 
 *
 *     "session" refers to a period during which an application interacts
 *         with an instance of a 3270/5250 emulator. It does NOT refer to a
 *         "terminal session", i.e., a period during which an emulator is 
 *         connected to a host.
 *
 *         "instance" refers to an instance of a 3270/5250 emulator.
 *------------------------------------------------------------------------
 */
#define MAXHLLAPI           8
#define MAXPSIDLONGNAME     8
#define MAXPSIDSHORTNAME    1
#define MAXPSWINDOWNAME		61
// Session limit set by number of available short names.
#define HLLAPI_SESSION_LIMIT	26
/*------------------------------------------------------------------------
 * Typedefs
 *------------------------------------------------------------------------
 */
/* Structure returned by Query Sessions (f. 10), one per session. */
typedef struct
{
    char ShortName;
    char LongName[MAXPSIDLONGNAME];
    char SessType;
    short PresSpaceSz;
} HLLQSESSION, far * PHLLQSESSION;

/*------------------------------------------------------------------------
 * Api Function Codes
 *------------------------------------------------------------------------       */

#define OEMFUNCTION                  0   /* OEM function.                        */
#define CONNECTPS                    1   /* connect presentation space           */
#define DISCONNECTPS                 2   /* disconnect presentation space        */
#define SENDKEY                      3   /* send key                             */
#define WAIT                         4   /* wait                                 */
#define COPYPS                       5   /* copy presentation space              */
#define SEARCHPS                     6   /* search presentation space            */
#define QUERYCURSORLOC               7   /* query cursor position                */
#define COPYPSTOSTR                  8   /* copy presentation space to string    */
#define SETSESSIONPARAMETERS         9   /* set session parameters               */
#define QUERYSESSIONS               10   /* query sessions                       */
#define RESERVE                     11   /* reserve                              */
#define RELEASE                     12   /* release                              */
#define COPYOIA                     13   /* copy oia information                 */
#define QUERYFIELDATTRIBUTE         14   /* query field attribute                */
#define COPYSTRTOPS                 15   /* copy string to presentation space    */
#define STORAGEMGR                  17   /* storage manager                      */
#define PAUSE                       18   /* pause                                */
#define QUERYSYSTEM                 20   /* query system                         */
#define RESETSYSTEM                 21   /* reset system                         */
#define QUERYSESSIONSTATUS          22   /* query session status                 */
#define STARTHOSTNOTIFICATION       23   /* start host notification              */
#define QUERYHOSTUPDATE             24   /* query host update                    */
#define STOPHOSTNOTIFICATION        25   /* stop host notification               */
#define SEARCHFIELD                 30   /* search field                         */
#define FINDFIELDPOSITION           31   /* find field position                  */
#define FINDFIELDLENGTH             32   /* find field length                    */
#define COPYSTRINGTOFIELD           33   /* copy string to field                 */
#define COPYFIELDTOSTRING           34   /* copy field to string                 */
#define DISPLAYCURSOR               37   /* display cursor                       */
#define DISPLAYPRESENTATIONSPACE    38   /* display presentation space           */
#define DELPRESENTATIONSPACE        39   /* delete presentation space            */
#define SETCURSOR                   40   /* set cursor                           */
#define STARTCLOSEINTERCEPT         41   /* Start close intercept                */
#define QUERYCLOSEINTERCEPT         42   /* Query close intercept                */        
#define STOPCLOSEINTERCEPT          43   /* Stop close intercept                 */    
#define STARTKSINTERCEPT            50   /* start keystroke intercept            */
#define GETKEY                      51   /* get key                              */
#define POSTINTERCEPTSTATUS         52   /* post intercept status                */
#define STOPKSINTERCEPT             53   /* stop keystroke intercept             */
#define LOCKPS                      60   /* Lock presentation space              */    
#define LOCKWINDOWSERVICES          61   /* Lock window services                 */    
#define SENDFILE                    90   /* send file                            */
#define RECEIVEFILE                 91   /* receive file                         */
#define CONVERT                     99   /* convert position or rowcol           */
#define CONNECTWS                   101  /* Connect window services              */
#define DISCONNECTWS                102  /* Disconnect window services           */
#define QUERYWINDOWCOORDS           103  /* Query window coordinates             */    
#define WINDOWSTATUS                104  /* Query/change window status           */    
#define CHANGESWITCHLISTLTNAME      105  /* Change/reset logical term switch list*/    
#define CHANGEPSWINDOWNAME          106  /* Change/reset ps window name          */    
#define CONNECTSTRUCTUREDFIELDS     120  /* Connect to process structured fields */    
#define DISCONNECTSTRUCTUREDFIELDS  121  /* Disconnect from processing SFs       */    
#define QUERYCOMMBUFFERSIZE         122  /* Query communications buffer size     */    
#define ALLOCATECOMMBUFFER          123  /* Allocate a communications buffer (SF)*/    
#define FREECOMMBUFFER              124  /* Free previously allocated buffer     */    
#define GETREQUESTCOMPLETION        125  /* Determine completion status of SF req*/    
#define READSTRUCTUREDFIELDS        126  /* Read a structured field              */    
#define WRITESTRUCTUREDFIELDS       127  /* Write a structured field             */    
#define RUNPROFILE                  1000 /* start emulator with profile          */
#define SHOWSESSION                 1001 /* changes state of emulator window     */
#define GETSESSIONHWND              1002 /* get window handle of emulator window */

/*------------------------------------------------------------------------
 * EHLLAPI Return Codes
 *------------------------------------------------------------------------   */
#define APIOK                 0    /* successful                             */
#define APINOTCONNECTED       1    /* not connected to presentation space    */
#define APIPARAMETERERROR     2    /* parameter error/invalid function       */
#define APIFTXCOMPLETE        3    /* file transfer complete                 */
#define APIFTXSEGMENTED       4    /* file transfer complete/segmented       */
#define APIPSBUSY             4    /* presentation space is busy             */
#define APIINHIBITED          5    /* inhibited/keyboard locked              */
#define APITRUNCATED          6    /* data truncated                         */
#define APIPOSITIONERROR      7    /* invalid presentation space position    */
#define APINOTAVAILABLE       8    /* unavailable operation                  */
#define APISYSERROR           9    /* system error                           */
#define APIUNAVAILABLE        11   /* resource is unavailable                */
#define APIUNDEFINEDKEY       20   /* undefined key combination              */
#define APIOIAUPDATE          21   /* oia updated                            */
#define APIPSUPDATE           22   /* ps updated                             */
#define APIBOTHUPDATE         23   /* boths ps and oia updated               */
#define APINOFIELD            24   /* no such field found                    */
#define APINOKEYSTROKES       25   /* no keystrokes are availble             */
#define APIPSCHANGED          26   /* ps or oia changed                      */
#define APIZEROLENFIELD       28   /* zero length field                      */
#define APIINVALIDTYPE        30   /* invalid cursor type                    */
#define APIKEYOVERFLOW        31   /* keystroke overflow                     */
#define APIFILENOTFOUND       302  /* file not found                         */
#define APIACCESSDENIED       305  /* access denied                          */
#define APIMEMORY             308  /* insufficient memory                    */
#define APIINVALIDPSID        9998 /* invalid presentation space id          */
#define APIINVALIDRC          9999 /* invalid row or column code             */
                                                                                 
/*------------------------------------------------------------------------
 * Defined parameters for WD functions
 *------------------------------------------------------------------------      */
/****** for WD_Convert **********************************************************/
#define CONVERT_POSITION        'P'     /* Convert position to row, col         */
#define CONVERT_ROW             'R'     /* Convert position to offset           */
#define _WDFP   _EXPORT
#define _WDW    WORD _WDFP
#define _WDH    HWND _WDFP
#define _WDB    BOOL _WDFP

#ifdef __cplusplus
extern "C" {
#endif


    WORD _EXPORT hllapi(LPWORD lpwFunction, LPSTR lpDataString, LPWORD lpwLength, LPWORD lpwReturnCode);
    BOOL _EXPORT setTraceFlag(BOOL bTrace);
    BOOL _EXPORT getTraceFlag(void);

    _WDW WD_ConnectPS(HWND hInst, LPSTR lpShortName);
    _WDW WD_Convert(HWND hInst, WORD wType, LPPOINT lpPoint, LPSTR lpShortName);
    _WDW WD_CopyFieldToString(HWND hInst, WORD wPosition, LPSTR lpData, WORD wLength);
    _WDW WD_CopyOIA(HWND hInst, LPSTR lpData, WORD wLength);
    _WDW WD_CopyPS(HWND hInst, LPSTR lpData, WORD wLength);
    _WDW WD_CopyPSToString(HWND hInst, WORD wPosition, LPSTR lpData, WORD wLength);
    _WDW WD_CopyStringToField(HWND hInst, WORD wPosition, LPSTR lpData);
    _WDW WD_CopyStringToPS(HWND hInst, WORD wPosition, LPSTR lpData, WORD wLength);
    _WDW WD_DeletePS(HWND hInst, LPSTR lpShortName);
    _WDW WD_DisconnectPS(HWND hInst);
    _WDW WD_DisplayCursor(HWND hInst, WORD wPosition, LPSTR lpData);
    _WDW WD_DisplayPS(HWND hInst, LPSTR lpShortName);
    _WDW WD_FindFieldLength(HWND hInst, LPWORD lpLocation, WORD wPosition, LPSTR lpData);
    _WDW WD_FindFieldPosition(HWND hInst, LPWORD lpLocation, WORD wPosition, LPSTR lpData);
    _WDW WD_GetKey(HWND hInst, LPSTR lpData);
    _WDH WD_GetSessionHWND(HWND hMyInst);
    _WDW WD_Pause(HWND hInst, WORD wDuration);
    _WDW WD_PostInterceptStatus(HWND hInst, LPSTR lpData);
    _WDW WD_QueryCursorLocation(HWND hInst, LPWORD lpLocation);
    _WDW WD_QueryFieldAttribute(HWND hInst, LPWORD lpLocation, WORD wPosition);
    _WDW WD_QueryHostUpdate(HWND hInst, LPSTR lpPSId);
    _WDW WD_QuerySessionStatus(HWND hInst, LPSTR lpData);
    _WDW WD_QuerySessions(HWND hInst, LPWORD lpNumSess, PHLLQSESSION lpSessions);
    _WDW WD_QuerySystem(HWND hInst, LPSTR lpData);
    _WDW WD_ReceiveFile(HWND hInst, LPSTR lpData);
    _WDW WD_Release(HWND hInst);
    _WDW WD_Reserve(HWND hInst);
    _WDW WD_ResetSystem(HWND hInst);
    _WDW WD_RunProfile(LPSTR lpProfile, WORD wSWConst);
    _WDW WD_SearchField(HWND hInst, LPWORD lpLocation, WORD wPosition, LPSTR lpTarget);
    _WDW WD_SearchPS(HWND hInst, LPWORD lpLocation, WORD wPosition, LPSTR lpTarget);
    _WDW WD_SendFile(HWND hInst, LPSTR lpData);
    _WDW WD_SendKey(HWND hInst, LPSTR lpData);
    _WDW WD_SetCursor(HWND hInst, WORD wPosition);
    _WDW WD_SetSessionParameters(HWND hInst, DWORD dwParams);
    _WDB WD_ShowSession(HWND hInst, WORD wSWConst);
    _WDW WD_StartHostNotification(HWND hInst, LPSTR lpData);
    _WDW WD_StartKSIntercept(HWND hInst, LPSTR lpData);
    _WDW WD_StopHostNotification(HWND hInst, LPSTR lpPSId);
    _WDW WD_StopKSIntercept(HWND hInst, LPSTR lpShortName);
    _WDW WD_Wait(HWND hInst);
	_WDW WD_QueryWindowCoordinates(HWND hWnd, LPSTR pStr) ;
	_WDW WD_DisconnectWindowServices(HWND hWnd, LPSTR pStr) ;
	_WDW WD_ConnectWindowServices(HWND hWnd, LPSTR pStr) ;
	_WDW WD_ChangeWindowName(HWND hWnd, LPSTR pStr1, BYTE b, LPSTR pStr2) ;
	_WDW WD_QueryBlockLocation(HWND hWnd, LPPOINT pPoint) ;
	_WDW WD_CopyBlockToString(HWND hWnd, WORD w1, WORD w2, LPSTR pStr) ;
	_WDW WD_RunMacro(HWND hWnd, LPSTR pStr) ;
	_WDW WD_SetSessionParamEx(HWND hWnd, LPSTR pStr) ;
	_WDW WD_StartKSInterceptAsync(HWND hWnd, LPSTR pStr) ;
	_WDW WD_WindowStatus(HWND hWnd, LPSTR pStr) ;
	_WDW WD_StopCloseIntercept(HWND, LPSTR);
	_WDW WD_StartCloseIntercept(HWND, LPSTR);
	_WDW WD_QueryCloseIntercept(HWND, LPSTR);

#ifdef __cplusplus
}    /* end of extern "C" */
#endif

#endif /* _EHLLAPI_H */
