//$Id: //ribm/12.0/dev/ehllapi/whllapi.h#1 $
#ifndef _WHLLAPI_H
#define _WHLLAPI_H

/*------------------------------------------------------------------------
 * Name..........Whllapi.h
 * Description...Deliverable definitions and declarations for
 *               WinHLLAPI specification
 * Language......C, C++
 * Designer......Bhushan Khanal
 * Created.......Mar 27, 1997
 * Copyright.....(c) 1997 WRQ Inc.
 *------------------------------------------------------------------------
 */

#include <windows.h>

/*------------------------------------------------------------------------
 * 32- and 16- bit portability issues
 *------------------------------------------------------------------------
 */
#ifdef _EXPORT
    #undef _EXPORT
#endif

#ifdef WIN32
#define _EXPORT _stdcall
#else
#define _EXPORT FAR PASCAL _export
#endif

/*------------------------------------------------------------------------
 * Terminology note.
 * In the WinHLLAPI code, and all things relating to it, 
 *
 *     "session" refers to a period during which an application interacts
 *         with an instance of a 3270/5250 emulator. It does NOT refer to a
 *         "terminal session", i.e., a period during which an emulator is 
 *         connected to a host.
 *
 *         "instance" refers to an instance of a 3270/5250 emulator.
 *------------------------------------------------------------------------
 */
#define MAXHLLAPI           8
#define MAXPSIDLONGNAME     8
#define MAXPSIDSHORTNAME    1
#define MAXPSWINDOWNAME		61
/*------------------------------------------------------------------------
 * Typedefs
 *------------------------------------------------------------------------
 */
// Function name
#define CONNECTPS                      1
#define DISCONNECTPS                   2
#define SENDKEY                        3
#define WAIT                           4
#define COPYPS                         5
#define SEARCHPS                       6
#define QUERYCURSORLOC                 7
#define COPYPSTOSTR                    8
#define SETSESSIONPARAMETERS           9
#define QUERYSESSIONS                 10
#define RESERVE                       11
#define RELEASE                       12
#define COPYOIA                       13
#define QUERYFIELDATTRIBUTE           14
#define COPYSTRTOPS                   15
#define PAUSE                         18
#define QUERYSYSTEM                   20
#define RESETSYSTEM                   21
#define QUERYSESSIONSTATUS            22
#define STARTHOSTNOTIFICATION         23
#define QUERYHOSTUPDATE               24
#define STOPHOSTNOTIFICATION          25
#define SEARCHFIELD                   30
#define FINDFIELDPOSITION             31
#define FINDFIELDLENGTH               32
#define COPYSTRINGTOFIELD             33
#define COPYFIELDTOSTRING             34
#define DISPLAYCURSOR                 37
#define DISPLAYPS                     38
#define DELETEPS                      39
#define SETCURSOR                     40
#define STARTCLOSEINTERCEPT           41
#define QUERYCLOSEINTERCEPT           42
#define STOPCLOSEINTERCEPT            43
#define STARTKSINTERCEPT              50
#define GETKEY                        51
#define POSTINTERCEPTSTATUS           52
#define STOPKSINTERCEPT               53
#define SENDFILE                      90
#define RECEIVEFILE                   91
#define CONVERT                       99
#define CONNECTWINDOWSERVICES        101
#define DISCONNECTWINDOWSERVICES     102
#define QUERYWINDOWCOORDINATES       103
#define WINDOWSTATUS                 104
#define CHANGEPSNAME                 105
#define CONNECTSTRFLDS               120
#define DISCONSTRFLDS                121
#define QUERYCOMMBUFSIZ              122
#define ALLOCCOMMBUFF                123
#define FREECOMMBUFF                 124
#define GETREQUESTCOMP               125
#define READSTRFLDS                  126
#define WRITESTRFLDS                 127
#define RUNPROFILE                  1000 
#define GETSESSIONHWND              1002 

// SetSessionParameters definitions
#define WHLL_SSP_NEWRET         (DWORD)0x00000001
#define WHLL_SSP_OLDRET         (DWORD)0x00000002
#define WHLL_SSP_ATTRB          (DWORD)0x00000004
#define WHLL_SSP_NOATTRB        (DWORD)0x00000008
#define WHLL_SSP_NWAIT          (DWORD)0x00000010
#define WHLL_SSP_LWAIT          (DWORD)0x00000020
#define WHLL_SSP_TWAIT          (DWORD)0x00000040
#define WHLL_SSP_EAB            (DWORD)0x00000080
#define WHLL_SSP_NOEAB          (DWORD)0x00000100
#define WHLL_SSP_AUTORESET      (DWORD)0x00000200
#define WHLL_SSP_NORESET        (DWORD)0x00000400
#define WHLL_SSP_CONPHYS        (DWORD)0x00000800
#define WHLL_SSP_SRCHALL        (DWORD)0x00001000
#define WHLL_SSP_SRCHFROM       (DWORD)0x00002000
#define WHLL_SSP_SRCHFRWD       (DWORD)0x00004000
#define WHLL_SSP_SRCHBKWD       (DWORD)0x00008000
#define WHLL_SSP_FPAUSE         (DWORD)0x00010000
#define WHLL_SSP_IPAUSE         (DWORD)0x00020000
#define WHLL_SSP_XLATE          (DWORD)0x00040000
#define WHLL_SSP_NOXLATE        (DWORD)0x00080000
#define WHLL_SSP_CONLOG         (DWORD)0x00100000
#define WHLL_SSP_DEFESC         (DWORD)0x40000000

//------------------------------------------------------------------------
// Convert Row or Column definitions
#define WHLL_CONVERT_POSITION               'P'
#define WHLL_CONVERT_ROW                    'R'

//------------------------------------------------------------------------
// Change PS Name definitions
#define WHLL_CHANGEPSNAME_SET               0x01
#define WHLL_CHANGEPSNAME_RESET             0x02

//------------------------------------------------------------------------
// Window Status definitions
#define WHLL_WINDOWSTATUS_SET               0x01
#define WHLL_WINDOWSTATUS_QUERY             0x02
#define WHLL_WINDOWSTATUS_EXTQUERY          0x03

#define WHLL_WINDOWSTATUS_NULL              0x0000
#define WHLL_WINDOWSTATUS_SIZE              0x0001
#define WHLL_WINDOWSTATUS_MOVE              0x0002
#define WHLL_WINDOWSTATUS_ZORDER            0x0004
#define WHLL_WINDOWSTATUS_SHOW              0x0008
#define WHLL_WINDOWSTATUS_HIDE              0x0010
#define WHLL_WINDOWSTATUS_ACTIVATE          0x0080
#define WHLL_WINDOWSTATUS_DEACTIVATE        0x0100
#define WHLL_WINDOWSTATUS_MINIMIZE          0x0400
#define WHLL_WINDOWSTATUS_MAXIMIZE          0x0800
#define WHLL_WINDOWSTATUS_RESTORE           0x1000

#define WHLL_WINDOWSTATUS_FRONT      (DWORD)0x00000003
#define WHLL_WINDOWSTATUS_BACK       (DWORD)0x00000004



#define WHLLOK                    0  // Successful
#define WHLLNOTCONNECTED          1  // Not Connected To Presentation Space
#define WHLLPARAMETERERROR        2  // Parameter Error/Invalid Function
#define WHLLFTXCOMPLETE           3  // File Transfer Complete
#define WHLLFTXSEGMENTED          4  // File Transfer Complete / segmented
#define WHLLPSBUSY                4  // Presentation Space is Busy
#define WHLLINHIBITED             5  // Inhibited/Keyboard Locked
#define WHLLTRUNCATED             6  // Data Truncated
#define WHLLPOSITIONERROR         7  // Invalid Presentation Space Position
#define WHLLNOTAVAILABLE          8  // Unavailable Operation
#define WHLLSYSERROR              9  // System Error
#define WHLLNOTSUPPORTED         10  // Function Not Supported
#define WHLLUNAVAILABLE          11  // Resource is unavailable
#define WHLLPSENDED              12  // The session was stopped
#define WHLLUNDEFINEDKEY         20  // Undefined Key Combination
#define WHLLOIAUPDATE            21  // OIA Updated
#define WHLLPSUPDATE             22  // PS Updated
#define WHLLBOTHUPDATE           23  // Both PS And OIA Updated
#define WHLLNOFIELD              24  // No Such Field Found
#define WHLLNOKEYSTROKES         25  // No Keystrokes are available
#define WHLLPSCHANGED            26  // PS or OIA changed
#define WHLLFTXABORTED           27  // File transfer aborted
#define WHLLZEROLENFIELD         28  // Field length is zero
#define WHLLKEYOVERFLOW          31  // Keystroke overflow
#define WHLLSFACONN              32  // Other application already connected
#define WHLLTRANCANCLI           34  // Message sent inbound to host cancelled
#define WHLLTRANCANCL            35  // Outbound trans from host cancelled
#define WHLLHOSTCLOST            36  // Contact with host was lost
#define WHLLOKDISABLED           37  // The function was successful
#define WHLLNOTCOMPLETE          38  // The requested fn was not completed
#define WHLLSFDDM                39  // One DDM session already connected
#define WHLLSFDPEND              40  // Disconnected w async requests pending
#define WHLLBUFFINUSE            41  // Specified buffer currently in use
#define WHLLNOMATCH              42  // No matching request found
#define WHLLLOCKERROR			 43  // API already locked or unlocked	

#define WHLLINVALIDFUNCTIONNUM  301  // Invalid function number
#define WHLLFILENOTFOUND        302  // File Not Found
#define WHLLACCESSDENIED        305  // Access Denied
#define WHLLMEMORY              308  // Insufficient Memory
#define WHLLINVALIDENVIRONMENT  310  // Invalid environment
#define WHLLINVALIDFORMAT       311  // Invalid format

#define WHLLINVALIDPSID        9998  // Invalid Presentation Space ID
#define WHLLINVALIDRC          9999  // Invalid Row or Column Code

//------------------------------------------------------------------------
// Windows HLLAPI Extensions Return Codes 
#define WHLLALREADY          0xF000  // An async call is already outstanding
#define WHLLINVALID          0xF001  // Async Task Id is invalid
#define WHLLCANCEL           0xF002  // Blocking call was cancelled
#define WHLLSYSNOTREADY      0xF003  // Underlying subsystem not started
#define WHLLVERNOTSUPPORTED  0xF004  // Application version not supported

/****** Windows HLLAPI structure ********************************************/

#define WHLLDESCRIPTION_LEN	127

typedef struct tagWHLLAPIDATA {
	WORD	wVersion;
	char	szDescription[WHLLDESCRIPTION_LEN+1];
} WHLLAPIDATA, * PWHLLAPIDATA, FAR * LPWHLLAPIDATA;

#ifdef __cplusplus
	extern "C"
{
#endif

/****** Windows HLLAPI Function Prototypes **********************************/

extern void WINAPI WinHLLAPI(LPWORD, LPSTR, LPWORD, LPWORD);
extern HANDLE WINAPI WinHLLAPIAsync(HWND, LPWORD, LPSTR, LPWORD, LPWORD);
extern BOOL WINAPI WinHLLAPICleanup(void);
extern BOOL WINAPI WinHLLAPIIsBlocking(void);
extern int WINAPI WinHLLAPICancelAsyncRequest(HANDLE, WORD);
extern int WINAPI WinHLLAPICancelBlockingCall(void);
extern int WINAPI WinHLLAPIStartup(WORD, LPWHLLAPIDATA);
extern FARPROC WINAPI WinHLLAPISetBlockingHook(FARPROC);
extern BOOL WINAPI WinHLLAPIUnhookBlockingHook(void);

#ifdef __cplusplus
}
#endif

#endif	// _WHLLAPI_H
