/* REXX */

/*********************************************************/
/*                                                       */
/* WRQMAIL - Send PROFS/OfficeVision mail to client MAPI */
/*           provider.                                   */
/*                                                       */
/* Invocation -                                          */
/*                                                       */
/*                               +--CC=YES---------+     */
/*   >>--WRQMAIL <FN> <FT> <FM>--|                 |-->< */
/*                               +--CC=--YES-------+     */
/*                                     +-MACHINE-+       */
/*                                     +-NO------+       */
/* Options -                                             */
/*                                                       */
/*   CC=YES     - treat the first character of each line */
/*                as ANSI carriage control. (default)    */
/*                                                       */
/*   CC=MACHINE - treat the first character of each line */
/*                as machine carriage control.           */
/*                                                       */
/*   CC=NO      - don't treat the first character of     */
/*                each line as carriage control.         */
/*                                                       */
/*********************************************************/

Address Command

Arg ProfsFileName ProfsFileType ProfsFileMode Options .

'VMFCLEAR'

EraseWriteAlternate='C000'x
'PIPE var EraseWriteAlternate | Fullscreen Noread NoClose | Hole'

Select
 When WordPos('CC=NO',Options) > 0 Then
  CarriageControl = '00'x
 When WordPos('CC=MACHINE',Options) > 0 Then
  CarriageControl = '02'x
 Otherwise
  CarriageControl = '01'x
End

WSF='20'x
EW='C0'x
WCC='03'x
SBA='11'x
IC='13'x
SF='1D'x
AttributeProtect='28'x
AttributeUnprotect='00'x

PromptData='4000'x||'F5'x ||WCC||SBA ||'0000'x||SF||AttributeUnprotect||IC
DestOrgData='0F02'x || '0000'x || '0001'x
SignalData='0001'x || ProfsFileName || '40'x || ProfsFileType || '40'x || ProfsFileMode || '00'x || 'profs.txt' || '00'x

OutputDatastream=WSF
OutputDatastream=OutputDataStream||D2C(Length(PromptData)+2,2)||PromptData
OutputDatastream=OutputDataStream||D2C(Length(DestOrgData)+2,2)||DestOrgData
OutputDatastream=OutputDataStream||D2C(Length(SignalData)+2+2,2)||SignalData
OutputDatastream=OutputDataStream||CarriageControl||'02'x

'PIPE var OutputDatastream | Fullscreen NoClose | var InputDatastream'

Parse Upper Var InputDatastream . 'IND$FILE' TransferArguments

'IND$FILE' TransferArguments

Return 0
