/* REXX */

/*****************************************************/
/*                                                   */
/* WRQPRINT - Print CMS files and Profs/OfficeVision */
/*            documents, notes, calendars and logs   */
/*            through Reflection terminal session.   */
/*                                                   */
/* Invocation -                                      */
/*                                                   */
/*                                +--CC=YES----+     */
/*   >>--WRQPRINT <FN> <FT> <FM>--|            |-->< */
/*                                +--CC=--YES--+     */
/*                                      +-NO--+      */
/*                                      +-PS--+      */
/* Options -                                         */
/*                                                   */
/*   CC=YES - treat the first character of each line */
/*            as carriage control. (default)         */
/*                                                   */
/*   CC=NO  - don't treat the first character of     */
/*            each line as carriage control.         */
/*                                                   */
/*   CC=PS  - file is postscript                     */
/*                                                   */
/*****************************************************/

Address Command

Arg ProfsFileName ProfsFileType ProfsFileMode Options .

If ProfsFileName = '?' | ProfsFileName = '' | ProfsFileType = '' Then
Do
    Say 'WRQPRINT - Print CMS files and Profs/OfficeVision'
    Say '           documents, notes, calendars and logs'
    Say '           through Reflection terminal session.'
    Say ''
    Say '  WRQPRINT <filename> <filetype> <filemode> <CCoption>'
    Say '  '
    Say '  <CCoption> = '
    Say '     CC=YES    file contains ASA carriage control'
    Say '                    characters (default)   '
    Say '     CC=NO     file contains no carriage control'
    Say '                     characters                 '
    Say '     CC=PS     file is in postscript format'
    Say ''
    Exit(1)
End

'VMFCLEAR'

EraseWriteAlternate='C000'x
'PIPE var EraseWriteAlternate | Fullscreen Noread NoClose | Hole'

If WordPos('CC=NO',Options) > 0 Then
  CarriageControl = '00'x
Else If WordPos('CC=PS',Options) > 0 Then
    CarriageControl = '04'x
Else
  CarriageControl = '01'x

WSF='20'x
EW='C0'x
WCC='03'x
SBA='11'x
IC='13'x
SF='1D'x
AttributeProtect='28'x
AttributeUnprotect='00'x

PromptData='4000'x||'F5'x ||WCC||SBA ||'0000'x||SF||AttributeUnprotect||IC
DestOrgData='0F02'x || '0000'x || '0001'x
SignalData='0001'x || ProfsFileName || '40'x || ProfsFileType || '40'x || ProfsFileMode || '00'x || 'profs.txt' || '00'x

OutputDatastream=WSF
OutputDatastream=OutputDataStream||D2C(Length(PromptData)+2,2)||PromptData
OutputDatastream=OutputDataStream||D2C(Length(DestOrgData)+2,2)||DestOrgData
OutputDatastream=OutputDataStream||D2C(Length(SignalData)+2+1,2)||SignalData
OutputDatastream=OutputDataStream||CarriageControl

'PIPE var OutputDatastream | Fullscreen NoClose | var InputDatastream'

Parse Upper Var InputDatastream . 'IND$FILE' TransferArguments

'IND$FILE' TransferArguments

Return 0
