<?xml version="1.0"?>
<xsl:stylesheet	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:template match="/">
<xsl:text>' This VBA Macro was generated by applying XSL transform (RibmXMLtoVBA.xsl) 
' to a Ribm XML settings file
'
Sub CommandsfromXMLSettings()

	' Set Reflection Settings

	With Session</xsl:text>
	<xsl:apply-templates/><xsl:text>
	End With
End Sub</xsl:text>
</xsl:template>


<xsl:template match = "STRING">
	<xsl:text>"</xsl:text>
	<xsl:call-template name="DOUBLEQUOTES">
		<xsl:with-param name="string">
			<xsl:value-of select="."/>
		</xsl:with-param>
	</xsl:call-template>
	<xsl:text>"</xsl:text>
	<xsl:if test="not(position()=last()-1)">
	<xsl:text>, </xsl:text>
	</xsl:if>
</xsl:template>

<!-- DOUBLEQUOTES Explanation
Within a STRING any double quote needs to be doubled
For example, the SetRecentlyUsedFile command can have 
a command as one parameter where the path is quoted. 

"SaveSettings rcXMLSettingsFile, rcOverwrite, "e:\JUNK.XML""
becomes
"SaveSettings rcXMLSettingsFile, rcOverwrite, ""e:\JUNK.XML"""
-->

<xsl:template name="DOUBLEQUOTES">
	<xsl:param name="string" />
	<xsl:if test="contains($string, '&#x22;')">
		<xsl:value-of select="substring-before($string, '&#x22;')" />
			<xsl:text>&#x22;&#x22;</xsl:text>
		<xsl:call-template name="DOUBLEQUOTES">
	                <xsl:with-param name="string">
	                	<xsl:value-of select="substring-after($string, '&#x22;')" />
	                </xsl:with-param>
	        </xsl:call-template>
	</xsl:if>
	<xsl:if test="not(contains($string, '&#x22;'))">
		<xsl:value-of select="$string" />
	</xsl:if>
</xsl:template>

<xsl:template match = "INT">
	<xsl:value-of select="."/>
	<xsl:if test="not(position()=last()-1)">
	<xsl:text>, </xsl:text>
	</xsl:if>
</xsl:template>

<xsl:template match = "BOOL">
	<xsl:choose>
		<xsl:when test=".='true'">
			<xsl:text>rcYes</xsl:text>
		</xsl:when>	
		<xsl:when test=".='false'">
			<xsl:text>rcNo</xsl:text>	
		</xsl:when>
	</xsl:choose>
	<xsl:if test="not(position()=last()-1)">
	<xsl:text>, </xsl:text>
	</xsl:if>
</xsl:template>


<xsl:template match="COMMAND">
	<!-- exclude read-only settings -->
	<xsl:if test="(INT[1]!='rcMaxDebugFilelength' and
				  INT[1]!='rcSettingsFileUpdate' and
				  INT[1]!='rcAssignedAS400' and
				  INT[1]!='rcTelnetKeepAliveAverage') or 
				  count(INT) = 0">
		.<xsl:value-of select="@name"/><xsl:text> </xsl:text>
		<xsl:apply-templates/>
	</xsl:if>
</xsl:template>


<xsl:template match="text()|@*"/>
</xsl:stylesheet>