<?xml version="1.0"?>
<xsl:stylesheet	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- RibmXMLtoRSF.xslimp   Converts XML settings file to Ribm Settings file (.RSF)-->
<!--   $Id: //ribm/12.0/dev/r8supprt/xml/ribmxmltorsf.xslimp#1 $ -->

<xsl:template match="/">
	<xsl:text>' v10.0 - Reflection IBM Settings File
' This Settings file was generated by applying XSL transform (RibmXMLtoRSF.xsl)
' to a Ribm XML settings file</xsl:text> 
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match = "STRING">
	<xsl:text>"</xsl:text>
	<xsl:call-template name="EUROREPLACE">
		<xsl:with-param name="string">
			<xsl:call-template name="DOUBLEQUOTES">
				<xsl:with-param name="string">
					<xsl:value-of select="."/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:with-param>
	</xsl:call-template>
	<xsl:text>"</xsl:text>
	<xsl:if test="not(position()=last()-1)">
	<xsl:text>, </xsl:text>
	</xsl:if>
</xsl:template>

<xsl:template name="EUROREPLACE">
<!-- substitute a ANSI EURO character 0x80 instead of the UTF-8 Euro character 0xE282AC
     which can also be written as Unicode character 0x20AC -->
	<xsl:param name="string" />
	<xsl:if test="contains($string, '&#x20AC;')">
		<xsl:value-of select="substring-before($string, '&#x20AC;')" />
		<xsl:text>&#x80;</xsl:text>
		<xsl:call-template name="EUROREPLACE">
	                <xsl:with-param name="string">
	                	<xsl:value-of select="substring-after($string, '&#x20AC;')" />
	                </xsl:with-param>
	        </xsl:call-template>
	</xsl:if>
	<xsl:if test="not(contains($string, '&#x20AC;'))">
		<xsl:value-of select="$string" />
	</xsl:if>
</xsl:template>

<!-- DOUBLEQUOTES Explanation
Within a STRING any double quote needs to be doubled
For example, the SetRecentlyUsedFile command can have 
a command as one parameter where the path is quoted. 

"SaveSettings rcXMLSettingsFile, rcOverwrite, "e:\JUNK.XML""
becomes
"SaveSettings rcXMLSettingsFile, rcOverwrite, ""e:\JUNK.XML"""
-->

<xsl:template name="DOUBLEQUOTES">
	<xsl:param name="string" />
	<xsl:if test="contains($string, '&#x22;')">
		<xsl:value-of select="substring-before($string, '&#x22;')" />
			<xsl:text>&#x22;&#x22;</xsl:text>
		<xsl:call-template name="DOUBLEQUOTES">
	                <xsl:with-param name="string">
	                	<xsl:value-of select="substring-after($string, '&#x22;')" />
	                </xsl:with-param>
	        </xsl:call-template>
	</xsl:if>
	<xsl:if test="not(contains($string, '&#x22;'))">
		<xsl:value-of select="$string" />
	</xsl:if>
</xsl:template>

<xsl:template match = "INT">
	<xsl:value-of select="."/>
	<xsl:if test="not(position()=last()-1)">
	<xsl:text>, </xsl:text>
	</xsl:if>
</xsl:template>

<xsl:template match = "BOOL">
	<xsl:choose>
		<xsl:when test=".='true'">
			<xsl:text>rcYes</xsl:text>
		</xsl:when>	
		<xsl:when test=".='false'">
			<xsl:text>rcNo</xsl:text>	
		</xsl:when>
	</xsl:choose>
	<xsl:if test="not(position()=last()-1)">
	<xsl:text>, </xsl:text>
	</xsl:if>
</xsl:template>


<xsl:template match="COMMAND">
.<xsl:value-of select="@name"/><xsl:text> </xsl:text>
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="text()|@*"/>


</xsl:stylesheet>