<?xml version="1.0"?>
<xsl:stylesheet	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="xml" encoding="UTF-8" indent="yes"/>


<!--  ribmxmltorweb.xsl  Transform settings from "Reflection for IBM" into "Reflection for the Web" -->
<!--  $Id: //ribm/12.0/dev/r8supprt/xml/ribmxmltorweb.xsl#2 $ -->

<xsl:template match="/">
	<xsl:call-template name = "CREATE_HEADER_COMMENT"/>
	<xsl:element name = "REFLECTION_WEB">
		<xsl:element name = "XML_STORE">
			<xsl:call-template name="PROPERTIES"/>			
			<xsl:element name = "CONTAINERS">
			<xsl:variable name="terminaltype">
				<xsl:call-template name="TERMINALTYPE"/>
			</xsl:variable>	
			<xsl:choose>
				<xsl:when test="$terminaltype = 'ibm3270'">
					<xsl:call-template name = "COLORDISPLAYMAP"/>
					<xsl:call-template name = "PERSISTENCESERVICE"/>
					<xsl:call-template name = "BLOCKTD"/>
					<xsl:call-template name = "FILEXFERSERVICE"/>
					<xsl:call-template name = "INDFILETRANSFER"/>
					<xsl:call-template name = "HOTSPOTSERVICEIBM3270"/>
					<xsl:call-template name = "IBM3270"/>
					<xsl:call-template name = "MOUSEMAPPERSERVICE"/>
					<xsl:call-template name = "PRINTERSERVICE"/>
					<xsl:call-template name = "SESSION"/>
					<xsl:call-template name = "BLOCKTISB"/>
					<xsl:call-template name = "TRANSPORTOPTIONS"/>
					<xsl:call-template name = "KEYMAP4"/>
					<xsl:call-template name = "MAPPERENGINE1"/>
					<xsl:call-template name = "PRESENTATIONMANAGER3"/>
				</xsl:when>
				<xsl:when test="$terminaltype = 'ibm3287'">
					<xsl:call-template name = "PERSISTENCESERVICE"/>
					<xsl:call-template name = "IBM3287"/>
					<xsl:call-template name = "MOUSEMAPPERSERVICE"/>
					<xsl:call-template name = "PRINTERSERVICE"/>
					<xsl:call-template name = "SESSION"/>
					<xsl:call-template name = "BLOCKTISB"/>
					<xsl:call-template name = "TRANSPORTOPTIONS"/>
					<xsl:call-template name = "PRESENTATIONMANAGER3"/>
				</xsl:when>
				<xsl:when test="$terminaltype = 'ibm5250'">
					<xsl:call-template name = "COLORDISPLAYMAP"/>
					<xsl:call-template name = "PERSISTENCESERVICE"/>
					<xsl:call-template name = "BLOCKTD"/>
					<xsl:call-template name = "HOTSPOTSERVICEIBM5250"/>
					<xsl:call-template name = "IBM5250"/>
					<xsl:call-template name = "MOUSEMAPPERSERVICE"/>
					<xsl:call-template name = "PRINTERSERVICE"/>
					<xsl:call-template name = "SESSION"/>
					<xsl:call-template name = "BLOCKTISB"/>
					<xsl:call-template name = "TRANSPORTOPTIONS"/>
					<xsl:call-template name = "KEYMAP4"/>
					<xsl:call-template name = "MAPPERENGINE1"/>
					<xsl:call-template name = "PRESENTATIONMANAGER3"/>
				</xsl:when>
				<xsl:when test="$terminaltype = 'ibm3812'">
					<xsl:call-template name = "PERSISTENCESERVICE"/>
					<xsl:call-template name = "IBM3812"/>
					<xsl:call-template name = "MOUSEMAPPERSERVICE"/>
					<xsl:call-template name = "PRINTERSERVICE"/>
					<xsl:call-template name = "SESSION"/>
					<xsl:call-template name = "TRANSPORTOPTIONS"/>
					<xsl:call-template name = "PRESENTATIONMANAGER3"/>
				</xsl:when>
			</xsl:choose>
			</xsl:element>
		</xsl:element>
	</xsl:element>
</xsl:template>

<xsl:template name = "CREATE_HEADER_COMMENT" >
	<xsl:comment>
		<xsl:text>	Reflection Settings (XML format </xsl:text>
		<xsl:value-of select="//REFLECTION_SETTINGS/@version"/>
		<xsl:text>)&#13;&#10;</xsl:text>
		<xsl:text>	Created by </xsl:text> 
		<xsl:value-of select="//REFLECTION_SETTINGS/CREATOR/@product"/>
	    <xsl:text> - version </xsl:text>
		<xsl:value-of select="//REFLECTION_SETTINGS/CREATOR/@version"/>
		<xsl:text> (build </xsl:text>
  		<xsl:value-of select="//REFLECTION_SETTINGS/CREATOR/@build"/>
		<xsl:text>)	</xsl:text>
	</xsl:comment>
</xsl:template>

<xsl:template name = "PROPERTIES" >
	<xsl:element name = "PROPERTIES">
		<xsl:element name = "PROPERTY">
			<xsl:attribute name = "NAME">
				<xsl:text>preload</xsl:text>
			</xsl:attribute>
			<xsl:text>com.wrq.ibm.display.hotspot.HotspotService com.wrq.present.pm.PresentationManager com.wrq.present.mouse.MouseMapperService com.wrq.session.Session com.wrq.display.BlockTD </xsl:text>
		</xsl:element>
		<xsl:element name = "PROPERTY">
			<xsl:attribute name = "NAME">
				<xsl:text>type</xsl:text>
			</xsl:attribute>
			<xsl:text>configuration</xsl:text>
		</xsl:element>
		<xsl:element name = "PROPERTY">
			<xsl:attribute name = "NAME">
				<xsl:text>version</xsl:text>
			</xsl:attribute>
			<xsl:text>3</xsl:text>
		</xsl:element>
		<xsl:element name = "PROPERTY">
			<xsl:attribute name = "NAME">
				<xsl:text>signature</xsl:text>
			</xsl:attribute>
			<xsl:variable name="terminaltype">
				<xsl:call-template name="TERMINALTYPE"/>
			</xsl:variable>	
			<xsl:choose>
				<xsl:when test="$terminaltype = 'ibm3270'">
					<xsl:text>IBM3270Applet v4.1</xsl:text>
				</xsl:when>
				<xsl:when test="$terminaltype = 'ibm3287'">
					<xsl:text>IBM3287Applet v4.1</xsl:text>
				</xsl:when>
				<xsl:when test="$terminaltype = 'ibm5250'">
					<xsl:text>IBM5250Applet v4.1</xsl:text>
				</xsl:when>
				<xsl:when test="$terminaltype = 'ibm3812'">
					<xsl:text>IBM3812Applet v4.1</xsl:text>
				</xsl:when>
			</xsl:choose>
		</xsl:element>
	</xsl:element>
</xsl:template>

<xsl:template name = "SESSION" >
	<xsl:element name = "CONTAINER">
		<xsl:attribute name = "NAME">
			<xsl:text>com.wrq.session.Session</xsl:text>
		</xsl:attribute>
		<xsl:element name = "CONTEXT_CHILD_STATE">
			<xsl:element name = "COMMAND_LIST">
				<xsl:attribute name = "SIZE">
					<xsl:variable name="terminaltype">
						<xsl:call-template name="TERMINALTYPE"/>
					</xsl:variable>	
					<xsl:choose>
						<xsl:when test="$terminaltype = 'ibm3270' or $terminaltype = 'ibm3287'">
							<xsl:text>4</xsl:text>
						</xsl:when>
						<xsl:when test="$terminaltype = 'ibm5250' or $terminaltype = 'ibm3812'">
							<xsl:text>3</xsl:text>
						</xsl:when>
					</xsl:choose>
				</xsl:attribute>
				<xsl:element name = "COMMAND">
					<xsl:attribute name = "NAME">
						<xsl:text>ISession.registerEmulator</xsl:text>
					</xsl:attribute>
					<xsl:element name = "OBJECT_ARRAY">
						<xsl:attribute name = "SIZE">
							<xsl:text>1</xsl:text>
						</xsl:attribute>
						<xsl:element name = "STRING">
							<xsl:call-template name = "REGISTEREMULATOR"/>
						</xsl:element>
					</xsl:element>
				</xsl:element>
					<xsl:call-template name = "REGISTERTRANSPORT"/>
				<xsl:element name = "COMMAND">
					<xsl:attribute name = "NAME">
						<xsl:text>ISession.sessionSetup</xsl:text>
					</xsl:attribute>
					<xsl:element name = "OBJECT_ARRAY">
						<xsl:attribute name = "SIZE">
							<xsl:text>3</xsl:text>
						</xsl:attribute>
						<xsl:element name = "STRING">
							<xsl:call-template name = "TERMINALTYPE"/>
						</xsl:element>
						<xsl:element name = "STRING">
							<xsl:call-template name = "TERMINALMODEL"/>
						</xsl:element>
						<xsl:element name = "STRING">
							<xsl:call-template name = "TRANSPORTTYPE"/>
						</xsl:element>
					</xsl:element>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "PROPERTY_STATE">
				<xsl:attribute name = "SIZE">
					<xsl:text>7</xsl:text>
				</xsl:attribute>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>terminalType</xsl:text>
					</xsl:attribute>
					<xsl:element name = "STRING">
						<xsl:call-template name = "TERMINALTYPE"/>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>terminalModel</xsl:text>
					</xsl:attribute>
					<xsl:element name = "STRING">
						<xsl:call-template name = "TERMINALMODEL"/>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>transportType</xsl:text>
					</xsl:attribute>
					<xsl:element name = "STRING">
						<xsl:call-template name = "TRANSPORTTYPE"/>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>autoconnect</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcAutoConnect']/BOOL"/>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>autoreconnect</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcAutoReConnect']/BOOL"/>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>hostURL</xsl:text>
					</xsl:attribute>
					<xsl:call-template name = "HOSTURL"/>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>meteringEnabled</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<!-- NOTE: Ribm doesn't have a corresponding setting
						     so this will always be set to false -->
						<xsl:text>false</xsl:text>
					</xsl:element>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:element>
</xsl:template>

<xsl:template name = "REGISTEREMULATOR">
	<xsl:variable name="terminaltype">
		<xsl:call-template name="TERMINALTYPE"/>
	</xsl:variable>	
	<xsl:choose>
		<xsl:when test="$terminaltype = 'ibm3270'">
			<xsl:text>com.wrq.ibm3270.IBM3270Factory</xsl:text>
		</xsl:when>
		<xsl:when test="$terminaltype = 'ibm3287'">
			<xsl:text>com.wrq.ibm3287.IBM3287Factory</xsl:text>
		</xsl:when>
		<xsl:when test="$terminaltype = 'ibm5250'">
			<xsl:text>com.wrq.ibm5250.IBM5250Factory</xsl:text>
		</xsl:when>
		<xsl:when test="$terminaltype = 'ibm3812'">
			<xsl:text>com.wrq.ibm3812.IBM3812Factory</xsl:text>
		</xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template name = "REGISTERTRANSPORT">
	<xsl:variable name="terminaltype">
		<xsl:call-template name="TERMINALTYPE"/>
	</xsl:variable>	
	<xsl:if test="$terminaltype = 'ibm3270' or $terminaltype = 'ibm3287'">
		<xsl:element name = "COMMAND">
			<xsl:attribute name = "NAME">
				<xsl:text>ISession.registerTransport</xsl:text>
			</xsl:attribute>
			<xsl:element name = "OBJECT_ARRAY">
				<xsl:attribute name = "SIZE">
					<xsl:text>1</xsl:text>
				</xsl:attribute>
				<xsl:element name = "STRING">
					<xsl:text>tn3270e</xsl:text>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:if>
	<xsl:if test="$terminaltype = 'ibm3270'">
		<xsl:element name = "COMMAND">
			<xsl:attribute name = "NAME">
				<xsl:text>ISession.registerTransport</xsl:text>
			</xsl:attribute>
			<xsl:element name = "OBJECT_ARRAY">
				<xsl:attribute name = "SIZE">
					<xsl:text>1</xsl:text>
				</xsl:attribute>
				<xsl:element name = "STRING">
					<xsl:text>tn3270</xsl:text>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:if>
	<xsl:if test="$terminaltype = 'ibm3287'">
		<xsl:element name = "COMMAND">
			<xsl:attribute name = "NAME">
				<xsl:text>ISession.registerTransport</xsl:text>
			</xsl:attribute>
			<xsl:element name = "OBJECT_ARRAY">
				<xsl:attribute name = "SIZE">
					<xsl:text>1</xsl:text>
				</xsl:attribute>
				<xsl:element name = "STRING">
					<xsl:text>tn3287</xsl:text>
				</xsl:element>
			</xsl:element>
		</xsl:element>											
	</xsl:if>
	<xsl:if test="$terminaltype = 'ibm3812' or $terminaltype = 'ibm5250'">
		<xsl:element name = "COMMAND">
			<xsl:attribute name = "NAME">
				<xsl:text>ISession.registerTransport</xsl:text>
			</xsl:attribute>
			<xsl:element name = "OBJECT_ARRAY">
				<xsl:attribute name = "SIZE">
					<xsl:text>1</xsl:text>
				</xsl:attribute>
				<xsl:element name = "STRING">
					<xsl:text>tn5250</xsl:text>
				</xsl:element>
			</xsl:element>
		</xsl:element>											
	</xsl:if>
</xsl:template>


<xsl:template name = "TERMINALTYPE">
	<xsl:choose>
	<xsl:when test="//SESSION/COMMAND/INT='rc3270Terminal'">
		<xsl:text>ibm3270</xsl:text>
	</xsl:when>
	<xsl:when test="//SESSION/COMMAND/INT='rc5250Terminal'">
		<xsl:text>ibm5250</xsl:text>
	</xsl:when>
	<xsl:when test="//SESSION/COMMAND/INT='rc3270Printer'">
		<xsl:text>ibm3287</xsl:text>
	</xsl:when>
	<xsl:when test="//SESSION/COMMAND/INT='rc5250Printer'">
		<xsl:text>ibm3812</xsl:text>
	</xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template name = "TERMINALMODEL">
	<xsl:choose>
	<xsl:when test="//SESSION/COMMAND[@name='SetupSession']/INT='rc3270MODEL2'">
		<xsl:text>2</xsl:text>
	</xsl:when>	
	<xsl:when test="//SESSION/COMMAND[@name='SetupSession']/INT='rc3270MODEL2E'">
		<xsl:text>2E</xsl:text>
	</xsl:when>	
	<xsl:when test="//SESSION/COMMAND[@name='SetupSession']/INT='rc3270MODEL3'">
		<xsl:text>3</xsl:text>
	</xsl:when>	
	<xsl:when test="//SESSION/COMMAND[@name='SetupSession']/INT='rc3270MODEL3E'">
		<xsl:text>3E</xsl:text>
	</xsl:when>	
	<xsl:when test="//SESSION/COMMAND[@name='SetupSession']/INT='rc3270MODEL4'">
		<xsl:text>4</xsl:text>
	</xsl:when>	
	<xsl:when test="//SESSION/COMMAND[@name='SetupSession']/INT='rc3270MODEL4E'">
		<xsl:text>4E</xsl:text>
	</xsl:when>	
	<xsl:when test="//SESSION/COMMAND[@name='SetupSession']/INT='rc3270MODEL5'">
		<xsl:text>5</xsl:text>
	</xsl:when>	
	<xsl:when test="//SESSION/COMMAND[@name='SetupSession']/INT='rc3270MODEL5E'">
		<xsl:text>5E</xsl:text>
	</xsl:when>	
	<xsl:when test="//SESSION/COMMAND[@name='SetupSession']/INT='rc3287Printer'">
		<xsl:text>3287</xsl:text>	
	</xsl:when>
	<xsl:when test="//SESSION/COMMAND[@name='SetupSession']/INT='rc3287OCSPrinter'">
		<xsl:text>3287</xsl:text>	
	</xsl:when>
	<xsl:when test="//SESSION/COMMAND[@name='SetupSession']/INT='rc31792'">
		<xsl:text>3179-2</xsl:text>	
	</xsl:when>
	<xsl:when test="//SESSION/COMMAND[@name='SetupSession']/INT='rc31802'">
		<xsl:text>3180-2</xsl:text>	
	</xsl:when>
	<xsl:when test="//SESSION/COMMAND[@name='SetupSession']/INT='rc3196A1'">
		<xsl:text>3196-A1</xsl:text>	
	</xsl:when>
	<xsl:when test="//SESSION/COMMAND[@name='SetupSession']/INT='rc3477FC'">
		<xsl:text>3477-FC</xsl:text>	
	</xsl:when>
	<xsl:when test="//SESSION/COMMAND[@name='SetupSession']/INT='rc3477FG'">
		<xsl:text>3477-FG</xsl:text>	
	</xsl:when>
	<xsl:when test="//SESSION/COMMAND[@name='SetupSession']/INT='rc3486BA'">
		<xsl:text>3486-BA</xsl:text>	
	</xsl:when>
	<xsl:when test="//SESSION/COMMAND[@name='SetupSession']/INT='rc3487HA'">
		<xsl:text>3487-HA</xsl:text>	
	</xsl:when>
	<xsl:when test="//SESSION/COMMAND[@name='SetupSession']/INT='rc3487HC'">
		<xsl:text>3487-HC</xsl:text>	
	</xsl:when>
	<xsl:when test="//SESSION/COMMAND[@name='SetupSession']/INT='rc525111'">
		<xsl:text>5251-11</xsl:text>	
	</xsl:when>
	<xsl:when test="//SESSION/COMMAND[@name='SetupSession']/INT='rc52911'">
		<xsl:text>5291-2</xsl:text>	
	</xsl:when>
	<xsl:when test="//SESSION/COMMAND[@name='SetupSession']/INT='rc5555C01'">
		<!-- 5555-C01 (DBCS) model not supported by Reflection for the Web, 
		     use 3179-2 instead for now -->
		<xsl:text>3179-2</xsl:text>	
	</xsl:when>
	<xsl:when test="//SESSION/COMMAND/INT='rc5250Printer'">
		<!-- Rweb only supports 3812-1, so if we're 5250Printer use 3812-1 -->
		<xsl:text>3812-1</xsl:text>	
	</xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template name = "TRANSPORTTYPE">
	<xsl:choose>
	<xsl:when test="//SESSION/COMMAND/INT='rcTelnet' and //SESSION/COMMAND/INT='rc3270Terminal'">  
		<xsl:text>tn3270</xsl:text>
	</xsl:when>	
	<xsl:when test="//SESSION/COMMAND/INT='rcTelnet' and //SESSION/COMMAND/INT='rc3270Printer'">  
		<xsl:text>tn3287</xsl:text>	
	</xsl:when>
	<xsl:when test="//SESSION/COMMAND[@name='SetupSession' and INT[3]='rcTelnetExtended']">  
		<xsl:text>tn3270e</xsl:text>
	</xsl:when>	
	<xsl:when test="//SESSION/COMMAND/INT='rcTelnet' and //SESSION/COMMAND/INT='rc5250Terminal'">
		<xsl:text>tn5250</xsl:text>	
	</xsl:when>
	<xsl:when test="//SESSION/COMMAND/INT='rcTelnet' and //SESSION/COMMAND/INT='rc5250Printer'">
		<xsl:text>tn5250</xsl:text>	
	</xsl:when>
	<xsl:otherwise>
		<xsl:text>Transport type not supported by Reflection for the Web.</xsl:text>	
	</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name = "HOSTURL">
	<xsl:element name = "URL_STRING">
		<xsl:call-template name="TRANSPORTTYPE"/>
		<xsl:text>://</xsl:text>
		<xsl:value-of select = "//COMMAND[@name='SetString' and INT='rcHostName']/STRING"/>
		<xsl:text>:</xsl:text>
		<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT[1]='rcTelnetPort']/INT[2]"/>
	</xsl:element>	
</xsl:template>

<xsl:template name = "BLOCKTISB">
	<xsl:element name = "CONTAINER">
		<xsl:attribute name = "NAME">
			<xsl:variable name="terminaltype">
				<xsl:call-template name="TERMINALTYPE"/>
			</xsl:variable>	
			<xsl:choose>
				<xsl:when test="$terminaltype = 'ibm3270'">
					<xsl:text>com.wrq.session.BlockTISB</xsl:text>
				</xsl:when>
				<xsl:when test="$terminaltype = 'ibm5250'">
					<xsl:text>com.wrq.session.tisb.BlockTISB</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>com.wrq.session.tisb.BlockTISB</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>
		<xsl:element name = "PROPERTY_STATE">
			<xsl:attribute name = "SIZE">
				<xsl:text>3</xsl:text>
			</xsl:attribute>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>cursorShape</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">
					<xsl:variable name = "cursorshape">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcCursorShape']/INT[2]"/>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="$cursorshape = 'rcFullBlock' or $cursorshape = 'rcNoCursor'">
							<xsl:text>0</xsl:text>
						</xsl:when>
						<xsl:when test="$cursorshape = 'rcUnderLine'">
							<xsl:text>1</xsl:text>
						</xsl:when>
						<xsl:when test="$cursorshape = 'rcHighHalfBlock'">
							<xsl:text>2</xsl:text>
						</xsl:when>
						<xsl:when test="$cursorshape = 'rcLowHalfBlock'">
							<xsl:text>3</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>0</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>cursorBlinks</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:variable name = "cursorblink">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcCursorBlinkRate']/INT[2]"/>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="$cursorblink = 'rcNoBlink'">
							<xsl:text>false</xsl:text>
						</xsl:when>
						<xsl:when test="$cursorblink = 'rcSlow' or $cursorblink = 'rcMedium' or
								$cursorblink = 'rcFast' or $cursorblink = 'rcSystem'">
							<xsl:text>true</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>true</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>cursorVisible</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:variable name = "cursorshape">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcCursorShape']/INT[2]"/>
					</xsl:variable> 
					<xsl:choose>
						<xsl:when test="$cursorshape = 'rcNoCursor'">
							<xsl:text>false</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>true</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:element>
</xsl:template>

<!-- TODO: figure out what this does in Rweb. It's in all the sessions I've saved,
and I can see how it would change, so this will be in all Config files.  --> 
<xsl:template name = "PERSISTENCESERVICE">
	<xsl:element name = "CONTAINER">
		<xsl:attribute name = "NAME">
			<xsl:text>com.wrq.core.service.PersistenceService</xsl:text>
		</xsl:attribute>
		<xsl:element name = "SERIAL_WRAPPER">
			<xsl:element name = "STRING_ARRAY">
				<xsl:attribute name = "SIZE">
					<xsl:text>1</xsl:text>
				</xsl:attribute>
				<xsl:element name = "STRING">
					<xsl:text>com.wrq.core.service.IPersistable</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "NULL"/>
		</xsl:element>
	</xsl:element>	
</xsl:template>

<xsl:template name = "COLORDISPLAYMAP">
	<xsl:element name = "CONTAINER">
		<xsl:attribute name = "NAME">
			<xsl:text>ColorDisplayMap</xsl:text>
		</xsl:attribute>
		<xsl:element name = "TD_COLOR_MAP">
			<xsl:element name = "SHIFT_COUNT">
				<xsl:text>28</xsl:text>
			</xsl:element>
			<xsl:element name = "SWAPPED">
				<xsl:text>false</xsl:text>
			</xsl:element>
			<xsl:element name = "OBJECT_ARRAY">
				<xsl:attribute name = "SIZE">
					<xsl:text>16</xsl:text>
				</xsl:attribute>
				<xsl:element name = "COLOR_ARRAY">
					<xsl:attribute name = "SIZE">
						<xsl:text>2</xsl:text>
					</xsl:attribute>
					<xsl:element name = "COLOR">
						<xsl:variable name="fgcolor">
							<xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcHostBlue']/INT[2]"/>					
						</xsl:variable>
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$fgcolor"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
					<xsl:element name = "COLOR">						
						<xsl:call-template name="GETBACKGROUNDCOLOR">
							<xsl:with-param name="backgroundcolor"><xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcHostBlue']/INT[3]"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "COLOR_ARRAY">
					<xsl:attribute name = "SIZE">
						<xsl:text>2</xsl:text>
					</xsl:attribute>
					<xsl:element name = "COLOR">
						<xsl:variable name="fgcolor">
							<xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcHostRed']/INT[2]"/>					
						</xsl:variable>
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$fgcolor"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
					<xsl:element name = "COLOR">
						<xsl:call-template name="GETBACKGROUNDCOLOR">
							<xsl:with-param name="backgroundcolor"><xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcHostRed']/INT[3]"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "COLOR_ARRAY">
					<xsl:attribute name = "SIZE">
						<xsl:text>2</xsl:text>
					</xsl:attribute>
					<xsl:element name = "COLOR">
						<xsl:variable name="fgcolor">
							<xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcHostPink']/INT[2]"/>
						</xsl:variable>
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$fgcolor"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
					<xsl:element name = "COLOR">
						<xsl:call-template name="GETBACKGROUNDCOLOR">
							<xsl:with-param name="backgroundcolor"><xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcHostPink']/INT[3]"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "COLOR_ARRAY">
					<xsl:attribute name = "SIZE">
						<xsl:text>2</xsl:text>
					</xsl:attribute>
					<xsl:element name = "COLOR">
						<xsl:variable name="fgcolor">
							<xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcHostGreen']/INT[2]"/>					
						</xsl:variable>
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$fgcolor"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
					<xsl:element name = "COLOR">
						<xsl:call-template name="GETBACKGROUNDCOLOR">
							<xsl:with-param name="backgroundcolor"><xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcHostGreen']/INT[3]"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "COLOR_ARRAY">
					<xsl:attribute name = "SIZE">
						<xsl:text>2</xsl:text>
					</xsl:attribute>
					<xsl:element name = "COLOR">
						<xsl:variable name="fgcolor">
							<xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcHostTurquoise']/INT[2]"/>					
						</xsl:variable>
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$fgcolor"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
					<xsl:element name = "COLOR">
						<xsl:call-template name="GETBACKGROUNDCOLOR">
							<xsl:with-param name="backgroundcolor"><xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcHostTurquoise']/INT[3]"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "COLOR_ARRAY">
					<xsl:attribute name = "SIZE">
						<xsl:text>2</xsl:text>
					</xsl:attribute>
					<xsl:element name = "COLOR">
						<xsl:variable name="fgcolor">
							<xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcHostYellow']/INT[2]"/>					
						</xsl:variable>
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$fgcolor"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
					<xsl:element name = "COLOR">
						<xsl:call-template name="GETBACKGROUNDCOLOR">
							<xsl:with-param name="backgroundcolor"><xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcHostYellow']/INT[3]"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "COLOR_ARRAY">
					<xsl:attribute name = "SIZE">
						<xsl:text>2</xsl:text>
					</xsl:attribute>
					<xsl:element name = "COLOR">
						<xsl:variable name="fgcolor">
							<xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcHostWhite']/INT[2]"/>					
						</xsl:variable>
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$fgcolor"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
					<xsl:element name = "COLOR">
						<xsl:call-template name="GETBACKGROUNDCOLOR">
							<xsl:with-param name="backgroundcolor"><xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcHostWhite']/INT[3]"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "COLOR_ARRAY">
					<xsl:attribute name = "SIZE">
						<xsl:text>2</xsl:text>
					</xsl:attribute>
					<xsl:element name = "COLOR">
						<xsl:variable name="fgcolor">
							<xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcStatusLine']/INT[2]"/>	
						</xsl:variable>
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$fgcolor"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
					<xsl:element name = "COLOR">
						<xsl:call-template name="GETBACKGROUNDCOLOR">
							<xsl:with-param name="backgroundcolor"><xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcStatusLine']/INT[3]"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "COLOR_ARRAY">
					<xsl:attribute name = "SIZE">
						<xsl:text>2</xsl:text>
					</xsl:attribute>
					<xsl:element name = "COLOR">
						<xsl:variable name="fgcolor">
							<xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcProtNormAlpha']/INT[2]"/>					
						</xsl:variable>
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$fgcolor"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
					<xsl:element name = "COLOR">
						<xsl:call-template name="GETBACKGROUNDCOLOR">
							<xsl:with-param name="backgroundcolor"><xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcProtNormAlpha']/INT[3]"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "COLOR_ARRAY">
					<xsl:attribute name = "SIZE">
						<xsl:text>2</xsl:text>
					</xsl:attribute>
					<xsl:element name = "COLOR">
						<xsl:variable name="fgcolor">
							<xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcProtNormNum']/INT[2]"/>					
						</xsl:variable>
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$fgcolor"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
					<xsl:element name = "COLOR">
						<xsl:call-template name="GETBACKGROUNDCOLOR">
							<xsl:with-param name="backgroundcolor"><xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcProtNormNum']/INT[3]"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "COLOR_ARRAY">
					<xsl:attribute name = "SIZE">
						<xsl:text>2</xsl:text>
					</xsl:attribute>
					<xsl:element name = "COLOR">
						<xsl:variable name="fgcolor">
							<xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcProtHighAlpha']/INT[2]"/>					
						</xsl:variable>
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$fgcolor"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
					<xsl:element name = "COLOR">
						<xsl:call-template name="GETBACKGROUNDCOLOR">
							<xsl:with-param name="backgroundcolor"><xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcProtHighAlpha']/INT[3]"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "COLOR_ARRAY">
					<xsl:attribute name = "SIZE">
						<xsl:text>2</xsl:text>
					</xsl:attribute>
					<xsl:element name = "COLOR">
						<xsl:variable name="fgcolor">
							<xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcProtHighNum']/INT[2]"/>					
						</xsl:variable>
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$fgcolor"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
					<xsl:element name = "COLOR">
						<xsl:call-template name="GETBACKGROUNDCOLOR">
							<xsl:with-param name="backgroundcolor"><xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcProtHighNum']/INT[3]"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "COLOR_ARRAY">
					<xsl:attribute name = "SIZE">
						<xsl:text>2</xsl:text>
					</xsl:attribute>
					<xsl:element name = "COLOR">
						<xsl:variable name="fgcolor">
							<xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcUnprotNormAlpha']/INT[2]"/>					
						</xsl:variable>
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$fgcolor"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
					<xsl:element name = "COLOR">
						<xsl:call-template name="GETBACKGROUNDCOLOR">
							<xsl:with-param name="backgroundcolor"><xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcUnprotNormAlpha']/INT[3]"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "COLOR_ARRAY">
					<xsl:attribute name = "SIZE">
						<xsl:text>2</xsl:text>
					</xsl:attribute>
					<xsl:element name = "COLOR">
						<xsl:variable name="fgcolor">
							<xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcUnprotNormNum']/INT[2]"/>
						</xsl:variable>
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$fgcolor"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
					<xsl:element name = "COLOR">
						<xsl:call-template name="GETBACKGROUNDCOLOR">
							<xsl:with-param name="backgroundcolor"><xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcUnprotNormNum']/INT[3]"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "COLOR_ARRAY">
					<xsl:attribute name = "SIZE">
						<xsl:text>2</xsl:text>
					</xsl:attribute>
					<xsl:element name = "COLOR">
						<xsl:variable name="fgcolor">
							<xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcUnprotHighAlpha']/INT[2]"/>
						</xsl:variable>
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$fgcolor"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
					<xsl:element name = "COLOR">
						<xsl:call-template name="GETBACKGROUNDCOLOR">
							<xsl:with-param name="backgroundcolor"><xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcUnprotHighAlpha']/INT[3]"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "COLOR_ARRAY">
					<xsl:attribute name = "SIZE">
						<xsl:text>2</xsl:text>
					</xsl:attribute>
					<xsl:element name = "COLOR">
						<xsl:variable name="fgcolor">
							<xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcUnprotHighNum']/INT[2]"/>
						</xsl:variable>
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$fgcolor"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
					<xsl:element name = "COLOR">
						<xsl:call-template name="GETBACKGROUNDCOLOR">
							<xsl:with-param name="backgroundcolor"><xsl:value-of select = "//COMMAND[@name='SetColorMap' and INT='rcUnprotHighNum']/INT[3]"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:element>
</xsl:template>


<xsl:template name="GETBACKGROUNDCOLOR">
	<xsl:param name="backgroundcolor"/>
	<xsl:variable name = "ribmsetting">
		<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcBackgndColor']/INT[2]"/>
	</xsl:variable>
	<xsl:choose>
		<xsl:when test="$ribmsetting='rcColorMapbackgnd'">
			<xsl:call-template name="CONVERTCOLOR">
				<xsl:with-param name="color"><xsl:value-of select = "$backgroundcolor"/></xsl:with-param>
			</xsl:call-template>					
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name="CONVERTCOLOR">
				<xsl:with-param name="color"><xsl:value-of select="$ribmsetting"/></xsl:with-param>
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "CONVERTCOLOR">
	<xsl:param name="color"/>
	<xsl:choose>
		<xsl:when test="$color='rcWhite'">
			<xsl:text>0xffffff</xsl:text>
		</xsl:when>
		<xsl:when test="$color='rcGrey'">
			<xsl:text>0xc0c0c0</xsl:text>
		</xsl:when>
		<xsl:when test="$color='rcRed'">
			<xsl:text>0xff0000</xsl:text>
		</xsl:when>
		<xsl:when test="$color='rcBlue'">
			<xsl:text>0xff</xsl:text>
		</xsl:when>
		<xsl:when test="$color='rcGreen'">
			<xsl:text>0xff00</xsl:text>
		</xsl:when>
		<xsl:when test="$color='rcYellow'">
			<xsl:text>0xffff00</xsl:text>
		</xsl:when>
		<xsl:when test="$color='rcCyan'">
			<xsl:text>0xffff</xsl:text>
		</xsl:when>
		<xsl:when test="$color='rcMagenta'">
			<xsl:text>0xff00ff</xsl:text>
		</xsl:when>
		<xsl:when test="$color='rcBlack'">
			<xsl:text>0x0</xsl:text>
		</xsl:when>
		<xsl:when test="$color='rcDkGrey'">
			<xsl:text>0x808080</xsl:text>
		</xsl:when>
		<xsl:when test="$color='rcDkRed'">
			<xsl:text>0x800000</xsl:text>
		</xsl:when>
		<xsl:when test="$color='rcDkBlue'">
			<xsl:text>0x80</xsl:text>
		</xsl:when>
		<xsl:when test="$color='rcDkGreen'">
			<xsl:text>0x8000</xsl:text>
		</xsl:when>
		<xsl:when test="$color='rcDkYellow'">
			<xsl:text>0x808000</xsl:text>
		</xsl:when>
		<xsl:when test="$color='rcDkCyan'">
			<xsl:text>0x8080</xsl:text>
		</xsl:when>
		<xsl:when test="$color='rcDkMagenta'">
			<xsl:text>0x800080</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>0x0</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!--
	0xFFFFFF,   // 0   _rcWHITE
	0xC0C0C0,   // 1   _rcGREY
	0x0000FF,   // 2   _rcRED
	0xFF0000,   // 3   _rcBLUE
	0x00FF00,   // 4   _rcGREEN
	0x00FFFF,   // 5   _rcYELLOW
	0xFFFF00,   // 6   _rcCYAN
	0xFF00FF,   // 7   _rcMAGENTA
	0x000000,   // 8   _rcBLACK
	0x808080,   // 9   _rcDKGREY
	0x000080,   // 10  _rcDKRED
	0x800000,   // 11  _rcDKBLUE
	0x008000,   // 12  _rcDKGREEN
	0x008080,   // 13  _rcDKYELLOW
	0x808000,   // 14  _rcDKCYAN
	0x800080    // 15  _rcDKMAGENTA
		
	public static final	int	HOST_BLUE			=	0;
	public static final	int	HOST_RED			=	1;
	public static final	int	HOST_PINK			=	2;
	public static final	int	HOST_GREEN			=	3;
	public static final	int	HOST_CYAN			=	4;
	public static final	int	HOST_YELLOW			=	5;
	public static final	int	HOST_WHITE			=	6;
	public static final	int	STATUS_LINE			=	7;
	public static final	int	PROTECTED_NORMAL_ALPHA		=	8;
	public static final	int	PROTECTED_NORMAL_NUM		=	9;
	public static final	int	PROTECTED_HIGH_ALPHA		=	10;
	public static final	int	PROTECTED_HIGH_NUM		=	11;
	public static final	int	UNPROTECTED_NORMAL_ALPHA	=	12;
	public static final	int	UNPROTECTED_NORMAL_NUM		=	13;
	public static final	int	UNPROTECTED_HIGH_ALPHA		=	14;
	public static final	int	UNPROTECTED_HIGH_NUM		=	15;	
-->	

<xsl:template name = "HOTSPOTSERVICEIBM3270">
	<xsl:element name = "CONTAINER">
		<xsl:attribute name = "NAME">
			<xsl:text>com.wrq.ibm.display.hotspot.HotspotService-ibm3270</xsl:text>
		</xsl:attribute>
		<xsl:element name = "CONTEXT_CHILD_STATE">
			<xsl:call-template name="HOTSPOTCOMMANDLIST3270"/>     
			<xsl:call-template name="HOTSPOTPROPERTIES"/>     			
		</xsl:element>	     
	</xsl:element>
</xsl:template>

<xsl:template name = "HOTSPOTSERVICEIBM5250">
	<xsl:element name = "CONTAINER">
		<xsl:attribute name = "NAME">
			<xsl:text>com.wrq.ibm.display.hotspot.HotspotService-ibm5250</xsl:text>
		</xsl:attribute>
		<xsl:element name = "CONTEXT_CHILD_STATE">
			<xsl:call-template name="HOTSPOTCOMMANDLIST5250"/>     
			<xsl:call-template name="HOTSPOTPROPERTIES"/>     			
		</xsl:element>	     
	</xsl:element>	     
</xsl:template>

<xsl:template name = "HOTSPOTPROPERTIES">
	<xsl:element name = "PROPERTY_STATE">
		<xsl:attribute name = "SIZE">
			<xsl:text>2</xsl:text>
		</xsl:attribute>
		<xsl:element name = "CORE_PROPERTY">
			<xsl:attribute name = "NAME">
				<xsl:text>showHotspots</xsl:text>
			</xsl:attribute>
			<xsl:element name = "BOOLEAN">
				<!-- this setting is not saved to the Reflection for IBM settings file if it has not 
				     been changed from default "true". So if it is false, set the config file to false
				     otherwise set it to true -->
				<xsl:choose>
					<xsl:when test="//COMMAND[@name='SetNumeric' and INT='rcShowHotSpots']/BOOL = 'false'">
						<xsl:text>false</xsl:text>	     
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>true</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>	     
		</xsl:element>	     
		<xsl:element name = "CORE_PROPERTY">
			<xsl:attribute name = "NAME">
				<xsl:text>enableHotspots</xsl:text>
			</xsl:attribute>
			<xsl:element name = "BOOLEAN">
				<!-- this setting is not saved to the Reflection for IBM settings file if it has not 
				     been changed from default "true". So if it is false, set the config file to false
				     otherwise set it to true -->
				<xsl:choose>
					<xsl:when test="//COMMAND[@name='SetNumeric' and INT='rcEnableHotSpots']/BOOL = 'false'">
						<xsl:text>false</xsl:text>	     
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>true</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>	     
		</xsl:element>	     
	</xsl:element>	     
</xsl:template>


<xsl:template name = "HOTSPOTCOMMANDLIST5250">
<!-- spit out all the default hotspots for 5250 terminal -->
	<xsl:element name = "COMMAND_LIST">
		<xsl:attribute name = "SIZE">
			<xsl:text>28</xsl:text>
		</xsl:attribute>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F1</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>1</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F2</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>2</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F3</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>3</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F4</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>4</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F5</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>5</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F6</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>6</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F7</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>7</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F8</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>8</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F9</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>9</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F10</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>10</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F11</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>11</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F12</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>12</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F13</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>13</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F14</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>14</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F15</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>15</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F16</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>16</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F17</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>17</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F18</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>18</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F19</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>19</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F20</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>20</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F21</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>21</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F22</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>22</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F23</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>23</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F24</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>24</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>enter</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>29</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>ENTER</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>29</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>more...</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>56</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>MORE...</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>56</xsl:text></xsl:with-param>
		</xsl:call-template>
	</xsl:element>	     
</xsl:template>


<xsl:template name = "HOTSPOTCOMMANDLIST3270">
<!-- spit out all the default hotspots for 3270 terminal -->
	<xsl:element name = "COMMAND_LIST">
		<xsl:attribute name = "SIZE">
			<xsl:text>97</xsl:text>
		</xsl:attribute>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF1</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>6</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF2</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>7</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF3</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>8</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF4</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>9</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF5</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>10</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF6</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>11</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF7</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>12</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF8</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>13</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF9</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>14</xsl:text></xsl:with-param>
		</xsl:call-template>
			
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF01</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>6</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF02</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>7</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF03</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>8</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF04</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>9</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF05</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>10</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF06</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>11</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF07</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>12</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF08</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>13</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF09</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>14</xsl:text></xsl:with-param>
		</xsl:call-template>
			
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF10</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>15</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF11</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>16</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF12</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>17</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF13</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>18</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF14</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>19</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF15</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>20</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF16</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>21</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF17</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>22</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF18</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>23</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF19</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>24</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF20</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>25</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF21</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>26</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF22</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>27</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF23</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>28</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PF24</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>29</xsl:text></xsl:with-param>
		</xsl:call-template>
			
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PA01</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>30</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PA02</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>31</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PA03</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>32</xsl:text></xsl:with-param>
		</xsl:call-template>

		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PA1</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>30</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PA2</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>31</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>PA3</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>32</xsl:text></xsl:with-param>
		</xsl:call-template>

		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F1</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>6</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F2</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>7</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F3</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>8</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F4</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>9</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F5</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>10</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F6</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>11</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F7</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>12</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F8</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>13</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F9</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>14</xsl:text></xsl:with-param>
		</xsl:call-template>

		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>01=</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>6</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>02=</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>7</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>03=</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>8</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>04=</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>9</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>05=</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>10</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>06=</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>11</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>07=</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>12</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>08=</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>13</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>09=</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>14</xsl:text></xsl:with-param>
		</xsl:call-template>
			
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>10=</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>15</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>11=</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>16</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>12=</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>17</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>13=</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>18</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>14=</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>19</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>15=</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>20</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>16=</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>21</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>17=</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>22</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>18=</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>23</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>19=</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>24</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>20=</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>25</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>21=</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>26</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>22=</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>27</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>23=</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>28</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>24=</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>29</xsl:text></xsl:with-param>
		</xsl:call-template>

		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>MORE...</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>33</xsl:text></xsl:with-param>
		</xsl:call-template>
			
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F01</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>6</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F02</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>7</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F03</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>8</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F04</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>9</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F05</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>10</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F06</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>11</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F07</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>12</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F08</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>13</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F09</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>14</xsl:text></xsl:with-param>
		</xsl:call-template>
			
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F10</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>15</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F11</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>16</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F12</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>17</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F13</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>18</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F14</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>19</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F15</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>20</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F16</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>21</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F17</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>22</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F18</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>23</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F19</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>24</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F20</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>25</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F21</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>26</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F22</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>27</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F23</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>28</xsl:text></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name = "HOTSPOTCOMMAND">
			<xsl:with-param name="hotspottext"><xsl:text>F24</xsl:text></xsl:with-param>
			<xsl:with-param name="hotspotint"><xsl:text>29</xsl:text></xsl:with-param>
		</xsl:call-template>
	</xsl:element>
</xsl:template>

<xsl:template name = "HOTSPOTCOMMAND">
	<xsl:param name="hotspottext"/>
	<xsl:param name="hotspotint"/>
	<xsl:element name = "COMMAND">
		<xsl:attribute name = "NAME">
			<xsl:text>IHotspotService.defineHotspot</xsl:text>
		</xsl:attribute>
		<xsl:element name = "OBJECT_ARRAY">
			<xsl:attribute name = "SIZE">
				<xsl:text>6</xsl:text>
			</xsl:attribute>
			<xsl:element name = "STRING">
				<xsl:value-of select="$hotspottext"/>
			</xsl:element>	     
			<xsl:element name = "INTEGER">
				<xsl:text>-1</xsl:text>
			</xsl:element>	     
			<xsl:element name = "INTEGER">
				<xsl:text>-1</xsl:text>
			</xsl:element>
			<xsl:element name = "BOOLEAN">
				<xsl:text>false</xsl:text>
			</xsl:element>
			<xsl:element name = "INTEGER">
				<xsl:variable name="terminaltype">
					<xsl:call-template name="TERMINALTYPE"/>
				</xsl:variable>	
				<xsl:choose>
					<xsl:when test="$terminaltype = 'ibm3270'">
						<xsl:text>0</xsl:text>
					</xsl:when>
					<xsl:when test="$terminaltype = 'ibm5250'">
						<xsl:text>1</xsl:text>
					</xsl:when>
				</xsl:choose> 
			</xsl:element>
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "NAME">
					<xsl:text>Emulator.transmitTerminalKey</xsl:text>
				</xsl:attribute>
				<xsl:element name = "OBJECT_ARRAY">
					<xsl:attribute name = "SIZE">
						<xsl:text>1</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INTEGER">
						<xsl:value-of select="$hotspotint"/>
					</xsl:element>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:element>
</xsl:template>


<!-- this appears to be the same regardless of session type.  -->
<xsl:template name = "PRESENTATIONMANAGER3">
	<xsl:element name = "CONTAINER">
		<xsl:attribute name = "NAME">
			<xsl:text>PresentationManager3</xsl:text>
		</xsl:attribute>
		<xsl:element name = "CONTEXT_CHILD_STATE">
			<xsl:element name = "COMMAND_LIST">
				<xsl:attribute name = "SIZE">
					<xsl:text>1</xsl:text>
				</xsl:attribute>
				<xsl:element name = "COMMAND">
					<xsl:attribute name = "NAME">
						<xsl:text>PresentationManager.setFrameBounds</xsl:text>
					</xsl:attribute>
					<xsl:element name = "OBJECT_ARRAY">
						<xsl:attribute name = "SIZE">
							<xsl:text>4</xsl:text>
						</xsl:attribute>
						<xsl:element name = "INTEGER">
							<xsl:text>-1</xsl:text>
						</xsl:element>
						<xsl:element name = "INTEGER">
							<xsl:text>-1</xsl:text>
						</xsl:element>
						<xsl:element name = "INTEGER">
							<xsl:text>-1</xsl:text>
						</xsl:element>
						<xsl:element name = "INTEGER">
							<xsl:text>-1</xsl:text>
						</xsl:element>
					</xsl:element>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "PROPERTY_STATE">
				<xsl:attribute name = "SIZE">
					<xsl:text>2</xsl:text>
				</xsl:attribute>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>visible</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<xsl:text>true</xsl:text>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>autoDisplaySizing</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<xsl:text>true</xsl:text>
					</xsl:element>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:element>
</xsl:template>

<xsl:template name = "BLOCKTD">
	<xsl:element name = "CONTAINER">
		<xsl:attribute name = "NAME">
			<xsl:text>com.wrq.display.BlockTD</xsl:text>
		</xsl:attribute>
		<xsl:element name = "PROPERTY_STATE">
			<xsl:attribute name = "SIZE">
				<xsl:text>20</xsl:text>
			</xsl:attribute>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>selectionDelimiters</xsl:text>
				</xsl:attribute>
				<xsl:element name = "STRING">	
					<xsl:text> .,;</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>beginSelectionModifier</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">	
					<xsl:text>0</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>beginAltSelectionModifier</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">	
					<xsl:text>8</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>extendSelectionModifier</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">	
					<xsl:text>1</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>displayFont</xsl:text>
				</xsl:attribute>
				<xsl:element name = "STRING">
					<!-- no good way to map this from Ribm to Rweb
					     so using Monospaced for now -->	
					<xsl:text>Monospaced</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>doubleClickTime</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">	
					<xsl:text>200</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>characterBlinkRate</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">	
					<xsl:text>0</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>cursorBlinkRate</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">	
					<xsl:text>0</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>constrainCellWidth</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">	
					<xsl:text>false</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>copyTrailingSpaces</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">	
					<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcCopyTrailingSpaces']/BOOL"/>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>defaultSelectionMode</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">
					<xsl:text>1</xsl:text>	
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>useHeavyFont</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:variable name = "fontstyle">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcFontStyle']/INT[2]"/>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="$fontstyle='rcBold'">
							<xsl:text>true</xsl:text>
						</xsl:when>
						<xsl:when test="$fontstyle='rcRegular'">
							<xsl:text>false</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>false</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>blinkEnabled</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">	
					<xsl:text>true</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>boldEnabled</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">	
					<xsl:text>true</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>underlineEnabled</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">	
					<xsl:text>true</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>bitmapFontWhenSmall</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">	
					<xsl:text>true</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>editAllAttributes</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">	
					<xsl:text>false</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>slashedZero</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">	
					<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcSubstituteDisplayChars']/BOOL"/>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>allowMultipleBkgColors</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:variable name = "ribmsetting">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcBackgndColor']/INT[2]"/>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="$ribmsetting='rcColorMapbackgnd'">
							<xsl:text>true</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>false</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>columnSeparatorStyle</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">
					<xsl:variable name = "columnseparatorstyle">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcColumnSeparatorStyle']/INT[2]"/>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="$columnseparatorstyle='rcDots'">
							<xsl:text>1</xsl:text>
						</xsl:when>
						<xsl:when test="$columnseparatorstyle='rcVerticalLines'">
							<xsl:text>2</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>0</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:element>
</xsl:template>

<xsl:template name = "MAPPERENGINE1">
	<xsl:element name = "CONTAINER">
		<xsl:attribute name = "NAME">
			<xsl:text>MapperEngine-1</xsl:text>
		</xsl:attribute>
		<xsl:element name = "PROPERTY_STATE">
			<xsl:attribute name = "SIZE">
				<xsl:text>3</xsl:text>
			</xsl:attribute>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>terminalKeyboardVisible</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcTerminalKbdVisible']/BOOL"/>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>buttonPaletteVisible</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:text>false</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>toolbarVisible</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<!-- using true all the time because ToolbarVisible isn't saved to settings files
					     and ShowToolbar uses localized strings for the names of the toolbars -->
					<xsl:text>true</xsl:text>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:element>
</xsl:template>

<xsl:template name = "TRANSPORTOPTIONS">
	<xsl:element name = "CONTAINER">
		<xsl:attribute name = "NAME">
			<xsl:text>com.wrq.session.transport.TransportOptions</xsl:text>
		</xsl:attribute>
		<xsl:element name = "PROPERTY_STATE">
			<xsl:attribute name = "SIZE">
				<xsl:text>21</xsl:text>
			</xsl:attribute>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>deviceName</xsl:text>
				</xsl:attribute>
				<xsl:choose>
					<xsl:when test="//SESSION/COMMAND[@name='SetupSession']/INT[1]='rc3270Printer'">  
						<xsl:element name = "STRING">
							<xsl:value-of select = "//COMMAND[@name='SetString' and INT='rcPrintHostLUName']/STRING"/>
						</xsl:element>
					</xsl:when>
					<xsl:otherwise>
						<xsl:element name = "STRING">
							<xsl:value-of select = "//COMMAND[@name='SetString' and INT='rcDeviceName']/STRING"/>
						</xsl:element>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>supportTN3270E</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:choose>
						<xsl:when test="//SESSION/COMMAND[@name='SetupSession' and INT[3]='rcTelnetExtended' and INT[1]='rc3270Terminal']">
							<xsl:text>true</xsl:text>
						</xsl:when>
						<xsl:when test="//SESSION/COMMAND[@name='SetupSession' and INT[3]='rcTelnetExtended' and INT[1]='rc3270Printer']">
							<xsl:text>true</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>false</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>responseMode</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcTelnetResponseMode']/BOOL"/>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>telnetTerminalID</xsl:text>
				</xsl:attribute>
				<xsl:element name = "STRING">
					<xsl:value-of select = "//COMMAND[@name='SetString' and INT='rcTelnetTerminalID']/STRING"/>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>tn3270eConnectType</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">
					<xsl:choose>
						<xsl:when test="//CONNECTION/COMMAND[@name='SetNumeric' and INT[1]='rcTN3287ConnectType' and INT[2]='rc3287Associate']">
							<xsl:text>0</xsl:text>
						</xsl:when>
						<xsl:when test="//CONNECTION/COMMAND[@name='SetNumeric' and INT[1]='rcTN3287ConnectType' and INT[2]='rc3287Connect']">
							<xsl:text>1</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>1</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>tnAssociation</xsl:text>
				</xsl:attribute>
				<xsl:element name = "STRING">
					<xsl:value-of select = "//COMMAND[@name='SetString' and INT='rcTNAssociation']/STRING"/>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>telnetTerminalType</xsl:text>
				</xsl:attribute>
				<xsl:element name = "STRING">
					<xsl:value-of select = "//COMMAND[@name='SetString' and INT='rcTelnetTerminalID']/STRING"/>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>sendLFAfterCR</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<!-- TODO: figure out what this is used for in Rweb
					     it is not applicable as far as I can tell 
					     leaving this false for now-->
					<xsl:text>false</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>initiateOptionNegotiation</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<!-- TODO: figure out what this is used for in Rweb
					     it is not applicable as far as I can tell 
					     leaving this true for now-->
					<xsl:text>true</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>requestBinary</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<!-- TODO: figure out what this is used for in Rweb
					     it is not applicable as far as I can tell 
					     leaving this false for now-->
					<xsl:text>false</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>breakSendsIP</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<!-- TODO: figure out what this is used for in Rweb
					     it is not applicable as far as I can tell 
					     leaving this true for now-->
					<xsl:text>true</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>negotiateWindowSize</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<!-- TODO: figure out what this is used for in Rweb
					     it is not applicable as far as I can tell 
					     leaving this true for now-->
					<xsl:text>true</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>localMode</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">
					<!-- TODO: figure out what this is used for in Rweb
					     it is not applicable as far as I can tell 
					     leaving this 0 for now-->
					<xsl:text>0</xsl:text>
				</xsl:element>
			</xsl:element>									
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>characterDelay</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">
					<!-- TODO: figure out what this is used for in Rweb
					     it is not applicable as far as I can tell 
					     leaving this 0 for now-->
					<xsl:text>0</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>renegotiateEcho</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<!-- TODO: figure out what this is used for in Rweb
					     it is not applicable as far as I can tell 
					     leaving this false for now-->
					<xsl:text>false</xsl:text>
				</xsl:element>
			</xsl:element>									
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>generateUniqueDeviceName</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<!-- TODO: no equivalent Ribm settings. false for now-->
					<xsl:text>false</xsl:text>
				</xsl:element>
			</xsl:element>									
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>encryptStream</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcTelnetEncryption']/BOOL"/>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>securityEnabled</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcTelnetUseReflectionSecurityProxy']/BOOL"/>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>SSLVersions</xsl:text>
				</xsl:attribute>
				<xsl:element name = "STRING">
					<xsl:text>EnableTLS10,EnableSSL30</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>playbackFile</xsl:text>
				</xsl:attribute>
				<xsl:element name = "STRING">
				</xsl:element>
			</xsl:element>									
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>pauseDuringPlayback</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPauseDebugPlayOnEOR']/BOOL"/>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:element>
</xsl:template>

<xsl:template name = "MOUSEMAPPERSERVICE">
	<xsl:element name = "CONTAINER">
		<xsl:attribute name = "NAME">
			<xsl:text>com.wrq.present.mouse.MouseMapperService</xsl:text>
		</xsl:attribute>
		<xsl:element name = "CONTEXT_CHILD_STATE">
			<xsl:element name = "COMMAND_LIST">
			<xsl:variable name="terminaltype">
				<xsl:call-template name="TERMINALTYPE"/>
			</xsl:variable>	
			<xsl:attribute name = "SIZE">
				<xsl:variable name="terminaltype2">
					<xsl:call-template name="TERMINALTYPE"/>
				</xsl:variable>	
				<xsl:choose>
					<xsl:when test="$terminaltype2 = 'ibm3270' or $terminaltype = 'ibm5250'">
						<xsl:text>2</xsl:text>
					</xsl:when>
					<xsl:when test="$terminaltype2 = 'ibm3287' or $terminaltype = 'ibm3812'">
						<xsl:text>1</xsl:text>
					</xsl:when>
				</xsl:choose> 
			</xsl:attribute>
				<xsl:element name = "COMMAND">
					<xsl:attribute name = "NAME">
						<xsl:text>IMouseMapperService.setMouseMap</xsl:text>
					</xsl:attribute>
					<xsl:element name = "OBJECT_ARRAY">
						<xsl:attribute name = "SIZE">
							<xsl:text>3</xsl:text>
						</xsl:attribute>
						<xsl:element name = "INTEGER">
							<xsl:text>0</xsl:text>
						</xsl:element>
						<xsl:element name = "INTEGER">
							<xsl:text>1</xsl:text>
						</xsl:element>
						<xsl:element name = "COMMAND">
							<xsl:attribute name = "NAME">
								<xsl:text>Emulator.moveCursor</xsl:text>
							</xsl:attribute>
							<xsl:element name = "OBJECT_ARRAY">
								<xsl:attribute name = "SIZE">
									<xsl:text>1</xsl:text>
								</xsl:attribute>
								<xsl:element name = "INDIRECT_PROPERTY">
									<xsl:element name = "STRING">
										<xsl:text>mouseClickPosition</xsl:text>
									</xsl:element>
								</xsl:element>
							</xsl:element>
						</xsl:element>
					</xsl:element>			
				</xsl:element>
				<xsl:if test="$terminaltype = 'ibm3270' or $terminaltype = 'ibm5250'">
					<xsl:element name = "COMMAND">
						<xsl:attribute name = "NAME">
							<xsl:text>IMouseMapperService.setMouseMap</xsl:text>
						</xsl:attribute>
						<xsl:element name = "OBJECT_ARRAY">
							<xsl:attribute name = "SIZE">
								<xsl:text>3</xsl:text>
							</xsl:attribute>
							<xsl:element name = "INTEGER">
								<xsl:text>10</xsl:text>
							</xsl:element>
							<xsl:element name = "INTEGER">
								<xsl:text>1</xsl:text>
							</xsl:element>
							<xsl:element name = "COMMAND">
								<xsl:attribute name = "NAME">
									<xsl:if test="$terminaltype = 'ibm3270'">
										<xsl:text>IBM3270.cursorSelect</xsl:text>
									</xsl:if>
									<xsl:if test="$terminaltype = 'ibm5250'">
										<xsl:text>IBM5250.cursorSelect</xsl:text>
									</xsl:if>
								</xsl:attribute>
								<xsl:element name = "OBJECT_ARRAY">
									<xsl:attribute name = "SIZE">
										<xsl:text>1</xsl:text>
									</xsl:attribute>
									<xsl:element name = "INDIRECT_PROPERTY">
										<xsl:element name = "STRING">
											<xsl:text>mouseClickPosition</xsl:text>
										</xsl:element>
									</xsl:element>
								</xsl:element>
							</xsl:element>
						</xsl:element>			
					</xsl:element>
				</xsl:if>				
				<xsl:element name = "NULL"/>
			</xsl:element>				
		</xsl:element>
	</xsl:element>
</xsl:template>

<xsl:template name = "IBM3270">
	<xsl:element name = "CONTAINER">
		<xsl:attribute name = "NAME">
			<xsl:text>com.wrq.ibm3270.IBM3270</xsl:text>
		</xsl:attribute>
		<xsl:element name = "PROPERTY_STATE">
			<xsl:attribute name = "SIZE">
				<xsl:text>16</xsl:text>
			</xsl:attribute>
			<xsl:call-template name="COMMONPROPERTIES32703287"/>
		</xsl:element>
	</xsl:element>
</xsl:template>

<xsl:template name = "COMMONPROPERTIES32703287">
	<xsl:element name = "CORE_PROPERTY">
		<xsl:attribute name = "NAME">
			<xsl:text>transferInProgress</xsl:text>
		</xsl:attribute>
		<xsl:element name = "BOOLEAN">
			<xsl:text>false</xsl:text>
		</xsl:element>
	</xsl:element>
	<xsl:element name = "CORE_PROPERTY">
		<xsl:attribute name = "NAME">
			<xsl:text>showStatusLine</xsl:text>
		</xsl:attribute>
		<xsl:element name = "BOOLEAN">
			<!-- note: this is not the same as ShowStatusBar in Ribm -->
			<xsl:text>true</xsl:text>
		</xsl:element>
	</xsl:element>
	<xsl:element name = "CORE_PROPERTY">
		<xsl:attribute name = "NAME">
			<xsl:text>C370CharacterSet</xsl:text>
		</xsl:attribute>
		<xsl:element name = "BOOLEAN">
			<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcC370Charset']/BOOL"/>
		</xsl:element>
	</xsl:element>
	<xsl:element name = "CORE_PROPERTY">
		<xsl:attribute name = "NAME">
			<xsl:text>CECG</xsl:text>
		</xsl:attribute>
		<xsl:element name = "BOOLEAN">
			<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcCEGC']/BOOL"/>
		</xsl:element>
	</xsl:element>
	<xsl:element name = "CORE_PROPERTY">
		<xsl:attribute name = "NAME">
			<xsl:text>insertArena</xsl:text>
		</xsl:attribute>
		<xsl:element name = "INTEGER">
			<xsl:variable name="insertarena">
				<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcInsertArena']/INT[2]"/>
			</xsl:variable>	
			<xsl:choose>
				<xsl:when test="$insertarena = 'rcCurrentField'">
					<xsl:text>0</xsl:text>
				</xsl:when>
				<xsl:when test="$insertarena = 'rcLocalUnprotectedFields'">
					<xsl:text>1</xsl:text>
				</xsl:when>
				<xsl:when test="$insertarena = 'rcAllUnprotectedFields'">
					<xsl:text>2</xsl:text>
				</xsl:when>
			</xsl:choose> 
		</xsl:element>
	</xsl:element>
	<xsl:element name = "CORE_PROPERTY">
		<xsl:attribute name = "NAME">
			<xsl:text>insertMode</xsl:text>
		</xsl:attribute>
		<!-- TODO: figure out what this does in Rweb
		     Preserve3270InsertState??? -->
		<xsl:element name = "BOOLEAN">
			<xsl:text>false</xsl:text>
		</xsl:element>
	</xsl:element>
	<xsl:element name = "CORE_PROPERTY">
		<xsl:attribute name = "NAME">
			<xsl:text>nationalCharacterSet</xsl:text>
		</xsl:attribute>
		<xsl:element name = "STRING">
			<xsl:call-template name="NATIONALCHARACTERSET"/>
		</xsl:element>
	</xsl:element>
	<xsl:element name = "CORE_PROPERTY">
		<xsl:attribute name = "NAME">
			<xsl:text>supportXSystem</xsl:text>
		</xsl:attribute>
		<xsl:element name = "BOOLEAN">
			<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcTelnetXSystem']/BOOL"/>
		</xsl:element>
	</xsl:element>
	<xsl:element name = "CORE_PROPERTY">
		<xsl:attribute name = "NAME">
			<xsl:text>telnetSysReqTestReq</xsl:text>
		</xsl:attribute>
		<xsl:element name = "BOOLEAN">
			<xsl:variable name="telnetsysreq">
				<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcTelnetSysReq']/INT[2]"/>
			</xsl:variable>	
			<xsl:choose>
				<xsl:when test="$telnetsysreq = 'rcTestRequestRead'">
					<xsl:text>true</xsl:text>
				</xsl:when>
				<xsl:when test="$telnetsysreq = 'rcTelnetAbortOutput'">
					<xsl:text>false</xsl:text>
				</xsl:when>
				<xsl:when test="$telnetsysreq = 'rcTelnetBreak'">
					<xsl:text>false</xsl:text>
				</xsl:when>
				<xsl:when test="$telnetsysreq = 'rcTelnetIntProcess'">
					<xsl:text>false</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>false</xsl:text>
				</xsl:otherwise>
			</xsl:choose> 
		</xsl:element>
	</xsl:element>
	<xsl:element name = "CORE_PROPERTY">
		<xsl:attribute name = "NAME">
			<xsl:text>attnKey</xsl:text>
		</xsl:attribute>
		<xsl:element name = "INTEGER">
			<xsl:variable name="telnetattn">
				<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcTelnetAttn']/INT[2]"/>
			</xsl:variable>	
			<xsl:choose>
				<xsl:when test="$telnetattn = 'rcTelnetAbortOutput'">
					<xsl:text>1</xsl:text>
				</xsl:when>
				<xsl:when test="$telnetattn = 'rcTelnetIntProcess'">
					<xsl:text>2</xsl:text>
				</xsl:when>
				<xsl:when test="$telnetattn = 'rcTelnetBreak'">
					<xsl:text>3</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>3</xsl:text>
				</xsl:otherwise>
			</xsl:choose> 
		</xsl:element>
	</xsl:element>
	<xsl:element name = "CORE_PROPERTY">
		<xsl:attribute name = "NAME">
			<xsl:text>typeahead</xsl:text>
		</xsl:attribute>
		<xsl:element name = "BOOLEAN">
			<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcTypeAhead']/BOOL"/>
		</xsl:element>
	</xsl:element>
	<xsl:element name = "CORE_PROPERTY">
		<xsl:attribute name = "NAME">
			<xsl:text>printerMPL</xsl:text>
		</xsl:attribute>
		<xsl:element name = "INTEGER">
			<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrinterMPL']/INT[2]"/>
		</xsl:element>
	</xsl:element>
	<xsl:element name = "CORE_PROPERTY">
		<xsl:attribute name = "NAME">
			<xsl:text>printerMPP</xsl:text>
		</xsl:attribute>
		<xsl:element name = "INTEGER">
			<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrinterMPP']/INT[2]"/>
		</xsl:element>
	</xsl:element>
	<xsl:element name = "CORE_PROPERTY">
		<xsl:attribute name = "NAME">
			<xsl:text>3270_insertProtocol</xsl:text>
		</xsl:attribute>
		<xsl:element name = "STRING">
			<xsl:variable name="insertprotocol">
				<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcInsertProtocol']/INT[2]"/>
			</xsl:variable>	
			<xsl:choose>
				<xsl:when test="$insertprotocol = 'rcFirstNull'">
					<xsl:text>firstNull</xsl:text>
				</xsl:when>
				<xsl:when test="$insertprotocol = 'rcFirstNullOrTrailingSpace'">
					<xsl:text>firstNull</xsl:text>
				</xsl:when>
				<xsl:when test="$insertprotocol = 'rcFirstNullOrTrailingChar'">
					<xsl:text>firstNull</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>firstNull</xsl:text>
				</xsl:otherwise>
			</xsl:choose> 
		</xsl:element>
	</xsl:element>
	<xsl:element name = "CORE_PROPERTY">
		<xsl:attribute name = "NAME">
			<xsl:text>3270_wordWrap</xsl:text>
		</xsl:attribute>
		<xsl:element name = "BOOLEAN">
			<xsl:variable name="wordwrap">
				<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcWordWrap']/INT[2]"/>
			</xsl:variable>	
			<xsl:choose>
				<xsl:when test="$wordwrap = 'rcHostWordWrap'">
					<xsl:text>true</xsl:text>
				</xsl:when>
				<xsl:when test="$wordwrap = 'rcLocalWordWrap'">
					<xsl:text>true</xsl:text>
				</xsl:when>
				<xsl:when test="$wordwrap = 'rcNoWordWrap'">
					<xsl:text>false</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>false</xsl:text>
				</xsl:otherwise>
			</xsl:choose> 
		</xsl:element>
	</xsl:element>
	<xsl:element name = "CORE_PROPERTY">
		<xsl:attribute name = "NAME">
			<xsl:text>3270_keyboardErrorReset</xsl:text>
		</xsl:attribute>
		<xsl:element name = "STRING">
			<xsl:text>false</xsl:text>
		</xsl:element>
	</xsl:element>
	<xsl:element name = "CORE_PROPERTY">
		<xsl:attribute name = "NAME">
			<xsl:text>attnKey</xsl:text>
		</xsl:attribute>
		<xsl:element name = "INTEGER">
			<xsl:text>3</xsl:text>
		</xsl:element>
	</xsl:element>
</xsl:template>

<xsl:template name = "IBM5250">
	<xsl:element name = "CONTAINER">
		<xsl:attribute name = "NAME">
			<xsl:text>com.wrq.ibm5250.IBM5250</xsl:text>
		</xsl:attribute>
		<xsl:element name = "PROPERTY_STATE">
			<xsl:attribute name = "SIZE">
				<xsl:text>17</xsl:text>
			</xsl:attribute>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>transferInProgress</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:text>false</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>showStatusLine</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<!-- note: this is not the same as ShowStatusBar in Ribm -->
					<xsl:text>true</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>autoReset</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:variable name="autoreset">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcKeyboardErrorReset']/INT[2]"/>
					</xsl:variable>	
					<xsl:choose>
						<xsl:when test="$autoreset = 'rcNoAutoReset'">
							<xsl:text>false</xsl:text>
						</xsl:when>
						<xsl:when test="$autoreset = 'rcAutoResetNoMessage'">
							<xsl:text>true</xsl:text>
						</xsl:when>
						<xsl:when test="$autoreset = 'rcAutoReset'">
							<xsl:text>true</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>false</xsl:text>
						</xsl:otherwise>
					</xsl:choose> 
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>insertMode</xsl:text>
				</xsl:attribute>
				<!-- TODO: figure out what this does in Rweb
				     Preserve3270InsertState??? -->
				<xsl:element name = "BOOLEAN">
					<xsl:text>false</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>typeahead</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcTypeAhead']/BOOL"/>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>fieldCheckWaivedForPFKey</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:text>false</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>nationalCharacterSet</xsl:text>
				</xsl:attribute>
				<xsl:element name = "STRING">
					<xsl:call-template name="NATIONALCHARACTERSET"/>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>keyboardLocked</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:text>false</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>keyboardLockedReason</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">
					<xsl:text>0</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>messageWaiting</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:text>false</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>hexModeState</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">
					<xsl:text>0</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>typeaheadState</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">
					<xsl:text>1</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>isSysReqState</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:text>false</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>screenSaveCompression</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">
					<xsl:text>1</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>standardCursorPositioning</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:text>true</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>ignoreASCIIData</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:text>false</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>errorAlarm</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:text>false</xsl:text>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:element>
</xsl:template>


<xsl:template name="NATIONALCHARACTERSET">
	<xsl:variable name="ncs">
		<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcNationalCharacterSet']/INT[2]"/>
	</xsl:variable>	
	<xsl:choose>
		<xsl:when test="$ncs = 'rcAustrian' or $ncs = 'rcAustrianEuro'">
			<xsl:text>Austrian</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'rcBelgian' or $ncs = 'rcBelgianEuro'">
			<xsl:text>Belgian</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'rcCanadianFrench' or $ncs = 'rcCanadianFrenchEuro'">
			<xsl:text>CanadianFrench</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'rcDanish' or $ncs = 'rcDanishEuro'">
			<xsl:text>Danish</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'rcDanish73'">
			<xsl:text>Danish73</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'rcEastEurope'">
			<xsl:text>EastEuropean</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'rcFinnish' or $ncs = 'rcFinnishEuro'">
			<xsl:text>Finnish</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'rcFrench' or $ncs = 'rcFrenchEuro'">
			<xsl:text>French</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'rcGerman' or $ncs = 'rcGermanEuro'">
			<xsl:text>German</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'rcIcelandic' or $ncs = 'rcIcelandicEuro'">
			<xsl:text>Icelandic</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'rcItalian' or $ncs = 'rcItalianEuro'">
			<xsl:text>Italian</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'rcJapaneseEnglish'">
			<xsl:text>JapaneseEnglish</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'rcJapaneseExtended'">
			<xsl:text>JapaneseExtended</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'rcJapaneseKatakana'">
			<xsl:text>JapaneseKatakana</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'rcNetherlands' or $ncs = 'rcNetherlandsEuro'">
			<xsl:text>Netherlands</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'rcBelgianNew' or $ncs = 'rcBelgianNewEuro'">
			<xsl:text>NewBelgian</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'rcNorwegian' or $ncs = 'rcNorwegianEuro'">
			<xsl:text>Norwegian</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'rcPortuguese' or $ncs = 'rcPortugueseEuro'">
			<xsl:variable name="terminaltype">
				<xsl:call-template name="TERMINALTYPE"/>
			</xsl:variable>	
			<xsl:choose>
				<xsl:when test="$terminaltype = 'ibm3270' or $terminaltype = 'ibm3287'">
					<xsl:text>Portuguese</xsl:text>
				</xsl:when>
				<xsl:when test="$terminaltype = 'ibm5250' or $terminaltype = 'ibm3812'">
					<xsl:text>Brazilian</xsl:text>
				</xsl:when>
			</xsl:choose>
		</xsl:when>
		<xsl:when test="$ncs = 'rcSpanish' or $ncs = 'rcSpanishEuro'">
			<xsl:text>Spanish</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'rcSwedish' or $ncs = 'rcSwedishEuro'">
			<xsl:text>Swedish</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'rcSwiss' or $ncs = 'rcSwissEuro'">
			<xsl:text>SwissFrench</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'rcSwissFrench' or $ncs = 'rcSwissFrenchEuro'">
			<xsl:text>SwissFrench</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'rcSwissGerman' or $ncs = 'rcSwissGermanEuro'">
			<xsl:text>SwissGerman</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'rcUKEnglish' or $ncs = 'rcUKEnglishEuro'">
			<xsl:text>UKEnglish</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'rcUSEnglish' or $ncs = 'rcUSEnglishEuro'">
			<xsl:text>USEnglish</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'rcUSASCII'">
			<xsl:text>USASCII</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>USEnglish</xsl:text>
		</xsl:otherwise>
	</xsl:choose> 
</xsl:template>

<xsl:template name = "IBM3287">
	<xsl:element name = "CONTAINER">
		<xsl:attribute name = "NAME">
			<xsl:text>com.wrq.ibm3287.IBM3287</xsl:text>
		</xsl:attribute>
		<xsl:element name = "PROPERTY_STATE">
			<xsl:attribute name = "SIZE">
				<xsl:text>27</xsl:text>
			</xsl:attribute>
			<xsl:call-template name="COMMONPROPERTIES32703287"/>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>rcPrintCase</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">
					<xsl:variable name="rcprintcase">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintCase']/INT[2]"/>					
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="$rcprintcase='rcDualCase'">
							<xsl:text>0</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintcase='rcUpperCase'">
							<xsl:text>1</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>0</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>rcPrintCharsPerInch</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">
					<xsl:variable name="rcprintcharsperinch">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintCharsPerInch']/INT[2]"/>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="$rcprintcharsperinch='rc10CPI'">
							<xsl:text>10</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintcharsperinch='rc12CPI'">
							<xsl:text>12</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintcharsperinch='rc13CPI'">
							<xsl:text>13</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintcharsperinch='rc15CPI'">
							<xsl:text>15</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintcharsperinch='rc17CPI'">
							<xsl:text>17</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintcharsperinch='rc20CPI'">
							<xsl:text>20</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintcharsperinch='rc22CPI'">
							<xsl:text>22</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintcharsperinch='rc27CPI'">
							<xsl:text>27</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintcharsperinch='rc5CPI'">
							<xsl:text>5</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintcharsperinch='rc6CPI'">
							<xsl:text>6</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintcharsperinch='rc8CPI'">
							<xsl:text>8</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>10</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>rcPrintDoubleSpace</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:variable name="rcprintdoublespace">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintLineSpacing']/INT[2]"/>					
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="$rcprintdoublespace='rcDoubleSpace'">
							<xsl:text>true</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>false</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>rcPrintLineSpacing</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">
					<xsl:variable name="rcprintlinespacing">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintLineSpacing']/INT[2]"/>					
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="$rcprintlinespacing='rcPoint5Space'">
							<xsl:text>0</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintlinespacing='rcSingleSpace'">
							<xsl:text>1</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintlinespacing='rc1Point5Space'">
							<xsl:text>2</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintlinespacing='rcDoubleSpace'">
							<xsl:text>3</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintlinespacing='rc2Point5Space'">
							<xsl:text>4</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintlinespacing='rcTripleSpace'">
							<xsl:text>5</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>1</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>rcPrintLinesPerInch</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">
					<xsl:variable name="rcprintcharsperinch">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintLinesPerInch']/INT[2]"/>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="$rcprintcharsperinch='rc10LPI'">
							<xsl:text>10</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintcharsperinch='rc12LPI'">
							<xsl:text>12</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintcharsperinch='rc14LPI'">
							<xsl:text>14</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintcharsperinch='rc17LPI'">
							<xsl:text>17</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintcharsperinch='rc20LPI'">
							<xsl:text>20</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintcharsperinch='rc24LPI'">
							<xsl:text>24</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintcharsperinch='rc28LPI'">
							<xsl:text>28</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintcharsperinch='rc34LPI'">
							<xsl:text>34</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintcharsperinch='rc3LPI'">
							<xsl:text>3</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintcharsperinch='rc40LPI'">
							<xsl:text>40</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintcharsperinch='rc48LPI'">
							<xsl:text>48</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintcharsperinch='rc4LPI'">
							<xsl:text>4</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintcharsperinch='rc5LPI'">
							<xsl:text>5</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintcharsperinch='rc6LPI'">
							<xsl:text>6</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintcharsperinch='rc8LPI'">
							<xsl:text>8</xsl:text>
						</xsl:when>
						<xsl:when test="$rcprintcharsperinch='rc9LPI'">
							<xsl:text>9</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>6</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>rcPrintOverrideHostFmt</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintOverrideHostFmt']/BOOL"/>					
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>rcPrintStatus</xsl:text>
				</xsl:attribute>
				<!-- this is read only setting in Rweb, so always set to false -->
				<xsl:element name = "INTEGER">
					<xsl:text>0</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>rcTranslateEBCDICinTransparent</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintTranslateEBCDICInTRN']/BOOL"/>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>transparentMode</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintTransparent']/BOOL"/>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>in3287Job</xsl:text>
				</xsl:attribute>
				<!-- this is read only setting in Rweb, so always set to false -->
				<xsl:element name = "BOOLEAN">
					<xsl:text>false</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>emulateFormFeed</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintEmulateFormFeed']/BOOL"/>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>promptForDeviceName</xsl:text>
				</xsl:attribute>
				<!-- no equivalent in Ribm, so always set to false -->
				<xsl:element name = "BOOLEAN">
					<xsl:text>false</xsl:text>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:element>
</xsl:template>

<xsl:template name = "IBM3812">
	<xsl:element name = "CONTAINER">
		<xsl:attribute name = "NAME">
			<xsl:text>com.wrq.ibm3812.IBM3812</xsl:text>
		</xsl:attribute>
		<xsl:element name = "PROPERTY_STATE">
			<xsl:attribute name = "SIZE">
				<xsl:text>21</xsl:text>
			</xsl:attribute>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>transferInProgress</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:text>false</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>showStatusLine</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<!-- note: this is not the same as ShowStatusBar in Ribm -->
					<xsl:text>true</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>inJob</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:text>false</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>overrideHostPageFmt</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintOverrideHostFmt']/BOOL"/>					
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>printStatus</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">
					<xsl:text>0</xsl:text>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>transparentMode</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintTransparent']/BOOL"/>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>nationalCharacterSet</xsl:text>
				</xsl:attribute>
				<xsl:element name = "STRING">
					<xsl:call-template name="NATIONALCHARACTERSET"/>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>emulateFormFeed</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintEmulateFormFeed']/BOOL"/>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>connectedDeviceName</xsl:text>
				</xsl:attribute>
				<xsl:element name = "STRING">
					<!-- leave empty, this read only -->
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>useHostPrintTransform</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">
					<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintTransform']/BOOL"/>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>printDeviceFontID</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">
					<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintDeviceFontId']/INT[2]"/>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>printDeviceFormsMode</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">
					<xsl:variable name="printdeviceformsmode">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintDeviceFormsMode']/INT[2]"/>					
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="$printdeviceformsmode='rcFormsModeAutoCut'">
							<xsl:text>0</xsl:text>
						</xsl:when>
						<xsl:when test="$printdeviceformsmode='rcFormsModeCont'">
							<xsl:text>1</xsl:text>
						</xsl:when>
						<xsl:when test="$printdeviceformsmode='rcFormsModeCut'">
							<xsl:text>2</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>0</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>printDevicePaperSrc1</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">
					<xsl:variable name="printdevicepapersrc1">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintDevicePaperSrc1']/INT[2]"/>					
					</xsl:variable>
					<xsl:call-template name="PAPERSRC">
						<xsl:with-param name="source"><xsl:value-of select="$printdevicepapersrc1"/></xsl:with-param>
					</xsl:call-template>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>printDevicePaperSrc2</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">
					<xsl:variable name="printdevicepapersrc2">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintDevicePaperSrc2']/INT[2]"/>
					</xsl:variable>
					<xsl:call-template name="PAPERSRC">
						<xsl:with-param name="source"><xsl:value-of select="$printdevicepapersrc2"/></xsl:with-param>
					</xsl:call-template>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>printDeviceEnvelopeSrc</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">
					<xsl:variable name="printdeviceenvelopesrc">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintDeviceEnvelopeSrc']/INT[2]"/>					
					</xsl:variable>
					<xsl:call-template name="PAPERSRC">
						<xsl:with-param name="source"><xsl:value-of select="$printdeviceenvelopesrc"/></xsl:with-param>
					</xsl:call-template>
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>messageQueue</xsl:text>
				</xsl:attribute>
				<xsl:element name = "STRING">
					<xsl:value-of select = "//COMMAND[@name='SetString' and INT='rcMessageQueue']/STRING"/>					
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>messageLibrary</xsl:text>
				</xsl:attribute>
				<xsl:element name = "STRING">
					<xsl:value-of select = "//COMMAND[@name='SetString' and INT='rcMessageLibrary']/STRING"/>					
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>printMfrType</xsl:text>
				</xsl:attribute>
				<xsl:element name = "STRING">
					<xsl:value-of select = "//COMMAND[@name='SetString' and INT='rcPrintMfrType']/STRING"/>					
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>printDeviceWscstName</xsl:text>
				</xsl:attribute>
				<xsl:element name = "STRING">
					<xsl:value-of select = "//COMMAND[@name='SetString' and INT='rcPrintDeviceWscstName']/STRING"/>					
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>printDeviceWscstLibrary</xsl:text>
				</xsl:attribute>
				<xsl:element name = "STRING">
					<xsl:value-of select = "//COMMAND[@name='SetString' and INT='rcPrintDeviceWscstLibrary']/STRING"/>					
				</xsl:element>
			</xsl:element>
			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>promptForDeviceName</xsl:text>
				</xsl:attribute>
				<!-- no equivalent in Ribm, so always set to false -->
				<xsl:element name = "BOOLEAN">
					<xsl:text>false</xsl:text>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:element>
</xsl:template>

<xsl:template name = "PAPERSRC">
	<xsl:param name="source"/>
		<xsl:choose>
			<xsl:when test="$source='rcIBMPaperSrcMfrTypModel'">
				<xsl:text>-2</xsl:text>
			</xsl:when>
			<xsl:when test="$source='rcIBMPaperSrcNone'">
				<xsl:text>-1</xsl:text>
			</xsl:when>
			<xsl:when test="$source='rcIBMPaperSrcSame'">
				<xsl:text>0</xsl:text>
			</xsl:when>
			<xsl:when test="$source='rcIBMPaperSrcLetter'">
				<xsl:text>1</xsl:text>
			</xsl:when>
			<xsl:when test="$source='rcIBMPaperSrcLegal'">
				<xsl:text>2</xsl:text>
			</xsl:when>
			<xsl:when test="$source='rcIBMPaperSrcExecutive'">
				<xsl:text>3</xsl:text>
			</xsl:when>
			<xsl:when test="$source='rcIBMPaperSrcA4'">
				<xsl:text>4</xsl:text>
			</xsl:when>
			<xsl:when test="$source='rcIBMPaperSrcA5'">
				<xsl:text>5</xsl:text>
			</xsl:when>
			<xsl:when test="$source='rcIBMPaperSrcB5'">
				<xsl:text>6</xsl:text>
			</xsl:when>
			<xsl:when test="$source='rcIBMPaperSrcCont80'">
				<xsl:text>7</xsl:text>
			</xsl:when>
			<xsl:when test="$source='rcIBMPaperSrcCont132'">
				<xsl:text>8</xsl:text>
			</xsl:when>
			<xsl:when test="$source='rcIBMPaperSrcMonarch'">
				<xsl:text>9</xsl:text>
			</xsl:when>
			<xsl:when test="$source='rcIBMPaperSrcNumber9'">
				<xsl:text>10</xsl:text>
			</xsl:when>
			<xsl:when test="$source='rcIBMPaperSrcNumber10'">
				<xsl:text>11</xsl:text>
			</xsl:when>
			<xsl:when test="$source='rcIBMPaperSrcC5'">
				<xsl:text>12</xsl:text>
			</xsl:when>
			<xsl:when test="$source='rcIBMPaperSrcDL'">
				<xsl:text>13</xsl:text>
			</xsl:when>
			<xsl:when test="$source='rcIBMPaperSrcA3'">
				<xsl:text>14</xsl:text>
			</xsl:when>
			<xsl:when test="$source='rcIBMPaperSrcB4'">
				<xsl:text>15</xsl:text>
			</xsl:when>
			<xsl:when test="$source='rcIBMPaperSrcLedger'">
				<xsl:text>16</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>-2</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
</xsl:template>

<xsl:template name = "PRINTERSERVICE">
	<xsl:element name = "CONTAINER">
		<xsl:attribute name = "NAME">
			<xsl:text>com.wrq.printer.PrinterService</xsl:text>
		</xsl:attribute>
		<xsl:element name="CONTEXT_CHILD_STATE">
			<xsl:element name = "COMMAND_LIST">
				<xsl:attribute name = "SIZE">
					<xsl:text>1</xsl:text>
				</xsl:attribute>
				<xsl:element name = "COMMAND">
					<xsl:attribute name = "NAME">
						<xsl:text>IPrinterService.configure</xsl:text>
					</xsl:attribute>
					<xsl:element name = "NULL">
					</xsl:element>				
				</xsl:element>
			</xsl:element>
			<xsl:element name = "PROPERTY_STATE">
			<xsl:attribute name = "SIZE">
				<xsl:text>46</xsl:text>
			</xsl:attribute>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>autoFF</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintFormFeedOnEndOfJob']/BOOL"/>					
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>closePrinterManually</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintFlushOnEndOfJob']/BOOL"/>					
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>printJobTerminationDelay</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INTEGER">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcHostPrintTimeout']/INT[2]"/>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>fitToPage</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintFitToPage']/BOOL"/>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>graphicalPrinting</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<xsl:text>false</xsl:text>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>overrideHostFormat</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintOverrideHostFmt']/BOOL"/>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>pageOrientation</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INTEGER">
						<xsl:variable name="pageorientation">
							<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrinterOrientation']/INT[2]"/>					
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="$pageorientation='rcDefaultOrientation'">
								<xsl:text>0</xsl:text>
							</xsl:when>
							<xsl:when test="$pageorientation='rcPortraitOrientation'">
								<xsl:text>1</xsl:text>
							</xsl:when>
							<xsl:when test="$pageorientation='rcLandscapeOrientation'">
								<xsl:text>2</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>0</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>paperSize</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INTEGER">
						<xsl:text>0</xsl:text>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>printerFont</xsl:text>
					</xsl:attribute>
					<xsl:element name = "STRING">
						<xsl:text>Monospaced</xsl:text>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>printFileName</xsl:text>
					</xsl:attribute>
					<!-- TODO: fill in the first string -->
					
					<xsl:variable name="fullpath">
						<xsl:value-of select="//COMMAND[@name='SetString' and INT='rcPrintFileName']/STRING"/>
					</xsl:variable>
					
					<xsl:variable name="path">
					  <xsl:call-template name="get-path">
						<xsl:with-param name="file" select="$fullpath"/>
						<xsl:with-param name="path"/>
					  </xsl:call-template>
					</xsl:variable>
					
					<xsl:element name = "PAIR">
						<xsl:element name = "FIRST">
							<xsl:element name = "STRING">
								<xsl:value-of select = "$path"/> 
							</xsl:element>
						</xsl:element>
						<xsl:element name = "SECOND">
							<xsl:element name = "STRING">
								<xsl:value-of select="substring-after($fullpath, $path)"/>
							</xsl:element>
						</xsl:element>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>printFileMode</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INTEGER">
						<xsl:variable name="printfilemode">
							<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintFileExistsAction']/INT[2]"/>					
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="$printfilemode='rcAutonumber'">
								<xsl:text>2</xsl:text>
							</xsl:when>
							<xsl:when test="$printfilemode='rcOverwrite'">
								<xsl:text>3</xsl:text>
							</xsl:when>
							<xsl:when test="$printfilemode='rcOpenError'">
								<xsl:text>4</xsl:text>
							</xsl:when>
							<xsl:when test="$printfilemode='rcAskUser'">
								<xsl:text>5</xsl:text>
							</xsl:when>
							<xsl:when test="$printfilemode='rcAppend'">
								<xsl:text>6</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>5</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>printToFile</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintToFile']/BOOL"/>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>charsPerLine</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INTEGER">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintCharsPerLine']/INT[2]"/>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>linesPerPage</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INTEGER">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintLinesPerPage']/INT[2]"/>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>printerBottomMargin</xsl:text>
					</xsl:attribute>
					<xsl:element name = "FLOAT">
						<xsl:call-template name = "CALCULATEMARGIN">
							<xsl:with-param name="margin">rcPrintMarginBottom</xsl:with-param>
						</xsl:call-template>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>printerLeftMargin</xsl:text>
					</xsl:attribute>
					<xsl:element name = "FLOAT">
						<xsl:call-template name = "CALCULATEMARGIN">
							<xsl:with-param name="margin">rcPrintMarginLeft</xsl:with-param>
						</xsl:call-template>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>printerRightMargin</xsl:text>
					</xsl:attribute>
					<xsl:element name = "FLOAT">
						<xsl:call-template name = "CALCULATEMARGIN">
							<xsl:with-param name="margin">rcPrintMarginRight</xsl:with-param>
						</xsl:call-template>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>printerTopMargin</xsl:text>
					</xsl:attribute>
					<xsl:element name = "FLOAT">
						<xsl:call-template name = "CALCULATEMARGIN">
							<xsl:with-param name="margin">rcPrintMarginTop</xsl:with-param>
						</xsl:call-template>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>hostChangedCPI</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<xsl:text>false</xsl:text>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>hostChangedCPL</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<xsl:text>false</xsl:text>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>hostChangedLPI</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<xsl:text>false</xsl:text>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>hostChangedLPP</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<xsl:text>false</xsl:text>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>hostChangedPageFormat</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<xsl:text>false</xsl:text>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>hostChangedMargins</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<xsl:text>false</xsl:text>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>hostSpecifiedCPI</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INTEGER">
						<xsl:text>10</xsl:text>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>hostSpecifiedCharsPerLine</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INTEGER">
						<xsl:text>80</xsl:text>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>hostSpecifiedLPI</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INTEGER">
						<xsl:text>6</xsl:text>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>hostSpecifiedLinesPerPage</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INTEGER">
						<xsl:text>60</xsl:text>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>hostSpecifiedBottomMargin</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INTEGER">
						<xsl:text>60</xsl:text>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>hostSpecifiedLeftMargin</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INTEGER">
						<xsl:text>1</xsl:text>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>hostSpecifiedRightMargin</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INTEGER">
						<xsl:text>80</xsl:text>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>hostSpecifiedTopMargin</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INTEGER">
						<xsl:text>1</xsl:text>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>printDataToFile</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<xsl:text>false</xsl:text>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>emulatorSpecifiedPrintDataToFile</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<xsl:text>false</xsl:text>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>printerMarginUnitsOfMeasurement</xsl:text>
					</xsl:attribute>
					<xsl:element name = "STRING">
						<xsl:choose>
							<xsl:when test="//COMMAND[@name='SetNumeric' and INT='rcLocale']/INT[2] ='rcEnglishLanguage'">
								<xsl:text>english</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>metric</xsl:text>
							</xsl:otherwise>
						</xsl:choose>						
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>autoPrintFormFeed</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<!-- readonly Rweb setting -->
						<xsl:text>false</xsl:text>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>autoPrintLineFeed</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<!-- no Ribm equivalent -->
						<xsl:text>true</xsl:text>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>dontShowOrientationDlg</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<!-- no Ribm equivalent -->
						<xsl:text>true</xsl:text>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>paperWidth</xsl:text>
					</xsl:attribute>
					<xsl:element name = "FLOAT">
						<xsl:choose>
							<xsl:when test="//COMMAND[@name='SetNumeric' and INT='rcLocale']/INT[2] ='rcEnglishLanguage'">
								<xsl:text>8.5</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>215.9</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>paperHeight</xsl:text>
					</xsl:attribute>
					<xsl:element name = "FLOAT">
						<xsl:choose>
							<xsl:when test="//COMMAND[@name='SetNumeric' and INT='rcLocale']/INT[2] ='rcEnglishLanguage'">
								<xsl:text>11.0</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>279.4</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>paperScalingPercentageX</xsl:text>
					</xsl:attribute>
					<xsl:element name = "FLOAT">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintFitUserWidth']/INT[2]"/>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>paperScalingPercentageY</xsl:text>
					</xsl:attribute>
					<xsl:element name = "FLOAT">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcPrintFitUserLength']/INT[2]"/>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>overstrikeCharacter</xsl:text>
					</xsl:attribute>
					<xsl:element name = "STRING">
						<!-- no Ribm equivalent -->
						<xsl:text>-</xsl:text>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>printDBCSScale</xsl:text>
					</xsl:attribute>
					<xsl:element name = "STRING">
						<xsl:text>1:2</xsl:text>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>fitHostPageX</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<xsl:text>true</xsl:text>
					</xsl:element>
				</xsl:element>
				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>fitHostPageY</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<xsl:text>true</xsl:text>
					</xsl:element>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:element>
</xsl:template>

<!-- For the KEYMAP4 Container we want to produce something like this for 
	SetKeyMap rcShift, "G", "AboutReflectionDlg"
	
	<CONTAINER NAME="KeyMap-4">
		<RKEYSTROKE_ARRAY SIZE="1">
			<RKEYSTROKE>
				<KEYSTROKE>
					<KEYCODE>71</KEYCODE> 
					<MODIFIERS>1</MODIFIERS> 
				</KEYSTROKE>
				<COMMAND_ACTION NAME="Shift+G">
					<COMMAND NAME="Glue.aboutBoxDialog">
						<NULL />
					</COMMAND>
				</COMMAND_ACTION>
			</RKEYSTROKE>
		</RKEYSTROKE_ARRAY>
	</CONTAINER>

	SetKeyMap rcShift, "S", "TransmitTerminalKey rcIBMEnterKey"  will produce: 
	
	<CONTAINER NAME="KeyMap-4">
		<RKEYSTROKE_ARRAY SIZE="1">
			<RKEYSTROKE>
				<KEYSTROKE>
					<KEYCODE>83</KEYCODE>
					<MODIFIERS>1</MODIFIERS>
				</KEYSTROKE>
				<COMMAND_ACTION NAME="Shift+S">
					<COMMAND NAME="Emulator.transmitTerminalKey">
						<OBJECT_ARRAY SIZE="1">
							<INTEGER>29</INTEGER>
						</OBJECT_ARRAY>
					</COMMAND>
				</COMMAND_ACTION>
			</RKEYSTROKE>
		</RKEYSTROKE_ARRAY>
	</CONTAINER>
-->
<xsl:template name = "KEYMAP4" >       <!-- see comments above -->
	<xsl:element name = "CONTAINER">
		<xsl:attribute name = "NAME">
			<xsl:text>KeyMap-4</xsl:text>
		</xsl:attribute>		
		<xsl:element name = "RKEYSTROKE_ARRAY">
			<xsl:attribute name = "SIZE">
				<xsl:value-of select="count(//COMMAND[@name='SetKeyMap'])"/>
			</xsl:attribute>
			<xsl:for-each select="//COMMAND[@name='SetKeyMap']">
				<xsl:element name = "RKEYSTROKE">
					<xsl:element name = "KEYSTROKE">
						<xsl:element name = "KEYCODE">
							<xsl:call-template name="CALC_KEYCODE_FROM_RIBMKEY"/>
						</xsl:element>
						<xsl:element name = "MODIFIERS">
							<xsl:call-template name="CALC_MODIFIERS_FROM_RIBM"/>
						</xsl:element>
					</xsl:element>	
					<xsl:element name = "COMMAND_ACTION">
						<xsl:attribute name = "NAME">
							<!-- don't do anything, (I think) Rweb will automatically create this-->
						</xsl:attribute>		
						<xsl:call-template name="BUILD_KEYCOMMAND"/>
					</xsl:element>
				</xsl:element>
			</xsl:for-each>
		</xsl:element>
	</xsl:element>
</xsl:template>

<xsl:template name = "CALC_KEYCODE_FROM_RIBMKEY">
	<!-- figure out keycode based on Ribm key. Ex: "S" maps to 83  
	Steps to map a Ribm string:
	1. look up the string in r8keynam.h (Ex: "Center" -> "VK_CLEAR")
	2. look up VK_CLEAR in the Java spec for key events (Google searh = "Java SDK KeyEvent")
	   (http://java.sun.com/j2se/1.4.1/docs/api/constant-values.html#java.awt.event.KeyEvent.VK_CLEAR)
	   use the corresponding number VK_CLEAR = "12"
	   note: the Java key event numbers do not match the Ribm constants
	   note: some Ribm keys do not have Java equivalents, ex: KpEnter. (map to same key event as Return)
	-->
	
	<xsl:choose>
		<xsl:when test="STRING[1] ='Break'">
			<xsl:text>3</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Backspace'">
			<xsl:text>8</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Tab'">
			<xsl:text>9</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Return'">
			<xsl:text>10</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='KpEnter'">
			<xsl:text>10</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Center'">
			<xsl:text>12</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='OemClear'">
			<xsl:text>12</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='LeftShift'">
			<xsl:text>16</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='RightShift'">
			<xsl:text>16</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='LeftControl'">
			<xsl:text>17</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='RightControl'">
			<xsl:text>17</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='LeftAlt'">
			<xsl:text>18</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='RightAlt'">
			<xsl:text>18</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='PauseKey'">
			<xsl:text>19</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='CapsLock'">
			<xsl:text>20</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Kana'">
			<xsl:text>21</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Kanji'">
			<xsl:text>25</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Esc'">
			<xsl:text>27</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Convert'">
			<xsl:text>28</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='NonConvert'">
			<xsl:text>29</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Space'">
			<xsl:text>32</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='PgUp'">
			<xsl:text>33</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='PgDn'">
			<xsl:text>34</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='End'">
			<xsl:text>35</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Home'">
			<xsl:text>36</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='LeftKey'">
			<xsl:text>37</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='UpKey'">
			<xsl:text>38</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='RightKey'">
			<xsl:text>39</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='DownKey'">
			<xsl:text>40</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='CpLeft'">
			<xsl:text>37</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='CpUp'">
			<xsl:text>38</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='CpRight'">
			<xsl:text>39</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='CpDown'">
			<xsl:text>40</xsl:text>
		</xsl:when>

		<xsl:when test="STRING[1] ='Comma'">
			<xsl:text>44</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Dash'">
			<xsl:text>45</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Period'">
			<xsl:text>46</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Slash'">
			<xsl:text>47</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='0'">
			<xsl:text>48</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='1'">
			<xsl:text>49</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='2'">
			<xsl:text>50</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='3'">
			<xsl:text>51</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='4'">
			<xsl:text>52</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='5'">
			<xsl:text>53</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='6'">
			<xsl:text>54</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='7'">
			<xsl:text>55</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='8'">
			<xsl:text>56</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='9'">
			<xsl:text>57</xsl:text>
		</xsl:when>

		<xsl:when test="STRING[1] ='Semicolon'">
			<xsl:text>59</xsl:text>
		</xsl:when>
		
		<xsl:when test="STRING[1] ='Equals'">
			<xsl:text>61</xsl:text>
		</xsl:when>

		<xsl:when test="STRING[1] ='A'">
			<xsl:text>65</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='B'">
			<xsl:text>66</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='C'">
			<xsl:text>67</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='D'">
			<xsl:text>68</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='E'">
			<xsl:text>69</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='F'">
			<xsl:text>70</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='G'">
			<xsl:text>71</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='H'">
			<xsl:text>72</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='I'">
			<xsl:text>73</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='J'">
			<xsl:text>74</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='K'">
			<xsl:text>75</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='L'">
			<xsl:text>76</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='M'">
			<xsl:text>77</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='N'">
			<xsl:text>78</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='O'">
			<xsl:text>79</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='P'">
			<xsl:text>80</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Q'">
			<xsl:text>81</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='R'">
			<xsl:text>82</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='S'">
			<xsl:text>83</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='T'">
			<xsl:text>84</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='U'">
			<xsl:text>85</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='V'">
			<xsl:text>86</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='W'">
			<xsl:text>87</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='X'">
			<xsl:text>88</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Y'">
			<xsl:text>89</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Z'">
			<xsl:text>90</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='OpenBracket'">
			<xsl:text>91</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='BackSlash'">
			<xsl:text>92</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='CloseBracket'">
			<xsl:text>93</xsl:text>
		</xsl:when>
		
		<xsl:when test="STRING[1] ='Kp0'">
			<xsl:text>96</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Kp1'">
			<xsl:text>97</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Kp2'">
			<xsl:text>98</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Kp3'">
			<xsl:text>99</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Kp4'">
			<xsl:text>100</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Kp5'">
			<xsl:text>101</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Kp6'">
			<xsl:text>102</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Kp7'">
			<xsl:text>103</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Kp8'">
			<xsl:text>104</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Kp9'">
			<xsl:text>105</xsl:text>
		</xsl:when>

		<xsl:when test="STRING[1] ='KpMultiply'">
			<xsl:text>106</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='KpPlus'">
			<xsl:text>107</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='KpSeparator'">
			<xsl:text>108</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='KpMinus'">
			<xsl:text>109</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='KpDecimal'">
			<xsl:text>110</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='KpDivide'">
			<xsl:text>111</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='F1'">
			<xsl:text>112</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='F2'">
			<xsl:text>113</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='F3'">
			<xsl:text>114</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='F4'">
			<xsl:text>115</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='F5'">
			<xsl:text>116</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='F6'">
			<xsl:text>117</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='F7'">
			<xsl:text>118</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='F8'">
			<xsl:text>119</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='F9'">
			<xsl:text>120</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='F10'">
			<xsl:text>121</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='F11'">
			<xsl:text>122</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='F12'">
			<xsl:text>123</xsl:text>
		</xsl:when>

		<xsl:when test="STRING[1] ='Del'">
			<xsl:text>127</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Grave'">
			<xsl:text>128</xsl:text>
		</xsl:when>

		<xsl:when test="STRING[1] ='Numlock'">
			<xsl:text>144</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='KpNumLock'">
			<xsl:text>144</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='ScrollLock'">
			<xsl:text>145</xsl:text>
		</xsl:when>

		
		<xsl:when test="STRING[1] ='Lt'">
			<xsl:text>153</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='PrintScreen'">
			<xsl:text>154</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Ins'">
			<xsl:text>155</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Help'">
			<xsl:text>156</xsl:text>
		</xsl:when>

		<xsl:when test="STRING[1] ='Apostrophe'">
			<xsl:text>222</xsl:text>
		</xsl:when>


		<xsl:when test="STRING[1] ='F13'">
			<xsl:text>61440</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='F14'">
			<xsl:text>61441</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='F15'">
			<xsl:text>61442</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='F16'">
			<xsl:text>61443</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='F17'">
			<xsl:text>61444</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='F18'">
			<xsl:text>61445</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='F19'">
			<xsl:text>61446</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='F20'">
			<xsl:text>61447</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='F21'">
			<xsl:text>61448</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='F22'">
			<xsl:text>61449</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='F23'">
			<xsl:text>61450</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='F24'">
			<xsl:text>61451</xsl:text>
		</xsl:when>
		
		<xsl:when test="STRING[1] ='Compose'">
			<xsl:text>65312</xsl:text>
		</xsl:when>


		<xsl:when test="STRING[1] ='CrSel'">
			<xsl:text>0</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='NoName'">
			<xsl:text>0</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Section'">
			<xsl:text>0</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='SnapShot'">
			<xsl:text>0</xsl:text>
		</xsl:when>
		<xsl:when test="STRING[1] ='Zoom'">
			<xsl:text>0</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>0</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name = "CALC_MODIFIERS_FROM_RIBM">
<!-- Rweb conversion: Shift=1, Cntl=2, Meta=4, Alt=8 -->
	<xsl:choose>
		<xsl:when test="INT[1] ='rcNormal'">
			<xsl:text>0</xsl:text>
		</xsl:when>
		<xsl:when test="INT[1] ='rcAlt'">
			<xsl:text>8</xsl:text>
		</xsl:when>
		<xsl:when test="INT[1] ='rcCtrl'">
			<xsl:text>2</xsl:text>
		</xsl:when>
		<xsl:when test="INT[1] ='rcShift'">
			<xsl:text>1</xsl:text>
		</xsl:when>
		<xsl:when test="INT[1] ='rcAltCtrl'">
			<xsl:text>10</xsl:text>
		</xsl:when>
		<xsl:when test="INT[1] ='rcAltShift'">
			<xsl:text>9</xsl:text>
		</xsl:when>
		<xsl:when test="INT[1] ='rcCtrlShift'">
			<xsl:text>3</xsl:text>
		</xsl:when>
		<xsl:when test="INT[1] ='rcAltCtrlShift'">
			<xsl:text>11</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>0</xsl:text>
		</xsl:otherwise>
	</xsl:choose>	
</xsl:template>

<xsl:template name="UNDOUBLEQUOTES">
<!-- 	Within a STRING double quotes will be converted to single double quotes
	For example: brian ""testing"" drye
	becomes :    brian "testing" drye -->
	<xsl:param name="string" />
	<xsl:if test="contains($string, '&#x22;&#x22;')">
		<xsl:value-of select="substring-before($string, '&#x22;&#x22;')" />
		<xsl:text>&#x22;</xsl:text>
		<xsl:call-template name="UNDOUBLEQUOTES">
	                <xsl:with-param name="string">
	                	<xsl:value-of select="substring-after($string, '&#x22;&#x22;')" />
	                </xsl:with-param>
	        </xsl:call-template>
	</xsl:if>
	<xsl:if test="not(contains($string, '&#x22;&#x22;'))">
		<xsl:value-of select="$string" />
	</xsl:if>
</xsl:template>


<xsl:template name="TRANSMITANSIPOSTQUOTEPARSER">
	<xsl:param name="string" />
	<xsl:if test="starts-with($string, '&#x22;')">
		<xsl:text>&#x22;</xsl:text>
		<xsl:call-template name="TRANSMITANSICHARPARSER">
            <xsl:with-param name="string">
            	<xsl:value-of select="substring-after($string, '&#x22;')" />
            </xsl:with-param>
        </xsl:call-template>
	</xsl:if>
	<xsl:if test="not(starts-with($string, '&#x22;'))">
		<xsl:text></xsl:text>
	</xsl:if>
</xsl:template>

<xsl:template name="TRANSMITANSICHARPARSER">
 	<!-- Get the correct string following a TransmitANSI command, pay careful attention to double quotes 
	For example, (from XML): TransmitANSI "abc""def" TransmitANSI "123""456" SaveDisplayDlg
	 should end up (config): abc""def	-->

	<xsl:param name="string" />
	
	<xsl:if test="not(starts-with($string, '&#x22;'))">
		<xsl:value-of select="substring-before($string, '&#x22;')" />
	</xsl:if>	
	<xsl:call-template name="TRANSMITANSIPOSTQUOTEPARSER">
        <xsl:with-param name="string">
           	<xsl:value-of select="substring-after($string, '&#x22;')" />
		</xsl:with-param>
    </xsl:call-template>
</xsl:template>


<xsl:template name = "BUILD_KEYCOMMAND">
	<!-- build keycommand based on Ribm command string. Ex: "AboutReflectionDlg" or "TransmitTerminalKey rcIBMEnterKey -->		
	<xsl:element name = "COMMAND">
		<xsl:attribute name = "NAME">
			<xsl:choose>
				<xsl:when test="starts-with(STRING[2],'TransmitTerminalKey')">
					<xsl:text>Emulator.transmitTerminalKey</xsl:text>
				</xsl:when>
				<xsl:when test="starts-with(STRING[2],'TransmitANSI')">
					<xsl:text>Emulator.transmitString</xsl:text>
				</xsl:when>
				<xsl:when test="starts-with(STRING[2],'AboutReflectionDlg')">
					<xsl:text>Glue.aboutBoxDialog</xsl:text>
				</xsl:when>
				<xsl:when test="starts-with(STRING[2],'Connect')">
					<xsl:text>ISession.connect</xsl:text>
				</xsl:when>
				<xsl:when test="starts-with(STRING[2],'Disconnect')">
					<xsl:text>ISession.disconnect</xsl:text>
				</xsl:when>
				<xsl:when test="starts-with(STRING[2],'CopySelection')">
					<xsl:text>Glue.copy</xsl:text>
				</xsl:when>
				<xsl:when test="starts-with(STRING[2],'Paste')">
					<xsl:text>Glue.paste</xsl:text>
				</xsl:when>
				<xsl:when test="starts-with(STRING[2],'PrintScreen rcPrintPartition') or
				                starts-with(STRING[2],'Print rcPrintPartition')">
					<xsl:text>Glue.screenPrint</xsl:text>
				</xsl:when>
				<xsl:when test="starts-with(STRING[2],'PrintScreen rcPrintScreenOrSel') or
				                starts-with(STRING[2],'Print rcPrintScreenOrSel')">
					<xsl:text>Glue.selectionPrint</xsl:text>
				</xsl:when>
				<xsl:when test="starts-with(STRING[2],'PrintScreen rcPrintScreen') or
				                starts-with(STRING[2],'Print rcPrintScreen')">
					<xsl:text>Glue.screenPrint</xsl:text>
				</xsl:when>
				<xsl:when test="starts-with(STRING[2],'PrintScreen rcPrintSel') or
				                starts-with(STRING[2],'Print rcPrintSel')">
					<xsl:text>Glue.selectionPrint</xsl:text>
				</xsl:when>
				<xsl:when test="starts-with(STRING[2],'SelectAll')">
					<xsl:text>Glue.selectAll</xsl:text>
				</xsl:when>
				<xsl:when test="starts-with(STRING[2],'SelectWord')">
					<xsl:text>ITDService.selectWordRight</xsl:text>
				</xsl:when>
				<xsl:otherwise> <!-- disable the key -->
					<xsl:text>Emulator.transmitTerminalKey</xsl:text>
				</xsl:otherwise>
			</xsl:choose>		
		</xsl:attribute>
		
		<xsl:choose>
			<xsl:when test="starts-with(STRING[2],'TransmitTerminalKey')">
				<xsl:element name = "OBJECT_ARRAY">
					<xsl:attribute name = "SIZE">
						<xsl:text>1</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INTEGER">
						<xsl:call-template name="GETTERMINALKEY"/>
					</xsl:element>
				</xsl:element>
			</xsl:when>
			<xsl:when test="starts-with(STRING[2],'TransmitANSI')">
				<xsl:element name = "OBJECT_ARRAY">
					<xsl:attribute name = "SIZE">
						<xsl:text>1</xsl:text>
					</xsl:attribute>
					<xsl:element name = "STRING">
						<xsl:call-template name="TRANSMITANSICHARPARSER">
							<xsl:with-param name="string">
								<xsl:value-of select="substring-after(STRING[2], '&quot;')"/>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:element>
				</xsl:element>
			</xsl:when>			
			<xsl:when test="starts-with(STRING[2],'AboutReflectionDlg') or
							starts-with(STRING[2],'Connect') or
							starts-with(STRING[2],'Disconnect') or
							starts-with(STRING[2],'CopySelection') or
							starts-with(STRING[2],'Paste') or
							starts-with(STRING[2],'PrintScreen rcPrintPartition') or
							starts-with(STRING[2],'Print rcPrintPartition') or
							starts-with(STRING[2],'PrintScreen rcPrintScreenOrSel') or
							starts-with(STRING[2],'Print rcPrintScreenOrSel') or
							starts-with(STRING[2],'PrintScreen rcPrintScreen') or
							starts-with(STRING[2],'Print rcPrintScreen') or
							starts-with(STRING[2],'PrintScreen rcPrintSel') or
							starts-with(STRING[2],'Print rcPrintSel') or
							starts-with(STRING[2],'SelectAll') or
							starts-with(STRING[2],'SelectWord')">
				<xsl:element name = "NULL"/>
			</xsl:when>
			<xsl:otherwise> <!-- disable the key. this goes with the transmitTerminalKey from above -->
				<xsl:element name = "OBJECT_ARRAY">
					<xsl:attribute name = "SIZE">
						<xsl:text>1</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INTEGER">
						<xsl:text>-1</xsl:text>
					</xsl:element>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:element>
</xsl:template>

<!-- Ribm terminal keys are listed in r8const.h
	 Rweb terminal keys are listed in Pk_IBM3270.java and Pk_IBM5250.java
-->
<xsl:template name = "GETTERMINALKEY">
	<xsl:variable name="terminaltype">
		<xsl:call-template name="TERMINALTYPE"/>
	</xsl:variable>	
	<xsl:choose>
		<xsl:when test="$terminaltype = 'ibm3270'">
			<xsl:call-template name="GET3270TERMINALKEY"/>
		</xsl:when>
		<xsl:when test="$terminaltype = 'ibm5250'">
			<xsl:call-template name="GET5250TERMINALKEY"/>
		</xsl:when>
	</xsl:choose>
</xsl:template>


<xsl:template name = "GET3270TERMINALKEY">
	<xsl:variable name="rcibmkey">
		<xsl:call-template name="GETONEARGUMENT"/>
	</xsl:variable>	
	<xsl:choose>
		<xsl:when test="$rcibmkey = 'rcIBMDeleteCharKey'">
			<xsl:text>1</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMDeleteKey'">
			<xsl:text>1</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMDeleteWordKey'">
			<xsl:text>2</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMDupKey'">
			<xsl:text>3</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMEraseEOFKey'">
			<xsl:text>4</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMSysreqstKey'">
			<xsl:text>5</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPf1Key'">
			<xsl:text>6</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPf2Key'">
			<xsl:text>7</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPf3Key'">
			<xsl:text>8</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPf4Key'">
			<xsl:text>9</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPf5Key'">
			<xsl:text>10</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPf6Key'">
			<xsl:text>11</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPf7Key'">
			<xsl:text>12</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPf8Key'">
			<xsl:text>13</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPf9Key'">
			<xsl:text>14</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPf10Key'">
			<xsl:text>15</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPf11Key'">
			<xsl:text>16</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPf12Key'">
			<xsl:text>17</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPf13Key'">
			<xsl:text>18</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPf14Key'">
			<xsl:text>19</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPf15Key'">
			<xsl:text>20</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPf16Key'">
			<xsl:text>21</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPf17Key'">
			<xsl:text>22</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPf18Key'">
			<xsl:text>23</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPf19Key'">
			<xsl:text>24</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPf20Key'">
			<xsl:text>25</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPf21Key'">
			<xsl:text>26</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPf22Key'">
			<xsl:text>27</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPf23Key'">
			<xsl:text>28</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPf24Key'">
			<xsl:text>29</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPA1Key'">
			<xsl:text>30</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPA2Key'">
			<xsl:text>31</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPA3Key'">
			<xsl:text>32</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMClearKey'">
			<xsl:text>33</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMClearPartitionKey'">
			<xsl:text>33</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMEnterKey'">
			<xsl:text>35</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMCursorSelectKey'">
			<xsl:text>36</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMAttnKey'">
			<xsl:text>37</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMBackSpaceKey'">
			<xsl:text>38</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMBacktabKey'">
			<xsl:text>39</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMDownKey'">
			<xsl:text>40</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMPageDownKey'">
			<xsl:text>40</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMEraseInputKey'">
			<xsl:text>41</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMHomeKey'">
			<xsl:text>42</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMIdentKey'">
			<xsl:text>43</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMInsertKey'">
			<xsl:text>44</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMLeftKey'">
			<xsl:text>45</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMLeftDoubleKey'">
			<xsl:text>46</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMNewLineKey'">
			<xsl:text>47</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMPrintKey'">
			<xsl:text>48</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMRightKey'">
			<xsl:text>49</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMRightDoubleKey'">
			<xsl:text>50</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMFieldMarkKey'">
			<xsl:text>51</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMTabKey'">
			<xsl:text>52</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMUpKey'">
			<xsl:text>53</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMUpDoubleKey'">
			<xsl:text>53</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMPageUpKey'">
			<xsl:text>53</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMEndOfFieldKey'">
			<xsl:text>55</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMDestrBackSpaceKey'">
			<xsl:text>56</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMDevicecancelKey'">
			<xsl:text>60</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMResetKey'">
			<xsl:text>65</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMFieldDelimKey'">
			<xsl:text>68</xsl:text>	
		</xsl:when>

		<xsl:otherwise> <!-- default to rcIBMRightKey, it seems harmless enough -->
			<xsl:text>49</xsl:text>	
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name = "GET5250TERMINALKEY">
	<xsl:variable name="rcibmkey">
		<xsl:call-template name="GETONEARGUMENT"/>
	</xsl:variable>	
	<xsl:choose>
		<xsl:when test="$rcibmkey = 'rcIBMF1Key'">
			<xsl:text>1</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMF2Key'">
			<xsl:text>2</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMF3Key'">
			<xsl:text>3</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMF4Key'">
			<xsl:text>4</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMF5Key'">
			<xsl:text>5</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMF6Key'">
			<xsl:text>6</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMF7Key'">
			<xsl:text>7</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMF8Key'">
			<xsl:text>8</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMF9Key'">
			<xsl:text>9</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMF10Key'">
			<xsl:text>10</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMF11Key'">
			<xsl:text>11</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMF12Key'">
			<xsl:text>12</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMF13Key'">
			<xsl:text>13</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMF14Key'">
			<xsl:text>14</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMF15Key'">
			<xsl:text>15</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMF16Key'">
			<xsl:text>16</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMF17Key'">
			<xsl:text>17</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMF18Key'">
			<xsl:text>18</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMF19Key'">
			<xsl:text>19</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMF20Key'">
			<xsl:text>20</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMF21Key'">
			<xsl:text>21</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMF22Key'">
			<xsl:text>22</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMF23Key'">
			<xsl:text>23</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMF24Key'">
			<xsl:text>24</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPA1Key'">
			<xsl:text>25</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPA2Key'">
			<xsl:text>26</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPA3Key'">
			<xsl:text>27</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMHomeKey'">
			<xsl:text>28</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMEnterKey'">
			<xsl:text>29</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMClearKey'">
			<xsl:text>30</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMClearPartitionKey'">
			<xsl:text>30</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMCursorSelectKey'">
			<xsl:text>31</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMUpKey'">
			<xsl:text>32</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMUpDoubleKey'">
			<xsl:text>53</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMPageUpKey'">
			<xsl:text>32</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMDownKey'">
			<xsl:text>33</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMPageDownKey'">
			<xsl:text>40</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMLeftKey'">
			<xsl:text>34</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMRightKey'">
			<xsl:text>35</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMBackSpaceKey'">
			<xsl:text>36</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 'rcIBMInsertKey'">
			<xsl:text>37</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMDeleteCharKey'">
			<xsl:text>38</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMDeleteKey'">
			<xsl:text>38</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMTabKey'">
			<xsl:text>39</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMBacktabKey'">
			<xsl:text>40</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMFieldExitKey'">
			<xsl:text>41</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMFieldPlusKey'">
			<xsl:text>42</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMFieldMinusKey'">
			<xsl:text>43</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMEraseInputKey'">
			<xsl:text>44</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMEraseEOFKey'">
			<xsl:text>45</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMDuplicateKey'">
			<xsl:text>46</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMFieldMarkKey'">
			<xsl:text>47</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMEndOfFieldKey'">
			<xsl:text>48</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMDestrBackSpaceKey'">
			<xsl:text>49</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMResetKey'">
			<xsl:text>50</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMSysreqstKey'">
			<xsl:text>51</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMHelpKey'">
			<xsl:text>52</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMAttnKey'">
			<xsl:text>53</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMTestKey'">
			<xsl:text>54</xsl:text>	
		</xsl:when>
		<!-- not sure what Ribm key matches Rweb "kKeyShowAttr" -->
		<xsl:when test="$rcibmkey = 'rcIBMShowAttr'">
			<xsl:text>55</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMRollUpKey'">
			<xsl:text>56</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMRollDownKey'">
			<xsl:text>57</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMNewLineKey'">
			<xsl:text>58</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMHexKey'">
			<xsl:text>59</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMAU1Key'">
			<xsl:text>60</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMAU2Key'">
			<xsl:text>61</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMAU3Key'">
			<xsl:text>62</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMAU4Key'">
			<xsl:text>63</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMAU5Key'">
			<xsl:text>64</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMAU6Key'">
			<xsl:text>65</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMAU7Key'">
			<xsl:text>66</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMAU8Key'">
			<xsl:text>67</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMAU9Key'">
			<xsl:text>68</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMAU10Key'">
			<xsl:text>69</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMAU11Key'">
			<xsl:text>70</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMAU12Key'">
			<xsl:text>71</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMAU13Key'">
			<xsl:text>72</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMAU14Key'">
			<xsl:text>73</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMAU15Key'">
			<xsl:text>74</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMAU16Key'">
			<xsl:text>75</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 'rcIBMPrintKey'">
			<xsl:text>76</xsl:text>	
		</xsl:when>
		<!-- not sure what Ribm key matches Rweb "kKeyStartOfField" -->
		<xsl:when test="$rcibmkey = 'rcIBMStartOfFieldKey'">
			<xsl:text>77</xsl:text>	
		</xsl:when>
		<xsl:otherwise> <!-- default to right key. harmless enough -->
			<xsl:text>35</xsl:text>	
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name = "GETONEARGUMENT">
	<xsl:variable name="restofstring">
		<xsl:value-of select="substring(STRING[2], 21, string-length(STRING[2])-20)"/>
	</xsl:variable>	
	<xsl:choose>
		<xsl:when test="contains($restofstring, ' ')">
			<xsl:value-of select="substring-before($restofstring, ' ')"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$restofstring"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name = "CALCULATEMARGIN">
	<xsl:param name="margin"/>
	<xsl:choose>
		<xsl:when test="//COMMAND[@name='SetNumeric' and INT='rcLocale']/INT[2] ='rcEnglishLanguage'">
			<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT=$margin]/INT[2] div 1440"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select = "(//COMMAND[@name='SetNumeric' and INT=$margin]/INT[2] div 1440) * 25.4"/>
		</xsl:otherwise>
	</xsl:choose> 
</xsl:template>

<xsl:template name="get-path">
  <xsl:param name="file"/>
  <xsl:param name="path"/>
  <xsl:choose>
    <xsl:when test="string-length($file) > 0 and contains($file, '\')">
      <xsl:call-template name="get-path">
        <xsl:with-param name="file" select="substring-after($file, '\')"/>
        <xsl:with-param name="path" select="concat($path, substring-before($file, '\'), '\')"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$path"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name = "FILEXFERSERVICE">
	<xsl:element name = "CONTAINER">
		<xsl:attribute name = "NAME">
			<xsl:text>com.wrq.filexfer.FileXferService</xsl:text>
		</xsl:attribute>
		<xsl:element name = "CONTEXT_CHILD_STATE">

			<xsl:element name = "PROPERTY_STATE">
				<xsl:attribute name = "SIZE">
					<xsl:text>17</xsl:text>
				</xsl:attribute>

				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>transferLocalFile</xsl:text>
					</xsl:attribute>
					<xsl:element name = "STRING">   
						<xsl:value-of select = "//COMMAND[@name='SetString' and INT='rcXfrLocalFile']/STRING"/>
					</xsl:element>
				</xsl:element>

				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>transferHostFile</xsl:text>
					</xsl:attribute>
					<xsl:element name = "STRING">  
						<xsl:value-of select = "//COMMAND[@name='SetString' and INT='rcXfrRemoteFile']/STRING"/>
					</xsl:element>
				</xsl:element>

				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>transferType</xsl:text>
					</xsl:attribute>
					<xsl:element name = "STRING">  
						<xsl:variable name = "test">
							<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcDfltXfrType']/INT[2]"/>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="$test='rcXfrASCII'">
								<xsl:text>ASCII</xsl:text>
							</xsl:when>
							<xsl:when test="$test='rcXfrBinary'">
								<xsl:text>Binary</xsl:text>
							</xsl:when>
						</xsl:choose>
					</xsl:element>
				</xsl:element>

				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>transferExistsAction</xsl:text>
					</xsl:attribute>
					<xsl:element name = "STRING">  
						<xsl:variable name = "test">
							<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcDfltExistsAction']/INT[2]"/>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="$test='rcOverwrite'">
								<xsl:text>Overwrite</xsl:text>
							</xsl:when>
							<xsl:when test="$test='rcAskUser'">
								<xsl:text>Ask User</xsl:text>
							</xsl:when>
							<xsl:when test="$test='rcAppend'">
								<xsl:text>Append</xsl:text>
							</xsl:when>
							<xsl:when test="$test='rcOpenError'">
								<xsl:text>Open Error</xsl:text>
							</xsl:when>
						</xsl:choose>
					</xsl:element>
				</xsl:element>

				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>transferShowStatus</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<xsl:text>true</xsl:text>
					</xsl:element>
				</xsl:element>

				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>transferDirection</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INTEGER">
						<xsl:text>1</xsl:text>
					</xsl:element>
				</xsl:element>

				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>transferCurrentDirectory</xsl:text>
					</xsl:attribute>
					<xsl:element name = "STRING">  
						<xsl:value-of select = "//COMMAND[@name='SetString' and INT='rcXfrCurrentDirectory']/STRING"/>
					</xsl:element>
				</xsl:element>

				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>transferTimeout</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INTEGER">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcXfrTimeout']/INT[2]"/>
					</xsl:element>
				</xsl:element>

				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>transferStartTimeout</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INTEGER">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcXfrStartTimeout']/INT[2]"/>
					</xsl:element>
				</xsl:element>

				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>transferCurrentProtocol</xsl:text>
					</xsl:attribute>
					<xsl:element name = "STRING">  
						<xsl:value-of select = "//COMMAND[@name='SetString' and INT='rcXfrHostCmd']/STRING"/>
					</xsl:element>
				</xsl:element>

				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>transferProgressLocalFile</xsl:text>
					</xsl:attribute>
					<xsl:element name = "STRING">  
						<xsl:text></xsl:text>
					</xsl:element>
				</xsl:element>

				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>transferProgressHostFile</xsl:text>
					</xsl:attribute>
					<xsl:element name = "STRING">  
						<xsl:text></xsl:text>
					</xsl:element>
				</xsl:element>

				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>spacesToUnderscore</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcXfrSpacesToUnderscores']/BOOL"/>
					</xsl:element>
				</xsl:element>

				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>underscoreToSpaces</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcXfrUnderscoresToSpaces']/BOOL"/>
					</xsl:element>
				</xsl:element>

				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>truncateTo8dot3</xsl:text>
					</xsl:attribute>
					<xsl:element name = "BOOLEAN">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcXfrReceive8Dot3']/BOOL"/>
					</xsl:element>
				</xsl:element>

				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>display8dot3</xsl:text>
					</xsl:attribute>
					<xsl:element name = "STRING">
						<xsl:variable name = "test">
							<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcXfr8Dot3FilenameCase']/INT[2]"/>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="$test='rcLowerCase'">
								<xsl:text>Lower Case</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>Upper Case</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:element>
				</xsl:element>

				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:text>transferProgress</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INTEGER">  
						<xsl:text>0</xsl:text>
					</xsl:element>
				</xsl:element>

			</xsl:element>
		</xsl:element>
	</xsl:element>
</xsl:template>

<xsl:template name = "INDFILETRANSFER">
	<xsl:element name = "CONTAINER">
		<xsl:attribute name = "NAME">
			<xsl:text>com.wrq.filexfer.indxfer.INDFileTransfer</xsl:text>
		</xsl:attribute>

		<xsl:element name = "PROPERTY_STATE">
			<xsl:attribute name = "SIZE">
				<xsl:text>21</xsl:text>
			</xsl:attribute>

			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>indAutoPositionCursor</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">   
					<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcIndAutoPositionCursor']/BOOL"/>
				</xsl:element>
			</xsl:element>

			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>indAdditionalParms</xsl:text>
				</xsl:attribute>
				<xsl:element name = "STRING">  
					<xsl:value-of select = "//COMMAND[@name='SetString' and INT='rcXfrAddParam']/STRING"/>
				</xsl:element>
			</xsl:element>

			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>indBinaryCrlf</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">   
					<xsl:variable name = "test">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcXfrBinaryCRLF']/INT[2]"/>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="$test='rcConvert'">
							<xsl:text>true</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>false</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>

			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>indAsciiCrlf</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">   
					<xsl:variable name = "test">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcXfrASCIICRLF']/INT[2]"/>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="$test='rcConvert'">
							<xsl:text>true</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>false</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>

			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>indJisciiCrlf</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">   
					<xsl:variable name = "test">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcXfrJISCIICRLF']/INT[2]"/>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="$test='rcConvert'">
							<xsl:text>true</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>false</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>

			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>indJisciiNoCrlf</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">   
					<xsl:variable name = "test">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcXfrJISCIICRLF']/INT[2]"/>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="$test='rcConvert'">
							<xsl:text>false</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>true</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>

			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>indSoDelim</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">   
					<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcXfrIndSO']/BOOL"/>
				</xsl:element>
			</xsl:element>

			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>indNoSoDelim</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">   
					<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcXfrIndNOSO']/BOOL"/>
				</xsl:element>
			</xsl:element>

			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>indUserDelim</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">   
					<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcXfrApvUser']/BOOL"/>
				</xsl:element>
			</xsl:element>

			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>indHostCommand</xsl:text>
				</xsl:attribute>
				<xsl:element name = "STRING">  
					<xsl:value-of select = "//COMMAND[@name='SetString' and INT='rcXfrHostCmd']/STRING"/>
				</xsl:element>
			</xsl:element>

			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>indHostMessage</xsl:text>
				</xsl:attribute>
				<xsl:element name = "STRING"></xsl:element>
			</xsl:element>

			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>indHostSystem</xsl:text>
				</xsl:attribute>
				<xsl:element name = "STRING">  
					<xsl:variable name = "test">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcXfrHostSys']/INT[2]"/>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="$test='rcCMS'">
							<xsl:text>CMS</xsl:text>
						</xsl:when>
						<xsl:when test="$test='rcCICS'">
							<xsl:text>CICS</xsl:text>
						</xsl:when>
						<xsl:when test="$test='rcTSO'">
							<xsl:text>TSO</xsl:text>
						</xsl:when>
					</xsl:choose>
				</xsl:element>
			</xsl:element>


			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>indRECFM</xsl:text>
				</xsl:attribute>
				<xsl:element name = "STRING">  
					<xsl:variable name = "test">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcXfrIndRecFm']/INT[2]"/>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="$test='rcXfrRecFmDflt'">
							<xsl:text>Default</xsl:text>
						</xsl:when>
						<xsl:when test="$test='rcFixed'">
							<xsl:text>Fixed</xsl:text>
						</xsl:when>
						<xsl:when test="$test='rcVariable'">
							<xsl:text>Variable</xsl:text>
						</xsl:when>
						<xsl:when test="$test='rcUndefined'">
							<xsl:text>Undefined</xsl:text>
						</xsl:when>
					</xsl:choose>
				</xsl:element>
			</xsl:element>

			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>Logical Record Length</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">  
					<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcXfrIndLrecl']/INT[2]"/>
				</xsl:element>
			</xsl:element>

			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>indStructuredFieldSize</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">  
					<xsl:variable name = "test">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcXfrIndStrucFldSz']/INT[2]"/>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="$test='rcSF2k'">
							<xsl:text>2048</xsl:text>
						</xsl:when>
						<xsl:when test="$test='rcSF4k'">
							<xsl:text>4096</xsl:text>
						</xsl:when>
						<xsl:when test="$test='rcSF8k'">
							<xsl:text>8192</xsl:text>
						</xsl:when>
						<xsl:when test="$test='rcSF16k'">
							<xsl:text>16384</xsl:text>
						</xsl:when>
						<xsl:when test="$test='rcSF32k'">
							<xsl:text>32511</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>4096</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>

			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>indTSOAllocationUnit</xsl:text>
				</xsl:attribute>
				<xsl:element name = "STRING">  
					<xsl:variable name = "test">
						<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcXfrIndAllocUnit']/INT[2]"/>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="$test='rcXfrAllocDflt'">
							<xsl:text>Default</xsl:text>
						</xsl:when>
						<xsl:when test="$test='rcXfrAllocBlock'">
							<xsl:text>Block</xsl:text>
						</xsl:when>
						<xsl:when test="$test='rcXfrAllocTrack'">
							<xsl:text>Track</xsl:text>
						</xsl:when>
						<xsl:when test="$test='rcXfrAllocCylinder'">
							<xsl:text>Cylinder</xsl:text>
						</xsl:when>
					</xsl:choose>
				</xsl:element>
			</xsl:element>

			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>TSO Average Block</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">  
					<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcXfrIndAvgBlk']/INT[2]"/>
				</xsl:element>
			</xsl:element>

			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>TSO Block Size</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">  
					<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcXfrIndBlkSize']/INT[2]"/>
				</xsl:element>
			</xsl:element>

			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>TSO Primary Allocation</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">  
					<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcXfrIndPrimAlloc']/INT[2]"/>
				</xsl:element>
			</xsl:element>

			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>TSO Secondary Allocation</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INTEGER">  
					<xsl:value-of select = "//COMMAND[@name='SetNumeric' and INT='rcXfrIndSecAlloc']/INT[2]"/>
				</xsl:element>
			</xsl:element>

			<xsl:element name = "CORE_PROPERTY">
				<xsl:attribute name = "NAME">
					<xsl:text>indXferOverwriteFile</xsl:text>
				</xsl:attribute>
				<xsl:element name = "BOOLEAN">  
					<xsl:text>false</xsl:text>
				</xsl:element>
			</xsl:element>
				
		</xsl:element>
	</xsl:element>
</xsl:template>


<xsl:template match="text()|@*"/>

</xsl:stylesheet>

