<?xml version="1.0"?>
<xsl:stylesheet	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="xml" encoding="UTF-8" indent="yes"/>

<xsl:template match="/">
<xsl:comment>This file has been transformed from an RWeb config file. Some
information found in XML Settings files saved directly from Reflection for IBM may
not be present, such as the DTD and Reflection version information.
</xsl:comment>
	<xsl:element name = "REFLECTION_SETTINGS">
		<xsl:element name = "CREATOR">
		</xsl:element>
		<xsl:element name = "TYPE">
			<xsl:attribute name = "mode">
				<xsl:text>All</xsl:text>
			</xsl:attribute>
			<xsl:text>SETTINGS</xsl:text>										
		</xsl:element>
		<xsl:call-template name="SESSION"/>		
		<xsl:call-template name="CONNECTION"/>		
		<xsl:call-template name="IBM3270"/>		
		<xsl:call-template name="IBM5250"/>		
		<xsl:call-template name="COLORS"/>		
		<xsl:call-template name="KEYMOUSEMAP"/>		
		<xsl:call-template name="MENUS"/>		
		<xsl:call-template name="TOOLBARS"/>		
		<xsl:call-template name="EVENTS"/>		
		<xsl:call-template name="HOTSPOTS"/>		
		<xsl:call-template name="PRINTER"/>		
		<xsl:call-template name="WINDOW"/>		
		<xsl:call-template name="COPYPASTE"/>		
		<xsl:call-template name="PROPERTIES"/>		
		<xsl:call-template name="INDFILETRANSFER"/>		
		<xsl:call-template name="FILEXFERSERVICE"/>		
	</xsl:element>
</xsl:template>

<xsl:template name = "SESSION" >
	<xsl:element name = "SESSION">
		<xsl:variable name = "setvalue1">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='autoconnect']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue1 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcAutoConnect</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue1"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue2">
			<!-- select the string after the second colon if there is one.  If there's no port number set Ribm to use 23 -->
			<xsl:if test="contains(substring-after(//CORE_PROPERTY[@NAME='hostURL']/URL_STRING, ':'), ':')">
				<xsl:value-of select = "substring-after(substring-after(//CORE_PROPERTY[@NAME='hostURL']/URL_STRING, ':'), ':')"/>		
			</xsl:if>
			<xsl:if test="not(contains(substring-after(//CORE_PROPERTY[@NAME='hostURL']/URL_STRING, ':'), ':'))">
				<xsl:text>23</xsl:text>		
			</xsl:if>
		</xsl:variable>
		<xsl:if test="$setvalue2 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcTelnetPort</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:value-of select = "$setvalue2"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue3">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='autoreconnect']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue3 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcAutoReConnect</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue3"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue4">
			<!-- select the string after the "//", and before the ":" if there is a ":" -->
			<xsl:if test="contains(substring-after(//CORE_PROPERTY[@NAME='hostURL']/URL_STRING, '//'), ':')">
				<xsl:value-of select = "substring-before(substring-after(//CORE_PROPERTY[@NAME='hostURL']/URL_STRING, '//'), ':')"/>
			</xsl:if>
			<xsl:if test="not(contains(substring-after(//CORE_PROPERTY[@NAME='hostURL']/URL_STRING, '//'), ':'))">
				<xsl:value-of select = "substring-after(//CORE_PROPERTY[@NAME='hostURL']/URL_STRING, '//')"/>
			</xsl:if>
		</xsl:variable>
		<xsl:if test="$setvalue4 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetString</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcHostName</xsl:text>
				</xsl:element>
				<xsl:element name = "STRING">
					<xsl:value-of select = "$setvalue4"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:element name = "COMMAND">
			<xsl:attribute name = "name">
				<xsl:text>SetupSession</xsl:text>
			</xsl:attribute>
			<xsl:element name = "INT">
				<xsl:call-template name = "TERMINALTYPE"/>
			</xsl:element>
			<xsl:element name = "INT">
				<xsl:call-template name = "TERMINALMODEL"/>
			</xsl:element>
			<xsl:element name = "INT">
				<xsl:call-template name = "TRANSPORTTYPE"/>
			</xsl:element>
		</xsl:element>
	</xsl:element>
</xsl:template>

<xsl:template name = "CONNECTION" >
	<xsl:element name = "CONNECTION">
		<xsl:variable name = "setvalue1">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='telnetSysReqTestReq']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue1 = 'true'">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcTelnetSysReq</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:text>rcTestRequestRead</xsl:text>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>	
		<xsl:variable name = "setvalue2">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='tn3270eConnectType']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue2 = '0'">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcTN3287ConnectType</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:text>rc3287Associate</xsl:text>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>	
		<xsl:variable name = "setvalue3">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='responseMode']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue3 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcTelnetResponseMode</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue3"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue4">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='supportXSystem']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue4 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcTelnetXSystem</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue4"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue45">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='generateUniqueDeviceName']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue45 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcGenerateDeviceNames</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue45"/>
				</xsl:element>
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue5">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='deviceName']/STRING"/>
		</xsl:variable>			
		<xsl:element name = "COMMAND">
			<xsl:attribute name = "name">
				<xsl:text>SetString</xsl:text>
			</xsl:attribute>
			<xsl:variable name="terminaltype">
				<xsl:call-template name="TERMINALTYPE"/>
			</xsl:variable>
			<xsl:choose>
				<xsl:when test="terminaltype = 'rc3270Printer'">
					<xsl:element name = "INT">
						<xsl:text>rcPrintHostLUName</xsl:text>
					</xsl:element>
				</xsl:when>
				<xsl:otherwise>
					<xsl:element name = "INT">
						<xsl:text>rcDeviceName</xsl:text>
					</xsl:element>
				</xsl:otherwise>
			</xsl:choose>	
			<xsl:element name = "STRING">
				<xsl:choose>
					<xsl:when test="$setvalue5 != ''">
						<xsl:value-of select = "$setvalue5"/>
					</xsl:when>
					<!-- if deviceName is empty and generateUniqueDeviceName is true, use a regular expression to 
						 approximate how Rweb generates device names -->
					<xsl:when test="$setvalue5 = '' and $setvalue45 = 'true'">
						<xsl:text>*&amp;COMPN</xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text></xsl:text>
					</xsl:otherwise>
				</xsl:choose>								
			</xsl:element>			
		</xsl:element>
		<xsl:variable name = "setvalue6">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='tnAssociation']/STRING"/>
		</xsl:variable>
		<xsl:if test="$setvalue6 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetString</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcTNAssociation</xsl:text>
				</xsl:element>
				<xsl:element name = "STRING">
					<xsl:value-of select = "$setvalue6"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue7">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='telnetTerminalID']/STRING"/>
		</xsl:variable>
		<xsl:if test="$setvalue7 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetString</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcTelnetTerminalID</xsl:text>
				</xsl:element>
				<xsl:element name = "STRING">
					<xsl:value-of select = "$setvalue7"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue8">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='encryptStream']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue8 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcTelnetEncryption</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue8"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue9">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='securityEnabled']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue9 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcTelnetUseReflectionSecurityProxy</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue9"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
	</xsl:element>
</xsl:template>

<xsl:template name = "IBM3270" >
	<xsl:element name = "IBM3270">
		<xsl:variable name = "setvalue1">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='rcTranslateEBCDICinTransparent']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue1 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintTranslateEBCDICInTRN</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue1"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue2">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='CECG']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue2 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcCEGC</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue2"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue3">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='C370CharacterSet']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue3 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcC370Charset</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue3"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue4">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='emulateFormFeed']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue4 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintEmulateFormFeed</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue4"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue5">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='printerMPL']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue5 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrinterMPL</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:value-of select = "$setvalue5"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue6">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='printerMPP']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue6 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrinterMPP</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:value-of select = "$setvalue6"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue7">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='deviceName']/STRING"/>
		</xsl:variable>
		<xsl:if test="$setvalue7 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetString</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintHostLUName</xsl:text>
				</xsl:element>
				<xsl:element name = "STRING">
					<xsl:value-of select = "$setvalue7"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue8">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='attnKey']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue8 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcTelnetAttn</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:choose>
						<xsl:when test="$setvalue8='1'">
							<xsl:text>rcTelnetAbortOutput</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue8='2'">
							<xsl:text>rcTelnetIntProcess</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue8='3'">
							<xsl:text>rcTelnetBreak</xsl:text>
						</xsl:when>
					</xsl:choose>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
	</xsl:element>
</xsl:template>

<xsl:template name = "IBM5250" >
	<xsl:element name = "IBM5250">
		<xsl:variable name = "setvalue1">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='printDeviceFontID']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue1 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintDeviceFontId</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:value-of select = "$setvalue1"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue2">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='printDeviceFormsMode']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue2 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintDeviceFormsMode</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:choose>
						<xsl:when test="$setvalue2='0'">
							<xsl:text>rcFormsModeAutoCut</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue2='1'">
							<xsl:text>rcFormsModeCont</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue2='2'">
							<xsl:text>rcFormsModeCut</xsl:text>
						</xsl:when>
					</xsl:choose>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue3">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='printDevicePaperSrc1']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue3 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintDevicePaperSrc1</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:call-template name="PAPERSRC">
						<xsl:with-param name="source"><xsl:value-of select="$setvalue3"/></xsl:with-param>
					</xsl:call-template>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue4">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='printDevicePaperSrc2']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue4 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintDevicePaperSrc2</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:call-template name="PAPERSRC">
						<xsl:with-param name="source"><xsl:value-of select="$setvalue4"/></xsl:with-param>
					</xsl:call-template>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue5">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='printDeviceEnvelopeSrc']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue5 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintDeviceEnvelopeSrc</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:call-template name="PAPERSRC">
						<xsl:with-param name="source"><xsl:value-of select="$setvalue5"/></xsl:with-param>
					</xsl:call-template>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue6">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='useHostPrintTransform']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue6 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintTransform</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue6"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue7">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='autoReset']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue7 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcKeyboardErrorReset</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:choose>
						<xsl:when test="$setvalue7 = 'false'">
							<xsl:text>rcNoAutoReset</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue7 = 'true'">
							<xsl:text>rcAutoReset</xsl:text>
						</xsl:when>
					</xsl:choose> 
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue8">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='wordWrap']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue8 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcWordWrap</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:choose>
						<xsl:when test="$setvalue8 = 'false'">
							<xsl:text>rcNoWordWrap</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue8 = 'true'">
							<xsl:text>rcLocalWordWrap</xsl:text>
						</xsl:when>
					</xsl:choose> 
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue9">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='columnSeparatorStyle']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue9 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcColumnSeparatorStyle</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:choose>
						<xsl:when test="$setvalue9 = '0'">
						<!--	If Rweb has columnSeparatorStyle = None (0), then the user 
								must run the following from the command line to make sure 
								Ribm doesn't show the column separator:
								.ShowDisplayAttribute rcAttrColumnSep, rcNo	
						-->
							<xsl:text>rcVerticalLines</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue9 = '1'">
							<xsl:text>rcDots</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue9 = '2'">
							<xsl:text>rcVerticalLines</xsl:text>
						</xsl:when>
					</xsl:choose> 
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue10">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='messageQueue']/STRING"/>
		</xsl:variable>
		<xsl:if test="$setvalue10 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetString</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcMessageQueue</xsl:text>
				</xsl:element>
				<xsl:element name = "STRING">
					<xsl:value-of select = "$setvalue10"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue11">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='messageLibrary']/STRING"/>
		</xsl:variable>
		<xsl:if test="$setvalue11 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetString</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcMessageLibrary</xsl:text>
				</xsl:element>
				<xsl:element name = "STRING">
					<xsl:value-of select = "$setvalue11"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue12">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='printMfrType']/STRING"/>
		</xsl:variable>
		<xsl:if test="$setvalue12 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetString</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintMfrType</xsl:text>
				</xsl:element>
				<xsl:element name = "STRING">
					<xsl:value-of select = "$setvalue12"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue13">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='printDeviceWscstName']/STRING"/>
		</xsl:variable>
		<xsl:if test="$setvalue13 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetString</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintDeviceWscstName</xsl:text>
				</xsl:element>
				<xsl:element name = "STRING">
					<xsl:value-of select = "$setvalue13"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue14">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='printDeviceWscstLibrary']/STRING"/>
		</xsl:variable>
		<xsl:if test="$setvalue14 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetString</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintDeviceWscstLibrary</xsl:text>
				</xsl:element>
				<xsl:element name = "STRING">
					<xsl:value-of select = "$setvalue14"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
	</xsl:element>
</xsl:template>

<xsl:template name = "COLORS" >
	<xsl:element name = "COLORS">
		<xsl:element name = "COLOR_ATTRIBUTES">
			<xsl:variable name = "setvalue1">
				<xsl:call-template name="GETBACKGROUNDCOLOR"/>
			</xsl:variable>
			<xsl:if test="$setvalue1 != ''">
				<xsl:element name = "COMMAND">
					<xsl:attribute name = "name">
						<xsl:text>SetNumeric</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INT">
						<xsl:text>rcBackgndColor</xsl:text>
					</xsl:element>
					<xsl:element name = "INT">
						<xsl:value-of select="$setvalue1"/>
					</xsl:element>			
				</xsl:element>			
			</xsl:if>
			<xsl:variable name = "setvalue2">
				<xsl:value-of select = "//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[1]/COLOR[1]"/>
			</xsl:variable>
			<xsl:if test="$setvalue2 != ''">
				<xsl:element name = "COMMAND">
					<xsl:attribute name = "name">
						<xsl:text>SetColorMap</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INT">
						<xsl:text>rcHostBlue</xsl:text>
					</xsl:element>
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$setvalue2"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>			
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[1]/COLOR[2]"/></xsl:with-param>
						</xsl:call-template>					
					</xsl:element>
				</xsl:element>			
			</xsl:if>
			<xsl:variable name = "setvalue3">
				<xsl:value-of select = "//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[2]/COLOR[1]"/>
			</xsl:variable>
			<xsl:if test="$setvalue3 != ''">
				<xsl:element name = "COMMAND">
					<xsl:attribute name = "name">
						<xsl:text>SetColorMap</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INT">
						<xsl:text>rcHostRed</xsl:text>
					</xsl:element>
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$setvalue3"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>			
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[2]/COLOR[2]"/></xsl:with-param>
						</xsl:call-template>					
					</xsl:element>
				</xsl:element>			
			</xsl:if>
			<xsl:variable name = "setvalue4">
				<xsl:value-of select = "//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[3]/COLOR[1]"/>
			</xsl:variable>
			<xsl:if test="$setvalue4 != ''">
				<xsl:element name = "COMMAND">
					<xsl:attribute name = "name">
						<xsl:text>SetColorMap</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INT">
						<xsl:text>rcHostPink</xsl:text>
					</xsl:element>
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$setvalue4"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>			
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[3]/COLOR[2]"/></xsl:with-param>
						</xsl:call-template>					
					</xsl:element>
				</xsl:element>			
			</xsl:if>
			<xsl:variable name = "setvalue5">
				<xsl:value-of select = "//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[4]/COLOR[1]"/>
			</xsl:variable>
			<xsl:if test="$setvalue5 != ''">
				<xsl:element name = "COMMAND">
					<xsl:attribute name = "name">
						<xsl:text>SetColorMap</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INT">
						<xsl:text>rcHostGreen</xsl:text>
					</xsl:element>
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$setvalue5"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>			
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[4]/COLOR[2]"/></xsl:with-param>
						</xsl:call-template>					
					</xsl:element>
				</xsl:element>			
			</xsl:if>
			<xsl:variable name = "setvalue6">
				<xsl:value-of select = "//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[5]/COLOR[1]"/>
			</xsl:variable>
			<xsl:if test="$setvalue6 != ''">
				<xsl:element name = "COMMAND">
					<xsl:attribute name = "name">
						<xsl:text>SetColorMap</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INT">
						<xsl:text>rcHostTurquoise</xsl:text>
					</xsl:element>
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$setvalue6"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>			
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[5]/COLOR[2]"/></xsl:with-param>
						</xsl:call-template>					
					</xsl:element>
				</xsl:element>			
			</xsl:if>
			<xsl:variable name = "setvalue7">
				<xsl:value-of select = "//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[6]/COLOR[1]"/>
			</xsl:variable>
			<xsl:if test="$setvalue7 != ''">
				<xsl:element name = "COMMAND">
					<xsl:attribute name = "name">
						<xsl:text>SetColorMap</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INT">
						<xsl:text>rcHostYellow</xsl:text>
					</xsl:element>
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$setvalue7"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>			
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[6]/COLOR[2]"/></xsl:with-param>
						</xsl:call-template>					
					</xsl:element>
				</xsl:element>			
			</xsl:if>
			<xsl:variable name = "setvalue8">
				<xsl:value-of select = "//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[7]/COLOR[1]"/>
			</xsl:variable>
			<xsl:if test="$setvalue8 != ''">
				<xsl:element name = "COMMAND">
					<xsl:attribute name = "name">
						<xsl:text>SetColorMap</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INT">
						<xsl:text>rcHostWhite</xsl:text>
					</xsl:element>
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$setvalue8"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>			
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[7]/COLOR[2]"/></xsl:with-param>
						</xsl:call-template>					
					</xsl:element>
				</xsl:element>			
			</xsl:if>
			<xsl:variable name = "setvalue9">
				<xsl:value-of select = "//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[8]/COLOR[1]"/>
			</xsl:variable>
			<xsl:if test="$setvalue9 != ''">
				<xsl:element name = "COMMAND">
					<xsl:attribute name = "name">
						<xsl:text>SetColorMap</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INT">
						<xsl:text>rcStatusLine</xsl:text>
					</xsl:element>
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$setvalue9"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>			
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[8]/COLOR[2]"/></xsl:with-param>
						</xsl:call-template>					
					</xsl:element>
				</xsl:element>			
			</xsl:if>
			<xsl:variable name = "setvalue10">
				<xsl:value-of select = "//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[9]/COLOR[1]"/>
			</xsl:variable>
			<xsl:if test="$setvalue10 != ''">
				<xsl:element name = "COMMAND">
					<xsl:attribute name = "name">
						<xsl:text>SetColorMap</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INT">
						<xsl:text>rcProtNormAlpha</xsl:text>
					</xsl:element>
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$setvalue10"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>			
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[9]/COLOR[2]"/></xsl:with-param>
						</xsl:call-template>					
					</xsl:element>
				</xsl:element>			
			</xsl:if>
			<xsl:variable name = "setvalue11">
				<xsl:value-of select = "//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[10]/COLOR[1]"/>
			</xsl:variable>
			<xsl:if test="$setvalue11 != ''">
				<xsl:element name = "COMMAND">
					<xsl:attribute name = "name">
						<xsl:text>SetColorMap</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INT">
						<xsl:text>rcProtNormNum</xsl:text>
					</xsl:element>
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$setvalue11"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>			
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[10]/COLOR[2]"/></xsl:with-param>
						</xsl:call-template>					
					</xsl:element>
				</xsl:element>			
			</xsl:if>
			<xsl:variable name = "setvalue12">
				<xsl:value-of select = "//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[11]/COLOR[1]"/>
			</xsl:variable>
			<xsl:if test="$setvalue12 != ''">
				<xsl:element name = "COMMAND">
					<xsl:attribute name = "name">
						<xsl:text>SetColorMap</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INT">
						<xsl:text>rcProtHighAlpha</xsl:text>
					</xsl:element>
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$setvalue12"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>			
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[11]/COLOR[2]"/></xsl:with-param>
						</xsl:call-template>					
					</xsl:element>
				</xsl:element>			
			</xsl:if>
			<xsl:variable name = "setvalue13">
				<xsl:value-of select = "//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[12]/COLOR[1]"/>
			</xsl:variable>
			<xsl:if test="$setvalue13 != ''">
				<xsl:element name = "COMMAND">
					<xsl:attribute name = "name">
						<xsl:text>SetColorMap</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INT">
						<xsl:text>rcProtHighNum</xsl:text>
					</xsl:element>
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$setvalue13"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>			
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[12]/COLOR[2]"/></xsl:with-param>
						</xsl:call-template>					
					</xsl:element>
				</xsl:element>			
			</xsl:if>
			<xsl:variable name = "setvalue14">
				<xsl:value-of select = "//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[13]/COLOR[1]"/>
			</xsl:variable>
			<xsl:if test="$setvalue14 != ''">
				<xsl:element name = "COMMAND">
					<xsl:attribute name = "name">
						<xsl:text>SetColorMap</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INT">
						<xsl:text>rcUnprotNormAlpha</xsl:text>
					</xsl:element>
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$setvalue14"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>			
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[13]/COLOR[2]"/></xsl:with-param>
						</xsl:call-template>					
					</xsl:element>
				</xsl:element>			
			</xsl:if>
			<xsl:variable name = "setvalue15">
				<xsl:value-of select = "//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[14]/COLOR[1]"/>
			</xsl:variable>
			<xsl:if test="$setvalue15 != ''">
				<xsl:element name = "COMMAND">
					<xsl:attribute name = "name">
						<xsl:text>SetColorMap</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INT">
						<xsl:text>rcUnprotNormNum</xsl:text>
					</xsl:element>
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$setvalue15"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>			
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[14]/COLOR[2]"/></xsl:with-param>
						</xsl:call-template>					
					</xsl:element>
				</xsl:element>			
			</xsl:if>
			<xsl:variable name = "setvalue16">
				<xsl:value-of select = "//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[15]/COLOR[1]"/>
			</xsl:variable>
			<xsl:if test="$setvalue16 != ''">
				<xsl:element name = "COMMAND">
					<xsl:attribute name = "name">
						<xsl:text>SetColorMap</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INT">
						<xsl:text>rcUnprotHighAlpha</xsl:text>
					</xsl:element>
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$setvalue16"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>			
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[15]/COLOR[2]"/></xsl:with-param>
						</xsl:call-template>					
					</xsl:element>
				</xsl:element>			
			</xsl:if>
			<xsl:variable name = "setvalue17">
				<xsl:value-of select = "//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[16]/COLOR[1]"/>
			</xsl:variable>
			<xsl:if test="$setvalue17 != ''">
				<xsl:element name = "COMMAND">
					<xsl:attribute name = "name">
						<xsl:text>SetColorMap</xsl:text>
					</xsl:attribute>
					<xsl:element name = "INT">
						<xsl:text>rcUnprotHighNum</xsl:text>
					</xsl:element>
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="$setvalue17"/></xsl:with-param>
						</xsl:call-template>
					</xsl:element>			
					<xsl:element name = "INT">
						<xsl:call-template name="CONVERTCOLOR">
							<xsl:with-param name="color"><xsl:value-of select="//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[16]/COLOR[2]"/></xsl:with-param>
						</xsl:call-template>					
					</xsl:element>
				</xsl:element>			
			</xsl:if>
		</xsl:element>
	</xsl:element>
</xsl:template>

<xsl:template name = "MENUS" >
<!-- no conversion to do -->
</xsl:template>

<xsl:template name = "TOOLBARS" >
<!-- no conversion to do -->
</xsl:template>

<xsl:template name = "EVENTS" >
<!-- no conversion to do -->
</xsl:template>

<xsl:template name = "HOTSPOTS" >
<!-- no conversion to do -->
</xsl:template>

<xsl:template name = "PRINTER" >
	<xsl:element name = "PRINTER">
		<xsl:variable name = "setvalue1">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='rcPrintLineSpacing']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue1 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintLineSpacing</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
						<xsl:choose>
						<xsl:when test="$setvalue1='0'">
							<xsl:text>rcPoint5Space</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue1='1'">
							<xsl:text>rcSingleSpace</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue1='2'">
							<xsl:text>rc1Point5Space</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue1='3'">
							<xsl:text>rcDoubleSpace</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue1='4'">
							<xsl:text>rc2Point5Space</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue1='5'">
							<xsl:text>rcTripleSpace</xsl:text>
						</xsl:when>
					</xsl:choose>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue2">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='rcPrintCase']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue2 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintCase</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
						<xsl:choose>
						<xsl:when test="$setvalue2='0'">
							<xsl:text>rcDualCase</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue2='1'">
							<xsl:text>rcUpperCase</xsl:text>
						</xsl:when>
					</xsl:choose>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue3">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='charsPerLine']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue3 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintCharsPerLine</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:value-of select = "$setvalue3"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue4">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='linesPerPage']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue4 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintLinesPerPage</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:value-of select = "$setvalue4"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue5">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='rcPrintLinesPerInch']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue5 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintLinesPerInch</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:choose>
						<xsl:when test="$setvalue5='10'">
							<xsl:text>rc10LPI</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue5='12'">
							<xsl:text>rc12LPI</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue5='14'">
							<xsl:text>rc14LPI</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue5='17'">
							<xsl:text>rc17LPI</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue5='20'">
							<xsl:text>rc20LPI</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue5='24'">
							<xsl:text>rc24LPI</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue5='28'">
							<xsl:text>rc28LPI</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue5='34'">
							<xsl:text>rc34LPI</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue5='3'">
							<xsl:text>rc3LPI</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue5='40'">
							<xsl:text>rc40LPI</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue5='48'">
							<xsl:text>rc48LPI</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue5='4'">
							<xsl:text>rc4LPI</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue5='5'">
							<xsl:text>rc5LPI</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue5='6'">
							<xsl:text>rc6LPI</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue5='8'">
							<xsl:text>rc8LPI</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue5='9'">
							<xsl:text>rc9LPI</xsl:text>
						</xsl:when>
					</xsl:choose>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue6">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='autoFF']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue6 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcAutoFormfeed</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue6"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue7">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='fitToPage']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue7 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintFitToPage</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue7"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue8">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='printFileMode']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue8 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintFileExistsAction</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:choose>
						<xsl:when test="$setvalue8='2'">
							<xsl:text>rcAutonumber</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue8='3'">
							<xsl:text>rcOverwrite</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue8='4'">
							<xsl:text>rcOpenError</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue8='5'">
							<xsl:text>rcAskUser</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue8='6'">
							<xsl:text>rcAppend</xsl:text>
						</xsl:when>
					</xsl:choose>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue9">
			<!-- formFeedOnEOJ was obsoleted by autoFF 168477 -->
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='formFeedOnEOJ' or @NAME='autoFF']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue9 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintFormFeedOnEndOfJob</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue9"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue10">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='printToFile']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue10 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintToFile</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue10"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue11">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='printJobTerminationDelay']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue11 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcHostPrintTimeout</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:value-of select = "$setvalue11"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue12">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='rcPrintCharsPerInch']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue12 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintCharsPerInch</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:choose>
						<xsl:when test="$setvalue12='10'">
							<xsl:text>rc10CPI</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue12='12'">
							<xsl:text>rc12CPI</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue12='13'">
							<xsl:text>rc13CPI</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue12='15'">
							<xsl:text>rc15CPI</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue12='17'">
							<xsl:text>rc17CPI</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue12='20'">
							<xsl:text>rc20CPI</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue12='22'">
							<xsl:text>rc22CPI</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue12='27'">
							<xsl:text>rc27CPI</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue12='5'">
							<xsl:text>rc5CPI</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue12='6'">
							<xsl:text>rc6CPI</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue12='8'">
							<xsl:text>rc8CPI</xsl:text>
						</xsl:when>
					</xsl:choose>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue13">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='printerBottomMargin']/FLOAT"/>
		</xsl:variable>
		<xsl:if test="$setvalue13 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintMarginBottom</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:call-template name="CALCULATEMARGIN">
						<xsl:with-param name="margin">
							<xsl:value-of select = "$setvalue13"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue14">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='printerTopMargin']/FLOAT"/>
		</xsl:variable>
		<xsl:if test="$setvalue14 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintMarginTop</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:call-template name="CALCULATEMARGIN">
						<xsl:with-param name="margin">
							<xsl:value-of select = "$setvalue14"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue15">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='printerLeftMargin']/FLOAT"/>
		</xsl:variable>
		<xsl:if test="$setvalue15 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintMarginLeft</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:call-template name="CALCULATEMARGIN">
						<xsl:with-param name="margin">
							<xsl:value-of select = "$setvalue15"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue16">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='printerRightMargin']/FLOAT"/>
		</xsl:variable>
		<xsl:if test="$setvalue16 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintMarginRight</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:call-template name="CALCULATEMARGIN">
						<xsl:with-param name="margin">
							<xsl:value-of select = "$setvalue16"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue17">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='transparentMode']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue17 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintTransparent</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue17"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue18">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='overrideHostPageFmt']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue18 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintOverrideHostFmt</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue18"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue19">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='pageOrientation']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue19 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrinterOrientation</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:choose>
						<xsl:when test="$setvalue19='0'">
							<xsl:text>rcDefaultOrientation</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue19='1'">
							<xsl:text>rcPortraitOrientation</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue19='2'">
							<xsl:text>rcLandscapeOrientation</xsl:text>
						</xsl:when>
					</xsl:choose>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue20">
			<!-- flushOnEOJRecord and flushOnEOJ have been obsoleted by closePrinterManually 168477 -->
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='flushOnEOJRecord' or @NAME='flushOnEOJ' or @NAME='closePrinterManually']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue20 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintFlushOnEndOfJob</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue20"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue21">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='paperScalingPercentageY']/FLOAT"/>
		</xsl:variable>
		<xsl:if test="$setvalue21 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintFitUserLength</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:value-of select = "$setvalue21"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue22">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='paperScalingPercentageX']/FLOAT"/>
		</xsl:variable>
		<xsl:if test="$setvalue22 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintFitUserWidth</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:value-of select = "$setvalue22"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue23">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='printFileName']/PAIR/FIRST/STRING"/>
		</xsl:variable>
		<xsl:variable name = "setvalue24">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='printFileName']/PAIR/SECOND/STRING"/>
		</xsl:variable>
		<xsl:if test="$setvalue24 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetString</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcPrintFileName</xsl:text>
				</xsl:element>
				<xsl:element name = "STRING">
					<xsl:value-of select = "concat($setvalue23, $setvalue24)"/>
				</xsl:element>
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue25">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='closePrinterManually']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue25 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcClosePrinterManually</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue25"/>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
	</xsl:element>
</xsl:template>

<xsl:template name = "WINDOW" >
	<xsl:element name="WINDOW">
		<xsl:variable name = "setvalue1">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='useHeavyFont']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue1 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcFontStyle</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:choose>
						<xsl:when test="$setvalue1='true'">
							<xsl:text>rcBold</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue1='false'">
							<xsl:text>rcRegular</xsl:text>
						</xsl:when>
					</xsl:choose>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>	
		<xsl:variable name = "setvalue2">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='cursorShape']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue2 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcCursorShape</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:choose>
						<xsl:when test="$setvalue2 = '0'">
							<xsl:text>rcFullBlock</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue2 = '1'">
							<xsl:text>rcUnderLine</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue2 = '2'">
							<xsl:text>rcHighHalfBlock</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue2 = '3'">
							<xsl:text>rcLowHalfBlock</xsl:text>
						</xsl:when>
					</xsl:choose>
				</xsl:element>			
			</xsl:element>			
		</xsl:if>
		<xsl:variable name = "setvalue3">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='cursorBlinks']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue3 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcCursorBlinkRate</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:choose>
						<xsl:when test="$setvalue3 = 'false'">
							<xsl:text>rcNoBlink</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue3 = 'true'">
							<xsl:text>rcSystem</xsl:text>
						</xsl:when>
					</xsl:choose>
				</xsl:element>			
			</xsl:element>
		</xsl:if>
		<xsl:variable name = "setvalue4">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='terminalKeyboardVisible']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue4 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcTerminalKbdVisible</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue4"/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		<xsl:variable name = "setvalue5">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='slashedZero']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue5 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcSubstituteDisplayChars</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue5"/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
	</xsl:element>
</xsl:template>

<xsl:template name = "COPYPASTE" >
	<xsl:element name="COPYPASTE">
		<xsl:variable name = "setvalue1">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='insertProtocol']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue1 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcInsertProtocol</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:choose>
						<xsl:when test="$setvalue1 = '0'">
							<xsl:text>rcFirstNull</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue1 = '1'">
							<xsl:text>rcFirstNullOrTrailingSpace</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue1 = '2'">
							<xsl:text>rcFirstNullOrTrailingChar</xsl:text>
						</xsl:when>
					</xsl:choose> 
				</xsl:element>
			</xsl:element>
		</xsl:if>
		<xsl:variable name = "setvalue2">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='insertArena']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue2 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcInsertArena</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:choose>
						<xsl:when test="$setvalue2 = '0'">
							<xsl:text>rcCurrentField</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue2 = '1'">
							<xsl:text>rcLocalUnprotectedFields</xsl:text>
						</xsl:when>
						<xsl:when test="$setvalue2 = '2'">
							<xsl:text>rcAllUnprotectedFields</xsl:text>
						</xsl:when>
					</xsl:choose> 
				</xsl:element>
			</xsl:element>
		</xsl:if>
		<xsl:variable name = "setvalue3">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='copyTrailingSpaces']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue3 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcCopyTrailingSpaces</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue3"/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
	</xsl:element>
</xsl:template>

<xsl:template name = "PROPERTIES" >
	<xsl:element name="PROPERTIES">
		<xsl:variable name = "setvalue1">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='typeahead']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue1 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcTypeAhead</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue1"/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		<xsl:variable name = "setvalue2">
			<xsl:call-template name="NATIONALCHARACTERSET"/>
		</xsl:variable>
		<xsl:if test="$setvalue2 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcNationalCharacterSet</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:value-of select = "$setvalue2"/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		<xsl:variable name = "setvalue3">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='enableHotspots']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue3 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcEnableHotspots</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue3"/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		<xsl:variable name = "setvalue4">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='showHotspots']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue4 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcShowHotspots</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue4"/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
	</xsl:element>
</xsl:template>

<xsl:template name = "INDFILETRANSFER" >
	<xsl:element name="INDFILETRANSFER">
		<xsl:variable name = "setvalue1">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='indAutoPositionCursor']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue1 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcIndAutoPositionCursor</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue1"/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		
		<xsl:variable name = "setvalue2">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='indAdditionalParms']/STRING"/>
		</xsl:variable>
		<xsl:if test="$setvalue2 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetString</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfrAddParam</xsl:text>
				</xsl:element>
				<xsl:element name = "STRING">
					<xsl:value-of select = "$setvalue2"/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		
		<xsl:variable name = "setvalue3">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='indBinaryCrlf']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue3 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfrBinaryCRLF</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:choose>
						<xsl:when test = "$setvalue3 = 'true'">
							<xsl:text>rcConvert</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>rcIgnore</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		<xsl:variable name = "setvalue4">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='indAsciiCrlf']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue4 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfrASCIICRLF</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:choose>
						<xsl:when test = "$setvalue4 = 'true'">
							<xsl:text>rcConvert</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>rcIgnore</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		
		<xsl:variable name = "setvalue5">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='indJisciiCrlf']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue5 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfrJISCIICRLF</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:choose>
						<xsl:when test = "$setvalue5 = 'true'">
							<xsl:text>rcConvert</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>rcIgnore</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		
		<xsl:variable name = "setvalue5a">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='indSoDelim']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue5a != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfrIndSO</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue5a"/>
				</xsl:element>			
			</xsl:element>
		</xsl:if>
		
		<xsl:variable name = "setvalue5b">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='indNoSoDelim']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue5b != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfrIndNOSO</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue5b"/>
				</xsl:element>			
			</xsl:element>
		</xsl:if>
		
		<xsl:variable name = "setvalue5c">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='indUserDelim']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue5c != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfrApvUser</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue5c"/>
				</xsl:element>			
			</xsl:element>
		</xsl:if>
		
		<xsl:variable name = "setvalue6">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='indHostCommand']/STRING"/>
		</xsl:variable>
		<xsl:if test="$setvalue6 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetString</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfrHostCmd</xsl:text>
				</xsl:element>
				<xsl:element name = "STRING">
					<xsl:value-of select = "$setvalue6"/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		
		<xsl:variable name = "setvalue7">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='indHostSystem']/STRING"/>
		</xsl:variable>
		<xsl:if test="$setvalue7 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfrHostSys</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:choose>
						<xsl:when test = "$setvalue7 = 'CMS'">
							<xsl:text>rcCMS</xsl:text>
						</xsl:when>
						<xsl:when test = "$setvalue7 = 'CICS'">
							<xsl:text>rcCICS</xsl:text>
						</xsl:when>
						<xsl:when test = "$setvalue7 = 'TSO'">
							<xsl:text>rcTSO</xsl:text>
						</xsl:when>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		<xsl:variable name = "setvalue8">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='indRECFM']/STRING"/>
		</xsl:variable>
		<xsl:if test="$setvalue8 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfrIndRecFm</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:choose>
						<xsl:when test = "$setvalue8 = 'Default'">
							<xsl:text>rcXfrRecFmDflt</xsl:text>
						</xsl:when>
						<xsl:when test = "$setvalue8 = 'Fixed'">
							<xsl:text>rcFixed</xsl:text>
						</xsl:when>
						<xsl:when test = "$setvalue8 = 'Variable'">
							<xsl:text>rcVariable</xsl:text>
						</xsl:when>
						<xsl:when test = "$setvalue8 = 'Undefined'">
							<xsl:text>rcUndefined</xsl:text>
						</xsl:when>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		
		<xsl:variable name = "setvalue9">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='Logical Record Length']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue9 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfrIndLrecl</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:value-of select = "$setvalue9"/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		
		<xsl:variable name = "setvalue10">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='indStructuredFieldSize']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue10 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfrIndStrucFldSz</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:choose>
						<xsl:when test = "$setvalue10 = '2048'">
							<xsl:text>rcSF2k</xsl:text>
						</xsl:when>
						<xsl:when test = "$setvalue10 = '4096'">
							<xsl:text>rcSF4k</xsl:text>
						</xsl:when>
						<xsl:when test = "$setvalue10 = '8192'">
							<xsl:text>rcSF8k</xsl:text>
						</xsl:when>
						<xsl:when test = "$setvalue10 = '16384'">
							<xsl:text>rcSF16k</xsl:text>
						</xsl:when>
						<xsl:when test = "$setvalue10 = '32511'">
							<xsl:text>rcSF32k</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>rcSFDisabled</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		
		<xsl:variable name = "setvalue11">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='indTSOAllocationUnit']/STRING"/>
		</xsl:variable>
		<xsl:if test="$setvalue11 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfrIndAllocUnit</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:choose>
						<xsl:when test = "$setvalue11 = 'Default'">
							<xsl:text>rcXfrAllocDflt</xsl:text>
						</xsl:when>
						<xsl:when test = "$setvalue11 = 'Block'">
							<xsl:text>rcXfrAllocBlock</xsl:text>
						</xsl:when>
						<xsl:when test = "$setvalue11 = 'Track'">
							<xsl:text>rcXfrAllocTrack</xsl:text>
						</xsl:when>
						<xsl:when test = "$setvalue11 = 'Cylinder'">
							<xsl:text>rcXfrAllocCylinder</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>rcXfrAllocDflt</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		
		<xsl:variable name = "setvalue12">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='TSO Average Block']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue12 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfrIndAvgBlk</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:value-of select = "$setvalue12"/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		
		<xsl:variable name = "setvalue13">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='TSO Block Size']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue13 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfrIndBlkSize</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:value-of select = "$setvalue13"/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		
		<xsl:variable name = "setvalue14">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='TSO Primary Allocation']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue14 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfrIndPrimAlloc</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:value-of select = "$setvalue14"/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		
		<xsl:variable name = "setvalue15">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='TSO Secondary Allocation']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue15 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfrIndSecAlloc</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:value-of select = "$setvalue15"/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
	</xsl:element>
</xsl:template>

<xsl:template name = "FILEXFERSERVICE" >
	<xsl:element name="FILEXFERSERVICE">
		<xsl:variable name = "setvalue1">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='transferLocalFile']/STRING"/>
		</xsl:variable>
		<xsl:if test="$setvalue1 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetString</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfrLocalFile</xsl:text>
				</xsl:element>
				<xsl:element name = "STRING">
					<xsl:value-of select = "$setvalue1"/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		<xsl:variable name = "setvalue2">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='transferHostFile']/STRING"/>
		</xsl:variable>
		<xsl:if test="$setvalue2 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetString</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfrRemoteFile</xsl:text>
				</xsl:element>
				<xsl:element name = "STRING">
					<xsl:value-of select = "$setvalue2"/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		
		<xsl:variable name = "setvalue3">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='transferType']/STRING"/>
		</xsl:variable>
		<xsl:if test="$setvalue3 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcDfltXfrType</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:choose>
						<xsl:when test = "$setvalue3 = 'ASCII'">
							<xsl:text>rcXfrASCII</xsl:text>
						</xsl:when>
						<xsl:when test = "$setvalue3 = 'Binary'">
							<xsl:text>rcXfrBinary</xsl:text>
						</xsl:when>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		
		<xsl:variable name = "setvalue4">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='transferExistsAction']/STRING"/>
		</xsl:variable>
		<xsl:if test="$setvalue4 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcDfltExistsAction</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:choose>
						<xsl:when test = "$setvalue4 = 'Overwrite'">
							<xsl:text>rcOverwrite</xsl:text>
						</xsl:when>
						<xsl:when test = "$setvalue4 = 'Ask User'">
							<xsl:text>rcAskUser</xsl:text>
						</xsl:when>
						<xsl:when test = "$setvalue4 = 'Append'">
							<xsl:text>rcAppend</xsl:text>
						</xsl:when>
						<xsl:when test = "$setvalue4 = 'Open Error'">
							<xsl:text>rcOpenError</xsl:text>
						</xsl:when>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		
		<xsl:variable name = "setvalue5">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='transferCurrentDirectory']/STRING"/>
		</xsl:variable>
		<xsl:if test="$setvalue5 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetString</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfrCurrentDirectory</xsl:text>
				</xsl:element>
				<xsl:element name = "STRING">
					<xsl:value-of select = "$setvalue5"/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		
		<xsl:variable name = "setvalue6">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='transferTimeout']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue6 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfrTimeout</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:value-of select = "$setvalue6"/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		
		<xsl:variable name = "setvalue7">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='transferStartTimeout']/INTEGER"/>
		</xsl:variable>
		<xsl:if test="$setvalue7 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfrStartTimeout</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:value-of select = "$setvalue7"/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		
		<xsl:variable name = "setvalue8">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='transferCurrentProtocol']/STRING"/>
		</xsl:variable>
		<xsl:if test="$setvalue8 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetString</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfrHostCmd</xsl:text>
				</xsl:element>
				<xsl:element name = "STRING">
					<xsl:value-of select = "$setvalue8"/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		
		<xsl:variable name = "setvalue9">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='spacesToUnderscore']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue9 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfrSpacesToUnderscores</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue9"/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		
		<xsl:variable name = "setvalue10">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='underscoreToSpaces']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue10 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfrUnderscoresToSpaces</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue10"/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		
		<xsl:variable name = "setvalue11">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='truncateTo8dot3']/BOOLEAN"/>
		</xsl:variable>
		<xsl:if test="$setvalue11 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfrReceive8Dot3</xsl:text>
				</xsl:element>
				<xsl:element name = "BOOL">
					<xsl:value-of select = "$setvalue11"/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		
		<xsl:variable name = "setvalue12">
			<xsl:value-of select = "//CORE_PROPERTY[@NAME='display8dot3']/STRING"/>
		</xsl:variable>
		<xsl:if test="$setvalue11 != ''">
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "name">
					<xsl:text>SetNumeric</xsl:text>
				</xsl:attribute>
				<xsl:element name = "INT">
					<xsl:text>rcXfr8Dot3FilenameCase</xsl:text>
				</xsl:element>
				<xsl:element name = "INT">
					<xsl:choose>
						<xsl:when test = "$setvalue12 = 'Lower Case'">
							<xsl:text>rcLowerCase</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>rcUpperCase</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
		</xsl:if>

	</xsl:element>
</xsl:template>		

<xsl:template name = "TERMINALTYPE" >
	<xsl:variable name="terminaltype">
		<xsl:value-of select = "//COMMAND[@NAME='ISession.sessionSetup']/OBJECT_ARRAY/STRING[1]"/>
	</xsl:variable>
	<xsl:choose>
		<xsl:when test = "$terminaltype = 'ibm3270'">
			<xsl:text>rc3270Terminal</xsl:text>
		</xsl:when>
		<xsl:when test = "$terminaltype = 'ibm5250'">
			<xsl:text>rc5250Terminal</xsl:text>
		</xsl:when>
		<xsl:when test = "$terminaltype = 'ibm3287'">
			<xsl:text>rc3270Printer</xsl:text>
		</xsl:when>
		<xsl:when test = "$terminaltype = 'ibm3812'">
			<xsl:text>rc5250Printer</xsl:text>
		</xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template name = "TERMINALMODEL" >
	<xsl:variable name="terminalmodel">
		<xsl:value-of select = "//COMMAND[@NAME='ISession.sessionSetup']/OBJECT_ARRAY/STRING[2]"/>
	</xsl:variable>
	<xsl:variable name="transporttype">
		<xsl:call-template name="TRANSPORTTYPE"/>
	</xsl:variable>
	<xsl:choose>
		<xsl:when test = "$terminalmodel = '2'">
			<xsl:text>rc3270MODEL2</xsl:text>
		</xsl:when>
		<xsl:when test = "$terminalmodel = '2E'">
			<xsl:text>rc3270MODEL2E</xsl:text>
		</xsl:when>
		<xsl:when test = "$terminalmodel = '3'">
			<xsl:text>rc3270MODEL3</xsl:text>
		</xsl:when>
		<xsl:when test = "$terminalmodel = '3E'">
			<xsl:text>rc3270MODEL3E</xsl:text>
		</xsl:when>
		<xsl:when test = "$terminalmodel = '4'">
			<xsl:text>rc3270MODEL4</xsl:text>
		</xsl:when>
		<xsl:when test = "$terminalmodel = '4E'">
			<xsl:text>rc3270MODEL4E</xsl:text>
		</xsl:when>
		<xsl:when test = "$terminalmodel = '5'">
			<xsl:text>rc3270MODEL5</xsl:text>
		</xsl:when>
		<xsl:when test = "$terminalmodel = '5E'">
			<xsl:text>rc3270MODEL5E</xsl:text>
		</xsl:when>
		<xsl:when test = "$terminalmodel = '3287' and $transporttype = 'rcTelnetExtended'">
			<xsl:text>rc3287Printer</xsl:text>
		</xsl:when>
		<xsl:when test = "$terminalmodel = '3287' and $transporttype = 'rcTelnet'">
			<xsl:text>rc3287OCSPrinter</xsl:text>
		</xsl:when>
		<xsl:when test = "$terminalmodel = '3179-2'">
			<xsl:text>rc31792</xsl:text>
		</xsl:when>
		<xsl:when test = "$terminalmodel = '3180-2'">
			<xsl:text>rc31802</xsl:text>
		</xsl:when>
		<xsl:when test = "$terminalmodel = '3196-A1'">
			<xsl:text>rc3196A1</xsl:text>
		</xsl:when>
		<xsl:when test = "$terminalmodel = '3477-FC'">
			<xsl:text>rc3477FC</xsl:text>
		</xsl:when>
		<xsl:when test = "$terminalmodel = '3477-FG'">
			<xsl:text>rc3477FG</xsl:text>
		</xsl:when>
		<xsl:when test = "$terminalmodel = '3486-BA'">
			<xsl:text>rc3486BA</xsl:text>
		</xsl:when>
		<xsl:when test = "$terminalmodel = '3487-HA'">
			<xsl:text>rc3487HA</xsl:text>
		</xsl:when>
		<xsl:when test = "$terminalmodel = '3487-HC'">
			<xsl:text>rc3487HC</xsl:text>
		</xsl:when>
		<xsl:when test = "$terminalmodel = '5251-11'">
			<xsl:text>rc525111</xsl:text>
		</xsl:when>
		<xsl:when test = "$terminalmodel = '5291-2'">
			<xsl:text>rc52911</xsl:text>
		</xsl:when>
		<xsl:when test = "$terminalmodel = '3812-1'">
			<xsl:text>rc3812Printer</xsl:text>
		</xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template name = "TRANSPORTTYPE" >
	<xsl:variable name="transporttype">
		<xsl:value-of select = "//COMMAND[@NAME='ISession.sessionSetup']/OBJECT_ARRAY/STRING[3]"/>
	</xsl:variable>
	<xsl:choose>
		<xsl:when test = "$transporttype = 'tn3270'">
			<xsl:text>rcTelnet</xsl:text>
		</xsl:when>
		<xsl:when test = "$transporttype = 'tn3270e'">
			<xsl:text>rcTelnetExtended</xsl:text>
		</xsl:when>
		<xsl:when test = "$transporttype = 'tn3287'">
			<xsl:text>rcTelnet</xsl:text>
		</xsl:when>
		<xsl:when test = "$transporttype = 'tn5250'">
			<xsl:text>rcTelnet</xsl:text>
		</xsl:when>
		<xsl:when test = "$transporttype = 'demo'">
			<xsl:text>rcDemo</xsl:text>
		</xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template name = "PAPERSRC">
	<xsl:param name="source"/>
		<xsl:choose>
			<xsl:when test="$source='-2'">
				<xsl:text>rcIBMPaperSrcMfrTypModel</xsl:text>
			</xsl:when>
			<xsl:when test="$source='-1'">
				<xsl:text>rcIBMPaperSrcNone</xsl:text>
			</xsl:when>
			<xsl:when test="$source='0'">
				<xsl:text>rcIBMPaperSrcSame</xsl:text>
			</xsl:when>
			<xsl:when test="$source='1'">
				<xsl:text>rcIBMPaperSrcLetter</xsl:text>
			</xsl:when>
			<xsl:when test="$source='2'">
				<xsl:text>rcIBMPaperSrcLegal</xsl:text>
			</xsl:when>
			<xsl:when test="$source='3'">
				<xsl:text>rcIBMPaperSrcExecutive</xsl:text>
			</xsl:when>
			<xsl:when test="$source='4'">
				<xsl:text>rcIBMPaperSrcA4</xsl:text>
			</xsl:when>
			<xsl:when test="$source='5'">
				<xsl:text>rcIBMPaperSrcA5</xsl:text>
			</xsl:when>
			<xsl:when test="$source='6'">
				<xsl:text>rcIBMPaperSrcB5</xsl:text>
			</xsl:when>
			<xsl:when test="$source='7'">
				<xsl:text>rcIBMPaperSrcCont80</xsl:text>
			</xsl:when>
			<xsl:when test="$source='8'">
				<xsl:text>rcIBMPaperSrcCont132</xsl:text>
			</xsl:when>
			<xsl:when test="$source='9'">
				<xsl:text>rcIBMPaperSrcMonarch</xsl:text>
			</xsl:when>
			<xsl:when test="$source='10'">
				<xsl:text>rcIBMPaperSrcNumber9</xsl:text>
			</xsl:when>
			<xsl:when test="$source='11'">
				<xsl:text>rcIBMPaperSrcNumber10</xsl:text>
			</xsl:when>
			<xsl:when test="$source='12'">
				<xsl:text>rcIBMPaperSrcC5</xsl:text>
			</xsl:when>
			<xsl:when test="$source='13'">
				<xsl:text>rcIBMPaperSrcDL</xsl:text>
			</xsl:when>
			<xsl:when test="$source='14'">
				<xsl:text>rcIBMPaperSrcA3</xsl:text>
			</xsl:when>
			<xsl:when test="$source='15'">
				<xsl:text>rcIBMPaperSrcB4</xsl:text>
			</xsl:when>
			<xsl:when test="$source='16'">
				<xsl:text>rcIBMPaperSrcLedger</xsl:text>
			</xsl:when>
		</xsl:choose>
</xsl:template>

<xsl:template name="GETBACKGROUNDCOLOR">
	<xsl:variable name="allowmultiple">
		<xsl:value-of select = "//CONTAINER[@NAME='com.wrq.display.BlockTD']/PROPERTY_STATE/CORE_PROPERTY[@NAME='allowMultipleBkgColors']/BOOLEAN"/>
	</xsl:variable>
	<xsl:choose>
		<xsl:when test="$allowmultiple='true'">
			<xsl:text>rcColorMapbackgnd</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:variable name="bgcolor">
				<xsl:value-of select = "//CONTAINER[@NAME='ColorDisplayMap']/TD_COLOR_MAP/OBJECT_ARRAY/COLOR_ARRAY[1]/COLOR[2]"/>
			</xsl:variable>
			<xsl:call-template name="CONVERTCOLOR">
				<xsl:with-param name="color"><xsl:value-of select="$bgcolor"/></xsl:with-param>
			</xsl:call-template>			
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "CONVERTCOLOR">
	<xsl:param name="color"/>
	<xsl:choose>
		<xsl:when test="$color='0xffffff'">
			<xsl:text>rcWhite</xsl:text>
		</xsl:when>
		<xsl:when test="$color='0xc0c0c0'">
			<xsl:text>rcGrey</xsl:text>
		</xsl:when>
		<xsl:when test="$color='0xff0000'">
			<xsl:text>rcRed</xsl:text>
		</xsl:when>
		<xsl:when test="$color='0xff'">
			<xsl:text>rcBlue</xsl:text>
		</xsl:when>
		<xsl:when test="$color='0xff00'">
			<xsl:text>rcGreen</xsl:text>
		</xsl:when>
		<xsl:when test="$color='0xffff00'">
			<xsl:text>rcYellow</xsl:text>
		</xsl:when>
		<xsl:when test="$color='0xffff'">
			<xsl:text>rcCyan</xsl:text>
		</xsl:when>
		<xsl:when test="$color='0xff00ff'">
			<xsl:text>rcMagenta</xsl:text>
		</xsl:when>
		<xsl:when test="$color='0x0'">
			<xsl:text>rcBlack</xsl:text>
		</xsl:when>
		<xsl:when test="$color='0x808080'">
			<xsl:text>rcDkGrey</xsl:text>
		</xsl:when>
		<xsl:when test="$color='0x800000'">
			<xsl:text>rcDkRed</xsl:text>
		</xsl:when>
		<xsl:when test="$color='0x80'">
			<xsl:text>rcDkBlue</xsl:text>
		</xsl:when>
		<xsl:when test="$color='0x8000'">
			<xsl:text>rcDkGreen</xsl:text>
		</xsl:when>
		<xsl:when test="$color='0x808000'">
			<xsl:text>rcDkYellow</xsl:text>
		</xsl:when>
		<xsl:when test="$color='0x8080'">
			<xsl:text>rcDkCyan</xsl:text>
		</xsl:when>
		<xsl:when test="$color='0x800080'">
			<xsl:text>rcDkMagenta</xsl:text>
		</xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template name = "CALCULATEMARGIN">
	<xsl:param name="margin"/>
	<xsl:choose>
		<xsl:when test="//CORE_PROPERTY[@NAME='printerMarginUnitsOfMeasurement']/STRING ='metric'">
		<xsl:value-of select = "round(($margin * 1440) div 25.4)"/> 
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select = "round($margin * 1440)"/>
		</xsl:otherwise>
	</xsl:choose> 
</xsl:template>

<xsl:template name="NATIONALCHARACTERSET">
	<xsl:variable name="ncs">
		<xsl:value-of select = "//CORE_PROPERTY[@NAME='nationalCharacterSet']/STRING"/>
	</xsl:variable>
	<xsl:choose>
		<xsl:when test="$ncs = 'Austrian'">
			<xsl:text>rcAustrian</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'Belgian'">
			<xsl:text>rcBelgian</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'Brazilian'">
			<xsl:text>rcPortuguese</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'CanadianFrench'">
			<xsl:text>rcCanadianFrench</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'Danish'">
			<xsl:text>rcDanish</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'Danish73'">
			<!-- RIBM does not support "Danish73" -->
			<xsl:text>rcDanish</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'EastEuropean'">
			<xsl:text>rcEastEurope</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'Finnish'">
			<xsl:text>rcFinnish</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'French'">
			<xsl:text>rcFrench</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'German'">
			<xsl:text>rcGerman</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'Icelandic'">
			<xsl:text>rcIcelandic</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'Italian'">
			<xsl:text>rcItalian</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'JapaneseEnglish'">
			<xsl:text>rcJapaneseEnglish</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'JapaneseExtended'">
			<xsl:text>rcJapaneseExtended</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'JapaneseKatakana'">
			<xsl:text>rcJapaneseKatakana</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'Netherlands'">
			<xsl:text>rcNetherlands</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'NewBelgian'">
			<xsl:text>rcBelgianNew</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'Norwegian'">
			<xsl:text>rcNorwegian</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'Portuguese'">
			<xsl:text>rcPortuguese</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'Spanish'">
			<xsl:text>rcSpanish</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'Swedish'">
			<xsl:text>rcSwedish</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'SwissFrench'">
			<xsl:variable name="terminaltype">
				<xsl:call-template name="TERMINALTYPE"/>
			</xsl:variable>	
			<xsl:choose>
				<xsl:when test="$terminaltype = 'rc3270Terminal' or $terminaltype = 'rc3270Printer'">
					<xsl:text>rcSwissFrench</xsl:text>
				</xsl:when>
				<xsl:when test="$terminaltype = 'rc5250Terminal' or $terminaltype = 'rc5250Printer'">
					<xsl:text>rcSwiss</xsl:text>
				</xsl:when>
			</xsl:choose>
		</xsl:when>
		<xsl:when test="$ncs = 'SwissGerman'">
			<xsl:text>rcSwissGerman</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'UKEnglish'">
			<xsl:text>rcUKEnglish</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'USEnglish'">
			<xsl:text>rcUSEnglish</xsl:text>
		</xsl:when>
		<xsl:when test="$ncs = 'USASCII'">
			<xsl:text>rcUSASCII</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>rcUSEnglish</xsl:text>
		</xsl:otherwise>
	</xsl:choose> 
</xsl:template>



<!-- For a KEYMAP4 Container like this: 
	<CONTAINER NAME="KeyMap-4">
		<RKEYSTROKE_ARRAY SIZE="1">
			<RKEYSTROKE>
				<KEYSTROKE>
					<KEYCODE>71</KEYCODE> 
					<MODIFIERS>1</MODIFIERS> 
				</KEYSTROKE>
				<COMMAND_ACTION NAME="Shift+G">
					<COMMAND NAME="Glue.aboutBoxDialog">
						<NULL />
					</COMMAND>
				</COMMAND_ACTION>
			</RKEYSTROKE>
		</RKEYSTROKE_ARRAY>
	</CONTAINER>

	we want to produce this:
	<COMMAND name="SetKeyMap" args="3">
	<INT>rcShift</INT>
	<STRING>G</STRING>
	<STRING>AboutReflectionDlg</STRING>
	</COMMAND>

	For a KEYMAP4 Container like this:
	<CONTAINER NAME="KeyMap-4">
		<RKEYSTROKE_ARRAY SIZE="1">
			<RKEYSTROKE>
				<KEYSTROKE>
					<KEYCODE>83</KEYCODE>
					<MODIFIERS>1</MODIFIERS>
				</KEYSTROKE>
				<COMMAND_ACTION NAME="Shift+S">
					<COMMAND NAME="Emulator.transmitTerminalKey">
						<OBJECT_ARRAY SIZE="1">
							<INTEGER>29</INTEGER>
						</OBJECT_ARRAY>
					</COMMAND>
				</COMMAND_ACTION>
			</RKEYSTROKE>
		</RKEYSTROKE_ARRAY>
	</CONTAINER>

	we want to produce this:
	<COMMAND name="SetKeyMap" args="3">
	<INT>rcShift</INT>
	<STRING>S</STRING>
	<STRING>TransmitTerminalKey rcIBMEnterKey</STRING>
	</COMMAND>	

	For a KEYMAP4 Container like this:
	<CONTAINER NAME="KeyMap-4">
		<RKEYSTROKE_ARRAY SIZE="1">
			<RKEYSTROKE>
				<KEYSTROKE>
					<KEYCODE>83</KEYCODE>
					<MODIFIERS>0</MODIFIERS>
				</KEYSTROKE>
				<COMMAND_ACTION NAME="S">
					<COMMAND NAME="Emulator.transmitString">
						<OBJECT_ARRAY SIZE="1">
							<STRING>Jos van Schagen</STRING>
						</OBJECT_ARRAY>
					</COMMAND>
				</COMMAND_ACTION>
			</RKEYSTROKE>
		</RKEYSTROKE_ARRAY>
	</CONTAINER>

	we want to produce this:
	<COMMAND name="SetKeyMap" args="3">
	<INT>rcNormal</INT>
	<STRING>S</STRING>
	<STRING>TransmitANSI "Jos van Schagen"</STRING>
	</COMMAND>	
-->
<xsl:template name = "KEYMOUSEMAP" >
	<xsl:element name = "KEYMOUSEMAP">		
		<xsl:for-each select="//CONTAINER[@NAME='KeyMap-4']/RKEYSTROKE_ARRAY/RKEYSTROKE">
			<xsl:variable name = "rwebkeycode">
				<xsl:call-template name="CALC_KEYCODE_FROM_RWEBKEY">
					<xsl:with-param name="keycode">
						<xsl:value-of select="KEYSTROKE/KEYCODE"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="$rwebkeycode != 'Zoom'">	<!-- unknown key -->
				<xsl:element name = "COMMAND">
					<xsl:attribute name = "name">
						<xsl:text>SetKeyMap</xsl:text>
					</xsl:attribute>		
					<xsl:attribute name = "args">
						<xsl:text>3</xsl:text>
					</xsl:attribute>		
					<xsl:element name = "INT">
						<xsl:call-template name="CALC_MODIFIERS_FROM_RWEB">
							<xsl:with-param name="modifier">
								<xsl:value-of select="KEYSTROKE/MODIFIERS"/>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:element>	
					<xsl:element name = "STRING">
						<xsl:value-of select="$rwebkeycode"/>
					</xsl:element>	
					<xsl:element name = "STRING">
						<xsl:call-template name="BUILD_KEYCOMMAND"></xsl:call-template>
					</xsl:element>
				</xsl:element>	
			</xsl:if>	
		</xsl:for-each>
	</xsl:element>
</xsl:template>

<xsl:template name = "CALC_KEYCODE_FROM_RWEBKEY">
<!-- figure out keycode based on RWeb key. Ex: 83 maps to "S"  -->
	<xsl:param name="keycode"/>
	<xsl:choose>
		<xsl:when test="$keycode =3">
			<xsl:text>Break</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =8">
			<xsl:text>Backspace</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =9">
			<xsl:text>Tab</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =10">
			<xsl:text>Return</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =12">
			<xsl:text>Center</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =16">
			<xsl:text>RightShift</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =17">
			<xsl:text>RightControl</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =18">
			<xsl:text>Right Alt</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =19">
			<xsl:text>PauseKey</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =20">
			<xsl:text>CapsLock</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =21">
			<xsl:text>Kana</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =25">
			<xsl:text>Kanji</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =27">
			<xsl:text>Esc</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =28">
			<xsl:text>Convert</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =29">
			<xsl:text>NonConvert</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =32">
			<xsl:text>Space</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =33">
			<xsl:text>PgUp</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =34">
			<xsl:text>PgDn</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =35">
			<xsl:text>End</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =36">
			<xsl:text>Home</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =37">
			<xsl:text>LeftKey</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =38">
			<xsl:text>UpKey</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =39">
			<xsl:text>RightKey</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =40">
			<xsl:text>DownKey</xsl:text>
		</xsl:when>
		
		<xsl:when test="$keycode =44">
			<xsl:text>Comma</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =45">
			<xsl:text>Dash</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =46">
			<xsl:text>Period</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =47">
			<xsl:text>Slash</xsl:text>
		</xsl:when>		
		<xsl:when test="$keycode =48">
			<xsl:text>0</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =49">
			<xsl:text>1</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =50">
			<xsl:text>2</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =51">
			<xsl:text>3</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =52">
			<xsl:text>4</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =53">
			<xsl:text>5</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =54">
			<xsl:text>6</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =55">
			<xsl:text>7</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =56">
			<xsl:text>8</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =57">
			<xsl:text>9</xsl:text>
		</xsl:when>
		
		<xsl:when test="$keycode =59">
			<xsl:text>Semicolon</xsl:text>
		</xsl:when>

		<xsl:when test="$keycode =61">
			<xsl:text>Equals</xsl:text>
		</xsl:when>		
		
		<xsl:when test="$keycode =65">
			<xsl:text>A</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =66">
			<xsl:text>B</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =67">
			<xsl:text>C</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =68">
			<xsl:text>D</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =69">
			<xsl:text>E</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =70">
			<xsl:text>F</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =71">
			<xsl:text>G</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =72">
			<xsl:text>H</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =73">
			<xsl:text>I</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =74">
			<xsl:text>J</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =75">
			<xsl:text>K</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =76">
			<xsl:text>L</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =77">
			<xsl:text>M</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =78">
			<xsl:text>N</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =79">
			<xsl:text>O</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =80">
			<xsl:text>P</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =81">
			<xsl:text>Q</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =82">
			<xsl:text>R</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =83">
			<xsl:text>S</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =84">
			<xsl:text>T</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =85">
			<xsl:text>U</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =86">
			<xsl:text>V</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =87">
			<xsl:text>W</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =88">
			<xsl:text>X</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =89">
			<xsl:text>Y</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =90">
			<xsl:text>Z</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =91">
			<xsl:text>OpenBracket</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =92">
			<xsl:text>BackSlash</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =93">
			<xsl:text>CloseBracket</xsl:text>
		</xsl:when>

		<xsl:when test="$keycode =96">
			<xsl:text>Kp0</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =97">
			<xsl:text>Kp1</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =98">
			<xsl:text>Kp2</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =99">
			<xsl:text>Kp3</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =100">
			<xsl:text>Kp4</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =101">
			<xsl:text>Kp5</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =102">
			<xsl:text>Kp6</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =103">
			<xsl:text>Kp7</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =104">
			<xsl:text>Kp8</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =105">
			<xsl:text>Kp9</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =106">
			<xsl:text>KpMultiply</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =107">
			<xsl:text>KpPlus</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =108">
			<xsl:text>KpSeparator</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =109">
			<xsl:text>KpMinus</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =110">
			<xsl:text>KpDecimal</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =111">
			<xsl:text>KpDivide</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =112">
			<xsl:text>F1</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =113">
			<xsl:text>F2</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =114">
			<xsl:text>F3</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =115">
			<xsl:text>F4</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =116">
			<xsl:text>F5</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =117">
			<xsl:text>F6</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =118">
			<xsl:text>F7</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =119">
			<xsl:text>F8</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =120">
			<xsl:text>F9</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =121">
			<xsl:text>F10</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =122">
			<xsl:text>F11</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =123">
			<xsl:text>F12</xsl:text>
		</xsl:when>

		<xsl:when test="$keycode =127">
			<xsl:text>Del</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =128">
			<xsl:text>Grave</xsl:text>
		</xsl:when>
		
		<xsl:when test="$keycode =144">
			<xsl:text>Numlock</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =145">
			<xsl:text>ScrollLock</xsl:text>
		</xsl:when>

		<xsl:when test="$keycode =153">
			<xsl:text>Lt</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =154">
			<xsl:text>PrintScreen</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =155">
			<xsl:text>Ins</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =156">
			<xsl:text>Help</xsl:text>
		</xsl:when>

		<xsl:when test="$keycode =222">
			<xsl:text>Apostrophe</xsl:text>
		</xsl:when>
		
		<xsl:when test="$keycode =224">
			<xsl:text>CpUp</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =225">
			<xsl:text>CpDown</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =226">
			<xsl:text>CpLeft</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =227">
			<xsl:text>CpRight</xsl:text>
		</xsl:when>
		
		<xsl:when test="$keycode =61440">
			<xsl:text>F13</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =61441">
			<xsl:text>F14</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =61442">
			<xsl:text>F15</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =61443">
			<xsl:text>F16</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =61444">
			<xsl:text>F17</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =61445">
			<xsl:text>F18</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =61446">
			<xsl:text>F19</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =61447">
			<xsl:text>F20</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =61448">
			<xsl:text>F21</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =61449">
			<xsl:text>F22</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =61450">
			<xsl:text>F23</xsl:text>
		</xsl:when>
		<xsl:when test="$keycode =61451">
			<xsl:text>F24</xsl:text>
		</xsl:when>

		<xsl:when test="$keycode =65312">
			<xsl:text>Compose</xsl:text>
		</xsl:when>
		
		<xsl:otherwise> <!-- unknown key -->
			<xsl:text>Zoom</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "CALC_MODIFIERS_FROM_RWEB">
<!-- Rweb definition: Normal=0, Shift=1, Cntl=2, Meta=4, Alt=8 -->
	<xsl:param name="modifier"/>
	<xsl:choose>
		<xsl:when test="$modifier = 0">
			<xsl:text>rcNormal</xsl:text>
		</xsl:when>
		<xsl:when test="$modifier = 1">
			<xsl:text>rcShift</xsl:text>
		</xsl:when>
		<xsl:when test="$modifier = 2">
			<xsl:text>rcCtrl</xsl:text>
		</xsl:when>
		<xsl:when test="$modifier = 3">
			<xsl:text>rcCtrlShift</xsl:text>
		</xsl:when>
		<xsl:when test="$modifier = 8">
			<xsl:text>rcAlt</xsl:text>
		</xsl:when>
		<xsl:when test="$modifier = 9">
			<xsl:text>rcAltShift</xsl:text>
		</xsl:when>
		<xsl:when test="$modifier = 10">
			<xsl:text>rcAltCtrl</xsl:text>
		</xsl:when>
		<xsl:when test="$modifier = 11">
			<xsl:text>rcAltCtrlShift</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>rcNormal</xsl:text>
		</xsl:otherwise>
	</xsl:choose>	
</xsl:template>

<!-- DOUBLEQUOTES Explanation
Within a STRING any double quote needs to be doubled
For example, the SetRecentlyUsedFile command can have 
a command as one parameter where the path is quoted. 

"SaveSettings rcXMLSettingsFile, rcOverwrite, "e:\JUNK.XML""
becomes
"SaveSettings rcXMLSettingsFile, rcOverwrite, ""e:\JUNK.XML"""
-->

<xsl:template name="DOUBLEQUOTES">
	<xsl:param name="string" />
	<xsl:if test="contains($string, '&#x22;')">
		<xsl:value-of select="substring-before($string, '&#x22;')" />
			<xsl:text>&#x22;&#x22;</xsl:text>
		<xsl:call-template name="DOUBLEQUOTES">
	                <xsl:with-param name="string">
	                	<xsl:value-of select="substring-after($string, '&#x22;')" />
	                </xsl:with-param>
	        </xsl:call-template>
	</xsl:if>
	<xsl:if test="not(contains($string, '&#x22;'))">
		<xsl:value-of select="$string" />
	</xsl:if>
</xsl:template>


<xsl:template name = "BUILD_KEYCOMMAND">
<!-- build keycommand based on Ribm command string. Ex: "AboutReflectionDlg" or "TransmitTerminalKey rcIBMEnterKey -->		
	<xsl:choose>
		<xsl:when test="COMMAND_ACTION/COMMAND/@NAME='Emulator.transmitTerminalKey' and 
						COMMAND_ACTION/COMMAND/OBJECT_ARRAY/INTEGER!='-1'">
			<xsl:text>TransmitTerminalKey </xsl:text>
			<xsl:call-template name="GETTERMINALKEY">
				<xsl:with-param name="ibmhostkey">
					<xsl:value-of select="COMMAND_ACTION/COMMAND/OBJECT_ARRAY/INTEGER"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:when>

		<xsl:when test="COMMAND_ACTION/COMMAND/@NAME='Emulator.transmitString'">
			<xsl:text>TransmitANSI "</xsl:text>
				<xsl:call-template name="DOUBLEQUOTES">
					<xsl:with-param name="string">						
						<xsl:value-of select="COMMAND_ACTION/COMMAND/OBJECT_ARRAY/STRING"/>
					</xsl:with-param>
				</xsl:call-template>
			<xsl:text>"</xsl:text>
		</xsl:when>

		<xsl:when test="COMMAND_ACTION/COMMAND/@NAME='Glue.aboutBoxDialog'">
			<xsl:text>AboutReflectionDlg</xsl:text>
		</xsl:when>
		
		<xsl:when test="COMMAND_ACTION/COMMAND/@NAME='Glue.copy'">
			<xsl:text>CopySelection</xsl:text>
		</xsl:when>
		
		<xsl:when test="COMMAND_ACTION/COMMAND/@NAME='Glue.paste'">
			<xsl:text>Paste</xsl:text>
		</xsl:when>
		
		<xsl:when test="COMMAND_ACTION/COMMAND/@NAME='Glue.screenPrint'">
			<xsl:text>Print rcPrintPartition</xsl:text>
		</xsl:when>
		
		<xsl:when test="COMMAND_ACTION/COMMAND/@NAME='Glue.selectionPrint'">
			<xsl:text>Print rcPrintScreenOrSel, 1</xsl:text>
		</xsl:when>
		
		<xsl:when test="COMMAND_ACTION/COMMAND/@NAME='Glue.screenPrint'">
			<xsl:text>Print rcPrintScreen, 1</xsl:text>
		</xsl:when>
		
		<xsl:when test="COMMAND_ACTION/COMMAND/@NAME='Glue.selectionPrint'">
			<xsl:text>Print rcPrintSel, 1</xsl:text>
		</xsl:when>
		
		<xsl:when test="COMMAND_ACTION/COMMAND/@NAME='Glue.selectAll'">
			<xsl:text>SelectAll</xsl:text>
		</xsl:when>
		
		<xsl:when test="COMMAND_ACTION/COMMAND/@NAME='ITDService.selectWordRight'">
			<xsl:text>SelectWord</xsl:text>
		</xsl:when>

		<xsl:when test="COMMAND_ACTION/COMMAND/@NAME='ISession.connect'">
			<xsl:text>Connect</xsl:text>
		</xsl:when>
		
		<xsl:when test="COMMAND_ACTION/COMMAND/@NAME='ISession.disconnect'">
			<xsl:text>Disconnect</xsl:text>
		</xsl:when>
		<xsl:otherwise>		<!-- disable by using empty string -->
			<xsl:text></xsl:text>
		</xsl:otherwise>
	</xsl:choose>		
</xsl:template>


<xsl:template name = "GETTERMINALKEY">
	<xsl:param name="ibmhostkey"/>
	<xsl:variable name="terminaltype">
		<xsl:call-template name="TERMINALTYPE"/>
	</xsl:variable>	
	<xsl:choose>
		<xsl:when test="$terminaltype = 'rc3270Terminal'">
			<xsl:call-template name="GET3270TERMINALKEY">
				<xsl:with-param name="rcibmkey">
					<xsl:value-of select="$ibmhostkey"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="$terminaltype = 'rc5250Terminal'">
			<xsl:call-template name="GET5250TERMINALKEY">
				<xsl:with-param name="rcibmkey">
					<xsl:value-of select="$ibmhostkey"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template name = "GET3270TERMINALKEY">
	<xsl:param name="rcibmkey"/>
	<xsl:choose>
		<xsl:when test="$rcibmkey = 1">
			<xsl:text>rcIBMDeleteCharKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 2">
			<xsl:text>rcIBMDeleteWordKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 3">
			<xsl:text>rcIBMDupKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 4">
			<xsl:text>rcIBMEraseEOFKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 5">
			<xsl:text>rcIBMSysreqstKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 6">
			<xsl:text>rcIBMPf1Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 7">
			<xsl:text>rcIBMPf2Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 8">
			<xsl:text>rcIBMPf3Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 9">
			<xsl:text>rcIBMPf4Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 10">
			<xsl:text>rcIBMPf5Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 11">
			<xsl:text>rcIBMPf6Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 12">
			<xsl:text>rcIBMPf7Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 13">
			<xsl:text>rcIBMPf8Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 14">
			<xsl:text>rcIBMPf9Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 15">
			<xsl:text>rcIBMPf10Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 16">
			<xsl:text>rcIBMPf11Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 17">
			<xsl:text>rcIBMPf12Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 18">
			<xsl:text>rcIBMPf13Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 19">
			<xsl:text>rcIBMPf14Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 20">
			<xsl:text>rcIBMPf15Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 21">
			<xsl:text>rcIBMPf16Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 22">
			<xsl:text>rcIBMPf17Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 23">
			<xsl:text>rcIBMPf18Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 24">
			<xsl:text>rcIBMPf19Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 25">
			<xsl:text>rcIBMPf20Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 26">
			<xsl:text>rcIBMPf21Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 27">
			<xsl:text>rcIBMPf22Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 28">
			<xsl:text>rcIBMPf23Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 29">
			<xsl:text>rcIBMPf24Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 30">
			<xsl:text>rcIBMPA1Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 31">
			<xsl:text>rcIBMPA2Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 32">
			<xsl:text>rcIBMPA3Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 33">
			<xsl:text>rcIBMClearKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 35">
			<xsl:text>rcIBMEnterKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 36">
			<xsl:text>rcIBMCursorSelectKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 37">
			<xsl:text>rcIBMAttnKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 38">
			<xsl:text>rcIBMBackSpaceKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 39">
			<xsl:text>rcIBMBacktabKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 40">
			<xsl:text>rcIBMDownKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 41">
			<xsl:text>rcIBMEraseInputKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 42">
			<xsl:text>rcIBMHomeKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 43">
			<xsl:text>rcIBMIdentKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 44">
			<xsl:text>rcIBMInsertKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 45">
			<xsl:text>rcIBMLeftKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 46">
			<xsl:text>rcIBMLeftDoubleKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 47">
			<xsl:text>rcIBMNewLineKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 48">
			<xsl:text>rcIBMPrintKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 49">
			<xsl:text>rcIBMRightKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 50">
			<xsl:text>rcIBMRightDoubleKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 51">
			<xsl:text>rcIBMFieldMarkKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 52">
			<xsl:text>rcIBMTabKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 53">
			<xsl:text>rcIBMUpKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 55">
			<xsl:text>rcIBMEndOfFieldKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 56">
			<xsl:text>rcIBMDestrBackSpaceKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 60">
			<xsl:text>rcIBMDevicecancelKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 65">
			<xsl:text>rcIBMResetKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 68">
			<xsl:text>rcIBMFieldDelimKey</xsl:text>	
		</xsl:when>

		<xsl:otherwise>
			<xsl:text>0</xsl:text>	
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name = "GET5250TERMINALKEY">
	<xsl:param name="rcibmkey"/>
	<xsl:choose>
		<xsl:when test="$rcibmkey = 1">
			<xsl:text>rcIBMF1Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 2">
			<xsl:text>rcIBMF2Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 3">
			<xsl:text>rcIBMF3Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 4">
			<xsl:text>rcIBMF4Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 5">
			<xsl:text>rcIBMF5Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 6">
			<xsl:text>rcIBMF6Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 7">
			<xsl:text>rcIBMF7Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 8">
			<xsl:text>rcIBMF8Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 9">
			<xsl:text>rcIBMF9Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 10">
			<xsl:text>rcIBMF10Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 11">
			<xsl:text>rcIBMF11Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 12">
			<xsl:text>rcIBMF12Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 13">
			<xsl:text>rcIBMF13Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 14">
			<xsl:text>rcIBMF14Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 15">
			<xsl:text>rcIBMF15Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 16">
			<xsl:text>rcIBMF16Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 17">
			<xsl:text>rcIBMF17Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 18">
			<xsl:text>rcIBMF18Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 19">
			<xsl:text>rcIBMF19Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 20">
			<xsl:text>rcIBMF20Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 21">
			<xsl:text>rcIBMF21Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 22">
			<xsl:text>rcIBMF22Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 23">
			<xsl:text>rcIBMF23Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 24">
			<xsl:text>rcIBMF24Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 25">
			<xsl:text>rcIBMPA1Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 26">
			<xsl:text>rcIBMPA2Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 27">
			<xsl:text>rcIBMPA3Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 28">
			<xsl:text>rcIBMHomeKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 29">
			<xsl:text>rcIBMEnterKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 30">
			<xsl:text>rcIBMClearKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 31">
			<xsl:text>rcIBMCursorSelectKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 32">
			<xsl:text>rcIBMUpKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 33">
			<xsl:text>rcIBMDownKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 34">
			<xsl:text>rcIBMLeftKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 35">
			<xsl:text>rcIBMRightKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 36">
			<xsl:text>rcIBMBackSpaceKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey= 37">
			<xsl:text>rcIBMInsertKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 38">
			<xsl:text>rcIBMDeleteCharKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 39">
			<xsl:text>rcIBMTabKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 40">
			<xsl:text>rcIBMBacktabKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 41">
			<xsl:text>rcIBMFieldExitKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 42">
			<xsl:text>rcIBMFieldPlusKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 43">
			<xsl:text>rcIBMFieldMinusKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 44">
			<xsl:text>rcIBMEraseInputKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 45">
			<xsl:text>rcIBMEraseEOFKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 46">
			<xsl:text>rcIBMDuplicateKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 47">
			<xsl:text>rcIBMFieldMarkKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 48">
			<xsl:text>rcIBMEndOfFieldKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 49">
			<xsl:text>rcIBMDestrBackSpaceKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 50">
			<xsl:text>rcIBMResetKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 51">
			<xsl:text>rcIBMSysreqstKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 52">
			<xsl:text>rcIBMHelpKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 53">
			<xsl:text>rcIBMAttnKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 54">
			<xsl:text>rcIBMTestKey</xsl:text>	
		</xsl:when>
		<!-- not sure what Ribm key matches Rweb "kKeyShowAttr" -->
		<xsl:when test="$rcibmkey = 55">
			<xsl:text>rcIBMShowAttr</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 56">
			<xsl:text>rcIBMRollUpKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 57">
			<xsl:text>rcIBMRollDownKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 58">
			<xsl:text>rcIBMNewLineKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 59">
			<xsl:text>rcIBMHexKey</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 60">
			<xsl:text>rcIBMAU1Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 61">
			<xsl:text>rcIBMAU2Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 62">
			<xsl:text>rcIBMAU3Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 63">
			<xsl:text>rcIBMAU4Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 64">
			<xsl:text>rcIBMAU5Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 65">
			<xsl:text>rcIBMAU6Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 66">
			<xsl:text>rcIBMAU7Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 67">
			<xsl:text>rcIBMAU8Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 68">
			<xsl:text>rcIBMAU9Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 69">
			<xsl:text>rcIBMAU10Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 70">
			<xsl:text>rcIBMAU11Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 71">
			<xsl:text>rcIBMAU12Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 72">
			<xsl:text>rcIBMAU13Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 73">
			<xsl:text>rcIBMAU14Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 74">
			<xsl:text>rcIBMAU15Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 75">
			<xsl:text>rcIBMAU16Key</xsl:text>	
		</xsl:when>
		<xsl:when test="$rcibmkey = 76">
			<xsl:text>rcIBMPrintKey</xsl:text>	
		</xsl:when>
		<!-- not sure what Ribm key matches Rweb "kKeyStartOfField" -->
		<xsl:when test="$rcibmkey = 77">
			<xsl:text>rcIBMStartOfFieldKey</xsl:text>	
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>0</xsl:text>	
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template match="text()|@*"/>

</xsl:stylesheet>


<!-- Things to consider:

no version for REFLECTION_SETTINGS
no CREATOR attributes
no COUNT
no args attribute for COMMAND
order of settings may cause a problem
path to CORE_PROPERTY could be fully specified 

-->
