<?xml version="1.0" standalone="no"?>
<xsl:stylesheet	
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	version="1.0">
<xsl:output 
	method="xml" 
	indent="yes"/>

<!--  RibmHtml.xsl  Converts XML settings file to XHTML -->
<!--  $Id: //ribm/12.0/dev/r8supprt/xml/ribmhtml.xsl#1 $ -->

<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
<xsl:template match="/">
<HTML>
<HEAD>
<STYLE TYPE="text/css">
	H1 {font-size: x-large;
		color: blue;}
	H2 {font-size: large;
		text-align: center;
		color: darkred;
		background: silver;}
	th {background: cyan;
		text-align: center;
		font-weight: bold}
</STYLE>
<!-- There are two different titles, depending on whether
     these are all settings or just the changed settings. -->
	<xsl:variable name="type">
		<xsl:value-of select="/REFLECTION_SETTINGS/TYPE/@mode"/>
	</xsl:variable>

	<xsl:variable name="pagetitle">
		<xsl:choose>
			<xsl:when test="$type = 'All'">
				Reflection for IBM Settings
			</xsl:when>
			<xsl:otherwise>
				Reflection for IBM Changed Settings
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<TITLE><xsl:value-of select="$pagetitle"/></TITLE>

<meta http-equiv="Content-Type" content="text/html"/>
</HEAD>
<BODY>
	<H1><xsl:value-of select="$pagetitle"/></H1>
  <p><b>Note:</b> This HTML requires <a href="http://www.microsoft.com/ie">Internet
	Explorer</a> version 6.0 or later.</p>
	<!-- center the navbar across the window -->
	<center>
	<table border="1" cellpadding="0" cellspacing="0" width="85%"
		bgcolor="silver" bordercolor="silver">
	<tr>
		<td width="15%" align="left"><font face="Arial"><a href="#session">			<b>Session		</b></a></font></td>
		<td width="10%" align="left"><font face="Arial"><a href="#3270properties">	<b>3270			</b></a></font></td>
		<td width="15%" align="left"><font face="Arial"><a href="#printer">			<b>Printer		</b></a></font></td>
		<td width="15%" align="left"><font face="Arial"><a href="#hotspots">		<b>Hotspots		</b></a></font></td>
		<td width="12%" align="left"><font face="Arial"><a href="#menus">			<b>Menus		</b></a></font></td>
		<td width="17%" align="left"><font face="Arial"><a href="#copypaste">		<b>Copy/Paste	</b></a></font></td>
		<td width="16%" align="left"><font face="Arial"><a href="#properties">		<b>Properties	</b></a></font></td>
	</tr>
	<tr>
		<td width="15%" align="right"><font face="Arial"><a href="#connection">		<b>Connection	</b></a></font></td>
		<td width="10%" align="right"><font face="Arial"><a href="#5250properties">	<b>5250			</b></a></font></td>
		<td width="15%" align="right"><font face="Arial"><a href="#toolbars">		<b>Toolbars		</b></a></font></td>
		<td width="15%" align="right"><font face="Arial"><a href="#keymousemap">	<b>Key Map		</b></a></font></td>
		<td width="12%" align="right"><font face="Arial"><a href="#events">			<b>Events		</b></a></font></td>
		<td width="17%" align="right"><font face="Arial"><a href="#colors">			<b>Colors		</b></a></font></td>
		<td width="16%" align="right"><font face="Arial"><a href="#window">			<b>Window		</b></a></font></td>
	</tr>
	</table>
	<p/>
	</center>
  <xsl:apply-templates/>

	<!-- write a short explanation for any missing sections, i.e. a partial settings file -->
	<xsl:variable name="count_sess"><xsl:value-of select="count(REFLECTION_SETTINGS/SESSION)"/></xsl:variable>
	<xsl:variable name="count_3270"><xsl:value-of select="count(REFLECTION_SETTINGS/IBM3270)"/></xsl:variable>
	<xsl:variable name="count_5250"><xsl:value-of select="count(REFLECTION_SETTINGS/IBM5250)"/></xsl:variable>
	<xsl:variable name="count_prnt"><xsl:value-of select="count(REFLECTION_SETTINGS/PRINTER)"/></xsl:variable>
	<xsl:variable name="count_keym"><xsl:value-of select="count(REFLECTION_SETTINGS/KEYMOUSEMAP)"/></xsl:variable>
	<xsl:variable name="count_colr"><xsl:value-of select="count(REFLECTION_SETTINGS/COLORS)"/></xsl:variable>
	<xsl:variable name="count_evnt"><xsl:value-of select="count(REFLECTION_SETTINGS/EVENTS)"/></xsl:variable>
	<xsl:variable name="count_tool"><xsl:value-of select="count(REFLECTION_SETTINGS/TOOLBARS)"/></xsl:variable>
	<xsl:variable name="count_wind"><xsl:value-of select="count(REFLECTION_SETTINGS/WINDOW)"/></xsl:variable>
	<xsl:variable name="count_hots"><xsl:value-of select="count(REFLECTION_SETTINGS/HOTSPOTS)"/></xsl:variable>
	<xsl:variable name="count_copy"><xsl:value-of select="count(REFLECTION_SETTINGS/COPYPASTE)"/></xsl:variable>
	<xsl:variable name="count_menu"><xsl:value-of select="count(REFLECTION_SETTINGS/MENUS)"/></xsl:variable>
	<xsl:variable name="count_conn"><xsl:value-of select="count(REFLECTION_SETTINGS/CONNECTION)"/></xsl:variable>
	<xsl:variable name="count_prop"><xsl:value-of select="count(REFLECTION_SETTINGS/PROPERTIES)"/></xsl:variable>

	<xsl:if test="$count_sess = 0">
		<H2><a name="session">Session Properties</a></H2>
		No session information available.
	</xsl:if>

	<xsl:if test="$count_3270 = 0">
		<H2><a name="3270properties">IBM 3270 Properties</a></H2>
		No 3270 information available.
	</xsl:if>

	<xsl:if test="$count_5250 = 0">
		<H2><a name="5250properties">IBM 5250 Properties</a></H2>
		No 5250 information available.
	</xsl:if>

	<xsl:if test="$count_prnt = 0">
		<H2><a name="printer">Printer</a></H2>
		No printer information available.
	</xsl:if>

	<xsl:if test="$count_keym = 0">
		<H2><a name="keymousemap">Keyboard and Mouse</a></H2>
		No keyboard and mouse information is available.
	</xsl:if>

	<xsl:if test="$count_colr = 0">
		<H2><a name="colors">Colors</a></H2>
		No color information available.
 	</xsl:if>

	<xsl:if test="$count_evnt = 0">
		<H2><a name="events">Events</a></H2>
		No event information available.
	</xsl:if>

	<xsl:if test="$count_tool = 0">
		<H2><a name="toolbars">Toolbars</a></H2>
		No toolbar information available.
	</xsl:if>

	<xsl:if test="$count_wind = 0">
		<H2><a name="window">Window</a></H2>
		No window information available.
	</xsl:if>

	<xsl:if test="$count_hots = 0">
		<H2><a name="hotspots">Hotspots</a></H2>
		No hotspot information available.
	</xsl:if>

	<xsl:if test="$count_copy = 0">
		<H2><a name="copypaste">Copy/Paste</a></H2>
		No copy/paste information available.
	</xsl:if>

	<xsl:if test="$count_menu = 0">
		<H2><a name="menus">Menus</a></H2>
		No menu information available.
	</xsl:if>

	<xsl:if test="$count_conn = 0">
		<H2><a name="connection">Connection</a></H2>
		No connection information available.
	</xsl:if>

	<xsl:if test="$count_prop = 0">
		<H2><a name="properties">String and Numeric Properties</a></H2>
		No string and numeric property information available.
	</xsl:if>

</BODY>
</HTML>
</xsl:template>

<xsl:template match="CREATOR" >
This product is "<xsl:value-of select="@product"/>"
version <xsl:value-of select="@version"/> 
build <xsl:value-of select="@build"/>.
</xsl:template>

<xsl:template match="TYPE" >
	<BR/>The file type is <xsl:value-of select="."/>.
	<xsl:variable name="type">
		<xsl:value-of select="/REFLECTION_SETTINGS/TYPE/@mode"/>
	</xsl:variable>
	<xsl:choose>
		<!-- xsl:when test="$type = 'All'">
			This contains <b>all</b> the settings.
		</xsl:when -->
		<xsl:when test="$type = 'ChangedFactory'">
			This list contains only the settings <b>changed from factory</b> defaults.
		</xsl:when>
		<xsl:when test="$type = 'ChangedProfile'">
			This describes only the settings <b>changed from profiled</b> defaults.
		</xsl:when>
	</xsl:choose>
</xsl:template>

<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
<xsl:template match="PROPERTIES" >
	<H2><a name="properties">String and Numeric Properties</a></H2>
	<xsl:variable name = "count">
		<xsl:value-of select="COUNT"/>
	</xsl:variable>

	<xsl:choose>
		<xsl:when test="$count > 0">
			<table border="3" cellpadding="3">
				<th>Property</th>
				<th>Value</th>
				<xsl:apply-templates select="COMMAND">
					<xsl:sort data-type="text" select="INT"/>
				</xsl:apply-templates>
			</table>
			<xsl:value-of select="COUNT"/> Properties
		</xsl:when>
		<xsl:otherwise>
			<P><I>All properties are at defaults</I></P>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
<xsl:template match="SESSION" >
	<H2><a name="session">Session Properties</a></H2>

	<xsl:variable name="cmd_count"><xsl:value-of select="count(COMMAND[@name!='SetNumeric' and @name!='SetString'])"/></xsl:variable>
	<xsl:variable name="prop_count"><xsl:value-of select="count(COMMAND[@name='SetNumeric' or @name='SetString'])"/></xsl:variable>

	<xsl:if test="$cmd_count > 0">
		<!-- process all commands *except* strings and numerics -->
		<table border="3" cellpadding="3">
			<th>Command</th>
			<th>Session Type</th>
			<th>Model Number</th>
			<th>Connection Type</th>
			<xsl:apply-templates select="COMMAND[@name!='SetNumeric' and @name!='SetString']"/>
		</table>
	</xsl:if>

	<xsl:if test="$prop_count > 0">
		<!-- process *only* the string and numeric settings -->
		<p/>
		<table border="3" cellpadding="3">
			<th>Session Property</th>
			<th>Value</th>
			<xsl:apply-templates select="COMMAND[@name='SetNumeric' or @name='SetString']">
				<xsl:sort data-type="text" select="INT"/>
			</xsl:apply-templates>
		</table>
	</xsl:if>
</xsl:template>

<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
<xsl:template match="IBM3270" >
	<H2><a name="3270properties">IBM 3270 Properties</a></H2>

	<xsl:variable name="cmd_count"><xsl:value-of select="count(COMMAND[@name!='SetNumeric' and @name!='SetString'])"/></xsl:variable>
	<xsl:variable name="prop_count"><xsl:value-of select="count(COMMAND[@name='SetNumeric' or @name='SetString'])"/></xsl:variable>

	<xsl:if test="$cmd_count > 0">
		<!-- process all commands *except* strings and numerics -->
		<table border="3" cellpadding="3">
			<th>Command</th>
			<th>Host System</th>
			<th>PC Filename</th>
			<th>Host Filename</th>
			<th>Transfer Type</th>
			<th>Exists Action</th>
			<th>Record Format</th>
			<th>ASCII CRLF</th>
			<th>Binary CRLF</th>
			<th>JISCII CRLF</th>
			<th>Record Length</th>
			<th>Add Param</th>
			<th>Block Size</th>
			<th>Alloc Size</th>
			<th>Avg Block Size</th>
			<th>Primary Alloc</th>
			<th>Secondary Alloc</th>
			<xsl:apply-templates select="COMMAND[@name!='SetNumeric' and @name!='SetString']"/>
		</table>
	</xsl:if>

	<xsl:if test="$prop_count > 0">
		<!-- process *only* the string and numeric settings -->
		<p/>
		<table border="3" cellpadding="3">
			<th>3270 Property</th>
			<th>Value</th>
			<xsl:apply-templates select="COMMAND[@name='SetNumeric' or @name='SetString']">
				<xsl:sort data-type="text" select="INT"/>
			</xsl:apply-templates>
		</table>
	</xsl:if>
</xsl:template>

<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
<xsl:template match="IBM5250" >
	<H2><a name="5250properties">IBM 5250 Properties</a></H2>

	<xsl:variable name="cmd_count"><xsl:value-of select="count(COMMAND[@name!='SetNumeric' and @name!='SetString'])"/></xsl:variable>
	<xsl:variable name="prop_count"><xsl:value-of select="count(COMMAND[@name='SetNumeric' or @name='SetString'])"/></xsl:variable>

	<xsl:if test="$cmd_count > 0">
		<!-- process all commands *except* strings and numerics -->
		<table border="3" cellpadding="3">
			<th>Command</th>
			<th>SQL Query Type</th>
			<th>SQL Statement</th>
			<!-- sort by name of command, to help push SetSQLStatement's toward the top -->
			<xsl:apply-templates select="COMMAND[@name!='SetNumeric' and @name!='SetString']">
				<xsl:sort data-type="text" select="@name"/>
			</xsl:apply-templates>
		</table>
	</xsl:if>

	<xsl:if test="$prop_count > 0">
		<!-- process *only* the string and numeric settings -->
		<p/>
		<table border="3" cellpadding="3">
			<th>5250 Property</th>
			<th>Value</th>
			<xsl:apply-templates select="COMMAND[@name='SetNumeric' or @name='SetString']">
				<xsl:sort data-type="text" select="INT"/>
			</xsl:apply-templates>
		</table>
	</xsl:if>
</xsl:template>

<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
<xsl:template match="PRINTER" >
	<H2><a name="printer">Printer</a></H2>

	<xsl:variable name="cmd_count"><xsl:value-of select="count(COMMAND[@name!='SetNumeric' and @name!='SetString'])"/></xsl:variable>
	<xsl:variable name="prop_count"><xsl:value-of select="count(COMMAND[@name='SetNumeric' or @name='SetString'])"/></xsl:variable>

	<xsl:if test="$cmd_count > 0">
		<!-- process all commands *except* strings and numerics (none expected for <PRINTER>) -->
		<table border="3" cellpadding="3">
			<th>Command</th>
			<th>Values</th>
			<xsl:apply-templates select="COMMAND[@name!='SetNumeric' and @name!='SetString']">
				<xsl:sort data-type="text" select="INT"/>
			</xsl:apply-templates>
		</table>
	</xsl:if>

	<xsl:if test="$prop_count > 0">
		<!-- process *only* the string and numeric settings -->
		<table border="3" cellpadding="3">
			<th>Printer Property</th>
			<th>Value</th>
			<xsl:apply-templates select="COMMAND[@name='SetNumeric' or @name='SetString']">
				<xsl:sort data-type="text" select="INT"/>
			</xsl:apply-templates>
		</table>
	</xsl:if>
</xsl:template>

<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
<xsl:template match="KEYMOUSEMAP" >
	<!-- this section is a list of "SetKeyMap" commands,
		 and has no numeric/string properties -->
	<H2><a name="keymousemap">Keyboard and Mouse</a></H2>
	<xsl:variable name = "count">
		<xsl:value-of select="COUNT"/>
	</xsl:variable>

	<xsl:choose>
		<xsl:when test="$count > 0">
			<table border="3" cellpadding="3">
				<th>Command</th>
				<th>Modifier</th>
				<th>Key</th>
				<th>Assignment</th>
				<xsl:apply-templates select="COMMAND">
					<xsl:sort data-type="text" select="STRING[1]"/>
				</xsl:apply-templates>
			</table>
		</xsl:when>
		<xsl:otherwise>
			<P><I>All keyboard and mouse properties are at default values.</I></P>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
<xsl:template match="COLORS">
	<H2><a name="colors">Colors</a></H2>
	<xsl:variable name = "count">
		<xsl:value-of select="COUNT"/>
	</xsl:variable>

	<xsl:choose>
		<xsl:when test="$count = 0">
			<P/><I>Default Colors</I>
			<P/>
		</xsl:when>
		<xsl:otherwise>
			<P/>
			<xsl:apply-templates select="COLOR_ATTRIBUTES"/>
		</xsl:otherwise>
	 </xsl:choose>
</xsl:template>

<xsl:template match="COLOR_ATTRIBUTES">
<H3>Color Commands</H3>
<table border="3" cellpadding="3">
	<tr>
		<th align="center" bgcolor="cyan">Command</th>
		<th align="center" bgcolor="cyan">Attribute</th>
		<th align="center" bgcolor="cyan">Foreground</th>
		<th align="center" bgcolor="cyan">Background</th>
	</tr>
	<xsl:apply-templates select="COMMAND[@name='SetColorMap']"/>
</table>
<H3>Color Palette</H3>
<table border="3" cellpadding="3">
	<th>Command</th>
	<th>Color</th>
	<th>Red</th>
	<th>Green</th>
	<th>Blue</th>
	<th>Sample</th>
	<xsl:apply-templates select="COMMAND[@name='SetColorRGB']"/>
</table>
</xsl:template>

<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
<xsl:template match="EVENTS" >
	<H2><a name="events">Events</a></H2>

	<xsl:variable name="cmd_count"><xsl:value-of select="count(COMMAND[@name!='SetNumeric' and @name!='SetString'])"/></xsl:variable>
	<xsl:variable name="prop_count"><xsl:value-of select="count(COMMAND[@name='SetNumeric' or @name='SetString'])"/></xsl:variable>

	<xsl:if test="$cmd_count > 0">
		<!-- process all commands *except* strings and numerics -->
		<table border="3" cellpadding="3">
			<th colspan="2">Event Command</th>
			<th>Trigger</th>
			<th>Command</th>
			<th>Enable</th>
			<th>After Event</th>
			<th>String</th>
			<th>Row</th>
			<th>Column</th>
			<xsl:apply-templates select="COMMAND"/>
		</table>
	</xsl:if>

	<xsl:if test="$prop_count > 0">
		<!-- process *only* the string and numeric settings -->
		<p/>
		<table border="3" cellpadding="3">
			<th>Event Property</th>
			<th>Value</th>
			<xsl:apply-templates select="COMMAND[@name='SetNumeric' or @name='SetString']">
				<xsl:sort data-type="text" select="INT"/>
			</xsl:apply-templates>
		</table>
	</xsl:if>
</xsl:template>

<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
<xsl:template match="TOOLBARS">
	<!-- This section has only toolbar commands, and no SetNumeric/SetString properties -->
	<H2><a name="toolbars">Toolbars</a></H2>
	<xsl:variable name = "count">
		<xsl:value-of select="COUNT"/>
	</xsl:variable>

	<xsl:choose>
		<xsl:when test="$count > 0">
			<table border="3" cellpadding="3">
				<xsl:for-each select="COMMAND">
					<xsl:variable name = "cmdName">
						<xsl:value-of select="@name"/>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="$cmdName = 'NewToolbar'">
							<tr>
							<th colspan="12">New Toolbar: <xsl:value-of select="."/></th>
							</tr>
						</xsl:when>
						<xsl:when test="$cmdName = 'SetToolbarMode'">
							<tr>
							<td align="left" colspan="3">Toolbar Mode (<xsl:value-of select="STRING[1]"/>):</td>
							<td align="left" colspan="9"><xsl:value-of select="INT[1]"/></td></tr>
						</xsl:when>
						<xsl:when test="$cmdName = 'ShowToolbar'">
							<tr>
							<td align="left" colspan="3">
								Show Toolbar (<xsl:value-of select="STRING[1]"/>):
							</td>
							<td align="left" colspan="9"><xsl:value-of select="BOOL[1]"/></td>
							</tr>
						</xsl:when>
						<xsl:when test="$cmdName = 'SetToolbarPosition'">
							<!-- What do these ints signify? -->
							<!-- These INTs indicate left, top, width, height -->
							<tr>
							<td colspan="2"><xsl:value-of select="@name"/></td>
							<td><xsl:value-of select="INT[1]"/></td>
							<td><xsl:value-of select="INT[2]"/></td>
							<td><xsl:value-of select="INT[3]"/></td>
							<td><xsl:value-of select="INT[4]"/></td>
							</tr>
						</xsl:when>
						<xsl:when test="$cmdName = 'DefineToolbarButton'">
							<xsl:variable name="firstButton">
								<xsl:value-of select="INT[1]"/>
							</xsl:variable>
							<tr>
								<xsl:if test="$firstButton = '1'">
									<tr>
									<td colspan="12">Buttons on toolbar <b><xsl:value-of select="STRING[1]"/></b>:</td>
									</tr>
									<tr>
										<td/>
										<th valign="bottom" rowspan="2">Toolbar</th>
										<th valign="bottom" rowspan="2">Index</th>
										<th valign="bottom" rowspan="2">Separator</th>
										<th colspan="2">Small Bitmap</th>
										<th colspan="2">Large Bitmap</th>
										<th valign="bottom" rowspan="2">Label</th>
										<th valign="bottom" rowspan="2">Tip Text</th>
										<th valign="bottom" rowspan="2">Help Text</th>
										<th valign="bottom" rowspan="2">Commands</th>
									</tr>
									<tr>
										<td/>
										<th>File</th>
										<th>Index</th>
										<th>File</th>
										<th>Index</th>
									</tr>
								</xsl:if>
								<td/>
								<xsl:apply-templates/>
							</tr>
						</xsl:when>
						<xsl:otherwise>
							<xsl:apply-templates/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</table>
		</xsl:when>
		<xsl:otherwise>
			<P><I>No toolbars are defined</I></P>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
<xsl:template match="HOTSPOTS" >
	<H2><a name="hotspots">Hotspots</a></H2>
	<xsl:variable name = "count">
		<xsl:value-of select="COUNT"/>
	</xsl:variable>

	<xsl:choose>
		<xsl:when test="$count > 0">
			<table border="3" cellpadding="3">
				<tr>
					<th colspan="4">Hotspot Properties</th>
				</tr>
				<xsl:for-each select="COMMAND">
					<xsl:variable name = "cmdName">
						<xsl:value-of select="@name"/>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="$cmdName = 'SetNumeric'">
							<tr>
								<td colspan="2"><xsl:value-of select="@name"/></td>
								<td colspan="1"><xsl:value-of select="INT[1]"/></td>
								<td colspan="1"><xsl:value-of select="BOOL[1]"/></td>
							</tr>
						</xsl:when>
						<xsl:when test="$cmdName = 'NewHotlist'">
							<tr>
								<th colspan="8">
									New Hotlist: <xsl:value-of select="STRING[1]"/>
								</th>
							</tr>
							<tr>
								<td align="left" colspan="3">
									Hotlist Options (<xsl:value-of select="STRING[1]"/>):
								</td>
								<td align="left" colspan="5">
									<xsl:value-of select="INT[1]"/>
								</td>
							</tr>
							<tr>
								<td align="left" colspan="8">
									Items: (<xsl:value-of select="STRING[1]"/>)
								</td>
							</tr>
							<tr>
								<td/>
								<th>Hotlist</th>
								<th>Options</th>
								<th>Item Name</th>
								<th colspan="4">Command</th>
							</tr>
						</xsl:when>
						<xsl:when test="$cmdName = 'AddHotListItem'">
							<tr>
							<td/>
							<td><xsl:value-of select="STRING[1]"/></td>
							<td><xsl:value-of select="INT[1]"/></td>
							<td><xsl:value-of select="STRING[2]"/></td>
							<td colspan="4"><xsl:value-of select="STRING[3]"/></td>
							</tr>
						</xsl:when>
						<xsl:when test="$cmdName = 'DefineHotspotEx' or $cmdName = 'DefineHotspot'">
							<tr>
							<th align="center" rowspan="2">Hotspot</th>
							<th align="center">Match String</th>
							<th align="center">Options</th>
							<th align="center">Row</th>
							<th align="center">Column</th>
							<th align="center">Tip Text</th>
							<th align="center">Help Text</th>
							<th align="center">Command</th>
							</tr>
							<tr>
							<xsl:apply-templates/>
							</tr>
						</xsl:when>
						<xsl:otherwise>
							<xsl:apply-templates/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</table>
		</xsl:when>
		<xsl:otherwise>
			<P><I>No hotspots are defined</I></P>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
<xsl:template match="WINDOW" >
	<H2><a name="window">Window</a></H2>

	<xsl:variable name="cmd_count"><xsl:value-of select="count(COMMAND[@name!='SetNumeric' and @name!='SetString'])"/></xsl:variable>
	<xsl:variable name="prop_count"><xsl:value-of select="count(COMMAND[@name='SetNumeric' or @name='SetString'])"/></xsl:variable>

	<xsl:if test="$cmd_count > 0">
		<!-- process all commands *except* strings and numerics -->
		<table border="3" cellpadding="3">
			<tr>
				<th rowspan="2">Command</th>
				<th colspan="2">Position</th>
				<th colspan="2">Size</th>
			</tr>
			<tr>
				<th>Left</th>
				<th>Top</th>
				<th>Width</th>
				<th>Height</th>
			</tr>
			<xsl:apply-templates select="COMMAND[@name!='SetNumeric' and @name!='SetString']"/>
		</table>
	</xsl:if>

	<xsl:if test="$prop_count > 0">
		<!-- process *only* the string and numeric settings -->
		<p/>
		<table border="3" cellpadding="3">
			<th>Window Property</th>
			<th>Value</th>
			<xsl:apply-templates select="COMMAND[@name='SetNumeric' or @name='SetString']">
				<xsl:sort data-type="text" select="INT"/>
			</xsl:apply-templates>
		</table>
	</xsl:if>
</xsl:template>

<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
<xsl:template match="COPYPASTE" >
	<H2><a name="copypaste">Copy/Paste</a></H2>
	<xsl:variable name = "count">
		<xsl:value-of select="COUNT"/>
	</xsl:variable>

	<xsl:choose>
		<xsl:when test="$count > 0">
			<!-- The copy/paste section ONLY contains numeric and string properties -->
			<table border="3" cellpadding="3">
				<th>Property</th>
				<th>Value</th>
				<xsl:apply-templates select="COMMAND[@name='SetNumeric' or @name='SetString']">
					<xsl:sort data-type="text" select="INT"/>
				</xsl:apply-templates>
			</table>
		</xsl:when>
		<xsl:otherwise>
			<P><I>All copy/paste settings are at default values.</I></P>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
<xsl:template match="MENUS" >
	<H2><a name="menus">Menus</a></H2>
	<xsl:variable name = "count">
		<xsl:value-of select="COUNT"/>
	</xsl:variable>

	<xsl:choose>
		<xsl:when test="$count > 0">
			<table border="3" cellpadding="3">
				<th>Menu Property</th>
				<th>Value</th>
				<xsl:apply-templates select="COMMAND"/>
			</table>
		</xsl:when>
		<xsl:otherwise>
			<P><I>All menu settings are at default values</I></P>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
<xsl:template match="CONNECTION" >
	<H2><a name="connection">Connection</a></H2>

	<xsl:variable name="cmd_count"><xsl:value-of select="count(COMMAND[@name!='SetNumeric' and @name!='SetString'])"/></xsl:variable>
	<xsl:variable name="prop_count"><xsl:value-of select="count(COMMAND[@name='SetNumeric' or @name='SetString'])"/></xsl:variable>

	<xsl:if test="$cmd_count > 0">
		<!-- process all commands *except* strings and numerics -->
		<table border="3" cellpadding="3">
			<!-- xsl:for-each select="COMMAND">
				<tr>
				<td><xsl:value-of select="@name"/></td>
				<xsl:apply-templates/>
				</tr>
			</xsl:for-each -->
			<th>Command</th>
			<th>Server</th>
			<th>Service</th>
			<th>LU</th>
			<!-- process all commands *except* strings and numerics -->
			<xsl:apply-templates select="COMMAND[@name!='SetNumeric' and @name!='SetString']"/>
		</table>
	</xsl:if>

	<xsl:if test="$prop_count > 0">
		<!-- process *only* the string and numeric settings -->
		<p/>
		<table border="3" cellpadding="3">
			<th>Connection Property</th>
			<th>Value</th>
			<xsl:apply-templates select="COMMAND[@name='SetNumeric' or @name='SetString']">
				<xsl:sort data-type="text" select="INT"/>
			</xsl:apply-templates>
		</table>
	</xsl:if>
</xsl:template>

<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
<!-- All RIBM settings are always <COMMAND> elements. 
	 If the command is not SetString/SetNumeric we need to show the name. -->
<xsl:template match="COMMAND">
	<tr>
		<td><xsl:value-of select="@name"/></td>
		<xsl:apply-templates/>
	</tr>
</xsl:template>

<xsl:template match="COMMAND[@name='SetColorRGB']">
	<tr>
		<td><xsl:value-of select="@name"/></td>
		<xsl:apply-templates/>
		<xsl:variable name="redIndex">
			<xsl:value-of select="INT[2]"/>
		</xsl:variable>
		<xsl:variable name="greenIndex">
			<xsl:value-of select="INT[3]"/>
		</xsl:variable>
		<xsl:variable name="blueIndex">
			<xsl:value-of select="INT[4]"/>
		</xsl:variable>
		<td style="background-color:rgb({$redIndex},{$greenIndex},{$blueIndex})">
			abcABC 
		</td>		
	</tr>
</xsl:template>

<!-- There are many SetString/SetNumeric commands, so be brief. -->
<xsl:template match="COMMAND[@name='SetNumeric' or @name='SetString']">
	<tr>
		<xsl:apply-templates/>
	</tr>
</xsl:template>

<xsl:template match="INT">
	<td><xsl:value-of select="."/></td>
</xsl:template>

<xsl:template match="BOOL">
	<td><xsl:value-of select="."/></td>
</xsl:template>

<xsl:template match="STRING">
	<xsl:choose>
		<xsl:when test = ". = ''">
			<td><font color="blue"><small>(empty string)</small></font></td>
		</xsl:when>
		<xsl:when test = ". = ' '">
			<td><font color="blue"><small>(1 blank)</small></font></td>
		</xsl:when>
		<xsl:when test = ". = '  '">
			<td><font color="blue"><small>(2 blanks)</small></font></td>
		</xsl:when>
		<xsl:otherwise>
			<td><xsl:value-of select="."/></td>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="text()|@*"/>

</xsl:stylesheet>

