<?xml version="1.0"?>
<xsl:stylesheet	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="xml" encoding = "UTF-8" standalone = "yes" indent = "no"/>



<!--  filter.xsl  Filter exported Reflection XML Settings -->

<!-- usage: include the paramater settings=sectionName+SectionName+...

	        for example:   settings=PROPERTIES+CONNECTION+KEYMAP 	-->




<xsl:param name = "settings"/>


<xsl:variable name = "transformVersion" select = "1.0"/>


<xsl:variable name = "elements"> 
	<xsl:choose>
		<xsl:when test = "string($settings)">
			<xsl:value-of select = "concat('CREATOR+TYPE+', 
									translate($settings, 
											  'abcdefghijklmnopqrstuvwxyz',
											  'ABCDEFGHIJKLMNOPQRSTUVWXYZ'))"/>
		</xsl:when>
		<xsl:otherwise>all</xsl:otherwise>
	</xsl:choose>
</xsl:variable>



<xsl:template match="/">
	<xsl:call-template name = "FilteredComment"/>
	<xsl:apply-templates mode = "copychildren"/>
</xsl:template>


<xsl:template match="REFLECTION_SETTINGS" mode = "copychildren">
	<xsl:call-template name = "lineBreak"/>
	<xsl:copy>
		<xsl:copy-of select="@*"/>
		<xsl:apply-templates select = "child::node()"/>
	</xsl:copy>
</xsl:template>


<xsl:template match = "/REFLECTION_SETTINGS/TYPE">
	<!-- change TYPE/@mode to 'Filtered'  -->
	<xsl:element name = "TYPE">
		<xsl:attribute name = "mode">Filtered</xsl:attribute>
		<xsl:value-of select = "/REFLECTION_SETTINGS/TYPE"/>
	</xsl:element>
</xsl:template>


<xsl:template match = "node()">
	<xsl:if test = "($elements = 'all') or contains($elements, local-name())">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:apply-templates select = "node()" mode="copy"/>
		</xsl:copy>
		<xsl:call-template name = "lineBreak"/>
	</xsl:if>
</xsl:template>


<xsl:template match = "node()" mode = "copy">
	<xsl:copy>
		<xsl:copy-of select="@*"/>
		<xsl:apply-templates select = "node()" mode="copy"/>
	</xsl:copy>
</xsl:template>


<xsl:template name = "FilteredComment" >
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>

	<xsl:comment>
		<xsl:text>     Reflection (</xsl:text>
		<xsl:value-of select = "/REFLECTION_SETTINGS/TYPE/@mode"/>
		<xsl:text>) </xsl:text>
		<xsl:value-of select="/REFLECTION_SETTINGS/TYPE"/>
		<xsl:call-template name = "lineBreak"/>
		<xsl:text>	 Filtered by Filter Transform version </xsl:text> 
		<xsl:value-of select="$transformVersion"/>
		<xsl:text>   </xsl:text>
	</xsl:comment>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>


<xsl:template name = "lineBreak">
	<xsl:text>&#10;</xsl:text>
</xsl:template>


<xsl:template match="text()|@*"/>


</xsl:stylesheet>

