<?xml version="1.0"?>
<xsl:stylesheet	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="xml" indent="yes"/>


<!--  html.xsl  Display All Reflection Settings -->







<xsl:template match="/">
	<xsl:variable name = "exportMode">
		<xsl:value-of select = "/REFLECTION_SETTINGS/TYPE/@mode"/>
	</xsl:variable>

	<xsl:variable name = "XMLversion">
		<xsl:value-of select = "/REFLECTION_SETTINGS/@version"/>
	</xsl:variable>

	<HTML>
	<HEAD>
 		<TITLE>
			<xsl:text>Reflection </xsl:text>
			<xsl:if test = "($exportMode = 'Changed') or ($exportMode = 'Filtered')">
				<xsl:value-of select = "$exportMode"/>
				<xsl:text> </xsl:text>
			</xsl:if>
			<xsl:text>Settings</xsl:text>
		</TITLE>
	</HEAD>
	<BODY>
		<xsl:if test = "$XMLversion &gt; '1'">
		<P><H2>
			<xsl:text>Reflection </xsl:text>
			<xsl:if test = "($exportMode = 'Changed') or ($exportMode = 'Filtered')">
				<xsl:value-of select = "$exportMode"/>
				<xsl:text> </xsl:text>
			</xsl:if>
			<xsl:text>Settings</xsl:text>
		</H2></P>
		<xsl:call-template name = "creator"/>
		<P>
		<xsl:if test = "$exportMode = 'All' and /REFLECTION_SETTINGS/TYPE = 'SETTINGS'">
			<H3 align="center"><font face="Arial">Contents</font></H3>
			<center>
			<table border="0" cellpadding="2" cellspacing="0" width="90%">
				<tr>
					<td width="18%" align="left"><font face="Arial"><a href="#properties"><b>  Properties  </b></a></font></td>
					<td width="24%" align="left"><font face="Arial"><a href="#connection"><b>  Connection  </b></a></font></td>
					<td width="18%" align="left"><font face="Arial"><a href="#keymap"><b>  Keymap	</b></a></font></td>
					<td width="20%" align="left"><font face="Arial"><a href="#mousemap"><b>  Mousemap  </b></a></font></td>
					<td width="20%" align="left"><font face="Arial"><a href="#menus"><b>   Menus  </b></a></font></td>
				</tr>
				<tr>
					<td width="18%" align="left"><font face="Arial"><a href="#toolbars"><b>  Toolbars  </b></a></font></td>
					<td width="24%" align="left"><font face="Arial"><a href="#fkeys"><b>  Function Keys   </b></a></font></td>
					<td width="18%" align="left"><font face="Arial"><a href="#tabs"><b>   Tabstops  </b></a></font></td>
					<td width="20%" align="left"><font face="Arial"><a href="#window"><b>  Window  </b></a></font></td>
					<td width="20%" align="left"><font face="Arial"><a href="#disabled"><b>  Disabled  </b></a></font></td>
				</tr>
				<tr>
					<td width="18%" align="left"><font face="Arial"><a href="#profiled"><b>  Profiled  </b></a></font></td>
					<td width="24%" align="left"><font face="Arial"><a href="#policies"><b> Group Policies  </b></a></font></td>
					<td width="18%" align="left"><font face="Arial"><a href="#events"><b>  Events  </b></a></font></td>
					<td width="20%" align="left"><font face="Arial"><a href="#hotspots"><b>  Hotspots  </b></a></font></td>
					<td width="20%" align="left"><font face="Arial"><a href="#colors"><b>  Colors  </b></a></font></td>
				</tr>
				<tr>
					<xsl:if test = "count(/REFLECTION_SETTINGS/SCREEN/TEXT) &gt; 0">
						<td width="18%" align="left"><font face="Arial"><a href="#screen"><b>  Screen  </b></a></font></td>
					</xsl:if>

				</tr>
			</table>
			</center>
			<BR/>
		</xsl:if>
		</P>

		<xsl:apply-templates/>
		</xsl:if>
		<xsl:if test = "$XMLversion &lt; '2'">
			<P><H2>Old XML Settings format found</H2></P>
			<BR>This transform requires 2.0 or greater exported Reflection Settings.</BR>
			As exported by Reflection version 10.0 or later.
		</xsl:if>
	</BODY>
	</HTML>
</xsl:template>



<xsl:template name = "creator">
	<xsl:value-of select="/REFLECTION_SETTINGS/CREATOR/@product"/> 
	<xsl:text> version </xsl:text> 
	<xsl:value-of select="/REFLECTION_SETTINGS/CREATOR/@version"/> 
	<xsl:text> build </xsl:text>
	<xsl:value-of select="/REFLECTION_SETTINGS/CREATOR/@build"/>
 	<BR/> 
	<xsl:text>XML settings format </xsl:text>
	<xsl:value-of select = "/REFLECTION_SETTINGS/@version"/>
	<xsl:text>   (</xsl:text>
	<xsl:value-of select = "/REFLECTION_SETTINGS/TYPE/@mode"/>
	<xsl:text> </xsl:text>
	<xsl:value-of select="/REFLECTION_SETTINGS/TYPE"/>
	<xsl:text>)</xsl:text>
 	<BR/> 
</xsl:template>



<xsl:template match="PROPERTIES" >
	<xsl:variable name = "count">
		<xsl:choose>
			<xsl:when test = "not(COUNT)">0</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="COUNT"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:if test = "(/REFLECTION_SETTINGS/TYPE/@mode = 'All' and /REFLECTION_SETTINGS/TYPE = 'SETTINGS')
					or ($count > 0)">
		<H2><a name="properties">Reflection Properties</a></H2>
	</xsl:if>

	<xsl:choose>
		<xsl:when test="$count > 0">
			<P/>
			<table border="3" cellpadding="3">
				<thead>
					<xsl:choose>
						<xsl:when test = "/REFLECTION_SETTINGS/TYPE[@mode = 'Changed']">
							<tr><xsl:value-of select="COUNT"/> Changed Properties</tr>
						</xsl:when>
						<xsl:otherwise>
							<tr><xsl:value-of select="COUNT"/> Properties</tr>
						</xsl:otherwise>
					</xsl:choose>
				</thead>
				<th align="center"><b>Property</b></th>
				<th align="center"><b>Value</b></th>
				<xsl:apply-templates select="PROPERTY">
					<xsl:sort select="@name"/>
				</xsl:apply-templates>
			</table>
		</xsl:when>
		<xsl:otherwise>
			<P><I>All Properties are at defaults</I></P>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="PROPERTY">
	<tr>
		<td><xsl:value-of select="@name"/></td>
	   	<xsl:call-template name="PROPERTY_TYPE"/>
	</tr>
</xsl:template>

<xsl:template name="PROPERTY_TYPE">
	<xsl:choose>
		<xsl:when test = "count(BOOLEAN) &gt; 0">
			<td><xsl:value-of select="BOOLEAN"/></td>
		</xsl:when>
		<xsl:when test = "count(INTEGER) &gt; 0">
			<td><xsl:value-of select="INTEGER"/></td>
		</xsl:when>
		<xsl:when test = "count(ENUMERATION) &gt; 0">
			<td><xsl:value-of select="ENUMERATION"/></td>
		</xsl:when>
		<xsl:when test = "count(CHARACTER) &gt; 0">
			<xsl:choose>
			   <xsl:when test = "count(CHARACTER/@ctrl) &gt; 0">
					<td><xsl:value-of select="CHARACTER/@ctrl"/></td>
			   </xsl:when>
				<xsl:when test = "CHARACTER=''">
					<td> (not set) </td>
				</xsl:when>
				<xsl:otherwise>
					<td><xsl:value-of select="CHARACTER"/></td>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:when test = "count(STRING) &gt; 0">
			<xsl:choose>
				<xsl:when test = "STRING=''">
					<td> (empty string) </td>
				</xsl:when>
				<xsl:otherwise>
					<td><xsl:value-of select="STRING"/></td>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>

		<xsl:when test = "count(FOLDER) &gt; 0">
			<xsl:choose>
				<xsl:when test = "FOLDER=''">
					<td> (empty folder name) </td>
				</xsl:when>
				<xsl:otherwise>
					<td><xsl:value-of select="FOLDER"/></td>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:when test = "count(FILE) &gt; 0">
			<xsl:choose>
				<xsl:when test = "FILE=''">
					<td> (empty filename) </td>
				</xsl:when>
				<xsl:otherwise>
					<td><xsl:value-of select="FILE"/></td>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>

		<xsl:otherwise>
			<td>unknown type</td>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>



<xsl:template match="CONNECTION" >
	<xsl:variable name = "count">
		<xsl:choose>
			<xsl:when test = "not(COUNT)">0</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="count(CONNECTION_SETTING)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:if test = "(/REFLECTION_SETTINGS/TYPE/@mode = 'All' and /REFLECTION_SETTINGS/TYPE = 'SETTINGS')
					or ($count > 0)">
		<H2><a name="connection">Connection Settings</a></H2>
	</xsl:if>

	<xsl:choose>
		<xsl:when test="$count > 0">
			<P/>
			<table border="3" cellpadding="3">
				<thead>
					<tr>
						<xsl:value-of select="$count"/> 
						<xsl:if test = "/REFLECTION_SETTINGS/TYPE[@mode = 'Changed']">
							<xsl:text> Changed</xsl:text>
						</xsl:if>
						<xsl:text> Connection Setting</xsl:text>
						<xsl:if test="$count > 1">
							<xsl:text>s</xsl:text>
						</xsl:if>
					</tr>
				</thead>
				<th align="center"><b>Setting</b></th>
				<th align="center"><b>Value</b></th>
				<xsl:apply-templates select="CONNECTION_SETTING">
					<xsl:sort select="@name"/>
				</xsl:apply-templates>
			</table>
		</xsl:when>
		<xsl:otherwise>
			<P><I>All Connection Settings are at defaults</I></P>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="CONNECTION_SETTING">
	<tr>
		<td><xsl:value-of select="@name"/></td>
		<xsl:call-template name="PROPERTY_TYPE"/>
	</tr>
</xsl:template>



<xsl:template match="KEYMAP" >
	<xsl:variable name = "count">
		<xsl:choose>
			<xsl:when test = "not(COUNT)">0</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="COUNT"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:if test = "(/REFLECTION_SETTINGS/TYPE/@mode = 'All' and /REFLECTION_SETTINGS/TYPE = 'SETTINGS')
					or ($count > 0)">
		<H2><a name="keymap">Keymap</a></H2>
	</xsl:if>

	<xsl:choose>
		<xsl:when test="$count = 0">
	   		<P/><I>Default Key Map</I>
			<P/>
		</xsl:when>
		<xsl:otherwise>
		   	<P/>
			<table border="3" cellpadding="3">
				<thead>
					<tr><xsl:value-of select="COUNT"/> Mapped Keys</tr>
				</thead>
				<th align="center"><b>Keystroke</b></th>
				<th align="center"><b>Mapping</b></th>
					<xsl:apply-templates select="KEY_MAPPING"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="KEY_MAPPING">
	<xsl:variable name = "keystroke">
		<xsl:choose>
			<xsl:when test="string-length(KEYSTROKE) &gt; 0">
				<xsl:value-of select="KEYSTROKE"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="VKEY"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = "mapping">
		<xsl:choose>					   
			<xsl:when test="count(LOC_MAPPING) &gt; 0">
				<xsl:value-of select="LOC_MAPPING"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="MAPPING"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<tr>
		<td><xsl:value-of select="$keystroke"/></td>
		<td><xsl:value-of select="$mapping"/></td>
	</tr>
</xsl:template>


<xsl:template match="MOUSEMAP" >
	<xsl:variable name = "count">
		<xsl:choose>
			<xsl:when test = "not(COUNT)">0</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="COUNT"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:if test = "(/REFLECTION_SETTINGS/TYPE/@mode = 'All' and /REFLECTION_SETTINGS/TYPE = 'SETTINGS')
					or ($count > 0)">
		<H2><a name="mousemap">Mousemap</a></H2>
	</xsl:if>

	<xsl:choose>
		<xsl:when test="$count = 0">
	   		<P/><I>Default Mouse Map</I>
			<P/>
		</xsl:when>
		<xsl:otherwise>
			<P/>
			<table border="3" cellpadding="3">
				<thead>
					<tr><xsl:value-of select="$count"/> Mouse Mappings</tr>
				</thead>
				<th align="center"><b>Keystroke</b></th>
				<th align="center"><b>Mapping</b></th>
					<xsl:apply-templates select="MOUSE_MAPPING"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="MOUSE_MAPPING">
	<xsl:variable name = "mapping">
		<xsl:choose>
			<xsl:when test="count(LOC_MAPPING) &gt; 0">
				<xsl:value-of select="LOC_MAPPING"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="MAPPING"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<tr>
		<td><xsl:value-of select="MOUSECHORD"/></td>
		<td><xsl:value-of select="$mapping"/></td>
	</tr>
</xsl:template>


<xsl:template match="EVENTS[COUNT]">
	<xsl:variable name = "eventCount">
		<xsl:choose>
			<xsl:when test = "not(COUNT)">0</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="COUNT"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:if test = "(/REFLECTION_SETTINGS/TYPE/@mode = 'All' and /REFLECTION_SETTINGS/TYPE = 'SETTINGS')
					or ($eventCount > 0)">
		<H2><a name="events">Events</a></H2>
	</xsl:if>

	<P/>
	<table border="3" cellpadding="3">
		<thead>
			<xsl:if test="$eventCount = 1">
				<tr><xsl:value-of select="COUNT"/> Event</tr>
			</xsl:if>
			<xsl:if test="$eventCount > 1">
				<tr><xsl:value-of select="COUNT"/> Events</tr>
		  	</xsl:if>
		</thead>

		<th align="center"><b>Event</b></th>
		<th align="center"><b>Type</b></th>
		<th align="center"><b>Default</b></th>
		<th align="center"><b>Enabled</b></th>
		<th align="center"><b>Action</b></th>
			<xsl:apply-templates select="EVENT"/>
	</table>
</xsl:template>


<xsl:template match="EVENT">
	<xsl:variable name = "mapping">
		<xsl:choose>
			<xsl:when test="count(LOC_ACTION) &gt; 0">
				<xsl:value-of select="LOC_ACTION"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="ACTION"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<tr>
		<td><xsl:value-of select="EVENT_TYPE"/></td>
		<td><xsl:value-of select="COMMAND_TYPE"/></td>
		<td align="center"><xsl:value-of select="DEFAULT_EVENT"/></td>
		<td align="center"><xsl:value-of select="EVENT_ENABLED"/></td>
		<td><xsl:value-of select="$mapping"/></td>
	</tr>
</xsl:template>

<!--
<xsl:template match="EVENT">
	<xsl:variable name = "mapping">
		<xsl:choose>
			<xsl:when test="count(LOC_ACTION) &gt; 0">
				<xsl:value-of select="LOC_ACTION"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="ACTION"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:choose>
		<xsl:when test="DEFAULT_EVENT='No'">
			<xsl:choose>
				<xsl:when test="EVENT_ENABLED='Yes'">
					<tr>
						<td><xsl:value-of select="EVENT_TYPE"/></td>
						<td><xsl:value-of select="COMMAND_TYPE"/></td>
						<td><xsl:value-of select="$mapping"/></td>
					</tr>
				</xsl:when> 
			</xsl:choose>
	  	</xsl:when>
	</xsl:choose>
</xsl:template>
-->


<xsl:template match="HOTSPOTS">
	<xsl:variable name = "count">
		<xsl:choose>
			<xsl:when test = "not(COUNT)">0</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="COUNT"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:if test = "(/REFLECTION_SETTINGS/TYPE/@mode = 'All' and /REFLECTION_SETTINGS/TYPE = 'SETTINGS')
					or ($count > 0)">
		<H2><a name="hotspots">Hotspots</a></H2>
	</xsl:if>


	<xsl:choose>
		<xsl:when test="$count = 0">
	   		<P/><I>Default Hotspots</I>
			<P/>
		</xsl:when>
		<xsl:otherwise>
			<P/>
			<table border="3" cellpadding="3">
				<thead>
					<xsl:call-template name="HOTSPOTCOUNT"/>
				</thead>
				<th align="center"><b>Hotspots Enabled</b></th>
				<th align="center"><b>Hotspots Visible</b></th>
				<th align="center"><b>Mousechord</b></th>
				<xsl:apply-templates select="HOTSPOT_SETTINGS"/>
			</table>

			<table border="3" cellpadding="3">
				<th align="center"><b>Text</b></th>
				<th align="center"><b>Type</b></th>
				<th align="center"><b>Action</b></th>
				<th align="center"><b>Match</b></th>
				<th align="center"><b>Row</b></th>
				<th align="center"><b>Column</b></th>
				<xsl:apply-templates select="HOTSPOT"/>
			</table>
		</xsl:otherwise>
 	</xsl:choose>
</xsl:template>

<xsl:template name="HOTSPOTCOUNT">
	<xsl:variable name = "spotCount">
		<xsl:value-of select="COUNT"/>
	</xsl:variable>
 	<xsl:if test="$spotCount = 1">
		<tr><xsl:value-of select="COUNT"/> Hotspot</tr>
	</xsl:if>
	<xsl:if test="$spotCount > 1">
		<tr><xsl:value-of select="COUNT"/> Hotspots</tr>
  	</xsl:if>

</xsl:template>

<xsl:template match="HOTSPOT_SETTINGS">
	<tr>
		<td align="center"><xsl:value-of select="HOTSPOTS_ENABLED"/></td>
	    <td align="center"><xsl:value-of select="HOTSPOTS_VISIBLE"/></td>
		<td align="center"><xsl:value-of select="MOUSECHORD"/></td>
	</tr>
</xsl:template>

<xsl:template match="HOTSPOT">
	<xsl:variable name = "mapping">
		<xsl:choose>
			<xsl:when test="count(LOC_ACTION) &gt; 0">
				<xsl:value-of select="LOC_ACTION"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="ACTION"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<tr>
		<td><xsl:value-of select="HOTSPOT_TEXT"/></td>
		<td><xsl:value-of select="COMMAND_TYPE"/></td>
		<td><xsl:value-of select="$mapping"/></td>
		<td>
			<xsl:if test="self::node()[MATCH_CASE='Yes']">
				<nobr>Case</nobr>

				<xsl:choose>
					<xsl:when test="MATCH_WHOLE_WORD='Yes'">
						<nobr>,</nobr>
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="MATCH_TIL_WHITESPACE='Yes'">
							<nobr>,</nobr>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>

			</xsl:if>

			<xsl:if test="self::node()[MATCH_WHOLE_WORD='Yes']">
				<nobr>Word</nobr>

				<xsl:if test="MATCH_TIL_WHITESPACE='Yes'">
					<nobr>,</nobr>
				</xsl:if>

			</xsl:if>

			<xsl:if test="self::node()[MATCH_TIL_WHITESPACE='Yes']">
				<nobr>Until whitespace</nobr>
			</xsl:if>
		</td>
		
		<xsl:if test="self::node()[ANY_ROW]">
			<td align="center">Any</td>
		</xsl:if>
		<xsl:if test="self::node()[ROW]">
			<td align="center"><xsl:value-of select="ROW"/></td>
		</xsl:if>
		
		
		<xsl:if test="self::node()[ANY_COLUMN]">
			<td align="center">Any</td>
		</xsl:if>
		<xsl:if test="self::node()[COLUMN]">
			<td align="center"><xsl:value-of select="COLUMN"/></td>
		</xsl:if>
	</tr>
</xsl:template>


<xsl:template match="MENUS/MAIN_MENU">
	<H2><a name="menus">Menus</a></H2>
	<P/>
	<I><xsl:text>Main Menu</xsl:text></I><BR/>
	<xsl:apply-templates select="POPUP|ITEM|SEPARATOR"/>
</xsl:template>

<xsl:template match="MENUS/CONTEXT_MENU">
	<P><BR/></P>
	<P><I><xsl:text>Context Menu</xsl:text></I></P>
	<xsl:apply-templates select="POPUP|ITEM|SEPARATOR"/>
</xsl:template>

<xsl:template match="POPUP">
	<DL>
		<DT><B><xsl:value-of select="@name"/></B></DT>
		<DD>
		 	<xsl:apply-templates select="POPUP|ITEM|SEPARATOR"/>
		</DD>
	</DL>
</xsl:template>


<xsl:template match="ITEM">
		<xsl:value-of select="@menu_item"/><BR/>
</xsl:template>

<xsl:template match="SEPARATOR">
		--------------<BR/>
</xsl:template>


<xsl:template match="TABS">
	<xsl:variable name = "count">
		<xsl:choose>
			<xsl:when test = "count(DEFAULTS) = 1">0</xsl:when>
			<xsl:otherwise>1</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:choose>
		<xsl:when test = "$count &gt; 0">
			<H2><a name="tabs">Tabstops</a></H2>
			<xsl:apply-templates select="TABSTOPS"/>
			<xsl:apply-templates select="HP_VTMODE_TABSTOPS"/>
			<xsl:apply-templates select="HP_HPMODE_TABSTOPS"/>
		</xsl:when>
		<xsl:otherwise>
	   		<P/><I>Default Tabstops</I>
			<P/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="TABSTOPS" >
	<DL>
	<DT><I>Tab Stops</I></DT>
  	<xsl:choose>
		<xsl:when test="count(TAB|TABSTOP_LIST|TABS_EVERY_N) = 0">
		   	<DD>No tabs set</DD>
		</xsl:when>
		<xsl:otherwise>
			<xsl:apply-templates select="TAB|TABSTOP_LIST|TABS_EVERY_N"/>
		</xsl:otherwise>
	</xsl:choose>
	</DL>
</xsl:template>

<xsl:template match="HP_VTMODE_TABSTOPS" >
	<DL>
	<DT><I>VT Mode Tab Stops</I></DT>
	<xsl:choose>
		<xsl:when test="count(TAB|TABSTOP_LIST|TABS_EVERY_N) = 0">
		   	<DD>No tabs set</DD>
		</xsl:when>
		<xsl:otherwise>
			<xsl:apply-templates select="TAB|TABSTOP_LIST|TABS_EVERY_N"/>
		</xsl:otherwise>
	</xsl:choose>
	</DL>
</xsl:template>

<xsl:template match="HP_HPMODE_TABSTOPS" >
	<DL>
	<DT><I>HP Mode Tab Stops</I></DT>
	 <xsl:choose>
		<xsl:when test="count(TAB|TABSTOP_LIST|TABS_EVERY_N) = 0">
		   	<DD>No tabs set</DD>
		</xsl:when>
		<xsl:otherwise>
			<xsl:apply-templates select="TAB|TABSTOP_LIST|TABS_EVERY_N"/>
		</xsl:otherwise>
	</xsl:choose>
	</DL>
</xsl:template>

<xsl:template match="TAB">
	<DD>Tab stop in column <xsl:value-of select="."/></DD>
</xsl:template>

<xsl:template match="TABSTOP_LIST">
	<DD>Tab stops in columns <xsl:value-of select="."/></DD>
</xsl:template>

<xsl:template match="TABS_EVERY_N">
	<DD>Tabs every <xsl:value-of select="."/> columns</DD>
</xsl:template>


<xsl:template match="COLORS">
	<xsl:if test = "(/REFLECTION_SETTINGS/TYPE/@mode = 'All' and /REFLECTION_SETTINGS/TYPE = 'SETTINGS')
					or (count(COLOR_PALETTE) > 0)">
		<H2><a name="colors">Colors</a></H2>
	</xsl:if>

	<xsl:choose>
		<xsl:when test="count(COLOR_PALETTE) = 0">
	   		<P/><I>Default Colors</I>
			<P/>
		</xsl:when>
		<xsl:otherwise>
			<P/><I>Colors</I>
			<xsl:apply-templates select="COLOR_PALETTE"/>
			<P/>
			<xsl:apply-templates select="COLOR_ATTRIBUTES"/>
			<xsl:apply-templates select="COLOR_OPTIONS"/>
		</xsl:otherwise>
	 </xsl:choose>
</xsl:template>

<xsl:template match="COLOR_ATTRIBUTES">
<table border="3" cellpadding="3">
	<thead>
		<tr>Color Attributes</tr>
	</thead>
	<tr>
		<th rowspan="2" align="center">Attribute</th>
		<th colspan="2" align="center">Foreground</th>
		<th colspan="2" align="center">Background</th>
	</tr>
	<tr>
		<th align="center">Index</th>
		<th align="center">Color</th>
		<th align="center">Index</th>
		<th align="center">Color</th>
	</tr>
	<xsl:apply-templates select="COLOR_ATTRIBUTE"/>
</table>
</xsl:template>


<xsl:template match="COLOR_PALETTE">
<table border="3" cellpadding="3">
	<thead>
		<tr>Color Palette</tr>
	</thead>
	<th align="center"><b>Index</b></th>
	<th align="center"><b>Color</b></th>
	<th align="center"><b>Color Name</b></th>
	<xsl:apply-templates select="COLOR"/>
</table>
</xsl:template>

<xsl:template match="COLOR">
	<tr>
		<td align="center"><xsl:value-of select="@index"/></td>
	    <td align="center"><xsl:value-of select="."/></td>
		<xsl:call-template name="COLOR_NAME"/>
	</tr>
</xsl:template>


<xsl:template name="COLOR_NAME">
	<xsl:variable name = "colors" select = "$colorNames"/>
	<xsl:variable name = "colorname" select = "$colors/COLOR[@value = current()]/@name"/>
	<td align="center"><xsl:value-of select = "$colorname"/></td>
</xsl:template>


<xsl:template match="BACKGROUND/COLOR">
	<xsl:call-template name="COLOR_NAME"/>
</xsl:template>

<xsl:template match="FOREGROUND/COLOR">
	<xsl:call-template name="COLOR_NAME"/>
</xsl:template>

<xsl:template match="COLOR_ATTRIBUTE">
	<xsl:variable name = "colors" select = "$colorNames"/>

	<tr>
		<td><xsl:value-of select="@name"/></td>

		<xsl:choose>
			<xsl:when test = "count(FOREGROUND/COLOR/@index)=0">
				<td align="center"><xsl:text>.</xsl:text></td>
			</xsl:when>
			<xsl:otherwise>
				 <td align="center"><xsl:value-of select="FOREGROUND/COLOR/@index"/></td>
			</xsl:otherwise>
		</xsl:choose>

		<xsl:variable name = "fgcolor" select = "$colors/COLOR[@value = current()/FOREGROUND/COLOR]/@name"/>
		<xsl:choose>
		<xsl:when test = "$fgcolor">
			<td align="center"><xsl:value-of select="$fgcolor"/></td>
		</xsl:when>
		<xsl:otherwise>
			<td align="center"><xsl:value-of select="FOREGROUND/COLOR"/></td>
		</xsl:otherwise>
		</xsl:choose>

		<xsl:choose>
			<xsl:when test = "count(BACKGROUND/COLOR/@index)=0">
				<td align="center"><xsl:text>.</xsl:text></td>
			</xsl:when>
			<xsl:otherwise>
				 <td align="center"><xsl:value-of select="BACKGROUND/COLOR/@index"/></td>
			</xsl:otherwise>
		</xsl:choose>

		<xsl:variable name = "bgcolor" select = "$colors/COLOR[@value = current()/BACKGROUND/COLOR]/@name"/>
		<xsl:choose>
		<xsl:when test = "$bgcolor">
			<td align="center"><xsl:value-of select="$bgcolor"/></td>
		</xsl:when>
		<xsl:otherwise>
			<td align="center"><xsl:value-of select="BACKGROUND/COLOR"/></td>
		</xsl:otherwise>
		</xsl:choose>
	</tr>
</xsl:template>


<xsl:template match="COLOR_OPTIONS">
<P/>
<table border="3" cellpadding="3">
	<thead>
		<tr>Color Options</tr>
	</thead>
	<tr>
	    <td align="center">OPTION</td>
		<td align="center">VALUE</td>
	</tr>
 	<xsl:apply-templates select="COLOR_OPTION"/>
</table>
</xsl:template>


<xsl:template match="COLOR_OPTION">
	<tr>
	    <td><xsl:value-of select="@name"/></td>
		<td align="center"><xsl:value-of select="BOOLEAN"/></td>
	</tr>
</xsl:template>


<xsl:template match="WINDOW">
	<xsl:variable name = "count">
		<xsl:choose>
			<xsl:when test = "count(WINDOW_STATE) = 0">0</xsl:when>
			<xsl:otherwise>1</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:if test = "(/REFLECTION_SETTINGS/TYPE/@mode = 'All' and /REFLECTION_SETTINGS/TYPE = 'SETTINGS')
					or ($count > 0)">
		<H2><a name="window">Terminal Window</a></H2>
	</xsl:if>

	<xsl:choose>
		<xsl:when test="count(WINDOW_STATE) = 0">
	   		<P/><I>Default Window Size and Position</I>
			<P/>
		</xsl:when>
		<xsl:otherwise>
			<table border="3" cellpadding="3">
				<thead>
					<tr><I>Window</I></tr>
				</thead>
				<th align="center"><b>State</b></th>
				<th align="center"><b>Position</b></th>
				<th align="center"><b>Size</b></th>
				<xsl:apply-templates select="WINDOW_STATE"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="WINDOW_STATE">
	<tr>
	    <td><xsl:value-of select="."/></td>
		<td align="center">
			(<xsl:value-of select="../WP_LEFT_X"/>,
			<xsl:value-of select="../WP_LEFT_Y"/>)
			 x 
			(<xsl:value-of select="../WP_RIGHT_X"/>,
			<xsl:value-of select="../WP_RIGHT_Y"/>)
		</td>
		<td align="center">
		<xsl:value-of select="../WP_RIGHT_X - ../WP_LEFT_X"/>
		 x 
		<xsl:value-of select="../WP_RIGHT_Y - ../WP_LEFT_Y"/>
		</td>
	</tr>
</xsl:template>


<xsl:template match="TOOLBARS">
	<xsl:variable name = "count">
		<xsl:choose>
			<xsl:when test = "not(COUNT)">0</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="COUNT"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:if test = "(/REFLECTION_SETTINGS/TYPE/@mode = 'All' and /REFLECTION_SETTINGS/TYPE = 'SETTINGS')
					or ($count > 0)">
		<H2><a name="toolbars">Toolbars</a></H2>
	</xsl:if>

	<xsl:choose>
		<xsl:when test="$count = 0">
	   		<P/><I>Default toolbars</I>
			<P/>
		</xsl:when>
		<xsl:otherwise>
			<P><BR/><I> Toolbars (<xsl:value-of select="$count"/>)</I></P>
			<table border="3" cellpadding="3">
				<tr>
					<th align="center"><b>Toolbar</b></th>
					<th align="center"><b>Location</b></th>
					<th align="center"><b>Visible</b></th>
					<th align="center"><b>Anchored</b></th>
					<th align="center"><b>Color</b></th>
					<th align="center">Lg Buttons<b></b></th>
					<th align="center"><b>Tooltips</b></th>
					<th align="center"><b>Labels</b></th>
				</tr>
				<xsl:for-each select="TOOLBAR">
				  	<xsl:call-template name="TOOLBAR_SUMMARY"/>
				</xsl:for-each>
			</table>

			<xsl:for-each select="TOOLBAR">
				<xsl:call-template name="TOOLBAR_BUTTONS"/>
			</xsl:for-each>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name="TOOLBAR_SUMMARY">
	<tr>
		<td><xsl:value-of select="@name"/></td>
		<td align="center"><xsl:value-of select="LOCATION"/></td>
		<td align="center"><xsl:value-of select="VISIBLE"/></td>
		<td align="center"><xsl:value-of select="ANCHORED"/></td>
		<td align="center"><xsl:value-of select="COLOR_BUTTONS"/></td>
		<td align="center"><xsl:value-of select="LARGE_BUTTONS"/></td>
		<td align="center"><xsl:value-of select="SHOW_TOOLTIPS"/></td>
		<td align="center"><xsl:value-of select="SHOW_LABELS"/></td>
	</tr>
</xsl:template>


<xsl:template name="TOOLBAR_BUTTONS">
	<xsl:variable name = "labels" select= "count(BUTTONS/BUTTON/BUTTON_LABEL) &gt; 0"/>

	<P/>
	<xsl:value-of select="@name"/><xsl:text> Toolbar</xsl:text>
   	<table border="3" cellpadding="3">
		<tr>
			<xsl:choose>
				<xsl:when test = "$labels &gt; 0">
					<th colspan="5" align="center"><b>Buttons</b></th>
				</xsl:when>
				<xsl:otherwise>
					<th colspan="4" align="center"><b>Buttons</b></th>
				</xsl:otherwise>
			</xsl:choose>
		</tr>
		<tr>
			<th align="center"><b>Number</b></th>
			<th align="center"><b>Command Type</b></th>
			<th align="center"><b>Action</b></th>
			<th align="center"><b>Tooltip</b></th>
			<xsl:if test = "$labels &gt; 0">
				<th align="center"><b>Label</b></th>
			</xsl:if>
		</tr>
		<xsl:for-each select="BUTTONS/BUTTON">
		  	<xsl:call-template name="TOOLBAR_BUTTON">
				<xsl:with-param name = "labels" select = "$labels"/>
			</xsl:call-template>
		</xsl:for-each>

 	</table>
</xsl:template>


<xsl:template name="TOOLBAR_BUTTON">
	<xsl:param name = "labels" select = "0"/>

	<xsl:variable name = "mapping">
		<xsl:choose>
			<xsl:when test="count(LOC_ACTION) &gt; 0">
				<xsl:value-of select="LOC_ACTION"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="ACTION"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<tr>
		<td align="center"><xsl:value-of select="@number"/></td>
		<td><xsl:value-of select="COMMAND_TYPE"/></td>
		<td><xsl:value-of select="$mapping"/></td>
		<td><xsl:value-of select="BUTTON_TOOLTIP"/></td>
		<xsl:if test = "$labels &gt; 0">
			<td><xsl:value-of select="BUTTON_LABEL"/></td>
		</xsl:if>
	</tr>
</xsl:template>

 
<xsl:template match="DISABLED" >
	<xsl:variable name = "count">
		<xsl:choose>
			<xsl:when test = "count(DEFAULTS) = 1">0</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="COUNT"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:if test = "(/REFLECTION_SETTINGS/TYPE/@mode = 'All' and /REFLECTION_SETTINGS/TYPE = 'SETTINGS')
					or ($count > 0)">
		<H2><a name="disabled">Disabled</a></H2>
	</xsl:if>

	<xsl:choose>
		<xsl:when test="$count = 0">
	   		<P/><I>Nothing Disabled</I>
		</xsl:when>
		<xsl:otherwise>
			<P/>
			<I><xsl:text>Disabled List</xsl:text></I><BR/>
			<xsl:text>Disabled Commands </xsl:text><xsl:value-of select="DISABLED_COMMANDS/COUNT"/><BR/>
			<xsl:apply-templates select="DISABLED_COMMANDS"/>
			<xsl:text>Disabled Settings </xsl:text><xsl:value-of select="DISABLED_SETTINGS/COUNT"/><BR/>
			<xsl:apply-templates select="DISABLED_SETTINGS"/>
			<xsl:text>Disabled Features </xsl:text><xsl:value-of select="DISABLED_FEATURES/COUNT"/><BR/>
			<xsl:apply-templates select="DISABLED_FEATURES"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="DISABLED_COMMANDS">
	<xsl:if test = "COUNT &gt; 0">
		<table border="3" cellpadding="3">
			<xsl:for-each select="DISABLED_COMMAND">
				<tr align="left" >
					<td align="left"><xsl:value-of select="."/></td>
				</tr>
			</xsl:for-each>
		</table>
		<P/>
	</xsl:if>
</xsl:template>

<xsl:template match="DISABLED_SETTINGS">
	<xsl:if test = "COUNT &gt; 0">
		<table border="3" cellpadding="3">
			<xsl:for-each select="DISABLED_SETTING">
				<tr  align="left" >
					<td align="left"><xsl:value-of select="."/></td>
				</tr>
			</xsl:for-each>
		</table>
		<P/>
	</xsl:if>
</xsl:template>

<xsl:template match="DISABLED_FEATURES">
	<xsl:if test = "COUNT &gt; 0">
		<table border="3" cellpadding="3">
			<xsl:for-each select="DISABLED_FEATURE">
				<tr align="left" >
					<td align="left"><xsl:value-of select="."/></td>
				</tr>
			</xsl:for-each>
		</table>
		<P/>
	</xsl:if>
</xsl:template>


<xsl:template match="PROFILED">
	<xsl:variable name = "count">
		<xsl:choose>
			<xsl:when test = "count(DEFAULTS) = 1">0</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="COUNT"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:if test = "(/REFLECTION_SETTINGS/TYPE/@mode = 'All' and /REFLECTION_SETTINGS/TYPE = 'SETTINGS')
					or ($count > 0)">
		<H2><a name="profiled">Profiled</a></H2>
	</xsl:if>

	<xsl:choose>
		<xsl:when test="$count = 0">
	   		<P/><I>Nothing Profiled</I>
		</xsl:when>
		<xsl:otherwise>
			<P/>
			<I><xsl:text>Profiled List</xsl:text></I><BR/>
			<xsl:text>Profiled Commands </xsl:text><xsl:value-of select="PROFILED_COMMANDS/COUNT"/><BR/>
			<xsl:apply-templates select="PROFILED_COMMANDS"/>
			<xsl:text>Profiled Settings </xsl:text><xsl:value-of select="PROFILED_SETTINGS/COUNT"/><BR/>
			<xsl:apply-templates select="PROFILED_SETTINGS"/>
			<xsl:text>Profiled Features </xsl:text><xsl:value-of select="PROFILED_FEATURES/COUNT"/><BR/>
			<xsl:apply-templates select="PROFILED_FEATURES"/>
			<xsl:text>Profiled Files </xsl:text><xsl:value-of select="PROFILED_FILES/COUNT"/><BR/>
			<xsl:apply-templates select="PROFILED_FILES"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="PROFILED_COMMANDS">
	<xsl:if test = "COUNT &gt; 0">
		<table border="3" cellpadding="3">
			<xsl:for-each select="PROFILED_COMMAND">
				<tr align="left" >
					<td align="left"><xsl:value-of select="."/></td>
				</tr>
			</xsl:for-each>
		</table>
		<P/>
	</xsl:if>
</xsl:template>

<xsl:template match="PROFILED_SETTINGS">
	<xsl:if test = "COUNT &gt; 0">
		<table border="3" cellpadding="3">
			<xsl:for-each select="PROFILED_SETTING">
				<tr  align="left" >
					<td align="left"><xsl:value-of select="."/></td>
				</tr>
			</xsl:for-each>
		</table>
		<P/>
	</xsl:if>
</xsl:template>

<xsl:template match="PROFILED_FEATURES">
	<xsl:if test = "COUNT &gt; 0">
		<table border="3" cellpadding="3">
			<xsl:for-each select="PROFILED_FEATURE">
				<tr align="left" >
					<td align="left"><xsl:value-of select="."/></td>
				</tr>
			</xsl:for-each>
		</table>
		<P/>
	</xsl:if>
</xsl:template>

<xsl:template match="PROFILED_FILES">
	<xsl:if test = "COUNT &gt; 0">
		<table border="3" cellpadding="3">
				<tr align="left" >
					<td align="left">Site Default Settings</td>
					<td align="left"><xsl:value-of select="SITE_DEFAULT_SETTINGS"/></td>
				</tr>
				<tr align="left" >
					<td align="left">Prior Version Settings Script</td>
					<td align="left"><xsl:value-of select="PRIOR_VERSION_SCRIPT"/></td>
				</tr>
				<tr align="left" >
					<td align="left">Current Version Settings Script</td>
					<td align="left"><xsl:value-of select="CURRENT_VERSION_SCRIPT"/></td>
				</tr>
		</table>
	</xsl:if>
</xsl:template>

<xsl:template match="GROUP_POLICIES">
	<xsl:variable name = "count">
		<xsl:choose>
			<xsl:when test = "count(DEFAULTS) = 1">0</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="COUNT"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:if test = "(/REFLECTION_SETTINGS/TYPE/@mode = 'All' and /REFLECTION_SETTINGS/TYPE = 'SETTINGS')
					or ($count > 0)">
		<H2><a name="policies">Group Policies</a></H2>
	</xsl:if>

	<xsl:choose>
		<xsl:when test="$count = 0">
	   		<P/><I>Nothing Set by Group Policies</I>
		</xsl:when>
		<xsl:otherwise>
			<P/>
			<I><xsl:text>Group Policy List</xsl:text></I><BR/>
<!--
			<xsl:text>Commands </xsl:text><xsl:value-of select="./POLICY_COMMANDS/COUNT"/><BR/>
			<xsl:apply-templates select="POLICY_COMMANDS"/>
-->
			<xsl:text>Settings </xsl:text><xsl:value-of select="./POLICY_SETTINGS/COUNT"/><BR/>
			<xsl:apply-templates select="POLICY_SETTINGS"/>
			<xsl:if test = "./POLICY_SETTINGS/COUNT = 0">
				<P/>
			</xsl:if>

			<xsl:text>Features </xsl:text><xsl:value-of select="./POLICY_FEATURES/COUNT"/><BR/>
			<xsl:apply-templates select="POLICY_FEATURES"/>
<!--
			<xsl:text>Files </xsl:text><xsl:value-of select="./POLICY_FILES/COUNT"/><BR/>
			<xsl:apply-templates select="POLICY_FILES"/>
-->
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="POLICY_COMMANDS">
	<xsl:if test = "COUNT &gt; 0">
		<table border="3" cellpadding="3">
			<xsl:for-each select="POLICY_COMMAND">
				<tr align="left" >
					<td align="left"><xsl:value-of select="."/></td>
				</tr>
			</xsl:for-each>
		</table>
		<P/>
	</xsl:if>
</xsl:template>

<xsl:template match="POLICY_SETTINGS">
	<xsl:if test = "COUNT &gt; 0">
		<table border="3" cellpadding="3">
			<xsl:for-each select="POLICY_SETTING">
				<tr  align="left" >
					<td align="left"><xsl:value-of select="."/></td>
				</tr>
			</xsl:for-each>
		</table>
	</xsl:if>
</xsl:template>

<xsl:template match="POLICY_FEATURES">
	<xsl:if test = "COUNT &gt; 0">
		<table border="3" cellpadding="3">
			<xsl:for-each select="POLICY_FEATURE">
				<tr align="left" >
					<td align="left"><xsl:value-of select="."/></td>
				</tr>
			</xsl:for-each>
		</table>
		<P/>
	</xsl:if>
</xsl:template>


<xsl:template match="FUNCTION_KEYS">
	<xsl:if test = "/REFLECTION_SETTINGS/TYPE/@mode = 'All' and /REFLECTION_SETTINGS/TYPE = 'SETTINGS'">
		<H2><a name="fkeys">Function Keys</a></H2>
	</xsl:if>

	<xsl:apply-templates select="HP_USER_FUNCTION_KEYS"/>
	<xsl:apply-templates select="WYSE_FUNCTION_KEYS"/>
</xsl:template>


<xsl:template match="HP_USER_FUNCTION_KEYS">
	<xsl:if test = "COUNT &gt; 0">
		<I> HP Function Keys </I>
		<table border="3" cellpadding="3">
			<tr>
				<th align="center"><b>Key</b></th>
				<th align="center"><b>Attribute</b></th>
				<th align="center"><b>Label</b></th>
				<th align="center"><b>Definition</b></th>
			</tr>
				<xsl:for-each select="HP_USER_KEY">
				  	<xsl:call-template name="HP_USER_KEY"/>
				</xsl:for-each>
		</table>
	</xsl:if>
</xsl:template>


<xsl:template name="HP_USER_KEY">
	<tr>
		<td align="center"><xsl:value-of select="@keynumber"/></td>
		<td align="center"><xsl:value-of select="FKEY_ATTRIBUTE"/></td>
		<td align="center"><xsl:value-of select="LABEL"/></td>

		<xsl:variable name = "def">
			<xsl:value-of select="DEFINITION"/>
		</xsl:variable>
		
		<xsl:choose>
			<xsl:when test="string-length($def)=5 and starts-with($def,'#027')">
				<td align="center"><xsl:value-of select="translate($def,'#027;','ESC')"/></td>
			</xsl:when>
			<xsl:otherwise>
				<td align="center"><xsl:value-of select="READABLE_DEFINITION"/></td>
			 </xsl:otherwise>
		</xsl:choose>
	</tr>
</xsl:template>


<xsl:template match="WYSE_FUNCTION_KEYS">
	<xsl:if test = "COUNT &gt; 0">
		<P><BR/><I> Wyse Function Keys </I></P>
		<table border="3" cellpadding="3">
			<tr>
				<th align="center"><b>Key</b></th>
				<th align="center"><b>Direction</b></th>
				<th align="center"><b>Definition</b></th>
			</tr>
				<xsl:for-each select="WYSE_FKEY">
				  	<xsl:call-template name="WYSE_FKEY"/>
				</xsl:for-each>
		</table>
	</xsl:if>
</xsl:template>

<xsl:template name="WYSE_FKEY">
	<tr>
		<td align="center"><xsl:value-of select="@keynumber"/></td>
		<td align="center"><xsl:value-of select="KEY_DIRECTION"/></td>
		<td align="center"><xsl:value-of select="READABLE_DEFINITION"/></td>
  	</tr>
</xsl:template>


<xsl:template match="SCREEN" >
	<xsl:variable name = "statuslines" select = "count(STATUS_LINE)"/>
	<xsl:variable name = "count">
		<xsl:choose>
			<xsl:when test = "not(TEXT)">0</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="count(TEXT)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:if test = "(/REFLECTION_SETTINGS/TYPE/@mode = 'All' and /REFLECTION_SETTINGS/TYPE = 'SETTINGS')
					and (count(/REFLECTION_SETTINGS/SCREEN/TEXT) &gt; 0)">
		<H2><a name="screen">Screen</a></H2>
	</xsl:if>


	<xsl:if test="(count(TEXT) + count(STATUS_LINE)) &gt; 0">
		<P/>
		<I><xsl:text>Terminal Screen</xsl:text></I><BR/>
		<P/>
		<PRE>
		<xsl:apply-templates select="TEXT"/>
		<xsl:if test = "$statuslines &gt; 0">
			<xsl:call-template name = "lineBreak"/>
			<xsl:if test = "count(TEXT) &gt; 0">
				<xsl:call-template name = "lineBreak"/>
			</xsl:if>
			<xsl:choose>
				<xsl:when test = "$statuslines &lt; 2">
					<I><xsl:text>Status Line</xsl:text></I>
				</xsl:when>
				<xsl:otherwise>
					<I><xsl:text>Status Lines</xsl:text></I>
				</xsl:otherwise>
			</xsl:choose>
			<BR/>
		</xsl:if>
		<xsl:apply-templates select="STATUS_LINE"/>
		</PRE>
	</xsl:if>
</xsl:template>

<xsl:template match="TEXT" >

	<xsl:if test="count(OFFSCREEN) = 0">
		<!--   only handle lines of display memory that are displayed on the screen    -->

		<xsl:variable name = "current_line">
			<xsl:value-of select="@row"/>
		</xsl:variable>
	
		<xsl:variable name = "next_line">
			<xsl:value-of select="following-sibling::node()/@row"/>
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="count(INVERSE) > 0">
				<SPAN style="background-color:black; color:white">
		 			<xsl:value-of select="DATA"/>
				</SPAN>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="DATA"/>	
			</xsl:otherwise>
		</xsl:choose>

		<xsl:if test="$next_line > $current_line ">
			<xsl:call-template name  = "BLANK_ROWS">
				<xsl:with-param name = "current_row"><xsl:value-of select="$current_line"/></xsl:with-param>
				<xsl:with-param name = "next_row"><xsl:value-of select="$next_line"/></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:if>
</xsl:template>

  
<xsl:template match="STATUS_LINE">
	<xsl:value-of select = "."/>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>


<xsl:template name="BLANK_ROWS" >

	<xsl:param name = "current_row"/>
	<xsl:param name = "next_row"/>

	<xsl:if test="$current_row &lt; $next_row">
		<!--      output line break         -->
		<BR/>
		<xsl:call-template name = "BLANK_ROWS">
			<xsl:with-param name = "current_row"><xsl:value-of select="$current_row + 1"/></xsl:with-param>
			<xsl:with-param name = "next_row"><xsl:value-of select="$next_row"/></xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>

<xsl:template name = "lineBreak">
	<xsl:text>&#10;</xsl:text>
</xsl:template>



<xsl:template match="text()|@*"/>


<xsl:variable name="colorNames">
	<COLOR value = "0x00ffff" 	name = "Aqua"/>
	<COLOR value = "0xf0ffff" 	name = "Azure"/>
	<COLOR value = "0xf5f5dc" 	name = "Beige"/>
	<COLOR value = "0x0" 		name = "Black"/>
	<COLOR value = "0x0000ff" 	name = "Blue"/>
	<COLOR value = "0xa52a2a" 	name = "Brown"/>
	<COLOR value = "0x7fff00" 	name = "Chartreuse"/>
	<COLOR value = "0xff7f50" 	name = "Coral"/>
	<COLOR value = "0xdc143c" 	name = "Crimson"/>
	<COLOR value = "0x00ffff" 	name = "Cyan"/>
	<COLOR value = "0x00008b" 	name = "Darkblue"/>
	<COLOR value = "0x006400" 	name = "Darkgreen"/>
	<COLOR value = "0xa9a9a9" 	name = "Darkgrey"/>
	<COLOR value = "0x8b008b" 	name = "Darkmagenta"/>
	<COLOR value = "0x8b0000" 	name = "Darkred"/>
	<COLOR value = "0x9400d3" 	name = "Darkviolet"/>
	<COLOR value = "0x808000" 	name = "Darkyellow"/>
	<COLOR value = "0xff00ff" 	name = "Fuchsia"/>
	<COLOR value = "0x808080" 	name = "Gray"/>
	<COLOR value = "0x008000" 	name = "Green"/>
	<COLOR value = "0xfffff0" 	name = "Ivory"/>
	<COLOR value = "0xadd8e6" 	name = "Lightblue"/>
	<COLOR value = "0x00ff00" 	name = "Lime"/>
	<COLOR value = "0x32cd32" 	name = "Limegreen"/>
	<COLOR value = "0x800000" 	name = "Maroon"/>
	<COLOR value = "0x191970" 	name = "Midnightblue"/>
	<COLOR value = "0x000080" 	name = "Navy"/>
	<COLOR value = "0x808000" 	name = "Olive"/>
	<COLOR value = "0xffa500" 	name = "Orange"/>
	<COLOR value = "0x800080" 	name = "Purple"/>
	<COLOR value = "0xff0000" 	name = "Red"/>
	<COLOR value = "0xc0c0c0" 	name = "Silver"/>
	<COLOR value = "0xd2b48c" 	name = "Tan"/>
	<COLOR value = "0x008080" 	name = "Teal"/>
	<COLOR value = "0x40e0d0" 	name = "Turquoise"/>
	<COLOR value = "0xee82ee" 	name = "Violet"/>
	<COLOR value = "0xffffff" 	name = "White"/>
	<COLOR value = "0xffff00" 	name = "Yellow"/>
	<COLOR value = "0x6e6e6e" 	name = "ReflectionGrey"/>
 </xsl:variable>



</xsl:stylesheet>

