<?xml version="1.0"?>
<xsl:stylesheet	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="xml" indent="yes"/>


<!--  mappings.xsl  Display All Reflection Settings -->



<xsl:param name = "type"/>


<xsl:template match="/">

	<HTML>
	<HEAD>
		<TITLE>Reflection Mappings</TITLE>
	</HEAD>
	<BODY>
		<P><H2>Reflection Key and Mouse Mappings</H2></P>
		<xsl:apply-templates/>
	</BODY>
	</HTML>
</xsl:template>





<xsl:template match="KEYMAP" >
	<xsl:if test = "$type = 'keys' or $type = 'both' or $type = ''">
	<xsl:choose>
		<xsl:when test="count(COUNT) = 0">
	   		<P/><I>Default Key Map</I>
			<P/>
		</xsl:when>
		<xsl:otherwise>
		   	<P/>
			<table border="3" cellpadding="3">
				<thead>
					<tr><xsl:value-of select="COUNT"/> Mapped Keys</tr>
				</thead>
				<th align="center"><b>Keystroke</b></th>
				<th align="center"><b>Mapping</b></th>
					<xsl:apply-templates select="KEY_MAPPING"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
	</xsl:if>
</xsl:template>

<xsl:template match="KEY_MAPPING">
	<xsl:variable name = "keystroke">
		<xsl:choose>
			<xsl:when test="string-length(KEYSTROKE) &gt; 0">
				<xsl:value-of select="KEYSTROKE"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="VKEY"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = "mapping">
		<xsl:choose>
			<xsl:when test="count(LOC_MAPPING) &gt; 0">
				<xsl:value-of select="LOC_MAPPING"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="MAPPING"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<tr>
		<td><xsl:value-of select="$keystroke"/></td>
		<td><xsl:value-of select="$mapping"/></td>
	</tr>
</xsl:template>


<xsl:template match="MOUSEMAP" >
	<xsl:if test = "$type = 'mouse' or $type = 'both'or $type = ''">
	<xsl:choose>
		<xsl:when test="count(COUNT) = 0">
	   		<P/><I>Default Mouse Map</I>
			<P/>
		</xsl:when>
		<xsl:otherwise>
			<P/>
			<table border="3" cellpadding="3">
				<thead>
					<tr><xsl:value-of select="COUNT"/> Mouse Mappings</tr>
				</thead>
				<th align="center"><b>Keystroke</b></th>
				<th align="center"><b>Mapping</b></th>
					<xsl:apply-templates select="MOUSE_MAPPING"/>
			</table>
		</xsl:otherwise>
	</xsl:choose>
	</xsl:if>
</xsl:template>

<xsl:template match="MOUSE_MAPPING">
	<xsl:variable name = "mapping">
		<xsl:choose>
			<xsl:when test="count(LOC_MAPPING) &gt; 0">
				<xsl:value-of select="LOC_MAPPING"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="MAPPING"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<tr>
		<td><xsl:value-of select="MOUSECHORD"/></td>
		<td><xsl:value-of select="$mapping"/></td>
	</tr>
</xsl:template>






<xsl:template match="text()|@*"/>


</xsl:stylesheet>

