<?xml version="1.0"?>
<xsl:stylesheet	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!--
<xsl:output method="text" indent="yes" standalone = "yes" encoding = "iso-8859-1"/>
-->
<xsl:output method="text" indent="yes" standalone = "yes" encoding = "UTF-16"/>


<!--  maptext.xsl  Display Key and Mouse Mappings to Text -->

<xsl:template match="/">
	<xsl:call-template name = "lineBreak"/>
	<xsl:text>Reflection Key and Mouse Mappings</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:apply-templates/>
</xsl:template>



<xsl:template match="KEYMAP" >
	<xsl:choose>
		<xsl:when test="count(COUNT) = 0">
			<xsl:call-template name = "lineBreak"/>
	   		<xsl:text>Default Key Map</xsl:text>
			<xsl:call-template name = "lineBreak"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="COUNT"/><xsl:text> Key Mappings</xsl:text>
			<xsl:call-template name = "lineBreak"/>
			<xsl:call-template name = "lineBreak"/>
			<xsl:text>KEYSTROKE                          MAPPING</xsl:text>
			<xsl:call-template name = "lineBreak"/>
			<xsl:call-template name = "lineBreak"/>
			<xsl:apply-templates select="KEY_MAPPING"/>
			<xsl:call-template name = "lineBreak"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="KEY_MAPPING">
	<xsl:variable name = "keystroke">
		<xsl:choose>
			<xsl:when test="string-length(KEYSTROKE) &gt; 0">
				<xsl:value-of select="KEYSTROKE"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="VKEY"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = "mapping">
		<xsl:choose>
			<xsl:when test="count(LOC_MAPPING) &gt; 0">
				<xsl:value-of select="LOC_MAPPING"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="MAPPING"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name = "keystrokeLen">
		<xsl:value-of select="string-length($keystroke)"/>
	</xsl:variable>

	<xsl:variable name = "padding">
		<xsl:choose>
			<xsl:when test="$keystrokeLen &gt; 35">
				<xsl:value-of select="1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="35-$keystrokeLen"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:value-of select="$keystroke"/>
	<xsl:call-template name = "Spaces">
		<xsl:with-param name = "count"><xsl:value-of select="$padding"/></xsl:with-param>
	</xsl:call-template>
	<xsl:value-of select="$mapping"/>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>


<xsl:template match="MOUSEMAP" >
	<xsl:choose>
		<xsl:when test="count(COUNT) = 0">
			<xsl:call-template name = "lineBreak"/>
	   		<xsl:text>Default Mouse Map</xsl:text>
			<xsl:call-template name = "lineBreak"/>
			<xsl:call-template name = "lineBreak"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name = "lineBreak"/>
			<xsl:value-of select="COUNT"/><xsl:text> Mouse Mappings</xsl:text>
			<xsl:call-template name = "lineBreak"/>
			<xsl:call-template name = "lineBreak"/>
			<xsl:text>MOUSESTROKE                        MAPPING</xsl:text>
			<xsl:call-template name = "lineBreak"/>
			<xsl:call-template name = "lineBreak"/>

			<xsl:apply-templates select="MOUSE_MAPPING"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="MOUSE_MAPPING">
	<xsl:variable name = "keystrokeLen">
		<xsl:value-of select="string-length(MOUSECHORD)"/>
	</xsl:variable>

	<xsl:variable name = "mapping">
		<xsl:choose>
			<xsl:when test="count(LOC_MAPPING) &gt; 0">
				<xsl:value-of select="LOC_MAPPING"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="MAPPING"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name = "padding">
		<xsl:choose>
			<xsl:when test="$keystrokeLen &gt; 35">
				<xsl:value-of select="1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="35-$keystrokeLen"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:value-of select="MOUSECHORD"/>
	<xsl:call-template name = "Spaces">
		<xsl:with-param name = "count"><xsl:value-of select="$padding"/></xsl:with-param>
	</xsl:call-template>
	<xsl:value-of select="$mapping"/>
	<xsl:call-template name = "lineBreak"/>

</xsl:template>



<xsl:template name = "lineBreak">
	<xsl:text>&#10;</xsl:text>
</xsl:template>


<xsl:template name = "Spaces">
	<xsl:param name = "count"/>

	<xsl:if test = "$count &gt; 0">
		<xsl:text> </xsl:text>	
		<xsl:call-template name = "Spaces">
			<xsl:with-param name = "count">
				<xsl:value-of select = "$count - 1"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>




<xsl:template match="text()|@*"/>


</xsl:stylesheet>

