<?xml version="1.0"?>
<xsl:stylesheet	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
				xmlns:msxsl="urn:schemas-microsoft-com:xslt"
				exclude-result-prefixes="msxsl">

<!--
<xsl:output method="text" indent="no" encoding = "iso-8859-1"/>
-->
<xsl:output method="text" indent="no" encoding = "UTF-8"/>


<!--  memory.xsl  Format Reflection Display Memory -->


<xsl:variable name = "memory" select = "REFLECTION_SETTINGS/SCREEN"/>



<xsl:template match="/">
	<xsl:variable name = "XMLversion">
		<xsl:value-of select = "/REFLECTION_SETTINGS/@version"/>
	</xsl:variable>

	<xsl:if test = "$XMLversion &gt; '1'">
		<xsl:text>Reflection Display Memory</xsl:text>
		<xsl:call-template name = "lineBreak"/>
		<xsl:call-template name = "lineBreak"/>
		<xsl:call-template name = "lineBreak"/>
		<xsl:apply-templates select = "msxsl:node-set($memory)" mode = "screen"/>
		<xsl:apply-templates select = "msxsl:node-set($memory)" mode = "offscreen"/>
	</xsl:if>

	<xsl:if test = "$XMLversion &lt; '2'">
		<xsl:text>Old XML Settings format found</xsl:text>
		<xsl:call-template name = "lineBreak"/>
		<xsl:text>This transform requires 2.0 or greater exported Reflection Settings.</xsl:text>
		<xsl:call-template name = "lineBreak"/>
		<xsl:text>As exported by Reflection version 10.0 or later.</xsl:text>
		<xsl:call-template name = "lineBreak"/>
	</xsl:if>
	
</xsl:template>


<xsl:template match="SCREEN" mode = "screen">
	<xsl:variable name = "statuslines" select = "count(STATUS_LINE)"/>
	<xsl:variable name = "count">
		<xsl:choose>
			<xsl:when test = "not(TEXT)">0</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="count(TEXT)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:if test="($count &gt; 0) or ($statuslines &gt; 0)">
		<xsl:call-template name = "lineBreak"/>
		<xsl:text>TERMINAL SCREEN</xsl:text>
		<xsl:call-template name = "lineBreak"/>
		<xsl:call-template name = "lineBreak"/>
		<xsl:apply-templates select="TEXT" mode = "screen"/>

		<xsl:if test = "$statuslines &gt; 0">
			<xsl:call-template name = "lineBreak"/>
			<xsl:if test = "count(TEXT) &gt; 0">
				<xsl:call-template name = "lineBreak"/>
			</xsl:if>
			<xsl:choose>
				<xsl:when test = "$statuslines &lt; 2">
					<I><xsl:text>Status Line</xsl:text></I>
				</xsl:when>
				<xsl:otherwise>
					<I><xsl:text>Status Lines</xsl:text></I>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:call-template name = "lineBreak"/>
		</xsl:if>
		<xsl:apply-templates select="STATUS_LINE"/>
	</xsl:if>	
</xsl:template>


<xsl:template match="STATUS_LINE">
	<xsl:value-of select = "."/>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>


<xsl:template match="SCREEN" mode = "offscreen">
	<xsl:variable name = "count" select = "count(TEXT/OFFSCREEN)"/>

	<xsl:if test="$count &gt; 0">
		<xsl:call-template name = "lineBreak"/>
		<xsl:call-template name = "lineBreak"/>
		<xsl:text>DISPLAY MEMORY</xsl:text>
		<xsl:call-template name = "lineBreak"/>
		<xsl:call-template name = "lineBreak"/>
		<xsl:apply-templates select="TEXT" mode = "offscreen"/>
	</xsl:if>	
</xsl:template>


<xsl:template match="TEXT" mode = "screen">
	<xsl:choose>
	<xsl:when test="count(OFFSCREEN) = 0">
		<!--   only handle lines of display memory that are displayed on the screen    -->

		<xsl:variable name = "current_line">
			<xsl:value-of select="@row"/>
		</xsl:variable>
	
		<xsl:variable name = "next_line">
			<xsl:value-of select="following-sibling::node()/@row"/>
		</xsl:variable>
		<xsl:value-of select="DATA"/>	
		<xsl:if test="$next_line > $current_line ">
			<xsl:call-template name  = "BLANK_ROWS">
				<xsl:with-param name = "current_row"><xsl:value-of select="$current_line"/></xsl:with-param>
				<xsl:with-param name = "next_row"><xsl:value-of select="$next_line"/></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:when>
	<xsl:otherwise>
	</xsl:otherwise>
	</xsl:choose>
</xsl:template>



<xsl:template match="TEXT" mode = "offscreen">
	<xsl:if test="count(OFFSCREEN) &gt; 0">
		<!--   only handle lines of display memory that off the screen    -->

		<xsl:variable name = "current_line">
			<xsl:value-of select="@row"/>
		</xsl:variable>
	
		<xsl:variable name = "next_line">
			<xsl:value-of select="following-sibling::node()/@row"/>
		</xsl:variable>
		<xsl:value-of select="DATA"/>	
		<xsl:if test="$next_line > $current_line ">
			<xsl:call-template name  = "BLANK_ROWS">
				<xsl:with-param name = "current_row"><xsl:value-of select="$current_line"/></xsl:with-param>
				<xsl:with-param name = "next_row"><xsl:value-of select="$next_line"/></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:if>
</xsl:template>


<xsl:template name="BLANK_ROWS" >

	<xsl:param name = "current_row"/>
	<xsl:param name = "next_row"/>

	<xsl:if test="$current_row &lt; $next_row">
		<!--      output line break         -->
		<xsl:call-template name = "lineBreak"/>
		<xsl:call-template name = "BLANK_ROWS">
			<xsl:with-param name = "current_row"><xsl:value-of select="$current_row + 1"/></xsl:with-param>
			<xsl:with-param name = "next_row"><xsl:value-of select="$next_row"/></xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>



<xsl:template name = "lineBreak">
	<xsl:text>&#10;</xsl:text>
</xsl:template>


<xsl:template name = "Spaces">
	<xsl:param name = "count"/>

	<xsl:if test = "$count &gt; 0">
		<xsl:text> </xsl:text>	
		<xsl:call-template name = "Spaces">
			<xsl:with-param name = "count">
				<xsl:value-of select = "$count - 1"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>



<xsl:template match="text()|@*"/>




</xsl:stylesheet>
