<?xml version="1.0"?>
<xsl:stylesheet	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" 
				xmlns:msxsl="urn:schemas-microsoft-com:xslt"
				exclude-result-prefixes="msxsl">

<!--
<xsl:output method="text" encoding = "iso-8859-1" standalone = "yes" indent = "no"/>
-->
<xsl:output method="text" encoding = "UTF-16" standalone = "yes" indent = "no"/>


<!--  migrate.xsl   Create a migration report on which Reflection Settings will	and
	                won't be transformed to the Reflection for the Web 5.0 config file -->



<xsl:variable name = "transformVersion" select = "1.0"/>




<xsl:param name = "type"/>
<xsl:variable name = "configType"> 
	<xsl:choose>
		<xsl:when test = "translate($type,
									'ABCDEFGHIJKLMNOPQRSTUVWXYZ',
									'abcdefghijklmnopqrstuvwxyz') = 'keymap'">keymap</xsl:when>
		<xsl:otherwise>config</xsl:otherwise>
	</xsl:choose>
</xsl:variable>



<xsl:variable name = "miscMigratedSettings" select = "msxsl:node-set($MiscMigratedProperties)"/>
<xsl:variable name = "keycodeTable" 		select = "msxsl:node-set($PCkeycodeTable)"/>
<xsl:variable name = "connection"  			select = "REFLECTION_SETTINGS/CONNECTION"/>
<xsl:variable name = "colors"  				select = "REFLECTION_SETTINGS/COLORS"/>


<!-- Miscellaneous Migrated Settings -->
<xsl:variable name = "MiscMigratedProperties">
	<PROPERTY name = "BoldEnabled" 		value = "{$colors/COLOR_OPTIONS/COLOR_OPTION[@name='Enable Bold']/BOOLEAN}"/>
	<PROPERTY name = "BlinkEnabled" 	value = "{$colors/COLOR_OPTIONS/COLOR_OPTION[@name='Enable Blink']/BOOLEAN}"/>
	<PROPERTY name = "UnderlineEnabled" value = "{$colors/COLOR_OPTIONS/COLOR_OPTION[@name='Enable Underline']/BOOLEAN}"/>
	<PROPERTY name = "ConnectionType" 	value = "{$connection/CONNECTION_TYPE}"/>
	<PROPERTY name = "Host" 			value = "{$connection/CONNECTION_SETTING[@name='Host']/STRING}"/>
	<PROPERTY name = "NSVTPort"			value = "{$connection/CONNECTION_SETTING[@name='NSVTPort']/INTEGER}"/>
	<PROPERTY name = "TelnetPort" 		value = "{$connection/CONNECTION_SETTING[@name='TelnetPort']/INTEGER}"/>
	<PROPERTY name = "UseRwebSecurityProxy" value = "{$connection/CONNECTION_SETTING[@name='UseRwebSecurityProxy']/BOOLEAN}"/>
	<PROPERTY name = "UseTLS" 			value = "{$connection/CONNECTION_SETTING[@name='UseTLS']/BOOLEAN}"/>
</xsl:variable>


<!-- Groups of Migrated Settings -->
<xsl:variable name = "OtherMigratedGroups">
	<GROUP>Colors</GROUP>
	<GROUP>HP Function Keys</GROUP>
</xsl:variable>


<!-- Groups of Non Migrated Settings -->
<xsl:variable name = "NotMigratedGroups">
	<GROUP>Disabled</GROUP>
	<GROUP>Events</GROUP>
	<GROUP>Hotspots</GROUP>
	<GROUP>Menu</GROUP>
	<GROUP>Mousemap</GROUP>
	<GROUP>Profiled</GROUP>
	<GROUP>Tabs</GROUP>
	<GROUP>Toolbars</GROUP>
	<GROUP>VBA macros and mappings to macros</GROUP>
	<GROUP>Window Position</GROUP>
</xsl:variable>





<!-- Property Migration Tables -->

<xsl:variable name = "HP_PropertyTable">
	<!--  Enumeration Properties  -->
	<Property name = "CursorShape" migratedName = "cursorShape" container = "com.wrq.session.tisb.HPTISB" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcBlock" 				migratedValue = "0"/>
		<ENUMERATION value = "rcUnderline" 			migratedValue = "1"/>
		<ENUMERATION value = "rcVerticalBar" 		migratedValue = "0"/>
	</Property>
	<Property name = "PrimaryStatusResponse" migratedName = "displayMemoryResponse" container = "com.wrq.hp.HP" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rc4k" 				migratedValue = "0"/>
		<ENUMERATION value = "rc8k" 				migratedValue = "1"/>
		<ENUMERATION value = "rc12k" 				migratedValue = "2"/>
		<ENUMERATION value = "rc15k" 				migratedValue = "3"/>
	</Property>
	<Property name = "FunctionKeySet" migratedName = "functionKeySet" container = "com.wrq.hp.HP" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcUser" 				migratedValue = "6"/>  
		<ENUMERATION value = "rcModes" 				migratedValue = "4"/>  
		<ENUMERATION value = "rcDeviceControl" 		migratedValue = "0"/>  
		<ENUMERATION value = "rcDeviceModes" 		migratedValue = "1"/>  
		<ENUMERATION value = "rcToDevices" 			migratedValue = "0"/>  
		<ENUMERATION value = "rcEnhanceVideo" 		migratedValue = "7"/>  
		<ENUMERATION value = "rcDefineField" 		migratedValue = "2"/>  
	</Property>
	<Property name = "TerminalType" migratedName = "termtype" container = "com.wrq.hp.HP" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcHP2392A" 			migratedValue = "0"/>
		<ENUMERATION value = "rcHP70092" 			migratedValue = "1"/>
		<ENUMERATION value = "rcHP70094" 			migratedValue = "2"/>
		<ENUMERATION value = "rcVT52" 				migratedValue = "3"/>
		<ENUMERATION value = "rcVT102" 				migratedValue = "4"/>
		<ENUMERATION value = "rcVT220_7" 			migratedValue = "5"/>
		<ENUMERATION value = "rcVT220_8" 			migratedValue = "6"/>
	</Property>
	<Property name = "HostCharacterSet" migratedName = "hostCharSet" container = "com.wrq.hp.HP" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcDECSupplemental" 	migratedValue = "0"/>
		<ENUMERATION value = "rcHPRoman9" 			migratedValue = "1"/>
		<ENUMERATION value = "other" 				migratedValue = "0"/>
	</Property>
	<Property name = "NationalReplacementSet" migratedName = "NRCS" container = "com.wrq.hp.HP" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcNone" 				migratedValue = "0"/>
		<ENUMERATION value = "rcBritish" 			migratedValue = "16"/>
		<ENUMERATION value = "rcFrench" 			migratedValue = "5"/>
		<ENUMERATION value = "rcGerman" 			migratedValue = "10"/>
		<ENUMERATION value = "rcItalian" 			migratedValue = "11"/>
		<ENUMERATION value = "rcNorwegian" 			migratedValue = "12"/>
		<ENUMERATION value = "rcDanish" 			migratedValue = "2"/>
		<ENUMERATION value = "rcSwedish" 			migratedValue = "15"/>
		<ENUMERATION value = "rcDutch" 				migratedValue = "3"/>
		<ENUMERATION value = "rcSwissGerman" 		migratedValue = "9"/>
		<ENUMERATION value = "rcEuropeanSpanish" 	migratedValue = "13"/>
		<ENUMERATION value = "rcLatinSpanish" 		migratedValue = "13"/>
		<ENUMERATION value = "rcPortuguese" 		migratedValue = "14"/>
		<ENUMERATION value = "rcFinnish" 			migratedValue = "4"/>
		<ENUMERATION value = "rcCanadianEnglish" 	migratedValue = "6"/>
		<ENUMERATION value = "rcFlemish" 		 	migratedValue = "1"/>
		<ENUMERATION value = "rcCanadianFrench"  	migratedValue = "7"/>
		<ENUMERATION value = "rcSwissFrench" 	 	migratedValue = "8"/>
		<ENUMERATION value = "other" 	 			migratedValue = "0"/>
	</Property>
	<Property name = "HPDataSpeedSelect" migratedName = "highDataSpeed" container = "com.wrq.hp.HP" sourcetype = "ENUMERATION" type = "BOOLEAN">
		<ENUMERATION value = "LO" 	 				migratedValue = "false"/>
		<ENUMERATION value = "HI" 	 				migratedValue = "true"/>
	</Property>
	<Property name = "HPTerminalType" migratedName = "terminalIdResponse" container = "com.wrq.hp.HP" sourcetype = "ENUMERATION" type = "STRING">
		<ENUMERATION value = "HP2392A" 				migratedValue = "HP2392A"/>
		<ENUMERATION value = "HP70092" 				migratedValue = "HP70092"/>
		<ENUMERATION value = "HP70094" 				migratedValue = "HP70094"/>
	</Property>
	<Property name = "JumpScrollSpeed" migratedName = "jumpScrollSpeed" container = "com.wrq.session.tisb.HPTISB" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcUnlimitedScroll" 	migratedValue = "-2"/>
		<ENUMERATION value = "rcScrollByPage" 		migratedValue = "-3"/>
		<ENUMERATION value = "rcScrollBy1" 			migratedValue = "1"/>
		<ENUMERATION value = "rcScrollBy2" 			migratedValue = "2"/>
		<ENUMERATION value = "rcScrollBy4" 			migratedValue = "4"/>
		<ENUMERATION value = "rcScrollBy8" 			migratedValue = "8"/>
		<ENUMERATION value = "rcScrollBy16" 		migratedValue = "16"/>
		<ENUMERATION value = "rcScrollBy32" 		migratedValue = "32"/>
		<ENUMERATION value = "rcScrollBy64" 		migratedValue = "64"/>
		<ENUMERATION value = "rcScrollBy128" 		migratedValue = "128"/>
	</Property>
	<Property name = "TerminalClass" migratedName = "terminalType" container = "com.wrq.session.Session" sourcetype = "ENUMERATION" type = "STRING">
		<ENUMERATION value = "rcHP" 				migratedValue = "hp"/>
		<ENUMERATION value = "rcDEC" 				migratedValue = "vt"/>
	</Property>
	<Property name = "StartupAction" migratedName = "autoconnect" container = "com.wrq.session.Session" sourcetype = "ENUMERATION" type = "BOOLEAN">
		<ENUMERATION value = "rcAutoConnect" 		migratedValue = "true"/>
		<ENUMERATION value = "rcNoConnect" 			migratedValue = "false"/>
		<ENUMERATION value = "other" 	 			migratedValue = "false"/>
	</Property>
	<Property name = "TerminalType" migratedName = "terminalModel" container = "com.wrq.session.Session" sourcetype = "ENUMERATION" type = "STRING">
		<ENUMERATION value = "rcHP2392A" 			migratedValue = "2392A"/>
		<ENUMERATION value = "rcHP70092" 			migratedValue = "70092"/>
		<ENUMERATION value = "rcHP70094" 			migratedValue = "70094"/>
		<ENUMERATION value = "rcVT52" 				migratedValue = "VT102"/>
		<ENUMERATION value = "rcVT102" 				migratedValue = "VT102"/>
		<ENUMERATION value = "rcVT220_7" 			migratedValue = "VT220"/>
		<ENUMERATION value = "other" 				migratedValue = "VT220"/>
	</Property>
	<Property name = "FormatModeTransmits" migratedName = "transmitModified" container = "com.wrq.hp.HP" sourcetype = "ENUMERATION" type = "BOOLEAN">
		<ENUMERATION value = "rcAllFields" 			migratedValue = "false"/>
		<ENUMERATION value = "rcModifiedFields"		migratedValue = "true"/>
		<ENUMERATION value = "other" 	 			migratedValue = "false"/>
	</Property>

	<!--  Boolean Properties  -->
	<Property name = "AutoFormFeed" migratedName = "doFormFeeds" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "AutoLineFeed" migratedName = "AutoLineFeed" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "BlockMode" migratedName = "blockMode" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "CapsLockMode" migratedName = "capsLockMode" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "ConfigurationLocked" migratedName = "configLocked" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "DestructiveBackspace" migratedName = "destructiveBackspace" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "EnqAck" migratedName = "enqAck" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "InhibitHandshake" migratedName = "inhibitHandshake" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "InhibitDC2" migratedName = "inhibitDC2" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "InverseVideo" migratedName = "inverseVideo" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "LocalEcho" migratedName = "localEcho" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "MarginBell" migratedName = "marginBell" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "ReturnEqualsEnter" migratedName = "returnEqualsEnter" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "ShowFunctionKeys" migratedName = "showFunctionKeys" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "ShowStatusBar" migratedName = "showStatusLine" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "SPOW" migratedName = "spowEnabled" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "TerminalEscapeTransfer" migratedName = "escapeXfer" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "TerminalModifyAll" migratedName = "modifyAll" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "TypeAhead" migratedName = "typeahead" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "TransmitFunctions" migratedName = "transmitFunctions" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "HPUseHostPrompt" migratedName = "useHostPrompt" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "UserFeaturesLocked" migratedName = "userFeaturesLocked" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "Bell" migratedName = "warningBell" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "PrinterColumnsTiedToDisplay" migratedName = "printerColumnsTiedToDisplay" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "SmoothScroll" migratedName = "smoothScrollHP" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "SmoothScroll" migratedName = "smoothScroll" container = "com.wrq.session.tisb.HPTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "CursorBlink" migratedName = "cursorBlinks" container = "com.wrq.session.tisb.HPTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "CursorVisible" migratedName = "cursorVisible" container = "com.wrq.session.tisb.HPTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "InverseVideo" migratedName = "fgAndBgAreSwapped" container = "com.wrq.session.tisb.HPTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "ShowToolbar" migratedName = "toolbarVisible" container = "MapperEngine-1" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "ShowTerminalKeyboard" migratedName = "terminalKeyboardVisible" container = "MapperEngine-1" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "SlashZeros" migratedName = "slashedZero" container = "com.wrq.display.HPTD" type = "BOOLEAN" noValueMigration = "true"/>
	<!--
	<Property name = "PrinterFitFontToPage" migratedName = "fitToPage" container = "PrinterService" type = "BOOLEAN" noValueMigration = "true"/>
	-->

	<!--  Character Properties  -->
	<Property name = "BlockTerminator" migratedName = "blockTerminator" container = "com.wrq.hp.HP" sourcetype = "CHARACTER" type = "INTEGER" charToIntMigration = "true"/>
	<Property name = "FieldSeparator" migratedName = "fieldSeparator" container = "com.wrq.hp.HP" sourcetype = "CHARACTER" type = "INTEGER" charToIntMigration = "true"/>
	<Property name = "HostTriggerCharacter" migratedName = "hostPromptCharacter" container = "com.wrq.hp.HP" sourcetype = "CHARACTER" type = "INTEGER" charToIntMigration = "true"/>

	<!--  Integer Properties  -->
	<Property name = "DisplayColumns" migratedName = "screenColumns" container = "com.wrq.hp.HP" type = "INTEGER" specialcase = "true"/>
	<Property name = "DisplayRows" migratedName = "screenRows" container = "com.wrq.hp.HP" type = "INTEGER" noValueMigration = "true"/>
	<Property name = "FormsBufferSize" migratedName = "formsBufferSize" container = "com.wrq.hp.HP" type = "INTEGER" noValueMigration = "true"/>
	<Property name = "StartColumn" migratedName = "startColumn" container = "com.wrq.hp.HP" type = "INTEGER" noValueMigration = "true"/>
	<Property name = "PasteDelay" migratedName = "pasteDelay" container = "com.wrq.hp.HP" type = "INTEGER" noValueMigration = "true"/>
	<Property name = "SpacesPerTab" migratedName = "tabDefinition" container = "com.wrq.hp.HP" type = "INTEGER" noValueMigration = "true"/>
	<!--
	<Property name = "PrinterTimeout" migratedName = "printJobTerminationDelay" container = "PrinterService" type = "INTEGER" noValueMigration = "true"/>
	-->

	<!--  String Properties  -->
	<Property name = "ReturnDefinition" migratedName = "returnDefinition" container = "com.wrq.hp.HP" type = "STRING" noValueMigration = "false"/>

</xsl:variable>



<xsl:variable name = "VT_PropertyTable">
	<!--  Enumeration Properties  -->
	<Property name = "CursorShape" migratedName = "cursorShape" container = "com.wrq.session.tisb.VTTISB" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcBlock" 				migratedValue = "0"/>
		<ENUMERATION value = "rcUnderline" 			migratedValue = "1"/>
		<ENUMERATION value = "rcVerticalBar" 	 	migratedValue = "0"/>
	</Property>
	<Property name = "DAResponse" migratedName = "daResponse" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcVT100" 				migratedValue = "1"/>
		<ENUMERATION value = "rcVT101" 				migratedValue = "2"/>
		<ENUMERATION value = "rcVT102" 				migratedValue = "3"/>
		<ENUMERATION value = "rcVT220" 				migratedValue = "4"/>
		<ENUMERATION value = "rcVT320" 				migratedValue = "5"/>
		<ENUMERATION value = "rcVT420" 				migratedValue = "6"/>
		<ENUMERATION value = "rcVTWRQID" 			migratedValue = "0"/>
		<ENUMERATION value = "rcVT80" 				migratedValue = "1"/>
		<ENUMERATION value = "rcVT100J"   			migratedValue = "1"/>
		<ENUMERATION value = "rcVT102J"   			migratedValue = "3"/>
		<ENUMERATION value = "rcVT220J"   			migratedValue = "4"/>
		<ENUMERATION value = "rcVT282J"   			migratedValue = "4"/>
		<ENUMERATION value = "rcVT382J"   			migratedValue = "5"/>
		<ENUMERATION value = "rcVT510" 				migratedValue = "6"/>
		<ENUMERATION value = "rcVT282" 				migratedValue = "4"/>
		<ENUMERATION value = "rcVT382" 				migratedValue = "4"/>
	</Property>
	<Property name = "TerminalType" migratedName = "termtype" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcVT52" 			 	migratedValue = "0"/>
		<ENUMERATION value = "rcVT102" 			 	migratedValue = "1"/>
		<ENUMERATION value = "rcVT400_7" 			migratedValue = "2"/>
		<ENUMERATION value = "rcVT400_8" 			migratedValue = "3"/>
		<ENUMERATION value = "other" 				migratedValue = "2"/>
	</Property>
	<Property name = "TerminalType" migratedName = "7Bit" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "BOOLEAN">
		<ENUMERATION value = "rcVT52" 				migratedValue = "true"/>
		<ENUMERATION value = "rcVT102" 				migratedValue = "true"/>
		<ENUMERATION value = "rcVT400_7" 			migratedValue = "false"/>
		<ENUMERATION value = "rcVT400_8" 			migratedValue = "false"/>
		<ENUMERATION value = "other" 				migratedValue = "false"/>
	</Property>
	<Property name = "HostCharacterSet" migratedName = "decaupss" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcDECSupplemental" 	migratedValue = "0"/>
		<ENUMERATION value = "rcISOLatin_1" 		migratedValue = "1"/>
		<ENUMERATION value = "rcISOLatin_2" 		migratedValue = "2"/>
		<ENUMERATION value = "rcISOLatin_5" 		migratedValue = "3"/>
		<ENUMERATION value = "rcISOLatin_9" 		migratedValue = "4"/>
		<ENUMERATION value = "other" 				migratedValue = "1"/>
	</Property>
	<Property name = "NationalReplacementSet" migratedName = "nrcSet" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcNone" 				migratedValue = "0"/>
		<ENUMERATION value = "rcBritish" 			migratedValue = "1"/>
		<ENUMERATION value = "rcFrench" 			migratedValue = "4"/>
		<ENUMERATION value = "rcGerman" 			migratedValue = "5"/>
		<ENUMERATION value = "rcItalian" 			migratedValue = "6"/>
		<ENUMERATION value = "rcNorwegian" 			migratedValue = "7"/>
		<ENUMERATION value = "rcDanish" 			migratedValue = "7"/>
		<ENUMERATION value = "rcSwedish" 			migratedValue = "10"/>
		<ENUMERATION value = "rcDutch" 				migratedValue = "7"/>
		<ENUMERATION value = "rcSwissGerman" 		migratedValue = "11"/>
		<ENUMERATION value = "rcEuropeanSpanish"	migratedValue = "8"/>
		<ENUMERATION value = "rcLatinSpanish" 		migratedValue = "8"/>
		<ENUMERATION value = "rcPortuguese" 		migratedValue = "9"/>
		<ENUMERATION value = "rcFinnish" 			migratedValue = "3"/>
		<ENUMERATION value = "rcCanadianEnglish" 	migratedValue = "2"/>
		<ENUMERATION value = "rcFlemish" 			migratedValue = "7"/>
		<ENUMERATION value = "rcCanadianFrench" 	migratedValue = "2"/>
		<ENUMERATION value = "rcSwissFrench" 		migratedValue = "11"/>
	</Property>
	<Property name = "JumpScrollSpeed" migratedName = "jumpScrollSpeed" container = "com.wrq.session.tisb.VTTISB" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcUnlimitedScroll" 	migratedValue = "-2"/>
		<ENUMERATION value = "rcScrollByPage" 		migratedValue = "-3"/>
		<ENUMERATION value = "rcScrollBy1" 			migratedValue = "1"/>
		<ENUMERATION value = "rcScrollBy2" 			migratedValue = "2"/>
		<ENUMERATION value = "rcScrollBy4" 			migratedValue = "4"/>
		<ENUMERATION value = "rcScrollBy8" 			migratedValue = "8"/>
		<ENUMERATION value = "rcScrollBy16" 		migratedValue = "16"/>
		<ENUMERATION value = "rcScrollBy32" 		migratedValue = "32"/>
		<ENUMERATION value = "rcScrollBy64" 		migratedValue = "64"/>
		<ENUMERATION value = "rcScrollBy128" 		migratedValue = "128"/>
	</Property>
	<Property name = "TerminalClass" migratedName = "terminalType" container = "com.wrq.session.Session" sourcetype = "ENUMERATION" type = "STRING">
		<ENUMERATION value = "rcHP" 				migratedValue = "hp"/>
		<ENUMERATION value = "rcDEC" 				migratedValue = "vt"/>
	</Property>
	<Property name = "StartupAction" migratedName = "autoconnect" container = "com.wrq.session.Session" sourcetype = "ENUMERATION" type = "BOOLEAN">
		<ENUMERATION value = "rcAutoConnect" 		migratedValue = "true"/>
		<ENUMERATION value = "rcNoConnect" 			migratedValue = "true"/>
		<ENUMERATION value = "other" 			 	migratedValue = "false"/>
	</Property>
	<Property name = "TerminalType" migratedName = "terminalModel" container = "com.wrq.session.Session" sourcetype = "ENUMERATION" type = "STRING">
		<ENUMERATION value = "rcVT52" 				migratedValue = "VT52"/>
		<ENUMERATION value = "rcVT102" 				migratedValue = "VT102"/>
		<ENUMERATION value = "rcVT400_7" 			migratedValue = "VT400-7"/>
		<ENUMERATION value = "rcVT400_8" 			migratedValue = "VT400-8"/>
		<ENUMERATION value = "other" 				migratedValue = "VT400-7"/>
	</Property>
	<Property name = "HostStatusLine" migratedName = "decssdt" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcNoStatusLine"  		migratedValue = "0"/>
		<ENUMERATION value = "rcIndicator" 			migratedValue = "1"/>
		<ENUMERATION value = "rcHostWritable"		migratedValue = "2"/>
	</Property>
	<Property name = "VTBackspaceSends" migratedName = "decbkm" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "BOOLEAN">
		<ENUMERATION value = "rcDeleteKey"  		migratedValue = "false"/>
		<ENUMERATION value = "rcBackspaceKey" 		migratedValue = "true"/>
	</Property>
	<Property name = "VTCursorKeyMode" migratedName = "decckm" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "BOOLEAN">
		<ENUMERATION value = "rcNormalMode"  		migratedValue = "false"/>
		<ENUMERATION value = "rcApplicationMode" 	migratedValue = "true"/>
	</Property>
	<Property name = "VTKeypadMode" migratedName = "decnkm" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "BOOLEAN">
		<ENUMERATION value = "rcNumericMode"  		migratedValue = "false"/>
		<ENUMERATION value = "rcApplicationMode" 	migratedValue = "true"/>
	</Property>

	<!--  Boolean Properties  -->
	<Property name = "AutoRepeat" migratedName = "decarm" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "AutoAnswerback" migratedName = "decaam" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "AnswerbackConcealed" migratedName = "deccansm" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "AutoLineFeed" migratedName = "lnm" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "BreakEnabled" migratedName = "breakEnabled" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "EndOfLineWrap" migratedName = "decawm" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "MarginBell" migratedName = "marginBell" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "ShowStatusBar" migratedName = "showStatusLine" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "UserFeaturesLocked" migratedName = "userLock" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "Bell" migratedName = "warningBell" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "SmoothScroll" migratedName = "smoothScroll" container = "com.wrq.session.tisb.VTTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "SmoothScroll" migratedName = "decsclm" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "CursorBlink" migratedName = "cursorBlinks" container = "com.wrq.session.tisb.VTTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "CursorVisible" migratedName = "cursorVisible" container = "com.wrq.session.tisb.VTTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "LocalEcho" migratedName = "srm" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "false"/>
	<Property name = "Online" migratedName = "onLine" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "PrinterColumnsTiedToDisplay" migratedName = "printerColumnsTiedToDisplay" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "InverseVideo" migratedName = "fgAndBgAreSwapped" container = "com.wrq.session.tisb.VTTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "PreserveNRC" migratedName = "preserveNRC" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "UseNRC" migratedName = "decnrcm" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "SaveFromScrollingRegion" migratedName = "saveFromScrollingRegion" container = "com.wrq.session.tisb.VTTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "NewPageOnClear" migratedName = "saveBeforeClearing" container = "com.wrq.session.tisb.VTTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "UseNRC" migratedName = "nrcsActive" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "InverseVideo" migratedName = "decscnm" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "SlashZeros" migratedName = "slashedZero" container = "com.wrq.display.VTTD" type = "BOOLEAN" noValueMigration = "true"/>

   	<!--  Integer Properties  -->
	<Property name = "DisplayColumns" migratedName = "deccolm" container = "com.wrq.vt.VT" sourcetype = "INTEGER" type = "BOOLEAN" specialcase = "true"/>
	<Property name = "DisplayRows" migratedName = "decslpp" container = "com.wrq.vt.VT" type = "INTEGER" noValueMigration = "true"/>
	<Property name = "DisplayRows" migratedName = "decsnls" container = "com.wrq.vt.VT" type = "INTEGER" noValueMigration = "true"/>
	<Property name = "PasteDelay" migratedName = "pasteDelay" container = "com.wrq.vt.VT" type = "INTEGER" noValueMigration = "true"/>

	<!--  String Properties  -->
	<Property name = "Answerback" migratedName = "declans" container = "com.wrq.vt.VT" type = "STRING" noValueMigration = "false"/>

</xsl:variable>






<!-- Keymap Migration Tables -->


<!-- HP Mapping Migration Table -->
<xsl:variable name = "HPKeymapMappingTable">
	<!--  Menu Commands  -->
	<Mapping name = "EditSelectAll"			migratedCommand = "Glue.selectAll"/>
	<Mapping name = "ConnectionConnect" 	migratedCommand = "ISession.connect"/>
	<Mapping name = "ConnectionDisconnect" 	migratedCommand = "ISession.disconnect"/>
	<Mapping name = "Disconnect" 			migratedCommand = "ISession.disconnect"/>
	<Mapping name = "HelpAboutReflection" 	migratedCommand = "Glue.aboutBoxDialog"/>
	<Mapping name = "EditCopy" 				migratedCommand = "Glue.copy"/>
	<Mapping name = "EditPaste" 			migratedCommand = "Glue.paste"/>
<!--
	<Mapping name = "EditClearDisplay" 		migratedCommand = "HP.clearDisplay"/>
	<Mapping name = "HpClearDisplay" 		migratedCommand = "HP.clearDisplay"/>
-->
	<Mapping name = "FileClosePrinter" 		migratedCommand = "HP.closePrinter"/>
	<Mapping name = "FilePrint" 			migratedCommand = "Glue.screenPrint"/>
	<Mapping name = "NextPage" 				migratedCommand = "ITDService.scrollDownPage"/>
	<Mapping name = "PrevPage" 				migratedCommand = "ITDService.scrollUpPage"/>
	<Mapping name = "ScrollDown" 			migratedCommand = "ITDService.scrollDownRow"/>
	<Mapping name = "HpScrollDown" 			migratedCommand = "ITDService.scrollDownRow"/>
	<Mapping name = "ScrollUp" 				migratedCommand = "ITDService.scrollUpRow"/>
	<Mapping name = "HpScrollUp" 			migratedCommand = "ITDService.scrollUpRow"/>
	<Mapping name = "SelectDown" 			migratedCommand = "ITDService.selectTextDown"/>
	<Mapping name = "SelectUp" 				migratedCommand = "ITDService.selectTextUp"/>
	<Mapping name = "SelectLeft" 			migratedCommand = "ITDService.selectTextLeft"/>
	<Mapping name = "SelectRight" 			migratedCommand = "ITDService.selectTextRight"/>
	<Mapping name = "SelectPrevWord"		migratedCommand = "ITDService.selectWordLeft"/>
	<Mapping name = "SelectNextWord" 		migratedCommand = "ITDService.selectWordRight"/>

	<!--
	<Mapping name = "" 						migratedCommand = "ITDService.selectWordDown"/>
	<Mapping name = "" 						migratedCommand = "ITDService.selectWordUp"/>
	<Mapping name = "" 						migratedCommand = "ITDService.altSelectTextDown"/>
	<Mapping name = "" 						migratedCommand = "ITDService.altSelectTextUp"/>
	<Mapping name = "" 						migratedCommand = "ITDService.altSelectTextLeft"/>
	<Mapping name = "" 						migratedCommand = "ITDService.altSelectTextRight"/>
	-->
</xsl:variable>


<!-- VT Mapping Migration Table -->
<xsl:variable name = "VTKeymapMappingTable">
	<!--  Menu Commands  -->
	<Mapping name = "EditSelectAll"   		migratedCommand = "Glue.selectAll"/>
	<Mapping name = "ConnectionConnect" 	migratedCommand = "ISession.connect"/>
	<Mapping name = "ConnectionDisconnect"	migratedCommand = "ISession.disconnect"/>
	<Mapping name = "VtDisconnect"			migratedCommand = "ISession.disconnect"/>
	<Mapping name = "ClearCommunications"	migratedCommand = "VT.clearComm"/>
	<Mapping name = "HelpAboutReflection" 	migratedCommand = "Glue.aboutBoxDialog"/>
	<Mapping name = "EditCopy" 				migratedCommand = "Glue.copy"/>
	<Mapping name = "EditPaste" 			migratedCommand = "Glue.paste"/>
	<Mapping name = "EditClearDisplay" 		migratedCommand = "VT.clearDisplay"/>
	<Mapping name="TerminalRecallLastSetup" migratedCommand = "VT.recall"/>
	<Mapping name = "TerminalReset" 		migratedCommand = "VT.reset"/>
	<Mapping name = "NextPage" 				migratedCommand = "ITDService.scrollDownPage"/>
	<Mapping name = "TerminalNextPage" 		migratedCommand = "ITDService.scrollDownPage"/>
	<Mapping name = "PrevPage" 				migratedCommand = "ITDService.scrollUpPage"/>
	<Mapping name = "TerminalPreviousPage" 	migratedCommand = "ITDService.scrollUpPage"/>
	<Mapping name = "FilePrint" 			migratedCommand = "Glue.screenPrint"/>
	<Mapping name = "VtPrintScreen"  		migratedCommand = "Glue.screenPrint"/>
	<Mapping name = "ScrollDown" 			migratedCommand = "ITDService.scrollDownRow"/>
	<Mapping name = "ScrollUp" 				migratedCommand = "ITDService.scrollUpRow"/>

	<!--
	<Mapping name = "SelectDown" 			migratedCommand = "ITDService.selectTextDown"/>
	<Mapping name = "SelectUp" 				migratedCommand = "ITDService.selectTextUp"/>
	<Mapping name = "SelectLeft" 			migratedCommand = "ITDService.selectTextLeft"/>
	<Mapping name = "SelectRight" 			migratedCommand = "ITDService.selectTextRight"/>
	<Mapping name = "SelectPrevWord"		migratedCommand = "ITDService.selectWordLeft"/>
	<Mapping name = "SelectNextWord" 		migratedCommand = "ITDService.selectWordRight"/>
	<Mapping name = "" 						migratedCommand = "ITDService.selectWordDown"/>
	<Mapping name = "" 						migratedCommand = "ITDService.selectWordUp"/>
	<Mapping name = "" 						migratedCommand = "ITDService.altSelectTextDown"/>
	<Mapping name = "" 						migratedCommand = "ITDService.altSelectTextUp"/>
	<Mapping name = "" 						migratedCommand = "ITDService.altSelectTextLeft"/>
	<Mapping name = "" 						migratedCommand = "ITDService.altSelectTextRight"/>
	-->
</xsl:variable>


<!-- PC Key Migration Table -->
<xsl:variable name = "PCkeycodeTable">
<!-- <Key name = "Application" 		VirtKey="93" 	migratedKey = "93" /> -->
	<Key name = "Break" 			VirtKey="3"		migratedKey = "3" />
	<Key name = "Backspace" 		VirtKey="8"		migratedKey = "8" />
	<Key name = "Tab" 				VirtKey="9"		migratedKey = "9" />
	<Key name = "Center" 			VirtKey="12"	migratedKey = "12" />
	<Key name = "Return" 			VirtKey="13"	migratedKey = "10" />
	<Key name = "Pause" 			VirtKey="19"	migratedKey = "19" />
	<Key name = "CapsLock" 			VirtKey="20"	migratedKey = "20" />
	<Key name = "Esc" 				VirtKey="27"	migratedKey = "27" />
	<Key name = "Space" 			VirtKey="32"	migratedKey = "32" />
	<Key name = "PgUp" 				VirtKey="33"	migratedKey = "33" />
	<Key name = "PgDn" 				VirtKey="34"	migratedKey = "34" />
	<Key name = "End" 				VirtKey="35"	migratedKey = "35" />
	<Key name = "Home" 				VirtKey="36"	migratedKey = "36" />
	<Key name = "Left" 				VirtKey="37"	migratedKey = "37" />
	<Key name = "Up" 				VirtKey="38"	migratedKey = "38" />
	<Key name = "Right" 			VirtKey="39"	migratedKey = "39" />
	<Key name = "Down" 				VirtKey="40"	migratedKey = "40" />

	<Key name = "PrintScreen" 		VirtKey="44"	migratedKey = "154" />
	<Key name = "Del" 				VirtKey="46"	migratedKey = "127" />
	<Key name = "0" 				VirtKey="48"	migratedKey = "48" />
	<Key name = "1" 				VirtKey="49"	migratedKey = "49" />
	<Key name = "2" 				VirtKey="50"	migratedKey = "50" />
	<Key name = "3" 				VirtKey="51"	migratedKey = "51" />
	<Key name = "4" 				VirtKey="52"	migratedKey = "52" />
	<Key name = "5" 				VirtKey="53"	migratedKey = "53" />
	<Key name = "6" 				VirtKey="54"	migratedKey = "54" />
	<Key name = "7" 				VirtKey="55"	migratedKey = "55" />
	<Key name = "8" 				VirtKey="56"	migratedKey = "56" />
	<Key name = "9" 				VirtKey="57"	migratedKey = "57" />
	<Key name = "A" 				VirtKey="65"	migratedKey = "65" />
	<Key name = "B" 				VirtKey="66"	migratedKey = "66" />
	<Key name = "C" 				VirtKey="67"	migratedKey = "67" />
	<Key name = "D" 				VirtKey="68"	migratedKey = "68" />
	<Key name = "E" 				VirtKey="69"	migratedKey = "69" />
	<Key name = "F" 				VirtKey="70"	migratedKey = "70" />
	<Key name = "G" 				VirtKey="71"	migratedKey = "71" />
	<Key name = "H" 				VirtKey="72"	migratedKey = "72" />
	<Key name = "I" 				VirtKey="73"	migratedKey = "73" />
	<Key name = "J" 				VirtKey="74"	migratedKey = "74" />
	<Key name = "K" 				VirtKey="75"	migratedKey = "75" />
	<Key name = "L" 				VirtKey="76"	migratedKey = "76" />
	<Key name = "M" 				VirtKey="77"	migratedKey = "77" />
	<Key name = "N" 				VirtKey="78"	migratedKey = "78" />
	<Key name = "O" 				VirtKey="79"	migratedKey = "79" />
	<Key name = "P" 				VirtKey="80"	migratedKey = "80" />
	<Key name = "Q" 				VirtKey="81"	migratedKey = "81" />
	<Key name = "R"	 				VirtKey="82"	migratedKey = "82" />
	<Key name = "S"	 				VirtKey="83"	migratedKey = "83" />
	<Key name = "T" 				VirtKey="84"	migratedKey = "84" />
	<Key name = "U" 				VirtKey="85"	migratedKey = "85" />
	<Key name = "V" 				VirtKey="86"	migratedKey = "86" />
	<Key name = "W" 				VirtKey="87"	migratedKey = "87" />
	<Key name = "X" 				VirtKey="88"	migratedKey = "88" />
	<Key name = "Y" 				VirtKey="89"	migratedKey = "89" />
	<Key name = "Z" 				VirtKey="90"	migratedKey = "90" />

	<Key name = "Kp0" 				VirtKey="96"	migratedKey = "96" 			ExtendedKey="yes" />
	<Key name = "Kp1" 				VirtKey="97"	migratedKey = "97" 			ExtendedKey="yes" />
	<Key name = "Kp2" 				VirtKey="98"	migratedKey = "98" 			ExtendedKey="yes" />
	<Key name = "Kp3" 				VirtKey="99"	migratedKey = "99" 			ExtendedKey="yes" />
	<Key name = "Kp4" 				VirtKey="100"	migratedKey = "100" 		ExtendedKey="yes" />
	<Key name = "Kp5" 				VirtKey="101"	migratedKey = "101" 		ExtendedKey="yes" />
	<Key name = "Kp6" 				VirtKey="102"	migratedKey = "102" 		ExtendedKey="yes" />
	<Key name = "Kp7" 				VirtKey="103"	migratedKey = "103" 		ExtendedKey="yes" />
	<Key name = "Kp8" 				VirtKey="104"	migratedKey = "104" 		ExtendedKey="yes" />
	<Key name = "Kp9" 				VirtKey="105"	migratedKey = "105" 		ExtendedKey="yes" />

	<Key name = "KpCenter"			VirtKey="12"	migratedKey = "101" 		ExtendedKey="yes" />
	<Key name = "KpMultiply" 		VirtKey="106"	migratedKey = "106" 		ExtendedKey="yes" />
	<Key name = "PF4"		 		VirtKey="106"	migratedKey = "106" 		ExtendedKey="yes" />
	<Key name = "KpPlus"			VirtKey="107"	migratedKey = "107" 		ExtendedKey="yes" />
	<Key name = "VK_108"			VirtKey="108"	migratedKey = "108" 		ExtendedKey="yes" />
	<Key name = "KpMinus"			VirtKey="109"	migratedKey = "109" 		ExtendedKey="yes" />
	<Key name = "KpDecimal"			VirtKey="110"	migratedKey = "110" 		ExtendedKey="yes" />
	<Key name = "KpDivide"			VirtKey="111"	migratedKey = "111" 		ExtendedKey="yes" />

	<Key name = "F1"				VirtKey="112"	migratedKey = "112" />
	<Key name = "F2"				VirtKey="113"	migratedKey = "113" />
	<Key name = "F3"				VirtKey="114"	migratedKey = "114" />
	<Key name = "F4"				VirtKey="115"	migratedKey = "115" />
	<Key name = "F5"				VirtKey="116"	migratedKey = "116" />
	<Key name = "F6"				VirtKey="117"	migratedKey = "117" />
	<Key name = "F7"				VirtKey="118"	migratedKey = "118" />
	<Key name = "F8"				VirtKey="119"	migratedKey = "119" />
	<Key name = "F9"				VirtKey="120"	migratedKey = "120" />
	<Key name = "F10"				VirtKey="121"	migratedKey = "121" />
	<Key name = "F11"				VirtKey="122"	migratedKey = "122" />
	<Key name = "F12"				VirtKey="123"	migratedKey = "123" />
	<Key name = "F13"				VirtKey="124"	migratedKey = "61440" 		ExtendedKey="yes" />
	<Key name = "F14"				VirtKey="125"	migratedKey = "61441" 		ExtendedKey="yes" />
	<Key name = "F15"				VirtKey="126"	migratedKey = "61442" 		ExtendedKey="yes" />
	<Key name = "F16"				VirtKey="127"	migratedKey = "61443" 		ExtendedKey="yes" />
	<Key name = "F17"				VirtKey="128"	migratedKey = "61444" 		ExtendedKey="yes" />
	<Key name = "F18"				VirtKey="129"	migratedKey = "61445" 		ExtendedKey="yes" />
	<Key name = "F19"				VirtKey="130"	migratedKey = "61446" 		ExtendedKey="yes" />
	<Key name = "F20"				VirtKey="131"	migratedKey = "61447" 		ExtendedKey="yes" />
	<Key name = "F21"				VirtKey="132"	migratedKey = "61448" 		ExtendedKey="yes" />
	<Key name = "F22"				VirtKey="133"	migratedKey = "61449" 		ExtendedKey="yes" />
	<Key name = "F23"				VirtKey="134"	migratedKey = "61450" 		ExtendedKey="yes" />
	<Key name = "F24"				VirtKey="135"	migratedKey = "61451" 		ExtendedKey="yes" />

	<Key name = "HpF1"				VirtKey="112"	migratedKey = "112" />
	<Key name = "HpF2"				VirtKey="113"	migratedKey = "113" />
	<Key name = "HpF3"				VirtKey="114"	migratedKey = "114" />
	<Key name = "HpF4"				VirtKey="115"	migratedKey = "115" />
	<Key name = "HpF5"				VirtKey="116"	migratedKey = "116" />
	<Key name = "HpF6"				VirtKey="117"	migratedKey = "117" />
	<Key name = "HpF7"				VirtKey="118"	migratedKey = "118" />
	<Key name = "HpF8"				VirtKey="119"	migratedKey = "119" />
	<Key name = "HpF9"				VirtKey="120"	migratedKey = "120" />
	<Key name = "HpF10"				VirtKey="121"	migratedKey = "121" />
	<Key name = "HpF11"				VirtKey="122"	migratedKey = "122" />
	<Key name = "HpF12"				VirtKey="123"	migratedKey = "123" />

	<Key name = "NumLock"			VirtKey="144"	migratedKey = "144" />
	<Key name = "PF2"				VirtKey="144"	migratedKey = "144" />
	<Key name = "ScrollLock"		VirtKey="145"	migratedKey = "145" />
	<Key name = "PF3"				VirtKey="145"	migratedKey = "145" />
	<Key name = "Compose"			VirtKey="146"	migratedKey = "65312" 		ExtendedKey="yes" />
	<Key name = "Ins" 			    VirtKey="45"	migratedKey = "155" />
	<Key name = "Insert"			VirtKey="45"	migratedKey = "155" />
	<Key name = "Semicolon"			VirtKey="186"	migratedKey = "186" />
	<Key name = "Equals"			VirtKey="187"	migratedKey = "187" />
	<Key name = "Comma"				VirtKey="188"	migratedKey = "44" />
	<Key name = "Dash"				VirtKey="189"	migratedKey = "189" />
	<Key name = "Period"			VirtKey="190"	migratedKey = "46" />
	<Key name = "Slash"				VirtKey="191"	migratedKey = "47" />
	<Key name = "Grave"				VirtKey="192"	migratedKey = "192" />
	<Key name = "OpenBracket"		VirtKey="219"	migratedKey = "219" 		ExtendedKey="yes" />
	<Key name = "BackSlash"			VirtKey="220"	migratedKey = "92" />
	<Key name = "CloseBracket"		VirtKey="221"	migratedKey = "221" 		ExtendedKey="yes" />
	<Key name = "Apostrophe"		VirtKey="222"	migratedKey = "222" 		ExtendedKey="yes" />

	<Key name = "KpEnter" 			VirtKey="1293"	migratedKey = "10" 			ExtendedKey="yes" />
	<Key name = "CpPgUp"  			VirtKey="1313"	migratedKey = "33" 			ExtendedKey="yes" />
	<Key name = "CpPgDn"  			VirtKey="1314"	migratedKey = "34" 			ExtendedKey="yes" />
	<Key name = "CpEnd"	 			VirtKey="1315"	migratedKey = "35" 			ExtendedKey="yes" />
	<Key name = "CpHome"  			VirtKey="1316"	migratedKey = "36" 			ExtendedKey="yes" />
	<Key name = "CpLeft"  			VirtKey="1317"	migratedKey = "37" 			ExtendedKey="yes" />
	<Key name = "CpUp"	 			VirtKey="1318"	migratedKey = "38" 			ExtendedKey="yes" />
	<Key name = "CpRight" 			VirtKey="1319"	migratedKey = "39" 			ExtendedKey="yes" />
	<Key name = "CpDown"  			VirtKey="1320"	migratedKey = "40" 			ExtendedKey="yes" />
	<Key name = "CpIns"				VirtKey="1325"	migratedKey = "155" 		ExtendedKey="yes" />
	<Key name = "CpDel"				VirtKey="1326"	migratedKey = "127" 		ExtendedKey="yes" />
	<Key name = "ScrollLeft"		VirtKey="0"		migratedKey = "37" 			ExtendedKey="yes" />
	<Key name = "ScrollRight"		VirtKey="0"		migratedKey = "39" 			ExtendedKey="yes" />
</xsl:variable>



<!-- Modifier Migration Table -->
<xsl:variable name = "ModifierTable">
	<Key name = "Shift" 			mods = "4"	migratedModifier = "1" />
	<Key name = "Ctrl" 				mods = "2"	migratedModifier = "2" />
	<Key name = "Alt" 				mods = "1"	migratedModifier = "8" />
	<Key name = "Shift+Ctrl" 		mods = "6"	migratedModifier = "3" />
	<Key name = "Shift+Alt" 		mods = "5"	migratedModifier = "9" />
	<Key name = "Ctrl+Alt"	 		mods = "3"	migratedModifier = "10" />
	<Key name = "Shift+Ctrl+Alt" 	mods = "7"	migratedModifier = "11" />
</xsl:variable>						
<!-- otherwise 						mods = "0"	migratedModifier = "0" /> -->


<!-- HP Terminal Key Migration Table -->
<xsl:variable name = "HPTerminalKeyTable">
	<Key name = "HpEnter" 			migratedKey = "1" />
	<Key name = "Return" 			migratedKey = "2" />
	<Key name = "Tab" 				migratedKey = "3" />
	<Key name = "HpBacktab"	  		migratedKey = "4" />
	<Key name = "BreakKey" 	 		migratedKey = "5" />
	<Key name = "Hold" 		 		migratedKey = "6" />
	<Key name = "Print" 	 		migratedKey = "7" />
	<Key name = "Backspace"	 		migratedKey = "8" />
	<Key name = "HpDelete"			migratedKey = "9" />
	<Key name = "EscKey" 			migratedKey = "10" />
	<Key name = "CapsLockToggle"	migratedKey = "11" />
	<Key name = "CursorUp" 			migratedKey = "12" />
	<Key name = "CursorDown"  		migratedKey = "13" />
	<Key name = "CursorRight" 		migratedKey = "14" />
	<Key name = "CursorLeft"  		migratedKey = "15" />
	<Key name = "HardReset"  		migratedKey = "16" />
	<Key name = "HpMenu" 	 		migratedKey = "17" />
<!--<Key name = "FunctionKeysSetup" migratedKey = "18" />-->
<!--<Key name = "HpSystem"			migratedKey = "19" />-->
	<Key name = "HpUser" 	 		migratedKey = "20" />
	<Key name = "HpModes"	  		migratedKey = "21" />
	<Key name = "HpHomeUp"			migratedKey = "22" />
	<Key name = "HpHomeDown"  		migratedKey = "23" />
	<Key name = "HpClearDisplay"	migratedKey = "24" />
	<Key name = "EditClearDisplay"	migratedKey = "24" />
	<Key name = "HpClearLine"		migratedKey = "25" />
	<Key name = "HpInsertLine"		migratedKey = "26" />
	<Key name = "HpDeleteLine"		migratedKey = "27" />
	<Key name = "HpInsertChar"		migratedKey = "28" />
	<Key name = "HpInsertCharWrap"	migratedKey = "29" />
	<Key name = "HpDeleteChar"		migratedKey = "30" />
	<Key name = "HpDeleteCharWrap" 	migratedKey = "31" />
	<Key name = "PrevPage" 			migratedKey = "32" />
	<Key name = "NextPage" 			migratedKey = "33" />
	<Key name = "ScrollUp"			migratedKey = "34" />
	<Key name = "ScrollDown"		migratedKey = "35" />
	<Key name = "HpF1"				migratedKey = "36" />
	<Key name = "HpF2"				migratedKey = "37" />
	<Key name = "HpF3"				migratedKey = "38" />
	<Key name = "HpF4"				migratedKey = "39" />
	<Key name = "HpF5"				migratedKey = "40" />
	<Key name = "HpF6"				migratedKey = "41" />
	<Key name = "HpF7"				migratedKey = "42" />
	<Key name = "HpF8"				migratedKey = "43" />
	<Key name = "HpDefaultF1"		migratedKey = "44" />
	<Key name = "HpDefaultF2"		migratedKey = "45" />
	<Key name = "HpDefaultF3"		migratedKey = "46" />
	<Key name = "HpDefaultF4"		migratedKey = "47" />
	<Key name = "HpDefaultF5"		migratedKey = "48" />
	<Key name = "HpDefaultF6"		migratedKey = "49" />
	<Key name = "HpDefaultF7"		migratedKey = "50" />
	<Key name = "HpDefaultF8"		migratedKey = "51" />
	<Key name = "SoftReset"			migratedKey = "105" />
	<Key name = "ClearTypeahead"	migratedKey = "107" />
	<Key name = "HpSelect"			migratedKey = "108" />
<!--<Key name = "SmartEnterKey" 	migratedKey = "109" />-->
</xsl:variable>						


<!-- VT Terminal Key Migration Table -->
<xsl:variable name = "VTTerminalKeyTable">
	<Key name = "VtEnter" 			migratedKey = "1" />
	<Key name = "Return" 			migratedKey = "2" />
<!--<Key name = "Tab" 				migratedKey = "3" />-->
	<Key name = "BreakKey" 	 		migratedKey = "7" />
	<Key name = "VtBreak" 	 		migratedKey = "7" />
	<Key name = "VTHoldScreen" 		migratedKey = "8" />
	<Key name = "VtBackArrow"	 	migratedKey = "9" />
	<Key name = "Backspace"	 		migratedKey = "9" />
	<Key name = "EscKey" 			migratedKey = "10" />
	<Key name = "VtFind"	  		migratedKey = "13" />
	<Key name = "VtInsertHere" 		migratedKey = "14" />
	<Key name = "VtRemove"  		migratedKey = "15" />
	<Key name = "VtSelect"  		migratedKey = "16" />
	<Key name = "VtPrevScreen" 		migratedKey = "17" />
	<Key name = "VtNextScreen" 		migratedKey = "18" />
	<Key name = "CursorUp"			migratedKey = "19" />
	<Key name = "CursorDown"  		migratedKey = "20" />
	<Key name = "CursorRight"  		migratedKey = "21" />
	<Key name = "CursorLeft"   		migratedKey = "22" />
	<Key name = "VtPf1"  			migratedKey = "23" />
	<Key name = "VtPf2"				migratedKey = "24" />
	<Key name = "VtPf3"				migratedKey = "25" />
	<Key name = "VtPf4"				migratedKey = "26" />
	<Key name = "VtMinus"			migratedKey = "27" />
	<Key name = "VtComma"			migratedKey = "28" />
	<Key name = "VtDecimal"			migratedKey = "29" />
	<Key name = "Vt0"				migratedKey = "30" />
	<Key name = "Vt1" 				migratedKey = "31" />
	<Key name = "Vt2" 				migratedKey = "32" />
	<Key name = "Vt3" 				migratedKey = "33" />
	<Key name = "Vt4"				migratedKey = "34" />
	<Key name = "Vt5"				migratedKey = "35" />
	<Key name = "Vt6"				migratedKey = "36" />
	<Key name = "Vt7"				migratedKey = "37" />
	<Key name = "Vt8"				migratedKey = "38" />
	<Key name = "Vt9"				migratedKey = "39" />
	<Key name = "VtF1"				migratedKey = "40" />
	<Key name = "VtF2"				migratedKey = "41" />
	<Key name = "VtF3"				migratedKey = "42" />
	<Key name = "VtF4"				migratedKey = "43" />
	<Key name = "VtF5"				migratedKey = "44" />
	<Key name = "VtF6"				migratedKey = "45" />
	<Key name = "VtF7"				migratedKey = "46" />
	<Key name = "VtF8"				migratedKey = "47" />
	<Key name = "VtF9"				migratedKey = "48" />
	<Key name = "VtF10"				migratedKey = "49" />
	<Key name = "VtF11"				migratedKey = "50" />
	<Key name = "VtF12"				migratedKey = "51" />
	<Key name = "VtF13"				migratedKey = "52" />
	<Key name = "VtF14"				migratedKey = "53" />
	<Key name = "VtF15"				migratedKey = "54" />
	<Key name = "VtF16"				migratedKey = "55" />
	<Key name = "VtF17"				migratedKey = "56" />
	<Key name = "VtF18"				migratedKey = "57" />
	<Key name = "VtF19"				migratedKey = "58" />
	<Key name = "VtF20"				migratedKey = "59" />
	<Key name = "VtUdk6"			migratedKey = "60" />
	<Key name = "VtUdk7"			migratedKey = "61" />
	<Key name = "VtUdk8"			migratedKey = "62" />
	<Key name = "VtUdk9"			migratedKey = "63" />
	<Key name = "VtUdk10"			migratedKey = "64" />
	<Key name = "VtUdk11"			migratedKey = "65" />
	<Key name = "VtUdk12"			migratedKey = "66" />
	<Key name = "VtUdk13"			migratedKey = "67" />
	<Key name = "VtUdk14"			migratedKey = "68" />
	<Key name = "VtUdk15"			migratedKey = "69" />
	<Key name = "VtUdk16"			migratedKey = "70" />
	<Key name = "VtUdk17"			migratedKey = "71" />
	<Key name = "VtUdk18"			migratedKey = "72" />
	<Key name = "VtUdk19"			migratedKey = "73" />
	<Key name = "VtUdk20"			migratedKey = "74" />
</xsl:variable>						





<!-- global variables  -->

<xsl:variable name = "properties" select = "/REFLECTION_SETTINGS/PROPERTIES"/>
<xsl:variable name = "HPPropertyTable"	select = "msxsl:node-set($HP_PropertyTable)"/>
<xsl:variable name = "VTPropertyTable" 	select = "msxsl:node-set($VT_PropertyTable)"/>
<xsl:variable name = "root" select = "REFLECTION_SETTINGS"/>

<xsl:variable name = "XMLversion">
	<xsl:value-of select = "/REFLECTION_SETTINGS/@version"/>
</xsl:variable>

<xsl:variable name = "settingsType" select =  "/REFLECTION_SETTINGS/TYPE"/>
<xsl:variable name = "settingsMode" select =  "/REFLECTION_SETTINGS/TYPE/@mode"/>

<xsl:variable name = "emulator">
	<xsl:value-of select = "/REFLECTION_SETTINGS/CREATOR/@type"/>
</xsl:variable>

<xsl:variable name = "terminalClass"
	select = "$properties/PROPERTY[@name = 'TerminalClass']/ENUMERATION"/>

<xsl:variable name = "product">
	<xsl:choose>
		<xsl:when test = "($emulator = 1)">HP</xsl:when>
		<xsl:otherwise>VT</xsl:otherwise>			
	</xsl:choose>
</xsl:variable>


<xsl:variable name = "productType">
	<xsl:choose>
		<xsl:when test = "($emulator = 1) and ($terminalClass = 'rcHP')">HP</xsl:when>
		<xsl:otherwise>VT</xsl:otherwise>			
	</xsl:choose>
</xsl:variable>

<xsl:variable name = "connectionType">
	<xsl:choose>
		<xsl:when test = "(/REFLECTION_SETTINGS/CONNECTION/CONNECTION_TYPE = 'VT-MGR') and
						  ($productType = 'HP')">nsvt</xsl:when>
		<xsl:otherwise>telnet</xsl:otherwise>			
	</xsl:choose>
</xsl:variable>

<xsl:variable name = "terminalType" 
			  select = "$properties/PROPERTY[@name = 'TerminalType']/ENUMERATION"/>

<xsl:variable name = "subtype">
	<xsl:value-of select = "/REFLECTION_SETTINGS/CREATOR/@emulation"/>
</xsl:variable>

<xsl:variable name = "language">
	<xsl:value-of select = "/REFLECTION_SETTINGS/CREATOR/@language"/>
</xsl:variable>





<xsl:template match="/">
	<xsl:variable name = "validSourceXML">
		<xsl:call-template name = "isSourceXMLValid"/>
	</xsl:variable>

	<xsl:choose>
		<xsl:when test = "string($validSourceXML) = 'true'">
			<xsl:call-template name = "createReport"/>
 		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name = "reportBadSourceXML"/>
	  	</xsl:otherwise>
	</xsl:choose>
</xsl:template>



<xsl:template name = "createReport">
	<xsl:call-template name = "CreatedByComment"/>
	<xsl:choose>
		<xsl:when test = "$configType = 'keymap'">
			<!-- keymap only report -->
			<xsl:apply-templates select = "/REFLECTION_SETTINGS/KEYMAP"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:apply-templates/>
			<xsl:call-template name = "Migrated"/>
			<xsl:call-template name = "NotMigrated"/>
			<xsl:call-template name = "lineBreak"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>




<xsl:template match="PROPERTIES" >
	<xsl:variable name = "count">
		<xsl:value-of select="count(PROPERTY)"/>
	</xsl:variable>

<!--
	<xsl:variable name = "migratedTerminalProperties">
		<xsl:choose>
			<xsl:when test = "$productType = 'HP'">
				<xsl:call-template name = "countMigratableProperties">
					<xsl:with-param name = "ContainerName">com.wrq.hp.HP</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name = "countMigratableProperties">
					<xsl:with-param name = "ContainerName">com.wrq.vt.VT</xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name = "migratedSessionProperties">
		<xsl:call-template name = "countMigratableProperties">
			<xsl:with-param name = "ContainerName">com.wrq.session.Session</xsl:with-param>
		</xsl:call-template> 
	</xsl:variable>

	<xsl:variable name = "migratedDisplayProperties">
		<xsl:choose>
			<xsl:when test = "$productType = 'HP'">
				<xsl:call-template name = "countMigratableProperties">
					<xsl:with-param name = "ContainerName">com.wrq.session.tisb.HPTISB</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name = "countMigratableProperties">
					<xsl:with-param name = "ContainerName">com.wrq.session.tisb.VTTISB</xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name = "miscMigratedProperties">
		<xsl:value-of select = "count($miscMigratedSettings/PROPERTY) - 1"/>
	</xsl:variable>

	<xsl:variable name = "migratedPropertyCount">
		<xsl:value-of select = "$migratedTerminalProperties + 
								$migratedSessionProperties  +
								$migratedDisplayProperties  +
								$miscMigratedProperties"/> 
	</xsl:variable>
-->

	<xsl:call-template name = "lineBreak"/>
	<xsl:choose>
		<xsl:when test="$count > 0">
			<xsl:value-of select="COUNT"/> 
			<xsl:text> Propert</xsl:text>
			<xsl:choose>
				<xsl:when test="$count > 1">
					<xsl:text>ies</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>y</xsl:text>
				</xsl:otherwise>
			</xsl:choose>

			<!-- display how many properties will be migrated -->
<!--
			<xsl:text>   (</xsl:text>
			<xsl:value-of select = "$migratedPropertyCount"/>
			<xsl:text> Migrated)</xsl:text>
-->
			<xsl:call-template name = "lineBreak"/>
			<xsl:call-template name = "lineBreak"/>
			<xsl:text>PROPERTY</xsl:text>
			<xsl:call-template name = "Spaces">
				<xsl:with-param name = "count"><xsl:value-of select="27"/></xsl:with-param>
			</xsl:call-template>
			<xsl:text>MIGRATED  </xsl:text>
			<xsl:text>VALUE</xsl:text>
			<xsl:call-template name = "lineBreak"/>

			<xsl:text>________</xsl:text>
			<xsl:call-template name = "Spaces">
				<xsl:with-param name = "count"><xsl:value-of select="27"/></xsl:with-param>
			</xsl:call-template>
			<xsl:text>________  _____</xsl:text>
			<xsl:call-template name = "lineBreak"/>

			<xsl:apply-templates select="PROPERTY">
			<xsl:sort select="@name"/>
			</xsl:apply-templates>

			<!-- list the miscellaneous migrated settings  -->
			<xsl:call-template name = "MiscMigratedSettings"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>All Properties are at defaults</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="PROPERTY">
	<xsl:variable name = "namelgth">
		<xsl:value-of select="string-length(@name)"/>
	</xsl:variable>
	<xsl:variable name = "padding">
		<xsl:choose>
			<xsl:when test="$namelgth &gt; 45">
				<xsl:value-of select="1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="45-$namelgth"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = "migratedProperty">
		<xsl:call-template name = "isPropertyMigratable">
			<xsl:with-param name = "node" select = "."/>
		</xsl:call-template>
	</xsl:variable>

	<xsl:call-template name = "lineBreak"/>
	<xsl:value-of select="@name"/>
	<xsl:choose>
		<xsl:when test = "$migratedProperty = 'true'">
			<xsl:call-template name = "Spaces">
				<xsl:with-param name = "count"><xsl:value-of select="$padding - 6"/></xsl:with-param>
			</xsl:call-template>		
			<xsl:text>*     </xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name = "Spaces">
				<xsl:with-param name = "count"><xsl:value-of select="$padding"/></xsl:with-param>
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
  	<xsl:call-template name="PROPERTY_TYPE"/>
</xsl:template>

<xsl:template name="PROPERTY_TYPE">
	<xsl:choose>
		<xsl:when test = "count(BOOLEAN) &gt; 0">
			<xsl:value-of select="BOOLEAN"/>
		</xsl:when>
		<xsl:when test = "count(INTEGER) &gt; 0">
			<xsl:value-of select="INTEGER"/>
		</xsl:when>
		<xsl:when test = "count(ENUMERATION) &gt; 0">
			<xsl:value-of select="ENUMERATION"/>
		</xsl:when>
		<xsl:when test = "count(CHARACTER) &gt; 0">
			<xsl:choose>
			   <xsl:when test = "count(CHARACTER/@ctrl) &gt; 0">
					<xsl:value-of select="CHARACTER/@ctrl"/>
			   </xsl:when>
				<xsl:when test = "CHARACTER=''">
					<xsl:text>(not set)</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="CHARACTER"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:when test = "count(STRING) &gt; 0">
			<xsl:choose>
				<xsl:when test = "STRING=''">
					<xsl:text>(empty string)</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="STRING"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>

		<xsl:when test = "count(FOLDER) &gt; 0">
			<xsl:choose>
				<xsl:when test = "FOLDER=''">
					<xsl:text>(empty folder name)</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="FOLDER"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:when test = "count(FILE) &gt; 0">
			<xsl:choose>
				<xsl:when test = "FILE=''">
					<xsl:text>(empty filename)</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="FILE"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>

		<xsl:otherwise>
			<xsl:text>unknown type</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template match="KEYMAP" >
	<xsl:variable name = "count">
		<xsl:choose>
			<xsl:when test = "not(COUNT)">0	</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="COUNT"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

<!--
	<xsl:variable name = "migratableMappings">
		<xsl:call-template name = "CountMigratableKeymappings"/>
	</xsl:variable>
-->

	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:value-of select="COUNT"/><xsl:text> Key Mapping</xsl:text>
	<xsl:if  test="$count > 1">
		<xsl:text>s</xsl:text>
	</xsl:if>

	<!-- display how many keymappings will be migrated -->
<!--
	<xsl:text>   (</xsl:text>
	<xsl:value-of select = "$migratableMappings"/>
	<xsl:text> Keymappings Migrated)</xsl:text>
-->

	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:text>KEYSTROKE                          MIGRATED  MAPPING</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:text>_________                          ________  _______</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:apply-templates select="KEY_MAPPING"/>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>

<xsl:template match="KEY_MAPPING">
	<xsl:variable name = "keystrokeLen">
		<xsl:value-of select="string-length(KEYSTROKE)"/>
	</xsl:variable>
	<xsl:variable name = "padding">
		<xsl:choose>
			<xsl:when test="$keystrokeLen &gt; 45">
				<xsl:value-of select="1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="45-$keystrokeLen"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name = "migratedMapping">
		<xsl:call-template name = "isMappingMigratable">
			<xsl:with-param name = "node" select = "."/>
		</xsl:call-template>
	</xsl:variable>

	<xsl:value-of select="KEYSTROKE"/>
	<xsl:choose>
		<xsl:when test = "$migratedMapping = 'true'">
			<xsl:call-template name = "Spaces">
				<xsl:with-param name = "count"><xsl:value-of select="$padding - 6"/></xsl:with-param>
			</xsl:call-template>		
			<xsl:text>*     </xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name = "Spaces">
				<xsl:with-param name = "count"><xsl:value-of select="$padding"/></xsl:with-param>
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
	<xsl:value-of select="MAPPING"/>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>

 
<xsl:template name = "CreatedByComment" >
	<xsl:text>Reflection for Windows to Reflection for the Web 5.0 Migration Report</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>	
	<xsl:call-template name = "lineBreak"/>
	<xsl:text>Reflection </xsl:text>
   	<xsl:value-of select="/REFLECTION_SETTINGS/TYPE"/>
	<xsl:text> (XML format </xsl:text>
	<xsl:value-of select="/REFLECTION_SETTINGS/@version"/>
	<xsl:text>)</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:text>Created by </xsl:text> 
	<xsl:value-of select="/REFLECTION_SETTINGS/CREATOR/@product"/>
    <xsl:text> - version </xsl:text>
	<xsl:value-of select="/REFLECTION_SETTINGS/CREATOR/@version"/>
	<xsl:text> (build </xsl:text>
	<xsl:value-of select="/REFLECTION_SETTINGS/CREATOR/@build"/>
	<xsl:text>) </xsl:text>
	<xsl:if test = "string($subtype)">
		<xsl:text> </xsl:text> 
		<xsl:value-of select="$subtype"/>
		<xsl:text> Emulation</xsl:text> 
	</xsl:if>
	<xsl:call-template name = "lineBreak"/>
	<xsl:if test = "string($language)">
		<xsl:text>Language - </xsl:text> 
		<xsl:value-of select="$language"/>
		<xsl:call-template name = "lineBreak"/>
	</xsl:if>
	<xsl:text>Transform version </xsl:text> 
	<xsl:value-of select="$transformVersion"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>


<xsl:template name = "MiscMigratedSettings" >
	<xsl:call-template name = "lineBreak"/>	
	<xsl:call-template name = "lineBreak"/>

	<xsl:for-each select = "$miscMigratedSettings/PROPERTY">
		<xsl:value-of select = "./@name"/>

		<xsl:variable name = "namelgth">
			<xsl:value-of select="string-length(./@name)"/>
		</xsl:variable>
		<xsl:variable name = "padding">
			<xsl:choose>
				<xsl:when test="$namelgth &gt; 45">
					<xsl:value-of select="1"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="45-$namelgth"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:call-template name = "Spaces">
			<xsl:with-param name = "count"><xsl:value-of select="$padding - 6"/></xsl:with-param>
		</xsl:call-template>		
		<xsl:text>*     </xsl:text>

		<xsl:variable name = "value" select = "./@value"/>
		<xsl:value-of select = "$value"/>

		<xsl:call-template name = "lineBreak"/>
	</xsl:for-each>

</xsl:template>


<xsl:template name = "Migrated" >
	<xsl:variable name = "otherMigratedGroups" select = "msxsl:node-set($OtherMigratedGroups)"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>	
	<xsl:text>Other Migrated Settings</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:text>_______________________</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:for-each select = "$otherMigratedGroups/GROUP">
		<xsl:value-of select = "."/>
		<xsl:call-template name = "lineBreak"/>
	</xsl:for-each>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>
	

<xsl:template name = "NotMigrated" >
	<xsl:variable name = "notMigratedGroups" select = "msxsl:node-set($NotMigratedGroups)"/>

	<xsl:call-template name = "lineBreak"/>	
	<xsl:text>Non Migrated Settings</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:text>_____________________</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:for-each select = "$notMigratedGroups/GROUP">
		<xsl:value-of select = "."/>
		<xsl:call-template name = "lineBreak"/>
	</xsl:for-each>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>
						  

<xsl:template name = "isMappingMigratable">
	<xsl:param name = "node" select = "current()"/>
	<xsl:choose>
		<xsl:when test = "$productType = 'HP'">
			<xsl:call-template name = "isHPMappingMigratable">
				<xsl:with-param name = "node" select = "$node"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name = "isVTMappingMigratable">
				<xsl:with-param name = "node" select = "$node"/>
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>



<xsl:template name = "isHPMappingMigratable">
	<xsl:param name = "node" select = "current()"/>

	<xsl:variable name = "KeycodeEntry" select = "$keycodeTable/Key[@name = $node/KEY]"/>
	<xsl:variable name = "mappableKey">
		<xsl:choose>
			<xsl:when test = "string($KeycodeEntry/@migratedKey)">true</xsl:when>
		</xsl:choose>
	</xsl:variable>

	<xsl:choose>
		<xsl:when test = "($node/COMMAND_TYPE = 'Transmit Text') and string($mappableKey)">true</xsl:when>

		<xsl:when test = "($node/COMMAND_TYPE = 'Terminal Command') or 
					($node/COMMAND_TYPE = 'Menu Command')">

			<xsl:variable name = "keyTable" select = "msxsl:node-set($HPKeymapMappingTable)"/>
			<xsl:variable name = "TerminalkeyTable" select = "msxsl:node-set($HPTerminalKeyTable)"/>
			<xsl:variable name = "mappedFromTable1" select = "$keyTable/Mapping[@name = $node/MAPPING]"/>
			<xsl:variable name = "mappedFromTable2" select = "$TerminalkeyTable/Key[@name = $node/MAPPING]"/>

			<xsl:variable name = "mapped">
				<xsl:choose>
					<xsl:when test = "string($mappedFromTable1/@migratedCommand)">
						<xsl:value-of select = "$mappedFromTable1/@migratedCommand"/>
					</xsl:when>
					<xsl:when test = "string($mappedFromTable2/@migratedKey)">
						<xsl:value-of select = "$mappedFromTable2/@migratedKey"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>

			<xsl:choose>
				<xsl:when test = "string($mappableKey) and string($mapped)">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>false</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "isVTMappingMigratable">
	<xsl:param name = "node" select = "current()"/>
	<xsl:variable name = "KeycodeEntry" select = "$keycodeTable/Key[@VirtKey = $node/VKEY]"/>
	<xsl:variable name = "mappableKey">
		<xsl:choose>
			<xsl:when test = "string($KeycodeEntry/@migratedKey)">true</xsl:when>
		</xsl:choose>
	</xsl:variable>

	<xsl:choose>
		<xsl:when test = "($node/COMMAND_TYPE = 'Transmit Text') and string($mappableKey)">true</xsl:when>

		<xsl:when test = "($node/COMMAND_TYPE = 'Terminal Command') or 
					($node/COMMAND_TYPE = 'Menu Command')">

			<xsl:variable name = "keyTable" select = "msxsl:node-set($VTKeymapMappingTable)"/>
			<xsl:variable name = "TerminalkeyTable" select = "msxsl:node-set($VTTerminalKeyTable)"/>
			<xsl:variable name = "mappedFromTable1" select = "$keyTable/Mapping[@name = $node/MAPPING]"/>
			<xsl:variable name = "mappedFromTable2" select = "$TerminalkeyTable/Key[@name = $node/MAPPING]"/>

			<xsl:variable name = "mapped">
				<xsl:choose>
					<xsl:when test = "string($mappedFromTable1/@migratedCommand)">
						<xsl:value-of select = "$mappedFromTable1/@migratedCommand"/>
					</xsl:when>
					<xsl:when test = "string($mappedFromTable2/@migratedKey)">
						<xsl:value-of select = "$mappedFromTable2/@migratedKey"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>

			<xsl:choose>
				<xsl:when test = "string($mappableKey) and string($mapped)">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>false</xsl:otherwise>
	</xsl:choose>
</xsl:template>





<xsl:template name = "lineBreak">
	<xsl:text>&#10;</xsl:text>
</xsl:template>


<xsl:template name = "Spaces">
	<xsl:param name = "count"/>

	<xsl:if test = "$count &gt; 0">
		<xsl:text> </xsl:text>	
		<xsl:call-template name = "Spaces">
			<xsl:with-param name = "count">
				<xsl:value-of select = "$count - 1"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>


<xsl:template name = "isSourceXMLValid">
	<xsl:choose>
		<xsl:when test = "($XMLversion &gt; 1) and ($settingsMode = 'All') 			and
						  (($emulator = 1)	or ($emulator = 2) or ($emulator = 4)) 	and
						  ($settingsType = 'SETTINGS')								and
						  (name($root) = 'REFLECTION_SETTINGS')	
						  ">true</xsl:when>
		<xsl:when test = "($configType = 'keymap') and ($XMLversion &gt; 1) 		and 
						  (($emulator = 1)	or ($emulator = 2) or ($emulator = 4)) 	and
 						  (($settingsType ='KEYMAP') or ($settingsType='SETTINGS')) and
						  (name($root) = 'REFLECTION_SETTINGS')	
						  ">true</xsl:when>
		<xsl:otherwise></xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "reportBadSourceXML">
	<xsl:call-template name = "lineBreak"/>
   	<xsl:text>Transform Failure Report</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:choose>
		<xsl:when test = "not(name($root) = 'REFLECTION_SETTINGS')">
			<xsl:text>Source XML is not an exported Reflection Settings file.</xsl:text>
		</xsl:when>
		<xsl:when test = "$XMLversion &lt; 2">
			<xsl:text>This transform requires version 2.0 or greater exported Reflection Settings.</xsl:text>
		</xsl:when>
		<xsl:when test = "not($settingsMode = 'All')">
			<xsl:text>This transform requires a complete exported Reflection Settings file  (not just changed settings).</xsl:text>
		</xsl:when>
		<xsl:when test = "not($settingsType = 'SETTINGS')">
			<xsl:text>This transform requires a complete exported Reflection Settings file.</xsl:text>
		</xsl:when>
		<xsl:when test = "not(($emulator = 1) or ($emulator = 2) or ($emulator = 4))">
			<xsl:text>This transform requires an exported Reflection Settings file</xsl:text>
			<xsl:call-template name = "lineBreak"/>
			<xsl:text>from Reflection for HP, Unix and Digital, or ReGIS Graphics</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>Source XML is not an exported Reflection Settings file.</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
	<xsl:call-template name = "lineBreak"/>
	<xsl:text>As created by Reflection 10.0 or later.</xsl:text>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>


<xsl:template name="CountMigratableKeymappings">
	<xsl:variable name = "total">
		<xsl:call-template name = "MigratableKeymappings">
			<xsl:with-param name = "list" select="/REFLECTION_SETTINGS/KEYMAP/KEY_MAPPING"/>
		</xsl:call-template>
	</xsl:variable>
	<xsl:value-of select="$total"/>
</xsl:template>



<xsl:template name="MigratableKeymappings">
	<xsl:param name = "list"/>
	<xsl:param name = "count" select = "0"/>

	<xsl:variable name = "keycodeTable" select = "$PCkeycodeTable"/>
	<xsl:variable name = "modifierTable" select = "$ModifierTable"/>

	<xsl:choose>
		<xsl:when test="not($list)">
			<xsl:value-of select = "$count"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:variable name = "first" select = "$list[1]"/>
			<xsl:variable name = "KeycodeEntry" select = "$keycodeTable/Key[@VirtKey = $first/VKEY]"/>
			<xsl:variable name = "ModifierEntry" select = "$modifierTable/Key[@mods = $first/MODS]"/>
			<xsl:variable name = "migratedKey">
				<xsl:choose>
					<xsl:when test = "string($KeycodeEntry/@migratedKey)">
						<xsl:value-of select = "$KeycodeEntry/@migratedKey"/>
					</xsl:when>
					<xsl:otherwise>NotFound</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name = "migratedModifier">
				<xsl:choose>
					<xsl:when test = "$ModifierEntry/@migratedModifier">
						 <xsl:value-of select = "$ModifierEntry/@migratedModifier"/>
					</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name = "migratedMapping">
				<xsl:call-template name = "isMappingMigratable">
					<xsl:with-param name = "node" select = "$first"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:variable name = "migrated">
				<xsl:choose>
 					<xsl:when test = "not($migratedKey = 'NotFound') and (string($migratedMapping) = 'true')">1</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:call-template name = "MigratableKeymappings">
				<xsl:with-param name = "list" select = "$list[position() > 1]"/>
				<xsl:with-param name = "count" select = "$count + $migrated"/>
			</xsl:call-template>
 		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "terminalType">
	<xsl:choose>
		<xsl:when test = "$productType = 'HP'">
			<xsl:variable name = "PropertyEntry" select = 
		   		"$HPPropertyTable/Property[@name = 'TerminalType' and @container = 'com.wrq.session.Session']"/>
			<xsl:variable name = "migratedValue" 
				select = "$PropertyEntry/ENUMERATION[@value = $terminalType]/@migratedValue"/>
			<xsl:choose>
				<xsl:when test = "string($migratedValue)">
					<xsl:value-of select = "$migratedValue"/>
				</xsl:when>
				<xsl:otherwise>2392A</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>
			<xsl:variable name = "PropertyEntry" select = 
		   		"$VTPropertyTable/Property[@name = 'TerminalType' and @container = 'com.wrq.session.Session']"/>
			<xsl:variable name = "migratedValue" 
				select = "$PropertyEntry/ENUMERATION[@value = $terminalType]/@migratedValue"/>
			<xsl:choose>
				<xsl:when test = "string($migratedValue)">
					<xsl:value-of select = "$migratedValue"/>
				</xsl:when>
				<xsl:otherwise>VT400-8</xsl:otherwise>
			</xsl:choose>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name="countMigratableProperties">
	<xsl:param name = "ContainerName"/>

	<xsl:choose>
		<xsl:when test = "$productType = 'HP'">
		  	<xsl:call-template name = "MigratableProperties">
		  		<xsl:with-param name = "list" select="$properties/PROPERTY"/>
				<xsl:with-param name = "PropertyTable" select = "$HPPropertyTable"/>
		  		<xsl:with-param name = "ContainerName" select = "$ContainerName"/>
		  	</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
		  	<xsl:call-template name = "MigratableProperties">
		  		<xsl:with-param name = "list" select="$properties/PROPERTY"/>
				<xsl:with-param name = "PropertyTable" select = "$VTPropertyTable"/>
		  		<xsl:with-param name = "ContainerName"  select = "$ContainerName"/>
		  	</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name="MigratableProperties">
	<xsl:param name = "list"/>
	<xsl:param name = "PropertyTable"/>
	<xsl:param name = "ContainerName"/>
	<xsl:param name = "count" select = "0"/>

	<xsl:choose>
		<xsl:when test="not($list)">
			<xsl:value-of select = "$count"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:variable name = "current" select = "$list[1]"/>

			<xsl:variable name = "PropertyEntry" select = 
			   "$PropertyTable/Property[(@name = $current/@name) and (@container = $ContainerName)]"/>

			<xsl:variable name = "mappedCount" select = "count($PropertyEntry)"/>

			<xsl:call-template name = "MigratableProperties">
				<xsl:with-param name = "list" 			select = "$list[position() > 1]"/>
				<xsl:with-param name = "PropertyTable" 	select = "$PropertyTable"/>
				<xsl:with-param name = "ContainerName" 	select = "$ContainerName"/>
				<xsl:with-param name = "count" 			select = "$count + $mappedCount"/>
			</xsl:call-template>
 		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name = "isPropertyMigratable">
	<xsl:param name = "node" select = "current()"/>

	<xsl:choose>
		<xsl:when test = "$productType = 'HP'">
			<xsl:call-template name = "isHPPropertyMigratable">
				<xsl:with-param name = "node" select = "$node"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name = "isVTPropertyMigratable">
				<xsl:with-param name = "node" select = "$node"/>
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
 </xsl:template>


<xsl:template name = "isHPPropertyMigratable">
	<xsl:param name = "node" select = "current()"/>

	<xsl:variable name="PropertyEntry" select="$HPPropertyTable/Property[@name = $node/@name]"/>
	<xsl:choose>
		<xsl:when test = "$PropertyEntry">true</xsl:when>
		<xsl:otherwise>false</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name = "isVTPropertyMigratable">
	<xsl:param name = "node" select = "current()"/>
	<xsl:variable name="PropertyEntry" select="$VTPropertyTable/Property[@name = $node/@name]"/>
	<xsl:choose>
		<xsl:when test = "$PropertyEntry">true</xsl:when>
		<xsl:otherwise>false</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template match="text()|@*"/>



</xsl:stylesheet>


 