<?xml version="1.0"?>
<xsl:stylesheet	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="xml" indent="yes"/>


<!--  registry.xsl  Display All Reflection Registry Settings -->



<xsl:variable name = "total">
	<xsl:value-of select="count(/REFLECTION_SETTINGS/PROPERTIES/PROPERTY/REGISTRY_MODE)"/>
</xsl:variable>



<xsl:template match="/">

	<HTML>
	<HEAD>
		<TITLE>Reflection Registry Settings</TITLE>
	</HEAD>
	<BODY>
		<P><H2>Reflection Registry Settings</H2></P>
		<xsl:apply-templates/>
	</BODY>
	</HTML>
</xsl:template>


<xsl:template match="CREATOR" >
  <xsl:value-of select="@product"/> 
   version 
  <xsl:value-of select="@version"/>
   build
  <xsl:value-of select="@build"/> 
</xsl:template>



<xsl:template match="TYPE" >
	(<xsl:value-of select="."/>)
</xsl:template>


<xsl:template match="PROPERTIES" >
	<xsl:choose>
		<xsl:when test="$total > 0">
			<P/>
			<table border="3" cellpadding="3">
				<thead>
					<tr><xsl:value-of select="$total"/> Registry Settings</tr>
				</thead>
				<th align="center"><b>Property</b></th>
				<th align="center"><b>Value</b></th>
				<xsl:apply-templates select="PROPERTY">
					<xsl:sort select="@name"/>
				</xsl:apply-templates>
			</table>
		</xsl:when>
		<xsl:otherwise>
			<P><I>All Properties are at defaults</I></P>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="PROPERTY">
	
	<xsl:if test = "count(REGISTRY_MODE) &gt; 0">
		<tr>
			<td><xsl:value-of select="@name"/></td>
	   		<xsl:call-template name="PROPERTY_TYPE"/>
		</tr>
	</xsl:if>
</xsl:template>

<xsl:template name="PROPERTY_TYPE">
	<xsl:choose>
		<xsl:when test = "count(BOOLEAN) &gt; 0">
			<td><xsl:value-of select="BOOLEAN"/></td>
		</xsl:when>
		<xsl:when test = "count(INTEGER) &gt; 0">
			<td><xsl:value-of select="INTEGER"/></td>
		</xsl:when>
		<xsl:when test = "count(ENUMERATION) &gt; 0">
			<td><xsl:value-of select="ENUMERATION"/></td>
		</xsl:when>
		<xsl:when test = "count(CHARACTER) &gt; 0">
			<xsl:choose>
			   <xsl:when test = "count(CHARACTER/@ctrl) &gt; 0">
					<td><xsl:value-of select="CHARACTER/@ctrl"/></td>
			   </xsl:when>
				<xsl:when test = "CHARACTER=''">
					<td> (not set) </td>
				</xsl:when>
				<xsl:otherwise>
					<td><xsl:value-of select="CHARACTER"/></td>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:when test = "count(STRING) &gt; 0">
			<xsl:choose>
				<xsl:when test = "STRING=''">
					<td> (empty string) </td>
				</xsl:when>
				<xsl:otherwise>
					<td><xsl:value-of select="STRING"/></td>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>

		<xsl:when test = "count(FOLDER) &gt; 0">
			<xsl:choose>
				<xsl:when test = "FOLDER=''">
					<td> (empty folder name) </td>
				</xsl:when>
				<xsl:otherwise>
					<td><xsl:value-of select="FOLDER"/></td>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:when test = "count(FILE) &gt; 0">
			<xsl:choose>
				<xsl:when test = "FILE=''">
					<td> (empty filename) </td>
				</xsl:when>
				<xsl:otherwise>
					<td><xsl:value-of select="FILE"/></td>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>

		<xsl:otherwise>
			<td>unknown type</td>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>



<xsl:template name="COUNT_REGISTRY_PROPERTIES">
	<xsl:variable name = "total">
		<xsl:call-template name = "TOTAL_REGISTRY_PROPERTIES">
			<xsl:with-param name = "list" select="/PROPERTIES/PROPERTY/REGISTRY_MODE"/>
		</xsl:call-template>
	</xsl:variable>

	<H3><xsl:value-of select="$total"/> Property Settings (with VB Properties)</H3>
</xsl:template>


<xsl:template name="TOTAL_REGISTRY_PROPERTIES">
	<xsl:param name = "list"/>

	<xsl:choose>
		<xsl:when test="$list">
			<xsl:variable name = "first" select = "$list[1]"/>

			<xsl:variable name = "remaining">
				<xsl:call-template name = "TOTAL_REGISTRY_PROPERTIES">
					<xsl:with-param name = "list" select = "$list[position()!=1]"/>
				</xsl:call-template>
			</xsl:variable>

			<xsl:choose>
				<xsl:when test = "count($first) = 0">
					<xsl:value-of select = "1 + $remaining"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select = "0 + $remaining"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>0</xsl:otherwise>
	</xsl:choose>

</xsl:template>




<xsl:template match="text()|@*"/>


</xsl:stylesheet>

