<?xml version="1.0"?>
<xsl:stylesheet	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<!--
<xsl:output method="text" indent="yes" standalone = "yes" encoding = "iso-8859-1"/>
-->
<xsl:output method="text" indent="yes" standalone = "yes" encoding = "UTF-16"/>


<!--  regtext.xsl  Display All Reflection Registry Settings and their registry hives -->



<xsl:variable name = "total">
	<xsl:value-of select="count(/REFLECTION_SETTINGS/PROPERTIES/PROPERTY/REGISTRY_MODE)"/>
</xsl:variable>



<xsl:template match="/">
	<xsl:call-template name = "lineBreak"/>
	<xsl:text>Reflection Registry Settings</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:apply-templates/>
	<xsl:call-template name = "hives"/>
</xsl:template>


<xsl:template match="PROPERTIES" >
	<xsl:call-template name = "lineBreak"/>
	<xsl:choose>
		<xsl:when test="$total > 0">
			<xsl:call-template name = "lineBreak"/>
			<xsl:value-of select="$total"/>
			<xsl:text> Registry Settings</xsl:text>
			<xsl:call-template name = "lineBreak"/>
			<xsl:call-template name = "lineBreak"/>
			<xsl:text>PROPERTY                        VALUE</xsl:text>
			<xsl:call-template name = "lineBreak"/>
			<xsl:call-template name = "lineBreak"/>
			<xsl:apply-templates select="PROPERTY">
				<xsl:sort select="@name"/>
			</xsl:apply-templates>
			<xsl:call-template name = "lineBreak"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>All Properties are at defaults</xsl:text>
			<xsl:call-template name = "lineBreak"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template match="PROPERTY">
	<xsl:variable name = "namelgth">
		<xsl:value-of select="string-length(@name)"/>
	</xsl:variable>
	<xsl:variable name = "padding">
		<xsl:choose>
			<xsl:when test="$namelgth &gt; 32">
				<xsl:value-of select="1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="32-$namelgth"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:if test = "count(REGISTRY_MODE) &gt; 0">
			<xsl:value-of select="@name"/>
			<xsl:call-template name = "Spaces">
				<xsl:with-param name = "count"><xsl:value-of select="$padding"/></xsl:with-param>
			</xsl:call-template>
	   		<xsl:call-template name="PROPERTY_TYPE"/>
			<xsl:call-template name = "lineBreak"/>
	</xsl:if>
</xsl:template>

<xsl:template name="PROPERTY_TYPE">
	<xsl:choose>
		<xsl:when test = "count(BOOLEAN) &gt; 0">
			<xsl:value-of select="BOOLEAN"/>
		</xsl:when>
		<xsl:when test = "count(INTEGER) &gt; 0">
			<xsl:value-of select="INTEGER"/>
		</xsl:when>
		<xsl:when test = "count(ENUMERATION) &gt; 0">
			<xsl:value-of select="ENUMERATION"/>
		</xsl:when>
		<xsl:when test = "count(CHARACTER) &gt; 0">
			<xsl:choose>
			   <xsl:when test = "count(CHARACTER/@ctrl) &gt; 0">
					<xsl:value-of select="CHARACTER/@ctrl"/>
			   </xsl:when>
				<xsl:when test = "CHARACTER=''">
					<xsl:text> (not set) </xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="CHARACTER"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:when test = "count(STRING) &gt; 0">
			<xsl:choose>
				<xsl:when test = "STRING=''">
					<xsl:text>(empty string) </xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="STRING"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>

		<xsl:when test = "count(FOLDER) &gt; 0">
			<xsl:choose>
				<xsl:when test = "FOLDER=''">
					<xsl:text>(empty folder name) </xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="FOLDER"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:when test = "count(FILE) &gt; 0">
			<xsl:choose>
				<xsl:when test = "FILE=''">
					<xsl:text>(empty filename) </xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="FILE"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>

		<xsl:otherwise>
			<xsl:text>unknown type</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>



<xsl:template name="COUNT_REGISTRY_PROPERTIES">
	<xsl:variable name = "total">
		<xsl:call-template name = "TOTAL_REGISTRY_PROPERTIES">
			<xsl:with-param name = "list" select="/REFLECTION_SETTINGS/PROPERTIES/PROPERTY/REGISTRY_MODE"/>
		</xsl:call-template>
	</xsl:variable>

	<H3><xsl:value-of select="$total"/> Registry Settings (with VB Properties)</H3>
</xsl:template>


<xsl:template name="TOTAL_REGISTRY_PROPERTIES">
	<xsl:param name = "list"/>

	<xsl:choose>
		<xsl:when test="$list">
			<xsl:variable name = "first" select = "$list[1]"/>

			<xsl:variable name = "remaining">
				<xsl:call-template name = "TOTAL_REGISTRY_PROPERTIES">
					<xsl:with-param name = "list" select = "$list[position()!=1]"/>
				</xsl:call-template>
			</xsl:variable>

			<xsl:choose>
				<xsl:when test = "count($first) = 0">
					<xsl:value-of select = "1 + $remaining"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select = "0 + $remaining"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>0</xsl:otherwise>
	</xsl:choose>

</xsl:template>


<xsl:template name = "lineBreak">
	<xsl:text>&#10;</xsl:text>
</xsl:template>


<xsl:template name = "Spaces">
	<xsl:param name = "count"/>

	<xsl:if test = "$count &gt; 0">
		<xsl:text> </xsl:text>	
		<xsl:call-template name = "Spaces">
			<xsl:with-param name = "count">
				<xsl:value-of select = "$count - 1"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>


<xsl:template name ="hives">
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:text>PROPERTY                        REGISTRY HIVE</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>

	<xsl:for-each select = "/REFLECTION_SETTINGS/PROPERTIES/PROPERTY">
		<xsl:sort select = "@name"/>
		<xsl:variable name = "namelgth">
			<xsl:value-of select="string-length(@name)"/>
		</xsl:variable>
		<xsl:variable name = "padding">
			<xsl:choose>
				<xsl:when test="$namelgth &gt; 32">
					<xsl:value-of select="1"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="32-$namelgth"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:if test = "count(REGISTRY_MODE) &gt; 0">
				<xsl:value-of select="@name"/>
				<xsl:call-template name = "Spaces">
					<xsl:with-param name = "count"><xsl:value-of select="$padding"/></xsl:with-param>
				</xsl:call-template>
				<xsl:value-of select="REGISTRY_KEY"/>
				<xsl:call-template name = "lineBreak"/>
		</xsl:if>
	</xsl:for-each>
</xsl:template>



<xsl:template match="text()|@*"/>


</xsl:stylesheet>

