<?xml version="1.0"?>
<xsl:stylesheet	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
				xmlns:msxsl="urn:schemas-microsoft-com:xslt"
				xmlns:exsl="http://exslt.org/common" 
				xmlns:ext="urn:rwin-rweb-scripts"
				exclude-result-prefixes="msxsl exsl ext">


<xsl:output method="xml" encoding = "UTF-8" standalone = "yes" indent = "no"/>



<!--  rweb60.xsl  Transform Reflection Settings to Reflection for the Web 6.0 config file -->



<xsl:variable name = "transformVersion" select = "2.0"/>




<xsl:param name = "type"/>
<xsl:variable name = "configType"> 
	<xsl:choose>
		<xsl:when test = "translate($type,
									'ABCDEFGHIJKLMNOPQRSTUVWXYZ',
									'abcdefghijklmnopqrstuvwxyz') = 'keymap'">keymap</xsl:when>
		<xsl:otherwise>config</xsl:otherwise>
	</xsl:choose>
</xsl:variable>







<!-- Property Migration Tables -->

<xsl:variable name = "HP_PropertyTable">
	<!--  Enumeration Properties  -->
	<Property name = "CursorShape" migratedName = "cursorShape" container = "com.wrq.session.tisb.HPTISB" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcBlock" 				migratedValue = "0"/>
		<ENUMERATION value = "rcUnderline" 			migratedValue = "1"/>
		<ENUMERATION value = "rcVerticalBar" 		migratedValue = "0"/>
	</Property>
	<Property name = "PrimaryStatusResponse" migratedName = "displayMemoryResponse" container = "com.wrq.hp.HP" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rc4k" 				migratedValue = "0"/>
		<ENUMERATION value = "rc8k" 				migratedValue = "1"/>
		<ENUMERATION value = "rc12k" 				migratedValue = "2"/>
		<ENUMERATION value = "rc15k" 				migratedValue = "3"/>
	</Property>
	<Property name = "FunctionKeySet" migratedName = "functionKeySet" container = "com.wrq.hp.HP" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcUser" 				migratedValue = "6"/>  
		<ENUMERATION value = "rcModes" 				migratedValue = "4"/>  
		<ENUMERATION value = "rcDeviceControl" 		migratedValue = "0"/>  
		<ENUMERATION value = "rcDeviceModes" 		migratedValue = "1"/>  
		<ENUMERATION value = "rcToDevices" 			migratedValue = "0"/>  
		<ENUMERATION value = "rcEnhanceVideo" 		migratedValue = "7"/>  
		<ENUMERATION value = "rcDefineField" 		migratedValue = "2"/>  
	</Property>
	<Property name = "TerminalType" migratedName = "termtype" container = "com.wrq.hp.HP" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcHP2392A" 			migratedValue = "0"/>
		<ENUMERATION value = "rcHP70092" 			migratedValue = "1"/>
		<ENUMERATION value = "rcHP70094" 			migratedValue = "2"/>
		<ENUMERATION value = "rcVT52" 				migratedValue = "3"/>
		<ENUMERATION value = "rcVT102" 				migratedValue = "4"/>
		<ENUMERATION value = "rcVT220_7" 			migratedValue = "5"/>
		<ENUMERATION value = "rcVT220_8" 			migratedValue = "6"/>
	</Property>
	<Property name = "HostCharacterSet" migratedName = "hostCharSet" container = "com.wrq.hp.HP" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcDECSupplemental" 	migratedValue = "0"/>
		<ENUMERATION value = "rcHPRoman9" 			migratedValue = "1"/>
		<ENUMERATION value = "other" 				migratedValue = "0"/>
	</Property>
	<Property name = "NationalReplacementSet" migratedName = "NRCS" container = "com.wrq.hp.HP" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcNone" 				migratedValue = "0"/>
		<ENUMERATION value = "rcBritish" 			migratedValue = "16"/>
		<ENUMERATION value = "rcFrench" 			migratedValue = "5"/>
		<ENUMERATION value = "rcGerman" 			migratedValue = "10"/>
		<ENUMERATION value = "rcItalian" 			migratedValue = "11"/>
		<ENUMERATION value = "rcNorwegian" 			migratedValue = "12"/>
		<ENUMERATION value = "rcDanish" 			migratedValue = "2"/>
		<ENUMERATION value = "rcSwedish" 			migratedValue = "15"/>
		<ENUMERATION value = "rcDutch" 				migratedValue = "3"/>
		<ENUMERATION value = "rcSwissGerman" 		migratedValue = "9"/>
		<ENUMERATION value = "rcEuropeanSpanish" 	migratedValue = "13"/>
		<ENUMERATION value = "rcLatinSpanish" 		migratedValue = "13"/>
		<ENUMERATION value = "rcPortuguese" 		migratedValue = "14"/>
		<ENUMERATION value = "rcFinnish" 			migratedValue = "4"/>
		<ENUMERATION value = "rcCanadianEnglish" 	migratedValue = "6"/>
		<ENUMERATION value = "rcFlemish" 		 	migratedValue = "1"/>
		<ENUMERATION value = "rcCanadianFrench"  	migratedValue = "7"/>
		<ENUMERATION value = "rcSwissFrench" 	 	migratedValue = "8"/>
		<ENUMERATION value = "other" 	 			migratedValue = "0"/>
	</Property>
	<Property name = "HPDataSpeedSelect" migratedName = "highDataSpeed" container = "com.wrq.hp.HP" sourcetype = "ENUMERATION" type = "BOOLEAN">
		<ENUMERATION value = "LO" 	 				migratedValue = "false"/>
		<ENUMERATION value = "HI" 	 				migratedValue = "true"/>
	</Property>
	<Property name = "HPTerminalType" migratedName = "terminalIdResponse" container = "com.wrq.hp.HP" sourcetype = "ENUMERATION" type = "STRING">
		<ENUMERATION value = "HP2392A" 				migratedValue = "HP2392A"/>
		<ENUMERATION value = "HP70092" 				migratedValue = "HP70092"/>
		<ENUMERATION value = "HP70094" 				migratedValue = "HP70094"/>
	</Property>
	<Property name = "JumpScrollSpeed" migratedName = "jumpScrollSpeed" container = "com.wrq.session.tisb.HPTISB" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcUnlimitedScroll" 	migratedValue = "-2"/>
		<ENUMERATION value = "rcScrollByPage" 		migratedValue = "-3"/>
		<ENUMERATION value = "rcScrollBy1" 			migratedValue = "1"/>
		<ENUMERATION value = "rcScrollBy2" 			migratedValue = "2"/>
		<ENUMERATION value = "rcScrollBy4" 			migratedValue = "4"/>
		<ENUMERATION value = "rcScrollBy8" 			migratedValue = "8"/>
		<ENUMERATION value = "rcScrollBy16" 		migratedValue = "16"/>
		<ENUMERATION value = "rcScrollBy32" 		migratedValue = "32"/>
		<ENUMERATION value = "rcScrollBy64" 		migratedValue = "64"/>
		<ENUMERATION value = "rcScrollBy128" 		migratedValue = "128"/>
	</Property>
	<Property name = "TerminalClass" migratedName = "terminalType" container = "com.wrq.session.Session" sourcetype = "ENUMERATION" type = "STRING">
		<ENUMERATION value = "rcHP" 				migratedValue = "hp"/>
		<ENUMERATION value = "rcDEC" 				migratedValue = "vt"/>
	</Property>
	<Property name = "StartupAction" migratedName = "autoconnect" container = "com.wrq.session.Session" sourcetype = "ENUMERATION" type = "BOOLEAN">
		<ENUMERATION value = "rcAutoConnect" 		migratedValue = "true"/>
		<ENUMERATION value = "rcNoConnect" 			migratedValue = "false"/>
		<ENUMERATION value = "other" 	 			migratedValue = "false"/>
	</Property>
	<Property name = "TerminalType" migratedName = "terminalModel" container = "com.wrq.session.Session" sourcetype = "ENUMERATION" type = "STRING">
		<ENUMERATION value = "rcHP2392A" 			migratedValue = "2392A"/>
		<ENUMERATION value = "rcHP70092" 			migratedValue = "70092"/>
		<ENUMERATION value = "rcHP70094" 			migratedValue = "70094"/>
		<ENUMERATION value = "rcVT52" 				migratedValue = "VT102"/>
		<ENUMERATION value = "rcVT102" 				migratedValue = "VT102"/>
		<ENUMERATION value = "rcVT220_7" 			migratedValue = "VT220"/>
		<ENUMERATION value = "other" 				migratedValue = "VT220"/>
	</Property>
	<Property name = "FormatModeTransmits" migratedName = "transmitModified" container = "com.wrq.hp.HP" sourcetype = "ENUMERATION" type = "BOOLEAN">
		<ENUMERATION value = "rcAllFields" 			migratedValue = "false"/>
		<ENUMERATION value = "rcModifiedFields"		migratedValue = "true"/>
		<ENUMERATION value = "other" 	 			migratedValue = "false"/>
	</Property>

	<!--  Boolean Properties  -->
	<Property name = "AutoFormFeed" migratedName = "doFormFeeds" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "AutoLineFeed" migratedName = "AutoLineFeed" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "BlockMode" migratedName = "blockMode" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "CapsLockMode" migratedName = "capsLockMode" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "ConfigurationLocked" migratedName = "configLocked" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "DestructiveBackspace" migratedName = "destructiveBackspace" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "EnqAck" migratedName = "enqAck" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "InhibitHandshake" migratedName = "inhibitHandshake" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "InhibitDC2" migratedName = "inhibitDC2" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "InverseVideo" migratedName = "inverseVideo" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "LocalEcho" migratedName = "localEcho" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "MarginBell" migratedName = "marginBell" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "ReturnEqualsEnter" migratedName = "returnEqualsEnter" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "ShowFunctionKeys" migratedName = "showFunctionKeys" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "ShowStatusBar" migratedName = "showStatusLine" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "SPOW" migratedName = "spowEnabled" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "TerminalEscapeTransfer" migratedName = "escapeXfer" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "TerminalModifyAll" migratedName = "modifyAll" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "TypeAhead" migratedName = "typeahead" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "TransmitFunctions" migratedName = "transmitFunctions" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "HPUseHostPrompt" migratedName = "useHostPrompt" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "UserFeaturesLocked" migratedName = "userFeaturesLocked" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "Bell" migratedName = "warningBell" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "PrinterColumnsTiedToDisplay" migratedName = "printerColumnsTiedToDisplay" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "SmoothScroll" migratedName = "smoothScrollHP" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "SmoothScroll" migratedName = "smoothScroll" container = "com.wrq.session.tisb.HPTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "CursorBlink" migratedName = "cursorBlinks" container = "com.wrq.session.tisb.HPTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "CursorVisible" migratedName = "cursorVisible" container = "com.wrq.session.tisb.HPTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "InverseVideo" migratedName = "fgAndBgAreSwapped" container = "com.wrq.session.tisb.HPTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "ShowToolbar" migratedName = "toolbarVisible" container = "MapperEngine-1" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "ShowTerminalKeyboard" migratedName = "terminalKeyboardVisible" container = "MapperEngine-1" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "SlashZeros" migratedName = "slashedZero" container = "com.wrq.display.HPTD" type = "BOOLEAN" noValueMigration = "true"/>

	<!--
	<Property name = "PrinterFitFontToPage" migratedName = "fitToPage" container = "PrinterService" type = "BOOLEAN" noValueMigration = "true"/>
	-->

	<!--  Character Properties  -->
	<Property name = "BlockTerminator" migratedName = "blockTerminator" container = "com.wrq.hp.HP" sourcetype = "CHARACTER" type = "INTEGER" charToIntMigration = "true"/>
	<Property name = "FieldSeparator" migratedName = "fieldSeparator" container = "com.wrq.hp.HP" sourcetype = "CHARACTER" type = "INTEGER" charToIntMigration = "true"/>
	<Property name = "HostTriggerCharacter" migratedName = "hostPromptCharacter" container = "com.wrq.hp.HP" sourcetype = "CHARACTER" type = "INTEGER" charToIntMigration = "true"/>

	<!--  Integer Properties  -->
	<Property name = "DisplayColumns" migratedName = "screenColumns" container = "com.wrq.hp.HP" type = "INTEGER" specialcase = "true"/>
	<Property name = "DisplayRows" migratedName = "screenRows" container = "com.wrq.hp.HP" type = "INTEGER" noValueMigration = "true"/>
	<Property name = "FormsBufferSize" migratedName = "formsBufferSize" container = "com.wrq.hp.HP" type = "INTEGER" noValueMigration = "true"/>
	<Property name = "StartColumn" migratedName = "startColumn" container = "com.wrq.hp.HP" type = "INTEGER" noValueMigration = "true"/>
	<Property name = "PasteDelay" migratedName = "pasteDelay" container = "com.wrq.hp.HP" type = "INTEGER" noValueMigration = "true"/>
	<Property name = "SpacesPerTab" migratedName = "tabDefinition" container = "com.wrq.hp.HP" type = "INTEGER" noValueMigration = "true"/>
	<!--
	<Property name = "PrinterTimeout" migratedName = "printJobTerminationDelay" container = "PrinterService" type = "INTEGER" noValueMigration = "true"/>
	-->

	<!--  String Properties  -->
	<Property name = "ReturnDefinition" migratedName = "returnDefinition" container = "com.wrq.hp.HP" type = "STRING" noValueMigration = "false"/>

</xsl:variable>



<xsl:variable name = "VT_PropertyTable">
	<!--  Enumeration Properties  -->
	<Property name = "CursorShape" migratedName = "cursorShape" container = "com.wrq.session.tisb.VTTISB" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcBlock" 				migratedValue = "0"/>
		<ENUMERATION value = "rcUnderline" 			migratedValue = "1"/>
		<ENUMERATION value = "rcVerticalBar" 	 	migratedValue = "0"/>
	</Property>
	<Property name = "DAResponse" migratedName = "daResponse" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcVT100" 				migratedValue = "1"/>
		<ENUMERATION value = "rcVT101" 				migratedValue = "2"/>
		<ENUMERATION value = "rcVT102" 				migratedValue = "3"/>
		<ENUMERATION value = "rcVT220" 				migratedValue = "4"/>
		<ENUMERATION value = "rcVT320" 				migratedValue = "5"/>
		<ENUMERATION value = "rcVT420" 				migratedValue = "6"/>
		<ENUMERATION value = "rcVTWRQID" 			migratedValue = "0"/>
		<ENUMERATION value = "rcVT80" 				migratedValue = "1"/>
		<ENUMERATION value = "rcVT100J"   			migratedValue = "1"/>
		<ENUMERATION value = "rcVT102J"   			migratedValue = "3"/>
		<ENUMERATION value = "rcVT220J"   			migratedValue = "4"/>
		<ENUMERATION value = "rcVT282J"   			migratedValue = "4"/>
		<ENUMERATION value = "rcVT382J"   			migratedValue = "5"/>
		<ENUMERATION value = "rcVT510" 				migratedValue = "6"/>
		<ENUMERATION value = "rcVT282" 				migratedValue = "4"/>
		<ENUMERATION value = "rcVT382" 				migratedValue = "4"/>
	</Property>
	<Property name = "TerminalType" migratedName = "termtype" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcVT52" 			 	migratedValue = "0"/>
		<ENUMERATION value = "rcVT102" 			 	migratedValue = "1"/>
		<ENUMERATION value = "rcVT400_7" 			migratedValue = "2"/>
		<ENUMERATION value = "rcVT400_8" 			migratedValue = "3"/>
		<ENUMERATION value = "other" 				migratedValue = "2"/>
	</Property>
	<Property name = "TerminalType" migratedName = "7Bit" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "BOOLEAN">
		<ENUMERATION value = "rcVT52" 				migratedValue = "true"/>
		<ENUMERATION value = "rcVT102" 				migratedValue = "true"/>
		<ENUMERATION value = "rcVT400_7" 			migratedValue = "false"/>
		<ENUMERATION value = "rcVT400_8" 			migratedValue = "false"/>
		<ENUMERATION value = "other" 				migratedValue = "false"/>
	</Property>
	<Property name = "HostCharacterSet" migratedName = "decaupss" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcDECSupplemental" 	migratedValue = "0"/>
		<ENUMERATION value = "rcISOLatin_1" 		migratedValue = "1"/>
		<ENUMERATION value = "rcISOLatin_2" 		migratedValue = "2"/>
		<ENUMERATION value = "rcISOLatin_5" 		migratedValue = "3"/>
		<ENUMERATION value = "rcISOLatin_9" 		migratedValue = "4"/>
		<ENUMERATION value = "other" 				migratedValue = "1"/>
	</Property>
	<Property name = "NationalReplacementSet" migratedName = "nrcSet" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcNone" 				migratedValue = "0"/>
		<ENUMERATION value = "rcBritish" 			migratedValue = "1"/>
		<ENUMERATION value = "rcFrench" 			migratedValue = "4"/>
		<ENUMERATION value = "rcGerman" 			migratedValue = "5"/>
		<ENUMERATION value = "rcItalian" 			migratedValue = "6"/>
		<ENUMERATION value = "rcNorwegian" 			migratedValue = "7"/>
		<ENUMERATION value = "rcDanish" 			migratedValue = "7"/>
		<ENUMERATION value = "rcSwedish" 			migratedValue = "10"/>
		<ENUMERATION value = "rcDutch" 				migratedValue = "7"/>
		<ENUMERATION value = "rcSwissGerman" 		migratedValue = "11"/>
		<ENUMERATION value = "rcEuropeanSpanish"	migratedValue = "8"/>
		<ENUMERATION value = "rcLatinSpanish" 		migratedValue = "8"/>
		<ENUMERATION value = "rcPortuguese" 		migratedValue = "9"/>
		<ENUMERATION value = "rcFinnish" 			migratedValue = "3"/>
		<ENUMERATION value = "rcCanadianEnglish" 	migratedValue = "2"/>
		<ENUMERATION value = "rcFlemish" 			migratedValue = "7"/>
		<ENUMERATION value = "rcCanadianFrench" 	migratedValue = "2"/>
		<ENUMERATION value = "rcSwissFrench" 		migratedValue = "11"/>
	</Property>
	<Property name = "JumpScrollSpeed" migratedName = "jumpScrollSpeed" container = "com.wrq.session.tisb.VTTISB" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcUnlimitedScroll" 	migratedValue = "-2"/>
		<ENUMERATION value = "rcScrollByPage" 		migratedValue = "-3"/>
		<ENUMERATION value = "rcScrollBy1" 			migratedValue = "1"/>
		<ENUMERATION value = "rcScrollBy2" 			migratedValue = "2"/>
		<ENUMERATION value = "rcScrollBy4" 			migratedValue = "4"/>
		<ENUMERATION value = "rcScrollBy8" 			migratedValue = "8"/>
		<ENUMERATION value = "rcScrollBy16" 		migratedValue = "16"/>
		<ENUMERATION value = "rcScrollBy32" 		migratedValue = "32"/>
		<ENUMERATION value = "rcScrollBy64" 		migratedValue = "64"/>
		<ENUMERATION value = "rcScrollBy128" 		migratedValue = "128"/>
	</Property>
	<Property name = "TerminalClass" migratedName = "terminalType" container = "com.wrq.session.Session" sourcetype = "ENUMERATION" type = "STRING">
		<ENUMERATION value = "rcHP" 				migratedValue = "hp"/>
		<ENUMERATION value = "rcDEC" 				migratedValue = "vt"/>
	</Property>
	<Property name = "StartupAction" migratedName = "autoconnect" container = "com.wrq.session.Session" sourcetype = "ENUMERATION" type = "BOOLEAN">
		<ENUMERATION value = "rcAutoConnect" 		migratedValue = "true"/>
		<ENUMERATION value = "rcNoConnect" 			migratedValue = "true"/>
		<ENUMERATION value = "other" 			 	migratedValue = "false"/>
	</Property>
	<Property name = "TerminalType" migratedName = "terminalModel" container = "com.wrq.session.Session" sourcetype = "ENUMERATION" type = "STRING">
		<ENUMERATION value = "rcVT52" 				migratedValue = "VT52"/>
		<ENUMERATION value = "rcVT102" 				migratedValue = "VT102"/>
		<ENUMERATION value = "rcVT400_7" 			migratedValue = "VT400-7"/>
		<ENUMERATION value = "rcVT400_8" 			migratedValue = "VT400-8"/>
		<ENUMERATION value = "other" 				migratedValue = "VT400-7"/>
	</Property>
	<Property name = "HostStatusLine" migratedName = "decssdt" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcNoStatusLine"  		migratedValue = "0"/>
		<ENUMERATION value = "rcIndicator" 			migratedValue = "1"/>
		<ENUMERATION value = "rcHostWritable"		migratedValue = "2"/>
	</Property>
	<Property name = "VTBackspaceSends" migratedName = "decbkm" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "BOOLEAN">
		<ENUMERATION value = "rcDeleteKey"  		migratedValue = "false"/>
		<ENUMERATION value = "rcBackspaceKey" 		migratedValue = "true"/>
	</Property>
	<Property name = "VTCursorKeyMode" migratedName = "decckm" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "BOOLEAN">
		<ENUMERATION value = "rcNormalMode"  		migratedValue = "false"/>
		<ENUMERATION value = "rcApplicationMode" 	migratedValue = "true"/>
	</Property>
	<Property name = "VTKeypadMode" migratedName = "decnkm" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "BOOLEAN">
		<ENUMERATION value = "rcNumericMode"  		migratedValue = "false"/>
		<ENUMERATION value = "rcApplicationMode" 	migratedValue = "true"/>
	</Property>

	<!--  Boolean Properties  -->
	<Property name = "AutoRepeat" migratedName = "decarm" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "AutoAnswerback" migratedName = "decaam" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "AnswerbackConcealed" migratedName = "deccansm" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "AutoLineFeed" migratedName = "lnm" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "BreakEnabled" migratedName = "breakEnabled" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "EndOfLineWrap" migratedName = "decawm" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "MarginBell" migratedName = "marginBell" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "ShowStatusBar" migratedName = "showStatusLine" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "UserFeaturesLocked" migratedName = "userLock" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "Bell" migratedName = "warningBell" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "SmoothScroll" migratedName = "smoothScroll" container = "com.wrq.session.tisb.VTTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "SmoothScroll" migratedName = "decsclm" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "CursorBlink" migratedName = "cursorBlinks" container = "com.wrq.session.tisb.VTTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "CursorVisible" migratedName = "cursorVisible" container = "com.wrq.session.tisb.VTTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "LocalEcho" migratedName = "srm" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "false"/>
	<Property name = "Online" migratedName = "onLine" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "PrinterColumnsTiedToDisplay" migratedName = "printerColumnsTiedToDisplay" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "InverseVideo" migratedName = "fgAndBgAreSwapped" container = "com.wrq.session.tisb.VTTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "PreserveNRC" migratedName = "preserveNRC" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "UseNRC" migratedName = "decnrcm" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "SaveFromScrollingRegion" migratedName = "saveFromScrollingRegion" container = "com.wrq.session.tisb.VTTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "NewPageOnClear" migratedName = "saveBeforeClearing" container = "com.wrq.session.tisb.VTTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "UseNRC" migratedName = "nrcsActive" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "InverseVideo" migratedName = "decscnm" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "SlashZeros" migratedName = "slashedZero" container = "com.wrq.display.VTTD" type = "BOOLEAN" noValueMigration = "true"/>

   	<!--  Integer Properties  -->
	<Property name = "DisplayColumns" migratedName = "deccolm" container = "com.wrq.vt.VT" sourcetype = "INTEGER" type = "BOOLEAN" specialcase = "true"/>
	<Property name = "DisplayRows" migratedName = "decslpp" container = "com.wrq.vt.VT" type = "INTEGER" noValueMigration = "true"/>
	<Property name = "DisplayRows" migratedName = "decsnls" container = "com.wrq.vt.VT" type = "INTEGER" noValueMigration = "true"/>
	<Property name = "PasteDelay" migratedName = "pasteDelay" container = "com.wrq.vt.VT" type = "INTEGER" noValueMigration = "true"/>

	<!--  String Properties  -->
	<Property name = "Answerback" migratedName = "declans" container = "com.wrq.vt.VT" type = "STRING" noValueMigration = "false"/>

</xsl:variable>



<xsl:variable name = "Transport_PropertyTable">
	<!--  Boolean Properties  -->
	<Property name = "UseTLS" 				migratedName = "encryptStream" 		container = "com.wrq.session.transport.TransportOptions" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "UseRwebSecurityProxy" migratedName = "securityEnabled" 	container = "com.wrq.session.transport.TransportOptions" type = "BOOLEAN" noValueMigration = "true"/>

	<!--  String Properties  -->
	<Property name = "UserName" 			migratedName = "sshUser" 			container = "com.wrq.session.transport.TransportOptions" type = "STRING" noValueMigration = "true"/>
</xsl:variable>



<!-- Keymap Migration Tables -->


<!-- HP Mapping Migration Table -->
<xsl:variable name = "HPKeymapMappingTable">
	<!--  Menu Commands  -->
	<Mapping name = "EditSelectAll"			migratedCommand = "Glue.selectAll"/>
	<Mapping name = "ConnectionConnect" 	migratedCommand = "ISession.connect"/>
	<Mapping name = "ConnectionDisconnect" 	migratedCommand = "ISession.disconnect"/>
	<Mapping name = "Disconnect" 			migratedCommand = "ISession.disconnect"/>
	<Mapping name = "HelpAboutReflection" 	migratedCommand = "Glue.aboutBoxDialog"/>
	<Mapping name = "EditCopy" 				migratedCommand = "Glue.copy"/>
	<Mapping name = "EditPaste" 			migratedCommand = "Glue.paste"/>
<!--
	<Mapping name = "EditClearDisplay" 		migratedCommand = "HP.clearDisplay"/>
	<Mapping name = "HpClearDisplay" 		migratedCommand = "HP.clearDisplay"/>
-->
	<Mapping name = "FileClosePrinter" 		migratedCommand = "HP.closePrinter"/>
	<Mapping name = "FilePrint" 			migratedCommand = "Glue.screenPrint"/>
	<Mapping name = "NextPage" 				migratedCommand = "ITDService.scrollDownPage"/>
	<Mapping name = "PrevPage" 				migratedCommand = "ITDService.scrollUpPage"/>
	<Mapping name = "ScrollDown" 			migratedCommand = "ITDService.scrollDownRow"/>
	<Mapping name = "HpScrollDown" 			migratedCommand = "ITDService.scrollDownRow"/>
	<Mapping name = "ScrollUp" 				migratedCommand = "ITDService.scrollUpRow"/>
	<Mapping name = "HpScrollUp" 			migratedCommand = "ITDService.scrollUpRow"/>
	<Mapping name = "SelectDown" 			migratedCommand = "ITDService.selectTextDown"/>
	<Mapping name = "SelectUp" 				migratedCommand = "ITDService.selectTextUp"/>
	<Mapping name = "SelectLeft" 			migratedCommand = "ITDService.selectTextLeft"/>
	<Mapping name = "SelectRight" 			migratedCommand = "ITDService.selectTextRight"/>
	<Mapping name = "SelectPrevWord"		migratedCommand = "ITDService.selectWordLeft"/>
	<Mapping name = "SelectNextWord" 		migratedCommand = "ITDService.selectWordRight"/>

	<!--
	<Mapping name = "" 						migratedCommand = "ITDService.selectWordDown"/>
	<Mapping name = "" 						migratedCommand = "ITDService.selectWordUp"/>
	<Mapping name = "" 						migratedCommand = "ITDService.altSelectTextDown"/>
	<Mapping name = "" 						migratedCommand = "ITDService.altSelectTextUp"/>
	<Mapping name = "" 						migratedCommand = "ITDService.altSelectTextLeft"/>
	<Mapping name = "" 						migratedCommand = "ITDService.altSelectTextRight"/>
	-->
</xsl:variable>


<!-- VT Mapping Migration Table -->
<xsl:variable name = "VTKeymapMappingTable">
	<!--  Menu Commands  -->
	<Mapping name = "EditSelectAll"   		migratedCommand = "Glue.selectAll"/>
	<Mapping name = "ConnectionConnect" 	migratedCommand = "ISession.connect"/>
	<Mapping name = "ConnectionDisconnect"	migratedCommand = "ISession.disconnect"/>
	<Mapping name = "VtDisconnect"			migratedCommand = "ISession.disconnect"/>
	<Mapping name = "ClearCommunications"	migratedCommand = "VT.clearComm"/>
	<Mapping name = "HelpAboutReflection" 	migratedCommand = "Glue.aboutBoxDialog"/>
	<Mapping name = "EditCopy" 				migratedCommand = "Glue.copy"/>
	<Mapping name = "EditPaste" 			migratedCommand = "Glue.paste"/>
	<Mapping name = "EditClearDisplay" 		migratedCommand = "VT.clearDisplay"/>
	<Mapping name="TerminalRecallLastSetup" migratedCommand = "VT.recall"/>
	<Mapping name = "TerminalReset" 		migratedCommand = "VT.reset"/>
	<Mapping name = "NextPage" 				migratedCommand = "ITDService.scrollDownPage"/>
	<Mapping name = "TerminalNextPage" 		migratedCommand = "ITDService.scrollDownPage"/>
	<Mapping name = "PrevPage" 				migratedCommand = "ITDService.scrollUpPage"/>
	<Mapping name = "TerminalPreviousPage" 	migratedCommand = "ITDService.scrollUpPage"/>
	<Mapping name = "FilePrint" 			migratedCommand = "Glue.screenPrint"/>
	<Mapping name = "VtPrintScreen"  		migratedCommand = "Glue.screenPrint"/>
	<Mapping name = "ScrollDown" 			migratedCommand = "ITDService.scrollDownRow"/>
	<Mapping name = "ScrollUp" 				migratedCommand = "ITDService.scrollUpRow"/>

	<!--
	<Mapping name = "SelectDown" 			migratedCommand = "ITDService.selectTextDown"/>
	<Mapping name = "SelectUp" 				migratedCommand = "ITDService.selectTextUp"/>
	<Mapping name = "SelectLeft" 			migratedCommand = "ITDService.selectTextLeft"/>
	<Mapping name = "SelectRight" 			migratedCommand = "ITDService.selectTextRight"/>
	<Mapping name = "SelectPrevWord"		migratedCommand = "ITDService.selectWordLeft"/>
	<Mapping name = "SelectNextWord" 		migratedCommand = "ITDService.selectWordRight"/>
	<Mapping name = "" 						migratedCommand = "ITDService.selectWordDown"/>
	<Mapping name = "" 						migratedCommand = "ITDService.selectWordUp"/>
	<Mapping name = "" 						migratedCommand = "ITDService.altSelectTextDown"/>
	<Mapping name = "" 						migratedCommand = "ITDService.altSelectTextUp"/>
	<Mapping name = "" 						migratedCommand = "ITDService.altSelectTextLeft"/>
	<Mapping name = "" 						migratedCommand = "ITDService.altSelectTextRight"/>
	-->
</xsl:variable>


<!-- PC Key Migration Table -->
<xsl:variable name = "PCkeycodeTable">
<!--<Key name = "Application" 		VirtKey="93" 	migratedKey = "93" />-->
	<Key name = "Break" 			VirtKey="3"		migratedKey = "3" />
	<Key name = "Backspace" 		VirtKey="8"		migratedKey = "8" />
	<Key name = "Tab" 				VirtKey="9"		migratedKey = "9" />
	<Key name = "Center" 			VirtKey="12"	migratedKey = "12" />
	<Key name = "Return" 			VirtKey="13"	migratedKey = "10" />
	<Key name = "Pause" 			VirtKey="19"	migratedKey = "19" />
	<Key name = "CapsLock" 			VirtKey="20"	migratedKey = "20" />
	<Key name = "Esc" 				VirtKey="27"	migratedKey = "27" />
	<Key name = "Space" 			VirtKey="32"	migratedKey = "32" />
	<Key name = "PgUp" 				VirtKey="33"	migratedKey = "33" />
	<Key name = "PgDn" 				VirtKey="34"	migratedKey = "34" />
	<Key name = "End" 				VirtKey="35"	migratedKey = "35" />
	<Key name = "Home" 				VirtKey="36"	migratedKey = "36" />
	<Key name = "Left" 				VirtKey="37"	migratedKey = "37" />
	<Key name = "Up" 				VirtKey="38"	migratedKey = "38" />
	<Key name = "Right" 			VirtKey="39"	migratedKey = "39" />
	<Key name = "Down" 				VirtKey="40"	migratedKey = "40" />

	<Key name = "PrintScreen" 		VirtKey="44"	migratedKey = "154" />
	<Key name = "Del" 				VirtKey="46"	migratedKey = "127" />
	<Key name = "0" 				VirtKey="48"	migratedKey = "48" />
	<Key name = "1" 				VirtKey="49"	migratedKey = "49" />
	<Key name = "2" 				VirtKey="50"	migratedKey = "50" />
	<Key name = "3" 				VirtKey="51"	migratedKey = "51" />
	<Key name = "4" 				VirtKey="52"	migratedKey = "52" />
	<Key name = "5" 				VirtKey="53"	migratedKey = "53" />
	<Key name = "6" 				VirtKey="54"	migratedKey = "54" />
	<Key name = "7" 				VirtKey="55"	migratedKey = "55" />
	<Key name = "8" 				VirtKey="56"	migratedKey = "56" />
	<Key name = "9" 				VirtKey="57"	migratedKey = "57" />
	<Key name = "A" 				VirtKey="65"	migratedKey = "65" />
	<Key name = "B" 				VirtKey="66"	migratedKey = "66" />
	<Key name = "C" 				VirtKey="67"	migratedKey = "67" />
	<Key name = "D" 				VirtKey="68"	migratedKey = "68" />
	<Key name = "E" 				VirtKey="69"	migratedKey = "69" />
	<Key name = "F" 				VirtKey="70"	migratedKey = "70" />
	<Key name = "G" 				VirtKey="71"	migratedKey = "71" />
	<Key name = "H" 				VirtKey="72"	migratedKey = "72" />
	<Key name = "I" 				VirtKey="73"	migratedKey = "73" />
	<Key name = "J" 				VirtKey="74"	migratedKey = "74" />
	<Key name = "K" 				VirtKey="75"	migratedKey = "75" />
	<Key name = "L" 				VirtKey="76"	migratedKey = "76" />
	<Key name = "M" 				VirtKey="77"	migratedKey = "77" />
	<Key name = "N" 				VirtKey="78"	migratedKey = "78" />
	<Key name = "O" 				VirtKey="79"	migratedKey = "79" />
	<Key name = "P" 				VirtKey="80"	migratedKey = "80" />
	<Key name = "Q" 				VirtKey="81"	migratedKey = "81" />
	<Key name = "R"	 				VirtKey="82"	migratedKey = "82" />
	<Key name = "S"	 				VirtKey="83"	migratedKey = "83" />
	<Key name = "T" 				VirtKey="84"	migratedKey = "84" />
	<Key name = "U" 				VirtKey="85"	migratedKey = "85" />
	<Key name = "V" 				VirtKey="86"	migratedKey = "86" />
	<Key name = "W" 				VirtKey="87"	migratedKey = "87" />
	<Key name = "X" 				VirtKey="88"	migratedKey = "88" />
	<Key name = "Y" 				VirtKey="89"	migratedKey = "89" />
	<Key name = "Z" 				VirtKey="90"	migratedKey = "90" />

	<Key name = "Kp0" 				VirtKey="96"	migratedKey = "96" 			ExtendedKey="yes" />
	<Key name = "Kp1" 				VirtKey="97"	migratedKey = "97" 			ExtendedKey="yes" />
	<Key name = "Kp2" 				VirtKey="98"	migratedKey = "98" 			ExtendedKey="yes" />
	<Key name = "Kp3" 				VirtKey="99"	migratedKey = "99" 			ExtendedKey="yes" />
	<Key name = "Kp4" 				VirtKey="100"	migratedKey = "100" 		ExtendedKey="yes" />
	<Key name = "Kp5" 				VirtKey="101"	migratedKey = "101" 		ExtendedKey="yes" />
	<Key name = "Kp6" 				VirtKey="102"	migratedKey = "102" 		ExtendedKey="yes" />
	<Key name = "Kp7" 				VirtKey="103"	migratedKey = "103" 		ExtendedKey="yes" />
	<Key name = "Kp8" 				VirtKey="104"	migratedKey = "104" 		ExtendedKey="yes" />
	<Key name = "Kp9" 				VirtKey="105"	migratedKey = "105" 		ExtendedKey="yes" />

	<Key name = "KpCenter"			VirtKey="12"	migratedKey = "101" 		ExtendedKey="yes" />
	<Key name = "KpMultiply" 		VirtKey="106"	migratedKey = "106" 		ExtendedKey="yes" />
	<Key name = "PF4"		 		VirtKey="106"	migratedKey = "106" 		ExtendedKey="yes"   />
	<Key name = "KpPlus"			VirtKey="107"	migratedKey = "107" 		ExtendedKey="yes" />
	<Key name = "VK_108"			VirtKey="108"	migratedKey = "108" 		ExtendedKey="yes"   />
	<Key name = "KpMinus"			VirtKey="109"	migratedKey = "109" 		ExtendedKey="yes" />
	<Key name = "KpDecimal"			VirtKey="110"	migratedKey = "110" 		ExtendedKey="yes" />
	<Key name = "KpDivide"			VirtKey="111"	migratedKey = "111" 		ExtendedKey="yes" />

	<Key name = "F1"				VirtKey="112"	migratedKey = "112" />
	<Key name = "F2"				VirtKey="113"	migratedKey = "113" />
	<Key name = "F3"				VirtKey="114"	migratedKey = "114" />
	<Key name = "F4"				VirtKey="115"	migratedKey = "115" />
	<Key name = "F5"				VirtKey="116"	migratedKey = "116" />
	<Key name = "F6"				VirtKey="117"	migratedKey = "117" />
	<Key name = "F7"				VirtKey="118"	migratedKey = "118" />
	<Key name = "F8"				VirtKey="119"	migratedKey = "119" />
	<Key name = "F9"				VirtKey="120"	migratedKey = "120" />
	<Key name = "F10"				VirtKey="121"	migratedKey = "121" />
	<Key name = "F11"				VirtKey="122"	migratedKey = "122" />
	<Key name = "F12"				VirtKey="123"	migratedKey = "123" />
	<Key name = "F13"				VirtKey="124"	migratedKey = "61440" 		ExtendedKey="yes" />
	<Key name = "F14"				VirtKey="125"	migratedKey = "61441" 		ExtendedKey="yes" />
	<Key name = "F15"				VirtKey="126"	migratedKey = "61442" 		ExtendedKey="yes" />
	<Key name = "F16"				VirtKey="127"	migratedKey = "61443" 		ExtendedKey="yes" />
	<Key name = "F17"				VirtKey="128"	migratedKey = "61444" 		ExtendedKey="yes" />
	<Key name = "F18"				VirtKey="129"	migratedKey = "61445" 		ExtendedKey="yes" />
	<Key name = "F19"				VirtKey="130"	migratedKey = "61446" 		ExtendedKey="yes" />
	<Key name = "F20"				VirtKey="131"	migratedKey = "61447" 		ExtendedKey="yes" />
	<Key name = "F21"				VirtKey="132"	migratedKey = "61448" 		ExtendedKey="yes" />
	<Key name = "F22"				VirtKey="133"	migratedKey = "61449" 		ExtendedKey="yes" />
	<Key name = "F23"				VirtKey="134"	migratedKey = "61450" 		ExtendedKey="yes" />
	<Key name = "F24"				VirtKey="135"	migratedKey = "61451" 		ExtendedKey="yes" />

	<Key name = "HpF1"				VirtKey="112"	migratedKey = "112" />
	<Key name = "HpF2"				VirtKey="113"	migratedKey = "113" />
	<Key name = "HpF3"				VirtKey="114"	migratedKey = "114" />
	<Key name = "HpF4"				VirtKey="115"	migratedKey = "115" />
	<Key name = "HpF5"				VirtKey="116"	migratedKey = "116" />
	<Key name = "HpF6"				VirtKey="117"	migratedKey = "117" />
	<Key name = "HpF7"				VirtKey="118"	migratedKey = "118" />
	<Key name = "HpF8"				VirtKey="119"	migratedKey = "119" />
	<Key name = "HpF9"				VirtKey="120"	migratedKey = "120" />
	<Key name = "HpF10"				VirtKey="121"	migratedKey = "121" />
	<Key name = "HpF11"				VirtKey="122"	migratedKey = "122" />
	<Key name = "HpF12"				VirtKey="123"	migratedKey = "123" />

	<Key name = "NumLock"			VirtKey="144"	migratedKey = "144" />
	<Key name = "PF2"				VirtKey="144"	migratedKey = "144" />
	<Key name = "ScrollLock"		VirtKey="145"	migratedKey = "145" />
	<Key name = "PF3"				VirtKey="145"	migratedKey = "145" />
	<Key name = "Compose"			VirtKey="146"	migratedKey = "65312" 		ExtendedKey="yes" />
	<Key name = "Ins" 			    VirtKey="45"	migratedKey = "155" />
	<Key name = "Insert"			VirtKey="45"	migratedKey = "155" />
	<Key name = "Semicolon"			VirtKey="186"	migratedKey = "186" />
	<Key name = "Equals"			VirtKey="187"	migratedKey = "187" />
	<Key name = "Comma"				VirtKey="188"	migratedKey = "44" />
	<Key name = "Dash"				VirtKey="189"	migratedKey = "189" />
	<Key name = "Period"			VirtKey="190"	migratedKey = "46" />
	<Key name = "Slash"				VirtKey="191"	migratedKey = "47" />
	<Key name = "Grave"				VirtKey="192"	migratedKey = "192" />
	<Key name = "OpenBracket"		VirtKey="219"	migratedKey = "219" 		ExtendedKey="yes" />
	<Key name = "BackSlash"			VirtKey="220"	migratedKey = "92" />
	<Key name = "CloseBracket"		VirtKey="221"	migratedKey = "221" 		ExtendedKey="yes" />
	<Key name = "Apostrophe"		VirtKey="222"	migratedKey = "222" 		ExtendedKey="yes" />

	<Key name = "KpEnter" 			VirtKey="1293"	migratedKey = "10" 			ExtendedKey="yes" />
	<Key name = "CpPgUp"  			VirtKey="1313"	migratedKey = "33" 			ExtendedKey="yes" />
	<Key name = "CpPgDn"  			VirtKey="1314"	migratedKey = "34" 			ExtendedKey="yes" />
	<Key name = "CpEnd"	 			VirtKey="1315"	migratedKey = "35" 			ExtendedKey="yes" />
	<Key name = "CpHome"  			VirtKey="1316"	migratedKey = "36" 			ExtendedKey="yes" />
	<Key name = "CpLeft"  			VirtKey="1317"	migratedKey = "37" 			ExtendedKey="yes" />
	<Key name = "CpUp"	 			VirtKey="1318"	migratedKey = "38" 			ExtendedKey="yes" />
	<Key name = "CpRight" 			VirtKey="1319"	migratedKey = "39" 			ExtendedKey="yes" />
	<Key name = "CpDown"  			VirtKey="1320"	migratedKey = "40" 			ExtendedKey="yes" />
	<Key name = "CpIns"				VirtKey="1325"	migratedKey = "155" 		ExtendedKey="yes" />
	<Key name = "CpDel"				VirtKey="1326"	migratedKey = "127" 		ExtendedKey="yes" />
	<Key name = "ScrollLeft"		VirtKey="0"		migratedKey = "37" 			ExtendedKey="yes" />
	<Key name = "ScrollRight"		VirtKey="0"		migratedKey = "39" 			ExtendedKey="yes" />
</xsl:variable>


<!-- Rweb Key Code Migration Table -->
<xsl:variable name = "RwebKeycodeTable">
	<Key name = "!" 				migratedKey = "33" />
	<Key name = "&quot;" 			migratedKey = "34" />
	<Key name = "#" 				migratedKey = "35" />
	<Key name = "$" 				migratedKey = "36" />
	<Key name = "%" 				migratedKey = "37" />
	<Key name = "&amp;" 			migratedKey = "38" />
	<Key name = "'" 				migratedKey = "39" />
	<Key name = "(" 				migratedKey = "40" />
	<Key name = ")" 				migratedKey = "41" />
	<Key name = "*" 				migratedKey = "42" />
	<Key name = "+" 				migratedKey = "43" />
	<Key name = "," 				migratedKey = "44" />
	<Key name = "-" 				migratedKey = "45" />
	<Key name = "." 				migratedKey = "46" />
	<Key name = "/" 				migratedKey = "47" />
	<Key name = "0" 				migratedKey = "48" />
	<Key name = "1" 				migratedKey = "49" />
	<Key name = "2" 				migratedKey = "50" />
	<Key name = "3" 				migratedKey = "51" />
	<Key name = "4" 				migratedKey = "52" />
	<Key name = "5" 				migratedKey = "53" />
	<Key name = "6" 				migratedKey = "54" />
	<Key name = "7" 				migratedKey = "55" />
	<Key name = "8" 				migratedKey = "56" />
	<Key name = "9" 				migratedKey = "57" />
	<Key name = ":" 				migratedKey = "58" />
	<Key name = ";" 				migratedKey = "59" />
	<Key name = "&lt;" 				migratedKey = "60" />
	<Key name = "=" 				migratedKey = "61" />
	<Key name = "&gt;" 				migratedKey = "62" />
	<Key name = "?" 				migratedKey = "63" />
	<Key name = "@" 				migratedKey = "64" />
	<Key name = "A" 				migratedKey = "65" />
	<Key name = "B" 				migratedKey = "66" />
	<Key name = "C" 				migratedKey = "67" />
	<Key name = "D" 				migratedKey = "68" />
	<Key name = "E" 				migratedKey = "69" />
	<Key name = "F" 				migratedKey = "70" />
	<Key name = "G" 				migratedKey = "71" />
	<Key name = "H" 				migratedKey = "72" />
	<Key name = "I" 				migratedKey = "73" />
	<Key name = "J" 				migratedKey = "74" />
	<Key name = "K" 				migratedKey = "75" />
	<Key name = "L" 				migratedKey = "76" />
	<Key name = "M" 				migratedKey = "77" />
	<Key name = "N" 				migratedKey = "78" />
	<Key name = "O" 				migratedKey = "79" />
	<Key name = "P" 				migratedKey = "80" />
	<Key name = "Q" 				migratedKey = "81" />
	<Key name = "R" 				migratedKey = "82" />
	<Key name = "S" 				migratedKey = "83" />
	<Key name = "T" 				migratedKey = "84" />
	<Key name = "U" 				migratedKey = "85" />
	<Key name = "V" 				migratedKey = "86" />
	<Key name = "W" 				migratedKey = "87" />
	<Key name = "X" 				migratedKey = "88" />
	<Key name = "Y" 				migratedKey = "89" />
	<Key name = "Z" 				migratedKey = "90" />
	<Key name = "[" 				migratedKey = "91" />
	<Key name = "\" 				migratedKey = "92" />
	<Key name = "]" 				migratedKey = "93" />
	<Key name = "`" 				migratedKey = "96" />
	<Key name = "a" 				migratedKey = "97" />
	<Key name = "b" 				migratedKey = "98" />
	<Key name = "c" 				migratedKey = "99" />
	<Key name = "d" 				migratedKey = "100" />
	<Key name = "e" 				migratedKey = "101" />
	<Key name = "f" 				migratedKey = "102" />
	<Key name = "g" 				migratedKey = "103" />
	<Key name = "h" 				migratedKey = "104" />
	<Key name = "i" 				migratedKey = "105" />
	<Key name = "i" 				migratedKey = "106" />
	<Key name = "j" 				migratedKey = "107" />
	<Key name = "l" 				migratedKey = "108" />
	<Key name = "m" 				migratedKey = "109" />
	<Key name = "n" 				migratedKey = "110" />
	<Key name = "o" 				migratedKey = "111" />
	<Key name = "p" 				migratedKey = "112" />
	<Key name = "q" 				migratedKey = "113" />
	<Key name = "r" 				migratedKey = "114" />
	<Key name = "s" 				migratedKey = "115" />
	<Key name = "t" 				migratedKey = "116" />
	<Key name = "u" 				migratedKey = "117" />
	<Key name = "v" 				migratedKey = "118" />
	<Key name = "w" 				migratedKey = "119" />
	<Key name = "x" 				migratedKey = "120" />
	<Key name = "y" 				migratedKey = "121" />
	<Key name = "z" 				migratedKey = "122" />
<!--<Key name = "{" 				migratedKey = "161" />-->
<!--<Key name = "}" 				migratedKey = "162" />-->
	<Key name = "|" 				migratedKey = "124" />
	<Key name = "~" 				migratedKey = "126" />
</xsl:variable>



<!-- Modifier Migration Table -->
<xsl:variable name = "ModifierTable">
	<Key name = "Shift" 			mods = "4"	migratedModifier = "1" />
	<Key name = "Ctrl" 				mods = "2"	migratedModifier = "2" />
	<Key name = "Alt" 				mods = "1"	migratedModifier = "8" />
	<Key name = "Shift+Ctrl" 		mods = "6"	migratedModifier = "3" />
	<Key name = "Shift+Alt" 		mods = "5"	migratedModifier = "9" />
	<Key name = "Ctrl+Alt"	 		mods = "3"	migratedModifier = "10" />
	<Key name = "Shift+Ctrl+Alt" 	mods = "7"	migratedModifier = "11" />
</xsl:variable>						
<!-- otherwise 						mods = "0"	migratedModifier = "0"    -->



<!-- HP Terminal Key Migration Table -->
<xsl:variable name = "HPTerminalKeyTable">
	<Key name = "HpEnter" 			migratedKey = "1" />
	<Key name = "Return" 			migratedKey = "2" />
	<Key name = "Tab" 				migratedKey = "3" />
	<Key name = "HpBacktab"	  		migratedKey = "4" />
	<Key name = "BreakKey" 	 		migratedKey = "5" />
	<Key name = "Hold" 		 		migratedKey = "6" />
	<Key name = "Print" 	 		migratedKey = "7" />
	<Key name = "Backspace"	 		migratedKey = "8" />
	<Key name = "HpDelete"			migratedKey = "9" />
	<Key name = "EscKey" 			migratedKey = "10" />
	<Key name = "CapsLockToggle"	migratedKey = "11" />
	<Key name = "CursorUp" 			migratedKey = "12" />
	<Key name = "CursorDown"  		migratedKey = "13" />
	<Key name = "CursorRight" 		migratedKey = "14" />
	<Key name = "CursorLeft"  		migratedKey = "15" />
	<Key name = "HardReset"  		migratedKey = "16" />
	<Key name = "HpMenu" 	 		migratedKey = "17" />
<!--<Key name = "FunctionKeysSetup" migratedKey = "18" />-->
<!--<Key name = "HpSystem"			migratedKey = "19" />-->
	<Key name = "HpUser" 	 		migratedKey = "20" />
	<Key name = "HpModes"	  		migratedKey = "21" />
	<Key name = "HpHomeUp"			migratedKey = "22" />
	<Key name = "HpHomeDown"  		migratedKey = "23" />
	<Key name = "HpClearDisplay"	migratedKey = "24" />
	<Key name = "EditClearDisplay"	migratedKey = "24" />
	<Key name = "HpClearLine"		migratedKey = "25" />
	<Key name = "HpInsertLine"		migratedKey = "26" />
	<Key name = "HpDeleteLine"		migratedKey = "27" />
	<Key name = "HpInsertChar"		migratedKey = "28" />
	<Key name = "HpInsertCharWrap"	migratedKey = "29" />
	<Key name = "HpDeleteChar"		migratedKey = "30" />
	<Key name = "HpDeleteCharWrap" 	migratedKey = "31" />
	<Key name = "PrevPage" 			migratedKey = "32" />
	<Key name = "NextPage" 			migratedKey = "33" />
	<Key name = "ScrollUp"			migratedKey = "34" />
	<Key name = "ScrollDown"		migratedKey = "35" />
	<Key name = "HpF1"				migratedKey = "36" />
	<Key name = "HpF2"				migratedKey = "37" />
	<Key name = "HpF3"				migratedKey = "38" />
	<Key name = "HpF4"				migratedKey = "39" />
	<Key name = "HpF5"				migratedKey = "40" />
	<Key name = "HpF6"				migratedKey = "41" />
	<Key name = "HpF7"				migratedKey = "42" />
	<Key name = "HpF8"				migratedKey = "43" />
	<Key name = "HpDefaultF1"		migratedKey = "44" />
	<Key name = "HpDefaultF2"		migratedKey = "45" />
	<Key name = "HpDefaultF3"		migratedKey = "46" />
	<Key name = "HpDefaultF4"		migratedKey = "47" />
	<Key name = "HpDefaultF5"		migratedKey = "48" />
	<Key name = "HpDefaultF6"		migratedKey = "49" />
	<Key name = "HpDefaultF7"		migratedKey = "50" />
	<Key name = "HpDefaultF8"		migratedKey = "51" />
	<Key name = "SoftReset"			migratedKey = "105" />
	<Key name = "ClearTypeahead"	migratedKey = "107" />
	<Key name = "HpSelect"			migratedKey = "108" />
<!--<Key name = "SmartEnterKey" 	migratedKey = "109" />-->
</xsl:variable>						


<!-- VT Terminal Key Migration Table -->
<xsl:variable name = "VTTerminalKeyTable">
	<Key name = "VtEnter" 			migratedKey = "1" />
	<Key name = "Return" 			migratedKey = "2" />
<!--<Key name = "Tab" 				migratedKey = "3" />-->
	<Key name = "BreakKey" 	 		migratedKey = "7" />
	<Key name = "VtBreak" 	 		migratedKey = "7" />
	<Key name = "VTHoldScreen" 		migratedKey = "8" />
	<Key name = "VtBackArrow"	 	migratedKey = "9" />
	<Key name = "Backspace"	 		migratedKey = "9" />
	<Key name = "EscKey" 			migratedKey = "10" />
	<Key name = "VtFind"	  		migratedKey = "13" />
	<Key name = "VtInsertHere" 		migratedKey = "14" />
	<Key name = "VtRemove"  		migratedKey = "15" />
	<Key name = "VtSelect"  		migratedKey = "16" />
	<Key name = "VtPrevScreen" 		migratedKey = "17" />
	<Key name = "VtNextScreen" 		migratedKey = "18" />
	<Key name = "CursorUp"			migratedKey = "19" />
	<Key name = "CursorDown"  		migratedKey = "20" />
	<Key name = "CursorRight"  		migratedKey = "21" />
	<Key name = "CursorLeft"   		migratedKey = "22" />
	<Key name = "VtPf1"  			migratedKey = "23" />
	<Key name = "VtPf2"				migratedKey = "24" />
	<Key name = "VtPf3"				migratedKey = "25" />
	<Key name = "VtPf4"				migratedKey = "26" />
	<Key name = "VtMinus"			migratedKey = "27" />
	<Key name = "VtComma"			migratedKey = "28" />
	<Key name = "VtDecimal"			migratedKey = "29" />
	<Key name = "Vt0"				migratedKey = "30" />
	<Key name = "Vt1" 				migratedKey = "31" />
	<Key name = "Vt2" 				migratedKey = "32" />
	<Key name = "Vt3" 				migratedKey = "33" />
	<Key name = "Vt4"				migratedKey = "34" />
	<Key name = "Vt5"				migratedKey = "35" />
	<Key name = "Vt6"				migratedKey = "36" />
	<Key name = "Vt7"				migratedKey = "37" />
	<Key name = "Vt8"				migratedKey = "38" />
	<Key name = "Vt9"				migratedKey = "39" />
	<Key name = "VtF1"				migratedKey = "40" />
	<Key name = "VtF2"				migratedKey = "41" />
	<Key name = "VtF3"				migratedKey = "42" />
	<Key name = "VtF4"				migratedKey = "43" />
	<Key name = "VtF5"				migratedKey = "44" />
	<Key name = "VtF6"				migratedKey = "45" />
	<Key name = "VtF7"				migratedKey = "46" />
	<Key name = "VtF8"				migratedKey = "47" />
	<Key name = "VtF9"				migratedKey = "48" />
	<Key name = "VtF10"				migratedKey = "49" />
	<Key name = "VtF11"				migratedKey = "50" />
	<Key name = "VtF12"				migratedKey = "51" />
	<Key name = "VtF13"				migratedKey = "52" />
	<Key name = "VtF14"				migratedKey = "53" />
	<Key name = "VtF15"				migratedKey = "54" />
	<Key name = "VtF16"				migratedKey = "55" />
	<Key name = "VtF17"				migratedKey = "56" />
	<Key name = "VtF18"				migratedKey = "57" />
	<Key name = "VtF19"				migratedKey = "58" />
	<Key name = "VtF20"				migratedKey = "59" />
	<Key name = "VtUdk6"			migratedKey = "60" />
	<Key name = "VtUdk7"			migratedKey = "61" />
	<Key name = "VtUdk8"			migratedKey = "62" />
	<Key name = "VtUdk9"			migratedKey = "63" />
	<Key name = "VtUdk10"			migratedKey = "64" />
	<Key name = "VtUdk11"			migratedKey = "65" />
	<Key name = "VtUdk12"			migratedKey = "66" />
	<Key name = "VtUdk13"			migratedKey = "67" />
	<Key name = "VtUdk14"			migratedKey = "68" />
	<Key name = "VtUdk15"			migratedKey = "69" />
	<Key name = "VtUdk16"			migratedKey = "70" />
	<Key name = "VtUdk17"			migratedKey = "71" />
	<Key name = "VtUdk18"			migratedKey = "72" />
	<Key name = "VtUdk19"			migratedKey = "73" />
	<Key name = "VtUdk20"			migratedKey = "74" />
</xsl:variable>						





<xsl:variable name = "ControlCharacter">
	<Char name = "CR"	code = "13" />
	<Char name = "ESC"	code = "27" />
	<Char name = "LF"	code = "10" />
	<Char name = "FF"	code = "12" />
	<Char name = "BEL" 	code = "7" />
	<Char name = "HT" 	code = "9" />
	<Char name = "BS" 	code = "8" />
	<Char name = "DC1" 	code = "17" />
</xsl:variable>						



<xsl:variable name = "ControlCodes">
	<Char name = "@"	code = "0" />
	<Char name = "a"	code = "1" />
	<Char name = "b"	code = "2" />
	<Char name = "c"	code = "3" />
	<Char name = "d"	code = "4" />
	<Char name = "e"	code = "5" />
	<Char name = "f"	code = "6" />
	<Char name = "g"	code = "7" />
	<Char name = "h"	code = "8" />
	<Char name = "i"	code = "9" />
	<Char name = "j"	code = "10" />
	<Char name = "k"	code = "11" />
	<Char name = "l"	code = "12" />
	<Char name = "m"	code = "13" />
	<Char name = "n"	code = "14" />
	<Char name = "o"	code = "15" />
	<Char name = "p"	code = "16" />
	<Char name = "q" 	code = "17" />
	<Char name = "r" 	code = "18" />
	<Char name = "s" 	code = "19" />
	<Char name = "t" 	code = "20" />
	<Char name = "u" 	code = "21" />
	<Char name = "v" 	code = "22" />
	<Char name = "w" 	code = "23" />
	<Char name = "x" 	code = "24" />
	<Char name = "y" 	code = "25" />
	<Char name = "z" 	code = "26" />
	<Char name = "[" 	code = "27" />
	<Char name = "\" 	code = "28" />
	<Char name = "]" 	code = "29" />
	<Char name = "^" 	code = "30" />
	<Char name = "?" 	code = "31" />
</xsl:variable>						



<!-- Fkey Attribute Migration Table -->

<xsl:variable name = "FkeyAttributeTable">
	<Type name = "NORMAL"	 		migratedType = "0" />
	<Type name = "LOCAL"			migratedType = "1" />
	<Type name = "TRANSMIT" 		migratedType = "2" />
</xsl:variable>						



<!-- Color Migration Table -->

<xsl:variable name = "ColorTable">
	<Color name = "grey"	 		rwinColor = "0x6e6e6e" 	rwebColor = "0x808080"	/>
	<Color name = "maroon" 			rwinColor = "0x800000"	rwebColor = "0x800080"  />
	<Color name = "darkblue"		rwinColor = "0x00008b"	rwebColor = "0x000080"  />
	<Color name = "Lightblue" 		rwinColor = "0xadd8e6" 	rwebColor = "0x0000ff"  />
	<Color name = "regisgrey" 		rwinColor = "0x2e2e2e" 	rwebColor = "0x808080"	/>
	<Color name = "regismaroon"		rwinColor = "0x3b1b1b"	rwebColor = "0x800000"   />
	<Color name = "regisdarkblue"	rwinColor = "0x21213b"	rwebColor = "0x000080"   />
	<Color name = "regisroyalblue"	rwinColor = "0x141450"	rwebColor = "0x0000ff"   />
	<Color name = "regisLightblue"	rwinColor = "0x145050" 	rwebColor = "0x00ffff"   />
	<Color name = "regisGreen"		rwinColor = "0x213b21" 	rwebColor = "0x008000"   />
	<Color name = "regisLime"		rwinColor = "0x145014" 	rwebColor = "0x00ff00"   />
	<Color name = "regisRed"		rwinColor = "0x4f0d0d" 	rwebColor = "0xff0000"   />
	<Color name = "regisFuschia"  	rwinColor = "0x501450" 	rwebColor = "0xff00ff"   />
	<Color name = "regisAqua"  		rwinColor = "0x145050" 	rwebColor = "0x00ffff"   />
	<Color name = "regisYellow"		rwinColor = "0x505014" 	rwebColor = "0xffff00"   />
	<Color name = "regisMustard"	rwinColor = "0x3b3b21" 	rwebColor = "0x808000"   />
	<Color name = "regisPurple" 	rwinColor = "0x3b213b" 	rwebColor = "0x800080"   />
	<Color name = "regisDarkGrey"  	rwinColor = "0x1a1a1a" 	rwebColor = "0x808080"   />
	<Color name = "regisLiteGrey"  	rwinColor = "0x505050" 	rwebColor = "0xc0c0c0"   />
	<Color name = "regisTeal" 	 	rwinColor = "0x213b3b" 	rwebColor = "0x008080"   />
</xsl:variable>						





<!-- Result XML Fragments -->

<xsl:variable name = "HPpropertiesList">
	<PROPERTIES>
		<PROPERTY NAME="preload">com.wrq.session.Session com.wrq.present.pm.PresentationManager com.wrq.present.mouse.MouseMapperService com.wrq.display.HPTD </PROPERTY>
		<PROPERTY NAME="type">configuration</PROPERTY> 
		<PROPERTY NAME="version">3</PROPERTY> 
		<PROPERTY NAME="signature">HPApplet v4.1</PROPERTY> 
	</PROPERTIES>
</xsl:variable>

<xsl:variable name = "VTpropertiesList">
	<PROPERTIES>
		<PROPERTY NAME="preload">com.wrq.session.Session com.wrq.present.pm.PresentationManager com.wrq.present.mouse.MouseMapperService com.wrq.display.VTTD </PROPERTY>
		<PROPERTY NAME="type">configuration</PROPERTY> 
		<PROPERTY NAME="version">3</PROPERTY> 
		<PROPERTY NAME="signature">VTApplet v4.1</PROPERTY> 
	</PROPERTIES>
</xsl:variable>

<xsl:variable name = "HPkeymapPropertiesList">
	<PROPERTIES>
		<PROPERTY NAME="type">single</PROPERTY>
		<PROPERTY NAME="exportMapID">1</PROPERTY>
		<PROPERTY NAME="version">2</PROPERTY>
		<PROPERTY NAME="signature">HPApplet v4.1</PROPERTY>
		<PROPERTY NAME="containerClassName">com.wrq.present.mapper.Mapper</PROPERTY>
	</PROPERTIES>
</xsl:variable>

<xsl:variable name = "VTkeymapPropertiesList">
	<PROPERTIES>
		<PROPERTY NAME="type">single</PROPERTY>
		<PROPERTY NAME="exportMapID">1</PROPERTY>
		<PROPERTY NAME="version">2</PROPERTY>
		<PROPERTY NAME="signature">VTApplet v4.1</PROPERTY>
		<PROPERTY NAME="containerClassName">com.wrq.present.mapper.Mapper</PROPERTY>
	</PROPERTIES>
</xsl:variable>

<xsl:variable name = "PersistenceServiceContainer">
	<CONTAINER NAME="com.wrq.core.service.PersistenceService">
		<SERIAL_WRAPPER>
			<STRING_ARRAY SIZE="1">
				<STRING>com.wrq.core.service.IPersistable</STRING>
			</STRING_ARRAY>
			<STRING_ARRAY SIZE="7">
				<STRING>com.wrq.present.mapper.0</STRING>
				<STRING>com.wrq.present.mapper.1</STRING>
				<STRING>com.wrq.present.pm.PresentationManager</STRING>
				<STRING>com.wrq.printer.PrinterService</STRING>
				<STRING>com.wrq.session.Session</STRING>
				<STRING>com.wrq.display.HPTD</STRING>
				<STRING>com.wrq.filexfer.FTPClient.FTPXferService</STRING>
			</STRING_ARRAY>
		</SERIAL_WRAPPER>
	</CONTAINER>
</xsl:variable>


<xsl:variable name = "ButtonPaletteContainer">
	<CONTAINER NAME="com.wrq.present.mapper.button.ButtonPalette">
   		<PROPERTY_STATE SIZE="1">
   			<CORE_PROPERTY NAME="buttonPaletteDocked">
   				<BOOLEAN>false</BOOLEAN>
   			</CORE_PROPERTY>
   		</PROPERTY_STATE>
   	</CONTAINER>
</xsl:variable>


<xsl:variable name = "KeyboardPalette">
	<CONTAINER NAME="com.wrq.present.mapper.button.KeyboardPalette">
		<PROPERTY_STATE SIZE="1">
			<CORE_PROPERTY NAME="terminalKeyboardDocked">
				<BOOLEAN>false</BOOLEAN>
			</CORE_PROPERTY>
		</PROPERTY_STATE>
	</CONTAINER>
</xsl:variable>

<xsl:variable name = "PresentationManager3">
	<CONTAINER NAME="PresentationManager3">
		<CONTEXT_CHILD_STATE>
			<COMMAND_LIST SIZE="1">
				<COMMAND NAME="PresentationManager.setFrameBounds">
					<OBJECT_ARRAY SIZE="4">
						<INTEGER>-1</INTEGER>
						<INTEGER>-1</INTEGER>
						<INTEGER>-1</INTEGER>
						<INTEGER>-1</INTEGER>
					</OBJECT_ARRAY>
				</COMMAND>
			</COMMAND_LIST>
			<PROPERTY_STATE SIZE="2">
				<CORE_PROPERTY NAME="visible">
					<BOOLEAN>true</BOOLEAN>
				</CORE_PROPERTY>
				<CORE_PROPERTY NAME="autoDisplaySizing">
					<BOOLEAN>true</BOOLEAN>
				</CORE_PROPERTY>
			</PROPERTY_STATE>
		</CONTEXT_CHILD_STATE>
	</CONTAINER>
</xsl:variable>


<xsl:variable name = "MapperEngineFixedContent">
	<CORE_PROPERTY NAME="buttonPaletteVisible">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
</xsl:variable>


<xsl:variable name = "MouseMapperService">
	<CONTAINER NAME="com.wrq.present.mouse.MouseMapperService">
		<CONTEXT_CHILD_STATE>
			<COMMAND_LIST SIZE="1">
				<COMMAND NAME="IMouseMapperService.setMouseMap">
					<OBJECT_ARRAY SIZE="3">
						<INTEGER>0</INTEGER>
						<INTEGER>1</INTEGER>
						<COMMAND NAME="Emulator.moveCursor">
							<OBJECT_ARRAY SIZE="1">
								<INDIRECT_PROPERTY>
									<STRING>mouseClickPosition</STRING>
								</INDIRECT_PROPERTY>
							</OBJECT_ARRAY>
						</COMMAND>
					</OBJECT_ARRAY>
				</COMMAND>
			</COMMAND_LIST>
			<NULL></NULL>
		</CONTEXT_CHILD_STATE>
	</CONTAINER>
</xsl:variable>


<xsl:variable name = "HostWritableStatusLine">
	<CONTAINER NAME="com.wrq.display.VTTD-hwsl">
		<PROPERTY_STATE SIZE="18">
			<CORE_PROPERTY NAME="selectionDelimiters-hwsl">
				<STRING> .,;</STRING>
			</CORE_PROPERTY>
			<CORE_PROPERTY NAME="beginSelectionModifier-hwsl">
				<INTEGER>0</INTEGER>
			</CORE_PROPERTY>
			<CORE_PROPERTY NAME="beginAltSelectionModifier-hwsl">
				<INTEGER>8</INTEGER>
			</CORE_PROPERTY>
			<CORE_PROPERTY NAME="extendSelectionModifier-hwsl">
				<INTEGER>1</INTEGER>
			</CORE_PROPERTY>
			<CORE_PROPERTY NAME="displayFont-hwsl">
				<STRING>Monospaced</STRING>
			</CORE_PROPERTY>
			<CORE_PROPERTY NAME="doubleClickTime-hwsl">
				<INTEGER>200</INTEGER>
			</CORE_PROPERTY>
			<CORE_PROPERTY NAME="characterBlinkRate-hwsl">
				<INTEGER>0</INTEGER>
			</CORE_PROPERTY>
			<CORE_PROPERTY NAME="cursorBlinkRate-hwsl">
				<INTEGER>0</INTEGER>
			</CORE_PROPERTY>
			<CORE_PROPERTY NAME="constrainCellWidth-hwsl">
				<BOOLEAN>false</BOOLEAN>
			</CORE_PROPERTY>
			<CORE_PROPERTY NAME="copyTrailingSpaces-hwsl">
				<BOOLEAN>true</BOOLEAN>
			</CORE_PROPERTY>
			<CORE_PROPERTY NAME="defaultSelectionMode-hwsl">
				<INTEGER>0</INTEGER>
			</CORE_PROPERTY>
			<CORE_PROPERTY NAME="useHeavyFont-hwsl">
				<BOOLEAN>false</BOOLEAN>
			</CORE_PROPERTY>
			<CORE_PROPERTY NAME="blinkEnabled-hwsl">
				<BOOLEAN>true</BOOLEAN>
			</CORE_PROPERTY>
			<CORE_PROPERTY NAME="boldEnabled-hwsl">
				<BOOLEAN>true</BOOLEAN>
			</CORE_PROPERTY>
			<CORE_PROPERTY NAME="underlineEnabled-hwsl">
				<BOOLEAN>true</BOOLEAN>
			</CORE_PROPERTY>
			<CORE_PROPERTY NAME="bitmapFontWhenSmall-hwsl">
				<BOOLEAN>true</BOOLEAN>
			</CORE_PROPERTY>
			<CORE_PROPERTY NAME="editAllAttributes-hwsl">
				<BOOLEAN>false</BOOLEAN>
			</CORE_PROPERTY>
			<CORE_PROPERTY NAME="slashedZero-hwsl">
				<BOOLEAN>false</BOOLEAN>
			</CORE_PROPERTY>
		</PROPERTY_STATE>
	</CONTAINER>
</xsl:variable>


<xsl:variable name = "HPsessionFixedContent">
	<CORE_PROPERTY NAME="autoreconnect">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="meteringEnabled">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
</xsl:variable>

<xsl:variable name = "VTsessionFixedContent">
	<CORE_PROPERTY NAME="autoreconnect">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="meteringEnabled">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
</xsl:variable>


<xsl:variable name = "HPTISBFixedContent">
	<CORE_PROPERTY NAME="scrollbackRowLimit">
		<INTEGER>500</INTEGER>
	</CORE_PROPERTY>
</xsl:variable>


<xsl:variable name = "VTTISBFixedContent">
	<CORE_PROPERTY NAME="scrollbackRowLimit">
		<INTEGER>500</INTEGER>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="useScrollback">
		<BOOLEAN>true</BOOLEAN>
	</CORE_PROPERTY>
</xsl:variable>


<xsl:variable name = "VTFixedContent">
	<CORE_PROPERTY NAME="transferInProgress">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="irm">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="kam">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="declrmm">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="decxrlm">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="decpccm">
		<BOOLEAN>true</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="decvccm">
		<BOOLEAN>true</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="crm">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="decsace">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="decarsm">
		<BOOLEAN>true</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="dectcem">
		<BOOLEAN>true</BOOLEAN>
	</CORE_PROPERTY>
</xsl:variable>
<xsl:variable name = "HPFixedContent" select = "$VTFixedContent"/>


<xsl:variable name = "VTTDFixedContent">
	<CORE_PROPERTY NAME="selectionDelimiters">
		<STRING> .,;</STRING>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="beginSelectionModifier">
		<INTEGER>0</INTEGER>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="beginAltSelectionModifier">
		<INTEGER>8</INTEGER>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="extendSelectionModifier">
		<INTEGER>1</INTEGER>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="displayFont">
		<STRING>Monospaced</STRING>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="doubleClickTime">
		<INTEGER>200</INTEGER>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="characterBlinkRate">
		<INTEGER>0</INTEGER>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="cursorBlinkRate">
		<INTEGER>0</INTEGER>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="constrainCellWidth">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="bitmapFontWhenSmall">
		<BOOLEAN>true</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="copyTrailingSpaces">
 		<BOOLEAN>true</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="defaultSelectionMode">
		<INTEGER>0</INTEGER>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="useHeavyFont">
		<BOOLEAN>true</BOOLEAN>
	</CORE_PROPERTY>
</xsl:variable>
<xsl:variable name = "HPTDFixedContent" select = "$VTTDFixedContent"/>


<xsl:variable name = "PrinterFixedContent">
	<CORE_PROPERTY NAME="autoFF">
		<BOOLEAN>true</BOOLEAN>
	</CORE_PROPERTY>
<!--
	<CORE_PROPERTY NAME="printJobTerminationDelay">
		<INTEGER>0</INTEGER>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="fitToPage">
		<BOOLEAN>true</BOOLEAN>
	</CORE_PROPERTY>
-->
	<CORE_PROPERTY NAME="graphicalPrinting">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="overrideHostFormat">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="pageOrientation">
		<INTEGER>0</INTEGER>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="paperSize">
		<INTEGER>0</INTEGER>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="printerFont">
		<STRING>Monospaced</STRING>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="printFileMode">
		<INTEGER>5</INTEGER>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="printToFile">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="charsPerLine">
		<INTEGER>80</INTEGER>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="linesPerPage">
		<INTEGER>60</INTEGER>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="printerBottomMargin">
		<FLOAT>0.5</FLOAT>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="printerLeftMargin">
		<FLOAT>0.5</FLOAT>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="printerRightMargin">
		<FLOAT>0.5</FLOAT>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="printerTopMargin">
		<FLOAT>0.5</FLOAT>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="hostChangedCPI">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="hostChangedCPL">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="hostChangedLPI">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="hostChangedLPP">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="hostChangedPageFormat">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="hostChangedMargins">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="hostSpecifiedCPI">
		<INTEGER>10</INTEGER>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="hostSpecifiedCharsPerLine">
		<INTEGER>80</INTEGER>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="hostSpecifiedLPI">
		<INTEGER>6</INTEGER>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="hostSpecifiedLinesPerPage">
		<INTEGER>60</INTEGER>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="hostSpecifiedBottomMargin">
		<INTEGER>60</INTEGER>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="hostSpecifiedLeftMargin">
		<INTEGER>1</INTEGER>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="hostSpecifiedRightMargin">
		<INTEGER>80</INTEGER>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="hostSpecifiedTopMargin">
		<INTEGER>1</INTEGER>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="printDataToFile">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="emulatorSpecifiedPrintDataToFile">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="printerMarginUnitsOfMeasurement">
		<STRING>english</STRING>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="autoPrintFormFeed">
		<BOOLEAN>true</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="autoPrintLineFeed">
		<BOOLEAN>true</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="dontShowOrientationDlg">
		<BOOLEAN>true</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="paperWidth">
		<FLOAT>8.5</FLOAT>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="paperHeight">
		<FLOAT>11.0</FLOAT>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="printScalingPercentageX">
		<FLOAT>100.0</FLOAT>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="printScalingPercentageY">
		<FLOAT>100.0</FLOAT>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="overstrikeCharacter">
		<STRING>-</STRING>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="printDBCSScale">
		<STRING>1:2</STRING>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="fitHostPageX">
		<BOOLEAN>true</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="fitHostPageY">
		<BOOLEAN>true</BOOLEAN>
	</CORE_PROPERTY>
</xsl:variable>


<xsl:variable name = "TransportOptionsFixedContent">
	<CORE_PROPERTY NAME="deviceName">
		<STRING></STRING>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="supportTN3270E">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="responseMode">
		<BOOLEAN>true</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="telnetTerminalID">
		<STRING></STRING>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="tn3270eConnectType">
		<INTEGER>1</INTEGER>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="tnAssociation">
		<STRING></STRING>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="telnetTerminalType">
		<STRING>VT220</STRING>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="sendLFAfterCR">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="initiateOptionNegotiation">
		<BOOLEAN>true</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="requestBinary">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="breakSendsIP">
		<BOOLEAN>true</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="negotiateWindowSize">
		<BOOLEAN>true</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="localMode">
		<INTEGER>0</INTEGER>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="characterDelay">
		<INTEGER>0</INTEGER>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="renegotiateEcho">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="generateUniqueDeviceName">
		<BOOLEAN>false</BOOLEAN>
	</CORE_PROPERTY>
	<CORE_PROPERTY NAME="pauseDuringPlayback">
		<BOOLEAN>true</BOOLEAN>
	</CORE_PROPERTY>
</xsl:variable>



<xsl:variable name = "EmptyFixedContent">
	<NULL></NULL>
</xsl:variable>


<xsl:variable name = "CountNotSupplied">-1</xsl:variable>




<!-- global variables  -->

<xsl:variable name = "properties" 		  	  select = "/REFLECTION_SETTINGS/PROPERTIES"/>
<xsl:variable name = "connectionProperty" 	  select = "/REFLECTION_SETTINGS/CONNECTION"/> 
<xsl:variable name = "HPPropertyTable"	  	  select = "msxsl:node-set($HP_PropertyTable)"/>
<xsl:variable name = "VTPropertyTable" 	 	  select = "msxsl:node-set($VT_PropertyTable)"/>
<xsl:variable name = "TransportPropertyTable" select = "msxsl:node-set($Transport_PropertyTable)"/>
<xsl:variable name = "NoFixedContent" 		  select = "msxsl:node-set($EmptyFixedContent)"/>
<xsl:variable name = "CtrlCharTable"   		  select = "msxsl:node-set($ControlCharacter)"/>
<xsl:variable name = "CtrlCodeTable"   		  select = "msxsl:node-set($ControlCodes)"/>
<xsl:variable name = "RwebKeycodes" 		  select = "msxsl:node-set($RwebKeycodeTable)"/>
<xsl:variable name = "root" 				  select = "REFLECTION_SETTINGS"/>

<xsl:variable name = "XMLversion">
	<xsl:value-of select = "/REFLECTION_SETTINGS/@version"/>
</xsl:variable>

<xsl:variable name = "settingsType" select =  "/REFLECTION_SETTINGS/TYPE"/>
<xsl:variable name = "settingsMode" select =  "/REFLECTION_SETTINGS/TYPE/@mode"/>

<xsl:variable name = "emulator">
	<xsl:value-of select = "/REFLECTION_SETTINGS/CREATOR/@type"/>
</xsl:variable>
					  
<xsl:variable name = "subtype">
	<xsl:value-of select = "/REFLECTION_SETTINGS/CREATOR/@emulation"/>
</xsl:variable>

<xsl:variable name = "language">
	<xsl:value-of select = "/REFLECTION_SETTINGS/CREATOR/@language"/>
</xsl:variable>

<xsl:variable name = "terminalClass"
	select = "$properties/PROPERTY[@name = 'TerminalClass']/ENUMERATION"/>

<xsl:variable name = "product">
	<xsl:choose>
		<xsl:when test = "($emulator = 1)">HP</xsl:when>
		<xsl:otherwise>VT</xsl:otherwise>			
	</xsl:choose>
</xsl:variable>

<xsl:variable name = "productType">
	<xsl:choose>
		<xsl:when test = "($emulator = 1) and ($terminalClass = 'rcHP')">HP</xsl:when>
		<xsl:when test = "($emulator = 1) and ($subtype = 'HP')">HP</xsl:when>
		<xsl:when test = "($emulator = 1) and ($configType = 'keymap') and
						  (not(string($terminalClass)) and not(string($subtype)))">HP</xsl:when>
		<xsl:otherwise>VT</xsl:otherwise>			
	</xsl:choose>
</xsl:variable>

<xsl:variable name = "RwinConnectionType">
	<xsl:value-of select = "/REFLECTION_SETTINGS/CONNECTION/CONNECTION_TYPE"/>
</xsl:variable>


<xsl:variable name = "connectionType">
	<xsl:choose>
		<xsl:when test = "($productType = 'HP')">
			<xsl:choose>
				<xsl:when test = "($RwinConnectionType = 'VT-MGR')">nsvt</xsl:when>
				<xsl:when test = "($RwinConnectionType = 'TELNET')">telnet</xsl:when>
				<xsl:when test = "($RwinConnectionType = 'OPENSSH')">ssh</xsl:when>
				<xsl:otherwise>nsvt</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:when test = "($productType = 'VT')">
			<xsl:choose>
				<xsl:when test = "($RwinConnectionType = 'OPENSSH')">ssh</xsl:when>
				<xsl:otherwise>telnet</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
 		<xsl:otherwise>telnet</xsl:otherwise>			
	</xsl:choose>
</xsl:variable>

<xsl:variable name = "terminalType" 
			  select = "$properties/PROPERTY[@name = 'TerminalType']/ENUMERATION"/>

<xsl:variable name = "VTstatusLine" 
			  select = "$properties/PROPERTY[@name = 'HostStatusLine']/ENUMERATION"/>






<xsl:template match="/">
	<xsl:variable name = "validSourceXML">
		<xsl:call-template name = "isSourceXMLValid"/>
	</xsl:variable>

	<xsl:choose>
		<xsl:when test = "string($validSourceXML) = 'true'">
			<xsl:choose>
				<xsl:when test = "$configType = 'keymap'">
					<xsl:call-template name = "createKeymapConfig"/>
				</xsl:when>
				<xsl:otherwise>
				<xsl:call-template name = "createConfigSetttings"/>
				</xsl:otherwise>
			</xsl:choose>
 		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name = "reportBadSourceXML"/>
	  	</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "createConfigSetttings">
	<xsl:call-template name = "CreatedByComment"/>
	<xsl:element name = "REFLECTION_WEB">
		<xsl:call-template name = "lineBreakOneTab"/>
		<xsl:element name = "XML_STORE">
			<xsl:call-template name = "lineBreakTwoTabs"/>
			<xsl:call-template name = "PropertiesList"/>
			<xsl:element name = "CONTAINERS">
				<xsl:call-template name = "lineBreak"/>
				<xsl:call-template name = "Colors"/>
				<xsl:call-template name = "PersistenceServiceContainer"/>
				<xsl:call-template name = "TDContainer"/>
				<xsl:call-template name = "ButtonPaletteContainer"/>
				<xsl:call-template name = "MouseMapper_Container"/>
				<xsl:call-template name = "SessionContainer"/>
				<xsl:call-template name = "TISBContainer"/>
				<xsl:call-template name = "Transport_Container"/>
				<xsl:call-template name = "EmulationContainer"/>
				<xsl:call-template name = "KeyboardPalette"/>
				<xsl:call-template name = "KeymapContainer"/>
				<xsl:call-template name = "KeypadContainer"/>
				<xsl:call-template name = "MapperEngine_Container"/>
				<xsl:call-template name = "PresentationManager3"/>
				<!--
				<xsl:call-template name = "Printer_Container"/>
				-->
				<xsl:call-template name = "lineBreakTwoTabs"/>
	 		</xsl:element>
			<xsl:call-template name = "lineBreakOneTab"/>
		</xsl:element>
		<xsl:call-template name = "lineBreak"/>
	</xsl:element>
</xsl:template>


<xsl:template name = "createKeymapConfig">
	<xsl:call-template name = "CreatedByComment"/>
	<xsl:element name = "REFLECTION_WEB">
		<xsl:call-template name = "lineBreakOneTab"/>
		<xsl:element name = "XML_STORE">
			<xsl:call-template name = "lineBreakTwoTabs"/>
			<xsl:call-template name = "KeymapPropertiesList"/>
			<xsl:element name = "CONTAINERS">
				<xsl:call-template name = "lineBreak"/>
				<xsl:call-template name = "KeymapContainer"/>
				<xsl:call-template name = "KeypadContainer"/>
				<xsl:call-template name = "lineBreakTwoTabs"/>
	 		</xsl:element>
			<xsl:call-template name = "lineBreakOneTab"/>
		</xsl:element>
		<xsl:call-template name = "lineBreak"/>
	</xsl:element>
</xsl:template>


<xsl:template name = "MouseMapper_Container">
	<xsl:variable name="list" select = "$MouseMapperService"/>
	<xsl:apply-templates select="$list/CONTAINER"/>
</xsl:template>


<xsl:template name = "HostWritableStatusLineContainer">
	<xsl:variable name="list" select = "$HostWritableStatusLine"/>
	<xsl:apply-templates select="$list/CONTAINER"/>
</xsl:template>


<xsl:template name = "PersistenceServiceContainer" >
	<xsl:variable name="list" select = "$PersistenceServiceContainer"/>
	<xsl:apply-templates select="$list/CONTAINER"/>
</xsl:template>


<xsl:template name = "ButtonPaletteContainer" >
	<xsl:variable name="list" select = "$ButtonPaletteContainer"/>
	<xsl:apply-templates select="$list/CONTAINER"/>
</xsl:template>


<xsl:template name = "KeyboardPalette" >
	<xsl:variable name="list" select = "$KeyboardPalette"/>
	<xsl:apply-templates select="$list/CONTAINER"/>
</xsl:template>

<xsl:template name = "PresentationManager3" >
	<xsl:variable name="list" select = "$PresentationManager3"/>
	<xsl:apply-templates select="$list/CONTAINER"/>
</xsl:template>

 
<xsl:template name = "CreatedByComment" >
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>

	<xsl:comment>
		<xsl:text>   Reflection (</xsl:text>
		<xsl:value-of select = "/REFLECTION_SETTINGS/TYPE/@mode"/>
		<xsl:text>) </xsl:text>
		<xsl:value-of select="/REFLECTION_SETTINGS/TYPE"/>
		<xsl:text> (XML format </xsl:text>
		<xsl:value-of select="/REFLECTION_SETTINGS/@version"/>
		<xsl:text>)</xsl:text>
		<xsl:call-template name = "lineBreak"/>
		<xsl:text>  	   Created by </xsl:text> 
		<xsl:value-of select="/REFLECTION_SETTINGS/CREATOR/@product"/>
	    <xsl:text> - version </xsl:text>
		<xsl:value-of select="/REFLECTION_SETTINGS/CREATOR/@version"/>
		<xsl:text> (build </xsl:text>
  		<xsl:value-of select="/REFLECTION_SETTINGS/CREATOR/@build"/>
		<xsl:text>)</xsl:text>

		<xsl:if test = "string($subtype)">
			<xsl:text> </xsl:text> 
			<xsl:value-of select="$subtype"/>
			<xsl:text> Emulation</xsl:text> 
		</xsl:if>
		<xsl:call-template name = "lineBreak"/>

		<xsl:if test = "string($language)">
			<xsl:text>  	   Language - </xsl:text> 
			<xsl:value-of select="$language"/>
			<xsl:call-template name = "lineBreak"/>
		</xsl:if>

		<xsl:text>  	   Transform version </xsl:text> 
		<xsl:value-of select="$transformVersion"/>
		<xsl:call-template name = "lineBreak"/>
	</xsl:comment>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>

						  
<xsl:template name = "TISBContainer">
	<xsl:choose>
		<xsl:when test = "$productType = 'HP'">
			<xsl:call-template name = "HPTISB_Container"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name = "VTTISB_Container"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "HPTISB_Container">
	<xsl:call-template name = "CreateContainer">
		<xsl:with-param name = "ContainerName">com.wrq.session.tisb.HPTISB</xsl:with-param>
		<xsl:with-param name = "PropertyTable" select = "$HPPropertyTable"/>
		<xsl:with-param name = "FixedContent" select = "msxsl:node-set($HPTISBFixedContent)"/>
	</xsl:call-template>
</xsl:template>


<xsl:template name = "VTTISB_Container">
	<xsl:call-template name = "CreateContainer">
		<xsl:with-param name = "ContainerName">com.wrq.session.tisb.VTTISB</xsl:with-param>
		<xsl:with-param name = "PropertyTable" select = "$VTPropertyTable"/>
		<xsl:with-param name = "FixedContent" select = "msxsl:node-set($VTTISBFixedContent)"/>
	</xsl:call-template>
</xsl:template>




<xsl:template name = "TDContainer">
	<xsl:choose>
		<xsl:when test = "$productType = 'HP'">
			<xsl:call-template name = "CreateTDContainer">
				<xsl:with-param name = "ContainerName">com.wrq.display.HPTD</xsl:with-param>
				<xsl:with-param name = "PropertyTable" select = "$HPPropertyTable"/>
				<xsl:with-param name = "FixedContent" select = "msxsl:node-set($HPTDFixedContent)"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name = "CreateTDContainer">
				<xsl:with-param name = "ContainerName">com.wrq.display.VTTD</xsl:with-param>
				<xsl:with-param name = "PropertyTable" select = "$VTPropertyTable"/>
				<xsl:with-param name = "FixedContent" select = "msxsl:node-set($VTTDFixedContent)"/>
			</xsl:call-template>
			<xsl:if test = "$VTstatusLine = 'rcHostWritable'">
				<xsl:call-template name = "HostWritableStatusLineContainer"/>
			</xsl:if>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "CreateTDContainer">
	<xsl:param name = "ContainerName"/>
	<xsl:param name = "PropertyTable"/>
	<xsl:param name = "FixedContent"/>
	<xsl:variable name = "fixedcount" select = "count($FixedContent/CORE_PROPERTY)"/>
	<xsl:variable name = "colorOptions" select = "/REFLECTION_SETTINGS/COLORS/COLOR_OPTIONS"/> 

	<xsl:variable name = "blinkEnabled" 
		select = "$colorOptions/COLOR_OPTION[@name = 'Enable Blink']/BOOLEAN"/>	
	<xsl:variable name = "underlineEnabled"   
		select = "$colorOptions/COLOR_OPTION[@name = 'Enable Underline']/BOOLEAN"/>	
	<xsl:variable name = "boldEnabled"   
		select = "$colorOptions/COLOR_OPTION[@name = 'Enable Bold']/BOOLEAN"/>	

	<xsl:call-template name = "threeTabs"/>
	<xsl:element name = "CONTAINER">
		<xsl:attribute name = "NAME">
			<xsl:value-of select = "$ContainerName"/>
		</xsl:attribute>
		<xsl:call-template name = "lineBreakFourTabs"/>

		<xsl:element name = "PROPERTY_STATE">
			<xsl:attribute name = "SIZE">
				<xsl:value-of select = "count($PropertyTable/Property[@container = $ContainerName])
										+ $fixedcount + 3"/>
			</xsl:attribute>
			<xsl:call-template name = "lineBreak"/>

		<xsl:call-template name = "fillContainer">
			<xsl:with-param name = "PropertyTable" select = "$PropertyTable"/>
			<xsl:with-param name = "ContainerName" select = "$ContainerName"/>
		</xsl:call-template>

		<!-- color properties -->
		<xsl:call-template name = "fiveTabs"/>
		<xsl:element name = "CORE_PROPERTY">
			<xsl:attribute name = "NAME">blinkEnabled</xsl:attribute>
			<xsl:call-template name = "lineBreakSixTabs"/>
			<xsl:choose>
				<xsl:when test = "$blinkEnabled = 'Yes'"><BOOLEAN>true</BOOLEAN></xsl:when>
				<xsl:otherwise><BOOLEAN>false</BOOLEAN></xsl:otherwise>
			</xsl:choose>
			<xsl:call-template name = "lineBreakFiveTabs"/>
		</xsl:element>
		<xsl:call-template name = "lineBreak"/>

		<xsl:call-template name = "fiveTabs"/>
		<xsl:element name = "CORE_PROPERTY">
			<xsl:attribute name = "NAME">underlineEnabled</xsl:attribute>
			<xsl:call-template name = "lineBreakSixTabs"/>
			<xsl:choose>
				<xsl:when test = "$underlineEnabled = 'Yes'"><BOOLEAN>true</BOOLEAN></xsl:when>
				<xsl:otherwise><BOOLEAN>false</BOOLEAN></xsl:otherwise>
			</xsl:choose>
			<xsl:call-template name = "lineBreakFiveTabs"/>
		</xsl:element>
		<xsl:call-template name = "lineBreak"/>

		<xsl:call-template name = "fiveTabs"/>
		<xsl:element name = "CORE_PROPERTY">
			<xsl:attribute name = "NAME">boldEnabled</xsl:attribute>
			<xsl:call-template name = "lineBreakSixTabs"/>
			<xsl:choose>
				<xsl:when test = "$boldEnabled = 'Yes'"><BOOLEAN>true</BOOLEAN></xsl:when>
				<xsl:otherwise><BOOLEAN>false</BOOLEAN></xsl:otherwise>
			</xsl:choose>
			<xsl:call-template name = "lineBreakFiveTabs"/>
		</xsl:element>
		<xsl:call-template name = "lineBreak"/>

		<!--  fixed properties  -->
		<xsl:if test = "$fixedcount &gt; '0'">
			<xsl:apply-templates select="$FixedContent/CORE_PROPERTY" mode = "fixedSectionCopy">
				<xsl:with-param name = "tabcount">5</xsl:with-param>
			</xsl:apply-templates>
		</xsl:if>

		<xsl:call-template name = "fourTabs"/>
		</xsl:element>
		<xsl:call-template name = "lineBreakThreeTabs"/>
	</xsl:element>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>


<xsl:template name = "MapperEngine_Container">
	<xsl:call-template name = "CreateContainer">
		<xsl:with-param name = "ContainerName">MapperEngine-1</xsl:with-param>
		<xsl:with-param name = "PropertyTable" select = "$HPPropertyTable"/>
		<xsl:with-param name = "FixedContent" select = "msxsl:node-set($MapperEngineFixedContent)"/>
	</xsl:call-template>
</xsl:template>

<xsl:template name = "SessionContainer">
	<xsl:choose>
		<xsl:when test = "$productType = 'HP'">
			<xsl:call-template name = "Session_Container">
				<xsl:with-param name = "PropertyTable" select = "$HPPropertyTable"/>
				<xsl:with-param name = "FixedContent" select = "msxsl:node-set($HPsessionFixedContent)"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name = "Session_Container">
				<xsl:with-param name = "PropertyTable" select = "$VTPropertyTable"/>
				<xsl:with-param name = "FixedContent" select = "msxsl:node-set($VTsessionFixedContent)"/>
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "Transport_Container">
	<xsl:variable name = "propertyCount">
		<xsl:value-of select = "count(/REFLECTION_SETTINGS/CONNECTION/CONNECTION_SETTING[@name = 'UseTLS']) 			  +
								count(/REFLECTION_SETTINGS/CONNECTION/CONNECTION_SETTING[@name = 'UseRwebSecurityProxy']) +
								count(/REFLECTION_SETTINGS/CONNECTION/CONNECTION_SETTING[@name = 'UserName'])"/>
	</xsl:variable>

	<xsl:call-template name = "CreateContainer">
		<xsl:with-param name = "ContainerName">com.wrq.session.transport.TransportOptions</xsl:with-param>
		<xsl:with-param name = "PropertyTable" select = "$TransportPropertyTable"/>
		<xsl:with-param name = "FixedContent" select = "msxsl:node-set($TransportOptionsFixedContent)"/>
		<xsl:with-param name = "PropertyCount" select = "$propertyCount"/>
	</xsl:call-template>
</xsl:template>


<xsl:template name = "Printer_Container">
	<xsl:variable name = "PropertyTable" select = "$HPPropertyTable"/>
	<xsl:variable name = "FixedContent" select = "msxsl:node-set($PrinterFixedContent)"/>
	<xsl:variable name = "ContainerName">PrinterService</xsl:variable>

	<xsl:call-template name = "threeTabs"/>
	<xsl:element name = "CONTAINER">
		<xsl:attribute name = "NAME">com.wrq.printer.PrinterService</xsl:attribute>
		<xsl:call-template name = "lineBreakFourTabs"/>

		<xsl:element name = "CONTEXT_CHILD_STATE">
			<xsl:call-template name = "lineBreakFiveTabs"/>

			<xsl:element name = "COMMAND_LIST">
				<xsl:attribute name = "SIZE">1</xsl:attribute>
				<xsl:call-template name = "lineBreakSixTabs"/>

				<xsl:element name = "COMMAND">
					<xsl:attribute name = "NAME">IPrinterService.Configure</xsl:attribute>
					<xsl:call-template name = "lineBreakSevenTabs"/>
					<NULL></NULL>
					<xsl:call-template name = "lineBreakSixTabs"/>
				</xsl:element>	<!-- end tag COMMAND -->
				<xsl:call-template name = "lineBreakFiveTabs"/>
			</xsl:element>		<!-- end tag COMMAND_LIST -->
			<xsl:call-template name = "lineBreakFiveTabs"/>

			<xsl:element name = "PROPERTY_STATE">
				<xsl:attribute name = "SIZE">
					<xsl:value-of select = "count($PropertyTable/Property[@container = $ContainerName])
											+ count($FixedContent/CORE_PROPERTY)"/>
				</xsl:attribute>
				<xsl:call-template name = "lineBreak"/>

				<xsl:call-template name = "fillContainer">
					<xsl:with-param name = "PropertyTable" select = "$PropertyTable"/>
					<xsl:with-param name = "startTab">6</xsl:with-param>
					<xsl:with-param name = "ContainerName">
						<xsl:value-of select = "$ContainerName"/>
					</xsl:with-param>
				</xsl:call-template>

				<!--  fixed properties  -->
				<xsl:apply-templates select="$FixedContent/CORE_PROPERTY" mode = "fixedSectionCopy">
					<xsl:with-param name = "tabcount">6</xsl:with-param>
				</xsl:apply-templates>

			<xsl:call-template name = "fiveTabs"/>
			</xsl:element>
			<xsl:call-template name = "lineBreakFourTabs"/>

		</xsl:element>		<!-- end tag CONTEXT_CHILD_STATE  -->
		<xsl:call-template name = "lineBreakThreeTabs"/>

	</xsl:element>		<!--  end tag CONTAINER  -->
	<xsl:call-template name = "lineBreak"/>
</xsl:template>


<xsl:template name = "Session_Container">
	<xsl:param name = "PropertyTable"/>
	<xsl:param name = "FixedContent"/>

	<xsl:variable name = "ContainerName">com.wrq.session.Session</xsl:variable>
	<xsl:variable name="port">
		<xsl:choose>
			<xsl:when test = "$connectionType = 'nsvt'">
				<xsl:value-of select = "/REFLECTION_SETTINGS/CONNECTION/CONNECTION_SETTING[@name= 'NSVTPort']/INTEGER"/>
			</xsl:when>
			<xsl:when test = "$connectionType = 'telnet'">
				<xsl:value-of select = "/REFLECTION_SETTINGS/CONNECTION/CONNECTION_SETTING[@name= 'TelnetPort']/INTEGER"/>
			</xsl:when>
			<!-- ssh port not stored in Reflection settings file  -->
<!--
			<xsl:when test = "$connectionType = 'ssh'">
				<xsl:value-of select = "/REFLECTION_SETTINGS/CONNECTION/CONNECTION_SETTING[@name= 'SSHPort']/INTEGER"/>
			</xsl:when>
-->
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="host">
		<xsl:variable name = "temp">
			<xsl:value-of select = "/REFLECTION_SETTINGS/CONNECTION/CONNECTION_SETTING[@name= 'Host']/STRING"/>
		</xsl:variable>
		<xsl:if test = "string-length($temp) &gt; 0">
			<xsl:value-of select = "$temp"/>
		</xsl:if>
	</xsl:variable>
	<xsl:variable name="miscCount">
		<xsl:choose>
			<xsl:when test = "string-length($host) &gt; 0">2</xsl:when>
			<xsl:otherwise>1</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name = "emulation">
		<xsl:choose>
			<xsl:when test = "$productType = 'HP'">hp</xsl:when>
			<xsl:otherwise>vt</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = "terminalType">
		<xsl:call-template name = "terminalType"/>
	</xsl:variable>
	<xsl:variable name = "transport">
		<xsl:value-of select = "$connectionType"/>
	</xsl:variable>

	<xsl:call-template name = "threeTabs"/>
	<xsl:element name = "CONTAINER">
		<xsl:attribute name = "NAME">com.wrq.session.Session</xsl:attribute>
		<xsl:call-template name = "lineBreakFourTabs"/>

		<xsl:element name = "CONTEXT_CHILD_STATE">
			<xsl:call-template name = "lineBreakFiveTabs"/>

			<xsl:element name = "COMMAND_LIST">
				<xsl:attribute name = "SIZE">
					<xsl:choose>
						<xsl:when test = "$productType = 'HP'">4</xsl:when>
						<xsl:otherwise>3</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
				<xsl:call-template name = "lineBreak"/>

				<!--  commands -->

				<xsl:variable name = "emulatorType">
					<xsl:choose>
						<xsl:when test = "$productType = 'HP'">com.wrq.hp.HPFactory</xsl:when>
						<xsl:otherwise>com.wrq.vt.VTFactory</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>

				<xsl:call-template name = "createCommand">
					<xsl:with-param name = "tabcount">6</xsl:with-param>
					<xsl:with-param name = "commandName">ISession.registerEmulator</xsl:with-param>
				   	<xsl:with-param name = "stringValue">
			   			<xsl:value-of select = "$emulatorType"/>
				   	</xsl:with-param>
				</xsl:call-template>

				<xsl:if test = "$productType = 'HP'">
				<xsl:call-template name = "createCommand">
					<xsl:with-param name = "tabcount">6</xsl:with-param>
					<xsl:with-param name = "commandName">ISession.registerTransport</xsl:with-param>
				   	<xsl:with-param name = "stringValue">nsvt</xsl:with-param>
				</xsl:call-template>
				</xsl:if>

				<xsl:call-template name = "createCommand">
					<xsl:with-param name = "tabcount">6</xsl:with-param>
					<xsl:with-param name = "commandName">ISession.registerTransport</xsl:with-param>
				   	<xsl:with-param name = "stringValue">telnet</xsl:with-param>
				</xsl:call-template>

				<!-- sessionSetup command -->
				<xsl:call-template name = "sixTabs"/>
				<xsl:element name = "COMMAND">
					<xsl:attribute name = "NAME">ISession.sessionSetup</xsl:attribute>
					<xsl:call-template name = "lineBreakSevenTabs"/>

					<xsl:element name = "OBJECT_ARRAY">
						<xsl:attribute name = "SIZE">3</xsl:attribute>
						<xsl:call-template name = "lineBreakEightTabs"/>
						<xsl:element name = "STRING">
							<xsl:value-of select = "$emulation"/>
						</xsl:element>		<!-- end tag STRING -->
						<xsl:call-template name = "lineBreakEightTabs"/>
						<xsl:element name = "STRING">
							<xsl:value-of select = "$terminalType"/>
						</xsl:element>		<!-- end tag STRING -->
						<xsl:call-template name = "lineBreakEightTabs"/>
						<xsl:element name = "STRING">
							<xsl:value-of select = "$transport"/>
						</xsl:element>		<!-- end tag STRING -->
						<xsl:call-template name = "lineBreakSevenTabs"/>
					</xsl:element>		<!-- end tag OBJECT_ARRAY -->
					<xsl:call-template name = "lineBreakSixTabs"/>

				</xsl:element>		<!-- end tag COMMAND -->
				<xsl:call-template name = "lineBreakFiveTabs"/>
			</xsl:element>		<!-- end tag COMMAND_LIST -->
			<xsl:call-template name = "lineBreakFiveTabs"/>

			<xsl:element name = "PROPERTY_STATE">
				<xsl:attribute name = "SIZE">
					<xsl:value-of select = "count($PropertyTable/Property[@container = $ContainerName])
											+ count($FixedContent/CORE_PROPERTY) + $miscCount"/>
				</xsl:attribute>
				<xsl:call-template name = "lineBreak"/>

				<xsl:call-template name = "fillContainer">
					<xsl:with-param name = "PropertyTable" select = "$PropertyTable"/>
					<xsl:with-param name = "startTab">6</xsl:with-param>
					<xsl:with-param name = "ContainerName">
						<xsl:value-of select = "$ContainerName"/>
					</xsl:with-param>
				</xsl:call-template>

			  	<xsl:call-template name = "sixTabs"/>
			  	<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">transportType</xsl:attribute>
					<xsl:call-template name = "lineBreakSevenTabs"/>
					<STRING><xsl:value-of select = "$connectionType"/></STRING>
					<xsl:call-template name = "lineBreakSixTabs"/>
				</xsl:element>
				<xsl:call-template name = "lineBreak"/>

				<xsl:if test = "string-length($host) &gt; 0">
				  	<xsl:call-template name = "sixTabs"/>
				  	<xsl:element name = "CORE_PROPERTY">
						<xsl:attribute name = "NAME">hostURL</xsl:attribute>
						<xsl:call-template name = "lineBreakSevenTabs"/>
						<URL_STRING>
						<xsl:value-of select = "$connectionType"/>
						<xsl:text>://</xsl:text>
						<xsl:value-of select = "$host"/>
						<xsl:if test = "string-length($port) &gt; 0 and not($port = '0')">
							<xsl:text>:</xsl:text>
							<xsl:value-of select = "$port"/>
						</xsl:if>
						</URL_STRING>
						<xsl:call-template name = "lineBreakSixTabs"/>
					</xsl:element>
					<xsl:call-template name = "lineBreak"/>
				</xsl:if>

				<!--  fixed properties  -->
				<xsl:apply-templates select="$FixedContent/CORE_PROPERTY" mode = "fixedSectionCopy">
					<xsl:with-param name = "tabcount">6</xsl:with-param>
				</xsl:apply-templates>

			<xsl:call-template name = "fiveTabs"/>
			</xsl:element>
			<xsl:call-template name = "lineBreakFourTabs"/>

		</xsl:element>		<!-- end tag CONTEXT_CHILD_STATE  -->
		<xsl:call-template name = "lineBreakThreeTabs"/>

	</xsl:element>		<!--  end tag CONTAINER  -->
	<xsl:call-template name = "lineBreak"/>
</xsl:template>


<xsl:template name = "EmulationContainer">
	<xsl:choose>
		<xsl:when test = "$productType = 'HP'">
			<xsl:call-template name = "HP_Container"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name = "VT_Container"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "VT_Container">
	<xsl:call-template name = "CreateContainer">
		<xsl:with-param name = "ContainerName">com.wrq.vt.VT</xsl:with-param>
		<xsl:with-param name = "PropertyTable" select = "$VTPropertyTable"/>
		<xsl:with-param name = "FixedContent" select = "msxsl:node-set($VTFixedContent)"/>
	</xsl:call-template>
</xsl:template>


<xsl:template name = "HP_Container">
	<xsl:variable name = "PropertyTable" select = "$HPPropertyTable"/>
	<xsl:variable name = "FixedContent"  select = "msxsl:node-set($HPFixedContent)"/>
	<xsl:variable name = "fixedcount" 	 select = "count($FixedContent/CORE_PROPERTY)"/>

	<xsl:variable name = "HPfkeyColors" select = 
		"/REFLECTION_SETTINGS/COLORS/COLOR_ATTRIBUTES/COLOR_ATTRIBUTE[@name='Function Keys']"/>

	<xsl:variable name = "fkeyPropertyCount">
		<xsl:choose>
		<xsl:when test = "string($HPfkeyColors)">
			<xsl:value-of select = "2"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select = "0"/>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
  
	<xsl:call-template name = "threeTabs"/>
	<xsl:element name = "CONTAINER">
		<xsl:attribute name = "NAME">com.wrq.hp.HP</xsl:attribute>
		<xsl:call-template name = "lineBreakFourTabs"/>

		<xsl:element name = "PROPERTY_STATE">
			<xsl:attribute name = "SIZE">
				<xsl:value-of select = "count($PropertyTable/Property[@container = 'com.wrq.hp.HP']) + 
					count(/REFLECTION_SETTINGS/FUNCTION_KEYS/HP_USER_FUNCTION_KEYS/HP_USER_KEY)       +
					number($fkeyPropertyCount) + $fixedcount"/>	
			</xsl:attribute>
			<xsl:call-template name = "lineBreak"/>

			<xsl:call-template name = "fillContainer">
				<xsl:with-param name = "PropertyTable" select = "$PropertyTable"/>
				<xsl:with-param name = "ContainerName">com.wrq.hp.HP</xsl:with-param>
			</xsl:call-template>

			<xsl:if test = "$fixedcount &gt; '0'">
				<xsl:apply-templates select="$FixedContent/CORE_PROPERTY" mode = "fixedSectionCopy">
					<xsl:with-param name = "tabcount">5</xsl:with-param>
				</xsl:apply-templates>
			</xsl:if>

			<xsl:if test = "$fkeyPropertyCount = '2'">
				<xsl:call-template name = "HPfkeyColorProperties">
					<xsl:with-param name = "HPfkeyColors" select = "$HPfkeyColors"/>
				</xsl:call-template>
			</xsl:if>

			<xsl:call-template name = "HP_FunctionKeys"/>
			<xsl:call-template name = "fourTabs"/>
		</xsl:element>
		<xsl:call-template name = "lineBreakThreeTabs"/>

	</xsl:element>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>



<xsl:template name = "HPfkeyColorProperties">
	<xsl:param name = "HPfkeyColors"/>

  	<xsl:call-template name = "fiveTabs"/>
  	<xsl:element name = "CORE_PROPERTY">
		<xsl:attribute name = "NAME">functionKeyButtonColor</xsl:attribute>
		<xsl:call-template name = "lineBreakSixTabs"/>
		<COLOR><xsl:value-of select = "$HPfkeyColors/BACKGROUND/COLOR"/></COLOR>
		<xsl:call-template name = "lineBreakFiveTabs"/>
	</xsl:element>
	<xsl:call-template name = "lineBreakFiveTabs"/>

  	<xsl:element name = "CORE_PROPERTY">
		<xsl:attribute name = "NAME">functionKeyTextColor</xsl:attribute>
		<xsl:call-template name = "lineBreakSixTabs"/>
		<COLOR><xsl:value-of select = "$HPfkeyColors/FOREGROUND/COLOR"/></COLOR>
		<xsl:call-template name = "lineBreakFiveTabs"/>
	</xsl:element>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>



<xsl:template name = "HP_FunctionKeys">
	<xsl:variable name = "fkeyAttributeTable" select = "$FkeyAttributeTable"/>
 	<xsl:for-each select="/REFLECTION_SETTINGS/FUNCTION_KEYS/HP_USER_FUNCTION_KEYS/HP_USER_KEY">
		<xsl:call-template name = "fiveTabs"/>

		<xsl:element name = "CORE_PROPERTY">
			<xsl:attribute name = "NAME">
				<xsl:text>userKey</xsl:text>
				<xsl:value-of select = "@keynumber"/>
			</xsl:attribute>
			<xsl:call-template name = "lineBreakSixTabs"/>

			<xsl:element name = "HP_USER_KEY">
			<xsl:call-template name = "lineBreakSevenTabs"/>

				<xsl:element name = "LABEL">
					<xsl:value-of select = "LABEL"/>
				</xsl:element>
				<xsl:call-template name = "lineBreakSevenTabs"/>

				 <xsl:element name = "DEFINITION">
					<xsl:call-template name = "translateCtrlChars">
						<xsl:with-param name = "text" select = "DEFINITION"/>
					</xsl:call-template>
				</xsl:element>
				<xsl:call-template name = "lineBreakSevenTabs"/>

				<xsl:element name = "INTEGER">
					<xsl:variable name = "attributeEntry" select = "$fkeyAttributeTable/Type[@name = current()/FKEY_ATTRIBUTE]"/>
					<xsl:variable name = "attribute">
						<xsl:choose>
							<xsl:when test = "$attributeEntry/@migratedType">
								 <xsl:value-of select = "$attributeEntry/@migratedType"/>
							</xsl:when>
							<xsl:otherwise>2</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<xsl:value-of select = "$attribute"/>
				</xsl:element>
				<xsl:call-template name = "lineBreakSixTabs"/>
			</xsl:element>
			<xsl:call-template name = "lineBreakFiveTabs"/>
		</xsl:element>
		<xsl:call-template name = "lineBreak"/>
	</xsl:for-each>
</xsl:template>


<xsl:template name = "rwebColor">
	<xsl:param name = "node"/>
	<xsl:param name = "swapcolors" select = "false"/>

	<xsl:variable name = "colorTable" select = "$ColorTable"/>
	<xsl:variable name = "FGEntry" select = "$colorTable/Color[@rwinColor = $node/FOREGROUND/COLOR]"/>
	<xsl:variable name = "fgcolor">
		<xsl:choose>
			<xsl:when  test = "string-length($FGEntry/@rwebColor) &gt; 0">
				<xsl:value-of select= "$FGEntry/@rwebColor"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select = "$node/FOREGROUND/COLOR"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = "BGEntry" select = "$colorTable/Color[@rwinColor = $node/BACKGROUND/COLOR]"/>
	<xsl:variable name = "bgcolor">
		<xsl:choose>
			<xsl:when  test = "string-length($BGEntry/@rwebColor) &gt; 0">
				<xsl:value-of select= "$BGEntry/@rwebColor"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select = "$node/BACKGROUND/COLOR"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:call-template name = "sixTabs"/>

	<xsl:element name = "COLOR_ARRAY">
		<xsl:attribute name = "SIZE">
			<xsl:value-of select = "2"/>
		</xsl:attribute>
		<xsl:call-template name = "lineBreakSevenTabs"/>

		<xsl:choose>
			<xsl:when test = "$swapcolors = 'true'">
				<xsl:element name = "COLOR">
					<xsl:value-of select = "$bgcolor"/>
				</xsl:element>
				<xsl:call-template name = "lineBreakSevenTabs"/>
				<xsl:element name = "COLOR">
					<xsl:value-of select = "$fgcolor"/>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>

				<xsl:element name = "COLOR">
					<xsl:value-of select = "$fgcolor"/>
				</xsl:element>
				<xsl:call-template name = "lineBreakSevenTabs"/>
				<xsl:element name = "COLOR">
					<xsl:value-of select = "$bgcolor"/>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:call-template name = "lineBreakSixTabs"/>

	</xsl:element>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>
	


<xsl:template name = "Colors">
	<xsl:variable name = "attributeCount">
		<xsl:choose>
			<xsl:when test = "$productType = 'HP'">17</xsl:when>
			<xsl:otherwise>16</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = "attirbuteLimit" select = "$attributeCount + 1"/>
	<xsl:variable name = "colorTable" select = "$ColorTable"/>
	<xsl:variable name = "attribute" select = "/REFLECTION_SETTINGS/COLORS/COLOR_ATTRIBUTES/COLOR_ATTRIBUTE"/>
	<xsl:variable name = "swapcolors">
		<xsl:choose>
			<xsl:when test = "$properties/PROPERTY[@name='InverseVideo']/BOOLEAN = 'True'">true</xsl:when>
			<xsl:otherwise>false</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:call-template name = "threeTabs"/>
 	<xsl:element name = "CONTAINER">
		<xsl:attribute name = "NAME">AttributeDisplayMap</xsl:attribute>
		<xsl:call-template name = "lineBreakFourTabs"/>

		<xsl:element name = "TD_COLOR_MAP">
			<xsl:call-template name = "lineBreakFiveTabs"/>

			<SHIFT_COUNT>0</SHIFT_COUNT>
			<xsl:call-template name = "lineBreakFiveTabs"/>

			<SWAPPED>							
				<xsl:value-of select = "$swapcolors"/>
			</SWAPPED>
			<xsl:call-template name = "lineBreakFiveTabs"/>
			
			<xsl:element name = "OBJECT_ARRAY">
				<xsl:attribute name = "SIZE">
					<xsl:value-of select = "$attributeCount"/>
				</xsl:attribute>
				<xsl:call-template name = "lineBreak"/>
		   
				<!-- reorder to rweb attribute order  -->
				<xsl:call-template name = "rwebColor">
					<xsl:with-param name = "node" select = "$attribute[@name='Normal']"/>
					<xsl:with-param name = "swapcolors" select = "$swapcolors"/>
				</xsl:call-template>
				<xsl:call-template name = "rwebColor">
					<xsl:with-param name = "node" select = "$attribute[@name='Halfbright|Bold']"/>
					<xsl:with-param name = "swapcolors" select = "$swapcolors"/>
				</xsl:call-template>
				<xsl:call-template name = "rwebColor"> 
					<xsl:with-param name = "node" select = "$attribute[@name='Blink']"/>
					<xsl:with-param name = "swapcolors" select = "$swapcolors"/>
				</xsl:call-template>
				<xsl:call-template name = "rwebColor"> 
					<xsl:with-param name = "node" select = "$attribute[@name='Halfbright|Bold Blink']"/>
					<xsl:with-param name = "swapcolors" select = "$swapcolors"/>
				</xsl:call-template>
				<xsl:call-template name = "rwebColor"> 
					<xsl:with-param name = "node" select = "$attribute[@name='Inverse']"/>
					<xsl:with-param name = "swapcolors" select = "$swapcolors"/>
				</xsl:call-template>
				<xsl:call-template name = "rwebColor"> 
					<xsl:with-param name = "node" select = "$attribute[@name='Halfbright|Bold Inverse']"/>
					<xsl:with-param name = "swapcolors" select = "$swapcolors"/>
				</xsl:call-template>
				<xsl:call-template name = "rwebColor"> 
					<xsl:with-param name = "node" select = "$attribute[@name='Inverse Blink']"/>
					<xsl:with-param name = "swapcolors" select = "$swapcolors"/>
				</xsl:call-template>
				<xsl:call-template name = "rwebColor"> 
					<xsl:with-param name = "node" select = "$attribute[@name='Halfbright|Bold Inverse Blink']"/>
					<xsl:with-param name = "swapcolors" select = "$swapcolors"/>
				</xsl:call-template>
				<xsl:call-template name = "rwebColor"> 
					<xsl:with-param name = "node" select = "$attribute[@name='Underline']"/>
					<xsl:with-param name = "swapcolors" select = "$swapcolors"/>
				</xsl:call-template>
				<xsl:call-template name = "rwebColor"> 
					<xsl:with-param name = "node" select = "$attribute[@name='Halfbright|Bold Underline']"/>
					<xsl:with-param name = "swapcolors" select = "$swapcolors"/>
				</xsl:call-template>								  
				<xsl:call-template name = "rwebColor"> 
					<xsl:with-param name = "node" select = "$attribute[@name='Underline Blink']"/>
					<xsl:with-param name = "swapcolors" select = "$swapcolors"/>
				</xsl:call-template>
				<xsl:call-template name = "rwebColor"> 
					<xsl:with-param name = "node" select = "$attribute[@name='Halfbright|Bold Underline Blink']"/>
					<xsl:with-param name = "swapcolors" select = "$swapcolors"/>
				</xsl:call-template>
				<xsl:call-template name = "rwebColor"> 
					<xsl:with-param name = "node" select = "$attribute[@name='Underline Inverse']"/>
					<xsl:with-param name = "swapcolors" select = "$swapcolors"/>
				</xsl:call-template>
				<xsl:call-template name = "rwebColor"> 
					<xsl:with-param name = "node" select = "$attribute[@name='Halfbright|Bold Underline Inverse']"/>
					<xsl:with-param name = "swapcolors" select = "$swapcolors"/>
				</xsl:call-template>
				<xsl:call-template name = "rwebColor"> 
					<xsl:with-param name = "node" select = "$attribute[@name='Underline Inverse Blink']"/>
					<xsl:with-param name = "swapcolors" select = "$swapcolors"/>
				</xsl:call-template>
				<xsl:call-template name = "rwebColor"> 
					<xsl:with-param name = "node" select = "$attribute[@name='Halfbright|Bold Underline Inverse Blink']"/>
					<xsl:with-param name = "swapcolors" select = "$swapcolors"/>
				</xsl:call-template>

				<xsl:if test = "$productType = 'HP'">
					<!-- default normal color -->
					<xsl:call-template name = "rwebColor">
						<xsl:with-param name = "node" select = "$attribute[@name='Normal']"/>
						<xsl:with-param name = "swapcolors" select = "$swapcolors"/>
					</xsl:call-template>
				</xsl:if>

				<xsl:call-template name = "fiveTabs"/>
			</xsl:element>
			<xsl:call-template name = "lineBreakFourTabs"/>
		</xsl:element>
		<xsl:call-template name = "lineBreakThreeTabs"/>
	</xsl:element>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>



<xsl:template name = "isMappingMigratable">
	<xsl:param name = "node" select = "current()"/>
	<xsl:choose>
		<xsl:when test = "$productType = 'HP'">
			<xsl:call-template name = "isHPMappingMigratable">
				<xsl:with-param name = "node" select = "$node"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name = "isVTMappingMigratable">
				<xsl:with-param name = "node" select = "$node"/>
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>



<xsl:template name = "isHPMappingMigratable">
	<xsl:param name = "node" select = "current()"/>
	<xsl:choose>
		<xsl:when test = "($node/COMMAND_TYPE = 'Transmit Text')">true</xsl:when>

		<xsl:when test = "($node/COMMAND_TYPE = 'Terminal Command') or 
					($node/COMMAND_TYPE = 'Menu Command')">

			<xsl:variable name = "keyTable" select = "msxsl:node-set($HPKeymapMappingTable)"/>
			<xsl:variable name = "TerminalkeyTable" select = "msxsl:node-set($HPTerminalKeyTable)"/>
			<xsl:variable name = "mappedFromTable1" select = "$keyTable/Mapping[@name = $node/MAPPING]"/>
			<xsl:variable name = "mappedFromTable2" select = "$TerminalkeyTable/Key[@name = $node/MAPPING]"/>

			<xsl:variable name = "mapped">
				<xsl:choose>
					<xsl:when test = "string($mappedFromTable1/@migratedCommand)">
						<xsl:value-of select = "$mappedFromTable1/@migratedCommand"/>
					</xsl:when>
					<xsl:when test = "string($mappedFromTable2/@migratedKey)">
						<xsl:value-of select = "$mappedFromTable2/@migratedKey"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:choose>
				<xsl:when test = "string($mapped)">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>false</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "isVTMappingMigratable">
	<xsl:param name = "node" select = "current()"/>
	<xsl:choose>
		<xsl:when test = "($node/COMMAND_TYPE = 'Transmit Text')">true</xsl:when>

		<xsl:when test = "($node/COMMAND_TYPE = 'Terminal Command') or 
					($node/COMMAND_TYPE = 'Menu Command')">

			<xsl:variable name = "keyTable" select = "msxsl:node-set($VTKeymapMappingTable)"/>
			<xsl:variable name = "TerminalkeyTable" select = "msxsl:node-set($VTTerminalKeyTable)"/>
			<xsl:variable name = "mappedFromTable1" select = "$keyTable/Mapping[@name = $node/MAPPING]"/>
			<xsl:variable name = "mappedFromTable2" select = "$TerminalkeyTable/Key[@name = $node/MAPPING]"/>

			<xsl:variable name = "mapped">
				<xsl:choose>
					<xsl:when test = "string($mappedFromTable1/@migratedCommand)">
						<xsl:value-of select = "$mappedFromTable1/@migratedCommand"/>
					</xsl:when>
					<xsl:when test = "string($mappedFromTable2/@migratedKey)">
						<xsl:value-of select = "$mappedFromTable2/@migratedKey"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:choose>
				<xsl:when test = "string($mapped)">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>false</xsl:otherwise>
	</xsl:choose>
</xsl:template>



<xsl:template name="keyMapping">
	<xsl:choose>
		<xsl:when test = "(COMMAND_TYPE = 'Transmit Text')">
			<xsl:call-template name = "transmitText"/>
		</xsl:when>
		<xsl:when test = "(COMMAND_TYPE = 'Terminal Command') or 
						  (COMMAND_TYPE = 'Menu Command')">
			<xsl:call-template name = "terminalCommand"/>
		</xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template name="transmitText">
	<xsl:element name = "COMMAND_ACTION">
		<xsl:call-template name = "lineBreakSevenTabs"/>
		<xsl:element name = "COMMAND">
			<xsl:attribute name = "NAME">Emulator.transmitString</xsl:attribute>
			<xsl:call-template name = "lineBreakEightTabs"/>
				<xsl:element name = "OBJECT_ARRAY">
					<xsl:attribute name = "SIZE">1</xsl:attribute>
					<xsl:call-template name = "lineBreakNineTabs"/>
					<xsl:element name = "STRING">
						<xsl:call-template name="decodeMappingText">
							<xsl:with-param name = "string" select = "MAPPING"/>
						</xsl:call-template>
					</xsl:element>
					<xsl:call-template name = "lineBreakEightTabs"/>
				</xsl:element>
			<xsl:call-template name = "lineBreakSevenTabs"/>
		</xsl:element>
		<xsl:call-template name = "lineBreakSixTabs"/>
	</xsl:element>
	<xsl:call-template name = "lineBreakFiveTabs"/>
</xsl:template>


<xsl:template name = "decodeCtrlChars">
	<xsl:param name = "ctrlChars"/>

	<xsl:variable name = "ctrlchar">
		<xsl:choose>	
			<xsl:when test = "contains($ctrlChars, '+')">
				 <xsl:value-of select = "normalize-space(substring-before($ctrlChars,'+'))"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select = "normalize-space($ctrlChars)"/>
			</xsl:otherwise>
		</xsl:choose>	
	</xsl:variable>

	<xsl:variable name = "remaining" select = "normalize-space(substring-after($ctrlChars,'+'))"/>

	<xsl:if test = "string($ctrlchar)">
		<xsl:variable name = "charcode" select = "$CtrlCharTable/Char[@name = $ctrlchar]/@code"/>
		<xsl:choose>
			<xsl:when test = "string($charcode)">
				<xsl:value-of disable-output-escaping="yes" select = "concat('&amp;#',$charcode,';')"/>
			</xsl:when>
		</xsl:choose>
	</xsl:if>

	<xsl:if test = "string($remaining)">
		<xsl:call-template name = "decodeCtrlChars">
			<xsl:with-param name = "ctrlChars" select = "$remaining"/>
		</xsl:call-template>
	</xsl:if>
</xsl:template>



<xsl:template name = "decodeText">
	<xsl:param name = "text"/>

	<xsl:choose>
		<xsl:when test = "contains($text, '^')">
			<xsl:variable name = "textpart">
				<xsl:value-of select = "substring-before($text, '^')"/>
			</xsl:variable>
			<xsl:value-of select = "$textpart"/>

			<xsl:variable name = "remaining" select = "substring(substring-after($text,'^'), 2)"/>

			<xsl:variable name = "char"	select = "translate(substring(substring-after($text,'^'),1,1),
								 'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')"/>

			<xsl:variable name = "charcode" select = "$CtrlCodeTable/Char[@name = $char]/@code"/>
			<xsl:choose>
				<xsl:when test = "string($charcode)">
					<xsl:value-of disable-output-escaping = "yes" select = "concat('&amp;#', $charcode,';')"/>
				</xsl:when>
			</xsl:choose>
			<xsl:if test = "string($remaining)">
				<xsl:call-template name = "decodeText">
					<xsl:with-param name = "text" select = "$remaining"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select = "$text"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>






<xsl:template name="decodeMappingText">
	<xsl:param name = "string"/>
	
	<xsl:choose>
		<xsl:when test = "not(contains($string, '&quot;') or contains($string, '+'))">
			<!-- single control character -->
			<xsl:variable name = "ctrlchar" select = "normalize-space($string)"/>
			<xsl:variable name = "charcode" select = "$CtrlCharTable/Char[@name = $ctrlchar]/@code"/>
			<xsl:choose>
				<xsl:when test = "string($charcode)">
					<xsl:value-of disable-output-escaping="yes" select = "concat('&amp;#',$charcode,';')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select = "$string"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:when test = "contains($string, '&quot;') and not(contains($string, '+'))">
			<!-- simple text sting inclosed in quotes -->
			<xsl:value-of select = "substring-before(substring-after($string,'&quot;'),'&quot;')"/>
		</xsl:when>
		<xsl:otherwise>
			<!-- multi-part string, plus sign(s) combine some combination of control chars and text -->
			<!-- could also have a text string which includes a plus sign, e.g. "+" or "A + B" -->
			<xsl:variable name = "leftOperand">
				<xsl:choose>
					<xsl:when test = "starts-with($string,'&quot;')">
						<xsl:value-of select="concat('&quot;',
							substring-before(substring($string,2), '&quot;'),'&quot;')"/>
					</xsl:when>
					<xsl:when test = "contains($string, '+')">
						<xsl:value-of select="normalize-space(substring-before($string, '+'))"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select = "normalize-space($string)"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>		  
			<xsl:variable name = "remainder">
				<xsl:choose>
					<xsl:when test = "contains($string, '+')">
						<xsl:value-of select="normalize-space(substring-after($string, '+'))"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name = "rightOperand">
				<xsl:choose>
					<xsl:when test = "starts-with($remainder,'&quot;')">
						<xsl:value-of select="concat('&quot;',
							substring-before(substring($remainder,2), '&quot;'),'&quot;')"/>
					</xsl:when>
					<xsl:when test = "contains($remainder, '+')">
						<xsl:value-of select="normalize-space(substring-before($remainder, '+'))"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select = "$remainder"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name = "remainingTerms">
				<xsl:choose>
					<xsl:when test = "starts-with($remainder,'&quot;')">
						<xsl:value-of select="normalize-space(substring-after(
							substring-after(substring($remainder,2),'&quot;'),'+')  )"/>
					</xsl:when>
					<xsl:when test = "contains($remainder, '+')">
						<xsl:value-of select="normalize-space(substring-after($remainder, '+'))"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>

			<!-- deal with first operand -->
			<xsl:choose>
				<xsl:when test = "starts-with($leftOperand,'&quot;')">
					<xsl:value-of select = "substring-before(substring-after($string,'&quot;'),'&quot;')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test = "string($leftOperand)">
						<xsl:call-template name="decodeMappingText">
							<xsl:with-param name = "string" select = "$leftOperand"/>
						</xsl:call-template>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>

			<!-- deal with second operand -->
			<xsl:if test = "string($rightOperand)">
				<xsl:choose>
					<xsl:when test = "starts-with($rightOperand,'&quot;')">
						<xsl:value-of select = "substring-before(substring-after($rightOperand,'&quot;'),'&quot;')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="decodeMappingText">
							<xsl:with-param name = "string" select = "$rightOperand"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>

			<!-- deal with all the rest -->
			<xsl:if test = "string($remainingTerms)">
				<xsl:call-template name="decodeMappingText">
					<xsl:with-param name = "string" select = "$remainingTerms"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name="terminalCommand">
	<xsl:choose>
		<xsl:when test = "$productType = 'HP'">
			<xsl:call-template name = "terminalCommandMapping">
				<xsl:with-param name = "TerminalkeyTable" 
								select = "msxsl:node-set($HPTerminalKeyTable)"/>
				<xsl:with-param name = "keyTable" 
								select = "msxsl:node-set($HPKeymapMappingTable)"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name = "terminalCommandMapping">
				<xsl:with-param name = "TerminalkeyTable" 
								select = "msxsl:node-set($VTTerminalKeyTable)"/>
				<xsl:with-param name = "keyTable" 
								select = "msxsl:node-set($VTKeymapMappingTable)"/>
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

   
<xsl:template name="terminalCommandMapping">
	<xsl:param name = "TerminalkeyTable"/>
	<xsl:param name = "keyTable"/> 
	 
	<xsl:variable name = "mappedFromTable1" select = "$keyTable/Mapping[@name = current()/MAPPING]"/>
	<xsl:variable name = "mappedFromTable2" select = "$TerminalkeyTable/Key[@name = current()/MAPPING]"/>

	<xsl:variable name = "mapped">
		<xsl:choose>
			<xsl:when test = "string($mappedFromTable1/@migratedCommand)">
				<xsl:value-of select = "$mappedFromTable1/@migratedCommand"/>
			</xsl:when>
			<xsl:when test = "string($mappedFromTable2/@migratedKey)">
				<xsl:value-of select = "$mappedFromTable2/@migratedKey"/>
			</xsl:when>
		</xsl:choose>
	</xsl:variable>

	<xsl:if test = "string($mapped)">
		<xsl:variable name = "command">
			<xsl:choose>
				<xsl:when test = "string($mappedFromTable1/@migratedCommand)">
					<xsl:value-of select = "$mappedFromTable1/@migratedCommand"/>
				</xsl:when>
				<xsl:otherwise>Emulator.transmitTerminalKey</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:variable name = "mapping">	
			<xsl:choose>
				<xsl:when test = "string($mappedFromTable2/@migratedKey)">
					<xsl:value-of select = "$mappedFromTable2/@migratedKey"/>
				</xsl:when>
				<xsl:otherwise></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:element name = "COMMAND_ACTION">
			<xsl:call-template name = "lineBreakSevenTabs"/>
			<xsl:element name = "COMMAND">
				<xsl:attribute name = "NAME">
					<xsl:value-of select = "$command"/>
				</xsl:attribute>
				<xsl:call-template name = "lineBreakEightTabs"/>
				<xsl:choose>
					<xsl:when test = "string($mapping) = ''">
						<NULL></NULL>	
					</xsl:when>
					<xsl:otherwise>
						<xsl:element name = "OBJECT_ARRAY">
							<xsl:attribute name = "SIZE">1</xsl:attribute>
							<xsl:call-template name = "lineBreakEightTabs"/>
							<xsl:element name = "INTEGER">
								<xsl:value-of select = "$mapping"/>
							</xsl:element>
							<xsl:call-template name = "lineBreakEightTabs"/>
						</xsl:element>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:call-template name = "lineBreakSevenTabs"/>
			</xsl:element>
			<xsl:call-template name = "lineBreakSixTabs"/>
		</xsl:element>
		<xsl:call-template name = "lineBreakFiveTabs"/>
	</xsl:if>
</xsl:template>





<xsl:template name = "lineBreak">
	<xsl:text>&#10;</xsl:text>
</xsl:template>

<xsl:template name = "lineBreakOneTab">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "lineBreakTwoTabs">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "lineBreakThreeTabs">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "lineBreakFourTabs">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "lineBreakFiveTabs">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "lineBreakSixTabs">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;&#9;&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "lineBreakSevenTabs">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;&#9;&#9;&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "lineBreakEightTabs">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;&#9;&#9;&#9;&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "lineBreakNineTabs">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;&#9;&#9;&#9;&#9;&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "tab">
	<xsl:text>&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "twoTabs">
	<xsl:text>&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "threeTabs">
	<xsl:text>&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "fourTabs">
	<xsl:text>&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "fiveTabs">
	<xsl:text>&#9;&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "sixTabs">
	<xsl:text>&#9;&#9;&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "sevenTabs">
	<xsl:text>&#9;&#9;&#9;&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "tabs">
	<xsl:param name = "tabcount"/>

	<xsl:if test = "$tabcount &gt; 0">
		<xsl:text>&#9;</xsl:text>	
		<xsl:call-template name = "tabs">
			<xsl:with-param name = "tabcount">
				<xsl:value-of select = "$tabcount - 1"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>


<xsl:template name = "decodeCtrlChar">
	<xsl:param name = "text"/>
	<xsl:choose>
		<xsl:when test = "string-length($text) = 4 and contains($text, '#') and
						 string-length(substring-after($text, '#')) = 3">
			<xsl:value-of select = "concat('&#38;', concat($text, ';'))"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select = "$text"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "translateCtrlChars">
	<xsl:param name = "text"/>
	<xsl:variable name = "startOfDigits">
		<xsl:value-of select = "substring-after($text, '#')"/>
	</xsl:variable>

	<xsl:choose>	
		<xsl:when test = "contains($text, '#') and contains($startOfDigits, ';')">
			<xsl:variable name = "pre">
				<xsl:value-of select = "substring-before($text, '#')"/>
			</xsl:variable>
			<xsl:variable name = "first">
				<xsl:value-of select = 
					"concat('#', substring-after(concat(substring-before($text, ';'), ';'), '#'))"/>
			</xsl:variable>
			<xsl:variable name = "remaining">
				<xsl:value-of select = "substring-after($text, ';')"/>
			</xsl:variable>
			<xsl:variable name = "charCode">
				<xsl:value-of select = "substring-before($startOfDigits, ';')"/>
			</xsl:variable>

			<xsl:choose>
				<xsl:when test = "string-length($charCode) = 3  and not(number($charCode) = Nan)">
					<xsl:variable name = "rest">
						<xsl:call-template name = "translateCtrlChars">
							<xsl:with-param name = "text">
								<xsl:value-of select = "$remaining"/>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:value-of disable-output-escaping = "yes"
						select = "concat(concat($pre, concat('&amp;', $first)), $rest)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select = "$text"/>	
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select = "$text"/>
		</xsl:otherwise>
	</xsl:choose>	
</xsl:template>


<xsl:template name = "isSourceXMLValid">
	<xsl:choose>
		<xsl:when test = "($XMLversion &gt; 1) and ($settingsMode = 'All') 			and
						  (($emulator = 1)	or ($emulator = 2) or ($emulator = 4)) 	and
						  ($settingsType = 'SETTINGS')								and
						  (name($root) = 'REFLECTION_SETTINGS')	
						  ">true</xsl:when>
		<xsl:when test = "($configType = 'keymap') and ($XMLversion &gt; 1) 		and 
						  (($emulator = 1)	or ($emulator = 2) or ($emulator = 4)) 	and
 						  (($settingsType ='KEYMAP') or ($settingsType='SETTINGS')) and
						  (name($root) = 'REFLECTION_SETTINGS')	
						  ">true</xsl:when>
		<xsl:otherwise></xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "reportBadSourceXML">
	<xsl:call-template name = "lineBreak"/>
	<TransformFailed>
		<xsl:call-template name = "lineBreak"/>
		<xsl:call-template name = "lineBreak"/>
		<Error>Transform Failed</Error>
		<xsl:call-template name = "lineBreak"/>
		<xsl:choose>
			<xsl:when test = "not(name($root) = 'REFLECTION_SETTINGS')">
				<Description>Source XML is not an exported Reflection Settings file.</Description>
			</xsl:when>
			<xsl:when test = "$XMLversion &lt; 2">
				<Description>This transform requires version 2.0 or greater exported Reflection Settings.</Description>
			</xsl:when>
			<xsl:when test = "not($settingsMode = 'All')">
				<Description>This transform requires a complete exported Reflection Settings file  (not just changed settings).</Description>
			</xsl:when>
			<xsl:when test = "not($settingsType = 'SETTINGS')">
				<Description>This transform requires a complete exported Reflection Settings file.</Description>
			</xsl:when>
			<xsl:when test = "not(($emulator = 1) or ($emulator = 2) or ($emulator = 4))">
				<Description>This transform requires an exported Reflection Settings file</Description>
				<xsl:call-template name = "lineBreak"/>
				<Description>from Reflection for HP, Unix and Digital, or ReGIS Graphics</Description>
			</xsl:when>
			<xsl:otherwise>
				<Description>Source XML is not an exported Reflection Settings file.</Description>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:call-template name = "lineBreak"/>
		<Description>As created by Reflection 10.0 or later.</Description>
		<xsl:call-template name = "lineBreak"/>
	</TransformFailed>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>



<xsl:template name="CountMigratableKeymappings">
	<xsl:variable name = "total">
		<xsl:call-template name = "MigratableKeymappings">
			<xsl:with-param name = "list" select="/REFLECTION_SETTINGS/KEYMAP/KEY_MAPPING"/>
		</xsl:call-template>
	</xsl:variable>
	<xsl:value-of select="$total"/>
</xsl:template>

<xsl:template name="CountMigratableKeypadKeymappings">
	<xsl:variable name = "total">
		<xsl:call-template name = "MigratableKeypadmappings">
			<xsl:with-param name = "list" select="/REFLECTION_SETTINGS/KEYMAP/KEY_MAPPING"/>
		</xsl:call-template>
	</xsl:variable>
	<xsl:value-of select="$total"/>
</xsl:template>



<xsl:template name="MigratableKeymappings">
	<xsl:param name = "list"/>
	<xsl:param name = "count" select = "0"/>

	<xsl:variable name = "keycodeTable" select = "$PCkeycodeTable"/>
	<xsl:variable name = "modifierTable" select = "$ModifierTable"/>

	<xsl:choose>
		<xsl:when test="not($list)">
			<xsl:value-of select = "$count"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:variable name = "first" 		 select = "$list[1]"/>
			<xsl:variable name = "KeycodeEntry"  select = "$keycodeTable/Key[@VirtKey = $first/VKEY]"/>
			<xsl:variable name = "ModifierEntry" select = "$modifierTable/Key[@mods = $first/MODS]"/>
			<xsl:variable name = "extendedKey"   select = "$KeycodeEntry/@ExtendedKey"/> 
			<xsl:variable name = "migratedKey">
				<xsl:choose>
					<xsl:when test = "string($extendedKey)">NotFound</xsl:when>
					<xsl:when test = "string($KeycodeEntry/@migratedKey)">
						<xsl:value-of select = "$KeycodeEntry/@migratedKey"/>
					</xsl:when>
					<xsl:otherwise>NotFound</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name = "migratedModifier">
				<xsl:choose>
					<xsl:when test = "$ModifierEntry/@migratedModifier">
						 <xsl:value-of select = "$ModifierEntry/@migratedModifier"/>
					</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name = "migratedMapping">
				<xsl:if test = "not(string($extendedKey))">
					<xsl:call-template name = "isMappingMigratable">
						<xsl:with-param name = "node" select = "$first"/>
					</xsl:call-template>
				</xsl:if>
			</xsl:variable>
			<xsl:variable name = "migrated">
				<xsl:choose>
 					<xsl:when test = "not($migratedKey = 'NotFound') and (string($migratedMapping) = 'true')">1</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:call-template name = "MigratableKeymappings">
				<xsl:with-param name = "list" select = "$list[position() > 1]"/>
				<xsl:with-param name = "count" select = "$count + $migrated"/>
			</xsl:call-template>
 		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name="MigratableKeypadmappings">
	<xsl:param name = "list"/>
	<xsl:param name = "count" select = "0"/>

	<xsl:variable name = "keycodeTable" select = "$PCkeycodeTable"/>
	<xsl:variable name = "modifierTable" select = "$ModifierTable"/>

	<xsl:choose>
		<xsl:when test="not($list)">
			<xsl:value-of select = "$count"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:variable name = "first" 		 select = "$list[1]"/>
			<xsl:variable name = "KeycodeEntry"  select = "$keycodeTable/Key[@VirtKey = $first/VKEY]"/>
			<xsl:variable name = "ModifierEntry" select = "$modifierTable/Key[@mods = $first/MODS]"/>
			<xsl:variable name = "extendedKey"   select = "$KeycodeEntry/@ExtendedKey"/> 
			<xsl:variable name = "migratedKey">
				<xsl:choose>
					<xsl:when test = "not(string-length($extendedKey) &gt; 0)">NotFound</xsl:when>
					<xsl:when test = "string($KeycodeEntry/@migratedKey)">
						<xsl:value-of select = "$KeycodeEntry/@migratedKey"/>
					</xsl:when>
					<xsl:otherwise>NotFound</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name = "migratedModifier">
				<xsl:choose>
					<xsl:when test = "$ModifierEntry/@migratedModifier">
						 <xsl:value-of select = "$ModifierEntry/@migratedModifier"/>
					</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name = "migratedMapping">
				<xsl:if test = "string($extendedKey)">
					<xsl:call-template name = "isMappingMigratable">
						<xsl:with-param name = "node" select = "$first"/>
					</xsl:call-template>
				</xsl:if>
			</xsl:variable>
			<xsl:variable name = "migrated">
				<xsl:choose>
 					<xsl:when test = "not($migratedKey = 'NotFound') and (string($migratedMapping) = 'true')">1</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:call-template name = "MigratableKeypadmappings">
				<xsl:with-param name = "list" select = "$list[position() > 1]"/>
				<xsl:with-param name = "count" select = "$count + $migrated"/>
			</xsl:call-template>
 		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

   

<xsl:template name = "terminalType">
	<xsl:choose>
		<xsl:when test = "$productType = 'HP'">
			<xsl:variable name = "PropertyEntry" select = 
		   		"$HPPropertyTable/Property[@name = 'TerminalType' and @container = 'com.wrq.session.Session']"/>
			<xsl:variable name = "migratedValue" 
				select = "$PropertyEntry/ENUMERATION[@value = $terminalType]/@migratedValue"/>
			<xsl:choose>
				<xsl:when test = "string($migratedValue)">
					<xsl:value-of select = "$migratedValue"/>
				</xsl:when>
				<xsl:otherwise>2392A</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>
			<xsl:variable name = "PropertyEntry" select = 
		   		"$VTPropertyTable/Property[@name = 'TerminalType' and @container = 'com.wrq.session.Session']"/>
			<xsl:variable name = "migratedValue" 
				select = "$PropertyEntry/ENUMERATION[@value = $terminalType]/@migratedValue"/>
			<xsl:choose>
				<xsl:when test = "string($migratedValue)">
					<xsl:value-of select = "$migratedValue"/>
				</xsl:when>
				<xsl:otherwise>VT400-7</xsl:otherwise>
			</xsl:choose>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "AppletSignature">
	<xsl:choose>
		<xsl:when test = "$productType = 'HP'">HP</xsl:when>
		<xsl:otherwise>VT</xsl:otherwise>
	</xsl:choose>
	<xsl:text>Applet v4.1</xsl:text>
</xsl:template>


<xsl:template match = "PROPERTIES/PROPERTY" >
	<xsl:call-template name = "threeTabs"/>
	<xsl:copy>
		<xsl:copy-of select="@*"/>
		<xsl:value-of select="."/>
	</xsl:copy>
	<xsl:call-template name = "lineBreak"/>
 </xsl:template>


<xsl:template name = "PropertiesList" >
	<xsl:variable name="listHP"  select = "$HPpropertiesList"/>
	<xsl:variable name="listVT"  select = "$VTpropertiesList"/>

   	<PROPERTIES>
	<xsl:call-template name = "lineBreak"/>
	<xsl:choose>
		<xsl:when test = "$productType = 'HP'">
			<xsl:apply-templates select="$listHP/PROPERTIES/PROPERTY"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:apply-templates select="$listVT/PROPERTIES/PROPERTY"/>
		</xsl:otherwise>
	</xsl:choose>
	<xsl:call-template name = "twoTabs"/>
	</PROPERTIES>
	<xsl:call-template name = "lineBreakTwoTabs"/>
</xsl:template>


<xsl:template name = "KeymapPropertiesList" >
	<xsl:variable name="listHP"  select = "$HPkeymapPropertiesList"/>
	<xsl:variable name="listVT"  select = "$VTkeymapPropertiesList"/>

   	<PROPERTIES>
	<xsl:call-template name = "lineBreak"/>
	<xsl:choose>
		<xsl:when test = "$productType = 'HP'">
			<xsl:apply-templates select="$listHP/PROPERTIES/PROPERTY"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:apply-templates select="$listVT/PROPERTIES/PROPERTY"/>
		</xsl:otherwise>
	</xsl:choose>
	<xsl:call-template name = "twoTabs"/>
	</PROPERTIES>
	<xsl:call-template name = "lineBreakTwoTabs"/>
</xsl:template>


<xsl:template match = "@*|node()" mode = "copy">
	<xsl:param name = "tabcount"/>

	<xsl:if test = "descendant::node() or (name() = 'NULL') or 
					((name() = 'STRING') and (not(descendant::node())))">
		<xsl:call-template name = "tabs">
			<xsl:with-param name = "tabcount" select = "$tabcount"/>
		</xsl:call-template>
	</xsl:if>
		<xsl:copy>
			<xsl:variable name = "tabstops">
				<xsl:choose>
					<!-- <element>text</element> and <NULL></NULL> -->
					<xsl:when test = "./text() or (name() = 'NULL')">
						<xsl:value-of select = "0"/>
					</xsl:when>
					<!-- indent for descendant elements -->
					<xsl:when test = "descendant::node()">
						<xsl:value-of select = "$tabcount + 1"/>
					</xsl:when>
					<!-- just because -->
					<xsl:otherwise>
							<xsl:value-of select = "0"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

			<!-- output any attributes for this element -->
			<xsl:copy-of select="@*"/>

			<!-- linebreak after element unless we want the closing tag on the same line -->
			<xsl:if test="not(text()) and not(name() = 'NULL') and not(name() = 'STRING')">
				<xsl:call-template name = "lineBreak"/>
			</xsl:if>

			<!-- recurse for the rest of the elements -->
	   		<xsl:apply-templates select="@*|node()" mode="copy">
				<xsl:with-param name = "tabcount" select = "$tabstops"/>
			</xsl:apply-templates>

			<!-- tab before outputing closing tag -->
			<xsl:if test = "not(text()) and not(name() = 'NULL') and not(name() = 'STRING')">
				<xsl:call-template name = "tabs">
					<xsl:with-param name = "tabcount" select = "$tabcount"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:copy>

	<!-- linebreak after closing element tag if more to come -->
	<xsl:if test = "descendant::node() or (name() = 'NULL') or (name() = 'STRING')">
	 	<xsl:call-template name = "lineBreak"/>
	</xsl:if>
</xsl:template>




<xsl:template match = "CONTAINER" >
	<xsl:call-template name = "tabs">
		<xsl:with-param name = "tabcount" select = "3"/>
	</xsl:call-template>
	<xsl:copy>
		<xsl:copy-of select="@*"/>
		<xsl:call-template name = "lineBreak"/>
		<xsl:apply-templates select = "@*|node()" mode="copy">
			<xsl:with-param name = "tabcount" select = "4"/>
		</xsl:apply-templates>
		<xsl:call-template name = "tabs">
			<xsl:with-param name = "tabcount" select = "3"/>
		</xsl:call-template>
	</xsl:copy>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>


<xsl:template match = "node()" mode = "fixedSectionCopy">
	<xsl:param name = "tabcount"/>

	<xsl:call-template name = "tabs">
		<xsl:with-param name = "tabcount" select = "$tabcount"/>
	</xsl:call-template>
	<xsl:copy>
		<xsl:copy-of select="@*"/>
		<xsl:call-template name = "lineBreak"/>
		<xsl:apply-templates select = "@*|node()" mode="copy">
			<xsl:with-param name = "tabcount" select = "$tabcount+1"/>
		</xsl:apply-templates>
		<xsl:call-template name = "tabs">
			<xsl:with-param name = "tabcount" select = "$tabcount"/>
		</xsl:call-template>
	</xsl:copy>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>



<xsl:template name="countMigratableProperties">
	<xsl:param name = "ContainerName"/>

	<xsl:choose>
		<xsl:when test = "$productType = 'HP'">
		  	<xsl:call-template name = "MigratableProperties">
		  		<xsl:with-param name = "list" select="$properties/PROPERTY"/>
				<xsl:with-param name = "PropertyTable" select = "$HPPropertyTable"/>
		  		<xsl:with-param name = "ContainerName" select = "$ContainerName"/>
		  	</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
		  	<xsl:call-template name = "MigratableProperties">
		  		<xsl:with-param name = "list" select="$properties/PROPERTY"/>
				<xsl:with-param name = "PropertyTable" select = "$VTPropertyTable"/>
		  		<xsl:with-param name = "ContainerName"  select = "$ContainerName"/>
		  	</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


				  

<xsl:template name="KeymapContainer" >
	<xsl:variable name = "keycodeTable" select = "$PCkeycodeTable"/>
	<xsl:variable name = "modifierTable" select = "$ModifierTable"/>
	<xsl:variable name = "migratableMappings">
		<xsl:call-template name = "CountMigratableKeymappings"/>
	</xsl:variable>

	<xsl:if test = "$migratableMappings &gt; 0">
		<xsl:call-template name = "threeTabs"/>
		<xsl:element name = "CONTAINER">
			<xsl:attribute name = "NAME">KeyMap-4</xsl:attribute>
			<xsl:call-template name = "lineBreakFourTabs"/>

			<xsl:element name = "RKEYSTROKE_ARRAY">
				<xsl:attribute name = "SIZE">
					<xsl:value-of select = "$migratableMappings"/>
				</xsl:attribute>

				<xsl:for-each select="/REFLECTION_SETTINGS/KEYMAP/KEY_MAPPING">
					<xsl:variable name = "KeymapEntry" select = "$keycodeTable/Key[@VirtKey = current()/VKEY]"/>
					<xsl:variable name = "extendedKey" select = "$KeymapEntry/@ExtendedKey"/> 
					<xsl:variable name = "ModifierEntry" select = "$modifierTable/Key[@mods = current()/MODS]"/>
					<xsl:if test = "string-length($KeymapEntry/@migratedKey) &gt; 0">
						<xsl:variable name = "migratedKey" select = "$KeymapEntry/@migratedKey"/>
						<xsl:variable name = "migratedModifier">
							<xsl:choose>
								<xsl:when test = "$ModifierEntry/@migratedModifier">
									 <xsl:value-of select = "$ModifierEntry/@migratedModifier"/>
								</xsl:when>
								<xsl:otherwise>0</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>

						<xsl:variable name = "migratedMapping">
							<xsl:if test = "not(string($extendedKey))">
								<xsl:call-template name = "isMappingMigratable">
									<xsl:with-param name = "node" select = "."/>
								</xsl:call-template>
							</xsl:if>
						</xsl:variable>

						<xsl:if test = "(string-length($migratedKey) &gt; 0) and (string($migratedMapping) = 'true')">
							<xsl:call-template name = "lineBreakFiveTabs"/>
							<xsl:element name = "RKEYSTROKE">
								<xsl:call-template name = "lineBreakSixTabs"/>

								<xsl:element name = "KEYSTROKE">
									<xsl:call-template name = "lineBreakSevenTabs"/>
									<xsl:element name = "KEYCODE">
										<xsl:value-of select="$migratedKey"/>
									</xsl:element>
									<xsl:call-template name = "lineBreakSevenTabs"/>
									<xsl:element name = "MODIFIERS">
										<xsl:value-of select="$migratedModifier"/>
									</xsl:element>
									<xsl:call-template name = "lineBreakSixTabs"/>
								</xsl:element>
								<xsl:call-template name = "lineBreakSixTabs"/>
								<xsl:call-template name = "keyMapping"/>
							</xsl:element>
						</xsl:if>
					</xsl:if>

				</xsl:for-each>		
				<xsl:call-template name = "lineBreakFourTabs"/>
			</xsl:element>
			<xsl:call-template name = "lineBreakThreeTabs"/>
		</xsl:element>
		<xsl:call-template name = "lineBreak"/>
	</xsl:if> 	<!-- if migratableMappings  -->
</xsl:template>


<xsl:template name="KeypadContainer" >
	<xsl:variable name = "keycodeTable" select = "$PCkeycodeTable"/>
	<xsl:variable name = "modifierTable" select = "$ModifierTable"/>
	<xsl:variable name = "migratableKeypadMappings">
		<xsl:call-template name = "CountMigratableKeypadKeymappings"/>
	</xsl:variable>

	<xsl:if test = "$migratableKeypadMappings &gt; 0">
		<xsl:call-template name = "threeTabs"/>
		<xsl:element name = "CONTAINER">
			<xsl:attribute name = "NAME">KeypadMap-6</xsl:attribute>
			<xsl:call-template name = "lineBreakFourTabs"/>

			<xsl:element name = "RKEYSTROKE_ARRAY">
				<xsl:attribute name = "SIZE">
					<xsl:value-of select = "$migratableKeypadMappings"/>
				</xsl:attribute>

				<xsl:for-each select="/REFLECTION_SETTINGS/KEYMAP/KEY_MAPPING">
					<xsl:variable name = "KeymapEntry" select = "$keycodeTable/Key[@VirtKey = current()/VKEY]"/>
					<xsl:variable name = "extendedKey" select = "$KeymapEntry/@ExtendedKey"/> 
					<xsl:variable name = "ModifierEntry" select = "$modifierTable/Key[@mods = current()/MODS]"/>
					<xsl:if test = "string-length($KeymapEntry/@migratedKey) &gt; 0">
						<xsl:variable name = "migratedKey" select = "$KeymapEntry/@migratedKey"/>
						<xsl:variable name = "migratedModifier">
							<xsl:choose>
								<xsl:when test = "$ModifierEntry/@migratedModifier">
									 <xsl:value-of select = "$ModifierEntry/@migratedModifier"/>
								</xsl:when>
								<xsl:otherwise>0</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>

						<xsl:variable name = "migratedMapping">
							<xsl:if test = "string($extendedKey)">
								<xsl:call-template name = "isMappingMigratable">
									<xsl:with-param name = "node" select = "."/>
								</xsl:call-template>
							</xsl:if>
						</xsl:variable>

						<xsl:if test = "(string-length($migratedKey) &gt; 0) and (string($migratedMapping) = 'true')">
							<xsl:call-template name = "lineBreakFiveTabs"/>
							<xsl:element name = "RKEYSTROKE">
								<xsl:call-template name = "lineBreakSixTabs"/>

								<xsl:element name = "KEYSTROKE">
									<xsl:call-template name = "lineBreakSevenTabs"/>
									<xsl:element name = "KEYCODE">
										<xsl:value-of select="$migratedKey"/>
									</xsl:element>
									<xsl:call-template name = "lineBreakSevenTabs"/>
									<xsl:element name = "MODIFIERS">
										<xsl:value-of select="$migratedModifier"/>
									</xsl:element>
									<xsl:call-template name = "lineBreakSixTabs"/>
								</xsl:element>
								<xsl:call-template name = "lineBreakSixTabs"/>
								<xsl:call-template name = "keyMapping"/>
							</xsl:element>
						</xsl:if>
					</xsl:if>
				</xsl:for-each>		
				<xsl:call-template name = "lineBreakFourTabs"/>
			</xsl:element>
			<xsl:call-template name = "lineBreakThreeTabs"/>
		</xsl:element>
		<xsl:call-template name = "lineBreak"/>
	</xsl:if> 	<!-- if migratableMappings  -->
</xsl:template>



<xsl:template name="MigratableProperties">
	<xsl:param name = "list"/>
	<xsl:param name = "PropertyTable"/>
	<xsl:param name = "ContainerName"/>
	<xsl:param name = "count" select = "0"/>

	<xsl:choose>
		<xsl:when test="not($list)">
			<xsl:value-of select = "$count"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:variable name = "current" select = "$list[1]"/>

			<xsl:variable name = "PropertyEntry" select = 
			   "$PropertyTable/Property[(@name = $current/@name) and (@container = $ContainerName)]"/>

			<!-- debug
			<xsl:if test = "count($PropertyEntry) &gt; 0">
				<xsl:call-template name = "lineBreak"/>
				<xsl:call-template name = "tab"/>
				<xsl:text>Multiple Property Table entries for Property:	</xsl:text>
				<xsl:value-of select = "$current/@name"/>
				<xsl:call-template name = "lineBreak"/>
				<xsl:for-each select = "$PropertyEntry">
					<xsl:variable name = "pos" select = "position()"/>
					<xsl:call-template name = "tab"/>
					<xsl:text>migrated name </xsl:text>
					<xsl:value-of select = "$pos"/>
					<xsl:text> : </xsl:text>
					<xsl:value-of select = "$PropertyEntry[$pos]/@migratedName"/>
					<xsl:call-template name = "lineBreak"/>
				</xsl:for-each>
				<xsl:call-template name = "lineBreak"/>
			</xsl:if>
			-->

			<xsl:variable name = "mappedCount" select = "count($PropertyEntry)"/>

			<xsl:call-template name = "MigratableProperties">
				<xsl:with-param name = "list" 			select = "$list[position() > 1]"/>
				<xsl:with-param name = "PropertyTable" 	select = "$PropertyTable"/>
				<xsl:with-param name = "ContainerName" 	select = "$ContainerName"/>
				<xsl:with-param name = "count" 			select = "$count + $mappedCount"/>
			</xsl:call-template>
 		</xsl:otherwise>
	</xsl:choose>
</xsl:template>



	
<xsl:template name = "fillTransportContainer">
	<xsl:param name = "PropertyTable"/>
	<xsl:param name = "startTab" select ="5"/>
	<xsl:param name = "ContainerName"/>

  	<xsl:for-each select="$connectionProperty/CONNECTION_SETTING">
		<xsl:sort select="@name"/>

		<xsl:variable name = "this" select = "."/>
		<xsl:variable name = "PropertyEntry" select = 
		   "$PropertyTable/Property[@name = current()/@name and @container = $ContainerName]"/>

		<xsl:for-each select = "$PropertyEntry">
			<!-- a few rwin properties are migrated to multiple one rweb properties -->
			<xsl:if test = ".">
			<!-- if this property/mode is in the property migration table for this container -->
			<xsl:variable name = "migratedName" select = "./@migratedName"/>
			<xsl:variable name = "type" select = "./@type"/>
			<xsl:variable name = "migratedValue">
				<xsl:choose>
					<xsl:when test = "self::node()[@specialcase = 'true']">
						<!-- handle all the special cases here -->

						<!-- end of special cases  -->
					</xsl:when>
					<xsl:when test = "self::node()[not(@sourcetype)]">
						<!-- source and destination type are the same -->
						<xsl:choose>
							<xsl:when test = "$type = 'BOOLEAN'">
								<xsl:variable name = "value" select = "$this/BOOLEAN"/>
								<xsl:variable name = "opposite">
									<xsl:choose>
										<xsl:when test = "./@noValueMigration = 'false'">true</xsl:when>
										<xsl:otherwise></xsl:otherwise>
									</xsl:choose>
								</xsl:variable>	
								<xsl:choose>
									<xsl:when test = "$opposite = 'true'">
										<xsl:choose>
											<xsl:when test = "$value = 'True'">false</xsl:when>
											<xsl:otherwise>true</xsl:otherwise>								 
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test = "$value = 'True'">true</xsl:when>
											<xsl:otherwise>false</xsl:otherwise>								 
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:when test = "$type = 'INTEGER'">
								<xsl:value-of select = "$this/INTEGER"/>
							</xsl:when>
							<xsl:when test = "$type = 'STRING'">
								<xsl:choose>
									<xsl:when test = "./@noValueMigration = 'false'">
										<xsl:call-template name = "translateCtrlChars">
											<xsl:with-param name = "text" select = "$this/STRING"/>
										</xsl:call-template>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select = "$this/STRING"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select = 
									"./ENUMERATION[@value = $this/ENUMERATION]/@migratedValue"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<!-- source and destination types differ -->
						<xsl:choose>
							<xsl:when test = "./@sourcetype = 'ENUMERATION'">
								<xsl:variable name = "enumValue"
									select = "./ENUMERATION[@value = $this/ENUMERATION]"/>
								<xsl:choose>
									<xsl:when test = "string($enumValue/@migratedValue)">
										<xsl:value-of select = "$enumValue/@migratedValue"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select = "./ENUMERATION[@value = 'other']/@migratedValue"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:when test = "./@sourcetype = 'CHARACTER'">
								<xsl:variable name = "keycode" select = "$RwebKeycodes/Key[@name = $this/CHARACTER]"/>
								<xsl:variable name = "key" select = "$keycode/@migratedKey"/>
								<xsl:choose>
									<xsl:when test = "$this/CHARACTER/@ctrl">
										<xsl:value-of select = "number(substring-after($this/CHARACTER, '#'))"/>
									</xsl:when>
									<xsl:when test = "string($key)">
										<xsl:value-of select = "$key"/>
									 </xsl:when>
								</xsl:choose>

							</xsl:when>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

			<xsl:if test = "string($migratedName) and  (string($migratedValue) or (string-length($migratedValue) = 0))">
				<xsl:call-template name = "tabs">
					<xsl:with-param name = "tabcount" select = "$startTab"/>
				</xsl:call-template>

				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:value-of select = "$migratedName"/>
					</xsl:attribute>

					<xsl:call-template name = "lineBreak"/>
					<xsl:call-template name = "tabs">
						<xsl:with-param name = "tabcount" select = "$startTab+1"/>
					</xsl:call-template>
					<xsl:choose>
						<xsl:when test = "$type = 'BOOLEAN'">
							<BOOLEAN><xsl:value-of select = "$migratedValue"/></BOOLEAN>
						</xsl:when>
						<xsl:when test = "$type = 'INTEGER'">
							<INTEGER><xsl:value-of select = "$migratedValue"/></INTEGER>
						</xsl:when>
						<xsl:when test = "$type = 'STRING'">
							<STRING><xsl:value-of disable-output-escaping = "yes"
												  select = "$migratedValue"/></STRING>
						</xsl:when>
						<xsl:otherwise>
							<Unknown><xsl:value-of select = "$migratedValue"/></Unknown>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:call-template name = "lineBreak"/>
					<xsl:call-template name = "tabs">
						<xsl:with-param name = "tabcount" select = "$startTab"/>
					</xsl:call-template>
				</xsl:element>
				<xsl:call-template name = "lineBreak"/>
			</xsl:if>  <!-- if test = "$migratedName and  $migratedValue" -->
			</xsl:if>	<!-- if test = "$PropertyEntry" -->
		</xsl:for-each>
	</xsl:for-each>
</xsl:template>



<xsl:template name = "fillContainer">
	<xsl:param name = "PropertyTable"/>
	<xsl:param name = "startTab" select ="5"/>
	<xsl:param name = "ContainerName"/>

  	<xsl:for-each select="$properties/PROPERTY">
		<xsl:sort select="@name"/>

		<xsl:variable name = "this" select = "."/>
		<xsl:variable name = "PropertyEntry" select = 
		   "$PropertyTable/Property[@name = current()/@name and @container = $ContainerName]"/>

		<!-- debug
		<xsl:if test = "count($PropertyEntry) &gt; 1">
			<xsl:call-template name = "lineBreak"/>
			<xsl:call-template name = "tab"/>
			<xsl:text>Multiple Property Table entries for Property:	</xsl:text>
			<xsl:value-of select = "current()/@name"/>
			<xsl:call-template name = "lineBreak"/>
			<xsl:for-each select = "$PropertyEntry">
				<xsl:variable name = "pos" select = "position()"/>
				<xsl:call-template name = "tab"/>
				<xsl:text>migrated name </xsl:text>
				<xsl:value-of select = "$pos"/>
				<xsl:text> : </xsl:text>
				<xsl:value-of select = "$PropertyEntry[$pos]/@migratedName"/>
				<xsl:call-template name = "lineBreak"/>
			</xsl:for-each>
			<xsl:call-template name = "lineBreak"/>
		</xsl:if>
		-->

		<xsl:for-each select = "$PropertyEntry">
			<!-- a few rwin properties are migrated to multiple one rweb properties -->
			<xsl:if test = ".">
			<!-- if this property/mode is in the property migration table for this container -->
			<xsl:variable name = "migratedName" select = "./@migratedName"/>
			<xsl:variable name = "type" select = "./@type"/>
			<xsl:variable name = "migratedValue">
				<xsl:choose>
					<xsl:when test = "self::node()[@specialcase = 'true']">
						<!-- handle all the special cases here -->
						<xsl:choose>
							<xsl:when test = "./@migratedName = 'deccolm'">
								<xsl:choose>
									<xsl:when test = "($this/INTEGER = 132) or
													  ($this/INTEGER &gt; 132)">true</xsl:when>
									<xsl:otherwise>false</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:when test = "./@migratedName = 'screenColumns'">
								<xsl:choose>
									<xsl:when test = "($this/INTEGER &gt; 512)">512</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select = "$this/INTEGER"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
						</xsl:choose>
						<!-- end of special cases  -->
					</xsl:when>
					<xsl:when test = "self::node()[not(@sourcetype)]">
						<!-- source and destination type are the same -->
						<xsl:choose>
							<xsl:when test = "$type = 'BOOLEAN'">
								<xsl:variable name = "value" select = "$this/BOOLEAN"/>
								<xsl:variable name = "opposite">
									<xsl:choose>
										<xsl:when test = "./@noValueMigration = 'false'">true</xsl:when>
										<xsl:otherwise></xsl:otherwise>
									</xsl:choose>
								</xsl:variable>	
								<xsl:choose>
									<xsl:when test = "$opposite = 'true'">
										<xsl:choose>
											<xsl:when test = "$value = 'True'">false</xsl:when>
											<xsl:otherwise>true</xsl:otherwise>								 
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test = "$value = 'True'">true</xsl:when>
											<xsl:otherwise>false</xsl:otherwise>								 
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:when test = "$type = 'INTEGER'">
								<xsl:value-of select = "$this/INTEGER"/>
							</xsl:when>
							<xsl:when test = "$type = 'STRING'">
								<xsl:choose>
									<xsl:when test = "./@noValueMigration = 'false'">
										<xsl:call-template name = "translateCtrlChars">
											<xsl:with-param name = "text" select = "$this/STRING"/>
										</xsl:call-template>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select = "$this/STRING"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select = 
									"./ENUMERATION[@value = $this/ENUMERATION]/@migratedValue"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<!-- source and destination types differ -->
						<xsl:choose>
							<xsl:when test = "./@sourcetype = 'ENUMERATION'">
								<xsl:variable name = "enumValue"
									select = "./ENUMERATION[@value = $this/ENUMERATION]"/>
								<xsl:choose>
									<xsl:when test = "string($enumValue/@migratedValue)">
										<xsl:value-of select = "$enumValue/@migratedValue"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select = "./ENUMERATION[@value = 'other']/@migratedValue"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:when test = "./@sourcetype = 'CHARACTER'">
								<xsl:variable name = "keycode" select = "$RwebKeycodes/Key[@name = $this/CHARACTER]"/>
								<xsl:variable name = "key" select = "$keycode/@migratedKey"/>
								<xsl:choose>
									<xsl:when test = "$this/CHARACTER/@ctrl">
										<xsl:value-of select = "number(substring-after($this/CHARACTER, '#'))"/>
									</xsl:when>
									<xsl:when test = "string($key)">
										<xsl:value-of select = "$key"/>
									 </xsl:when>
								</xsl:choose>

							</xsl:when>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
<!--
			<xsl:if test = "string($migratedName) and string($migratedValue)">
-->
			<xsl:if test = "string($migratedName) and  (string($migratedValue) or (string-length($migratedValue) = 0))">
				<xsl:call-template name = "tabs">
					<xsl:with-param name = "tabcount" select = "$startTab"/>
				</xsl:call-template>

				<xsl:element name = "CORE_PROPERTY">
					<xsl:attribute name = "NAME">
						<xsl:value-of select = "$migratedName"/>
					</xsl:attribute>

					<xsl:call-template name = "lineBreak"/>
					<xsl:call-template name = "tabs">
						<xsl:with-param name = "tabcount" select = "$startTab+1"/>
					</xsl:call-template>
					<xsl:choose>
						<xsl:when test = "$type = 'BOOLEAN'">
							<BOOLEAN><xsl:value-of select = "$migratedValue"/></BOOLEAN>
						</xsl:when>
						<xsl:when test = "$type = 'INTEGER'">
							<INTEGER><xsl:value-of select = "$migratedValue"/></INTEGER>
						</xsl:when>
						<xsl:when test = "$type = 'STRING'">
							<STRING><xsl:value-of disable-output-escaping = "yes"
												  select = "$migratedValue"/></STRING>
						</xsl:when>
						<xsl:otherwise>
							<Unknown><xsl:value-of select = "$migratedValue"/></Unknown>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:call-template name = "lineBreak"/>
					<xsl:call-template name = "tabs">
						<xsl:with-param name = "tabcount" select = "$startTab"/>
					</xsl:call-template>
				</xsl:element>
				<xsl:call-template name = "lineBreak"/>
			</xsl:if>  <!-- if test = "$migratedName and  $migratedValue" -->
			</xsl:if>	<!-- if test = "$PropertyEntry" -->
		</xsl:for-each>

	</xsl:for-each>
</xsl:template>



<xsl:template name = "CreateContainer">
	<xsl:param name = "ContainerName"/>
	<xsl:param name = "PropertyTable"/>
	<xsl:param name = "FixedContent" select = "$NoFixedContent"/>
	<xsl:param name = "PropertyCount" select = "$CountNotSupplied"/>

	<xsl:variable name = "fixedcount" select = "count($FixedContent/CORE_PROPERTY)"/>
	<xsl:variable name = "propertyCount">
		<xsl:choose>
			<xsl:when test = "$PropertyCount = $CountNotSupplied">
				<xsl:call-template name = "countMigratableProperties">
					<xsl:with-param name = "ContainerName" select = "$ContainerName"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select = "$PropertyCount"/>	
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:call-template name = "threeTabs"/>

	<xsl:element name = "CONTAINER">
		<xsl:attribute name = "NAME">
			<xsl:value-of select = "$ContainerName"/>
		</xsl:attribute>
		<xsl:call-template name = "lineBreakFourTabs"/>

		<xsl:element name = "PROPERTY_STATE">
			<xsl:attribute name = "SIZE">
				<xsl:value-of select = "$propertyCount + $fixedcount"/>
			</xsl:attribute>
			<xsl:call-template name = "lineBreak"/>

		<xsl:choose>
			<xsl:when test = "contains($ContainerName, 'TransportOptions')">
				<xsl:call-template name = "fillTransportContainer">
					<xsl:with-param name = "PropertyTable" select = "$PropertyTable"/>
					<xsl:with-param name = "ContainerName" select = "$ContainerName"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name = "fillContainer">
					<xsl:with-param name = "PropertyTable" select = "$PropertyTable"/>
					<xsl:with-param name = "ContainerName" select = "$ContainerName"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>



		<!--  fixed properties  -->
		<xsl:if test = "$fixedcount &gt; '0'">
			<xsl:apply-templates select="$FixedContent/CORE_PROPERTY" mode = "fixedSectionCopy">
				<xsl:with-param name = "tabcount">5</xsl:with-param>
			</xsl:apply-templates>
		</xsl:if>

		<xsl:call-template name = "fourTabs"/>
		</xsl:element>
		<xsl:call-template name = "lineBreakThreeTabs"/>
	</xsl:element>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>



<xsl:template name = "createCommand">
	<xsl:param name = "tabcount" select = "0"/>
	<xsl:param name = "commandName"/>
	<xsl:param name = "stringValue"/>


	<xsl:call-template name = "tabs">
		<xsl:with-param name = "tabcount" select = "$tabcount"/>
	</xsl:call-template>
	<xsl:element name = "COMMAND">
		<xsl:attribute name = "NAME">
			<xsl:value-of select = "$commandName"/>
		</xsl:attribute>
		<xsl:call-template name = "lineBreak"/>

		 <xsl:call-template name = "tabs">
			<xsl:with-param name = "tabcount" select = "$tabcount+1"/>
		</xsl:call-template>
		<xsl:element name = "OBJECT_ARRAY">
			<xsl:attribute name = "SIZE">1</xsl:attribute>
			<xsl:call-template name = "lineBreak"/>
			<xsl:call-template name = "tabs">
				<xsl:with-param name = "tabcount" select = "$tabcount+2"/>
			</xsl:call-template>
			<xsl:element name = "STRING">
				<xsl:value-of select = "$stringValue"/>
			</xsl:element>		<!-- end tag STRING -->
			<xsl:call-template name = "lineBreak"/>
			<xsl:call-template name = "tabs">
			<xsl:with-param name = "tabcount" select = "$tabcount+1"/>
		</xsl:call-template>
		</xsl:element>		<!-- end tag OBJECT_ARRAY -->
		<xsl:call-template name = "lineBreak"/>

	<xsl:call-template name = "tabs">
		<xsl:with-param name = "tabcount" select = "$tabcount"/>
	</xsl:call-template>
	</xsl:element>		<!-- end tag COMMAND -->
	<xsl:call-template name = "lineBreak"/>
</xsl:template>



<xsl:template match="text()|@*"/>



</xsl:stylesheet>

