<?xml version="1.0"?>
<xsl:stylesheet	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
				xmlns:msxsl="urn:schemas-microsoft-com:xslt"
				xmlns:exsl="http://exslt.org/common" 
				xmlns:ext="urn:rwin-rweb-scripts"
				exclude-result-prefixes="msxsl exsl ext">


<xsl:output method="xml" encoding = "UTF-8" cdata-section-elements = "KEY" standalone = "yes" indent = "no"/>



<!--  RwebImpt.xsl  Transform Reflection for the Web Settings to Reflection import format  -->




<xsl:variable name = "transformVersion" select = "1.0"/>

<xsl:variable name = "ImportFormatVersion" select = "1.0"/>






<!-- global variables  -->

<xsl:variable name = "root" 			select = "REFLECTION_WEB"/>
<xsl:variable name = "properties" 		select = "/REFLECTION_WEB/XML_STORE/PROPERTIES"/>
<xsl:variable name = "colors" 			select = "/REFLECTION_WEB/XML_STORE/CONTAINERS/CONTAINER[@NAME='AttributeDisplayMap']"/>
<xsl:variable name = "hpProperties"		select = "/REFLECTION_WEB/XML_STORE/CONTAINERS/CONTAINER[@NAME='com.wrq.hp.HP']"/>
<xsl:variable name = "vtProperties"		select = "/REFLECTION_WEB/XML_STORE/CONTAINERS/CONTAINER[@NAME='com.wrq.vt.VT']"/>
<xsl:variable name = "keymapContainer"	select = "/REFLECTION_WEB/XML_STORE/CONTAINERS/CONTAINER[@NAME='KeyMap-4']"/>
<xsl:variable name = "session"			select = "/REFLECTION_WEB/XML_STORE/CONTAINERS/CONTAINER[@NAME='com.wrq.session.Session']/CONTEXT_CHILD_STATE"/>
<xsl:variable name = "hptisb"			select = "/REFLECTION_WEB/XML_STORE/CONTAINERS/CONTAINER[@NAME='com.wrq.session.tisb.HPTISB']"/>
<xsl:variable name = "vttisb"			select = "/REFLECTION_WEB/XML_STORE/CONTAINERS/CONTAINER[@NAME='com.wrq.session.tisb.VTTISB']"/>
<xsl:variable name = "hptd"				select = "/REFLECTION_WEB/XML_STORE/CONTAINERS/CONTAINER[@NAME='com.wrq.display.HPTD']"/>
<xsl:variable name = "vttd"				select = "/REFLECTION_WEB/XML_STORE/CONTAINERS/CONTAINER[@NAME='com.wrq.display.VTTD']"/>
<xsl:variable name = "vtpresentation"	select = "/REFLECTION_WEB/XML_STORE/CONTAINERS/CONTAINER[@NAME='PresentationManager3']/CONTEXT_CHILD_STATE"/>
<xsl:variable name = "transportOptions" select = "/REFLECTION_WEB/XML_STORE/CONTAINERS/CONTAINER[@NAME='com.wrq.session.transport.TransportOptions']/PROPERTY_STATE"/>
<xsl:variable name = "hptabs"			select = "$hpProperties/PROPERTY_STATE/CORE_PROPERTY[@NAME='tabStops']/BIT_SET"/>
<xsl:variable name = "vttabs"			select = "$vtProperties/PROPERTY_STATE/CORE_PROPERTY[@NAME='tabStops']/BIT_SET"/>
<xsl:variable name = "hpkeyTable" 		select = "msxsl:node-set($HPKeymapMappingTable)"/>
<xsl:variable name = "hpterminalKeys" 	select = "msxsl:node-set($HPTerminalKeyTable)"/>
<xsl:variable name = "vtkeyTable" 		select = "msxsl:node-set($VTKeymapMappingTable)"/>
<xsl:variable name = "vtterminalKeys" 	select = "msxsl:node-set($VTTerminalKeyTable)"/>
<xsl:variable name = "hpcolorswapped" 	
  select = "/REFLECTION_WEB/XML_STORE/CONTAINERS/CONTAINER[@NAME='com.wrq.session.tisb.HPTISB']/PROPERTY_STATE/CORE_PROPERTY[@NAME='fgAndBgAreSwapped']/BOOLEAN"/>
<xsl:variable name = "vtcolorswapped" 	
  select = "/REFLECTION_WEB/XML_STORE/CONTAINERS/CONTAINER[@NAME='com.wrq.session.tisb.VTTISB']/PROPERTY_STATE/CORE_PROPERTY[@NAME='fgAndBgAreSwapped']/BOOLEAN"/>

<xsl:variable name = "host" 	
  select = "/REFLECTION_WEB/XML_STORE/CONTAINERS/CONTAINER[@NAME='com.wrq.session.Session']/CONTEXT_CHILD_STATE/PROPERTY_STATE/CORE_PROPERTY[@NAME='hostURL']/URL_STRING"/>


<xsl:variable name = "XMLversion">
	<xsl:value-of select = "/REFLECTION_WEB/XML_STORE/PROPERTIES/PROPERTY[@NAME='version']"/>
</xsl:variable>


<xsl:variable name = "RwebType">
	<xsl:value-of select = "/REFLECTION_WEB/XML_STORE/PROPERTIES/PROPERTY[@NAME='type']"/>
</xsl:variable>

<xsl:variable name = "RwebExportType">
	<xsl:value-of select = "/REFLECTION_WEB/XML_STORE/PROPERTIES/PROPERTY[@NAME='exportMapID']"/>
</xsl:variable>

<xsl:variable name = "keymapOnlyConfig">
	<xsl:choose>
		<xsl:when test = "($RwebType = 'single') and ($RwebExportType = '1')">true</xsl:when>
		<xsl:otherwise>false</xsl:otherwise>
	</xsl:choose>
</xsl:variable>


<xsl:variable name = "signature">	
	<xsl:value-of select = "/REFLECTION_WEB/XML_STORE/PROPERTIES/PROPERTY[@NAME='signature']"/>
</xsl:variable>
			
<xsl:variable name = "emulator">	
	<xsl:value-of select = "substring($signature,1,2)"/>
</xsl:variable>
					  
<xsl:variable name = "type">
	<xsl:value-of select = "/REFLECTION_WEB/XML_STORE/PROPERTIES/PROPERTY[@NAME='type']"/> 
</xsl:variable>




<!-- Property Migration Tables -->

<xsl:variable name = "HP_PropertyTable">
	<!--  Enumeration Properties  -->
	<Property name = "CursorShape" migratedName = "cursorShape" container = "com.wrq.session.tisb.HPTISB" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcBlock" 				nvalue = "0"		migratedValue = "0"/>
		<ENUMERATION value = "rcUnderline" 			nvalue = "1"		migratedValue = "1"/>
		<ENUMERATION value = "rcVerticalBar" 		navlue = "2"		migratedValue = "0"/>
	</Property>
	<Property name = "PrimaryStatusResponse" migratedName = "displayMemoryResponse" container = "com.wrq.hp.HP" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rc4k" 				nvalue = "0"		migratedValue = "0"/>
		<ENUMERATION value = "rc8k" 				nvalue = "1"		migratedValue = "1"/>
		<ENUMERATION value = "rc12k" 				nvalue = "2"		migratedValue = "2"/>
		<ENUMERATION value = "rc15k" 				nvalue = "3"		migratedValue = "3"/>
	</Property>
	<Property name = "FunctionKeySet" migratedName = "functionKeySet" container = "com.wrq.hp.HP" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcUser" 				nvalue = "0"		migratedValue = "6"/>  
		<ENUMERATION value = "rcModes" 				nvalue = "1"		migratedValue = "4"/>  
		<ENUMERATION value = "rcDeviceControl" 		nvalue = "2"		migratedValue = "0"/>  
		<ENUMERATION value = "rcDeviceModes" 		nvalue = "3"		migratedValue = "1"/>  
		<ENUMERATION value = "rcToDevices" 			nvalue = "4"		migratedValue = "0"/>  
		<ENUMERATION value = "rcEnhanceVideo" 		nvalue = "5"		migratedValue = "7"/>  
		<ENUMERATION value = "rcDefineField" 		nvalue = "6"		migratedValue = "2"/>  
	</Property>
	<Property name = "TerminalType" migratedName = "termtype" container = "com.wrq.hp.HP" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcHP2392A" 			nvalue = "0"		migratedValue = "0"/>
		<ENUMERATION value = "rcHP70092" 			nvalue = "1"		migratedValue = "1"/>
		<ENUMERATION value = "rcHP70094" 			nvalue = "2"		migratedValue = "2"/>
		<ENUMERATION value = "rcVT52" 				nvalue = "3"		migratedValue = "3"/>
		<ENUMERATION value = "rcVT102" 				nvalue = "4"		migratedValue = "4"/>
		<ENUMERATION value = "rcVT220_7" 			nvalue = "5"		migratedValue = "5"/>
		<ENUMERATION value = "rcVT220_8" 			nvalue = "6"		migratedValue = "6"/>
	</Property>
	<Property name = "HostCharacterSet" migratedName = "hostCharset" container = "com.wrq.hp.HP" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcHPRoman8" 			nvalue = "4"		migratedValue = "0"/>
		<ENUMERATION value = "rcHPRoman9" 			nvalue = "56"		migratedValue = "1"/>
	</Property>
	<Property name = "NationalReplacementSet" migratedName = "NRCS" container = "com.wrq.hp.HP" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcNone" 				nvalue = "0"		migratedValue = "0"/>
		<ENUMERATION value = "rcBritish" 			nvalue = "1"		migratedValue = "16"/>
		<ENUMERATION value = "rcFrench" 			nvalue = "2"		migratedValue = "5"/>
		<ENUMERATION value = "rcGerman" 			nvalue = "3"		migratedValue = "10"/>
		<ENUMERATION value = "rcItalian" 			nvalue = "4"		migratedValue = "11"/>
		<ENUMERATION value = "rcNorwegian" 			nvalue = "5"		migratedValue = "12"/>
		<ENUMERATION value = "rcDanish" 			nvalue = "6"		migratedValue = "2"/>
		<ENUMERATION value = "rcSwedish" 			nvalue = "7"		migratedValue = "15"/>
		<ENUMERATION value = "rcDutch" 				nvalue = "8"		migratedValue = "3"/>
		<ENUMERATION value = "rcSwissGerman" 		nvalue = "9"		migratedValue = "9"/>
		<ENUMERATION value = "rcEuropeanSpanish" 	nvalue = "10"		migratedValue = "13"/>
		<ENUMERATION value = "rcLatinSpanish" 		nvalue = "11"		migratedValue = "13"/>
		<ENUMERATION value = "rcFinnish" 			nvalue = "12"		migratedValue = "4"/>
		<ENUMERATION value = "rcCanadianEnglish" 	nvalue = "13"		migratedValue = "6"/>
		<ENUMERATION value = "rcFlemish" 		 	nvalue = "14"		migratedValue = "1"/>
		<ENUMERATION value = "rcCanadianFrench"  	nvalue = "15"		migratedValue = "7"/>
		<ENUMERATION value = "rcSwissFrench" 	 	nvalue = "16"		migratedValue = "8"/>
		<ENUMERATION value = "rcPortuguese" 		nvalue = ""			migratedValue = "14"/>
	</Property>
	<Property name = "HPDataSpeedSelect" migratedName = "highDataSpeed" container = "com.wrq.hp.HP" sourcetype = "ENUMERATION" type = "BOOLEAN">
		<ENUMERATION value = "LO" 	 				nvalue = "0"		migratedValue = "false"/>
		<ENUMERATION value = "HI" 	 				nvalue = "1"		migratedValue = "true"/>
	</Property>
	<Property name = "HPTerminalType" migratedName = "terminalIdResponse" container = "com.wrq.hp.HP" type = "STRING">
		<ENUMERATION value = "HP2392A" 				nvalue = "0"		migratedValue = "HP2392A"/>
		<ENUMERATION value = "HP70092" 				nvalue = "1"		migratedValue = "HP70092"/>
		<ENUMERATION value = "HP70094" 				nvalue = "2"		migratedValue = "HP70094"/>
	</Property>
	<Property name = "JumpScrollSpeed" migratedName = "jumpScrollSpeed" container = "com.wrq.session.tisb.HPTISB" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcUnlimitedScroll" 	nvalue = "0"		migratedValue = "-2"/>
		<ENUMERATION value = "rcScrollByPage" 		nvalue = "1"		migratedValue = "-3"/>
		<ENUMERATION value = "rcScrollBy1" 			nvalue = "2"		migratedValue = "1"/>
		<ENUMERATION value = "rcScrollBy2" 			nvalue = "3"		migratedValue = "2"/>
		<ENUMERATION value = "rcScrollBy4" 			nvalue = "4"		migratedValue = "4"/>
		<ENUMERATION value = "rcScrollBy8" 			nvalue = "5"		migratedValue = "8"/>
		<ENUMERATION value = "rcScrollBy16" 		nvalue = "6"		migratedValue = "16"/>
		<ENUMERATION value = "rcScrollBy32" 		nvalue = "7"		migratedValue = "32"/>
		<ENUMERATION value = "rcScrollBy64" 		nvalue = "8"		migratedValue = "64"/>
		<ENUMERATION value = "rcScrollBy128" 		nvalue = "9"		migratedValue = "128"/>
	</Property>
	<Property name = "TerminalClass" migratedName = "terminalType" container = "com.wrq.session.Session" sourcetype = "ENUMERATION" type = "STRING">
		<ENUMERATION value = "rcHP" 				nvalue = "0"		migratedValue = "hp"/>
		<ENUMERATION value = "rcDEC" 				nvalue = "1"		migratedValue = "vt"/>
	</Property>
	<Property name = "BlockTransferUnit" migratedName = "blockTransferPage" container = "com.wrq.hp.HP" sourcetype = "ENUMERATION" type = "BOOLEAN">
		<ENUMERATION value = "rcPage" 				nvalue = "1"		migratedValue = "true"/>
		<ENUMERATION value = "rcLine" 				nvalue = "0"  		migratedValue = "false"/>
	</Property>
	<Property name = "FormatModeTransmits" migratedName = "transmitModified" container = "com.wrq.hp.HP" sourcetype = "ENUMERATION" type = "BOOLEAN">
		<ENUMERATION value = "rcAll" 				nvalue = "0" 		migratedValue = "fasle"/>
		<ENUMERATION value = "rcModified" 			nvalue = "1" 		migratedValue = "true"/>
	</Property>
	<Property name = "StartupAction" migratedName = "autoconnect" container = "com.wrq.session.Session" sourcetype = "ENUMERATION" type = "BOOLEAN">
		<ENUMERATION value = "rcAutoConnect" 		nvalue = "0"		migratedValue = "true"/>
		<ENUMERATION value = "rcNoConnect" 			nvalue = "5"		migratedValue = "false"/>
	</Property>

	<!--  Boolean Properties  -->
	<Property name = "AutoFormFeed" migratedName = "doFormFeeds" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "AutoLineFeed" migratedName = "autoLineFeed" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "BlockMode" migratedName = "blockMode" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "CapsLockMode" migratedName = "capsLockMode" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "ConfigurationLocked" migratedName = "configLocked" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "DestructiveBackspace" migratedName = "destructiveBackspace" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "EnqAck" migratedName = "enqAck" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "InhibitHandshake" migratedName = "inhibitHandshake" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "InhibitDC2" migratedName = "inhibitDC2" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "InverseVideo" migratedName = "inverseVideo" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "LocalEcho" migratedName = "localEcho" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "MarginBell" migratedName = "marginBell" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "ReturnEqualsEnter" migratedName = "returnEqualsEnter" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "ShowFunctionKeys" migratedName = "showFunctionKeys" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "ShowStatusBar" migratedName = "showStatusLine" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "SPOW" migratedName = "spowEnabled" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "TerminalEscapeTransfer" migratedName = "escapeXfer" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "TerminalModifyAll" migratedName = "modifyAll" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "TypeAhead" migratedName = "typeahead" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "TransmitFunctions" migratedName = "transmitFunctions" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "HPUseHostPrompt" migratedName = "useHostPrompt" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "UserFeaturesLocked" migratedName = "userFeaturesLocked" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "Bell" migratedName = "warningBell" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "PrinterColumnsTiedToDisplay" migratedName = "printerColumnsTiedToDisplay" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "SmoothScroll" migratedName = "smoothScrollHP" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "SmoothScroll" migratedName = "smoothScroll" container = "com.wrq.session.tisb.HPTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "CursorBlink" migratedName = "cursorBlinks" container = "com.wrq.session.tisb.HPTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "CursorVisible" migratedName = "cursorVisible" container = "com.wrq.session.tisb.HPTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "InverseVideo" migratedName = "fgAndBgAreSwapped" container = "com.wrq.session.tisb.HPTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "ShowToolbar" migratedName = "toolbarVisible" container = "MapperEngine-1" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "ShowTerminalKeyboard" migratedName = "terminalKeyboardVisible" container = "MapperEngine-1" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "SlashZeros" migratedName = "slashedZero" container = "com.wrq.display.HPTD" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "EndOfLineWrap" migratedName = "inhibitEOLWrap" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "TransmitTabAsSpaces" migratedName = "tabEqualsSpaces" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "UseNRC" migratedName = "useNRC" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>

	<Property name = "BlinkCharacters" 		migratedName = "blinkEnabled" container = "com.wrq.display.HPTD" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "UnderlineCharacters" 	migratedName = "underlineEnabled" container = "com.wrq.display.HPTD" type = "BOOLEAN" noValueMigration = "true"/>
<!--
	<Property name = "BoldCharacters" 		migratedName = "boldEnabled" container = "com.wrq.display.HPTD" type = "BOOLEAN" noValueMigration = "true"/>
-->
	<!--
	<Property name = "PrinterFitFontToPage" migratedName = "fitToPage" container = "PrinterService" type = "BOOLEAN" noValueMigration = "true"/>
	-->

	<!--  Character Properties  -->
	<Property name = "BlockTerminator" migratedName = "blockTerminator" container = "com.wrq.hp.HP" sourcetype = "CHARACTER" type = "INTEGER" charToIntMigration = "true"/>
	<Property name = "FieldSeparator" migratedName = "fieldSeparator" container = "com.wrq.hp.HP" sourcetype = "CHARACTER" type = "INTEGER" charToIntMigration = "true"/>
	<Property name = "HostTriggerCharacter" migratedName = "hostPromptCharacter" container = "com.wrq.hp.HP" sourcetype = "CHARACTER" type = "INTEGER" charToIntMigration = "true"/>

	<!--  Integer Properties  -->
	<Property name = "DisplayColumns" migratedName = "screenColumns" container = "com.wrq.hp.HP" type = "INTEGER" noValueMigration = "true"/>
	<Property name = "DisplayRows" 	  migratedName = "screenRows" container = "com.wrq.hp.HP" type = "INTEGER" noValueMigration = "true"/>
	<Property name = "FormsBufferSize" migratedName = "formsBufferSize" container = "com.wrq.hp.HP" type = "INTEGER" noValueMigration = "true"/>
	<Property name = "StartColumn" migratedName = "startColumn" container = "com.wrq.hp.HP" type = "INTEGER" noValueMigration = "true" specialcase = "true"/>
	<Property name = "PasteDelay" migratedName = "pasteDelay" container = "com.wrq.hp.HP" type = "INTEGER" noValueMigration = "true"/>
	<!--
	<Property name = "PrinterTimeout" migratedName = "printJobTerminationDelay" container = "PrinterService" type = "INTEGER" noValueMigration = "true"/>
	-->

	<!--  String Properties  -->
<!--
	<Property name = "ReturnDefinition" migratedName = "returnDefinition" container = "com.wrq.hp.HP" type = "STRING" specialcase = "true"/>
-->

</xsl:variable>

<xsl:variable name = "HP_SpecialPropertyTable">
	<!--  Enumeration Properties  -->
	<Property name = "NationalReplacementSet" migratedName = "NRCS" container = "com.wrq.hp.HP" sourcetype = "ENUMERATION" type = "INTEGER"/>
</xsl:variable>

<xsl:variable name = "VT_PropertyTable">
	<!--  Enumeration Properties  -->
	<Property name = "CursorShape" migratedName = "cursorShape" container = "com.wrq.session.tisb.VTTISB" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcBlock" 				nvalue = "0"		migratedValue = "0"/>
		<ENUMERATION value = "rcUnderline" 			nvalue = "1"		migratedValue = "1"/>
		<ENUMERATION value = "rcVerticalBar" 	 	nvalue = "2"		migratedValue = "0"/>
	</Property>
	<Property name = "DAResponse" migratedName = "daResponse" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcVT100" 				nvalue = "0"		migratedValue = "1"/>
		<ENUMERATION value = "rcVT101" 				nvalue = "1"		migratedValue = "2"/>
		<ENUMERATION value = "rcVT102" 				nvalue = "2"		migratedValue = "3"/>
		<ENUMERATION value = "rcVT220" 				nvalue = "3"		migratedValue = "4"/>
		<ENUMERATION value = "rcVT320" 				nvalue = "4"		migratedValue = "5"/>
		<ENUMERATION value = "rcVT420" 				nvalue = "5"		migratedValue = "6"/>
		<ENUMERATION value = "rcVTWRQID" 			nvalue = "7"		migratedValue = "0"/>
		<ENUMERATION value = "rcVT80" 				nvalue = "8"		migratedValue = "1"/>
		<ENUMERATION value = "rcVT100J"   			nvalue = "9"		migratedValue = "1"/>
		<ENUMERATION value = "rcVT102J"   			nvalue = "10"		migratedValue = "3"/>
		<ENUMERATION value = "rcVT220J"   			nvalue = "11"		migratedValue = "4"/>
		<ENUMERATION value = "rcVT282"   			nvalue = "12"		migratedValue = "4"/>
		<ENUMERATION value = "rcVT282" 				nvalue = "12"		migratedValue = "4"/>
		<ENUMERATION value = "rcVT382" 				nvalue = "13"		migratedValue = "4"/>
	</Property>
	<Property name = "TerminalType" migratedName = "termtype" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcVT52" 			 	nvalue = "0"		migratedValue = "0"/>
		<ENUMERATION value = "rcVT102" 			 	nvalue = "1"		migratedValue = "1"/>
		<ENUMERATION value = "rcVT400_7" 			nvalue = "2"		migratedValue = "2"/>
		<ENUMERATION value = "rcVT400_8" 			nvalue = "3"		migratedValue = "3"/>
	</Property>
	<Property name = "HostCharacterSet" migratedName = "decaupss" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcDECSupplemental" 	nvalue = "0"		migratedValue = "0"/>
		<ENUMERATION value = "rcISOLatin_1" 		nvalue = "1"		migratedValue = "1"/>
		<ENUMERATION value = "rcISOLatin_2" 		nvalue = "14"		migratedValue = "2"/>
		<ENUMERATION value = "rcISOLatin_5" 		nvalue = "19"		migratedValue = "3"/>
		<ENUMERATION value = "rcISOLatin_9" 		nvalue = "55"		migratedValue = "4"/>
	</Property>
	<Property name = "NationalReplacementSet" migratedName = "nrcSet" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcNone" 				nvalue = "0"		migratedValue = "0"/>
		<ENUMERATION value = "rcBritish" 			nvalue = "12"		migratedValue = "1"/>
		<ENUMERATION value = "rcFrench" 			nvalue = "3"		migratedValue = "4"/>
		<ENUMERATION value = "rcGerman" 			nvalue = "5"		migratedValue = "5"/>
		<ENUMERATION value = "rcItalian" 			nvalue = "6"		migratedValue = "6"/>
		<ENUMERATION value = "rcNorwegian" 			nvalue = "7"		migratedValue = "7"/>
		<ENUMERATION value = "rcDanish" 			nvalue = "7"		migratedValue = "7"/>
		<ENUMERATION value = "rcSwedish" 			nvalue = "10"		migratedValue = "10"/>
		<ENUMERATION value = "rcDutch" 				nvalue = "1"		migratedValue = "7"/>
		<ENUMERATION value = "rcSwissGerman" 		nvalue = "11"		migratedValue = "11"/>
		<ENUMERATION value = "rcEuropeanSpanish"	nvalue = "9"		migratedValue = "8"/>
		<ENUMERATION value = "rcLatinSpanish" 		nvalue = "9"		migratedValue = "8"/>
		<ENUMERATION value = "rcPortuguese" 		nvalue = "8" 		migratedValue = "9"/>
		<ENUMERATION value = "rcFinnish" 			nvalue = "2"		migratedValue = "3"/>
		<ENUMERATION value = "rcCanadianEnglish" 	nvalue = "4"		migratedValue = "2"/>
		<ENUMERATION value = "rcFlemish" 			nvalue = "14"		migratedValue = "7"/>
		<ENUMERATION value = "rcCanadianFrench" 	nvalue = "4"		migratedValue = "2"/>
		<ENUMERATION value = "rcSwissFrench" 		nvalue = "16"		migratedValue = "11"/>
	</Property>
	<Property name = "JumpScrollSpeed" migratedName = "jumpScrollSpeed" container = "com.wrq.session.tisb.VTTISB" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcUnlimitedScroll" 	nvalue = "0"		migratedValue = "-2"/>
		<ENUMERATION value = "rcScrollByPage" 		nvalue = "1"		migratedValue = "-3"/>
		<ENUMERATION value = "rcScrollBy1" 			nvalue = "2"		migratedValue = "1"/>
		<ENUMERATION value = "rcScrollBy2" 			nvalue = "3"		migratedValue = "2"/>
		<ENUMERATION value = "rcScrollBy4" 			nvalue = "4"		migratedValue = "4"/>
		<ENUMERATION value = "rcScrollBy8" 			nvalue = "5"		migratedValue = "8"/>
		<ENUMERATION value = "rcScrollBy16" 		nvalue = "6"		migratedValue = "16"/>
		<ENUMERATION value = "rcScrollBy32" 		nvalue = "7"		migratedValue = "32"/>
		<ENUMERATION value = "rcScrollBy64" 		nvalue = "8"		migratedValue = "64"/>
		<ENUMERATION value = "rcScrollBy128" 		nvalue = "9"		migratedValue = "128"/>
	</Property>
	<Property name = "TerminalClass" migratedName = "terminalType" container = "com.wrq.session.Session" sourcetype = "ENUMERATION" type = "STRING">
		<ENUMERATION value = "rcHP" 				nvalue = "1"		migratedValue = "hp"/>
		<ENUMERATION value = "rcDEC" 				nvalue = "2"		migratedValue = "vt"/>
	</Property>
	<Property name = "StartupAction" migratedName = "autoconnect" container = "com.wrq.session.Session" sourcetype = "ENUMERATION" type = "BOOLEAN">
		<ENUMERATION value = "rcAutoConnect" 		nvalue = "0"		migratedValue = "true"/>
		<ENUMERATION value = "rcNoConnect" 			nvalue = "5"		migratedValue = "false"/>
	</Property>
	<Property name = "HostStatusLine" migratedName = "decssdt" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "INTEGER">
		<ENUMERATION value = "rcNoStatusLine"  		nvalue = "0"		gratedValue = "0"/>
		<ENUMERATION value = "rcIndicator" 			nvalue = "1"		migratedValue = "1"/>
		<ENUMERATION value = "rcHostWritable"		nvalue = "2"		migratedValue = "2"/>
	</Property>
	<Property name = "VTBackspaceSends" migratedName = "decbkm" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "BOOLEAN">
		<ENUMERATION value = "rcDeleteKey"  		nvalue = "0" 		migratedValue = "false"/>
		<ENUMERATION value = "rcBackspaceKey" 		nvalue = "1" 		migratedValue = "true"/>
	</Property>
	<Property name = "VTCursorKeyMode" migratedName = "decckm" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "BOOLEAN">
		<ENUMERATION value = "rcNormalMode"  		nvalue = "0"		migratedValue = "false"/>
		<ENUMERATION value = "rcApplicationMode" 	nvalue = "1" 		migratedValue = "true"/>
	</Property>
	<Property name = "VTKeypadMode" migratedName = "decnkm" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "BOOLEAN">
		<ENUMERATION value = "rcNumericMode"  		nvalue = "0"  		migratedValue = "false"/>
		<ENUMERATION value = "rcApplicationMode" 	nvalue = "1" 		migratedValue = "true"/>
	</Property>

	<!--  Boolean Properties  -->
	<Property name = "AutoRepeat" migratedName = "decarm" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "AutoAnswerback" migratedName = "decaam" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "AnswerbackConcealed" migratedName = "deccansm" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "AutoLineFeed" migratedName = "lnm" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "BreakEnabled" migratedName = "breakEnabled" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "EndOfLineWrap" migratedName = "decawm" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "MarginBell" migratedName = "marginBell" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "ShowStatusBar" migratedName = "showStatusLine" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "UserFeaturesLocked" migratedName = "userLock" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "Bell" migratedName = "warningBell" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "SmoothScroll" migratedName = "smoothScroll" container = "com.wrq.session.tisb.VTTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "SmoothScroll" migratedName = "decsclm" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "CursorBlink" migratedName = "cursorBlinks" container = "com.wrq.session.tisb.VTTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "CursorVisible" migratedName = "cursorVisible" container = "com.wrq.session.tisb.VTTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "LocalEcho" migratedName = "srm" container = "com.wrq.vt.VT" type = "BOOLEAN" specialcase = "true"/>
	<Property name = "Online" migratedName = "remoteMode" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "PrinterColumnsTiedToDisplay" migratedName = "printerColumnsTiedToDisplay" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "InverseVideo" migratedName = "fgAndBgAreSwapped" container = "com.wrq.session.tisb.VTTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "PreserveNRC" migratedName = "preserveNRC" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "UseNRC" migratedName = "decnrcm" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "SaveFromScrollingRegion" migratedName = "saveFromScrollingRegion" container = "com.wrq.session.tisb.VTTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "NewPageOnClear" migratedName = "saveBeforeClearing" container = "com.wrq.session.tisb.VTTISB" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "InverseVideo" migratedName = "decscnm" container = "com.wrq.vt.VT" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "SlashZeros" migratedName = "slashedZero" container = "com.wrq.display.VTTD" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "TransmitTabAsSpaces" migratedName = "tabEqualsSpaces" container = "com.wrq.hp.HP" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "BlinkCharacters" 		migratedName = "blinkEnabled" container = "com.wrq.display.VTTD" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "UnderlineCharacters" 	migratedName = "underlineEnabled" container = "com.wrq.display.VTTD" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "BoldCharacters" 		migratedName = "boldEnabled" container = "com.wrq.display.VTTD" type = "BOOLEAN" noValueMigration = "true"/>
	<Property name = "AutoResizeScreen" 	migratedName = "autoDisplaySizing" container = "PresentationManager3" type = "BOOLEAN" noValueMigration = "true"/>

   	<!--  Integer Properties  -->
	<Property name = "DisplayColumns" migratedName = "deccolm" container = "com.wrq.vt.VT" sourcetype = "INTEGER" type = "BOOLEAM" specialcase = "true" />
	<Property name = "DisplayRows" migratedName = "decsnls" container = "com.wrq.vt.VT" type = "INTEGER" noValueMigration = "true"/>
	<Property name = "WindowRows" migratedName = "decslpp" container = "com.wrq.vt.VT" type = "INTEGER" noValueMigration = "true"/>
	<Property name = "PasteDelay" migratedName = "pasteDelay" container = "com.wrq.vt.VT" type = "INTEGER" noValueMigration = "true"/>

	<!--  String Properties  -->
	<Property name = "Answerback" migratedName = "declans" container = "com.wrq.vt.VT" type = "STRING" noValueMigration = "false"/>

</xsl:variable>


<xsl:variable name = "VT_SpecialPropertyTable">
	<!--  Enumeration Properties  -->
	<Property name = "NationalReplacementSet" migratedName = "nrcSet" container = "com.wrq.vt.VT" sourcetype = "ENUMERATION" type = "INTEGER"/>
</xsl:variable>


<!-- Keymap Migration Tables -->
<!-- HP Mapping Migration Table -->
<xsl:variable name = "HPKeymapMappingTable">
	<!--  Menu Commands  -->
	<Mapping name = "EditSelectAll"			rwebCommand = "Glue.selectAll"/>
	<Mapping name = "ConnectionConnect" 	rwebCommand = "ISession.connect"/>
	<Mapping name = "ConnectionDisconnect" 	rwebCommand = "ISession.disconnect"/>
	<Mapping name = "Disconnect" 			rwebCommand = "ISession.disconnect"/>
	<Mapping name = "HelpAboutReflection" 	rwebCommand = "Glue.aboutBoxDialog"/>
	<Mapping name = "EditCopy" 				rwebCommand = "Glue.copy"/>
	<Mapping name = "EditPaste" 			rwebCommand = "Glue.paste"/>
<!--
	<Mapping name = "EditClearDisplay" 		rwebCommand = "HP.clearDisplay"/>
	<Mapping name = "HpClearDisplay" 		rwebCommand = "HP.clearDisplay"/>
-->
	<Mapping name = "FileClosePrinter" 		rwebCommand = "HP.closePrinter"/>
	<Mapping name = "FilePrint" 			rwebCommand = "Glue.screenPrint"/>
	<Mapping name = "NextPage" 				rwebCommand = "ITDService.scrollDownPage"/>
	<Mapping name = "PrevPage" 				rwebCommand = "ITDService.scrollUpPage"/>
	<Mapping name = "ScrollDown" 			rwebCommand = "ITDService.scrollDownRow"/>
	<Mapping name = "HpScrollDown" 			rwebCommand = "ITDService.scrollDownRow"/>
	<Mapping name = "ScrollUp" 				rwebCommand = "ITDService.scrollUpRow"/>
	<Mapping name = "HpScrollUp" 			rwebCommand = "ITDService.scrollUpRow"/>
	<Mapping name = "SelectDown" 			rwebCommand = "ITDService.selectTextDown"/>
	<Mapping name = "SelectUp" 				rwebCommand = "ITDService.selectTextUp"/>
	<Mapping name = "SelectLeft" 			rwebCommand = "ITDService.selectTextLeft"/>
	<Mapping name = "SelectRight" 			rwebCommand = "ITDService.selectTextRight"/>
	<Mapping name = "SelectPrevWord"		rwebCommand = "ITDService.selectWordLeft"/>
	<Mapping name = "SelectNextWord" 		rwebCommand = "ITDService.selectWordRight"/>

	<!--
	<Mapping name = "" 						rwebCommand = "ITDService.selectWordDown"/>
	<Mapping name = "" 						rwebCommand = "ITDService.selectWordUp"/>
	<Mapping name = "" 						rwebCommand = "ITDService.altSelectTextDown"/>
	<Mapping name = "" 						rwebCommand = "ITDService.altSelectTextUp"/>
	<Mapping name = "" 						rwebCommand = "ITDService.altSelectTextLeft"/>
	<Mapping name = "" 						rwebCommand = "ITDService.altSelectTextRight"/>
	-->
</xsl:variable>


<!-- VT Mapping Migration Table -->
<xsl:variable name = "VTKeymapMappingTable">
	<!--  Menu Commands  -->
	<Mapping name = "EditSelectAll"   		rwebCommand = "Glue.selectAll"/>
	<Mapping name = "ConnectionConnect" 	rwebCommand = "ISession.connect"/>
	<Mapping name = "ConnectionDisconnect"	rwebCommand = "ISession.disconnect"/>
	<Mapping name = "VtDisconnect"			rwebCommand = "ISession.disconnect"/>
	<Mapping name = "ClearCommunications"	rwebCommand = "VT.clearComm"/>
	<Mapping name = "HelpAboutReflection" 	rwebCommand = "Glue.aboutBoxDialog"/>
	<Mapping name = "EditCopy" 				rwebCommand = "Glue.copy"/>
	<Mapping name = "EditPaste" 			rwebCommand = "Glue.paste"/>
	<Mapping name = "EditClearDisplay" 		rwebCommand = "VT.clearDisplay"/>
	<Mapping name="TerminalRecallLastSetup" rwebCommand = "VT.recall"/>
	<Mapping name = "TerminalReset" 		rwebCommand = "VT.reset"/>
	<Mapping name = "NextPage" 				rwebCommand = "ITDService.scrollDownPage"/>
	<Mapping name = "TerminalNextPage" 		rwebCommand = "ITDService.scrollDownPage"/>
	<Mapping name = "PrevPage" 				rwebCommand = "ITDService.scrollUpPage"/>
	<Mapping name = "TerminalPreviousPage" 	rwebCommand = "ITDService.scrollUpPage"/>
	<Mapping name = "FilePrint" 			rwebCommand = "Glue.screenPrint"/>
	<Mapping name = "VtPrintScreen"  		rwebCommand = "Glue.screenPrint"/>
	<Mapping name = "ScrollDown" 			rwebCommand = "ITDService.scrollDownRow"/>
	<Mapping name = "ScrollUp" 				rwebCommand = "ITDService.scrollUpRow"/>

	<!--
	<Mapping name = "SelectDown" 			rwebCommand = "ITDService.selectTextDown"/>
	<Mapping name = "SelectUp" 				rwebCommand = "ITDService.selectTextUp"/>
	<Mapping name = "SelectLeft" 			rwebCommand = "ITDService.selectTextLeft"/>
	<Mapping name = "SelectRight" 			rwebCommand = "ITDService.selectTextRight"/>
	<Mapping name = "SelectPrevWord"		rwebCommand = "ITDService.selectWordLeft"/>
	<Mapping name = "SelectNextWord" 		rwebCommand = "ITDService.selectWordRight"/>
	<Mapping name = "" 						rwebCommand = "ITDService.selectWordDown"/>
	<Mapping name = "" 						rwebCommand = "ITDService.selectWordUp"/>
	<Mapping name = "" 						rwebCommand = "ITDService.altSelectTextDown"/>
	<Mapping name = "" 						rwebCommand = "ITDService.altSelectTextUp"/>
	<Mapping name = "" 						rwebCommand = "ITDService.altSelectTextLeft"/>
	<Mapping name = "" 						rwebCommand = "ITDService.altSelectTextRight"/>
	-->
</xsl:variable>





<!-- Modifier Migration Table -->
<xsl:variable name = "modifierTable">
	<Key name = "Alt" 				rwinModifier = "1" rwebModifier = "8" />
	<Key name = "Ctrl" 				rwinModifier = "2" rwebModifier = "2" />
	<Key name = "Ctrl+Alt"	 		rwinModifier = "3" rwebModifier = "10" />
	<Key name = "Shift" 			rwinModifier = "4" rwebModifier = "1" />
	<Key name = "Shift+Alt" 		rwinModifier = "5" rwebModifier = "9" />
	<Key name = "Shift+Ctrl" 		rwinModifier = "6" rwebModifier = "3" />
	<Key name = "Shift+Ctrl+Alt" 	rwinModifier = "7" rwebModifier = "11" />
</xsl:variable>						
<!-- otherwise 						rwinModifier = "0"    -->


<!-- PC Key Migration Table -->
<xsl:variable name = "PCKeycodeTable">
	<Key name = "Break" 			VirtKey="3"		rwebKey = "3" />
	<Key name = "Backspace" 		VirtKey="8"		rwebKey = "8" />
	<Key name = "Tab" 				VirtKey="9"		rwebKey = "9" />
	<Key name = "Center" 			VirtKey="12"	rwebKey = "12" />
	<Key name = "Return" 			VirtKey="13"	rwebKey = "10" />
	<Key name = "Pause" 			VirtKey="19"	rwebKey = "19" />
	<Key name = "CapsLock" 			VirtKey="20"	rwebKey = "20" />
	<Key name = "Esc" 				VirtKey="27"	rwebKey = "27" />
	<Key name = "Space" 			VirtKey="32"	rwebKey = "32" />

	<Key name = "PgUp" 				VirtKey="33"	rwebKey = "33" />
	<Key name = "PgDn" 				VirtKey="34"	rwebKey = "34" />
	<Key name = "End" 				VirtKey="35"	rwebKey = "35" />
	<Key name = "Home" 				VirtKey="36"	rwebKey = "36" />
	<Key name = "Left" 				VirtKey="37"	rwebKey = "37" />
	<Key name = "Up" 				VirtKey="38"	rwebKey = "38" />
	<Key name = "Right" 			VirtKey="39"	rwebKey = "39" />
	<Key name = "Down" 				VirtKey="40"	rwebKey = "40" />

	<Key name = "PrintScreen" 		VirtKey="44"	rwebKey = "154" />
	<Key name = "Del" 				VirtKey="46"	rwebKey = "127" />
	<Key name = "0" 				VirtKey="48"	rwebKey = "48" />
	<Key name = "1" 				VirtKey="49"	rwebKey = "49" />
	<Key name = "2" 				VirtKey="50"	rwebKey = "50" />
	<Key name = "3" 				VirtKey="51"	rwebKey = "51" />
	<Key name = "4" 				VirtKey="52"	rwebKey = "52" />
	<Key name = "5" 				VirtKey="53"	rwebKey = "53" />
	<Key name = "6" 				VirtKey="54"	rwebKey = "54" />
	<Key name = "7" 				VirtKey="55"	rwebKey = "55" />
	<Key name = "8" 				VirtKey="56"	rwebKey = "56" />
	<Key name = "9" 				VirtKey="57"	rwebKey = "57" />
	<Key name = "A" 				VirtKey="65"	rwebKey = "65" />
	<Key name = "B" 				VirtKey="66"	rwebKey = "66" />
	<Key name = "C" 				VirtKey="67"	rwebKey = "67" />
	<Key name = "D" 				VirtKey="68"	rwebKey = "68" />
	<Key name = "E" 				VirtKey="69"	rwebKey = "69" />
	<Key name = "F" 				VirtKey="70"	rwebKey = "70" />
	<Key name = "G" 				VirtKey="71"	rwebKey = "71" />
	<Key name = "H" 				VirtKey="72"	rwebKey = "72" />
	<Key name = "I" 				VirtKey="73"	rwebKey = "73" />
	<Key name = "J" 				VirtKey="74"	rwebKey = "74" />
	<Key name = "K" 				VirtKey="75"	rwebKey = "75" />
	<Key name = "L" 				VirtKey="76"	rwebKey = "76" />
	<Key name = "M" 				VirtKey="77"	rwebKey = "77" />
	<Key name = "N" 				VirtKey="78"	rwebKey = "78" />
	<Key name = "O" 				VirtKey="79"	rwebKey = "79" />
	<Key name = "P" 				VirtKey="80"	rwebKey = "80" />
	<Key name = "Q" 				VirtKey="81"	rwebKey = "81" />
	<Key name = "R"	 				VirtKey="82"	rwebKey = "82" />
	<Key name = "S"	 				VirtKey="83"	rwebKey = "83" />
	<Key name = "T" 				VirtKey="84"	rwebKey = "84" />
	<Key name = "U" 				VirtKey="85"	rwebKey = "85" />
	<Key name = "V" 				VirtKey="86"	rwebKey = "86" />
	<Key name = "W" 				VirtKey="87"	rwebKey = "87" />
	<Key name = "X" 				VirtKey="88"	rwebKey = "88" />
	<Key name = "Y" 				VirtKey="89"	rwebKey = "89" />
	<Key name = "Z" 				VirtKey="90"	rwebKey = "90" />

	<Key name = "Kp0" 				VirtKey="96"	rwebKey = "96" 			ExtendedKey="yes" />
	<Key name = "Kp1" 				VirtKey="97"	rwebKey = "97" 			ExtendedKey="yes" />
	<Key name = "Kp2" 				VirtKey="98"	rwebKey = "98" 			ExtendedKey="yes" />
	<Key name = "Kp3" 				VirtKey="99"	rwebKey = "99" 			ExtendedKey="yes" />
	<Key name = "Kp4" 				VirtKey="100"	rwebKey = "100" 		ExtendedKey="yes" />
	<Key name = "Kp5" 				VirtKey="101"	rwebKey = "101" 		ExtendedKey="yes" />
	<Key name = "Kp6" 				VirtKey="102"	rwebKey = "102" 		ExtendedKey="yes" />
	<Key name = "Kp7" 				VirtKey="103"	rwebKey = "103" 		ExtendedKey="yes" />
	<Key name = "Kp8" 				VirtKey="104"	rwebKey = "104" 		ExtendedKey="yes" />
	<Key name = "Kp9" 				VirtKey="105"	rwebKey = "105" 		ExtendedKey="yes" />

	<Key name = "KpCenter"			VirtKey="12"	rwebKey = "101" 		ExtendedKey="yes" />
	<Key name = "KpMultiply" 		VirtKey="106"	rwebKey = "106" 		ExtendedKey="yes" />
	<Key name = "KpPlus"			VirtKey="107"	rwebKey = "107" 		ExtendedKey="yes" />
	<Key name = "KpMinus"			VirtKey="109"	rwebKey = "109" 		ExtendedKey="yes" />
	<Key name = "KpDecimal"			VirtKey="110"	rwebKey = "110" 		ExtendedKey="yes" />
	<Key name = "KpDivide"			VirtKey="111"	rwebKey = "111" 		ExtendedKey="yes" />

	<Key name = "F1"				VirtKey="112"	rwebKey = "112" />
	<Key name = "F2"				VirtKey="113"	rwebKey = "113" />
	<Key name = "F3"				VirtKey="114"	rwebKey = "114" />
	<Key name = "F4"				VirtKey="115"	rwebKey = "115" />
	<Key name = "F5"				VirtKey="116"	rwebKey = "116" />
	<Key name = "F6"				VirtKey="117"	rwebKey = "117" />
	<Key name = "F7"				VirtKey="118"	rwebKey = "118" />
	<Key name = "F8"				VirtKey="119"	rwebKey = "119" />
	<Key name = "F9"				VirtKey="120"	rwebKey = "120" />
	<Key name = "F10"				VirtKey="121"	rwebKey = "121" />
	<Key name = "F11"				VirtKey="122"	rwebKey = "122" />
	<Key name = "F12"				VirtKey="123"	rwebKey = "123" />
	<Key name = "F13"				VirtKey="124"	rwebKey = "61440" 		ExtendedKey="yes" />
	<Key name = "F14"				VirtKey="125"	rwebKey = "61441" 		ExtendedKey="yes" />
	<Key name = "F15"				VirtKey="126"	rwebKey = "61442" 		ExtendedKey="yes" />
	<Key name = "F16"				VirtKey="127"	rwebKey = "61443" 		ExtendedKey="yes" />
	<Key name = "F17"				VirtKey="128"	rwebKey = "61444" 		ExtendedKey="yes" />
	<Key name = "F18"				VirtKey="129"	rwebKey = "61445" 		ExtendedKey="yes" />
	<Key name = "F19"				VirtKey="130"	rwebKey = "61446" 		ExtendedKey="yes" />
	<Key name = "F20"				VirtKey="131"	rwebKey = "61447" 		ExtendedKey="yes" />
	<Key name = "F21"				VirtKey="132"	rwebKey = "61448" 		ExtendedKey="yes" />
	<Key name = "F22"				VirtKey="133"	rwebKey = "61449" 		ExtendedKey="yes" />
	<Key name = "F23"				VirtKey="134"	rwebKey = "61450" 		ExtendedKey="yes" />
	<Key name = "F24"				VirtKey="135"	rwebKey = "61451" 		ExtendedKey="yes" />

	<Key name = "HpF1"				VirtKey="112"	rwebKey = "112" />
	<Key name = "HpF2"				VirtKey="113"	rwebKey = "113" />
	<Key name = "HpF3"				VirtKey="114"	rwebKey = "114" />
	<Key name = "HpF4"				VirtKey="115"	rwebKey = "115" />
	<Key name = "HpF5"				VirtKey="116"	rwebKey = "116" />
	<Key name = "HpF6"				VirtKey="117"	rwebKey = "117" />
	<Key name = "HpF7"				VirtKey="118"	rwebKey = "118" />
	<Key name = "HpF8"				VirtKey="119"	rwebKey = "119" />
	<Key name = "HpF9"				VirtKey="120"	rwebKey = "120" />
	<Key name = "HpF10"				VirtKey="121"	rwebKey = "121" />
	<Key name = "HpF11"				VirtKey="122"	rwebKey = "122" />
	<Key name = "HpF12"				VirtKey="123"	rwebKey = "123" />

	<Key name = "NumLock"			VirtKey="144"	rwebKey = "144" />
	<Key name = "ScrollLock"		VirtKey="145"	rwebKey = "145" />
	<Key name = "Compose"			VirtKey="146"	rwebKey = "65312" 		ExtendedKey="yes" />
	<Key name = "Ins" 			    VirtKey="45"	rwebKey = "155" />
	<Key name = "Insert"			VirtKey="45"	rwebKey = "155" />
	<Key name = "Semicolon"			VirtKey="186"	rwebKey = "186" />
	<Key name = "Equals"			VirtKey="187"	rwebKey = "187" />
	<Key name = "Comma"				VirtKey="188"	rwebKey = "188" />
	<Key name = "Dash"				VirtKey="189"	rwebKey = "189" />
	<Key name = "Period"			VirtKey="190"	rwebKey = "46" />
	<Key name = "Slash"				VirtKey="191"	rwebKey = "47" />
	<Key name = "Grave"				VirtKey="192"	rwebKey = "192" />
	<Key name = "OpenBracket"		VirtKey="219"	rwebKey = "219" 		ExtendedKey="yes" />
	<Key name = "BackSlash"			VirtKey="220"	rwebKey = "92" />
	<Key name = "CloseBracket"		VirtKey="221"	rwebKey = "221" 		ExtendedKey="yes" />
	<Key name = "Apostrophe"		VirtKey="222"	rwebKey = "222" />

	<Key name = "KpEnter" 			VirtKey="1293"	rwebKey = "10" 			ExtendedKey="yes" />
	<Key name = "CpPgUp"  			VirtKey="1313"	rwebKey = "33"	 		ExtendedKey="yes" />
	<Key name = "CpPgDn"  			VirtKey="1314"	rwebKey = "34"	 		ExtendedKey="yes" />
	<Key name = "CpEnd"	 			VirtKey="1315"	rwebKey = "35"	 		ExtendedKey="yes" />
	<Key name = "CpHome"  			VirtKey="1316"	rwebKey = "36"	 		ExtendedKey="yes" />
	<Key name = "CpLeft"  			VirtKey="1317"	rwebKey = "37"	 		ExtendedKey="yes" />
	<Key name = "CpUp"	 			VirtKey="1318"	rwebKey = "38"	 		ExtendedKey="yes" />
	<Key name = "CpRight" 			VirtKey="1319"	rwebKey = "39"	 		ExtendedKey="yes" />
	<Key name = "CpDown"  			VirtKey="1320"	rwebKey = "40"	 		ExtendedKey="yes" />
	<Key name = "CpIns"				VirtKey="1325"	rwebKey = "155" 		ExtendedKey="yes" />
	<Key name = "CpDel"				VirtKey="1326"	rwebKey = "127" 		ExtendedKey="yes" />
	<Key name = "ScrollLeft"		VirtKey="0"		rwebKey = "37"	 		ExtendedKey="yes" />
	<Key name = "ScrollRight"		VirtKey="0"		rwebKey = "39"	 		ExtendedKey="yes" />
</xsl:variable>


<!-- HP Terminal Key Migration Table -->
<xsl:variable name = "HPTerminalKeyTable">
	<Key name = "HpEnter" 			rwebKey = "1" />
	<Key name = "Return" 			rwebKey = "2" />
	<Key name = "Tab" 				rwebKey = "3" />
	<Key name = "HpBacktab"	  		rwebKey = "4" />
	<Key name = "BreakKey" 	 		rwebKey = "5" />
	<Key name = "Hold" 		 		rwebKey = "6" />
	<Key name = "Print" 	 		rwebKey = "7" />
	<Key name = "Backspace"	 		rwebKey = "8" />
	<Key name = "HpDelete"			rwebKey = "9" />
	<Key name = "EscKey" 			rwebKey = "10" />
	<Key name = "CapsLockToggle"	rwebKey = "11" />
	<Key name = "CursorUp" 			rwebKey = "12" />
	<Key name = "CursorDown"  		rwebKey = "13" />
	<Key name = "CursorRight" 		rwebKey = "14" />
	<Key name = "CursorLeft"  		rwebKey = "15" />
	<Key name = "HardReset"  		rwebKey = "16" />
	<Key name = "HpMenu" 	 		rwebKey = "17" />
	<Key name = "FunctionKeysSetup" rwebKey = "18" />
	<Key name = "HpSystem"			rwebKey = "19" />
	<Key name = "HpUser" 	 		rwebKey = "20" />
	<Key name = "HpModes"	  		rwebKey = "21" />
	<Key name = "HpHomeUp"			rwebKey = "22" />
	<Key name = "HpHomeDown"  		rwebKey = "23" />
	<Key name = "HpClearDisplay"	rwebKey = "24" />
	<Key name = "EditClearDisplay"	rwebKey = "24" />
	<Key name = "HpClearLine"		rwebKey = "25" />
	<Key name = "HpInsertLine"		rwebKey = "26" />
	<Key name = "HpDeleteLine"		rwebKey = "27" />
	<Key name = "HpInsertChar"		rwebKey = "28" />
	<Key name = "HpInsertCharWrap"	rwebKey = "29" />
	<Key name = "HpDeleteChar"		rwebKey = "30" />
	<Key name = "HpDeleteCharWrap" 	rwebKey = "31" />
	<Key name = "PrevPage" 			rwebKey = "32" />
	<Key name = "NextPage" 			rwebKey = "33" />
	<Key name = "ScrollUp"			rwebKey = "34" />
	<Key name = "ScrollDown"		rwebKey = "35" />
	<Key name = "HpF1"				rwebKey = "36" />
	<Key name = "HpF2"				rwebKey = "37" />
	<Key name = "HpF3"				rwebKey = "38" />
	<Key name = "HpF4"				rwebKey = "39" />
	<Key name = "HpF5"				rwebKey = "40" />
	<Key name = "HpF6"				rwebKey = "41" />
	<Key name = "HpF7"				rwebKey = "42" />
	<Key name = "HpF8"				rwebKey = "43" />
	<Key name = "HpDefaultF1"		rwebKey = "44" />
	<Key name = "HpDefaultF2"		rwebKey = "45" />
	<Key name = "HpDefaultF3"		rwebKey = "46" />
	<Key name = "HpDefaultF4"		rwebKey = "47" />
	<Key name = "HpDefaultF5"		rwebKey = "48" />
	<Key name = "HpDefaultF6"		rwebKey = "49" />
	<Key name = "HpDefaultF7"		rwebKey = "50" />
	<Key name = "HpDefaultF8"		rwebKey = "51" />
	<Key name = "SoftReset"			rwebKey = "105" />
	<Key name = "ClearTypeahead"	rwebKey = "107" />
	<Key name = "HpSelect"			rwebKey = "108" />
	<Key name = "SmartEnterKey" 	rwebKey = "109" />
</xsl:variable>						


<!-- VT Terminal Key Migration Table -->
<xsl:variable name = "VTTerminalKeyTable">
	<Key name = "VtEnter" 			rwebKey = "1" />
	<Key name = "Return" 			rwebKey = "2" />
	<Key name = "Tab" 				rwebKey = "3" />
	<Key name = "BreakKey" 	 		rwebKey = "7" />
	<Key name = "VtBreak" 	 		rwebKey = "7" />
	<Key name = "VTHoldScreen" 		rwebKey = "8" />
	<Key name = "VtBackArrow"	 	rwebKey = "9" />
	<Key name = "Backspace"	 		rwebKey = "9" />
	<Key name = "EscKey" 			rwebKey = "10" />
	<Key name = "VtFind"	  		rwebKey = "13" />
	<Key name = "VtInsertHere" 		rwebKey = "14" />
	<Key name = "VtRemove"  		rwebKey = "15" />
	<Key name = "VtSelect"  		rwebKey = "16" />
	<Key name = "VtPrevScreen" 		rwebKey = "17" />
	<Key name = "VtNextScreen" 		rwebKey = "18" />
	<Key name = "CursorUp"			rwebKey = "19" />
	<Key name = "CursorDown"  		rwebKey = "20" />
	<Key name = "CursorRight"  		rwebKey = "21" />
	<Key name = "CursorLeft"   		rwebKey = "22" />
	<Key name = "VtPf1"  			rwebKey = "23" />
	<Key name = "VtPf2"				rwebKey = "24" />
	<Key name = "VtPf3"				rwebKey = "25" />
	<Key name = "VtPf4"				rwebKey = "26" />
	<Key name = "VtMinus"			rwebKey = "27" />
	<Key name = "VtComma"			rwebKey = "28" />
	<Key name = "VtDecimal"			rwebKey = "29" />
	<Key name = "Vt0"				rwebKey = "30" />
	<Key name = "Vt1" 				rwebKey = "31" />
	<Key name = "Vt2" 				rwebKey = "32" />
	<Key name = "Vt3" 				rwebKey = "33" />
	<Key name = "Vt4"				rwebKey = "34" />
	<Key name = "Vt5"				rwebKey = "35" />
	<Key name = "Vt6"				rwebKey = "36" />
	<Key name = "Vt7"				rwebKey = "37" />
	<Key name = "Vt8"				rwebKey = "38" />
	<Key name = "Vt9"				rwebKey = "39" />
	<Key name = "VtF1"				rwebKey = "40" />
	<Key name = "VtF2"				rwebKey = "41" />
	<Key name = "VtF3"				rwebKey = "42" />
	<Key name = "VtF4"				rwebKey = "43" />
	<Key name = "VtF5"				rwebKey = "44" />
	<Key name = "VtF6"				rwebKey = "45" />
	<Key name = "VtF7"				rwebKey = "46" />
	<Key name = "VtF8"				rwebKey = "47" />
	<Key name = "VtF9"				rwebKey = "48" />
	<Key name = "VtF10"				rwebKey = "49" />
	<Key name = "VtF11"				rwebKey = "50" />
	<Key name = "VtF12"				rwebKey = "51" />
	<Key name = "VtF13"				rwebKey = "52" />
	<Key name = "VtF14"				rwebKey = "53" />
	<Key name = "VtF15"				rwebKey = "54" />
	<Key name = "VtF16"				rwebKey = "55" />
	<Key name = "VtF17"				rwebKey = "56" />
	<Key name = "VtF18"				rwebKey = "57" />
	<Key name = "VtF19"				rwebKey = "58" />
	<Key name = "VtF20"				rwebKey = "59" />
	<Key name = "VtUdk6"			rwebKey = "60" />
	<Key name = "VtUdk7"			rwebKey = "61" />
	<Key name = "VtUdk8"			rwebKey = "62" />
	<Key name = "VtUdk9"			rwebKey = "63" />
	<Key name = "VtUdk10"			rwebKey = "64" />
	<Key name = "VtUdk11"			rwebKey = "65" />
	<Key name = "VtUdk12"			rwebKey = "66" />
	<Key name = "VtUdk13"			rwebKey = "67" />
	<Key name = "VtUdk14"			rwebKey = "68" />
	<Key name = "VtUdk15"			rwebKey = "69" />
	<Key name = "VtUdk16"			rwebKey = "70" />
	<Key name = "VtUdk17"			rwebKey = "71" />
	<Key name = "VtUdk18"			rwebKey = "72" />
	<Key name = "VtUdk19"			rwebKey = "73" />
	<Key name = "VtUdk20"			rwebKey = "74" />
</xsl:variable>						





<!-- Rwin default color palette -->
<xsl:variable name = "DefaultPalette">
<COLOR_PALETTE>
	<COLOR name = "black"		index="0" 	value="0x0" />
	<COLOR name = "maroon"		index="1" 	value="0x800000" />
	<COLOR name = "green"		index="2" 	value="0x008000" />
	<COLOR name = "dark yellow"	index="3" 	value="0x808000" />
	<COLOR name = "navy"		index="4" 	value="0x000080" />
	<COLOR name = "purple"		index="5" 	value="0x800080" />
	<COLOR name = "teal"		index="6" 	value="0x008080" />
	<COLOR name = "Rwin grey"	index="7" 	value="0x6e6e6e" />
	<COLOR name = "silver"		index="8" 	value="0xc0c0c0" />
	<COLOR name = "red"			index="9" 	value="0xff0000" />
	<COLOR name = "lime"		index="10" 	value="0x00ff00" />
	<COLOR name = "yellow"		index="11" 	value="0xffff00" />
	<COLOR name = "blue"		index="12" 	value="0x0000ff" />
	<COLOR name = "fuchsia"		index="13" 	value="0xff00ff" />
	<COLOR name = "aqua"		index="14" 	value="0x00ffff" />
	<COLOR name = "white"		index="15" 	value="0xffffff" />
</COLOR_PALETTE>
</xsl:variable>


<!-- Color Migration Table -->

<xsl:variable name = "ColorPaletteTable">
	<Color name = "black"		value = "0x0" 		rwebIndx = "2" 		rwinIndx = "1"/>
	<Color name = "black"		value = "0x000000" 	rwebIndx = "2" 		rwinIndx = "1"/>
	<Color name = "maroon"		value = "0x800000" 	rwebIndx = "6" 		rwinIndx = "2"/>
	<Color name = "green"		value = "0x8000" 	rwebIndx = "10"		rwinIndx = "3"/>
	<Color name = "green"		value = "0x008000" 	rwebIndx = "10"		rwinIndx = "3"/>
	<Color name = "darkyellow"	value = "0x808000" 	rwebIndx = "8" 		rwinIndx = "4"/>
	<Color name = "navy"		value = "0x80" 		rwebIndx = "14" 	rwinIndx = "5"/>
	<Color name = "navy"		value = "0x000080" 	rwebIndx = "14" 	rwinIndx = "5"/>
	<Color name = "purple"		value = "0x800080" 	rwebIndx = "16"		rwinIndx = "6"/>
	<Color name = "teal"		value = "0x8080" 	rwebIndx = "12"		rwinIndx = "7"/>
	<Color name = "teal"		value = "0x008080" 	rwebIndx = "12"		rwinIndx = "7"/>
	<Color name = "grey"		value = "0x808080" 	rwebIndx = "4" 		rwinIndx = "8"/>
	<Color name = "grey"		value = "0x6e6e6e" 	rwebIndx = "4" 		rwinIndx = "8"/>
	<Color name = "silver"		value = "0xc0c0c0" 	rwebIndx = "3" 		rwinIndx = "9"/>
	<Color name = "red"			value = "0xff0000" 	rwebIndx = "5"	 	rwinIndx = "10"/>
	<Color name = "lime"		value = "0xff00" 	rwebIndx = "9" 		rwinIndx = "11"/>
	<Color name = "lime"		value = "0x00ff00" 	rwebIndx = "9" 		rwinIndx = "11"/>
	<Color name = "yellow"		value = "0xffff00" 	rwebIndx = "7"	 	rwinIndx = "12"/>
	<Color name = "blue"		value = "0xff" 		rwebIndx = "13" 	rwinIndx = "13"/>
	<Color name = "blue"		value = "0x0000ff" 	rwebIndx = "13" 	rwinIndx = "13"/>
	<Color name = "fuchsia"		value = "0xff00ff" 	rwebIndx = "15" 	rwinIndx = "14"/>
	<Color name = "aqua"		value = "0xffff" 	rwebIndx = "11" 	rwinIndx = "15"/>
	<Color name = "aqua"		value = "0x00ffff" 	rwebIndx = "11" 	rwinIndx = "15"/>
	<Color name = "white"		value = "0xffffff" 	rwebIndx = "1" 		rwinIndx = "16"/>
</xsl:variable>



<!-- Rweb Character Migration Table -->
<xsl:variable name = "RwebCharacterTable">
	<Key name = "!" 				migratedKey = "33" />
	<Key name = "&quot;" 			migratedKey = "34" />
	<Key name = "#" 				migratedKey = "35" />
	<Key name = "$" 				migratedKey = "36" />
	<Key name = "%" 				migratedKey = "37" />
	<Key name = "&amp;" 			migratedKey = "38" />
	<Key name = "'" 				migratedKey = "39" />
	<Key name = "(" 				migratedKey = "40" />
	<Key name = ")" 				migratedKey = "41" />
	<Key name = "*" 				migratedKey = "42" />
	<Key name = "+" 				migratedKey = "43" />
	<Key name = "," 				migratedKey = "44" />
	<Key name = "-" 				migratedKey = "45" />
	<Key name = "." 				migratedKey = "46" />
	<Key name = "/" 				migratedKey = "47" />
	<Key name = "0" 				migratedKey = "48" />
	<Key name = "1" 				migratedKey = "49" />
	<Key name = "2" 				migratedKey = "50" />
	<Key name = "3" 				migratedKey = "51" />
	<Key name = "4" 				migratedKey = "52" />
	<Key name = "5" 				migratedKey = "53" />
	<Key name = "6" 				migratedKey = "54" />
	<Key name = "7" 				migratedKey = "55" />
	<Key name = "8" 				migratedKey = "56" />
	<Key name = "9" 				migratedKey = "57" />
	<Key name = ":" 				migratedKey = "58" />
	<Key name = ";" 				migratedKey = "59" />
	<Key name = "&lt;" 				migratedKey = "60" />
	<Key name = "=" 				migratedKey = "61" />
	<Key name = "&gt;" 				migratedKey = "62" />
	<Key name = "?" 				migratedKey = "63" />
	<Key name = "@" 				migratedKey = "64" />
	<Key name = "A" 				migratedKey = "65" />
	<Key name = "B" 				migratedKey = "66" />
	<Key name = "C" 				migratedKey = "67" />
	<Key name = "D" 				migratedKey = "68" />
	<Key name = "E" 				migratedKey = "69" />
	<Key name = "F" 				migratedKey = "70" />
	<Key name = "G" 				migratedKey = "71" />
	<Key name = "H" 				migratedKey = "72" />
	<Key name = "I" 				migratedKey = "73" />
	<Key name = "J" 				migratedKey = "74" />
	<Key name = "K" 				migratedKey = "75" />
	<Key name = "L" 				migratedKey = "76" />
	<Key name = "M" 				migratedKey = "77" />
	<Key name = "N" 				migratedKey = "78" />
	<Key name = "O" 				migratedKey = "79" />
	<Key name = "P" 				migratedKey = "80" />
	<Key name = "Q" 				migratedKey = "81" />
	<Key name = "R" 				migratedKey = "82" />
	<Key name = "S" 				migratedKey = "83" />
	<Key name = "T" 				migratedKey = "84" />
	<Key name = "U" 				migratedKey = "85" />
	<Key name = "V" 				migratedKey = "86" />
	<Key name = "W" 				migratedKey = "87" />
	<Key name = "X" 				migratedKey = "88" />
	<Key name = "Y" 				migratedKey = "89" />
	<Key name = "Z" 				migratedKey = "90" />
	<Key name = "[" 				migratedKey = "91" />
	<Key name = "\" 				migratedKey = "92" />
	<Key name = "]" 				migratedKey = "93" />
	<Key name = "`" 				migratedKey = "96" />
	<Key name = "a" 				migratedKey = "97" />
	<Key name = "b" 				migratedKey = "98" />
	<Key name = "c" 				migratedKey = "99" />
	<Key name = "d" 				migratedKey = "100" />
	<Key name = "e" 				migratedKey = "101" />
	<Key name = "f" 				migratedKey = "102" />
	<Key name = "g" 				migratedKey = "103" />
	<Key name = "h" 				migratedKey = "104" />
	<Key name = "i" 				migratedKey = "105" />
	<Key name = "i" 				migratedKey = "106" />
	<Key name = "j" 				migratedKey = "107" />
	<Key name = "l" 				migratedKey = "108" />
	<Key name = "m" 				migratedKey = "109" />
	<Key name = "n" 				migratedKey = "110" />
	<Key name = "o" 				migratedKey = "111" />
	<Key name = "p" 				migratedKey = "112" />
	<Key name = "q" 				migratedKey = "113" />
	<Key name = "r" 				migratedKey = "114" />
	<Key name = "s" 				migratedKey = "115" />
	<Key name = "t" 				migratedKey = "116" />
	<Key name = "u" 				migratedKey = "117" />
	<Key name = "v" 				migratedKey = "118" />
	<Key name = "w" 				migratedKey = "119" />
	<Key name = "x" 				migratedKey = "120" />
	<Key name = "y" 				migratedKey = "121" />
	<Key name = "z" 				migratedKey = "122" />
<!--<Key name = "{" 				migratedKey = "123" />-->
<!--<Key name = "}" 				migratedKey = "125" />-->
	<Key name = "|" 				migratedKey = "124" />
	<Key name = "~" 				migratedKey = "126" />
</xsl:variable>




<xsl:variable name = "ControlCodes">
	<Char char = "&#9;"		code = "9" />
	<Char char = "&#10;"	code = "10" />
	<Char char = "&#13;"	code = "13" />

<!--
	<Char char = "&#0;"		code = "0" />
	<Char char = "&#1;"		code = "1" />
	<Char char = "&#2;"		code = "2" />
	<Char char = "&#3;"		code = "3" />
	<Char char = "&#4;"		code = "4" />
	<Char char = "&#5;"		code = "5" />				
	<Char char = "&#6;"		code = "6" />
	<Char char = "&#7;"		code = "7" />
	<Char char = "&#8;"		code = "8" />
	<Char char = "&#9;"		code = "9" />
	<Char char = "&#10;"	code = "10" />
	<Char char = "&#11;"	code = "11" />
	<Char char = "&#12;"	code = "12" />
	<Char char = "&#13;"	code = "13" />
	<Char char = "&#14;"	code = "14" />
	<Char char = "&#15;"	code = "15" />
	<Char char = "&#16;"	code = "16" />
	<Char char = "&#17;" 	code = "17" />
	<Char char = "&#18;" 	code = "18" />
	<Char char = "&#19;" 	code = "19" />
	<Char char = "&#20;" 	code = "20" />
	<Char char = "&#21;" 	code = "21" />
	<Char char = "&#22;" 	code = "22" />
	<Char char = "&#23;" 	code = "23" />
	<Char char = "&#24;" 	code = "24" />
	<Char char = "&#25;" 	code = "25" />
	<Char char = "&#26;" 	code = "26" />
	<Char char = "&#27;" 	code = "27" />
	<Char char = "&#28;" 	code = "28" />
	<Char char = "&#29;" 	code = "29" />
	<Char char = "&#30;" 	code = "30" />
	<Char char = "&#31;" 	code = "31" />
-->
</xsl:variable>						






<xsl:variable name = "HPPropertyTable"	select = "msxsl:node-set($HP_PropertyTable)"/>
<xsl:variable name = "VTPropertyTable" 	select = "msxsl:node-set($VT_PropertyTable)"/>
<xsl:variable name = "ColorTable"		select = "msxsl:node-set($ColorPaletteTable)"/>
<xsl:variable name = "PCkeycodeTable"	select = "msxsl:node-set($PCKeycodeTable)"/>
<xsl:variable name = "ModifierTable"	select = "msxsl:node-set($modifierTable)"/>
<xsl:variable name = "CtrlCodeTable"   	select = "msxsl:node-set($ControlCodes)"/>



<xsl:template match="/">
	<xsl:variable name = "validSourceXML">
		<xsl:call-template name = "isSourceXMLValid"/>
	</xsl:variable>

	<xsl:choose>
		<xsl:when test = "string($validSourceXML) = 'true'">
		   	<xsl:call-template name = "createImportSetttingsFile"/>
		</xsl:when>
 		<xsl:otherwise>
			<xsl:call-template name = "reportBadSourceXML"/>
	  	</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "createImportSetttingsFile">
	<xsl:call-template name = "CreatedByComment"/>
	<xsl:element name = "REFLECTION_SETTINGS_IMPORT">
		<xsl:attribute name = "version">
			<xsl:value-of select="$ImportFormatVersion"/>
		</xsl:attribute>
		<xsl:call-template name = "Creator"/>
		<xsl:call-template name = "PropertySettings"/>
		<xsl:call-template name = "ConnectionSettings"/>
		<xsl:call-template name = "ColorSettings"/>
		<xsl:call-template name = "HPfkeys"/>
		<xsl:call-template name = "Keymap"/>
		<xsl:call-template name = "tabstops"/>
		<xsl:call-template name = "lineBreak"/>
	</xsl:element>
</xsl:template>



<xsl:template name = "Creator" >
	<xsl:call-template name = "lineBreakOneTab"/>
	<xsl:element name = "CREATOR">
		<xsl:attribute name = "product">Reflection for the Web</xsl:attribute>
		<xsl:attribute name = "version">
			<xsl:value-of select = "$XMLversion"/>
		</xsl:attribute>
		<xsl:attribute name = "type">
			<xsl:choose>
				<xsl:when test = "$emulator = 'HP'">1</xsl:when>
				<xsl:otherwise>2</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>
		<xsl:attribute name = "emulation">
			<xsl:value-of select = "$emulator"/>
		</xsl:attribute>
		<xsl:attribute name = "prod">rweb</xsl:attribute>
	</xsl:element>
 </xsl:template>



<xsl:template name = "PropertySettings" >
	<xsl:call-template name = "lineBreakOneTab"/>
	<xsl:element name = "PROPERTIES">
		<xsl:call-template name = "SetSpecialProperties"/>
		<xsl:call-template name = "SetProperties"/>
		<xsl:call-template name = "lineBreakOneTab"/>
	</xsl:element>
</xsl:template>



<xsl:template name = "SetSpecialProperties" >
	<xsl:choose>
		<xsl:when test = "$emulator = 'HP'">

			<!-- HP containers -->

			<xsl:call-template name = "SpecialProperties" >
				<xsl:with-param name = "properties" select = "$HP_SpecialPropertyTable"/>
				<xsl:with-param name = "container" select = "$hpProperties"/>
	  			<xsl:with-param name = "propertyTable" select = "$HPPropertyTable"/>
			</xsl:call-template>


		</xsl:when>
		<xsl:otherwise>

			<!-- VT containers -->

			<xsl:call-template name = "SpecialProperties" >
				<xsl:with-param name = "properties" select = "$VT_SpecialPropertyTable"/>
				<xsl:with-param name = "container" select = "$vtProperties"/>
				<xsl:with-param name = "propertyTable" select = "$VTPropertyTable"/>
			</xsl:call-template>

		</xsl:otherwise>
	</xsl:choose>

</xsl:template>


<xsl:template name = "SetProperties" >
	<xsl:choose>
		<xsl:when test = "$emulator = 'HP'">

			<!-- HP containers -->

			<xsl:call-template name = "Properties">
				<xsl:with-param name = "container" select = "$hpProperties"/>
				<xsl:with-param name = "propertyTable" select = "$HPPropertyTable"/>
			</xsl:call-template>
			<xsl:call-template name = "Properties">
				<xsl:with-param name = "container" select = "$session"/>
				<xsl:with-param name = "propertyTable" select = "$HPPropertyTable"/>
				<xsl:with-param name = "containername">com.wrq.session.Session</xsl:with-param>

			</xsl:call-template>
			<xsl:call-template name = "Properties">
				<xsl:with-param name = "container" select = "$hptisb"/>
				<xsl:with-param name = "propertyTable" select = "$HPPropertyTable"/>
			</xsl:call-template>
			<xsl:call-template name = "Properties">
				<xsl:with-param name = "container" select = "$hptd"/>
				<xsl:with-param name = "propertyTable" select = "$HPPropertyTable"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>

			<!-- VT containers -->

			<xsl:call-template name = "Properties">
				<xsl:with-param name = "container" select = "$vtProperties"/>
				<xsl:with-param name = "propertyTable" select = "$VTPropertyTable"/>
			</xsl:call-template>
			<xsl:call-template name = "Properties">
				<xsl:with-param name = "container" select = "$session"/>
				<xsl:with-param name = "propertyTable" select = "$VTPropertyTable"/>
			</xsl:call-template>
			<xsl:call-template name = "Properties">
				<xsl:with-param name = "container" select = "$vttisb"/>
				<xsl:with-param name = "propertyTable" select = "$VTPropertyTable"/>
			</xsl:call-template>
			<xsl:call-template name = "Properties">
				<xsl:with-param name = "container" select = "$vttd"/>
				<xsl:with-param name = "propertyTable" select = "$VTPropertyTable"/>
			</xsl:call-template>
			<xsl:call-template name = "Properties">
				<xsl:with-param name = "container" select = "$vtpresentation"/>
				<xsl:with-param name = "propertyTable" select = "$VTPropertyTable"/>
				<xsl:with-param name = "containername">PresentationManager3</xsl:with-param>
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>

	<!-- settings that require special handling -->
	<xsl:variable name = "transport">
		<xsl:value-of select = "/REFLECTION_WEB/XML_STORE/CONTAINERS/CONTAINER[@NAME='com.wrq.session.Session']/CONTEXT_CHILD_STATE/COMMAND_LIST/COMMAND[@NAME='ISession.sessionSetup']/OBJECT_ARRAY/STRING[3]"/>
	</xsl:variable>
	<xsl:variable name = "renegotiateEcho">
		<xsl:if test = "$transport = 'telnet'">
			<xsl:value-of select = "$transportOptions/CORE_PROPERTY[@NAME = 'renegotiateEcho']/BOOLEAN"/>
		</xsl:if>
	</xsl:variable>

	<xsl:if test = "string($renegotiateEcho)">
		<xsl:call-template name = "lineBreakTwoTabs"/>
		<xsl:element name = "PROPERTY">
			<xsl:attribute name = "name">TelnetRenegotiateEcho</xsl:attribute>
			<xsl:attribute name = "type">Boolean</xsl:attribute>
			<xsl:value-of select = "$renegotiateEcho"/>
		</xsl:element>
	</xsl:if>

</xsl:template>


<xsl:template name = "ConnectionSettings" >
	<xsl:call-template name = "lineBreakOneTab"/>
	<xsl:element name = "CONNECTION">
		<xsl:call-template name = "SetConnectionSettings"/>
		<xsl:call-template name = "lineBreakOneTab"/>
	</xsl:element>
</xsl:template>



<xsl:template name = "SetConnectionSettings" >
	<xsl:variable name = "transport">
		<xsl:value-of select = "/REFLECTION_WEB/XML_STORE/CONTAINERS/CONTAINER[@NAME='com.wrq.session.Session']/CONTEXT_CHILD_STATE/COMMAND_LIST/COMMAND[@NAME='ISession.sessionSetup']/OBJECT_ARRAY/STRING[3]"/>
	</xsl:variable>
	<xsl:variable name = "hostSansTransport">
		<xsl:value-of select = "substring-after($host,'://')"/>
	</xsl:variable>
	<xsl:variable name = "hostName">
		<xsl:choose>
			<xsl:when test = "contains($hostSansTransport,':')">
				<xsl:value-of select = "substring-before($hostSansTransport,':')"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select = "$hostSansTransport"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = "telnetBinary">
		<xsl:if test = "$transport = 'telnet'">
			<xsl:value-of select = "$transportOptions/CORE_PROPERTY[@NAME = 'requestBinary']/BOOLEAN"/>
		</xsl:if>
	</xsl:variable>
	<xsl:variable name = "telnetTerminalType">
		<xsl:if test = "$transport = 'telnet'">
			<xsl:value-of select = "$transportOptions/CORE_PROPERTY[@NAME = 'telnetTerminalType']/STRING"/>
		</xsl:if>
	</xsl:variable>
	<xsl:variable name = "sendLFAfterCR">
		<xsl:if test = "$transport = 'telnet'">
			<xsl:value-of select = "$transportOptions/CORE_PROPERTY[@NAME = 'sendLFAfterCR']/BOOLEAN"/>
		</xsl:if>
	</xsl:variable>
	<xsl:variable name = "breakSendsIP">
		<xsl:if test = "$transport = 'telnet'">
			<xsl:value-of select = "$transportOptions/CORE_PROPERTY[@NAME = 'breakSendsIP']/BOOLEAN"/>
		</xsl:if>
	</xsl:variable>
	<xsl:variable name = "initiateOptionNegotiation">
		<xsl:if test = "$transport = 'telnet'">
			<xsl:value-of select = "$transportOptions/CORE_PROPERTY[@NAME = 'initiateOptionNegotiation']/BOOLEAN"/>
		</xsl:if>
	</xsl:variable>
	<xsl:variable name = "negotiateWindowSize">
		<xsl:if test = "$transport = 'telnet'">
			<xsl:value-of select = "$transportOptions/CORE_PROPERTY[@NAME = 'negotiateWindowSize']/BOOLEAN"/>
		</xsl:if>
	</xsl:variable>
	<xsl:variable name = "telnetLocalMode">
		<xsl:if test = "$transport = 'telnet'">
			<xsl:value-of select = "$transportOptions/CORE_PROPERTY[@NAME = 'localMode']/INTEGER"/>
		</xsl:if>
	</xsl:variable>
	<xsl:variable name = "telnetEcho">
		<xsl:if test = "($transport = 'telnet') and string($telnetLocalMode)">
		<xsl:choose>
			<xsl:when test = "$telnetLocalMode = '0'">Auto</xsl:when>
			<xsl:when test = "$telnetLocalMode = '1'">Yes</xsl:when>
			<xsl:when test = "$telnetLocalMode = '2'">No</xsl:when>
		</xsl:choose>
		</xsl:if>
	</xsl:variable>
	<xsl:variable name = "encryptStream">
		<xsl:if test = "($transport = 'telnet') or ($transport = 'nsvt')">
			<xsl:value-of select = "$transportOptions/CORE_PROPERTY[@NAME = 'encryptStream']/BOOLEAN"/>
		</xsl:if>
	</xsl:variable>
	<xsl:variable name = "securityEnabled">
		<xsl:if test = "($transport = 'telnet') or ($transport = 'nsvt')">
			<xsl:value-of select = "$transportOptions/CORE_PROPERTY[@NAME = 'securityEnabled']/BOOLEAN"/>
		</xsl:if>
	</xsl:variable>
	<xsl:variable name = "telnetPort">
		<xsl:if test = "substring($host,1,6) = 'telnet'">
			<xsl:value-of select = "substring-after(substring-after($host,'://'),':')"/>
		</xsl:if>
	</xsl:variable>


	<xsl:if test = "string($transport)">
		<xsl:call-template name = "lineBreakTwoTabs"/>
		<xsl:element name = "CONNECTION_SETTING">
			<xsl:attribute name = "name">ConnectionType</xsl:attribute>
				<xsl:choose>
					<xsl:when test = "$transport = 'nsvt'">vt-mgr</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select = "$transport"/>
					</xsl:otherwise>
				</xsl:choose>
		</xsl:element>
	</xsl:if>

	<xsl:if test = "string($hostName)">
		<xsl:call-template name = "lineBreakTwoTabs"/>
		<xsl:element name = "CONNECTION_SETTING">
			<xsl:attribute name = "name">Host</xsl:attribute>
			<xsl:value-of select = "$hostName"/>
		</xsl:element>
	</xsl:if>

	<xsl:if test = "string($encryptStream)">
		<xsl:call-template name = "lineBreakTwoTabs"/>
		<xsl:element name = "CONNECTION_SETTING">
			<xsl:attribute name = "name">UseTLS</xsl:attribute>
			<xsl:value-of select = "$encryptStream"/>
		</xsl:element>
	</xsl:if>

	<xsl:if test = "string($securityEnabled)">
		<xsl:call-template name = "lineBreakTwoTabs"/>
		<xsl:element name = "CONNECTION_SETTING">
			<xsl:attribute name = "name">UseRwebSecurityProxy</xsl:attribute>
			<xsl:value-of select = "$securityEnabled"/>
		</xsl:element>
	</xsl:if>



	<xsl:if test = "string($telnetBinary)">
		<xsl:call-template name = "lineBreakTwoTabs"/>
		<xsl:element name = "CONNECTION_SETTING">
			<xsl:attribute name = "name">TelnetBinary</xsl:attribute>
			<xsl:value-of select = "$telnetBinary"/>
		</xsl:element>
	</xsl:if>

	<xsl:if test = "string($breakSendsIP)">
		<xsl:call-template name = "lineBreakTwoTabs"/>
		<xsl:element name = "CONNECTION_SETTING">
			<xsl:attribute name = "name">TelnetBreak</xsl:attribute>
			<xsl:value-of select = "$breakSendsIP"/>
		</xsl:element>
	</xsl:if>

	<xsl:if test = "string($telnetEcho)">
		<xsl:call-template name = "lineBreakTwoTabs"/>
		<xsl:element name = "CONNECTION_SETTING">
			<xsl:attribute name = "name">TelnetEcho</xsl:attribute>
			<xsl:value-of select = "$telnetEcho"/>
		</xsl:element>
	</xsl:if>

	<xsl:if test = "string($initiateOptionNegotiation)">
		<xsl:call-template name = "lineBreakTwoTabs"/>
		<xsl:element name = "CONNECTION_SETTING">
			<xsl:attribute name = "name">TelnetInitOptionNegotiation</xsl:attribute>
			<xsl:value-of select = "$initiateOptionNegotiation"/>
		</xsl:element>
	</xsl:if>

	<xsl:if test = "string($sendLFAfterCR)">
		<xsl:call-template name = "lineBreakTwoTabs"/>
		<xsl:element name = "CONNECTION_SETTING">
			<xsl:attribute name = "name">TelnetLFAfterCR</xsl:attribute>
			<xsl:value-of select = "$sendLFAfterCR"/>
		</xsl:element>
	</xsl:if>

	<xsl:if test = "string($telnetPort)">
		<xsl:call-template name = "lineBreakTwoTabs"/>
		<xsl:element name = "CONNECTION_SETTING">
			<xsl:attribute name = "name">TelnetPort</xsl:attribute>
			<xsl:value-of select = "$telnetPort"/>
		</xsl:element>
	</xsl:if>

	<xsl:if test = "string($negotiateWindowSize)">
		<xsl:call-template name = "lineBreakTwoTabs"/>
		<xsl:element name = "CONNECTION_SETTING">
			<xsl:attribute name = "name">TelnetSetWindowSize</xsl:attribute>
			<xsl:value-of select = "$negotiateWindowSize"/>
		</xsl:element>
	</xsl:if>

	<xsl:if test = "string($telnetTerminalType)">
		<xsl:call-template name = "lineBreakTwoTabs"/>
		<xsl:element name = "CONNECTION_SETTING">
			<xsl:attribute name = "name">TelnetTermDefault</xsl:attribute>
			<xsl:value-of select = "$telnetTerminalType"/>
		</xsl:element>
	</xsl:if>

</xsl:template>


<xsl:template name = "Properties" >
	<xsl:param name = "container"/>
	<xsl:param name = "propertyTable"/>
	<xsl:param name = "containername"/>

	<xsl:variable name = "ContainerName">
		<xsl:choose>
			<xsl:when test = "string($containername)">
				<xsl:value-of select = "$containername" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select = "$container/@NAME"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:for-each select="$container/PROPERTY_STATE/CORE_PROPERTY">
		<xsl:sort select="@NAME"/>
		<xsl:variable name = "this" select = "."/>

		<xsl:variable name = "PropertyEntry" select = 
		   "$propertyTable/Property[@migratedName = $this/@NAME and @container = $ContainerName]"/>
		<xsl:variable name = "propertyName" select = "$PropertyEntry/@name"/>
		<xsl:variable name = "type">
			<xsl:choose>		
			<xsl:when test = "$PropertyEntry/@sourcetype">		
				<xsl:value-of select = "$PropertyEntry/@sourcetype"/>
			</xsl:when>
			<xsl:when test = "$PropertyEntry/@type">		
				<xsl:value-of select = "$PropertyEntry/@type"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name = "RwebPropertyType"/>
			</xsl:otherwise>
			</xsl:choose>		
		</xsl:variable>

		<xsl:variable name = "specialcase">
			<xsl:choose>		
				<xsl:when test = "$PropertyEntry/@specialcase = 'true'">true</xsl:when>
				<xsl:otherwise>no</xsl:otherwise>
			</xsl:choose>		
		</xsl:variable>

		<xsl:if test = "string($propertyName)">
			<xsl:call-template name = "lineBreakTwoTabs"/>
			<xsl:element name = "PROPERTY">
				<xsl:attribute name = "name">
					<xsl:value-of select = "$propertyName"/>
				</xsl:attribute>
				<xsl:attribute name = "type">
					<xsl:call-template name="propertyType">
						<xsl:with-param name = "type" select = "$type"/>
					</xsl:call-template>
				</xsl:attribute>

				<xsl:variable name = "rwebValue">
					<xsl:call-template name="propertyValue">
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="migratedValue">
					<xsl:with-param name = "propertyEntry" select = "$PropertyEntry"/>
					<xsl:with-param name = "rwebValue" select = "$rwebValue"/>
					<xsl:with-param name = "type" select = "$type"/>
					<xsl:with-param name = "specialcase" select = "$specialcase"/>
				</xsl:call-template>
			</xsl:element>
		</xsl:if>
	</xsl:for-each>
</xsl:template>


<xsl:template name = "SpecialProperties" >
	<xsl:param name = "properties"/>
	<xsl:param name = "container"/>
	<xsl:param name = "propertyTable"/>

	<xsl:for-each select="$properties/Property">
		<xsl:variable name = "property" select = "./@migratedName"/>
		<xsl:variable name = "containerName" select = "./@container"/>
		<xsl:variable name = "this" select = "$container/PROPERTY_STATE/CORE_PROPERTY[@NAME=$property]"/>

		<xsl:variable name = "PropertyEntry" select = 
		   "$propertyTable/Property[@migratedName = $this/@NAME and @container = $containerName]"/>
     		<xsl:variable name = "propertyName" select = "$PropertyEntry/@name"/>
		<xsl:variable name = "type">
			<xsl:choose>		
			<xsl:when test = "$PropertyEntry/@sourcetype">		
				<xsl:value-of select = "$PropertyEntry/@sourcetype"/>
			</xsl:when>
			<xsl:when test = "$PropertyEntry/@type">		
				<xsl:value-of select = "$PropertyEntry/@type"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name = "RwebPropertyType"/>
			</xsl:otherwise>
			</xsl:choose>		
		</xsl:variable>

		<xsl:variable name = "specialcase">
			<xsl:choose>		
				<xsl:when test = "$PropertyEntry/@specialcase = 'true'">true</xsl:when>
				<xsl:otherwise>no</xsl:otherwise>
			</xsl:choose>		
		</xsl:variable>

		<xsl:if test = "string($propertyName)">
			<xsl:call-template name = "lineBreakTwoTabs"/>
			<xsl:element name = "PROPERTY">
				<xsl:attribute name = "name">
					<xsl:value-of select = "$propertyName"/>
				</xsl:attribute>
				<xsl:attribute name = "type">
					<xsl:call-template name="propertyType">
						<xsl:with-param name = "type" select = "$type"/>
					</xsl:call-template>
				</xsl:attribute>

				<xsl:variable name = "rwebValue">
					<xsl:call-template name="propertyValue">
						<xsl:with-param name = "entry" select = "$this"/>
					</xsl:call-template>
				</xsl:variable>

				<xsl:call-template name="migratedValue">
					<xsl:with-param name = "propertyEntry" select = "$PropertyEntry"/>
					<xsl:with-param name = "rwebValue" select = "$rwebValue"/>
					<xsl:with-param name = "type" select = "$type"/>
					<xsl:with-param name = "specialcase" select = "$specialcase"/>
				</xsl:call-template>
			</xsl:element>
		</xsl:if>
	</xsl:for-each>
</xsl:template>


<xsl:template name = "propertyType">
	<xsl:param name = "type"/>

	<xsl:choose>
		<xsl:when test = "$type = 'ENUMERATION'">Enum</xsl:when>
		<xsl:when test = "$type = 'INTEGER'">Integer</xsl:when>
		<xsl:when test = "$type = 'BOOLEAN'">Boolean</xsl:when>
		<xsl:when test = "$type = 'STRING'">String</xsl:when>
		<xsl:when test = "$type = 'CHARACTER'">Char</xsl:when>
		<xsl:otherwise>Unkown</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "propertyValue">
	<xsl:param name = "entry" select = "."/>

	<xsl:choose>
  		<xsl:when test = "$entry/INTEGER">
			<xsl:value-of select = "$entry/INTEGER"/>
		</xsl:when>
		<xsl:when test = "./BOOLEAN">
			<xsl:value-of select = "$entry/BOOLEAN"/>
		</xsl:when>
		<xsl:when test = "$entry/STRING">
			<xsl:variable name = "string" select = "$entry/STRING"/>
			<xsl:variable name = "str" select = "translate($string,'0123456789','9999999999')"/>

			<xsl:variable name = "exactstring">				
				<xsl:call-template name = "encodeString">
					<xsl:with-param name = "string" select = "$string"/>
				</xsl:call-template>
			</xsl:variable>

			<xsl:choose>
				<xsl:when test = "contains($str, '&amp;#9;') or contains($str, '&amp;#99;') or
				  				  contains($str, '&amp;#999;')">
					<xsl:value-of select = "$exactstring"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select = "$string"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise></xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "migratedValue">
	<xsl:param name = "propertyEntry"/>
	<xsl:param name = "rwebValue"/>
	<xsl:param name = "type"/>
	<xsl:param name = "specialcase"/>
	<xsl:choose>
		<xsl:when test = "$specialcase = 'true'">
			<!-- handle all the special cases here -->
			<xsl:choose>
				<xsl:when test = "$propertyEntry/@migratedName = 'deccolm'">
					<xsl:choose>
						<xsl:when test = "$rwebValue = 'false'">80</xsl:when>
						<xsl:when test = "$rwebValue = 'true'">132</xsl:when>
						<xsl:otherwise>80</xsl:otherwise>
					</xsl:choose>
				</xsl:when>

				<xsl:when test = "$propertyEntry/@migratedName = 'srm'">
 					<xsl:choose>
						<xsl:when test = "$rwebValue = 'true'">false</xsl:when>
						<xsl:otherwise>true</xsl:otherwise>								 
					</xsl:choose>
				</xsl:when>

				<xsl:when test = "$propertyEntry/@migratedName = 'startColumn'">
 					<xsl:value-of select = "$rwebValue + 1"/>
				</xsl:when>

				<xsl:when test = "$propertyEntry/@migratedName = 'returnDefinition'">
					<xsl:variable name = "char1">
						<xsl:choose>
							<xsl:when  test = "starts-with($rwebValue, '&amp;') and
											   (substring($rwebValue,2,1) = '#')">
								<xsl:value-of select = 
									"concat('#',
											substring-before(substring-after($rwebValue,'#'),';'),
											';')"/>
							</xsl:when>
							<xsl:otherwise>										
								<xsl:value-of select = "substring($rwebValue,1,1)"/>
							</xsl:otherwise>										
						</xsl:choose>				
					</xsl:variable>
					<xsl:variable name = "remainder">
						<xsl:choose>
							<xsl:when  test = "starts-with($rwebValue, '&amp;') and
											   (substring($rwebValue,2,1) = '#')">
								<xsl:value-of select = "substring-after($rwebValue, ';')"/>
							</xsl:when>
							<xsl:otherwise>										
								<xsl:value-of select = "substring($rwebValue,2)"/>
							</xsl:otherwise>										
						</xsl:choose>				
  					</xsl:variable>
					<xsl:variable name = "char2">
						<xsl:choose>
							<xsl:when  test = "starts-with($remainder, '&amp;') and
											   (substring($remainder,2,1) = '#')">
								<xsl:value-of disable-output-escaping="yes" 
									select = "concat('&amp;','#',
											substring-before(substring-after($remainder,'#'),';'),
											';')"/>
							</xsl:when>
							<xsl:otherwise>										
								<xsl:value-of select = "substring($remainder,1)"/>
							</xsl:otherwise>										
						</xsl:choose>				
					</xsl:variable>
						<xsl:value-of disable-output-escaping="yes" 
							select = "concat('&lt;![CDATA[','&amp;',$char1,$char2']]>')"/>
				</xsl:when>	
			</xsl:choose>
			<!-- end of special cases  -->
		</xsl:when>

		<xsl:when test = "$type = 'ENUMERATION'">
			<xsl:value-of select = "$propertyEntry/ENUMERATION[@migratedValue = $rwebValue]/@nvalue"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:choose>
				<xsl:when test = "contains($rwebValue, '&lt;![CDATA[')">
					<xsl:value-of disable-output-escaping="yes" 
						select = "$rwebValue"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select = "$rwebValue"/>
				</xsl:otherwise>
			</xsl:choose>

		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "RwebPropertyType">
	<xsl:choose>
		<xsl:when test = "./ENUMERATION">ENUMERATION</xsl:when>
		<xsl:when test = "./INTEGER">INTEGER</xsl:when>
		<xsl:when test = "./BOOLEAN">BOOLEAN</xsl:when>
		<xsl:when test = "./STRING">STRING</xsl:when>
		<xsl:when test = "./CHARACTER">CHARACTER</xsl:when>
		<xsl:otherwise>Unkown</xsl:otherwise>
	</xsl:choose>
</xsl:template>




<xsl:template name = "ColorSettings" >
	<xsl:variable name = "colornodecount" select = "$colors/TD_COLOR_MAP/OBJECT_ARRAY/@SIZE"/>

	<xsl:if test = "$colornodecount &gt; 15">
		<xsl:call-template name = "lineBreakOneTab"/>
		<xsl:element name = "COLORS">
			<xsl:call-template name = "SetDefaultColorPalette"/>
			<xsl:call-template name = "lineBreakTwoTabs"/>
			<xsl:element name = "COLOR_ATTRIBUTES">
				<xsl:call-template name = "ColorAttributes"/>
				<xsl:call-template name = "lineBreakTwoTabs"/>
			</xsl:element>
			<xsl:call-template name = "lineBreakOneTab"/>
		</xsl:element>
	</xsl:if>
</xsl:template>


<xsl:template name = "ColorAttributes" >
	<!-- normal text -->
	<xsl:call-template name = "SetColorAttribute">
		<xsl:with-param name = "rwebColorIndex" select = "1"/>
		<xsl:with-param name = "attributeIndex" select = "0"/>
	</xsl:call-template>

	<!-- blink -->
	<xsl:call-template name = "SetColorAttribute">
		<xsl:with-param name = "rwebColorIndex" select = "3"/>
		<xsl:with-param name = "attributeIndex" select = "1"/>
	</xsl:call-template>

	<!-- inverse -->
	<xsl:call-template name = "SetColorAttribute">
		<xsl:with-param name = "rwebColorIndex" select = "5"/>
		<xsl:with-param name = "attributeIndex" select = "2"/>
	</xsl:call-template>

	<!-- inverse + blink -->
	<xsl:call-template name = "SetColorAttribute">
		<xsl:with-param name = "rwebColorIndex" select = "7"/>
		<xsl:with-param name = "attributeIndex" select = "3"/>
	</xsl:call-template>

	<!-- underline -->
	<xsl:call-template name = "SetColorAttribute">
		<xsl:with-param name = "rwebColorIndex" select = "9"/>
		<xsl:with-param name = "attributeIndex" select = "4"/>
	</xsl:call-template>

	<!-- underline + blink -->
	<xsl:call-template name = "SetColorAttribute">
		<xsl:with-param name = "rwebColorIndex" select = "11"/>
		<xsl:with-param name = "attributeIndex" select = "5"/>
	</xsl:call-template>

	<!-- underline + inverse -->
	<xsl:call-template name = "SetColorAttribute">
		<xsl:with-param name = "rwebColorIndex" select = "13"/>
		<xsl:with-param name = "attributeIndex" select = "6"/>
	</xsl:call-template>

	<!-- underline + inverse + blink -->
	<xsl:call-template name = "SetColorAttribute">
		<xsl:with-param name = "rwebColorIndex" select = "15"/>
		<xsl:with-param name = "attributeIndex" select = "7"/>
	</xsl:call-template>

	<!-- halfbright|bold -->
	<xsl:call-template name = "SetColorAttribute">
		<xsl:with-param name = "rwebColorIndex" select = "2"/>
		<xsl:with-param name = "attributeIndex" select = "8"/>
	</xsl:call-template>

	<!-- halfbright|bold + blink -->
	<xsl:call-template name = "SetColorAttribute">
		<xsl:with-param name = "rwebColorIndex" select = "4"/>
		<xsl:with-param name = "attributeIndex" select = "9"/>
	</xsl:call-template>

	<!-- halfbright|bold + inverse -->
	<xsl:call-template name = "SetColorAttribute">
		<xsl:with-param name = "rwebColorIndex" select = "6"/>
		<xsl:with-param name = "attributeIndex" select = "10"/>
	</xsl:call-template>

	<!-- halfbright|bold + inverese + blink -->
	<xsl:call-template name = "SetColorAttribute">
		<xsl:with-param name = "rwebColorIndex" select = "8"/>
		<xsl:with-param name = "attributeIndex" select = "11"/>
	</xsl:call-template>

	<!-- halfbright|bold + underline -->
	<xsl:call-template name = "SetColorAttribute">
		<xsl:with-param name = "rwebColorIndex" select = "10"/>
		<xsl:with-param name = "attributeIndex" select = "12"/>
	</xsl:call-template>

	<!-- halfbright|bold + underline +blink -->
	<xsl:call-template name = "SetColorAttribute">
		<xsl:with-param name = "rwebColorIndex" select = "12"/>
		<xsl:with-param name = "attributeIndex" select = "13"/>
	</xsl:call-template>

	<!-- halfbright|bold + underline + inverse -->
	<xsl:call-template name = "SetColorAttribute">
		<xsl:with-param name = "rwebColorIndex" select = "14"/>
		<xsl:with-param name = "attributeIndex" select = "14"/>
	</xsl:call-template>

	<!-- halfbright|bold + underline + inverse + blink -->
	<xsl:call-template name = "SetColorAttribute">
		<xsl:with-param name = "rwebColorIndex" select = "16"/>
		<xsl:with-param name = "attributeIndex" select = "15"/>
	</xsl:call-template>

	<!-- function keys -->
	<xsl:call-template name = "SetFunctionKeyColor"/>

</xsl:template>





<xsl:template name = "SetColorAttribute" >
	<xsl:param name = "rwebColorIndex"/>
	<xsl:param name = "attributeIndex"/>

	<xsl:variable name = "colornodes" select = "$colors/TD_COLOR_MAP/OBJECT_ARRAY"/>
	<xsl:variable name = "fgcolor" select = "$colornodes/COLOR_ARRAY[$rwebColorIndex]/COLOR[1]"/>
	<xsl:variable name = "bgcolor" select = "$colornodes/COLOR_ARRAY[$rwebColorIndex]/COLOR[2]"/>
	<xsl:variable name = "fgIndex" select = "$ColorTable/Color[@value = $fgcolor]/@rwinIndx"/>
	<xsl:variable name = "bgIndex" select = "$ColorTable/Color[@value = $bgcolor]/@rwinIndx"/>
	<xsl:variable name = "index" select = "$attributeIndex"/>
	<xsl:call-template name = "ColorAttribute">
		<xsl:with-param name = "attributeIndex" select = "$index"/>
		<xsl:with-param name = "fgcolor" 		select = "$fgIndex - 1"/>
		<xsl:with-param name = "bgcolor" 		select = "$bgIndex - 1"/>
	</xsl:call-template>
</xsl:template>



<xsl:template name = "SetFunctionKeyColor" >
	<xsl:variable name = "fgcolor" select = "$hpProperties/PROPERTY_STATE/CORE_PROPERTY[@NAME = 'functionKeyTextColor']/COLOR"/>
	<xsl:variable name = "bgcolor" select = "$hpProperties/PROPERTY_STATE/CORE_PROPERTY[@NAME = 'functionKeyButtonColor']/COLOR"/>
	<xsl:variable name = "fgIndex" select = "$ColorTable/Color[@value = $fgcolor]/@rwinIndx"/>
	<xsl:variable name = "bgIndex" select = "$ColorTable/Color[@value = $bgcolor]/@rwinIndx"/>

	<xsl:variable name = "attributeIndex" select = "16"/>
	<xsl:call-template name = "ColorAttribute">
		<xsl:with-param name = "attributeIndex" select = "$attributeIndex"/>
		<xsl:with-param name = "fgcolor" 		select = "$fgIndex - 1"/>
		<xsl:with-param name = "bgcolor" 		select = "$bgIndex - 1 "/>
	</xsl:call-template>
</xsl:template>


<xsl:template name = "ColorAttribute" >
	<xsl:param name = "attributeIndex"/>
	<xsl:param name = "fgcolor"/>
	<xsl:param name = "bgcolor"/>

	<xsl:variable name = "swapcolors">
		<xsl:choose>
			<xsl:when test = "$emulator = 'HP'">
				<xsl:value-of select = "$hpcolorswapped"/>		
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select = "$vtcolorswapped"/>		
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:call-template name = "lineBreakThreeTabs"/>
	<xsl:element name = "COLOR_ATTRIBUTE">
		<xsl:attribute name = "attributeIndex">
			<xsl:value-of select="$attributeIndex"/>
		</xsl:attribute>

		<xsl:attribute name = "foreground">
			<xsl:choose>
				<xsl:when test = "$swapcolors = 'true'">
					<xsl:value-of select="$bgcolor"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$fgcolor"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>

		<xsl:attribute name = "background">
			<xsl:choose>
				<xsl:when test = "$swapcolors = 'true'">
					<xsl:value-of select="$fgcolor"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$bgcolor"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>

	</xsl:element>
 </xsl:template>




<xsl:template name = "SetDefaultColorPalette">
	<xsl:variable name="list" select = "$DefaultPalette"/>
	<xsl:apply-templates select="$list/COLOR_PALETTE"/>
</xsl:template>	  




<xsl:template match = "COLOR_PALETTE" >
	<xsl:call-template name = "lineBreakTwoTabs"/>
	<xsl:copy>
		<xsl:copy-of select="@*"/>
		<xsl:for-each select = "./COLOR">   
			<xsl:call-template name = "lineBreakThreeTabs"/>
			<xsl:copy>
				<xsl:copy-of select="@*"/>
			</xsl:copy>	   
		</xsl:for-each>	   
		<xsl:call-template name = "lineBreakTwoTabs"/>
	</xsl:copy>
</xsl:template>




<xsl:template name = "HPfkeys" >
	<xsl:variable name = "count" select = "count($hpProperties/PROPERTY_STATE/CORE_PROPERTY/HP_USER_KEY)"/>

	<xsl:if test = "($emulator = 'HP') and ($count &gt; 0)">
		<xsl:call-template name = "lineBreakOneTab"/>
		<xsl:element name = "HPFUNCTION_KEYS">

		<xsl:for-each select="$hpProperties/PROPERTY_STATE/CORE_PROPERTY/HP_USER_KEY">
			<xsl:variable name = "this" select = "."/>
			<xsl:call-template name = "lineBreakTwoTabs"/>
			<xsl:element name = "KEY">
				<xsl:attribute name = "number">
					<xsl:value-of select="count(preceding::HP_USER_KEY)+1"/>
				</xsl:attribute>
				<xsl:attribute name = "type">
					<xsl:value-of select="$this/INTEGER"/>
				</xsl:attribute>
				<xsl:attribute name = "label">
					<xsl:value-of select="$this/LABEL"/>
				</xsl:attribute>
				<xsl:value-of select = "$this/DEFINITION"/>
			</xsl:element>
		</xsl:for-each>
		<xsl:call-template name = "lineBreakOneTab"/>
		</xsl:element>
	</xsl:if>
</xsl:template>




<xsl:template name = "Keymap" >
	<xsl:variable name = "count" select = "count($keymapContainer/RKEYSTROKE_ARRAY/RKEYSTROKE/KEYSTROKE)"/>

	<xsl:if test = "$count &gt; 0">
		<xsl:call-template name = "lineBreakOneTab"/>
		<xsl:element name = "KEYMAP">

		<xsl:for-each select="$keymapContainer/RKEYSTROKE_ARRAY/RKEYSTROKE">
			<xsl:variable name = "this" select = "."/>

			<xsl:variable name = "key">
				<xsl:call-template name = "migrateKeycode">
					<xsl:with-param name = "key" select="./KEYSTROKE/KEYCODE"/>
				</xsl:call-template>
			</xsl:variable>	

			<xsl:variable name = "action" select = "./COMMAND_ACTION/COMMAND/@NAME"/>

			<xsl:variable name = "type">
				<xsl:call-template name = "migrateKeymapType">
					<xsl:with-param name = "action" select = "$action"/>
				</xsl:call-template>
			</xsl:variable>

			<xsl:variable name = "mapping">
				<xsl:choose>
					<xsl:when test = "$emulator = 'HP'">
						<xsl:call-template name = "migrateKeymapping">
							<xsl:with-param name = "action" 		select = "$action"/>
							<xsl:with-param name = "keyTable" 		select = "$hpkeyTable"/>
							<xsl:with-param name = "terminalKeys" 	select = "$hpterminalKeys"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name = "migrateKeymapping">
							<xsl:with-param name = "action" 		select = "$action"/>
							<xsl:with-param name = "keyTable" 		select = "$vtkeyTable"/>
							<xsl:with-param name = "terminalKeys" 	select = "$vtterminalKeys"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

			<xsl:if test = "string($key) and string($mapping)">
				<xsl:call-template name = "lineBreakTwoTabs"/>
				<xsl:element name = "KEYMAPPING">
					<xsl:attribute name = "virt">
						<xsl:value-of select = "$key"/>
					</xsl:attribute>
					<xsl:attribute name = "mods">
						<xsl:call-template name = "migrateModifer">
							<xsl:with-param name = "mods" select="./KEYSTROKE/MODIFIERS"/>
						</xsl:call-template>
					</xsl:attribute>
		
					<xsl:attribute name = "type">
						<xsl:value-of select = "$type"/>
					</xsl:attribute>

					<xsl:value-of select = "$mapping"/>

				</xsl:element>
			</xsl:if>
		</xsl:for-each>
		<xsl:call-template name = "lineBreakOneTab"/>
		</xsl:element>
	</xsl:if>
</xsl:template>




<xsl:template name = "migrateKeycode" >
	<xsl:param name = "key"/>

	<xsl:variable name = "entry" select = "$PCkeycodeTable/Key[@rwebKey = $key]"/>
	<xsl:variable name = "rwinKey" select = "$entry/@VirtKey"/>

	<xsl:choose>
		<xsl:when test = "string($rwinKey)">
			<xsl:value-of select = "$rwinKey"/>
		</xsl:when>
		<xsl:otherwise>0</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "migrateModifer" >
	<xsl:param name = "mods"/>

	<xsl:variable name = "entry" select = "$ModifierTable/Key[@rwebModifier = $mods]"/>
	<xsl:variable name = "rwinMods" select = "$entry/@rwinModifier"/>

	<xsl:choose>
		<xsl:when test = "string($rwinMods)">
			<xsl:value-of select = "$rwinMods"/>
		</xsl:when>
		<xsl:otherwise>0</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "migrateKeymapType" >
	<xsl:param name = "action"/>

	<xsl:choose>
		<xsl:when test = "$action = 'Emulator.transmitString'">4</xsl:when>
		<xsl:otherwise>3</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "migrateKeymapping" >
	<xsl:param name = "action"/>
	<xsl:param name = "keyTable"/>
	<xsl:param name = "terminalKeys"/>

	<xsl:choose>
		<xsl:when test = "$action = 'Emulator.transmitString'">
			<xsl:value-of select = "./COMMAND_ACTION/COMMAND/OBJECT_ARRAY/STRING"/>
		</xsl:when>
		<xsl:when test = "$action = 'Emulator.transmitTerminalKey'">
			<xsl:variable name = "rwebKey" select = "./COMMAND_ACTION/COMMAND/OBJECT_ARRAY/INTEGER"/>
			<xsl:variable name = "rwinKey" select = "$terminalKeys/Key[@rwebKey = $rwebKey]/@name"/>
			<xsl:value-of select = "$rwinKey"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:variable name = "entry" select = "$keyTable/Mapping[@rwebCommand = $action]/@name"/>
			<xsl:choose>
				<xsl:when test = "string($entry)">
					<xsl:value-of select = "$entry"/>
				</xsl:when>
				<xsl:otherwise></xsl:otherwise>
			</xsl:choose>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>



<xsl:template name = "tabstops" >
	<xsl:if test = "($emulator = 'HP') and $hptabs">
		<xsl:call-template name = "lineBreakOneTab"/>
		<xsl:element name = "TABS">
			<xsl:call-template name = "lineBreakTwoTabs"/>
			<xsl:element name = "TABSTOP_LIST">
				<xsl:choose>
					<xsl:when test = "$emulator = 'HP'">
						<xsl:value-of select = "translate($hptabs,'{},','')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select = "translate($vttabs,'{},','')"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
			<xsl:call-template name = "lineBreakOneTab"/>
		</xsl:element>
	</xsl:if>
</xsl:template>



<xsl:template name = "CreatedByComment" >
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>

	<xsl:comment>
		<xsl:text>   Reflection Settings</xsl:text>
		<xsl:text> (XML Import format </xsl:text>
		<xsl:value-of select="$transformVersion"/>
		<xsl:text>)</xsl:text>
		<xsl:call-template name = "lineBreak"/>
		<xsl:text>       Created from Reflection for the Web </xsl:text> 
	    <xsl:text> - XML version </xsl:text>
		<xsl:value-of select="$XMLversion"/>

		<xsl:if test = "$keymapOnlyConfig = 'true'">
			<xsl:text> (Keymap only Config)</xsl:text> 
		</xsl:if>
	   
		<xsl:if test = "string($emulator)">
			<xsl:text> </xsl:text> 
			<xsl:value-of select="$emulator"/>
			<xsl:text> Emulation</xsl:text> 
		</xsl:if>
		<xsl:call-template name = "lineBreak"/>

		<xsl:text>       Transform version </xsl:text> 
		<xsl:value-of select="$transformVersion"/>
		<xsl:call-template name = "lineBreak"/>
	</xsl:comment>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>

						  


 

<xsl:template name = "lineBreak">
	<xsl:text>&#10;</xsl:text>
</xsl:template>

<xsl:template name = "lineBreakOneTab">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "lineBreakTwoTabs">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "lineBreakThreeTabs">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "lineBreakFourTabs">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "lineBreakFiveTabs">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "lineBreakSixTabs">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;&#9;&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "lineBreakSevenTabs">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;&#9;&#9;&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "lineBreakEightTabs">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;&#9;&#9;&#9;&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "lineBreakNineTabs">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;&#9;&#9;&#9;&#9;&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "tab">
	<xsl:text>&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "twoTabs">
	<xsl:text>&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "threeTabs">
	<xsl:text>&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "fourTabs">
	<xsl:text>&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "fiveTabs">
	<xsl:text>&#9;&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "sixTabs">
	<xsl:text>&#9;&#9;&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "sevenTabs">
	<xsl:text>&#9;&#9;&#9;&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "tabs">
	<xsl:param name = "tabcount"/>

	<xsl:if test = "$tabcount &gt; 0">
		<xsl:text>&#9;</xsl:text>	
		<xsl:call-template name = "tabs">
			<xsl:with-param name = "tabcount">
				<xsl:value-of select = "$tabcount - 1"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>


<xsl:template name = "decodeCtrlChar">
	<xsl:param name = "text"/>
	<xsl:choose>
		<xsl:when test = "string-length($text) = 4 and contains($text, '#') and
						 string-length(substring-after($text, '#')) = 3">
			<xsl:value-of select = "concat('&#38;', concat($text, ';'))"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select = "$text"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "translateCtrlChars">
	<xsl:param name = "text"/>
	<xsl:variable name = "startOfDigits">
		<xsl:value-of select = "substring-after($text, '#')"/>
	</xsl:variable>

	<xsl:choose>	
		<xsl:when test = "contains($text, '#') and contains($startOfDigits, ';')">
			<xsl:variable name = "pre">
				<xsl:value-of select = "substring-before($text, '#')"/>
			</xsl:variable>
			<xsl:variable name = "first">
				<xsl:value-of select = 
					"concat('#', substring-after(concat(substring-before($text, ';'), ';'), '#'))"/>
			</xsl:variable>
			<xsl:variable name = "remaining">
				<xsl:value-of select = "substring-after($text, ';')"/>
			</xsl:variable>
			<xsl:variable name = "charCode">
				<xsl:value-of select = "substring-before($startOfDigits, ';')"/>
			</xsl:variable>

			<xsl:choose>
				<xsl:when test = "string-length($charCode) = 3  and not(number($charCode) = Nan)">
					<xsl:variable name = "rest">
						<xsl:call-template name = "translateCtrlChars">
							<xsl:with-param name = "text">
								<xsl:value-of select = "$remaining"/>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:value-of disable-output-escaping = "yes"
						select = "concat(concat($pre, concat('&amp;', $first)), $rest)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select = "$text"/>	
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select = "$text"/>
		</xsl:otherwise>
	</xsl:choose>	
</xsl:template>


<xsl:template name = "isSourceXMLValid">
	<xsl:choose>
		<xsl:when test = "($XMLversion &gt;= 3)    			and
						  (name($root) = 'REFLECTION_WEB')">true</xsl:when>

		<xsl:when test = "($XMLversion &gt;= 2)    		    and
						  (name($root) = 'REFLECTION_WEB')  and
						  ($keymapOnlyConfig = 'true')">true</xsl:when>
	 	<xsl:otherwise></xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "reportBadSourceXML">
	<xsl:call-template name = "lineBreak"/>
	<TransformFailed>
		<xsl:call-template name = "lineBreak"/>
		<xsl:call-template name = "lineBreak"/>
		<Error>Transform Failed</Error>
		<xsl:call-template name = "lineBreak"/>
		<xsl:choose>
			<xsl:when test = "not(name($root) = 'REFLECTION_SETTINGS')">
				<Description>Source XML is not an exported Reflection Settings file.</Description>
			</xsl:when>
			<xsl:when test = "$XMLversion &lt; 3">
				<Description>This transform requires version 3.0 or greater exported Reflection Settings.</Description>
			</xsl:when>
			<xsl:when test = "not(($emulator = 1) or ($emulator = 2) or ($emulator = 4))">
				<Description>This transform requires an exported Reflection Settings file</Description>
				<xsl:call-template name = "lineBreak"/>
				<Description>from Reflection for HP, Unix and Digital, or ReGIS Graphics</Description>
			</xsl:when>
			<xsl:otherwise>
				<Description>Source XML is not an exported Reflection Settings file.</Description>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:call-template name = "lineBreak"/>
		<Description>As created by Reflection 11.0 or later.</Description>
		<xsl:call-template name = "lineBreak"/>
	</TransformFailed>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>


<xsl:template name = "decodeEntities">
	<xsl:param name = "string"/>

	<xsl:choose>
		<xsl:when test = "contains(translate($string,'0123456789','9999999999'), '&amp;#9;') or
						  contains(translate($string,'0123456789','9999999999'), '&amp;#99;') or
						  contains(translate($string,'0123456789','9999999999'), '&amp;#999;')	">

			<xsl:variable name = "pre" select = "substring-before($string,'&amp;#')"/>
			<xsl:variable name = "digits" 
				select = "substring-before(substring-after($string,'&amp;#'),';')"/>
			<xsl:variable name = "remainder" 
				select = "substring-after(substring-after($string,'&amp;#'),';')"/>

<!--
			<xsl:variable name = "ccode" select = "$CtrlCodeTable/Char[@char = $pre]/@code"/>
			<xsl:variable name = "charcode">
				<xsl:choose>
					<xsl:when test = "string(ccode)">
						<xsl:value-of select = "$ccode"/>
					</xsl:when>
					<xsl:when test = "$pre = '&#10;'">13</xsl:when>
				</xsl:choose>
			</xsl:variable>
-->
			<xsl:choose>
<!--
				<xsl:when test = "string($charcode) and
-->
				<xsl:when test = "string($pre) and (string-length($pre) &gt; 0) and 
								  (contains(translate($digits,'0123456789','9999999999'), '9') or 
								  contains(translate($digits,'0123456789','9999999999'), '99') or
								  contains(translate($digits,'0123456789','9999999999'), '999'))">
<!--
					<xsl:value-of disable-output-escaping = "yes"
						select = "concat(concat('&amp;#',$charcode,';'),'&amp;#',$digits,';')"/>
-->
					<xsl:value-of disable-output-escaping = "yes"
						select = "concat($pre,'&amp;#',$digits,';')"/>


				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of disable-output-escaping = "yes"
						select = "concat(substring-before($string,';'),';')"/>
				</xsl:otherwise>
			</xsl:choose>

			<xsl:if test = "string($remainder) and string-length($remainder) &gt; 0">
				<xsl:call-template name = "decodeEntities">
					<xsl:with-param name = "string" select = "$remainder"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select = "$string"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>




<xsl:template name = "encodeString">
	<xsl:param name = "string"/>

	<xsl:choose>
		<xsl:when test = "contains(translate($string,'0123456789','9999999999'), '&amp;#9;') or
						  contains(translate($string,'0123456789','9999999999'), '&amp;#99;') or
						  contains(translate($string,'0123456789','9999999999'), '&amp;#999;')">
			<xsl:variable name = "encoding">
				<xsl:call-template name = "decodeEntities">
					<xsl:with-param name = "string" select = "$string"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:value-of disable-output-escaping="yes" 
				select = "$encoding"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select = "$string"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>





<xsl:template match="text()|@*"/>



</xsl:stylesheet>

