<?xml version="1.0"?>
<xsl:stylesheet	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
				xmlns:msxsl="urn:schemas-microsoft-com:xslt"
				xmlns:exsl="http://exslt.org/common" 
				xmlns:ext="urn:rwin-rweb-scripts"
				exclude-result-prefixes="msxsl exsl ext">


<xsl:output method = "xml" encoding = "UTF-8" cdata-section-elements = "KEY" 
			standalone = "yes" indent = "no"/>



<!--  RwinImpt.xsl  Transform Reflection Settings to Reflection import format  -->



<xsl:variable name = "transformVersion" select = "1.0"/>

<xsl:variable name = "ImportFormatVersion" select = "1.0"/>



<!-- Modifier Migration Table -->
<xsl:variable name = "ModifierTable">
	<Key name = "None" 				migratedModifier = "0" />
	<Key name = "Alt" 				migratedModifier = "1" />
	<Key name = "Ctrl" 				migratedModifier = "2" />
	<Key name = "Ctrl+Alt"	 		migratedModifier = "3" />
	<Key name = "Shift" 			migratedModifier = "4" />
	<Key name = "Shift+Alt" 		migratedModifier = "5" />
	<Key name = "Shift+Ctrl" 		migratedModifier = "6" />
	<Key name = "Shift+Ctrl+Alt" 	migratedModifier = "7" />
</xsl:variable>						


<!-- Modifier Migration Table -->
<!--
<xsl:variable name = "ModifierTable">
	<Key name = "Shift" 			migratedModifier = "1" />
	<Key name = "Ctrl" 				migratedModifier = "2" />
	<Key name = "Alt" 				migratedModifier = "8" />
	<Key name = "Shift+Ctrl" 		migratedModifier = "3" />
	<Key name = "Shift+Alt" 		migratedModifier = "9" />
	<Key name = "Ctrl+Alt"	 		migratedModifier = "10" />
	<Key name = "Shift+Ctrl+Alt" 	migratedModifier = "11" />
</xsl:variable>		
-->


<!-- PC Key Migration Table -->
<xsl:variable name = "PCkeycodeTable">
	<Key name = "Application" 		VirtKey="93" 	migratedKey = "93" />
	<Key name = "Break" 			VirtKey="3"		migratedKey = "3" />
	<Key name = "Backspace" 		VirtKey="8"		migratedKey = "8" />
	<Key name = "Tab" 				VirtKey="9"		migratedKey = "9" />
	<Key name = "Center" 			VirtKey="12"	migratedKey = "12" />
	<Key name = "Return" 			VirtKey="13"	migratedKey = "10" />
	<Key name = "Pause" 			VirtKey="19"	migratedKey = "19" />
	<Key name = "CapsLock" 			VirtKey="20"	migratedKey = "20" />
	<Key name = "Esc" 				VirtKey="27"	migratedKey = "27" />
	<Key name = "Space" 			VirtKey="32"	migratedKey = "32" />
	<Key name = "PgUp" 				VirtKey="33"	migratedKey = "33" />
	<Key name = "PgDn" 				VirtKey="34"	migratedKey = "34" />
	<Key name = "End" 				VirtKey="35"	migratedKey = "35" />
	<Key name = "Home" 				VirtKey="36"	migratedKey = "36" />
	<Key name = "Left" 				VirtKey="37"	migratedKey = "37" />
	<Key name = "Up" 				VirtKey="38"	migratedKey = "38" />
	<Key name = "Right" 			VirtKey="39"	migratedKey = "39" />
	<Key name = "Down" 				VirtKey="40"	migratedKey = "40" />

	<Key name = "PrintScreen" 		VirtKey="44"	migratedKey = "154" />
	<Key name = "Del" 				VirtKey="46"	migratedKey = "127" />
	<Key name = "0" 				VirtKey="48"	migratedKey = "48" />
	<Key name = "1" 				VirtKey="49"	migratedKey = "49" />
	<Key name = "2" 				VirtKey="50"	migratedKey = "50" />
	<Key name = "3" 				VirtKey="51"	migratedKey = "51" />
	<Key name = "4" 				VirtKey="52"	migratedKey = "52" />
	<Key name = "5" 				VirtKey="53"	migratedKey = "53" />
	<Key name = "6" 				VirtKey="54"	migratedKey = "54" />
	<Key name = "7" 				VirtKey="55"	migratedKey = "55" />
	<Key name = "8" 				VirtKey="56"	migratedKey = "56" />
	<Key name = "9" 				VirtKey="57"	migratedKey = "57" />
	<Key name = "A" 				VirtKey="65"	migratedKey = "65" />
	<Key name = "B" 				VirtKey="66"	migratedKey = "66" />
	<Key name = "C" 				VirtKey="67"	migratedKey = "67" />
	<Key name = "D" 				VirtKey="68"	migratedKey = "68" />
	<Key name = "E" 				VirtKey="69"	migratedKey = "69" />
	<Key name = "F" 				VirtKey="70"	migratedKey = "70" />
	<Key name = "G" 				VirtKey="71"	migratedKey = "71" />
	<Key name = "H" 				VirtKey="72"	migratedKey = "72" />
	<Key name = "I" 				VirtKey="73"	migratedKey = "73" />
	<Key name = "J" 				VirtKey="74"	migratedKey = "74" />
	<Key name = "K" 				VirtKey="75"	migratedKey = "75" />
	<Key name = "L" 				VirtKey="76"	migratedKey = "76" />
	<Key name = "M" 				VirtKey="77"	migratedKey = "77" />
	<Key name = "N" 				VirtKey="78"	migratedKey = "78" />
	<Key name = "O" 				VirtKey="79"	migratedKey = "79" />
	<Key name = "P" 				VirtKey="80"	migratedKey = "80" />
	<Key name = "Q" 				VirtKey="81"	migratedKey = "81" />
	<Key name = "R"	 				VirtKey="82"	migratedKey = "82" />
	<Key name = "S"	 				VirtKey="83"	migratedKey = "83" />
	<Key name = "T" 				VirtKey="84"	migratedKey = "84" />
	<Key name = "U" 				VirtKey="85"	migratedKey = "85" />
	<Key name = "V" 				VirtKey="86"	migratedKey = "86" />
	<Key name = "W" 				VirtKey="87"	migratedKey = "87" />
	<Key name = "X" 				VirtKey="88"	migratedKey = "88" />
	<Key name = "Y" 				VirtKey="89"	migratedKey = "89" />
	<Key name = "Z" 				VirtKey="90"	migratedKey = "90" />

	<Key name = "Kp0" 				VirtKey="96"	migratedKey = "96" 			ExtendedKey="yes" />
	<Key name = "Kp1" 				VirtKey="97"	migratedKey = "97" 			ExtendedKey="yes" />
	<Key name = "Kp2" 				VirtKey="98"	migratedKey = "98" 			ExtendedKey="yes" />
	<Key name = "Kp3" 				VirtKey="99"	migratedKey = "99" 			ExtendedKey="yes" />
	<Key name = "Kp4" 				VirtKey="100"	migratedKey = "100" 		ExtendedKey="yes" />
	<Key name = "Kp5" 				VirtKey="101"	migratedKey = "101" 		ExtendedKey="yes" />
	<Key name = "Kp6" 				VirtKey="102"	migratedKey = "102" 		ExtendedKey="yes" />
	<Key name = "Kp7" 				VirtKey="103"	migratedKey = "103" 		ExtendedKey="yes" />
	<Key name = "Kp8" 				VirtKey="104"	migratedKey = "104" 		ExtendedKey="yes" />
	<Key name = "Kp9" 				VirtKey="105"	migratedKey = "105" 		ExtendedKey="yes" />

	<Key name = "KpCenter"			VirtKey="12"	migratedKey = "101" 		ExtendedKey="yes" />
	<Key name = "KpMultiply" 		VirtKey="106"	migratedKey = "106" 		ExtendedKey="yes" />
	<Key name = "PF4"		 		VirtKey="106"	migratedKey = "106" 		ExtendedKey="yes"   />
	<Key name = "KpPlus"			VirtKey="107"	migratedKey = "107" 		ExtendedKey="yes" />
	<Key name = "VK_108"			VirtKey="108"	migratedKey = "108" 		ExtendedKey="yes"   />
	<Key name = "KpMinus"			VirtKey="109"	migratedKey = "109" 		ExtendedKey="yes" />
	<Key name = "KpDecimal"			VirtKey="110"	migratedKey = "110" 		ExtendedKey="yes" />
	<Key name = "KpDivide"			VirtKey="111"	migratedKey = "111" 		ExtendedKey="yes" />

	<Key name = "F1"				VirtKey="112"	migratedKey = "112" />
	<Key name = "F2"				VirtKey="113"	migratedKey = "113" />
	<Key name = "F3"				VirtKey="114"	migratedKey = "114" />
	<Key name = "F4"				VirtKey="115"	migratedKey = "115" />
	<Key name = "F5"				VirtKey="116"	migratedKey = "116" />
	<Key name = "F6"				VirtKey="117"	migratedKey = "117" />
	<Key name = "F7"				VirtKey="118"	migratedKey = "118" />
	<Key name = "F8"				VirtKey="119"	migratedKey = "119" />
	<Key name = "F9"				VirtKey="120"	migratedKey = "120" />
	<Key name = "F10"				VirtKey="121"	migratedKey = "121" />
	<Key name = "F11"				VirtKey="122"	migratedKey = "122" />
	<Key name = "F12"				VirtKey="123"	migratedKey = "123" />
	<Key name = "F13"				VirtKey="124"	migratedKey = "61440" 		ExtendedKey="yes" />
	<Key name = "F14"				VirtKey="125"	migratedKey = "61441" 		ExtendedKey="yes" />
	<Key name = "F15"				VirtKey="126"	migratedKey = "61442" 		ExtendedKey="yes" />
	<Key name = "F16"				VirtKey="127"	migratedKey = "61443" 		ExtendedKey="yes" />
	<Key name = "F17"				VirtKey="128"	migratedKey = "61444" 		ExtendedKey="yes" />
	<Key name = "F18"				VirtKey="129"	migratedKey = "61445" 		ExtendedKey="yes" />
	<Key name = "F19"				VirtKey="130"	migratedKey = "61446" 		ExtendedKey="yes" />
	<Key name = "F20"				VirtKey="131"	migratedKey = "61447" 		ExtendedKey="yes" />
	<Key name = "F21"				VirtKey="132"	migratedKey = "61448" 		ExtendedKey="yes" />
	<Key name = "F22"				VirtKey="133"	migratedKey = "61449" 		ExtendedKey="yes" />
	<Key name = "F23"				VirtKey="134"	migratedKey = "61450" 		ExtendedKey="yes" />
	<Key name = "F24"				VirtKey="135"	migratedKey = "61451" 		ExtendedKey="yes" />

	<Key name = "HpF1"				VirtKey="112"	migratedKey = "112" />
	<Key name = "HpF2"				VirtKey="113"	migratedKey = "113" />
	<Key name = "HpF3"				VirtKey="114"	migratedKey = "114" />
	<Key name = "HpF4"				VirtKey="115"	migratedKey = "115" />
	<Key name = "HpF5"				VirtKey="116"	migratedKey = "116" />
	<Key name = "HpF6"				VirtKey="117"	migratedKey = "117" />
	<Key name = "HpF7"				VirtKey="118"	migratedKey = "118" />
	<Key name = "HpF8"				VirtKey="119"	migratedKey = "119" />
	<Key name = "HpF9"				VirtKey="120"	migratedKey = "120" />
	<Key name = "HpF10"				VirtKey="121"	migratedKey = "121" />
	<Key name = "HpF11"				VirtKey="122"	migratedKey = "122" />
	<Key name = "HpF12"				VirtKey="123"	migratedKey = "123" />

	<Key name = "NumLock"			VirtKey="144"	migratedKey = "144" />
	<Key name = "PF2"				VirtKey="144"	migratedKey = "144" />
	<Key name = "ScrollLock"		VirtKey="145"	migratedKey = "145" />
	<Key name = "PF3"				VirtKey="145"	migratedKey = "145" />
	<Key name = "Compose"			VirtKey="146"	migratedKey = "65312" 		ExtendedKey="yes" />
	<Key name = "Ins" 			    VirtKey="45"	migratedKey = "155" />
	<Key name = "Insert"			VirtKey="45"	migratedKey = "155" />
	<Key name = "Semicolon"			VirtKey="186"	migratedKey = "186" />
	<Key name = "Equals"			VirtKey="187"	migratedKey = "187" />
	<Key name = "Comma"				VirtKey="188"	migratedKey = "44" />
	<Key name = "Dash"				VirtKey="189"	migratedKey = "189" />
	<Key name = "Period"			VirtKey="190"	migratedKey = "46" />
	<Key name = "Slash"				VirtKey="191"	migratedKey = "47" />
	<Key name = "Grave"				VirtKey="192"	migratedKey = "192" />
	<Key name = "OpenBracket"		VirtKey="219"	migratedKey = "219" 		ExtendedKey="yes" />
	<Key name = "BackSlash"			VirtKey="220"	migratedKey = "92" />
	<Key name = "CloseBracket"		VirtKey="221"	migratedKey = "221" 		ExtendedKey="yes" />
	<Key name = "Apostrophe"		VirtKey="222"	migratedKey = "222" 		ExtendedKey="yes" />

	<Key name = "KpEnter" 			VirtKey="1293"	migratedKey = "10" 			ExtendedKey="yes" />
	<Key name = "CpPgUp"  			VirtKey="1313"	migratedKey = "33" 			ExtendedKey="yes" />
	<Key name = "CpPgDn"  			VirtKey="1314"	migratedKey = "34" 			ExtendedKey="yes" />
	<Key name = "CpEnd"	 			VirtKey="1315"	migratedKey = "35" 			ExtendedKey="yes" />
	<Key name = "CpHome"  			VirtKey="1316"	migratedKey = "36" 			ExtendedKey="yes" />
	<Key name = "CpLeft"  			VirtKey="1317"	migratedKey = "37" 			ExtendedKey="yes" />
	<Key name = "CpUp"	 			VirtKey="1318"	migratedKey = "38" 			ExtendedKey="yes" />
	<Key name = "CpRight" 			VirtKey="1319"	migratedKey = "39" 			ExtendedKey="yes" />
	<Key name = "CpDown"  			VirtKey="1320"	migratedKey = "40" 			ExtendedKey="yes" />
	<Key name = "CpIns"				VirtKey="1325"	migratedKey = "155" 		ExtendedKey="yes" />
	<Key name = "CpDel"				VirtKey="1326"	migratedKey = "127" 		ExtendedKey="yes" />
	<Key name = "ScrollLeft"		VirtKey="0"		migratedKey = "37" 			ExtendedKey="yes" />
	<Key name = "ScrollRight"		VirtKey="0"		migratedKey = "39" 			ExtendedKey="yes" />
</xsl:variable>



<!-- global variables  -->

<xsl:variable name = "properties" 		select = "/REFLECTION_SETTINGS/PROPERTIES"/>
<xsl:variable name = "root" 			select = "REFLECTION_SETTINGS"/>
<xsl:variable name = "hpFunctionKeys" 	select = "/REFLECTION_SETTINGS/FUNCTION_KEYS/HP_USER_FUNCTION_KEYS"/>
<xsl:variable name = "modifierTable" 	select = "$ModifierTable"/>
<xsl:variable name = "keycodeTable" 	select = "$PCkeycodeTable"/>
<xsl:variable name = "window"			select = "/REFLECTION_SETTINGS/WINDOW"/>


<xsl:variable name = "XMLversion">
	<xsl:value-of select = "/REFLECTION_SETTINGS/@version"/>
</xsl:variable>

<xsl:variable name = "emulator">
	<xsl:value-of select = "/REFLECTION_SETTINGS/CREATOR/@type"/>
</xsl:variable>
					  
<xsl:variable name = "subtype">
	<xsl:value-of select = "/REFLECTION_SETTINGS/CREATOR/@emulation"/>
</xsl:variable>

<xsl:variable name = "language">
	<xsl:value-of select = "/REFLECTION_SETTINGS/CREATOR/@language"/>
</xsl:variable>





<xsl:template match="/">
	<xsl:variable name = "validSourceXML">
		<xsl:call-template name = "isSourceXMLValid"/>
	</xsl:variable>

	<xsl:choose>
		<xsl:when test = "string($validSourceXML) = 'true'">
		   	<xsl:call-template name = "createImportSetttingsFile"/>
		</xsl:when>
 		<xsl:otherwise>
			<xsl:call-template name = "reportBadSourceXML"/>
	  	</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "createImportSetttingsFile">
	<xsl:call-template name = "CreatedByComment"/>
	<xsl:element name = "REFLECTION_SETTINGS_IMPORT">
		<xsl:attribute name = "version">
			<xsl:value-of select="$ImportFormatVersion"/>
		</xsl:attribute>
		<xsl:call-template name = "creator"/>
		<xsl:call-template name = "PropertySettings"/>
		<xsl:call-template name = "ConnectionSettings"/>
		<xsl:call-template name = "ColorSettings"/>
		<xsl:call-template name = "HPFunctionKeys"/>
		<xsl:call-template name = "Keymappings"/>
		<xsl:call-template name = "mousemappings"/>
		<xsl:call-template name = "hotspots"/>
		<xsl:call-template name = "events"/>
		<xsl:call-template name = "menus"/>
		<xsl:call-template name = "toolbars"/>
		<xsl:call-template name = "tabstops"/>
		<xsl:call-template name = "windowsize"/>
		<xsl:call-template name = "lineBreak"/>
	</xsl:element>
</xsl:template>


<xsl:template name = "creator" >
	<xsl:apply-templates select="/REFLECTION_SETTINGS/CREATOR"/>
</xsl:template>	  


<xsl:template match = "CREATOR" >
	<xsl:call-template name = "lineBreakOneTab"/>
	<xsl:copy>
		<xsl:copy-of select="@*"/>
		<xsl:attribute name = "prod">rwin</xsl:attribute>
	</xsl:copy>
 </xsl:template>



<xsl:template name = "PropertySettings" >
	<xsl:if test = "count(/REFLECTION_SETTINGS/PROPERTIES/PROPERTY) &gt; 0">
		<xsl:call-template name = "lineBreakOneTab"/>
		<xsl:element name = "PROPERTIES">
			<xsl:apply-templates select="/REFLECTION_SETTINGS/PROPERTIES"/>
			<xsl:call-template name = "lineBreakOneTab"/>
		</xsl:element>
	</xsl:if>
</xsl:template>


<xsl:template name = "propertyType">
	<xsl:choose>
		<xsl:when test = "./ENUMERATION">Enum</xsl:when>
		<xsl:when test = "./INTEGER">Integer</xsl:when>
		<xsl:when test = "./BOOLEAN">Boolean</xsl:when>
		<xsl:when test = "./STRING">String</xsl:when>
		<xsl:when test = "./FILE">String</xsl:when>
		<xsl:when test = "./FOLDER">String</xsl:when>
		<xsl:when test = "./CHARACTER">
			<xsl:choose>
				<xsl:when test = "./CHARACTER/@ctrl">CharNum</xsl:when>
				<xsl:otherwise>Char</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>Unkown</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name = "propertyValue">
	<xsl:param name = "type" select = "property"/>
	<xsl:choose>
		<xsl:when test = "./ENUMERATION">
			<xsl:choose>
				<xsl:when test = "$type = 'property'">
					<xsl:value-of select = "./ENUMERATION/@value"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select = "./ENUMERATION"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:when test = "./INTEGER">
			<xsl:value-of select = "./INTEGER"/>
		</xsl:when>
		<xsl:when test = "./BOOLEAN">
			<xsl:value-of select = "./BOOLEAN"/>
		</xsl:when>
		<xsl:when test = "./STRING">
			<xsl:call-template name = "encodeString">
				<xsl:with-param name = "string" select = "./STRING"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test = "./FILE">
			<xsl:value-of select = "./FILE"/>
		</xsl:when>
		<xsl:when test = "./FOLDER">
			<xsl:value-of select = "./FOLDER"/>
		</xsl:when>
		<xsl:when test = "./CHARACTER">
			<xsl:variable name = "char" select = "./CHARACTER"/>
			<xsl:choose>
				<xsl:when test = "contains($char, '#')">
					<xsl:value-of select = "substring-after($char, '#')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select = "$char"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise></xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template match = "PROPERTY" >
	<xsl:call-template name = "lineBreakTwoTabs"/>
	<xsl:element name = "PROPERTY">
		<xsl:attribute name = "name">
			<xsl:value-of select="@name"/>
		</xsl:attribute>
		<xsl:attribute name = "type">
			<xsl:call-template name="propertyType"/>
		</xsl:attribute>
		<xsl:call-template name="propertyValue">
			<xsl:with-param name = "type">property</xsl:with-param>
			</xsl:call-template>
	</xsl:element>
 </xsl:template>


<xsl:template name = "ConnectionSettings" >
	<xsl:if test = "(count(/REFLECTION_SETTINGS/CONNECTION/CONNECTION_SETTING) &gt; 0) or
					(count(/REFLECTION_SETTINGS/CONNECTION/CONNECTION_TYPE)    &gt; 0)">
		<xsl:call-template name = "lineBreakOneTab"/>
		<xsl:element name = "CONNECTION">
			<xsl:apply-templates select="/REFLECTION_SETTINGS/CONNECTION"/>
			<xsl:call-template name = "lineBreakOneTab"/>
		</xsl:element>
	</xsl:if>
</xsl:template>


<xsl:template match = "CONNECTION_SETTING" >
	<xsl:call-template name = "lineBreakTwoTabs"/>
	<xsl:element name = "CONNECTION_SETTING">
		<xsl:attribute name = "name">
			<xsl:value-of select="@name"/>
		</xsl:attribute>
		<xsl:attribute name = "type">
			<xsl:call-template name="propertyType"/>
		</xsl:attribute>
		<xsl:call-template name="propertyValue">
			<xsl:with-param name = "type" select = "connection"/>
		</xsl:call-template>
	</xsl:element>
 </xsl:template>

<xsl:template match = "CONNECTION_TYPE" >
	<xsl:call-template name = "lineBreakTwoTabs"/>
	<xsl:element name = "CONNECTION_SETTING">
		<xsl:attribute name = "name">ConnectionType</xsl:attribute>
		<xsl:attribute name = "type">String</xsl:attribute>
		<xsl:value-of select = "."/>
	</xsl:element>
 </xsl:template>


<xsl:template name = "HPFunctionKeys" >
	<xsl:call-template name = "lineBreakOneTab"/>
	<xsl:if test = "$hpFunctionKeys">
		<xsl:element name = "HPFUNCTION_KEYS">
			<xsl:apply-templates select="$hpFunctionKeys"/>
			<xsl:call-template name = "lineBreakOneTab"/>
		</xsl:element>
	</xsl:if>
</xsl:template>

					   
<xsl:template match = "HP_USER_KEY" >
	<xsl:call-template name = "lineBreakTwoTabs"/>
	<xsl:element name = "KEY">
		<xsl:attribute name = "number">
			<xsl:value-of select="@keynumber"/>
		</xsl:attribute>
		<xsl:attribute name = "type">
			<xsl:call-template name="HPfkeyType"/>
		</xsl:attribute>
		<xsl:attribute name = "label">
			<xsl:value-of select="./LABEL"/>
		</xsl:attribute>
		<xsl:call-template name = "keyDefinition"/>
	</xsl:element>
</xsl:template>


<xsl:template name = "keyDefinition">
	<xsl:variable name = "def" select = "./DEFINITION"/>

	<xsl:call-template name = "decodeEntities">
		<xsl:with-param name = "string" select = "$def"/>
	</xsl:call-template>
</xsl:template>


<xsl:template name = "decodeEntities">
	<xsl:param name = "string"/>

	<xsl:choose>
		<xsl:when test = "contains(translate($string,'0123456789','9999999999'), '#999;')">
			<xsl:variable name = "pre" select = "substring-before($string,'#')"/>
			<xsl:variable name = "digits" 
				select = "substring-before(substring-after($string,'#'),';')"/>
			<xsl:variable name = "remainder" 
				select = "substring-after(substring-after($string,'#'),';')"/>

			<xsl:choose>
				<xsl:when test = "contains(translate($digits,'0123456789','9999999999'), '999')">
					<xsl:value-of disable-output-escaping = "yes"
						select = "concat($pre,'&amp;#',$digits,';')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of disable-output-escaping = "yes"
						select = "concat(substring-before($string,';'),';')"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test = "string($remainder) and string-length($remainder) &gt; 0">
				<xsl:call-template name = "decodeEntities">
					<xsl:with-param name = "string" select = "$remainder"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select = "$string"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "HPfkeyType">
	<xsl:choose>
		<xsl:when test = "./FKEY_ATTRIBUTE = 'NORMAL'">0</xsl:when>
		<xsl:when test = "./FKEY_ATTRIBUTE = 'LOCAL'">1</xsl:when>
		<xsl:when test = "./FKEY_ATTRIBUTE = 'TRANSMIT'">2</xsl:when>
		<xsl:when test = "./FKEY_ATTRIBUTE = 'RCL COMMAND'">3</xsl:when>
		<xsl:otherwise>5</xsl:otherwise>
	</xsl:choose>
</xsl:template>




<xsl:template name = "encodeString">
	<xsl:param name = "string"/>
	<xsl:choose>
		<xsl:when test = "contains(translate($string,'0123456789','9999999999'), '#999;')">
			<xsl:variable name = "encoding">
				<xsl:call-template name = "decodeEntities">
					<xsl:with-param name = "string" select = "$string"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:value-of disable-output-escaping="yes" 
				select = "concat('&lt;![CDATA[',$encoding,']]>')"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select = "$string"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>



<xsl:template name = "ColorSettings" >
	<xsl:if test = "count(/REFLECTION_SETTINGS/COLORS/COLOR_ATTRIBUTES) &gt; 0">
		<xsl:call-template name = "lineBreakOneTab"/>
		<xsl:element name = "COLORS">
			<xsl:call-template name = "lineBreakTwoTabs"/>
			<xsl:element name = "COLOR_PALETTE">
				<xsl:apply-templates select="/REFLECTION_SETTINGS/COLORS/COLOR_PALETTE"/>
				<xsl:call-template name = "lineBreakTwoTabs"/>
			</xsl:element>
			<xsl:call-template name = "lineBreakTwoTabs"/>
			<xsl:element name = "COLOR_ATTRIBUTES">
				<xsl:apply-templates select="/REFLECTION_SETTINGS/COLORS/COLOR_ATTRIBUTES"/>
				<xsl:call-template name = "lineBreakTwoTabs"/>
			</xsl:element>
			<xsl:call-template name = "lineBreakOneTab"/>
		</xsl:element>
	</xsl:if>
</xsl:template>



<xsl:template match = "COLOR" >
	<xsl:call-template name = "lineBreakThreeTabs"/>
	<xsl:element name = "COLOR">
		<xsl:attribute name = "index">
			<xsl:value-of select="@index"/>
		</xsl:attribute>
		<xsl:attribute name = "value">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:element>
 </xsl:template>

<xsl:template match = "COLOR_ATTRIBUTE" >
	<xsl:variable name = "colorAttributeIndex">
			<xsl:value-of select="count(preceding::COLOR_ATTRIBUTE)"/>
	</xsl:variable>

	<xsl:call-template name = "lineBreakThreeTabs"/>
	<xsl:element name = "COLOR_ATTRIBUTE">
		<xsl:attribute name = "name">
			<xsl:value-of select="@name"/>
		</xsl:attribute>
		<xsl:attribute name = "attributeIndex">
			<xsl:value-of select="$colorAttributeIndex"/>
		</xsl:attribute>

		<xsl:attribute name = "foreground">
			<xsl:choose>
				<xsl:when test = "FOREGROUND/COLOR/@index">
					<xsl:value-of select="./FOREGROUND/COLOR/@index"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./FOREGROUND/COLOR"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>

		<xsl:attribute name = "background">
			<xsl:choose>
				<xsl:when test = "BACKGROUND/COLOR/@index">
					<xsl:value-of select="./BACKGROUND/COLOR/@index"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./BACKGROUND/COLOR"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>

	</xsl:element>
 </xsl:template>




<xsl:template name = "Keymappings" >
	<xsl:if test = "count(/REFLECTION_SETTINGS/KEYMAP/KEY_MAPPING) &gt; 0">
		<xsl:call-template name = "lineBreakOneTab"/>
		<xsl:element name = "KEYMAP">
			<xsl:apply-templates select="/REFLECTION_SETTINGS/KEYMAP/KEY_MAPPING"/>
			<xsl:call-template name = "lineBreakOneTab"/>
		</xsl:element>
	</xsl:if>
</xsl:template>


<xsl:template match = "KEY_MAPPING">
	<xsl:variable name = "this" select = "."/>
	<xsl:variable name = "ModifierEntry" select = "$modifierTable/Key[@name = $this/MODIFIERS]"/>
	<xsl:variable name = "KeycodeEntry" select = "$keycodeTable/Key[@name = $this/KEY]"/>
	<xsl:variable name = "vkey" select = "VKEY"/>
	<xsl:variable name = "mods" select = "MODS"/>
	
	<xsl:variable name = "migratedModifier">
		<xsl:choose>
			<xsl:when test = "string($mods)">
				<xsl:value-of select = "$mods"/>
			</xsl:when>
			<xsl:when test = "$ModifierEntry/@migratedModifier">
				 <xsl:value-of select = "$ModifierEntry/@migratedModifier"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name = "VirtualKey">
		<xsl:choose>
			<xsl:when test = "$vkey">
				 <xsl:value-of select = "$vkey"/>
			</xsl:when>
			<xsl:when test = "$KeycodeEntry/@VirtKey">
				 <xsl:value-of select = "$KeycodeEntry/@VirtKey"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:call-template name = "lineBreakTwoTabs"/>
	<xsl:element name = "KEYMAPPING">

		<xsl:attribute name = "key">
			<xsl:value-of select="./KEY"/>
		</xsl:attribute>

		<xsl:attribute name = "virt">
			<xsl:value-of select="$VirtualKey"/>
		</xsl:attribute>

		<xsl:attribute name = "mods">
			<xsl:value-of select="$migratedModifier"/>
		</xsl:attribute>

		<xsl:attribute name = "type">
			<xsl:call-template name = "mappingType">
				<xsl:with-param name = "node" select = "."/>
			</xsl:call-template>
		</xsl:attribute>

		<xsl:attribute name = "action">
			<xsl:value-of select="normalize-space(./COMMAND_TYPE)"/>
		</xsl:attribute>

		<xsl:value-of select="./MAPPING"/>

	</xsl:element>
</xsl:template>





<xsl:template name = "mappingType" >
	<xsl:param name = "node"/>
	<xsl:variable name = "cmdType" select="$node/COMMAND_TYPE"/>

	<xsl:choose>
		<xsl:when test = "($cmdType = 'Terminal Command') or 
						  ($cmdType = 'Menu Command')">3</xsl:when>
		<xsl:when test = "($cmdType = 'Transmit Text')">6</xsl:when>
		<xsl:when test = "($cmdType = 'VB Macro')">7</xsl:when>
		<xsl:when test = "($cmdType = 'VB Command')">8</xsl:when>
		<xsl:when test = "($cmdType = 'RCL Command')">5</xsl:when>
		<xsl:when test = "($cmdType = 'RCL Script')">4</xsl:when>
		<xsl:when test = "($cmdType = 'RB Script')">1</xsl:when>
		<xsl:when test = "($cmdType = 'RB Command')">2</xsl:when>
		<xsl:when test = "($cmdType = 'Mixed Macro')">10</xsl:when>
		<xsl:when test = "($cmdType = 'Complex Macro')">10</xsl:when>

		<xsl:otherwise>3</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "mousemappings" >
	<xsl:if test = "count(/REFLECTION_SETTINGS/MOUSEMAP/MOUSE_MAPPING) &gt; 0">
		<xsl:call-template name = "lineBreakOneTab"/>
		<xsl:element name = "MOUSEMAP">
			<xsl:apply-templates select="/REFLECTION_SETTINGS/MOUSEMAP/MOUSE_MAPPING"/>
			<xsl:call-template name = "lineBreakOneTab"/>
		</xsl:element>
	</xsl:if>
</xsl:template>


<xsl:template match = "MOUSE_MAPPING">
	<xsl:variable name = "this" select = "."/>
	<xsl:variable name = "modifierElement" select = "$this/MODIFIERS"/>
	<xsl:variable name = "modifiers">
		<xsl:choose>
			<xsl:when test = "string($modifierElement)">
				<xsl:choose>
					<xsl:when test = "$modifierElement = 'Double Click'">None</xsl:when>
					<xsl:when test = "contains($modifierElement, '+Double Click')">
						<xsl:value-of select = "substring-before($modifierElement,'+Double Click')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select = "$modifierElement"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>None</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = "ModifierEntry" select = "$modifierTable/Key[@name = $modifiers]"/>
	<xsl:variable name = "migratedModifier">
		<xsl:choose>
			<xsl:when test = "$ModifierEntry/@migratedModifier">
				 <xsl:value-of select = "$ModifierEntry/@migratedModifier"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = "doubleclick">
		<xsl:choose>
			<xsl:when test = "contains($this/MOUSECHORD, 'Double Click')">yes</xsl:when>
			<xsl:otherwise>no</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = "whenreleased">
		<xsl:choose>
			<xsl:when test = "contains($this/MOUSECHORD, 'when released')">yes</xsl:when>
			<xsl:otherwise>no</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = "button">
		<xsl:choose>
			<xsl:when test = "contains($this/MOUSECHORD, '1')">0</xsl:when>
			<xsl:when test = "contains($this/MOUSECHORD, 'Middle')">1</xsl:when>
			<xsl:when test = "contains($this/MOUSECHORD, '2')">2</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = "type">
		<xsl:call-template name = "mappingType">
			<xsl:with-param name = "node" select = "."/>
		</xsl:call-template>
	</xsl:variable>

	<xsl:call-template name = "lineBreakTwoTabs"/>
	<xsl:element name = "MOUSEMAPPING">

		<xsl:attribute name = "mods">
			<xsl:value-of select="$migratedModifier"/>
		</xsl:attribute>

		<xsl:attribute name = "btn">
			<xsl:value-of select="$button"/>
		</xsl:attribute>

		<xsl:attribute name = "dblclick">
			<xsl:value-of select="$doubleclick"/>
		</xsl:attribute>

		<xsl:attribute name = "whenreleased">
			<xsl:value-of select="$whenreleased"/>
		</xsl:attribute>

		<xsl:attribute name = "type">
			<xsl:value-of select="$type"/>
		</xsl:attribute>

		<xsl:value-of select="normalize-space(./MAPPING)"/>

	</xsl:element>
</xsl:template>


<xsl:template name = "events" >
	<xsl:if test = "count(/REFLECTION_SETTINGS/EVENTS/EVENT) &gt; 0">
		<xsl:call-template name = "lineBreakOneTab"/>
		<xsl:element name = "EVENTS">
			<xsl:apply-templates select="/REFLECTION_SETTINGS/EVENTS/EVENT"/>
			<xsl:call-template name = "lineBreakOneTab"/>
		</xsl:element>
	</xsl:if>
</xsl:template>


<xsl:template match = "EVENT">
	<xsl:variable name = "type">
		<xsl:call-template name = "mappingType">
			<xsl:with-param name = "node" select = "."/>
		</xsl:call-template>
	</xsl:variable>

	<xsl:call-template name = "lineBreakTwoTabs"/>
	<xsl:element name = "EVENT">
		<xsl:attribute name = "number">
			<xsl:value-of select="@number"/>
		</xsl:attribute>
		<xsl:attribute name = "enabled">
			<xsl:value-of select="translate(EVENT_ENABLED,'YN','yn')"/>
		</xsl:attribute>
		<xsl:attribute name = "default">
			<xsl:value-of select="translate(DEFAULT_EVENT,'YN','yn')"/>
		</xsl:attribute>
		<xsl:attribute name = "typeindex">
			<xsl:value-of select="EVENT_TYPE_INDEX"/>
		</xsl:attribute>
		<xsl:attribute name = "time">
			<xsl:value-of select="EVENT_TIME"/>
		</xsl:attribute>
		<xsl:attribute name = "duration">
			<xsl:value-of select="EVENT_DURATION"/>
		</xsl:attribute>
		<xsl:attribute name = "row">
			<xsl:value-of select="EVENT_ROW"/>
		</xsl:attribute>
		<xsl:attribute name = "column">
			<xsl:value-of select="EVENT_COLUMN"/>
		</xsl:attribute>
		<xsl:attribute name = "key">
			<xsl:value-of select="EVENT_TERMINAL_KEY"/>
		</xsl:attribute>
		<xsl:attribute name = "after">
			<xsl:value-of select="EVENT_AFTER"/>
		</xsl:attribute>
		<xsl:attribute name = "string">
			<xsl:value-of select="EVENT_STRING"/>
		</xsl:attribute>
		<xsl:attribute name = "type">
			<xsl:value-of select="$type"/>
		</xsl:attribute>
		<xsl:attribute name = "notranslation">
			<xsl:value-of select="translate(EVENT_NOTRANSLATION,'YN','yn')"/>
		</xsl:attribute>
		<xsl:value-of select = "normalize-space(ACTION)"/>
	</xsl:element>
</xsl:template>
											

<xsl:template name = "menus" >
	<xsl:if test = "count(/REFLECTION_SETTINGS/MENUS/MAIN_MENU) &gt; 0 or
					count(/REFLECTION_SETTINGS/MENUS/CONTEXT_MENU) &gt; 0">
		<xsl:call-template name = "lineBreakOneTab"/>
		<xsl:element name = "MENUS">
			<xsl:apply-templates select="/REFLECTION_SETTINGS/MENUS/MAIN_MENU"/>
			<xsl:apply-templates select="/REFLECTION_SETTINGS/MENUS/CONTEXT_MENU"/>
			<xsl:call-template name = "lineBreakOneTab"/>
		</xsl:element>
	</xsl:if>
</xsl:template>


<xsl:template match = "MAIN_MENU | CONTEXT_MENU">
	<xsl:variable name = "default">
		<xsl:choose>
			<xsl:when test = "count(DEFAULTS) &gt; 0">yes</xsl:when>
			<xsl:otherwise>no</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = "count">
		<xsl:choose>
			<xsl:when test = "count(COUNT) &gt; 0">
				<xsl:value-of select = "COUNT"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = "menuname">
			<xsl:value-of select="local-name()"/>
	</xsl:variable>

	<xsl:call-template name = "lineBreakTwoTabs"/>
	<xsl:element name = "MENU">
		<xsl:attribute name = "name">
			<xsl:value-of select = "$menuname"/>
		</xsl:attribute>
		<xsl:attribute name = "default">
			<xsl:value-of select="$default"/>
		</xsl:attribute>
		<xsl:attribute name = "count">
			<xsl:value-of select="$count"/>
		</xsl:attribute>

		<xsl:choose>
			<xsl:when test = "$menuname = 'MAIN_MENU'">
				<xsl:call-template name = "menuitems">
					<xsl:with-param name = "list" select="/REFLECTION_SETTINGS/MENUS/MAIN_MENU/*"/>
					<xsl:with-param name = "tabcount">3</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test = "$menuname = 'CONTEXT_MENU'">
				<xsl:call-template name = "menuitems">
					<xsl:with-param name = "list" select="/REFLECTION_SETTINGS/MENUS/CONTEXT_MENU/*"/>
					<xsl:with-param name = "tabcount">3</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>

		<xsl:call-template name = "lineBreakTwoTabs"/>
	</xsl:element>
</xsl:template>




<xsl:template name = "menuitems" >
	<xsl:param name = "list"/>
	<xsl:param name = "tabcount"/>

	<xsl:if test = "count($list) &gt; 0">
		<xsl:variable name = "first" select = "$list[1]"/>
		<xsl:variable name = "element" select = "local-name($first)"/>
		<xsl:choose>
			<xsl:when test = "$element = 'ITEM'">
				<xsl:call-template name = "lineBreak"/>
				<xsl:call-template name = "tabs">
					<xsl:with-param name = "tabcount" select = "$tabcount"/>
				</xsl:call-template>
				<xsl:element name = "ITEM">
					<xsl:attribute name = "name">
						<xsl:value-of select="$first/@menu_item"/>
					</xsl:attribute>
					<xsl:attribute name = "position">
						<xsl:value-of select="$first/@position"/>
					</xsl:attribute>
					<xsl:attribute name = "accel">
						<xsl:value-of select="$first/ACCELERATOR"/>
					</xsl:attribute>
					<xsl:choose>
						<xsl:when test = "count($first/KEYCODE) &gt; 0">
							<xsl:attribute name = "keycode">
								<xsl:value-of select="$first/KEYCODE"/>
							</xsl:attribute>
							<xsl:attribute name = "help">
								<xsl:value-of select="$first/HELP"/>
							</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name = "type">
								<xsl:call-template name = "mappingType">
									<xsl:with-param name = "node" select = "$first"/>
								</xsl:call-template>
							</xsl:attribute>
							<xsl:attribute name = "help">
								<xsl:value-of select="$first/HELP"/>
							</xsl:attribute>
							<xsl:value-of select = "normalize-space($first/ACTION)"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:when>

			<xsl:when test = "$element = 'SEPARATOR'">
				<xsl:call-template name = "lineBreak"/>
				<xsl:call-template name = "tabs">
					<xsl:with-param name = "tabcount" select = "$tabcount"/>
				</xsl:call-template>
				<xsl:element name = "SEPARATOR">
					<xsl:attribute name = "position">
						<xsl:value-of select="$first/@position"/>
					</xsl:attribute>
				</xsl:element>
			</xsl:when>
			<xsl:when test = "$element = 'POPUPEND'">
				<xsl:call-template name = "lineBreak"/>
				<xsl:call-template name = "tabs">
					<xsl:with-param name = "tabcount" select = "$tabcount"/>
				</xsl:call-template>
				<xsl:element name = "POPUPEND">
					<xsl:attribute name = "position">
						<xsl:value-of select="$first/@position"/>
					</xsl:attribute>
				</xsl:element>
			</xsl:when>

			<xsl:when test = "$element = 'POPUP'">
				<xsl:call-template name = "lineBreak"/>
				<xsl:call-template name = "tabs">
					<xsl:with-param name = "tabcount" select = "$tabcount"/>
				</xsl:call-template>

				<xsl:element name = "POPUP">
					<xsl:attribute name = "name">
						<xsl:value-of select="$first/@name"/>
					</xsl:attribute>
					<xsl:attribute name = "position">
						<xsl:value-of select="$first/@position"/>
					</xsl:attribute>
					<xsl:attribute name = "accel">
						<xsl:value-of select="$first/ACCELERATOR"/>
					</xsl:attribute>
					<xsl:attribute name = "help">
						<xsl:value-of select="$first/HELP"/>
					</xsl:attribute>

					<xsl:if test = "count($first/*) &gt; 0">
						<xsl:call-template name = "menuitems">
							<xsl:with-param name = "list" select = "$first/*"/>
							<xsl:with-param name = "tabcount" select = "$tabcount+1"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:call-template name = "lineBreak"/>
					<xsl:call-template name = "tabs">
						<xsl:with-param name = "tabcount" select = "$tabcount"/>
					</xsl:call-template>
				</xsl:element>
			</xsl:when>
		</xsl:choose>

		<xsl:call-template name = "menuitems">
			<xsl:with-param name = "list" select = "$list[position() > 1]"/>
			<xsl:with-param name = "tabcount" select = "$tabcount"/>
		</xsl:call-template>

	</xsl:if>
 </xsl:template>




<xsl:template name = "toolbars" >
	<xsl:if test = "count(/REFLECTION_SETTINGS/TOOLBARS/TOOLBAR) &gt; 0">
		<xsl:call-template name = "lineBreakOneTab"/>
		<xsl:element name = "TOOLBARS">
			<xsl:apply-templates select="/REFLECTION_SETTINGS/TOOLBARS/TOOLBAR"/>
			<xsl:call-template name = "lineBreakOneTab"/>
		</xsl:element>
	</xsl:if>
</xsl:template>


<xsl:template match = "TOOLBAR">
	<xsl:call-template name = "lineBreakTwoTabs"/>
	<xsl:element name = "TOOLBAR">
		<xsl:attribute name = "name">
			<xsl:value-of select="@name"/>
		</xsl:attribute>
		<xsl:attribute name = "visible">
			<xsl:value-of select="translate(VISIBLE,'YN','yn')"/>
		</xsl:attribute>
		<xsl:attribute name = "pos">
			<xsl:value-of select="translate(LOCATION,'TBLRF','tblrf')"/>
		</xsl:attribute>
		<xsl:attribute name = "anchored">
			<xsl:value-of select="translate(ANCHORED,'YN','yn')"/>
		</xsl:attribute>
		<xsl:attribute name = "color">
			<xsl:value-of select="translate(COLOR_BUTTONS,'YN','yn')"/>
		</xsl:attribute>
		<xsl:attribute name = "largebtns">
			<xsl:value-of select="translate(LARGE_BUTTONS,'YN','yn')"/>
		</xsl:attribute>
		<xsl:attribute name = "tips">
			<xsl:value-of select="translate(SHOW_TOOLTIPS,'YN','yn')"/>
		</xsl:attribute>
		<xsl:attribute name = "labels">
			<xsl:value-of select="translate(SHOW_LABELS,'YN','yn')"/>
		</xsl:attribute>
		<xsl:attribute name = "fixed">
			<xsl:value-of select="translate(FIXED_WIDTH_BUTTONS,'YN','yn')"/>
		</xsl:attribute>
		<xsl:attribute name = "left">
			<xsl:value-of select="LEFT"/>
		</xsl:attribute>
		<xsl:attribute name = "top">
			<xsl:value-of select="TOP"/>
		</xsl:attribute>
		<xsl:attribute name = "width">
			<xsl:value-of select="WIDTH"/>
		</xsl:attribute>
		<xsl:attribute name = "height">
			<xsl:value-of select="HEIGHT"/>
		</xsl:attribute>
		<xsl:attribute name = "xbtn">
			<xsl:value-of select="XBTN"/>
		</xsl:attribute>
		<xsl:attribute name = "ybtn">
			<xsl:value-of select="YBTN"/>
		</xsl:attribute>
		<xsl:attribute name = "auto">
			<xsl:value-of select="AUTO"/>
		</xsl:attribute>
		<xsl:attribute name = "btnformat">
			<xsl:value-of select="BTN_FORMAT"/>
		</xsl:attribute>
		<xsl:apply-templates select = "BUTTONS/BUTTON"/>
		<xsl:call-template name = "lineBreakTwoTabs"/>
	</xsl:element>

</xsl:template>



<xsl:template match = "BUTTON">
	<xsl:variable name = "type">
		<xsl:call-template name = "mappingType">
			<xsl:with-param name = "node" select = "."/>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name = "picture">
		<xsl:value-of select = "PICTURE"/>
	</xsl:variable>
	<xsl:variable name = "sm_index">
			<xsl:value-of select = "BUTTON_SM_PIC_INDEX"/>
	</xsl:variable>
	<xsl:variable name = "lg_index">
			<xsl:value-of select = "BUTTON_LG_PIC_INDEX"/>
	</xsl:variable>
	<xsl:variable name = "sm_pic_index">
		<xsl:choose>
			<xsl:when test = "string($sm_index)">
				<xsl:value-of select = "$sm_index"/>
			</xsl:when>
			<xsl:when test = "BUTTON_SM_PIC_INDEX/@constvalue">
				<xsl:value-of select = "concat('-', BUTTON_SM_PIC_INDEX/@constvalue)"/>
			</xsl:when>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = "lg_pic_index">
		<xsl:choose>
			<xsl:when test = "string($lg_index)">
				<xsl:value-of select = "$lg_index"/>
			</xsl:when>
			<xsl:when test = "BUTTON_LG_PIC_INDEX/@constvalue">
				<xsl:value-of select = "concat('-', BUTTON_LG_PIC_INDEX/@constvalue)"/>
			</xsl:when>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = "sm_pic_file">
		<xsl:value-of select = "BUTTON_SM_PIC_FILE"/>
	</xsl:variable>
	<xsl:variable name = "lg_pic_file">
		<xsl:value-of select = "BUTTON_LG_PIC_FILE"/>
	</xsl:variable>

	<xsl:call-template name = "lineBreakThreeTabs"/>
	<xsl:element name = "BUTTON">
			<xsl:attribute name = "number">
				<xsl:value-of select="@number"/>
			</xsl:attribute>
			<xsl:attribute name = "btnflags">
				<xsl:value-of select="BTNFLAGS"/>
			</xsl:attribute>
			<xsl:choose>
				<xsl:when test = "string($picture)">
					<xsl:attribute name = "picture">
						<xsl:value-of select="$picture"/>
					</xsl:attribute>
				</xsl:when>
				<xsl:when test = "string($sm_pic_index) and string($lg_pic_index)">
					<xsl:attribute name = "smpicindex">
						<xsl:value-of select="$sm_pic_index"/>
					</xsl:attribute>
					<xsl:attribute name = "lgpicindex">
						<xsl:value-of select="$lg_pic_index"/>
					</xsl:attribute>
				</xsl:when>
				<xsl:when test = "string($sm_pic_file) and string($lg_pic_file)">
					<xsl:attribute name = "smpicfile">
						<xsl:value-of select="$sm_pic_file"/>
					</xsl:attribute>
					<xsl:attribute name = "lgpicfile">
						<xsl:value-of select="$lg_pic_file"/>
					</xsl:attribute>
				</xsl:when>
			</xsl:choose>
			<xsl:attribute name = "type">
				<xsl:value-of select="$type"/>
			</xsl:attribute>
			<xsl:attribute name = "label">
				<xsl:value-of select="BUTTON_LABEL"/>
			</xsl:attribute>
			<xsl:attribute name = "tip">
				<xsl:value-of select="BUTTON_TOOLTIP"/>
			</xsl:attribute>
			<xsl:attribute name = "help">
				<xsl:value-of select="BUTTON_HELP"/>
			</xsl:attribute>
			<xsl:value-of select = "normalize-space(ACTION)"/>
	</xsl:element>
</xsl:template>




<xsl:template name = "hotspots" >
	<xsl:if test = "count(/REFLECTION_SETTINGS/HOTSPOTS/HOTSPOT) &gt; 0">
		<xsl:call-template name = "lineBreakOneTab"/>
		<xsl:element name = "HOTSPOTS">
			<xsl:apply-templates select="/REFLECTION_SETTINGS/HOTSPOTS/HOTSPOT_SETTINGS"/>
			<xsl:apply-templates select="/REFLECTION_SETTINGS/HOTSPOTS/HOTSPOT"/>
			<xsl:call-template name = "lineBreakOneTab"/>
		</xsl:element>
	</xsl:if>
</xsl:template>



<xsl:template match = "HOTSPOT_SETTINGS">
	<xsl:variable name = "button">
		<xsl:choose>
			<xsl:when test = "contains(./MOUSECHORD, '1')">0</xsl:when>
			<xsl:when test = "contains(./MOUSECHORD, 'Middle')">1</xsl:when>
			<xsl:when test = "contains(./MOUSECHORD, '2')">2</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = "dblclick">
		<xsl:choose>
			<xsl:when test = "contains(./MOUSECHORD, 'Double Click')">3</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = "btn">
		<xsl:value-of select = "$button + $dblclick"/>
	</xsl:variable>
	<xsl:variable name = "alt">
		<xsl:choose>
			<xsl:when test = "contains(./MOUSECHORD, 'Alt')">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = "ctrl">
		<xsl:choose>
			<xsl:when test = "contains(./MOUSECHORD, 'Ctrl')">2</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = "shift">
		<xsl:choose>
			<xsl:when test = "contains(./MOUSECHORD, 'Shift')">4</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name = "mods">
		<xsl:value-of select = "$alt + $ctrl + $shift"/>
	</xsl:variable>


	<xsl:call-template name = "lineBreakTwoTabs"/>
	<xsl:element name = "HOTSPOT_CONFIG">
		<xsl:attribute name = "enabled">
			<xsl:value-of select="translate(./HOTSPOTS_ENABLED, 'YN','yn')"/>
		</xsl:attribute>
		<xsl:attribute name = "visible">
			<xsl:value-of select="translate(./HOTSPOTS_VISIBLE, 'YN','yn')"/>
		</xsl:attribute>
		<xsl:attribute name = "mods">
			<xsl:value-of select="$mods"/>
		</xsl:attribute>
		<xsl:attribute name = "btn">
			<xsl:value-of select="$btn"/>
		</xsl:attribute>
	</xsl:element>
</xsl:template>


<xsl:template match = "HOTSPOT">
	<xsl:variable name = "type">
		<xsl:call-template name = "mappingType">
			<xsl:with-param name = "node" select = "."/>
		</xsl:call-template>
	</xsl:variable>

	<xsl:call-template name = "lineBreakTwoTabs"/>
	<xsl:element name = "HOTSPOT">

		<xsl:attribute name = "default">
			<xsl:value-of select="translate(./DEFAULT_HOTSPOT,'YN','yn')"/>
		</xsl:attribute>

		<xsl:attribute name = "matchcase">
			<xsl:value-of select="translate(./MATCH_CASE,'YN','yn')"/>
		</xsl:attribute>

		<xsl:attribute name = "matchword">
			<xsl:value-of select="translate(./MATCH_WHOLE_WORD,'YN','yn')"/>
		</xsl:attribute>

		<xsl:attribute name = "matchtilspace">
			<xsl:value-of select="translate(./MATCH_TIL_WHITESPACE,'YN','yn')"/>
		</xsl:attribute>

		<xsl:attribute name = "useposition">
			<xsl:value-of select="translate(./USE_POSITION,'YN','yn')"/>
		</xsl:attribute>

		<xsl:attribute name = "row">
			<xsl:value-of select="./ROW"/>
		</xsl:attribute>

		<xsl:attribute name = "column">
			<xsl:value-of select="./COLUMN"/>
		</xsl:attribute>

		<xsl:attribute name = "text">
			<xsl:value-of select="./HOTSPOT_TEXT"/>
		</xsl:attribute>

		<xsl:attribute name = "tip">
			<xsl:value-of select="./HOTSPOT_TOOLTIP"/>
		</xsl:attribute>

		<xsl:attribute name = "help">
			<xsl:value-of select="./HOTSPOT_HELP"/>
		</xsl:attribute>

		<xsl:attribute name = "type">
			<xsl:value-of select="$type"/>
		</xsl:attribute>

		<xsl:value-of select="normalize-space(./ACTION)"/>

	</xsl:element>
</xsl:template>




<xsl:template name = "tabstops" >
	<xsl:variable name = "singletab" 	select = "$root/TABS/TABSTOPS/TAB"/>
	<xsl:variable name = "everyn" 		select = "$root/TABS/TABSTOPS/TABS_EVERY_N"/>
	<xsl:variable name = "tablist" 		select = "$root/TABS/TABSTOPS/TABSTOP_LIST"/>

	<xsl:if test = "string($singletab) or string($everyn) or string($tablist)">
		<xsl:call-template name = "lineBreakOneTab"/>
		<xsl:element name = "TABS">
			<xsl:if test = "string($singletab)">
				<xsl:call-template name = "lineBreakTwoTabs"/>
				 <xsl:element name = "TABSTOP_LIST">
					<xsl:value-of select="$singletab - 1"/>
				</xsl:element>
			</xsl:if>
			<xsl:if test = "string($everyn)">
				<xsl:call-template name = "lineBreakTwoTabs"/>
				 <xsl:element name = "TABSTOP_LIST">
					<xsl:text>every </xsl:text>
					<xsl:value-of select="$everyn"/>
				</xsl:element>
			</xsl:if>
			<xsl:if test = "string($tablist)">
				<xsl:call-template name = "lineBreakTwoTabs"/>
				 <xsl:element name = "TABSTOP_LIST">
<!--
					<xsl:value-of select="$tablist"/>
-->
					<xsl:call-template name = "convertRwinTabList">
						<xsl:with-param name = "list" select = "$tablist"/>
					</xsl:call-template>
				</xsl:element>
			</xsl:if>
			<xsl:call-template name = "lineBreakOneTab"/>
		</xsl:element>
	</xsl:if>
</xsl:template>



<xsl:template name = "convertRwinTabList">
	<xsl:param name = "list"/>

	<xsl:variable name = "firsttab"  select = "substring-before($list, ' ')"/>
	<xsl:variable name = "remainder" select = "substring-after($list, ' ')"/>

	<xsl:choose>
		<xsl:when test = "not($firsttab = 'NAN')">
			<xsl:value-of select = "concat($firsttab - 1, ' ')"/>

			<xsl:if test = "string($remainder)">
				<xsl:call-template name = "convertRwinTabList">
					<xsl:with-param name = "list" select = "$remainder"/>
				</xsl:call-template>
			</xsl:if>		
		</xsl:when>	
	</xsl:choose>
		
</xsl:template>


<xsl:template name = "windowsize" >
	<xsl:if test = "count($window/WINDOW_STATE) &gt; 0">
		<xsl:call-template name = "lineBreakOneTab"/>
		<xsl:element name = "WINDOWSIZE">
			<xsl:attribute name = "state">
				<xsl:value-of select="$window/WINDOW_STATE"/>
			</xsl:attribute>
			<xsl:attribute name = "left">
				<xsl:value-of select="$window/WP_LEFT_X"/>
			</xsl:attribute>
			<xsl:attribute name = "top">
				<xsl:value-of select="$window/WP_LEFT_Y"/>
			</xsl:attribute>
			<xsl:attribute name = "right">
				<xsl:value-of select="$window/WP_RIGHT_X"/>
			</xsl:attribute>
			<xsl:attribute name = "bottom">
				<xsl:value-of select="$window/WP_RIGHT_Y"/>
			</xsl:attribute>
		</xsl:element>
	</xsl:if>
</xsl:template>



<xsl:template name = "CreatedByComment" >
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>

	<xsl:comment>
		<xsl:text>   Reflection Settings</xsl:text>
		<xsl:text> (XML Import format </xsl:text>
		<xsl:value-of select="$transformVersion"/>
		<xsl:text>)</xsl:text>
		<xsl:call-template name = "lineBreak"/>
		<xsl:text>  	   Created from </xsl:text> 
		<xsl:value-of select="/REFLECTION_SETTINGS/CREATOR/@product"/>
	    <xsl:text> - version </xsl:text>
		<xsl:value-of select="/REFLECTION_SETTINGS/CREATOR/@version"/>
		<xsl:text> (build </xsl:text>
  		<xsl:value-of select="/REFLECTION_SETTINGS/CREATOR/@build"/>
		<xsl:text>)</xsl:text>

		<xsl:if test = "string($subtype)">
			<xsl:text> </xsl:text> 
			<xsl:value-of select="$subtype"/>
			<xsl:text> Emulation</xsl:text> 
		</xsl:if>
		<xsl:call-template name = "lineBreak"/>

		<xsl:if test = "string($language)">
			<xsl:text>  	   Language - </xsl:text> 
			<xsl:value-of select="$language"/>
			<xsl:call-template name = "lineBreak"/>
		</xsl:if>

		<xsl:text>       Transform version </xsl:text> 
		<xsl:value-of select="$transformVersion"/>
		<xsl:call-template name = "lineBreak"/>
	</xsl:comment>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>

						  


 

<xsl:template name = "lineBreak">
	<xsl:text>&#10;</xsl:text>
</xsl:template>

<xsl:template name = "lineBreakOneTab">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "lineBreakTwoTabs">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "lineBreakThreeTabs">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "lineBreakFourTabs">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "lineBreakFiveTabs">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "lineBreakSixTabs">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;&#9;&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "lineBreakSevenTabs">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;&#9;&#9;&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "lineBreakEightTabs">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;&#9;&#9;&#9;&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "lineBreakNineTabs">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>&#9;&#9;&#9;&#9;&#9;&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "tab">
	<xsl:text>&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "twoTabs">
	<xsl:text>&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "threeTabs">
	<xsl:text>&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "fourTabs">
	<xsl:text>&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "fiveTabs">
	<xsl:text>&#9;&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "sixTabs">
	<xsl:text>&#9;&#9;&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "sevenTabs">
	<xsl:text>&#9;&#9;&#9;&#9;&#9;&#9;&#9;</xsl:text>	
</xsl:template>

<xsl:template name = "tabs">
	<xsl:param name = "tabcount"/>

	<xsl:if test = "$tabcount &gt; 0">
		<xsl:text>&#9;</xsl:text>	
		<xsl:call-template name = "tabs">
			<xsl:with-param name = "tabcount">
				<xsl:value-of select = "$tabcount - 1"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>


<xsl:template name = "decodeCtrlChar">
	<xsl:param name = "text"/>
	<xsl:choose>
		<xsl:when test = "string-length($text) = 4 and contains($text, '#') and
						 string-length(substring-after($text, '#')) = 3">
			<xsl:value-of select = "concat('&#38;', concat($text, ';'))"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select = "$text"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "translateCtrlChars">
	<xsl:param name = "text"/>
	<xsl:variable name = "startOfDigits">
		<xsl:value-of select = "substring-after($text, '#')"/>
	</xsl:variable>

	<xsl:choose>	
		<xsl:when test = "contains($text, '#') and contains($startOfDigits, ';')">
			<xsl:variable name = "pre">
				<xsl:value-of select = "substring-before($text, '#')"/>
			</xsl:variable>
			<xsl:variable name = "first">
				<xsl:value-of select = 
					"concat('#', substring-after(concat(substring-before($text, ';'), ';'), '#'))"/>
			</xsl:variable>
			<xsl:variable name = "remaining">
				<xsl:value-of select = "substring-after($text, ';')"/>
			</xsl:variable>
			<xsl:variable name = "charCode">
				<xsl:value-of select = "substring-before($startOfDigits, ';')"/>
			</xsl:variable>

			<xsl:choose>
				<xsl:when test = "string-length($charCode) = 3  and not(number($charCode) = Nan)">
					<xsl:variable name = "rest">
						<xsl:call-template name = "translateCtrlChars">
							<xsl:with-param name = "text">
								<xsl:value-of select = "$remaining"/>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:value-of disable-output-escaping = "yes"
						select = "concat(concat($pre, concat('&amp;', $first)), $rest)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select = "$text"/>	
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select = "$text"/>
		</xsl:otherwise>
	</xsl:choose>	
</xsl:template>


<xsl:template name = "isSourceXMLValid">
	<xsl:choose>
		<xsl:when test = "($XMLversion &gt;= 3) 							 	   	and
						  (($emulator = 1)	or ($emulator = 2) or ($emulator = 4)) 	and
						  (name($root) = 'REFLECTION_SETTINGS')	
						  ">true</xsl:when>
	 	<xsl:otherwise></xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "reportBadSourceXML">
	<xsl:call-template name = "lineBreak"/>
	<TransformFailed>
		<xsl:call-template name = "lineBreak"/>
		<xsl:call-template name = "lineBreak"/>
		<Error>Transform Failed</Error>
		<xsl:call-template name = "lineBreak"/>
		<xsl:choose>
			<xsl:when test = "not(name($root) = 'REFLECTION_SETTINGS')">
				<Description>Source XML is not an exported Reflection Settings file.</Description>
			</xsl:when>
			<xsl:when test = "$XMLversion &lt; 3">
				<Description>This transform requires version 3.0 or greater exported Reflection Settings.</Description>
			</xsl:when>
			<xsl:when test = "not(($emulator = 1) or ($emulator = 2) or ($emulator = 4))">
				<Description>This transform requires an exported Reflection Settings file</Description>
				<xsl:call-template name = "lineBreak"/>
				<Description>from Reflection for HP, Unix and Digital, or ReGIS Graphics</Description>
			</xsl:when>
			<xsl:otherwise>
				<Description>Source XML is not an exported Reflection Settings file.</Description>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:call-template name = "lineBreak"/>
		<Description>As created by Reflection 11.0 or later.</Description>
		<xsl:call-template name = "lineBreak"/>
	</TransformFailed>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>



<xsl:template match="text()|@*"/>



</xsl:stylesheet>

